/**
  ******************************************************************************
 *
 * @file        Sample_CSC_XOSC_Init.c
 *
 * @brief       CSC set CK_HS clock from XOSC sample code.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/21
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_CSC_XOSC_Init(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       Sample CSC_XOSC_Init
 * @details     1. XOSC enable
 *      \n      2. Wait XOSC Ready
 *      \n      3. Clear CSC_XOSC Stable And Ready Flag
 *      \n      4. CSC CK_HS Source From CK_XOSC Sslect
 * @return	    None
 * @note        Cannot use the XOSC at the same time.
 * @par         Example
 * @code
    Sample_CSC_XOSC_Init();
 * @endcode
 *******************************************************************************
 */
 
void Sample_CSC_XOSC_Init(void)
{
    /* 1. XOSC enable */
    CSC_XOSC_Cmd(ENABLE);
    
    UnProtectModuleReg(CSCprotect);                     // CSC register R/W protect disable
    /* 2. Wait XOSC Ready */
    while(CSC_GetClockSourceState(CSC_XOSCF) != DRV_Ready);
    
    /* 3. Clear CSC_XOSC Stable And Ready Flag */
    CSC_ClearFlag(CSC_XOSCF);
    
    /* 4. CSC CK_HS Source From CK_XOSC Sslect */
    CSC_CK_HS_Select(HS_CK_XOSC);
    
    /* 5. IHRCO Disable */
    /*
    // When the IHRCO is not in use, the IHRCO can be disable to save power.
    CSC_IHRCO_Cmd(DISABLE); 
    */
    
ProtectModuleReg(CSCprotect);                       // CSC register R/W protect enable
}


