


/**
 ******************************************************************************
 *
 * @file       Sample_APX_SDTRotaryDecoder.c
 * @brief      Use SDT of APX to be rotary decoder.
 *
 * @par        Project
 *             MG32 M0 (no include MG32F02A132/A072/A032/A128/U128/V032)
 * @version    V1.00
 * @date       2024/12/03
 * @author     Megawin Software Center
 * @copyright  Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *             All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_APX_DRV.h"
#include "MG32_GPIO_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static volatile uint32_t SDT_CNT;

/* Private function prototypes -----------------------------------------------*/
void APX_IRQHandler(void);

extern void Sample_SDTRotaryDecoder_Init(void);
extern void APX_IRQHandler_Callback(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	   SDT of APX IRQHandler
 * @details 
 * @return     
 * @exception   
 * @note           
 *******************************************************************************
 */
void APX_IRQHandler(void)
{
    uint32_t APX_IRQHandlerTmp;
    
    APX_IRQHandlerTmp = APX_GetAllFlagStatus(APX);
    
    if( APX_IRQHandlerTmp & APX_SDTF4)
    {
        APX_ClearFlag(APX,APX_SDTF4);
        SDT_CNT--;
    }
    if( APX_IRQHandlerTmp & APX_SDTF5) 
    {
        APX_ClearFlag(APX,APX_SDTF5);
        SDT_CNT++;
    }
    
    APX_IRQHandler_Callback();
    
}


/**
 *******************************************************************************
 * @brief	   SDT of APX initial
 * @details 
 * @return     
 * @exception   
 * @note           
 *******************************************************************************
 */
void Sample_SDTRotaryDecoder_Init(void)
{

    /*SDT_I0 / SDT_I1 pin can using MG32_GPIO_xxx_Init.h to configure or 
      following code to configure.*/
    
//    PIN_InitTypeDef    SDT_PINXInitStruct;
//    
//    GPIO_PortFilterClockSource_Select(IOMA,GPIO_FT_CLK_AHB_DIV8);              // Select filter clock source
//    
//    SDT_PINXInitStruct.PINX_Mode               = PINX_Mode_Digital_I;
//    SDT_PINXInitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
//    SDT_PINXInitStruct.PINX_Speed              = PINX_Speed_Low;
//    SDT_PINXInitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;
//    SDT_PINXInitStruct.PINX_FilterDivider      = PINX_FilterDivider_16;
//    SDT_PINXInitStruct.PINX_Inverse            = PINX_Inverse_Disable;
//    SDT_PINXInitStruct.PINX_Alternate_Function = 6;
//    GPIO_PinMode_Config(PINA(2),&SDT_PINXInitStruct);
//    GPIO_PinMode_Config(PINA(3),&SDT_PINXInitStruct);    
    
    /*SDT mode configure*/
    APX_SDT_Cmd(ENABLE);
    APX_InitState0PROC4(3);             //Set State-0 state for procedure-4
    APX_PROC4LineState_Init(0x0E1);     //SDT_I0 / SDT_I1 S0 ~ S5 state configure for procedure-4
    APX_SetEndOfPROC4(3);               //Set procedure-4 detect end state index = S4
    
    APX_InitState0PROC5(3);             //Set State-0 state for procedure-5
    APX_PROC5LineState_Init(0x0D2);     //SDT_I0 / SDT_I1 S0 ~ S5 state configure for procedure-5
    APX_SetEndOfPROC5(3);               //Set procedure-5 detect end state index = S4
    
    
    /*SDT interrupt configure*/
    APX_ClearFlag(APX,(APX_SDTF4 | APX_SDTF5));
    APX_IT_Config(APX,(APX_SDT_IE4 | APX_SDT_IE5),ENABLE);
    APX_ITEA_Cmd(APX,ENABLE);
    NVIC_EnableIRQ(APX_IRQn);
    
}

/**
 *******************************************************************************
 * @brief	   SDT of APX IRQHandler callback function
 * @details 
 * @return     
 * @exception   
 * @note           
 *******************************************************************************
 */
__WEAK void APX_IRQHandler_Callback(void)
{
    //=========================================================
    //NOTE : This function should not be modifyed, when the 
    //       callback is needed, the APX_IRQHandler_Callback 
    //       can be implemented in the user file.
}

