/*
*********************************************************************************************************
*                                              EXAMPLE CODE
*
*                             (c) Copyright 2012; Micrium, Inc.; Weston, FL
*
*                   All rights reserved.  Protected by international copyright laws.
*                   Knowledge of the source code may not be used to write a similar
*                   product.  This file may only be used in accordance with a license
*                   and should not be redistributed in any way.
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*
*                                            EXAMPLE CODE
*
*                                           megawin MG32
*                                              on the
*
*                                       MG32F02A132-EV Board
*                                         Evaluation Board
*
* Filename      : app.c
* Version       : V1.00
* Programmer(s) : MD
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             INCLUDE FILES
*********************************************************************************************************
*/

#include  <includes.h>


/*
*********************************************************************************************************
*                                            LOCAL DEFINES
*********************************************************************************************************
*/

#define STARTUP_TASK_PRIO 4
#define STARTUP_TASK_STK_SIZE 40

/*
*********************************************************************************************************
*                                       LOCAL GLOBAL VARIABLES
*********************************************************************************************************
*/

/* --------------- APPLICATION GLOBALS ---------------- */
static OS_STK task_testled1[STARTUP_TASK_STK_SIZE];
static OS_STK task_testled2[STARTUP_TASK_STK_SIZE];
static OS_STK task_testled3[STARTUP_TASK_STK_SIZE];

/*
*********************************************************************************************************
*                                         FUNCTION PROTOTYPES
*********************************************************************************************************
*/


/*
*********************************************************************************************************
*       
*
*
*********************************************************************************************************
**/
void TestLed1(void *p_arg)
{
    while(1)
    {
        BSP_LED_Toggle(2);
        OSTimeDlyHMSM(0,0,1,0);
    }
}


void TestLed2(void *p_arg)
{
    while(1)
    {
        BSP_LED_Toggle(3);
        OSTimeDlyHMSM(0,0,0,500);
    }
}


void TestLed3(void *p_arg)
{
    while(1)
    {
        BSP_LED_Toggle(4);
        OSTimeDlyHMSM(0,0,0,100);
    }
}


/*
*********************************************************************************************************
*                                                main()
*
* Description : This is the standard entry point for C code.  It is assumed that your code will call
*               main() once you have performed all necessary initialization.
*
* Arguments   : none
*
* Returns     : none
*
*********************************************************************************************************
**/

int main(void)
{
#if (CPU_CFG_NAME_ERR == DEF_ENABLED)
    CPU_ERR     cpu_err;
#endif

    CPU_Init();

    CPU_IntDis();                   /* Disable all interrupts.                              */

    BSP_IntInit();

    ChipInit();

    OS_CPU_SysTickInit(BSP_CPU_ClkFreq() / OS_TICKS_PER_SEC);

    OSInit();                                                   /* Initialize "uC/OS-II, The Real-Time Kernel"          */

/*  INT8U  OSTaskCreate (void   (*task)(void *p_arg),
                         void    *p_arg,
                         OS_STK  *ptos,
                         INT8U    prio) */
    OSTaskCreate(TestLed1, (void *)0, &task_testled1[STARTUP_TASK_STK_SIZE-1], STARTUP_TASK_PRIO);
    OSTaskCreate(TestLed2, (void *)0, &task_testled2[STARTUP_TASK_STK_SIZE-1], STARTUP_TASK_PRIO-1);
    OSTaskCreate(TestLed3, (void *)0, &task_testled3[STARTUP_TASK_STK_SIZE-1], STARTUP_TASK_PRIO-2);

    OSStart();                                                  /* Start multitasking (i.e. give control to uC/OS-II)   */

    return (1);
}


