


/**
 ******************************************************************************
 *
 * @file        BSP_7_StepMotor.h
 * @brief       This is Step Motor H file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/05/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#ifndef _BSP_7_STEPMOTOR_H
 
#define _BSP_7_STEPMOTOR_H 
 
 
#include "MG32_GPIO_DRV.h"
#include "MG32_TM_DRV.h"


/**
 * @name define
 *   		
 */ 
///@{ 
#define BSP_STEPMOTOR_IDLE              0
#define BSP_STEPMOTOR_BUSY              1

///@}

/**
 * @name function
 *   		
 */ 
///@{
void BSP_StepMotor_Init(void);
void BSP_StepMotor_ClockwiseRotate(uint32_t Clockwise_step);
void BSP_StepMotor_AnticlockwiseRotate(uint32_t anticlockwise_step);
uint8_t BSP_StepMotor_GetStatus(void);
void BSP_StepMotor_SetSpeed(uint16_t StepMotor_Speed);
///@} 
 

#endif

