

/**
 ******************************************************************************
 *
 * @file        BSP_TemperatureSensor.h
 * @brief        
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2024/08/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _BSP_TEMPERATURESENSOR_H
#define _BSP_TEMPERATURESENSOR_H


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_ADC_DRV.h"


/* Menu ----------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define TEMP_ADC_CHANNEL    2

/* Typedef -------------------------------------------------------------------*/
/* Macro ---------------------------------------------------------------------*/
/* variables -----------------------------------------------------------------*/
/* Functions -----------------------------------------------------------------*/
void BSP_TemperatureSensor_Init(void);


void BSP_TemperatureSensor_Trigger(void);
void BSP_TemperatureSensor_DischargeTrigger(void);
void BSP_TemperatureSensor_Handler(void);
int16_t BSP_TemperatureSensor_GetDegree(void);

void BSP_TemperatureSensor_CpltCallback(void);
void BSP_TemperatureSensor_SkipADCData(void);

#endif





