

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2025/07/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"
#include "MG32_ChipInit.h"
#include "MG32_IEC60730_Common.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#if defined(MG32_2ND)
    #define MG_EB_LED1SET  PIND(8)
    #define MG_EB_LED2SET  PIND(9)
    #define MG_EB_LED3SET  PIND(10)

    #define MG_EB_LED1     PD8
    #define MG_EB_LED2     PD9
    #define MG_EB_LED3     PD10
#endif
#if defined(MG32_1ST) || defined(MG32_3RD)
    #define MG_EB_LED1     PE13
    #define MG_EB_LED2     PE14
    #define MG_EB_LED3     PE15
    
    #define MG_EB_LED1SET  PINE(13)
    #define MG_EB_LED2SET  PINE(14)
    #define MG_EB_LED3SET  PINE(15)
#endif
#if defined(MG32_5TH)
    #define MG_EB_LED1     PC0
    #define MG_EB_LED2     PC2
    #define MG_EB_LED3     PA2
    
    #define MG_EB_LED1SET  PINC(0)
    #define MG_EB_LED2SET  PINC(2)
    #define MG_EB_LED3SET  PINA(2)
#endif

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_Code(void);
void Sample_SysTick_Init(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


int main(void)
{    
    PIN_InitTypeDef        PINX_InitStruct;
    
    // ------------------------------------------------------------------------
    // chip initial (User can enable CSC, GPIO, TM, ADC, EXIC ... wizard)
    // ------------------------------------------------------------------------
    ChipInit();
    
    //============================================
    //System Tick inital
    InitTick(12000000UL, 0); // 1ms Tick
    
    //============================================
    PINX_InitStruct.PINX_Mode				= PINX_Mode_PushPull_O;
    PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Enable;
    PINX_InitStruct.PINX_Speed              = PINX_Speed_Low;
    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;
    PINX_InitStruct.PINX_Alternate_Function = 0;

    GPIO_PinMode_Config(MG_EB_LED1SET,&PINX_InitStruct);
    GPIO_PinMode_Config(MG_EB_LED2SET,&PINX_InitStruct);
    GPIO_PinMode_Config(MG_EB_LED3SET,&PINX_InitStruct);
    
    while(1)
    {            
        // Toggle LEDs        
        MG_EB_LED1 = 0; MG_EB_LED2 = 1; MG_EB_LED3 = 1;
        Delay(250);
        MG_EB_LED1 = 1; MG_EB_LED2 = 0; MG_EB_LED3 = 1;
        Delay(250);
        MG_EB_LED1 = 1; MG_EB_LED2 = 1; MG_EB_LED3 = 0;
        Delay(250);
        
        // To do......
        // --------------------------------------------------------------------
        // 1. 'IEC60730_CPURegister_RunTime' function call is only available in 'ON Mode'.
        // 2. User call this function 'IEC60730_CPURegister_RunTime' to check CPU register.
        // 3. If an error occurs in "IEC60730_CPURegister_RunTime", the FailSafePOR routine is executed.
        // --------------------------------------------------------------------
        // IEC60730_CPURegister_RunTime:
        //      Size : 904 bytes (-O0)
        //      Execution time : 36.242us / 447 cycles @ CK_AHB=12MHz
        // --------------------------------------------------------------------
        IEC60730_CPURegister_RunTime();        
        
        // --------------------------------------------------------------------
        // 1. 'IEC60730_Flash_RunTime_AP' function call is only available in 'ON Mode'.
        // 2. User call this function 'IEC60730_Flash_RunTime_AP' to check AP area using CRC code.
        // 3. If 'IEC60730_Flash_RunTime_AP' returns 'IEC60730_TEST_FAILURE' code. 
        //    User must pay attention to this issue.
        // --------------------------------------------------------------------
        // IEC60730_Flash_RunTime_AP:
        //      Size : 496 bytes bytes (-O0)
        //      Execution time : 8485 cycls @ CK_AHB=12MHz (1K AP)
        // --------------------------------------------------------------------
        if (IEC60730_Flash_RunTime_AP() == IEC60730_TEST_FAILURE)
        {
            // to do ... (There is an unknow problem in the AP area. User needs to care about it.)
            
            while(1);
        }
        
        // --------------------------------------------------------------------
        // 1. 'IEC60730_Flash_RunTime_IAP' function call is only available in 'ON Mode'.
        // 2. User call this function 'IEC60730_Flash_RunTime_IAP' to check IAP area using CRC code.
        // 3. If 'IEC60730_Flash_RunTime_IAP' returns 'IEC60730_TEST_FAILURE' code. User must pay attention to this issue.
        // 4. The IAP check code is stored in the last 4 bytes of the last page of the IAP area.
        // 5. Very import !!! After updating the IAP area, user must update IAP check code by 'IEC60730_Flash_Initial_IAP' function call.
        // --------------------------------------------------------------------
        // IEC60730_Flash_RunTime_AP:
        //      Size : 352 bytes (-O0)
        //      Execution time : 6432 cycls @ CK_AHB=12MHz
        // --------------------------------------------------------------------
//        if (IEC60730_Flash_RunTime_IAP() == IEC60730_TEST_FAILURE)
//        {
//            // to do ... (There is an unknow problem in the IAP area. User needs to care about it.)
//            
//            while(1);
//        }
        
        // --------------------------------------------------------------------
        // 1. 'IEC60730_RAM_RunTime' function call is only available in 'ON Mode'.
        // 2. User call this function 'IEC60730_RAM_RunTime' to check RAM area by writing '1'.
        // 3. If 'IEC60730_RAM_RunTime' returns 'IEC60730_TEST_FAILURE' code. User must pay attention to this
        //    issue.
        // --------------------------------------------------------------------
        // IEC60730_RAM_RunTime:
        //      Size : 528 bytes / RW : 130 bytes (-O0)
        //      Execution time : 536 us / 6432 cycls @ CK_AHB=12MHz
        // --------------------------------------------------------------------
        if (IEC60730_RAM_RunTime() == IEC60730_TEST_FAILURE)
        {
//            // to do ... (There is an unknow problem in the RAM area. User needs to care about it.)
//
            while(1);
        }
        
        // --------------------------------------------------------------------
        // 1. 'IEC60730_Clock_RunTime' function call is only available in 'ON Mode'.
        // 2. User call this function 'IEC60730_Clock_RunTime' to check real CK_APB 
        //    frequency and ideal CK_APB frequency gap must less +-40%.
        // 3. If 'IEC60730_Clock_RunTime' returns 'IEC60730_TEST_FAILURE' code.
        //    User must pay attention to this issue.
        // --------------------------------------------------------------------
        // IEC60730_Clock_RunTime:
        //      Size : 1176 bytes
        //      Execution time : 4260 (us) @ CK_AHB=0.75MHz
        //      Execution time : 352  (us) @ CK_AHB=12MHz
        //      Execution time : 222  (us) @ CK_AHB=24MHz
        //      Execution time : 158  (us) @ CK_AHB=48MHz
        // --------------------------------------------------------------------
        if (IEC60730_Clock_RunTime() == IEC60730_TEST_FAILURE)
        {
//            // to do ... (There is an unknow problem in the clock control. User needs to care about it.)
//
            while(1);
        }
        
        // --------------------------------------------------------------------
        // 1. 'IEC60730_IWDT_RunTime' function call is only available in 'ON Mode'.(Need to enable system tick)
        // 2. Check IWDT underflow timing
        // 3. Check IWDT overflow timing
        // 4. Check IWDT overflow timing
        // --------------------------------------------------------------------
        // IEC60730_IWDT_RunTime:
        //      Size :  248 bytes
        //      Execution time : 17ms @ CK_AHB=12MHz
        // --------------------------------------------------------------------
        if (IEC60730_IWDT_RunTime() == IEC60730_TEST_FAILURE)
        {
//            // to do ... (There is an unknow problem in the IWDT function. User needs to care about it.)
//
            while(1);
        }
    }
}
