

 /**
 ******************************************************************************
 *
 * @file        MG_CAN.h
 * @brief       MG CAN module sample code H file.
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2025/04/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_ChipInit.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_CAN_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Typedef -------------------------------------------------------------------*/
/* Define --------------------------------------------------------------------*/
#define BUTTON0_PINX    PINA(0)       /*!< Button 0 pin IO control register define.*/  
#define BUTTON1_PINX    PINA(1)       /*!< Button 1 pin IO control register define.*/ 

#define BUTTON0         PA0           /*!< Button pin define.*/
#define BUTTON1         PA1           /*!< Button pin define.*/


#define LED_R_PINX      PINC(0)       /*!< LED Red pin IO control register define.*/
#define LED_Y_PINX      PINC(2)       /*!< LED Yellow pin IO control register define.*/
#define LED_G_PINX      PINA(2)       /*!< LED Green pin IO control register define.*/ 

#define LED_R           PC0           /*!< LED Red pin define.*/
#define LED_Y           PC2           /*!< LED Yellow pin define.*/
#define LED_G           PA2           /*!< LED Green pin define.*/

#define LED_ON          0             /*!< Define LED ON level.*/
#define LED_OFF         1             /*!< Define LED OFF level.*/


/* Macro ---------------------------------------------------------------------*/
/* Variables -----------------------------------------------------------------*/
/* Function prototypes -------------------------------------------------------*/
void Button_Initial(void);
void Button_Button0SimpleDebounce(void);
void Button_Button1SimpleDebounce(void);

void LED_Initial(void);




