/**
 ******************************************************************************
 *
 * @file        MG32_CFG.h
 *
 * @brief       MG32 CFG Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_CFG_H
#define _MG32_CFG_H
#define _MG32_CFG_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_CFG_H_VER)
    #error "_MG32_CFG_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      CFG_Struct
 *              CFG  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    __I uint32_t  RESERVED0[3];         /*!< RESERVED0  ~ Offset[0x00]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] CFG key register
                                        //0 = Unprotected
                                        //1 = Protected
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  CFG write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BOOT_MS       :2;     //[1..0] System cold reset boot memory select and memory is mapped at 0x0000 0000
                                        //0x0 = Application Flash
                                        //0x1 = Boot Flash
                                        //0x2 = Embedded SRAM
                                        //0x3 = Reserved
            __I  uint8_t                :5;     //[6..2] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t  LOCK_DIS      :1;     //[8] Main Flash code locked enable
                                        //0 = Enable
                                        //1 = Disable (Code dump on Writer is transparent)
            __I  uint8_t                :7;     //[15..9] 
            __I  uint8_t  BOD1_TH       :2;     //[17..16] BOD1 detect voltage threshold select.
                                        //0x0 = 2.0v
                                        //0x1 = 2.4v
                                        //0x2 = 3.7v
                                        //0x3 = 4.2v
            __I  uint8_t                :2;     //[19..18] 
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t  BOD0_WE       :1;     //[24] BOD0 trigger Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t  BOD1_WE       :1;     //[25] BOD1 trigger Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t  BOD2_WE       :1;     //[26] BOD2 trigger Warm reset enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :5;     //[31..27] 
        }MBIT;
    }OR00;                              /*!< OR00       ~ Offset[0x10]  CFG option byte register 00 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t IAP_SIZE      :16;    //[15..0] IAP memory size select
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR01;                              /*!< OR01       ~ Offset[0x14]  CFG option byte register 01 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t ISP_SIZE      :16;    //[15..0] ISP memory size select
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR02;                              /*!< OR02       ~ Offset[0x18]  CFG option byte register 02 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  IWDT_EN       :1;     //[0] IWDT enable after Cold reset
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t  IWDT_WP       :1;     //[1] IWDT registers write protected enable
                                        //0 = Disable
                                        //1 = Enable : Write-protected
            __I  uint8_t  IWDT_WE       :1;     //[2] IWDT reset generation enable option
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t  IWDT_DIV      :4;     //[7..4] IWDT internal clock CK_IWDT_INT input divider select
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
                                        //0x4 = DIV16 : divided by 16
                                        //0x5 = DIV32 : divided by 32
                                        //0x6 = DIV64 : divided by 64
                                        //0x7 = DIV128 : divided by 128
                                        //0x8 = DIV256 : divided by 256 
                                        //0x9 = DIV512 : divided by 512
                                        //0xA = DIV1024 : divided by 1024
                                        //0xB = DIV2048 : divided by 2048
                                        //0xC = DIV4096 : divided by 4096
            __I  uint8_t  IWDT_SLP      :1;     //[8] IWDT counting control when chip in SLEEP mode
                                        //0 = Stop : Stop counting
                                        //1 = Keep : Keep counting
            __I  uint8_t  IWDT_STP      :1;     //[9] IWDT counting control when chip in STOP mode
                                        //0 = Stop : Stop counting
                                        //1 = Keep : Keep counting
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR03;                              /*!< OR03       ~ Offset[0x1C]  CFG option byte register 03 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  IAP_AEN       :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :5;     //[6..2] 
            __I  uint8_t  HSP_EN        :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR04;                              /*!< OR04       ~ Offset[0x20]  CFG option byte register 04 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  EXRST_PIN     :1;     //[0] External reset pin control after power-on
                                        //0 = Enable
                                        //1 = Disable
            __I  uint8_t  SWD_PIN       :1;     //[1] SWD interface pin control after power-on
                                        //0 = Enable
                                        //1 = Disable
            __I  uint8_t  EXRST_SEL     :1;     //[2] External reset power on default warm-reset or cold-reset select
                                        //0 = Warm : Power-on warm reset
                                        //1 = Cold : Power-on cold reset
            __I  uint8_t  PC_IOM        :1;     //[3] Port C default IO mode select after power-on 
                                        //0 = AIO : Analog IO
                                        //1 = QB : Quasi-Bidirectional output drive high one CLK
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t  PON_MDS       :1;     //[8] 
            __I  uint8_t                :7;     //[15..9] 
            __I  uint8_t                :1;     //[16] 
            __I  uint8_t  HS_SEL        :1;     //[17] CK_HS clock source select after power-on (Cold reset)
                                        //0 = IHRCO
                                        //1 = ILRCO
            __I  uint8_t                :2;     //[19..18] 
            __I  uint8_t  PLL_CTL       :2;     //[21..20] 
            __I  uint8_t  HSWKP         :2;     //[23..22] 
            __I  uint8_t  XOSC_GN       :2;     //[25..24] 
            __I  uint8_t                :2;     //[27..26] 
            __I  uint8_t  XOSC_DB       :1;     //[28] 
            __I  uint8_t                :1;     //[29] 
            __I  uint8_t                :1;     //[30] 
            __I  uint8_t  XOSC_EN       :1;     //[31] XOSC crystal oscillation circuit enable
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }OR05;                              /*!< OR05       ~ Offset[0x24]  CFG option byte register 05 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  UTR_RES       :3;     //[2..0] USB UTR resolution value.
                                        //0x0 = 32 : 0.267%
                                        //0x1 = 48 : 0.4%
                                        //0x2 = 20x : 0.167%
                                        //0x3 = 24x : 0.2%
                                        //0x4 = 12 : 0.1%
                                        //0x5 = 16 : 0.133%
                                        //0x6 = 20 : 0.167%
                                        //0x7 = 24 : 0.2%
            __IO uint8_t  UTR_OFINE     :1;     //[3] USB UTR HFOSC frequency trimming mode select.
                                        //0 = Normal : UTR use both rough and fine tune bit for frequency trimming.
                                        //1 = Fine : UTR only use fine tune bit for frequency trimming.
            __IO uint8_t  UTR_INTV      :2;     //[5..4] USB UTR interval value select.
                                        //0x0 = 1ms
                                        //0x1 = 8ms
                                        //0x2 = 4ms
                                        //0x3 = 2ms
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  UTR_EN        :1;     //[7] USB UTR function enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  XTR_EN        :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :6;     //[15..10] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR06;                              /*!< OR06       ~ Offset[0x28]  CFG option byte register 06 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t  CG21          :1;     //[1] 
            __I  uint8_t  CG22          :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t  LVRDE         :1;     //[5] 
            __I  uint8_t  LVRDS0        :1;     //[6] 
            __I  uint8_t  LVRDS1        :1;     //[7] 
            __I  uint8_t  PNDCE         :1;     //[8] 
            __I  uint8_t  PNDRC         :1;     //[9] 
            __I  uint8_t  PORDS         :1;     //[10] 
            __I  uint8_t  DPORDS        :1;     //[11] 
            __I  uint8_t  CGIL          :1;     //[12] 
            __I  uint8_t  GF            :3;     //[15..13] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR07;                              /*!< OR07       ~ Offset[0x2C]  CFG option byte register 07 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  V33_TRM       :3;     //[2..0] 
            __I  uint8_t                :5;     //[7..3] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR10;                              /*!< OR10       ~ Offset[0x30]  CFG option byte register 10 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :3;     //[2..0] 
            __I  uint8_t                :5;     //[7..3] 
            __IO uint8_t  VBG_BTRM      :5;     //[12..8] 
            __I  uint8_t                :3;     //[15..13] 
            __I  uint8_t                :5;     //[20..16] 
            __I  uint8_t                :3;     //[23..21] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OR11;                              /*!< OR11       ~ Offset[0x34]  CFG option byte register 11 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  BOD2_TRM      :3;     //[2..0] 
            __I  uint8_t                :5;     //[7..3] 
            __IO uint8_t  BOD1_TRM      :4;     //[11..8] 
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  LVR_TRM       :4;     //[19..16] 
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }OR12;                              /*!< OR12       ~ Offset[0x38]  CFG option byte register 12 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IHR0_FTRM     :7;     //[6..0] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  IHR0_CTRM     :2;     //[9..8] 
            __I  uint8_t                :6;     //[15..10] 
            __IO uint8_t  IHR1_FTRM     :7;     //[22..16] 
            __I  uint8_t                :1;     //[23] 
            __IO uint8_t  IHR1_CTRM     :2;     //[25..24] 
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }OR13;                              /*!< OR13       ~ Offset[0x3C]  CFG option byte register 13 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ILR_TRM       :4;     //[3..0] 
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  IHR_BGTV      :2;     //[9..8] 
            __I  uint8_t                :3;     //[12..10] 
            __IO uint8_t  IHR_BGTI      :3;     //[15..13] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OR14;                              /*!< OR14       ~ Offset[0x40]  CFG option byte register 14 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x44]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t TEMP_CAL0     :12;    //[11..0] Temperature Sensor calibration value acquired at 25 degree-C
            __I  uint8_t                :4;     //[15..12] 
            __IO uint16_t TEMP_CAL1     :12;    //[27..16] Temperature Sensor calibration value acquired at 60 degree-C
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }OR16;                              /*!< OR16       ~ Offset[0x48]  CFG option byte register 16 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  LDO_TRM       :3;     //[2..0] 
            __I  uint8_t                :5;     //[7..3] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  IVR_TRM       :5;     //[20..16] 
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  ADC_OFFT      :5;     //[28..24] ADC offset adjust bits
            __I  uint8_t                :3;     //[31..29] 
        }MBIT;
    }OR17;                              /*!< OR17       ~ Offset[0x4C]  CFG option byte register 17 */

    __I uint32_t  RESERVED2[4];         /*!< RESERVED2  ~ Offset[0x50]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  POF0          :1;     //[0] 
            __IO uint8_t  POF1          :1;     //[1] 
            __IO uint8_t  POF2          :1;     //[2] 
            __IO uint8_t  DPORF         :1;     //[3] 
            __IO uint8_t  LVRF0         :1;     //[4] 
            __IO uint8_t  DBLVRF        :1;     //[5] 
            __IO uint8_t  PNDF          :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TST0;                              /*!< TST0       ~ Offset[0x60]  CFG Test register 0 (not load from flash memory) */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  FLH_WE        :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  FTSTO         :5;     //[6..2] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BOD_OE        :1;     //[8] 
            __IO uint8_t  LVR_DIS       :1;     //[9] 
            __I  uint8_t                :6;     //[15..10] 
            __IO uint8_t  IHRCK_OE      :1;     //[16] 
            __IO uint8_t  ILRCK_OE      :1;     //[17] 
            __IO uint8_t  ILRCO_EN      :1;     //[18] 
            __I  uint8_t                :5;     //[23..19] 
            __IO uint8_t  PLL_TST       :1;     //[24] 
            __IO uint8_t  PLL_GOFF      :1;     //[25] 
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  PCKI_SEL      :1;     //[28] 
            __IO uint8_t  PCTL_SEL      :1;     //[29] 
            __IO uint8_t  TST_PCTL      :2;     //[31..30] 
        }MBIT;
    }TST1;                              /*!< TST1       ~ Offset[0x64]  CFG Test register 2 (not load from flash memory) */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EXPHY_SEL     :3;     //[2..0] 
            __IO uint8_t  EXPHY_EN      :1;     //[3] 
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  IOCHAIN_EN    :1;     //[8] 
            __I  uint8_t                :7;     //[15..9] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }TST2;                              /*!< TST2       ~ Offset[0x68]  CFG Test register 2 (not load from flash memory) */

} CFG_Struct;

/**
 ******************************************************************************
 *
 * @name        CFG  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CFG_Base                        ((uint32_t)0x4FF00000)              /*!< Hardware Option Bytes Configure Control */
#define CFG                             ((CFG_Struct*) CFG_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        CFG  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        CFG_KEY  [register's definitions]
 *              Offset[0x0C]  CFG write protected Key register (0x4FF0000C)
 ******************************************************************************
 */
///@{
#define CFG_KEY_default                             ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_KEY */
#define CFG_KEY_KEY_mask_w                          ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define CFG_KEY_KEY_mask_h0                         ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define CFG_KEY_KEY_unprotected_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define CFG_KEY_KEY_unprotected_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define CFG_KEY_KEY_unprotected_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define CFG_KEY_KEY_protected_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define CFG_KEY_KEY_protected_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define CFG_KEY_KEY_protected_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR00  [register's definitions]
 *              Offset[0x10]  CFG option byte register 00 (0x4FF00010)
 ******************************************************************************
 */
///@{
#define CFG_OR00_default                            ((uint32_t)0x00330001)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR00 */
#define CFG_OR00_BOD2_WE_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define CFG_OR00_BOD2_WE_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CFG_OR00_BOD2_WE_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_OR00_BOD2_WE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR00_BOD2_WE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR00_BOD2_WE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR00_BOD2_WE_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR00_BOD2_WE_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR00_BOD2_WE_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR00_BOD1_WE_mask_w                     ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define CFG_OR00_BOD1_WE_mask_h1                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CFG_OR00_BOD1_WE_mask_b3                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR00_BOD1_WE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR00_BOD1_WE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR00_BOD1_WE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR00_BOD1_WE_enable_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR00_BOD1_WE_enable_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR00_BOD1_WE_enable_b3                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR00_BOD0_WE_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define CFG_OR00_BOD0_WE_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR00_BOD0_WE_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR00_BOD0_WE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR00_BOD0_WE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR00_BOD0_WE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR00_BOD0_WE_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR00_BOD0_WE_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR00_BOD0_WE_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR00_BOD1_TH_mask_w                     ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define CFG_OR00_BOD1_TH_mask_h1                    ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CFG_OR00_BOD1_TH_mask_b2                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR00_BOD1_TH_2_0v_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):2.0v of 32bit */
#define CFG_OR00_BOD1_TH_2_0v_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):2.0v of 16bit */
#define CFG_OR00_BOD1_TH_2_0v_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):2.0v of 8bit */
#define CFG_OR00_BOD1_TH_2_4v_w                     ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):2.4v of 32bit */
#define CFG_OR00_BOD1_TH_2_4v_h1                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):2.4v of 16bit */
#define CFG_OR00_BOD1_TH_2_4v_b2                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):2.4v of 8bit */
#define CFG_OR00_BOD1_TH_3_7v_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):3.7v of 32bit */
#define CFG_OR00_BOD1_TH_3_7v_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(0x2):3.7v of 16bit */
#define CFG_OR00_BOD1_TH_3_7v_b2                    ((uint8_t )0x02)        /*!< Bit Value =(0x2):3.7v of 8bit */
#define CFG_OR00_BOD1_TH_4_2v_w                     ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):4.2v of 32bit */
#define CFG_OR00_BOD1_TH_4_2v_h1                    ((uint16_t)0x0003)      /*!< Bit Value =(0x3):4.2v of 16bit */
#define CFG_OR00_BOD1_TH_4_2v_b2                    ((uint8_t )0x03)        /*!< Bit Value =(0x3):4.2v of 8bit */

#define CFG_OR00_LOCK_DIS_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_OR00_LOCK_DIS_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR00_LOCK_DIS_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR00_LOCK_DIS_enable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define CFG_OR00_LOCK_DIS_enable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define CFG_OR00_LOCK_DIS_enable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define CFG_OR00_LOCK_DIS_disable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Disable of 32bit */
#define CFG_OR00_LOCK_DIS_disable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Disable of 16bit */
#define CFG_OR00_LOCK_DIS_disable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Disable of 8bit */

#define CFG_OR00_BOOT_MS_mask_w                     ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define CFG_OR00_BOOT_MS_mask_h0                    ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define CFG_OR00_BOOT_MS_mask_b0                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR00_BOOT_MS_application_flash_w        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Application Flash of 32bit */
#define CFG_OR00_BOOT_MS_application_flash_h0       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Application Flash of 16bit */
#define CFG_OR00_BOOT_MS_application_flash_b0       ((uint8_t )0x00)        /*!< Bit Value =(0x0):Application Flash of 8bit */
#define CFG_OR00_BOOT_MS_boot_flash_w               ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Boot Flash of 32bit */
#define CFG_OR00_BOOT_MS_boot_flash_h0              ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Boot Flash of 16bit */
#define CFG_OR00_BOOT_MS_boot_flash_b0              ((uint8_t )0x01)        /*!< Bit Value =(0x1):Boot Flash of 8bit */
#define CFG_OR00_BOOT_MS_embedded_sram_w            ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Embedded SRAM of 32bit */
#define CFG_OR00_BOOT_MS_embedded_sram_h0           ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Embedded SRAM of 16bit */
#define CFG_OR00_BOOT_MS_embedded_sram_b0           ((uint8_t )0x02)        /*!< Bit Value =(0x2):Embedded SRAM of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR01  [register's definitions]
 *              Offset[0x14]  CFG option byte register 01 (0x4FF00014)
 ******************************************************************************
 */
///@{
#define CFG_OR01_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR01 */
#define CFG_OR01_IAP_SIZE_mask_w                    ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define CFG_OR01_IAP_SIZE_mask_h0                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define CFG_OR01_IAP_SIZE_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR01_IAP_SIZE_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR01_IAP_SIZE_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR02  [register's definitions]
 *              Offset[0x18]  CFG option byte register 02 (0x4FF00018)
 ******************************************************************************
 */
///@{
#define CFG_OR02_default                            ((uint32_t)0x00000200)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR02 */
#define CFG_OR02_ISP_SIZE_mask_w                    ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define CFG_OR02_ISP_SIZE_mask_h0                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define CFG_OR02_ISP_SIZE_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR02_ISP_SIZE_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR02_ISP_SIZE_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR03  [register's definitions]
 *              Offset[0x1C]  CFG option byte register 03 (0x4FF0001C)
 ******************************************************************************
 */
///@{
#define CFG_OR03_default                            ((uint32_t)0x000000F0)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR03 */
#define CFG_OR03_IWDT_STP_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_STP_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_STP_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_STP_stop_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define CFG_OR03_IWDT_STP_stop_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define CFG_OR03_IWDT_STP_stop_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define CFG_OR03_IWDT_STP_keep_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Keep of 32bit */
#define CFG_OR03_IWDT_STP_keep_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Keep of 16bit */
#define CFG_OR03_IWDT_STP_keep_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Keep of 8bit */

#define CFG_OR03_IWDT_SLP_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_SLP_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_SLP_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_SLP_stop_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Stop of 32bit */
#define CFG_OR03_IWDT_SLP_stop_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Stop of 16bit */
#define CFG_OR03_IWDT_SLP_stop_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Stop of 8bit */
#define CFG_OR03_IWDT_SLP_keep_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Keep of 32bit */
#define CFG_OR03_IWDT_SLP_keep_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Keep of 16bit */
#define CFG_OR03_IWDT_SLP_keep_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Keep of 8bit */

#define CFG_OR03_IWDT_DIV_mask_w                    ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_DIV_mask_h0                   ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_DIV_mask_b0                   ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_DIV_div1_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CFG_OR03_IWDT_DIV_div1_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CFG_OR03_IWDT_DIV_div1_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CFG_OR03_IWDT_DIV_div2_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CFG_OR03_IWDT_DIV_div2_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CFG_OR03_IWDT_DIV_div2_b0                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CFG_OR03_IWDT_DIV_div4_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CFG_OR03_IWDT_DIV_div4_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CFG_OR03_IWDT_DIV_div4_b0                   ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CFG_OR03_IWDT_DIV_div8_w                    ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CFG_OR03_IWDT_DIV_div8_h0                   ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CFG_OR03_IWDT_DIV_div8_b0                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */
#define CFG_OR03_IWDT_DIV_div16_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(0x4):DIV16 of 32bit */
#define CFG_OR03_IWDT_DIV_div16_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(0x4):DIV16 of 16bit */
#define CFG_OR03_IWDT_DIV_div16_b0                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):DIV16 of 8bit */
#define CFG_OR03_IWDT_DIV_div32_w                   ((uint32_t)0x00000050)  /*!< Bit Value =(0x5):DIV32 of 32bit */
#define CFG_OR03_IWDT_DIV_div32_h0                  ((uint16_t)0x0050)      /*!< Bit Value =(0x5):DIV32 of 16bit */
#define CFG_OR03_IWDT_DIV_div32_b0                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):DIV32 of 8bit */
#define CFG_OR03_IWDT_DIV_div64_w                   ((uint32_t)0x00000060)  /*!< Bit Value =(0x6):DIV64 of 32bit */
#define CFG_OR03_IWDT_DIV_div64_h0                  ((uint16_t)0x0060)      /*!< Bit Value =(0x6):DIV64 of 16bit */
#define CFG_OR03_IWDT_DIV_div64_b0                  ((uint8_t )0x60)        /*!< Bit Value =(0x6):DIV64 of 8bit */
#define CFG_OR03_IWDT_DIV_div128_w                  ((uint32_t)0x00000070)  /*!< Bit Value =(0x7):DIV128 of 32bit */
#define CFG_OR03_IWDT_DIV_div128_h0                 ((uint16_t)0x0070)      /*!< Bit Value =(0x7):DIV128 of 16bit */
#define CFG_OR03_IWDT_DIV_div128_b0                 ((uint8_t )0x70)        /*!< Bit Value =(0x7):DIV128 of 8bit */
#define CFG_OR03_IWDT_DIV_div256_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(0x8):DIV256 of 32bit */
#define CFG_OR03_IWDT_DIV_div256_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(0x8):DIV256 of 16bit */
#define CFG_OR03_IWDT_DIV_div256_b0                 ((uint8_t )0x80)        /*!< Bit Value =(0x8):DIV256 of 8bit */
#define CFG_OR03_IWDT_DIV_div512_w                  ((uint32_t)0x00000090)  /*!< Bit Value =(0x9):DIV512 of 32bit */
#define CFG_OR03_IWDT_DIV_div512_h0                 ((uint16_t)0x0090)      /*!< Bit Value =(0x9):DIV512 of 16bit */
#define CFG_OR03_IWDT_DIV_div512_b0                 ((uint8_t )0x90)        /*!< Bit Value =(0x9):DIV512 of 8bit */
#define CFG_OR03_IWDT_DIV_div1024_w                 ((uint32_t)0x000000A0)  /*!< Bit Value =(0xA):DIV1024 of 32bit */
#define CFG_OR03_IWDT_DIV_div1024_h0                ((uint16_t)0x00A0)      /*!< Bit Value =(0xA):DIV1024 of 16bit */
#define CFG_OR03_IWDT_DIV_div1024_b0                ((uint8_t )0xA0)        /*!< Bit Value =(0xA):DIV1024 of 8bit */
#define CFG_OR03_IWDT_DIV_div2048_w                 ((uint32_t)0x000000B0)  /*!< Bit Value =(0xB):DIV2048 of 32bit */
#define CFG_OR03_IWDT_DIV_div2048_h0                ((uint16_t)0x00B0)      /*!< Bit Value =(0xB):DIV2048 of 16bit */
#define CFG_OR03_IWDT_DIV_div2048_b0                ((uint8_t )0xB0)        /*!< Bit Value =(0xB):DIV2048 of 8bit */
#define CFG_OR03_IWDT_DIV_div4096_w                 ((uint32_t)0x000000C0)  /*!< Bit Value =(0xC):DIV4096 of 32bit */
#define CFG_OR03_IWDT_DIV_div4096_h0                ((uint16_t)0x00C0)      /*!< Bit Value =(0xC):DIV4096 of 16bit */
#define CFG_OR03_IWDT_DIV_div4096_b0                ((uint8_t )0xC0)        /*!< Bit Value =(0xC):DIV4096 of 8bit */

#define CFG_OR03_IWDT_WE_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_WE_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_WE_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_WE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR03_IWDT_WE_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR03_IWDT_WE_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR03_IWDT_WE_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR03_IWDT_WE_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR03_IWDT_WE_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR03_IWDT_WP_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_WP_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_WP_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_WP_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR03_IWDT_WP_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR03_IWDT_WP_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR03_IWDT_WP_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR03_IWDT_WP_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR03_IWDT_WP_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR03_IWDT_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CFG_OR03_IWDT_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_OR03_IWDT_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR03_IWDT_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR03_IWDT_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR03_IWDT_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR03_IWDT_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR03_IWDT_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR03_IWDT_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR04  [register's definitions]
 *              Offset[0x20]  CFG option byte register 04 (0x4FF00020)
 ******************************************************************************
 */
///@{
#define CFG_OR04_default                            ((uint32_t)0x00000081)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR04 */
#define CFG_OR04_HSP_EN_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CFG_OR04_HSP_EN_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CFG_OR04_HSP_EN_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CFG_OR04_HSP_EN_disable_w                   ((uint32_t)0x00000000)
#define CFG_OR04_HSP_EN_disable_h0                  ((uint16_t)0x0000)
#define CFG_OR04_HSP_EN_disable_b0                  ((uint8_t )0x00)
#define CFG_OR04_HSP_EN_enable_w                    ((uint32_t)0x00000080)
#define CFG_OR04_HSP_EN_enable_h0                   ((uint16_t)0x0080)
#define CFG_OR04_HSP_EN_enable_b0                   ((uint8_t )0x80)

#define CFG_OR04_IAP_AEN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CFG_OR04_IAP_AEN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_OR04_IAP_AEN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR04_IAP_AEN_disable_w                  ((uint32_t)0x00000000)
#define CFG_OR04_IAP_AEN_disable_h0                 ((uint16_t)0x0000)
#define CFG_OR04_IAP_AEN_disable_b0                 ((uint8_t )0x00)
#define CFG_OR04_IAP_AEN_enable_w                   ((uint32_t)0x00000001)
#define CFG_OR04_IAP_AEN_enable_h0                  ((uint16_t)0x0001)
#define CFG_OR04_IAP_AEN_enable_b0                  ((uint8_t )0x01)

///@}
/**
 ******************************************************************************
 * @name        CFG_OR05  [register's definitions]
 *              Offset[0x24]  CFG option byte register 05 (0x4FF00024)
 ******************************************************************************
 */
///@{
#define CFG_OR05_default                            ((uint32_t)0x11E00100)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR05 */
#define CFG_OR05_XOSC_EN_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_XOSC_EN_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CFG_OR05_XOSC_EN_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CFG_OR05_XOSC_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR05_XOSC_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR05_XOSC_EN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR05_XOSC_EN_enable_w                   ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR05_XOSC_EN_enable_h1                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR05_XOSC_EN_enable_b3                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR05_XOSC_DB_mask_w                     ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_XOSC_DB_mask_h1                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CFG_OR05_XOSC_DB_mask_b3                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CFG_OR05_XOSC_DB_4096_w                     ((uint32_t)0x00000000)
#define CFG_OR05_XOSC_DB_4096_h1                    ((uint16_t)0x0000)
#define CFG_OR05_XOSC_DB_4096_b3                    ((uint8_t )0x00)
#define CFG_OR05_XOSC_DB_1024_w                     ((uint32_t)0x10000000)
#define CFG_OR05_XOSC_DB_1024_h1                    ((uint16_t)0x1000)
#define CFG_OR05_XOSC_DB_1024_b3                    ((uint8_t )0x10)

#define CFG_OR05_XOSC_GN_mask_w                     ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_XOSC_GN_mask_h1                    ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CFG_OR05_XOSC_GN_mask_b3                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR05_XOSC_GN_32k_normal_w               ((uint32_t)0x00000000)
#define CFG_OR05_XOSC_GN_32k_normal_h1              ((uint16_t)0x0000)
#define CFG_OR05_XOSC_GN_32k_normal_b3              ((uint8_t )0x00)
#define CFG_OR05_XOSC_GN_medium_w                   ((uint32_t)0x01000000)
#define CFG_OR05_XOSC_GN_medium_h1                  ((uint16_t)0x0100)
#define CFG_OR05_XOSC_GN_medium_b3                  ((uint8_t )0x01)
#define CFG_OR05_XOSC_GN_32k_lowest_w               ((uint32_t)0x02000000)
#define CFG_OR05_XOSC_GN_32k_lowest_h1              ((uint16_t)0x0200)
#define CFG_OR05_XOSC_GN_32k_lowest_b3              ((uint8_t )0x02)

#define CFG_OR05_HSWKP_mask_w                       ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_HSWKP_mask_h1                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CFG_OR05_HSWKP_mask_b2                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CFG_OR05_HSWKP_dt0_w                        ((uint32_t)0x00000000)
#define CFG_OR05_HSWKP_dt0_h1                       ((uint16_t)0x0000)
#define CFG_OR05_HSWKP_dt0_b2                       ((uint8_t )0x00)
#define CFG_OR05_HSWKP_dt1_w                        ((uint32_t)0x00400000)
#define CFG_OR05_HSWKP_dt1_h1                       ((uint16_t)0x0040)
#define CFG_OR05_HSWKP_dt1_b2                       ((uint8_t )0x40)
#define CFG_OR05_HSWKP_dt2_w                        ((uint32_t)0x00800000)
#define CFG_OR05_HSWKP_dt2_h1                       ((uint16_t)0x0080)
#define CFG_OR05_HSWKP_dt2_b2                       ((uint8_t )0x80)
#define CFG_OR05_HSWKP_dt3_w                        ((uint32_t)0x00C00000)
#define CFG_OR05_HSWKP_dt3_h1                       ((uint16_t)0x00C0)
#define CFG_OR05_HSWKP_dt3_b2                       ((uint8_t )0xC0)

#define CFG_OR05_PLL_CTL_mask_w                     ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_PLL_CTL_mask_h1                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CFG_OR05_PLL_CTL_mask_b2                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CFG_OR05_PLL_CTL_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define CFG_OR05_PLL_CTL_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define CFG_OR05_PLL_CTL_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define CFG_OR05_HS_SEL_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CFG_OR05_HS_SEL_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_OR05_HS_SEL_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR05_HS_SEL_ihrco_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):IHRCO of 32bit */
#define CFG_OR05_HS_SEL_ihrco_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):IHRCO of 16bit */
#define CFG_OR05_HS_SEL_ihrco_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):IHRCO of 8bit */
#define CFG_OR05_HS_SEL_ilrco_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):ILRCO of 32bit */
#define CFG_OR05_HS_SEL_ilrco_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):ILRCO of 16bit */
#define CFG_OR05_HS_SEL_ilrco_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):ILRCO of 8bit */

#define CFG_OR05_PON_MDS_mask_w                     ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_OR05_PON_MDS_mask_h0                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR05_PON_MDS_mask_b1                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR05_PON_MDS_fast_w                     ((uint32_t)0x00000000)
#define CFG_OR05_PON_MDS_fast_h0                    ((uint16_t)0x0000)
#define CFG_OR05_PON_MDS_fast_b1                    ((uint8_t )0x00)
#define CFG_OR05_PON_MDS_slow_w                     ((uint32_t)0x00000100)
#define CFG_OR05_PON_MDS_slow_h0                    ((uint16_t)0x0100)
#define CFG_OR05_PON_MDS_slow_b1                    ((uint8_t )0x01)

#define CFG_OR05_PC_IOM_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CFG_OR05_PC_IOM_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CFG_OR05_PC_IOM_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CFG_OR05_PC_IOM_aio_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):AIO of 32bit */
#define CFG_OR05_PC_IOM_aio_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):AIO of 16bit */
#define CFG_OR05_PC_IOM_aio_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):AIO of 8bit */
#define CFG_OR05_PC_IOM_qb_w                        ((uint32_t)0x00000008)  /*!< Bit Value =(1):QB of 32bit */
#define CFG_OR05_PC_IOM_qb_h0                       ((uint16_t)0x0008)      /*!< Bit Value =(1):QB of 16bit */
#define CFG_OR05_PC_IOM_qb_b0                       ((uint8_t )0x08)        /*!< Bit Value =(1):QB of 8bit */

#define CFG_OR05_EXRST_SEL_mask_w                   ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CFG_OR05_EXRST_SEL_mask_h0                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CFG_OR05_EXRST_SEL_mask_b0                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_OR05_EXRST_SEL_warm_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Warm of 32bit */
#define CFG_OR05_EXRST_SEL_warm_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Warm of 16bit */
#define CFG_OR05_EXRST_SEL_warm_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Warm of 8bit */
#define CFG_OR05_EXRST_SEL_cold_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Cold of 32bit */
#define CFG_OR05_EXRST_SEL_cold_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Cold of 16bit */
#define CFG_OR05_EXRST_SEL_cold_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Cold of 8bit */

#define CFG_OR05_SWD_PIN_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CFG_OR05_SWD_PIN_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_OR05_SWD_PIN_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR05_SWD_PIN_enable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define CFG_OR05_SWD_PIN_enable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define CFG_OR05_SWD_PIN_enable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define CFG_OR05_SWD_PIN_disable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Disable of 32bit */
#define CFG_OR05_SWD_PIN_disable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Disable of 16bit */
#define CFG_OR05_SWD_PIN_disable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Disable of 8bit */

#define CFG_OR05_EXRST_PIN_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CFG_OR05_EXRST_PIN_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_OR05_EXRST_PIN_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR05_EXRST_PIN_enable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define CFG_OR05_EXRST_PIN_enable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define CFG_OR05_EXRST_PIN_enable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define CFG_OR05_EXRST_PIN_disable_w                ((uint32_t)0x00000001)  /*!< Bit Value =(1):Disable of 32bit */
#define CFG_OR05_EXRST_PIN_disable_h0               ((uint16_t)0x0001)      /*!< Bit Value =(1):Disable of 16bit */
#define CFG_OR05_EXRST_PIN_disable_b0               ((uint8_t )0x01)        /*!< Bit Value =(1):Disable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR06  [register's definitions]
 *              Offset[0x28]  CFG option byte register 06 (0x4FF00028)
 ******************************************************************************
 */
///@{
#define CFG_OR06_default                            ((uint32_t)0x000000BF)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR06 */
#define CFG_OR06_XTR_EN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_OR06_XTR_EN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR06_XTR_EN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR06_XTR_EN_disable_w                   ((uint32_t)0x00000000)
#define CFG_OR06_XTR_EN_disable_h0                  ((uint16_t)0x0000)
#define CFG_OR06_XTR_EN_disable_b1                  ((uint8_t )0x00)
#define CFG_OR06_XTR_EN_enable_w                    ((uint32_t)0x00000100)
#define CFG_OR06_XTR_EN_enable_h0                   ((uint16_t)0x0100)
#define CFG_OR06_XTR_EN_enable_b1                   ((uint8_t )0x01)

#define CFG_OR06_UTR_EN_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CFG_OR06_UTR_EN_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CFG_OR06_UTR_EN_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CFG_OR06_UTR_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CFG_OR06_UTR_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CFG_OR06_UTR_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CFG_OR06_UTR_EN_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CFG_OR06_UTR_EN_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CFG_OR06_UTR_EN_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CFG_OR06_UTR_INTV_mask_w                    ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define CFG_OR06_UTR_INTV_mask_h0                   ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CFG_OR06_UTR_INTV_mask_b0                   ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CFG_OR06_UTR_INTV_1ms_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1ms of 32bit */
#define CFG_OR06_UTR_INTV_1ms_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1ms of 16bit */
#define CFG_OR06_UTR_INTV_1ms_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):1ms of 8bit */
#define CFG_OR06_UTR_INTV_8ms_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):8ms of 32bit */
#define CFG_OR06_UTR_INTV_8ms_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):8ms of 16bit */
#define CFG_OR06_UTR_INTV_8ms_b0                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):8ms of 8bit */
#define CFG_OR06_UTR_INTV_4ms_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):4ms of 32bit */
#define CFG_OR06_UTR_INTV_4ms_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):4ms of 16bit */
#define CFG_OR06_UTR_INTV_4ms_b0                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):4ms of 8bit */
#define CFG_OR06_UTR_INTV_2ms_w                     ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):2ms of 32bit */
#define CFG_OR06_UTR_INTV_2ms_h0                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):2ms of 16bit */
#define CFG_OR06_UTR_INTV_2ms_b0                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):2ms of 8bit */

#define CFG_OR06_UTR_OFINE_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CFG_OR06_UTR_OFINE_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CFG_OR06_UTR_OFINE_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CFG_OR06_UTR_OFINE_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CFG_OR06_UTR_OFINE_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CFG_OR06_UTR_OFINE_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CFG_OR06_UTR_OFINE_fine_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Fine of 32bit */
#define CFG_OR06_UTR_OFINE_fine_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Fine of 16bit */
#define CFG_OR06_UTR_OFINE_fine_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Fine of 8bit */

#define CFG_OR06_UTR_RES_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define CFG_OR06_UTR_RES_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CFG_OR06_UTR_RES_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CFG_OR06_UTR_RES_32_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):32 of 32bit */
#define CFG_OR06_UTR_RES_32_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):32 of 16bit */
#define CFG_OR06_UTR_RES_32_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):32 of 8bit */
#define CFG_OR06_UTR_RES_48_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):48 of 32bit */
#define CFG_OR06_UTR_RES_48_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):48 of 16bit */
#define CFG_OR06_UTR_RES_48_b0                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):48 of 8bit */
#define CFG_OR06_UTR_RES_20x_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):20x of 32bit */
#define CFG_OR06_UTR_RES_20x_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(0x2):20x of 16bit */
#define CFG_OR06_UTR_RES_20x_b0                     ((uint8_t )0x02)        /*!< Bit Value =(0x2):20x of 8bit */
#define CFG_OR06_UTR_RES_24x_w                      ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):24x of 32bit */
#define CFG_OR06_UTR_RES_24x_h0                     ((uint16_t)0x0003)      /*!< Bit Value =(0x3):24x of 16bit */
#define CFG_OR06_UTR_RES_24x_b0                     ((uint8_t )0x03)        /*!< Bit Value =(0x3):24x of 8bit */
#define CFG_OR06_UTR_RES_12_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):12 of 32bit */
#define CFG_OR06_UTR_RES_12_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(0x4):12 of 16bit */
#define CFG_OR06_UTR_RES_12_b0                      ((uint8_t )0x04)        /*!< Bit Value =(0x4):12 of 8bit */
#define CFG_OR06_UTR_RES_16_w                       ((uint32_t)0x00000005)  /*!< Bit Value =(0x5):16 of 32bit */
#define CFG_OR06_UTR_RES_16_h0                      ((uint16_t)0x0005)      /*!< Bit Value =(0x5):16 of 16bit */
#define CFG_OR06_UTR_RES_16_b0                      ((uint8_t )0x05)        /*!< Bit Value =(0x5):16 of 8bit */
#define CFG_OR06_UTR_RES_20_w                       ((uint32_t)0x00000006)  /*!< Bit Value =(0x6):20 of 32bit */
#define CFG_OR06_UTR_RES_20_h0                      ((uint16_t)0x0006)      /*!< Bit Value =(0x6):20 of 16bit */
#define CFG_OR06_UTR_RES_20_b0                      ((uint8_t )0x06)        /*!< Bit Value =(0x6):20 of 8bit */
#define CFG_OR06_UTR_RES_24_w                       ((uint32_t)0x00000007)  /*!< Bit Value =(0x7):24 of 32bit */
#define CFG_OR06_UTR_RES_24_h0                      ((uint16_t)0x0007)      /*!< Bit Value =(0x7):24 of 16bit */
#define CFG_OR06_UTR_RES_24_b0                      ((uint8_t )0x07)        /*!< Bit Value =(0x7):24 of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR07  [register's definitions]
 *              Offset[0x2C]  CFG option byte register 07 (0x4FF0002C)
 ******************************************************************************
 */
///@{
#define CFG_OR07_default                            ((uint32_t)0x0000003F)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR07 */
#define CFG_OR07_GF_mask_w                          ((uint32_t)0x0000E000)  /*!< Bit Mask of 32bit */
#define CFG_OR07_GF_mask_h0                         ((uint16_t)0xE000)      /*!< Bit Mask of 16bit */
#define CFG_OR07_GF_mask_b1                         ((uint8_t )0xE0)        /*!< Bit Mask of 8bit */
#define CFG_OR07_GF_disable_w                       ((uint32_t)0x00000000)
#define CFG_OR07_GF_disable_h0                      ((uint16_t)0x0000)
#define CFG_OR07_GF_disable_b1                      ((uint8_t )0x00)
#define CFG_OR07_GF_enable_w                        ((uint32_t)0x00002000)
#define CFG_OR07_GF_enable_h0                       ((uint16_t)0x2000)
#define CFG_OR07_GF_enable_b1                       ((uint8_t )0x20)

#define CFG_OR07_CGIL_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define CFG_OR07_CGIL_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CFG_OR07_CGIL_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CFG_OR07_CGIL_disable_w                     ((uint32_t)0x00000000)
#define CFG_OR07_CGIL_disable_h0                    ((uint16_t)0x0000)
#define CFG_OR07_CGIL_disable_b1                    ((uint8_t )0x00)
#define CFG_OR07_CGIL_enable_w                      ((uint32_t)0x00001000)
#define CFG_OR07_CGIL_enable_h0                     ((uint16_t)0x1000)
#define CFG_OR07_CGIL_enable_b1                     ((uint8_t )0x10)

#define CFG_OR07_DPORDS_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define CFG_OR07_DPORDS_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CFG_OR07_DPORDS_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CFG_OR07_DPORDS_disable_w                   ((uint32_t)0x00000000)
#define CFG_OR07_DPORDS_disable_h0                  ((uint16_t)0x0000)
#define CFG_OR07_DPORDS_disable_b1                  ((uint8_t )0x00)
#define CFG_OR07_DPORDS_enable_w                    ((uint32_t)0x00000800)
#define CFG_OR07_DPORDS_enable_h0                   ((uint16_t)0x0800)
#define CFG_OR07_DPORDS_enable_b1                   ((uint8_t )0x08)

#define CFG_OR07_PORDS_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define CFG_OR07_PORDS_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CFG_OR07_PORDS_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_OR07_PORDS_disable_w                    ((uint32_t)0x00000000)
#define CFG_OR07_PORDS_disable_h0                   ((uint16_t)0x0000)
#define CFG_OR07_PORDS_disable_b1                   ((uint8_t )0x00)
#define CFG_OR07_PORDS_enable_w                     ((uint32_t)0x00000400)
#define CFG_OR07_PORDS_enable_h0                    ((uint16_t)0x0400)
#define CFG_OR07_PORDS_enable_b1                    ((uint8_t )0x04)

#define CFG_OR07_PNDRC_mask_w                       ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CFG_OR07_PNDRC_mask_h0                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CFG_OR07_PNDRC_mask_b1                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR07_PNDRC_disable_w                    ((uint32_t)0x00000000)
#define CFG_OR07_PNDRC_disable_h0                   ((uint16_t)0x0000)
#define CFG_OR07_PNDRC_disable_b1                   ((uint8_t )0x00)
#define CFG_OR07_PNDRC_enable_w                     ((uint32_t)0x00000200)
#define CFG_OR07_PNDRC_enable_h0                    ((uint16_t)0x0200)
#define CFG_OR07_PNDRC_enable_b1                    ((uint8_t )0x02)

#define CFG_OR07_PNDCE_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_OR07_PNDCE_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_OR07_PNDCE_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_OR07_PNDCE_disable_w                    ((uint32_t)0x00000000)
#define CFG_OR07_PNDCE_disable_h0                   ((uint16_t)0x0000)
#define CFG_OR07_PNDCE_disable_b1                   ((uint8_t )0x00)
#define CFG_OR07_PNDCE_enable_w                     ((uint32_t)0x00000100)
#define CFG_OR07_PNDCE_enable_h0                    ((uint16_t)0x0100)
#define CFG_OR07_PNDCE_enable_b1                    ((uint8_t )0x01)

#define CFG_OR07_LVRDS1_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CFG_OR07_LVRDS1_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CFG_OR07_LVRDS1_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CFG_OR07_LVRDS1_disable_w                   ((uint32_t)0x00000000)
#define CFG_OR07_LVRDS1_disable_h0                  ((uint16_t)0x0000)
#define CFG_OR07_LVRDS1_disable_b0                  ((uint8_t )0x00)
#define CFG_OR07_LVRDS1_enable_w                    ((uint32_t)0x00000080)
#define CFG_OR07_LVRDS1_enable_h0                   ((uint16_t)0x0080)
#define CFG_OR07_LVRDS1_enable_b0                   ((uint8_t )0x80)

#define CFG_OR07_LVRDS0_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CFG_OR07_LVRDS0_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CFG_OR07_LVRDS0_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CFG_OR07_LVRDS0_disable_w                   ((uint32_t)0x00000000)
#define CFG_OR07_LVRDS0_disable_h0                  ((uint16_t)0x0000)
#define CFG_OR07_LVRDS0_disable_b0                  ((uint8_t )0x00)
#define CFG_OR07_LVRDS0_enable_w                    ((uint32_t)0x00000040)
#define CFG_OR07_LVRDS0_enable_h0                   ((uint16_t)0x0040)
#define CFG_OR07_LVRDS0_enable_b0                   ((uint8_t )0x40)

#define CFG_OR07_LVRDE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CFG_OR07_LVRDE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CFG_OR07_LVRDE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CFG_OR07_LVRDE_disable_w                    ((uint32_t)0x00000000)
#define CFG_OR07_LVRDE_disable_h0                   ((uint16_t)0x0000)
#define CFG_OR07_LVRDE_disable_b0                   ((uint8_t )0x00)
#define CFG_OR07_LVRDE_enable_w                     ((uint32_t)0x00000020)
#define CFG_OR07_LVRDE_enable_h0                    ((uint16_t)0x0020)
#define CFG_OR07_LVRDE_enable_b0                    ((uint8_t )0x20)

#define CFG_OR07_CG22_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CFG_OR07_CG22_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CFG_OR07_CG22_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_OR07_CG22_disable_w                     ((uint32_t)0x00000000)
#define CFG_OR07_CG22_disable_h0                    ((uint16_t)0x0000)
#define CFG_OR07_CG22_disable_b0                    ((uint8_t )0x00)
#define CFG_OR07_CG22_enable_w                      ((uint32_t)0x00000004)
#define CFG_OR07_CG22_enable_h0                     ((uint16_t)0x0004)
#define CFG_OR07_CG22_enable_b0                     ((uint8_t )0x04)

#define CFG_OR07_CG21_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CFG_OR07_CG21_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_OR07_CG21_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_OR07_CG21_disable_w                     ((uint32_t)0x00000000)
#define CFG_OR07_CG21_disable_h0                    ((uint16_t)0x0000)
#define CFG_OR07_CG21_disable_b0                    ((uint8_t )0x00)
#define CFG_OR07_CG21_enable_w                      ((uint32_t)0x00000002)
#define CFG_OR07_CG21_enable_h0                     ((uint16_t)0x0002)
#define CFG_OR07_CG21_enable_b0                     ((uint8_t )0x02)

///@}
/**
 ******************************************************************************
 * @name        CFG_OR10  [register's definitions]
 *              Offset[0x30]  CFG option byte register 10 (0x4FF00030)
 ******************************************************************************
 */
///@{
#define CFG_OR10_default                            ((uint32_t)0x00000004)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR10 */
#define CFG_OR10_V33_TRM_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define CFG_OR10_V33_TRM_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CFG_OR10_V33_TRM_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CFG_OR10_V33_TRM_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR10_V33_TRM_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR10_V33_TRM_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR11  [register's definitions]
 *              Offset[0x34]  CFG option byte register 11 (0x4FF00034)
 ******************************************************************************
 */
///@{
#define CFG_OR11_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR11 */
#define CFG_OR11_VBG_BTRM_mask_w                    ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define CFG_OR11_VBG_BTRM_mask_h0                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define CFG_OR11_VBG_BTRM_mask_b1                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define CFG_OR11_VBG_BTRM_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CFG_OR11_VBG_BTRM_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR11_VBG_BTRM_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR12  [register's definitions]
 *              Offset[0x38]  CFG option byte register 12 (0x4FF00038)
 ******************************************************************************
 */
///@{
#define CFG_OR12_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR12 */
#define CFG_OR12_LVR_TRM_mask_w                     ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define CFG_OR12_LVR_TRM_mask_h1                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CFG_OR12_LVR_TRM_mask_b2                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CFG_OR12_LVR_TRM_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define CFG_OR12_LVR_TRM_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR12_LVR_TRM_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR12_BOD1_TRM_mask_w                    ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define CFG_OR12_BOD1_TRM_mask_h0                   ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define CFG_OR12_BOD1_TRM_mask_b1                   ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CFG_OR12_BOD1_TRM_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CFG_OR12_BOD1_TRM_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR12_BOD1_TRM_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR12_BOD2_TRM_mask_w                    ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define CFG_OR12_BOD2_TRM_mask_h0                   ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CFG_OR12_BOD2_TRM_mask_b0                   ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CFG_OR12_BOD2_TRM_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR12_BOD2_TRM_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR12_BOD2_TRM_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR13  [register's definitions]
 *              Offset[0x3C]  CFG option byte register 13 (0x4FF0003C)
 ******************************************************************************
 */
///@{
#define CFG_OR13_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR13 */
#define CFG_OR13_IHR1_CTRM_mask_w                   ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define CFG_OR13_IHR1_CTRM_mask_h1                  ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CFG_OR13_IHR1_CTRM_mask_b3                  ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR13_IHR1_CTRM_shift_w                  (24)                    /*!< Bit Shift of 32bit */
#define CFG_OR13_IHR1_CTRM_shift_h1                 (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR13_IHR1_CTRM_shift_b3                 (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR13_IHR1_FTRM_mask_w                   ((uint32_t)0x007F0000)  /*!< Bit Mask of 32bit */
#define CFG_OR13_IHR1_FTRM_mask_h1                  ((uint16_t)0x007F)      /*!< Bit Mask of 16bit */
#define CFG_OR13_IHR1_FTRM_mask_b2                  ((uint8_t )0x7F)        /*!< Bit Mask of 8bit */
#define CFG_OR13_IHR1_FTRM_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define CFG_OR13_IHR1_FTRM_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR13_IHR1_FTRM_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR13_IHR0_CTRM_mask_w                   ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define CFG_OR13_IHR0_CTRM_mask_h0                  ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CFG_OR13_IHR0_CTRM_mask_b1                  ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR13_IHR0_CTRM_shift_w                  (8)                     /*!< Bit Shift of 32bit */
#define CFG_OR13_IHR0_CTRM_shift_h0                 (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR13_IHR0_CTRM_shift_b1                 (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR13_IHR0_FTRM_mask_w                   ((uint32_t)0x0000007F)  /*!< Bit Mask of 32bit */
#define CFG_OR13_IHR0_FTRM_mask_h0                  ((uint16_t)0x007F)      /*!< Bit Mask of 16bit */
#define CFG_OR13_IHR0_FTRM_mask_b0                  ((uint8_t )0x7F)        /*!< Bit Mask of 8bit */
#define CFG_OR13_IHR0_FTRM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR13_IHR0_FTRM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR13_IHR0_FTRM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR14  [register's definitions]
 *              Offset[0x40]  CFG option byte register 14 (0x4FF00040)
 ******************************************************************************
 */
///@{
#define CFG_OR14_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR14 */
#define CFG_OR14_IHR_BGTI_mask_w                    ((uint32_t)0x0000E000)  /*!< Bit Mask of 32bit */
#define CFG_OR14_IHR_BGTI_mask_h0                   ((uint16_t)0xE000)      /*!< Bit Mask of 16bit */
#define CFG_OR14_IHR_BGTI_mask_b1                   ((uint8_t )0xE0)        /*!< Bit Mask of 8bit */
#define CFG_OR14_IHR_BGTI_shift_w                   (13)                    /*!< Bit Shift of 32bit */
#define CFG_OR14_IHR_BGTI_shift_h0                  (13)                    /*!< Bit Shift of 16bit */
#define CFG_OR14_IHR_BGTI_shift_b1                  (5)                     /*!< Bit Shift of 8bit */

#define CFG_OR14_IHR_BGTV_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define CFG_OR14_IHR_BGTV_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define CFG_OR14_IHR_BGTV_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define CFG_OR14_IHR_BGTV_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define CFG_OR14_IHR_BGTV_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR14_IHR_BGTV_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR14_ILR_TRM_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CFG_OR14_ILR_TRM_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CFG_OR14_ILR_TRM_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CFG_OR14_ILR_TRM_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR14_ILR_TRM_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR14_ILR_TRM_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR16  [register's definitions]
 *              Offset[0x48]  CFG option byte register 16 (0x4FF00048)
 ******************************************************************************
 */
///@{
#define CFG_OR16_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR16 */
#define CFG_OR16_TEMP_CAL1_mask_w                   ((uint32_t)0x0FFF0000)  /*!< Bit Mask of 32bit */
#define CFG_OR16_TEMP_CAL1_mask_h1                  ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define CFG_OR16_TEMP_CAL1_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define CFG_OR16_TEMP_CAL1_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR16_TEMP_CAL1_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR16_TEMP_CAL0_mask_w                   ((uint32_t)0x00000FFF)  /*!< Bit Mask of 32bit */
#define CFG_OR16_TEMP_CAL0_mask_h0                  ((uint16_t)0x0FFF)      /*!< Bit Mask of 16bit */
#define CFG_OR16_TEMP_CAL0_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR16_TEMP_CAL0_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR16_TEMP_CAL0_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_OR17  [register's definitions]
 *              Offset[0x4C]  CFG option byte register 17 (0x4FF0004C)
 ******************************************************************************
 */
///@{
#define CFG_OR17_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_OR17 */
#define CFG_OR17_ADC_OFFT_mask_w                    ((uint32_t)0x1F000000)  /*!< Bit Mask of 32bit */
#define CFG_OR17_ADC_OFFT_mask_h1                   ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define CFG_OR17_ADC_OFFT_mask_b3                   ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define CFG_OR17_ADC_OFFT_shift_w                   (24)                    /*!< Bit Shift of 32bit */
#define CFG_OR17_ADC_OFFT_shift_h1                  (8)                     /*!< Bit Shift of 16bit */
#define CFG_OR17_ADC_OFFT_shift_b3                  (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR17_IVR_TRM_mask_w                     ((uint32_t)0x001F0000)  /*!< Bit Mask of 32bit */
#define CFG_OR17_IVR_TRM_mask_h1                    ((uint16_t)0x001F)      /*!< Bit Mask of 16bit */
#define CFG_OR17_IVR_TRM_mask_b2                    ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define CFG_OR17_IVR_TRM_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define CFG_OR17_IVR_TRM_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR17_IVR_TRM_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define CFG_OR17_LDO_TRM_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define CFG_OR17_LDO_TRM_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CFG_OR17_LDO_TRM_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CFG_OR17_LDO_TRM_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CFG_OR17_LDO_TRM_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CFG_OR17_LDO_TRM_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_TST0  [register's definitions]
 *              Offset[0x60]  CFG Test register 0 (not load from flash memory) (0x4FF00060)
 ******************************************************************************
 */
///@{
#define CFG_TST0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_TST0 */
#define CFG_TST0_PNDF_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CFG_TST0_PNDF_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CFG_TST0_PNDF_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CFG_TST0_PNDF_shift_w                       (6)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_PNDF_shift_h0                      (6)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_PNDF_shift_b0                      (6)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_DBLVRF_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define CFG_TST0_DBLVRF_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define CFG_TST0_DBLVRF_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CFG_TST0_DBLVRF_shift_w                     (5)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_DBLVRF_shift_h0                    (5)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_DBLVRF_shift_b0                    (5)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_LVRF0_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CFG_TST0_LVRF0_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CFG_TST0_LVRF0_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CFG_TST0_LVRF0_shift_w                      (4)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_LVRF0_shift_h0                     (4)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_LVRF0_shift_b0                     (4)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_DPORF_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CFG_TST0_DPORF_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CFG_TST0_DPORF_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CFG_TST0_DPORF_shift_w                      (3)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_DPORF_shift_h0                     (3)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_DPORF_shift_b0                     (3)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_POF2_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CFG_TST0_POF2_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CFG_TST0_POF2_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_TST0_POF2_shift_w                       (2)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_POF2_shift_h0                      (2)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_POF2_shift_b0                      (2)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_POF1_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CFG_TST0_POF1_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_TST0_POF1_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_TST0_POF1_shift_w                       (1)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_POF1_shift_h0                      (1)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_POF1_shift_b0                      (1)                     /*!< Bit Shift of 8bit */

#define CFG_TST0_POF0_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CFG_TST0_POF0_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_TST0_POF0_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST0_POF0_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define CFG_TST0_POF0_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define CFG_TST0_POF0_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CFG_TST1  [register's definitions]
 *              Offset[0x64]  CFG Test register 2 (not load from flash memory) (0x4FF00064)
 ******************************************************************************
 */
///@{
#define CFG_TST1_default                            ((uint32_t)0x00040000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_TST1 */
#define CFG_TST1_TST_PCTL_mask_w                    ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_TST_PCTL_mask_h1                   ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CFG_TST1_TST_PCTL_mask_b3                   ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CFG_TST1_TST_PCTL_shift_w                   (30)                    /*!< Bit Shift of 32bit */
#define CFG_TST1_TST_PCTL_shift_h1                  (14)                    /*!< Bit Shift of 16bit */
#define CFG_TST1_TST_PCTL_shift_b3                  (6)                     /*!< Bit Shift of 8bit */

#define CFG_TST1_PCTL_SEL_mask_w                    ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_PCTL_SEL_mask_h1                   ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define CFG_TST1_PCTL_SEL_mask_b3                   ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define CFG_TST1_PCTL_SEL_or_w                      ((uint32_t)0x00000000)
#define CFG_TST1_PCTL_SEL_or_h1                     ((uint16_t)0x0000)
#define CFG_TST1_PCTL_SEL_or_b3                     ((uint8_t )0x00)
#define CFG_TST1_PCTL_SEL_tst_w                     ((uint32_t)0x20000000)
#define CFG_TST1_PCTL_SEL_tst_h1                    ((uint16_t)0x2000)
#define CFG_TST1_PCTL_SEL_tst_b3                    ((uint8_t )0x20)

#define CFG_TST1_PCKI_SEL_mask_w                    ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_PCKI_SEL_mask_h1                   ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CFG_TST1_PCKI_SEL_mask_b3                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CFG_TST1_PCKI_SEL_int_w                     ((uint32_t)0x00000000)
#define CFG_TST1_PCKI_SEL_int_h1                    ((uint16_t)0x0000)
#define CFG_TST1_PCKI_SEL_int_b3                    ((uint8_t )0x00)
#define CFG_TST1_PCKI_SEL_ext_w                     ((uint32_t)0x10000000)
#define CFG_TST1_PCKI_SEL_ext_h1                    ((uint16_t)0x1000)
#define CFG_TST1_PCKI_SEL_ext_b3                    ((uint8_t )0x10)

#define CFG_TST1_PLL_GOFF_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_PLL_GOFF_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CFG_TST1_PLL_GOFF_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_TST1_PLL_GOFF_disable_w                 ((uint32_t)0x00000000)
#define CFG_TST1_PLL_GOFF_disable_h1                ((uint16_t)0x0000)
#define CFG_TST1_PLL_GOFF_disable_b3                ((uint8_t )0x00)
#define CFG_TST1_PLL_GOFF_enable_w                  ((uint32_t)0x02000000)
#define CFG_TST1_PLL_GOFF_enable_h1                 ((uint16_t)0x0200)
#define CFG_TST1_PLL_GOFF_enable_b3                 ((uint8_t )0x02)

#define CFG_TST1_PLL_TST_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_PLL_TST_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_TST1_PLL_TST_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST1_PLL_TST_disable_w                  ((uint32_t)0x00000000)
#define CFG_TST1_PLL_TST_disable_h1                 ((uint16_t)0x0000)
#define CFG_TST1_PLL_TST_disable_b3                 ((uint8_t )0x00)
#define CFG_TST1_PLL_TST_enable_w                   ((uint32_t)0x01000000)
#define CFG_TST1_PLL_TST_enable_h1                  ((uint16_t)0x0100)
#define CFG_TST1_PLL_TST_enable_b3                  ((uint8_t )0x01)

#define CFG_TST1_ILRCO_EN_mask_w                    ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_ILRCO_EN_mask_h1                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CFG_TST1_ILRCO_EN_mask_b2                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CFG_TST1_ILRCO_EN_disable_w                 ((uint32_t)0x00000000)
#define CFG_TST1_ILRCO_EN_disable_h1                ((uint16_t)0x0000)
#define CFG_TST1_ILRCO_EN_disable_b2                ((uint8_t )0x00)
#define CFG_TST1_ILRCO_EN_enable_w                  ((uint32_t)0x00040000)
#define CFG_TST1_ILRCO_EN_enable_h1                 ((uint16_t)0x0004)
#define CFG_TST1_ILRCO_EN_enable_b2                 ((uint8_t )0x04)

#define CFG_TST1_ILRCK_OE_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_ILRCK_OE_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CFG_TST1_ILRCK_OE_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_TST1_ILRCK_OE_disable_w                 ((uint32_t)0x00000000)
#define CFG_TST1_ILRCK_OE_disable_h1                ((uint16_t)0x0000)
#define CFG_TST1_ILRCK_OE_disable_b2                ((uint8_t )0x00)
#define CFG_TST1_ILRCK_OE_enable_w                  ((uint32_t)0x00020000)
#define CFG_TST1_ILRCK_OE_enable_h1                 ((uint16_t)0x0002)
#define CFG_TST1_ILRCK_OE_enable_b2                 ((uint8_t )0x02)

#define CFG_TST1_IHRCK_OE_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CFG_TST1_IHRCK_OE_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_TST1_IHRCK_OE_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST1_IHRCK_OE_disable_w                 ((uint32_t)0x00000000)
#define CFG_TST1_IHRCK_OE_disable_h1                ((uint16_t)0x0000)
#define CFG_TST1_IHRCK_OE_disable_b2                ((uint8_t )0x00)
#define CFG_TST1_IHRCK_OE_enable_w                  ((uint32_t)0x00010000)
#define CFG_TST1_IHRCK_OE_enable_h1                 ((uint16_t)0x0001)
#define CFG_TST1_IHRCK_OE_enable_b2                 ((uint8_t )0x01)

#define CFG_TST1_LVR_DIS_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CFG_TST1_LVR_DIS_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CFG_TST1_LVR_DIS_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CFG_TST1_LVR_DIS_enable_w                   ((uint32_t)0x00000000)
#define CFG_TST1_LVR_DIS_enable_h0                  ((uint16_t)0x0000)
#define CFG_TST1_LVR_DIS_enable_b1                  ((uint8_t )0x00)
#define CFG_TST1_LVR_DIS_disable_w                  ((uint32_t)0x00000200)
#define CFG_TST1_LVR_DIS_disable_h0                 ((uint16_t)0x0200)
#define CFG_TST1_LVR_DIS_disable_b1                 ((uint8_t )0x02)

#define CFG_TST1_BOD_OE_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_TST1_BOD_OE_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_TST1_BOD_OE_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST1_BOD_OE_disable_w                   ((uint32_t)0x00000000)
#define CFG_TST1_BOD_OE_disable_h0                  ((uint16_t)0x0000)
#define CFG_TST1_BOD_OE_disable_b1                  ((uint8_t )0x00)
#define CFG_TST1_BOD_OE_enable_w                    ((uint32_t)0x00000100)
#define CFG_TST1_BOD_OE_enable_h0                   ((uint16_t)0x0100)
#define CFG_TST1_BOD_OE_enable_b1                   ((uint8_t )0x01)

#define CFG_TST1_FTSTO_mask_w                       ((uint32_t)0x0000007C)  /*!< Bit Mask of 32bit */
#define CFG_TST1_FTSTO_mask_h0                      ((uint16_t)0x007C)      /*!< Bit Mask of 16bit */
#define CFG_TST1_FTSTO_mask_b0                      ((uint8_t )0x7C)        /*!< Bit Mask of 8bit */
#define CFG_TST1_FTSTO_pc0_w                        ((uint32_t)0x00000000)
#define CFG_TST1_FTSTO_pc0_h0                       ((uint16_t)0x0000)
#define CFG_TST1_FTSTO_pc0_b0                       ((uint8_t )0x00)
#define CFG_TST1_FTSTO_rc32k_w                      ((uint32_t)0x00000004)
#define CFG_TST1_FTSTO_rc32k_h0                     ((uint16_t)0x0004)
#define CFG_TST1_FTSTO_rc32k_b0                     ((uint8_t )0x04)
#define CFG_TST1_FTSTO_bod1_w                       ((uint32_t)0x00000008)
#define CFG_TST1_FTSTO_bod1_h0                      ((uint16_t)0x0008)
#define CFG_TST1_FTSTO_bod1_b0                      ((uint8_t )0x08)
#define CFG_TST1_FTSTO_bod0_w                       ((uint32_t)0x0000000C)
#define CFG_TST1_FTSTO_bod0_h0                      ((uint16_t)0x000C)
#define CFG_TST1_FTSTO_bod0_b0                      ((uint8_t )0x0C)
#define CFG_TST1_FTSTO_ilrco_w                      ((uint32_t)0x00000010)
#define CFG_TST1_FTSTO_ilrco_h0                     ((uint16_t)0x0010)
#define CFG_TST1_FTSTO_ilrco_b0                     ((uint8_t )0x10)
#define CFG_TST1_FTSTO_ihrco_w                      ((uint32_t)0x00000014)
#define CFG_TST1_FTSTO_ihrco_h0                     ((uint16_t)0x0014)
#define CFG_TST1_FTSTO_ihrco_b0                     ((uint8_t )0x14)
#define CFG_TST1_FTSTO_pll_w                        ((uint32_t)0x00000018)
#define CFG_TST1_FTSTO_pll_h0                       ((uint16_t)0x0018)
#define CFG_TST1_FTSTO_pll_b0                       ((uint8_t )0x18)
#define CFG_TST1_FTSTO_ac0_w                        ((uint32_t)0x00000020)
#define CFG_TST1_FTSTO_ac0_h0                       ((uint16_t)0x0020)
#define CFG_TST1_FTSTO_ac0_b0                       ((uint8_t )0x20)
#define CFG_TST1_FTSTO_ac1_w                        ((uint32_t)0x00000024)
#define CFG_TST1_FTSTO_ac1_h0                       ((uint16_t)0x0024)
#define CFG_TST1_FTSTO_ac1_b0                       ((uint8_t )0x24)
#define CFG_TST1_FTSTO_pc14_in_w                    ((uint32_t)0x00000030)
#define CFG_TST1_FTSTO_pc14_in_h0                   ((uint16_t)0x0030)
#define CFG_TST1_FTSTO_pc14_in_b0                   ((uint8_t )0x30)
#define CFG_TST1_FTSTO_bmi_tmcko0_w                 ((uint32_t)0x00000034)
#define CFG_TST1_FTSTO_bmi_tmcko0_h0                ((uint16_t)0x0034)
#define CFG_TST1_FTSTO_bmi_tmcko0_b0                ((uint8_t )0x34)
#define CFG_TST1_FTSTO_bmi_tmcko1_w                 ((uint32_t)0x00000038)
#define CFG_TST1_FTSTO_bmi_tmcko1_h0                ((uint16_t)0x0038)
#define CFG_TST1_FTSTO_bmi_tmcko1_b0                ((uint8_t )0x38)
#define CFG_TST1_FTSTO_bod2_w                       ((uint32_t)0x0000003C)
#define CFG_TST1_FTSTO_bod2_h0                      ((uint16_t)0x003C)
#define CFG_TST1_FTSTO_bod2_b0                      ((uint8_t )0x3C)

#define CFG_TST1_FLH_WE_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CFG_TST1_FLH_WE_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CFG_TST1_FLH_WE_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST1_FLH_WE_disable_w                   ((uint32_t)0x00000000)
#define CFG_TST1_FLH_WE_disable_h0                  ((uint16_t)0x0000)
#define CFG_TST1_FLH_WE_disable_b0                  ((uint8_t )0x00)
#define CFG_TST1_FLH_WE_enable_w                    ((uint32_t)0x00000001)
#define CFG_TST1_FLH_WE_enable_h0                   ((uint16_t)0x0001)
#define CFG_TST1_FLH_WE_enable_b0                   ((uint8_t )0x01)

///@}
/**
 ******************************************************************************
 * @name        CFG_TST2  [register's definitions]
 *              Offset[0x68]  CFG Test register 2 (not load from flash memory) (0x4FF00068)
 ******************************************************************************
 */
///@{
#define CFG_TST2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CFG_TST2 */
#define CFG_TST2_IOCHAIN_EN_mask_w                  ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CFG_TST2_IOCHAIN_EN_mask_h0                 ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CFG_TST2_IOCHAIN_EN_mask_b1                 ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CFG_TST2_IOCHAIN_EN_disable_w               ((uint32_t)0x00000000)
#define CFG_TST2_IOCHAIN_EN_disable_h0              ((uint16_t)0x0000)
#define CFG_TST2_IOCHAIN_EN_disable_b1              ((uint8_t )0x00)
#define CFG_TST2_IOCHAIN_EN_enable_w                ((uint32_t)0x00000100)
#define CFG_TST2_IOCHAIN_EN_enable_h0               ((uint16_t)0x0100)
#define CFG_TST2_IOCHAIN_EN_enable_b1               ((uint8_t )0x01)

#define CFG_TST2_EXPHY_EN_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CFG_TST2_EXPHY_EN_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CFG_TST2_EXPHY_EN_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CFG_TST2_EXPHY_EN_internal_w                ((uint32_t)0x00000000)
#define CFG_TST2_EXPHY_EN_internal_h0               ((uint16_t)0x0000)
#define CFG_TST2_EXPHY_EN_internal_b0               ((uint8_t )0x00)
#define CFG_TST2_EXPHY_EN_external_w                ((uint32_t)0x00000008)
#define CFG_TST2_EXPHY_EN_external_h0               ((uint16_t)0x0008)
#define CFG_TST2_EXPHY_EN_external_b0               ((uint8_t )0x08)

#define CFG_TST2_EXPHY_SEL_mask_w                   ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define CFG_TST2_EXPHY_SEL_mask_h0                  ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define CFG_TST2_EXPHY_SEL_mask_b0                  ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CFG_TST2_EXPHY_SEL_jz244_w                  ((uint32_t)0x00000000)
#define CFG_TST2_EXPHY_SEL_jz244_h0                 ((uint16_t)0x0000)
#define CFG_TST2_EXPHY_SEL_jz244_b0                 ((uint8_t )0x00)
#define CFG_TST2_EXPHY_SEL_fa205_w                  ((uint32_t)0x00000001)
#define CFG_TST2_EXPHY_SEL_fa205_h0                 ((uint16_t)0x0001)
#define CFG_TST2_EXPHY_SEL_fa205_b0                 ((uint8_t )0x01)
#define CFG_TST2_EXPHY_SEL_stusb03e_w               ((uint32_t)0x00000002)
#define CFG_TST2_EXPHY_SEL_stusb03e_h0              ((uint16_t)0x0002)
#define CFG_TST2_EXPHY_SEL_stusb03e_b0              ((uint8_t )0x02)

///@}

#endif  // _MG32_CFG_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_CFG.h                           */
/*----------------------------------------------------------------------------*/
