

/**
 ******************************************************************************
 *
 * @file        TH222x_11_RCServoMotor.c
 * @brief       This is to test TH222x RC Servo Motor (SG90) C file.
                
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_11_RCServoMotor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TH222x_RCSERVOMOTOR_PULSEWIDTH_MIN    100           /*!< Max pulse width is 2ms.*/
#define TH222x_RCSERVOMOTOR_PULSEWIDTH_MAX    200           /*!< Min pulse width is 1ms.*/
#define TH222x_RCSERVOMOTOR_PULSEWIDTH_RANGE  2

#define TH222x_RCSERVOMOTOR_DIRECT_NEG        0
#define TH222x_RCSERVOMOTOR_DIRECT_POS        1

/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_RCServoMotor_UpdateFlag;                     // UpdateFlag=0 (Nothing)    
                                                            // UpdateFlag=1 (Needs to do ...)
                                                            
static uint32_t TH222x_RCServoMotor_DramaTime;              // Drama Time counter : (0~TH222x_RCServoMotor_DramaTimeMax)
static uint32_t TH222x_RCServoMotor_DramaTimeMax;           // The maximum of TH222x_RCServoMotor_DramaTime.

static uint8_t TH222x_RCServoMotor_PulseWidth;              // This pulse width controls Sevro angle.

static uint8_t TH222x_RCServoMotor_Direct;                  // There are two directions. {TH222x_RCSERVOMOTOR_DIRECT_NEG, TH222x_RCSERVOMOTOR_DIRECT_POS}

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	 TH222x RC Servo Motor parameter default initial.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_RCServoMotorParameter_DeInit(void)
{
    // ------------------------------------------------------------------------
    TH222x_RCServoMotor_UpdateFlag   = 0;                   // No update event
    
    TH222x_RCServoMotor_DramaTime    = 0;                   // Drama time counter    
    TH222x_RCServoMotor_DramaTimeMax = 10;
    
    TH222x_RCServoMotor_PulseWidth   = TH222x_RCSERVOMOTOR_PULSEWIDTH_MIN;  // 100
    TH222x_RCServoMotor_Direct       = TH222x_RCSERVOMOTOR_DIRECT_POS;      // 1
    
    // ------------------------------------------------------------------------
    // change PWM pulse width
    BSP_RCServoMotor_ChangePulseWidth(TH222x_RCServoMotor_PulseWidth);
    
}
/**
 *******************************************************************************
 * @brief	 TH222x RC Servo Motor main function.   
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_RCServoMotor(void)
{
    
    // ------------------------------------------------------------------------
    // Condition is TH222x_RCServoMotor_UpdateFlag=1.
    // ------------------------------------------------------------------------
    if(TH222x_RCServoMotor_UpdateFlag==0)
    {
        TH222x_RCServoMotor_UpdateFlag = 0;
        return;
    }
    
    // ------------------------------------------------------------------------
    TH222x_RCServoMotor_UpdateFlag = 0;
    
    // ------------------------------------------------------------------------
    // TH222x_RCServoMotor_DramaTime index (0~TH222x_RCServoMotor_DramaTimeMax)
    // ------------------------------------------------------------------------
    if(TH222x_RCServoMotor_DramaTime < TH222x_RCServoMotor_DramaTimeMax)
    {
        TH222x_RCServoMotor_DramaTime = TH222x_RCServoMotor_DramaTime + 1;
        return;
    }
    
    // ------------------------------------------------------------------------
    TH222x_RCServoMotor_DramaTime = 0;
    
    // ------------------------------------------------------------------------
    // Clockwise
    // ------------------------------------------------------------------------    
    if(TH222x_RCServoMotor_Direct == TH222x_RCSERVOMOTOR_DIRECT_POS)
    {
        if(TH222x_RCServoMotor_PulseWidth < TH222x_RCSERVOMOTOR_PULSEWIDTH_MAX)
        {
            TH222x_RCServoMotor_PulseWidth = TH222x_RCServoMotor_PulseWidth + TH222x_RCSERVOMOTOR_PULSEWIDTH_RANGE; // Duty cycle += 2
        }
        else
        {
            TH222x_RCServoMotor_PulseWidth = TH222x_RCServoMotor_PulseWidth - TH222x_RCSERVOMOTOR_PULSEWIDTH_RANGE; // Duty cycle -= 2
            TH222x_RCServoMotor_Direct     = TH222x_RCSERVOMOTOR_DIRECT_NEG;    // Change direct
        }
    }
    // ------------------------------------------------------------------------
    // Anticlockwise
    // ------------------------------------------------------------------------    
    else
    {
        if(TH222x_RCServoMotor_PulseWidth > TH222x_RCSERVOMOTOR_PULSEWIDTH_MIN)
        {
            TH222x_RCServoMotor_PulseWidth = TH222x_RCServoMotor_PulseWidth - TH222x_RCSERVOMOTOR_PULSEWIDTH_RANGE; // Duty cycle -= 2
        }
        else
        {
            TH222x_RCServoMotor_PulseWidth = TH222x_RCServoMotor_PulseWidth + TH222x_RCSERVOMOTOR_PULSEWIDTH_RANGE; // Duty cycle += 2
            TH222x_RCServoMotor_Direct     = TH222x_RCSERVOMOTOR_DIRECT_POS;    // Change direct
        }
    }
    
    // ------------------------------------------------------------------------
    // change PWM pulse width
    // ------------------------------------------------------------------------
    BSP_RCServoMotor_ChangePulseWidth(TH222x_RCServoMotor_PulseWidth);
    
}





