
/**
 ******************************************************************************
 *
 * @file        TH222x_10_Buzzer.c
 * @brief       This is to test TH222x Buzzer C file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/02/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "TH222x_Global.h"
#include "BSP_10_Buzzer.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t TH222x_Buzzer_UpdateFlag;                           // UpdateFlag=0 (Nothing)    
                                                            // UpdateFlag=1 (Needs to do ...)

uint8_t TH222x_Buzzer_ONFlag;                               /*!< Turn On/Off Buzzer.1=Turn On, 0=Turn Off */

uint8_t TH222x_Buzzer_ONCount;                              /*!< Control Buzzer sound time. */


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	 TH222x Buzzer parameter default initial.  
 * @details     
 * @return      
 * @note       
 *******************************************************************************
 */
void TH222x_BuzzerParameter_DeInit(void)
{
    // ------------------------------------------------------------------------
    TH222x_Buzzer_UpdateFlag = 0;                           // Clear TH222x_Buzzer_UpdateFlag.
    
    // ------------------------------------------------------------------------
    TH222x_Buzzer_ONFlag     = 0;                           // Buzzer ON/OFF flag.
    TH222x_Buzzer_ONCount    = 0;                           // Just counter (for TH222x_main.c)
                        
    // ------------------------------------------------------------------------
    BSP_Buzzer_Cmd(DISABLE);                                // Disable buzzer
}    
/**
 *******************************************************************************
 * @brief	    TH222x Buzzer main function.  
 * @details     
 * @return      None  
 *******************************************************************************
 */
void TH222x_Buzzer(void)
{
    // ------------------------------------------------------------------------
    // Condition TH222x_Buzzer_UpdateFlag=1
    if(TH222x_Buzzer_UpdateFlag == 0)
        return;
    
    // ------------------------------------------------------------------------
    TH222x_Buzzer_UpdateFlag = 0;
    
    // ------------------------------------------------------------------------
    // Control buzzer ON/OFF through TH222x_Buzzer_ONFlag
    // ------------------------------------------------------------------------
    if(TH222x_Buzzer_ONFlag == 0)
        BSP_Buzzer_Cmd(DISABLE);
    else
        BSP_Buzzer_Cmd(ENABLE);
    
}



