/**
 *******************************************************************************
 *
 * @file        MG32_APB_Init.c
 *
 * @brief       The APB initial code C file 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2023/04/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_APB.h"
#include "MG32_APB_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            MID_OBMx_HandleTypeDef   mOBMx;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        MID_OBMx_HandleTypeDef   mOBMx;
    #endif
    // ------------------------------------------------------------------------
#endif
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief  	    Initialized APB module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void APB_Init(void)
{

    /* APB CR0 (IR) initial wizard */
    #if (CONF_APB_CR0 != 0)
        APB->CR0.W  = APB->CR0.W | (CONF_APB_CR0 & 0x00FF0000);
    #endif
    
    /* APB CR2 (ITR6/7) initial wizard */
    #if (CONF_APB_CR2 != 0)
        APB->CR2.W  = CONF_APB_CR2;
    #endif
    
    /* APB OBM0 initial wizard */
    #if defined(CONF_APB_OBM00)
        #if (CONF_APB_OBM01 != 0) 
            APB->OBM00.W  = CONF_APB_OBM00;
            APB->OBM01.W  = CONF_APB_OBM01;
        #endif
    #endif

    /* APB OBM1 initial wizard */
    #if defined(CONF_APB_OBM10)
        #if (CONF_APB_OBM11 != 0) 
            APB->OBM10.W  = CONF_APB_OBM10;
            APB->OBM11.W  = CONF_APB_OBM11;
        #endif
    #endif

    /* APB NCO initial wizard */
    #if defined(CONF_APB_NCO00)
        #if ((CONF_APB_NCO00 & 0x01000000 )!= 0x00000000)       // NCO0_EN = 0x01000000
            APB->NCO01.W  = CONF_APB_NCO01;
            APB->NCO00.W  = (CONF_APB_NCO00 & 0xFFF00000) | (CONF_APB_NCO01 & 0x000FFFFF);
        #endif
    #endif

    // ------------------------------------------------------------------------
    // Config mOBMx structure within Middleware level
    // ------------------------------------------------------------------------
    #if defined(IRQHandler_Middleware_Level_)       
        // (for OBM0)----------------------------------------------------------
        #if defined(CONF_APB_OBM00)
            #if (CONF_APB_OBM01 != 0) 
                mOBMx.Instance                  = OBM0;
                mOBMx.Init.OBMxMode             = mOBM0_OBMxMode_Select;
                mOBMx.Init.BKS0Src              = mOBM0_BKS0Src_Select;
                mOBMx.Init.BKS0Polarity         = mOBM0_BKS0Polarity_Select;
                mOBMx.Init.BKS1Src              = mOBM0_BKS1Src_Select;
                mOBMx.Init.BKS1Polarity         = mOBM0_BKS1Polarity_Select;
                mOBMx.Init.BKS2Src              = mOBM0_BKS2Src_Select;
                mOBMx.Init.BKS2Polarity         = mOBM0_BKS2Polarity_Select;
                mOBMx.Init.OutChannel0Src       = mOBM0_OutChannel0Src_Select;
                mOBMx.Init.OutChannel0Polarity  = mOBM0_OutChannel0Polarity_Select;
                mOBMx.Init.OutChannel1Src       = mOBM0_OutChannel1Src_Select;
                mOBMx.Init.OutChannel1Polarity  = mOBM0_OutChannel0Polarity_Select;
                mOBMx.Init.OBMxOutPolarity      = mOBM0_OBMxOutPolarity_Select;
                mOBMx.Init.SyncFilter           = mOBM0_SyncFilter_Select;
                mOBMx.Init.InitSTAState         = APB_OBM_INITSTA_HIGH;
            #endif
       #endif
        // MID_OBMx_Init(&mOBMx);
        
        // (for OBM1)----------------------------------------------------------
        #if defined(CONF_APB_OBM10)
            #if (CONF_APB_OBM11 != 0) 
                mOBMx.Instance                  = OBM1;
                mOBMx.Init.OBMxMode             = mOBM1_OBMxMode_Select;
                mOBMx.Init.BKS0Src              = mOBM1_BKS0Src_Select;
                mOBMx.Init.BKS0Polarity         = mOBM1_BKS0Polarity_Select;
                mOBMx.Init.BKS1Src              = mOBM1_BKS1Src_Select;
                mOBMx.Init.BKS1Polarity         = mOBM1_BKS1Polarity_Select;
                mOBMx.Init.BKS2Src              = mOBM1_BKS2Src_Select;
                mOBMx.Init.BKS2Polarity         = mOBM1_BKS2Polarity_Select;
                mOBMx.Init.OutChannel0Src       = mOBM1_OutChannel0Src_Select;
                mOBMx.Init.OutChannel0Polarity  = mOBM1_OutChannel0Polarity_Select;
                mOBMx.Init.OutChannel1Src       = mOBM1_OutChannel1Src_Select;
                mOBMx.Init.OutChannel1Polarity  = mOBM1_OutChannel1Polarity_Select;
                mOBMx.Init.OBMxOutPolarity      = mOBM1_OBMxOutPolarity_Select;
                mOBMx.Init.SyncFilter           = mOBM1_SyncFilter_Select;
                mOBMx.Init.InitSTAState         = APB_OBM_INITSTA_HIGH;
            #endif
        #endif
        // MID_OBMx_Init(&mOBMx);
    #endif

}


