/**
 *******************************************************************************
 *
 * @file        MG32_RTC_Init.c
 *
 * @brief       The RTC initial code C file
 *
 * @par         Project
 *              MG32
 * @version     V1.06
 * @date        2023/05/30
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_RTC_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            RTC_HandleTypeDef        mRTC;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        RTC_HandleTypeDef        mRTC;
    #endif
    // ------------------------------------------------------------------------
#endif
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       initialized RTC module.
 * @details  
 * @param[in]   RTC_Init:
 * 	@arg\b      Use keil wizard define table index..
 * @return      
 * @note
 * @par         Example
 * @code
                RTC_Init();
 * @endcode
 *******************************************************************************
 */
void RTC_Init(void)
{
#if ((CONF_RTC_EN&0x00000001)==0x00000001)
    
    // RTC module register unlocked.
    RTC->KEY.MBIT.KEY = 0xA217;
    
    // RTC input clock & divider select.
    RTC->CLK.W = (CONF_RTC_CK_SEL|  \
                  CONF_RTC_CK_DIV|  \
                  CONF_RTC_CK_PDIV);
    
    // RTC interrupt event enable.
    RTC->INT.W = CONF_RTC_INT;
    
    // Set RTC Control Register Value.
    RTC->CR0.W = CONF_RTC_CR0;
    
    // RTC Reload Value Set.
    RTC->RLR.W = CONF_RTC_RLR;
    
    // RTC Count Value Set.
    RTC->CR0.B[0] &= ~RTC_CR0_RCR_MDS_mask_b0;
    RTC->CR0.B[0] |= RTC_CR0_RCR_MDS_forced_reload_b0;
    RTC->CR1.MBIT.RC_START = 1;
    while(RTC->STA.MBIT.RCRF==0);
    RTC->STA.B[0] |= RTC_STA_RCRF_happened_b0;
    RTC->CR0.B[0] &= ~RTC_CR0_RCR_MDS_mask_b0;
    RTC->CR0.B[0] |= RTC_CR0_RCR_MDS_auto_reload_b0;
    
    // Interrupt enable check
    #if (CONF_RTC_INT != 0)
        PW->KEY.MBIT.KEY = 0xA217;
        SYS->INT.MBIT.IEA = 1;                  // Enable System module all interrupt.
        PW->KEY.MBIT.KEY = 0x712A;
    #endif
    
    // Wake up enable check
    if((RTC->CR0.W&(RTC_CR0_TF_WPEN_mask_w|RTC_CR0_PC_WPEN_mask_w|RTC_CR0_ALM_WPEN_mask_w))!=DISABLE)
    {
        // CSC module register unlocked.
        CSC->KEY.MBIT.KEY = 0xA217;
        CSC->SLP0.MBIT.SLP_RTC = 1;             // Enable RTC clock at SLEEP mode
        CSC->STP0.MBIT.STP_RTC = 1;             // Enable RTC clock at STOP mode
        // CSC module register locked.
        CSC->KEY.MBIT.KEY = 0x217A;
    }
    
    // Alarm Enable Check
    if((CONF_RTC_ALM_EN&RTC_CR0_ALM_EN_mask_w)!=DISABLE)
    {
        RTC->ALM.W = CONF_RTC_ALM;           // Alarm value set.
    }
    
    // RTC Function Enable
    RTC->CR0.MBIT.EN |= CONF_RTC_EN;
    
    // RTC module register locked
    RTC->KEY.MBIT.KEY = 0x217A;
    
    // RTC Middleware Define.
    #if defined(IRQHandler_Middleware_Level_)
    mRTC.Instance = RTC;
    mRTC.Init.RTC_CK_SEL = CONF_RTC_CK_SEL;         //RTC clock source select
    mRTC.Init.RTC_CK_PDIV = CONF_RTC_CK_PDIV;
    mRTC.Init.RTC_CK_DIV = CONF_RTC_CK_DIV;
    mRTC.Init.RTC_RLR = CONF_RTC_RLR;             //RTC reload register set 0~0xFFFFFFFE, 0xFFFFFFFF  forbidden.
    mRTC.Init.RTC_INT = CONF_RTC_INT;
    
//    MID_RTC_Init(&mRTC);
    
    #endif
#endif
}



