/**
 ******************************************************************************
 *
 * @file        MG32_IWDT_Init.h
 *
 * @brief       This file is used to configure IWDT setting.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/05/09 (H File Generated Date)
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_IWDT.h"

#include "MG32__Common_DRV.h"

#if defined(IRQHandler_Middleware_Level_)       
#include "MG32_IWDT_MID.h"
#endif      // MG32 IWDT Middleware Define


#ifndef MG32_IWDT_H
#define MG32_IWDT_H

/* Wizard menu ---------------------------------------------------------------*/
//<<< Use Configuration Wizard in Context Menu >>>
/**
 ******************************************************************************
 *
 * @brief       IWDT Initial Configure
 *
 ******************************************************************************
 */
//<h> IWDT Initial Configure
    //<e.0>IWDT_EN
    //  <i> IWDT module function enable set.
    #define CONF_IWDT_EN 0x00000000

        //<o0.4..7> IWDT Input Clock Divider <0 = > DIV1 <1 = > DIV2 <2 = > DIV4 <3 = > DIV8 <4 = > DIV16 <5 = > DIV32 <6 = > DIV64 
        //                                   <7 = > DIV128 <8 = > DIV256 <9 = > DIV512 <10 = > DIV1024 <11 = > DIV2048 <12 = > DIV4096
        //  <i> IWDT input clock divider select.
        #define CONF_IWDT_CK_DIV 0x00000000

        //<h> IWDT Wake Up Configure.
        //<q0.8>IWDT_TF_WPEN
        //  <i> IWDT detect over float flag, wake up set.
        #define CONF_IWDT_TF_WPEN   0x00000000
        //<q0.10>IWDT_EW0_WPEN
        //  <i> IWDT detect early wake up 0 flag, wake up set.
        #define CONF_IWDT_EW0_WPEN  0x00000000
        //<q0.11>IWDT_EW1_WPEN
        //  <i> IWDT detect early wake up 1 flag, wake up set.
        #define CONF_IWDT_EW1_WPEN  0x00000000
        //</h>IWDT Wake Configure End.

        //<h> IWDT Interrupt Configure.
        //  <i> Interrupt will happened, when system module SYS_IEA enable.
            //<q0.1> IWDT_TIE_EN
            //  <i> IWDT overfloat interrupt enable.
            #define CONF_IWDT_TIE_INT   0x00000000
            //<q0.2> IWDT_EW0_EN
            //  <i> IWDT early wake up 0 interrupt enable.
            #define CONF_IWDT_EW0_INT   0x00000000
            //<q0.3> IWDT_EW1_EN
            //  <i> IWDT early wake up 1 interrupt enable.
            #define CONF_IWDT_EW1_INT   0x00000000
        //</h> IWDT Interrupt Configure End.
    //</e> IWDT Module Function Enable End.
//</h>
//<<< end of configuration section >>>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define CONF_IWDT_CLK   (CONF_IWDT_CK_DIV)
#define CONF_IWDT_CR0   (CONF_IWDT_TF_WPEN  |       \
                         CONF_IWDT_EW0_WPEN |       \
                         CONF_IWDT_EW1_WPEN)
#define CONF_IWDT_INT   (CONF_IWDT_TIE_INT  |       \
                         CONF_IWDT_EW0_INT  |       \
                         CONF_IWDT_EW1_INT)
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 * @name    Function announce
 *   
 */
///@{  
void IWDT_Init(void);
///@}
#endif // IWDT Configure Wizard Define End

