

/**
 ******************************************************************************
 *
 * @file        MG32_URT_Init.c
 * @brief       MG32 URT configure C Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2024/10/25
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_URT_Init.h"
#include "MG32_CSC_Init.h"
#if defined(ModuleExist_GPL)
#include "MG32_GPL.h"
#endif
#include "stdlib.h"
#include "RTE_Components.h"
#if defined(IRQHandler_Middleware_Level_)
#include "MG32_URT_MID.h"
#include "MG32_SPI_MID.h"
#endif

/*Division Related--------------------------------------------------------*/  
/* URT Cofigure Common Related--------------------------------------------*/
//Interrupt
#if !defined(URT_INT_TUDR_IE_mask_w)
#define URT_INT_TUDR_IE_mask_w   0
    #define CONF_URT0_TUDRIE         0
    #define CONF_URT1_TUDRIE         0
    #define CONF_URT2_TUDRIE         0
    #define CONF_URT3_TUDRIE         0    
#endif
#if !defined(URT_INT_NSS_IE_mask_w)
#define URT_INT_NSS_IE_mask_w    0
    #define CONF_URT0_NSSIE          0
    #define CONF_URT1_NSSIE          0
    #define CONF_URT2_NSSIE          0
    #define CONF_URT3_NSSIE          0
#endif


//CONF SHIFT
#define CONF_URT0n_DATA_INT      0
#define CONF_URT0n_DATA_CLK      1
#define CONF_URT0n_DATA_CR0      2
#define CONF_URT0n_DATA_CR1      3
#define CONF_URT0n_DATA_CR2      4
#define CONF_URT0n_DATA_CR3      5
#define CONF_URT0n_DATA_CR4      6
#define CONF_URT0n_DATA_RLR      7
#define CONF_URT0n_DATA_TMOUT    8
#define CONF_URT0n_DATA_TMOUT2   9
#define CONF_URT0n_DATA_SC       10
#define CONF_URT0n_DATA_SADR     11
#define CONF_URT0n_DATA_CAL      12
#define CONF_URT0n_DATA_IRDA     13
#define CONF_URT0n_DATA_HFC      14
#define CONF_URT0n_DATA_CALC     15
#define CONF_URT0n_DATA_FREQ     16
#define CONF_URT0n_DATA_BD       17


#define CONF_URT4n_DATA_INT      0
#define CONF_URT4n_DATA_CLK      1
#define CONF_URT4n_DATA_CR0      2
#define CONF_URT4n_DATA_CR1      3
#define CONF_URT4n_DATA_CR2      4
#define CONF_URT4n_DATA_RLR      5
#define CONF_URT4n_DATA_CALC     6
#define CONF_URT4n_DATA_FREQ     7
#define CONF_URT4n_DATA_BD       8

//Baud-Rate
#define CONF_URT_BR_CALC_MASK    0x80000000
#define CONF_URT_BR_OS_MASK      0x00FF0000

#define CONF_URT_UART_OS_MIN     7
#define CONF_URT_IRDA_OS_MIN     15
#define CONF_URT_ADR_OS_MIN      7
#define CONF_URT_IDL_OS_MIN      7
#define CONF_URT_MSPI_OS_MIN     3
#define CONF_URT_SSPI_OS_MIN     3
#define CONF_URT_LIN_OS_MIN      7

#define CONF_URT_BRG_MAX         (((URT_RLR_PSR_mask_w |  URT_RLR_RLR_mask_w)) + 1)  // Baud-Rate Generator reload max counter in 
                                                                                     // baud-rate timer mode is "Combined" mode.
                                                                                     
// IrDA Pulse Width table                                                                                    
static uint8_t const URT_IrDAPulseWidth_Table[17] = {2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5};                         
                         

/* CK_URTx_PR Frequence Related*/
#if defined(URT0_Base)
    #if CONF_CSC_URT0_CKS == 0
        #define CONF_URT0_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT0_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT1_Base)
    #if CONF_CSC_URT1_CKS == 0
        #define CONF_URT1_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT1_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT2_Base)
    #if CONF_CSC_URT2_CKS == 0
        #define CONF_URT2_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT2_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT3_Base)
    #if CONF_CSC_URT3_CKS == 0
        #define CONF_URT3_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT3_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT4_Base)
    #if CONF_CSC_URT4_CKS == 0
        #define CONF_URT4_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT4_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT5_Base)
    #if CONF_CSC_URT5_CKS == 0
        #define CONF_URT5_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT5_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT6_Base)
    #if CONF_CSC_URT6_CKS == 0
        #define CONF_URT6_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT6_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif
#if defined(URT7_Base)
    #if CONF_CSC_URT7_CKS == 0
        #define CONF_URT7_Freq    CONF_CK_APB_FREQ
    #else
        #define CONF_URT7_Freq    CONF_CK_AHB_FREQ   
    #endif
#endif

/* URT0 Related Configure-----------------------------------------------*/
#if defined(URT0_Base) 
    /*Disable or Enable check*/
    #if CONF_URT0_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT0_INIT_EN          0
        #define CONF_URT0_BaudRate_Config  0
    #else
        #define CONF_URT0_INIT_EN          1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT0_MODE == CONF_URT_MODE_UART
                #define CONF_URT0_UART_MASK  0xFFFFFFFF
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_IRDA
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0xFFFFFFFF
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0xFFFFFFFF
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0  
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0xFFFFFFFF
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0xFFFFFFFF
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0xFFFFFFFF
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0xFFFFFFFF
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_LIN
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0xFFFFFFFF
                #define CONF_URT0_TM_MASK    0
            #elif CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT0_UART_MASK  0
                #define CONF_URT0_IRDA_MASK  0
                #define CONF_URT0_ADR_MASK   0
                #define CONF_URT0_IDL_MASK   0
                #define CONF_URT0_MSPI_MASK  0
                #define CONF_URT0_SSPI_MASK  0
                #define CONF_URT0_SC_MASK    0
                #define CONF_URT0_LIN_MASK   0
                #define CONF_URT0_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT0_INT    ((URT_INT_IEA_mask_w      * CONF_URT0_IEA)    | \
                                      (URT_INT_UG_IE_mask_w    * CONF_URT0_UGFIE)  | \
                                      (URT_INT_TC_IE_mask_w    * CONF_URT0_TCIE)   | \
                                      (URT_INT_ERR_IE_mask_w   * CONF_URT0_ERRIE)  | \
                                      (URT_INT_LS_IE_mask_w    * CONF_URT0_LSIE)   | \
                                      (URT_INT_RX_IE_mask_w    * CONF_URT0_RXIE)   | \
                                      (URT_INT_TX_IE_mask_w    * CONF_URT0_TXIE)   | \
                                      (URT_INT_SADR_IE_mask_w  * CONF_URT0_SADRIE) | \
                                      (URT_INT_BRT_IE_mask_w   * CONF_URT0_BRTIE)  | \
                                      (URT_INT_TMO_IE_mask_w   * CONF_URT0_TMOIE)  | \
                                      (URT_INT_CALC_IE_mask_w  * CONF_URT0_CALCIE) | \
                                      (URT_INT_BK_IE_mask_w    * CONF_URT0_BKIE)   | \
                                      (URT_INT_IDL_IE_mask_w   * CONF_URT0_IDLIE)  | \
                                      (URT_INT_CTS_IE_mask_w   * CONF_URT0_CTSIE)  | \
                                      (URT_INT_NSS_IE_mask_w   * CONF_URT0_NSSIE)  | \
                                      (URT_INT_PE_IE_mask_w    * CONF_URT0_PEIE)   | \
                                      (URT_INT_FE_IE_mask_w    * CONF_URT0_FEIE)   | \
                                      (URT_INT_NCE_IE_mask_w   * CONF_URT0_NCEIE)  | \
                                      (URT_INT_ROVR_IE_mask_w  * CONF_URT0_ROVRIE) | \
                                      (URT_INT_TXE_IE_mask_w   * CONF_URT0_TXEIE)  | \
                                      (URT_INT_TUDR_IE_mask_w  * CONF_URT0_TUDRIE) | \
                                      (URT_INT_RXTMO_IE_mask_w * CONF_URT0_RXTMOIE)| \
                                      (URT_INT_IDTMO_IE_mask_w * CONF_URT0_IDMO_IE)| \
                                      (URT_INT_BKTMO_IE_mask_w * CONF_URT0_BKTMOIE)| \
                                      (URT_INT_CALTMO_IE_mask_w* CONF_URT0_CALTMOIE))   
                                      
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_CKS) Baud-rate timer clock source select.
            #if CONF_URT0_MODE != CONF_URT_MODE_SC
                #define CONF_URT0_BR_CKS  0
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT0_BR_CKS  URT_CLK_BR_CKS_ck_urtx_w
            #else
                #define CONF_URT0_BR_CKS  0
            #endif
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT0_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT0_UART_BR_MDS     ) & CONF_URT0_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_IRDA_BR_MDS     ) & CONF_URT0_IRDA_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_MULTIADR_BR_MDS ) & CONF_URT0_ADR_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_MULTIIDL_BR_MDS ) & CONF_URT0_IDL_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_SPIMASTER_BR_MDS) & CONF_URT0_MSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_SPISLAVE_BR_MDS ) & CONF_URT0_SSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 0                         ) & CONF_URT0_SC_MASK)   |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT0_LIN_BR_MDS      ) & CONF_URT0_LIN_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT0_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #if CONF_URT0_TM_BRT == 1
                    #define CONF_URT0_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT0_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT0_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (TX_CKS) Transmission clock source select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT0_TX_CKS       URT_CLK_TX_CKS_ext_clk_w
            #else
                #define CONF_URT0_TX_CKS       URT_CLK_TX_CKS_internal_w
            #endif
            // (RX_CKS) Receive clock source select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT0_RX_CKS       URT_CLK_RX_CKS_ext_clk_w
            #else
                #define CONF_URT0_RX_CKS       URT_CLK_RX_CKS_internal_w
            #endif
            // (CLK_CKS) External clock output source select.
            #define CONF_URT0_CLK_CKS      URT_CLK_CLK_CKS_sc_w
            // (CLK_EN) URTx_CLK signal output enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT0_CLK_EN   URT_CLK_CLK_EN_enable_w
            #else
                #define CONF_URT0_CLK_EN   URT_CLK_CLK_EN_disable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT0_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT0_UART_BR_CKSEL      << 1)) & CONF_URT0_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_IRDA_BR_CKSEL      << 1)) & CONF_URT0_IRDA_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_MULTIADR_BR_CKSEL  << 1)) & CONF_URT0_ADR_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_MULTIIDL_BR_CKSEL  << 1)) & CONF_URT0_IDL_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_SPIMASTER_BR_CKSEL << 1)) & CONF_URT0_MSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_SPISLAVE_BR_CKSEL  << 1)) & CONF_URT0_SSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT0_SC_MASK)   |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT0_LIN_BR_CKSEL       << 1)) & CONF_URT0_LIN_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT0_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (DE_GT) URTx_DE signal output guard time select.
            // (DE_INV) URTx_DE signal inverse enable.
            // (DE_EN) URTx_DE signal output enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_UART
                #define CONF_URT0_DE         (CONF_URT0_HWFLOW_DE << 12)
            #else
                #define CONF_URT0_DE         (URT_CR0_DE_GT_1_4_w | URT_CR0_DE_INV_disable_w | URT_CR0_DE_EN_disable_w)
            #endif
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT0_TX_INV         (((CONF_URT0_UART_TX_INV    & CONF_URT0_UART_MASK)| \
                                               (CONF_URT0_IRDA_TX_INV    & CONF_URT0_IRDA_MASK)| \
                                               (CONF_URT0_MULTIADR_TX_INV& CONF_URT0_ADR_MASK) | \
                                               (CONF_URT0_MULTIIDL_TX_INV& CONF_URT0_IDL_MASK))<<11)
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT0_RX_INV         (((CONF_URT0_UART_RX_INV    & CONF_URT0_UART_MASK)| \
                                               (CONF_URT0_IRDA_RX_INV    & CONF_URT0_IRDA_MASK)| \
                                               (CONF_URT0_MULTIADR_RX_INV& CONF_URT0_ADR_MASK) | \
                                               (CONF_URT0_MULTIIDL_RX_INV& CONF_URT0_IDL_MASK))<<10)    
            // (SYNC_MDS) SYNC mode(SPI) select.
            #if defined(URT_CR0_SYNC_MDS_mask_w)
                #define CONF_URT0_SYNC_MDS   ((URT_CR0_SYNC_MDS_master_w & CONF_URT0_MSPI_MASK) |\
                                              (URT_CR0_SYNC_MDS_slave_w  & CONF_URT0_SSPI_MASK))
            #else
                #define CONF_URT0_SYNC_MDS 0
            #endif                           
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT0_IO_SWP         (((CONF_URT0_UART_PINSWAP     & CONF_URT0_UART_MASK)|\
                                               (CONF_URT0_IRDA_PINSWAP     & CONF_URT0_IRDA_MASK)|\
                                               (CONF_URT0_MULTIADR_PINSWAP & CONF_URT0_ADR_MASK) |\
                                               (CONF_URT0_MULTIIDL_PINSWAP & CONF_URT0_IDL_MASK) |\
                                               (CONF_URT0_SPIMASTER_PINSWAP& CONF_URT0_MSPI_MASK)|\
                                               (CONF_URT0_SPISLAVE_PINSWAP & CONF_URT0_SSPI_MASK))<<8)
            // (GSA_EN) Multi-processor global slave address enable.
            #define CONF_URT0_GSA_EN         (((CONF_URT0_MULTIADR_GLOBAL & CONF_URT0_ADR_MASK) |\
                                               (CONF_URT0_MULTIIDL_GLOBAL & CONF_URT0_IDL_MASK))<<7)   
            // (MDS) Mode select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT0_MDS        URT_CR0_MDS_sync_w
            #elif CONF_URT0_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT0_MDS        URT_CR0_MDS_idle_w
            #elif CONF_URT0_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT0_MDS        URT_CR0_MDS_adr_w
            #else
                #define CONF_URT0_MDS        URT_CR0_MDS_uart_w
            #endif
            // (DAT_LINE) Communication data line select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_DATA_LINE  URT_CR0_DAT_LINE_1_w 
            #else
                #define CONF_URT0_DATA_LINE  URT_CR0_DAT_LINE_2_w
            #endif
            // (HDX_EN) Half-duplex mode enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC || CONF_URT0_MODE == CONF_URT_MODE_LIN
                #define CONF_URT0_HDX_EN     URT_CR0_HDX_EN_enable_w 
            #else
                #define CONF_URT0_HDX_EN     URT_CR0_HDX_EN_disable_w
            #endif
            // (EN) Function enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_EN         URT_CR0_EN_disable_w
            #else
                #define CONF_URT0_EN         URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT0_OS_NUM         (((CONF_URT0_UART_BR_OS     & CONF_URT0_UART_MASK) |\
                                               (CONF_URT0_IRDA_BR_OS     & CONF_URT0_IRDA_MASK) |\
                                               (CONF_URT0_MULTIADR_BR_OS & CONF_URT0_ADR_MASK)  |\
                                               (CONF_URT0_MULTIIDL_BR_OS & CONF_URT0_IDL_MASK)  |\
                                               (CONF_URT0_SPIMASTER_BR_OS& CONF_URT0_MSPI_MASK) |\
                                               (CONF_URT0_SPISLAVE_BR_OS & CONF_URT0_SSPI_MASK) |\
                                               (30                       & CONF_URT0_SC_MASK)   |\
                                               (CONF_URT0_LIN_BR_OS      & CONF_URT0_LIN_MASK))<<URT_CR1_RXOS_NUM_shift_w)       
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC || CONF_URT0_MODE == CONF_URT_MODE_LIN
                #define CONF_URT0_STP_LEN    (URT_CR1_RXSTP_LEN_1bit_w)
            #else
                #define CONF_URT0_STP_LEN    (((CONF_URT0_UART_STOP       & CONF_URT0_UART_MASK)  |\
                                               (CONF_URT0_IRDA_STOP       & CONF_URT0_IRDA_MASK)  |\
                                               (CONF_URT0_MULTIADR_STOP   & CONF_URT0_ADR_MASK)   |\
                                               (CONF_URT0_MULTIIDL_STOP   & CONF_URT0_IDL_MASK))<<6)
            #endif
            // (TXMSB_EN) TX data order MSB first enable.
            // (RXMSB_EN) RX data order MSB first enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC || CONF_URT0_MODE == CONF_URT_MODE_LIN
                #define CONF_URT0_MSB_EN     (CONF_URT0_SC_CONVENTION & URT_CR1_RXMSB_EN_mask_w)
            #else
                #define CONF_URT0_MSB_EN     (((CONF_URT0_UART_DATAORDER     & CONF_URT0_UART_MASK)  |\
                                               (CONF_URT0_IRDA_DATAORDER     & CONF_URT0_IRDA_MASK)  |\
                                               (CONF_URT0_MULTIADR_DATAORDER & CONF_URT0_ADR_MASK)   |\
                                               (CONF_URT0_MULTIIDL_DATAORDER & CONF_URT0_IDL_MASK)   |\
                                               (CONF_URT0_SPIMASTER_DATAORDER& CONF_URT0_MSPI_MASK)  |\
                                               (CONF_URT0_SPISLAVE_DATAORDER & CONF_URT0_SSPI_MASK))<<5)
                                               
            #endif     
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_PAR         (URT_CR1_RXPAR_STK_disable_w | URT_CR1_RXPAR_EN_mask_w | (CONF_URT0_SC_CONVENTION & URT_CR1_RXPAR_POL_mask_w))
            #else
                #define CONF_URT0_PAR         (((CONF_URT0_UART_PARITY     & CONF_URT0_UART_MASK)|\
                                                (CONF_URT0_IRDA_PARITY     & CONF_URT0_IRDA_MASK)|\
                                                (CONF_URT0_MULTIADR_PARITY & CONF_URT0_ADR_MASK) |\
                                                (CONF_URT0_MULTIIDL_PARITY & CONF_URT0_IDL_MASK) |\
                                                (0                         & CONF_URT0_LIN_MASK))<<2)
            #endif
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT0_DSIZE           ((CONF_URT0_UART_DATABIT     & CONF_URT0_UART_MASK) | \
                                               (CONF_URT0_IRDA_DATABIT     & CONF_URT0_IRDA_MASK) | \
                                               (CONF_URT0_MULTIADR_DATABIT & CONF_URT0_ADR_MASK)  | \
                                               (CONF_URT0_MULTIIDL_DATABIT & CONF_URT0_IDL_MASK))                                 
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (DOUT_IDL) SPI master mode idle state data output value.
            // (DOUT_MDS) SPI master standard mode idle state data output mode select.
            #if defined(URT_CR2_DOUT_MDS_mask_w)
                #define CONF_URT0_DOUT        ((((uint32_t)CONF_URT0_SPIMASTER_DOUT) << 29) & CONF_URT0_MSPI_MASK)
            #else
                #define CONF_URT0_DOUT        0
            #endif
            // (NSSI_EN) NSS signal input function enable when UART configure to synchronous mode SPI slave.
            #if defined(URT_CR2_NSSI_EN_mask_w)
                #define CONF_URT0_NSSI_EN     (URT_CR2_NSSI_EN_enable_w & CONF_URT0_SSPI_MASK)
            #else
                #define CONF_URT0_NSSI_EN     0
            #endif
            // (TX_EN) Transmitter enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT0_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT0_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*CR3    (Control Register 3)*/
        #if 1
            // (TXGT_LEN) TX guard time.
            #define CONF_URT0_TXGT_LEN        ((CONF_URT0_SC_GT<<16) & CONF_URT0_SC_MASK)
            // (DET_IDL) Idle line detect threshold value.
            #define CONF_URT0_DET_IDL         (((CONF_URT0_MULTIIDL_IDL-1) << 8) & CONF_URT0_IDL_MASK)
            // (DET_BK) Bit time select for break detection or transmission.
            #define CONF_URT0_DET_BK          ((CONF_URT0_LIN_BK << 4) & CONF_URT0_LIN_MASK)
            // (CPHA) Clock phase select.
            #define CONF_URT0_CPHA            (((CONF_URT0_SPIMASTER_CPHA & CONF_URT0_MSPI_MASK)| \
                                                (CONF_URT0_SPISLAVE_CPHA  & CONF_URT0_SSPI_MASK))<<2)
            // (CPOL) Clock polarity select.
            #define CONF_URT0_CPOL            (((CONF_URT0_SPIMASTER_CPOL & CONF_URT0_MSPI_MASK)| \
                                                (CONF_URT0_SPISLAVE_CPOL  & CONF_URT0_SSPI_MASK))<<1)
        #endif
        /*CR4    (Control Register 4)*/
        #if 1
            // (TDAT_CLR) Transmitted data clear enable.
            #define CONF_URT0_TDAT_CLR        URT_CR4_TDAT_CLR_enable_w
            // (RDAT_CLR) Receive data clear enable.
            #define CONF_URT0_RDAT_CLR        URT_CR4_RDAT_CLR_enable_w
            // (TDAT_INV) Inverse transmitted data enable.
            // (RDAT_INV) Inverse received data enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_DAT_INV         ((CONF_URT0_SC_CONVENTION >> 16) & (URT_CR4_TDAT_INV_mask_w | URT_CR4_RDAT_INV_mask_w))
            #else
                #define CONF_URT0_DAT_INV         ((((CONF_URT0_UART_DATAINV     << 5) | (CONF_URT0_UART_DATAINV     << 4)) & CONF_URT0_UART_MASK)| \
                                                   (((CONF_URT0_IRDA_DATAINV     << 5) | (CONF_URT0_IRDA_DATAINV     << 4)) & CONF_URT0_IRDA_MASK)| \
                                                   (((CONF_URT0_MULTIADR_DATAINV << 5) | (CONF_URT0_MULTIADR_DATAINV << 4)) & CONF_URT0_ADR_MASK) | \
                                                   (((CONF_URT0_MULTIIDL_DATAINV << 5) | (CONF_URT0_MULTIIDL_DATAINV << 4)) & CONF_URT0_IDL_MASK) | \
                                                   (((CONF_URT0_SPIMASTER_DATAINV<< 5) | (CONF_URT0_SPIMASTER_DATAINV<< 4)) & CONF_URT0_MSPI_MASK)| \
                                                   (((CONF_URT0_SPISLAVE_DATAINV << 5) | (CONF_URT0_SPISLAVE_DATAINV << 4)) & CONF_URT0_SSPI_MASK))
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #if CONF_URT0_Freq < 5000000
                #define CONF_URT0_PSR             (((CONF_URT0_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT0_UART_MASK) | \
                                                   ((CONF_URT0_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT0_IRDA_MASK) | \
                                                   ((CONF_URT0_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_ADR_MASK)  | \
                                                   ((CONF_URT0_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_IDL_MASK)  | \
                                                   ((CONF_URT0_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT0_MSPI_MASK) | \
                                                   ((CONF_URT0_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_SSPI_MASK) | \
                                                   ((0                         << URT_RLR_PSR_shift_w) & CONF_URT0_SC_MASK)   | \
                                                   ((CONF_URT0_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT0_LIN_MASK)  | \
                                                   (((CONF_URT0_TM_BRTRLR-1)     & URT_RLR_PSR_mask_w) & CONF_URT0_TM_MASK))
            #else
                #define CONF_URT0_PSR             (((CONF_URT0_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT0_UART_MASK) | \
                                                   ((CONF_URT0_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT0_IRDA_MASK) | \
                                                   ((CONF_URT0_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_ADR_MASK)  | \
                                                   ((CONF_URT0_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_IDL_MASK)  | \
                                                   ((CONF_URT0_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT0_MSPI_MASK) | \
                                                   ((CONF_URT0_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT0_SSPI_MASK) | \
                                                   (((CONF_URT0_Freq/5000000)  << URT_RLR_PSR_shift_w) & CONF_URT0_SC_MASK)   | \
                                                   ((CONF_URT0_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT0_LIN_MASK)  | \
                                                   (((CONF_URT0_TM_BRTRLR-1)     & URT_RLR_PSR_mask_w) & CONF_URT0_TM_MASK))
            #endif
            // (RLR) Baud-rate clock counter reload register.
            #if CONF_URT0_Freq < 5000000
                #define CONF_URT0_RLR             (((CONF_URT0_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT0_UART_MASK) | \
                                                   ((CONF_URT0_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT0_IRDA_MASK) | \
                                                   ((CONF_URT0_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_ADR_MASK)  | \
                                                   ((CONF_URT0_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_IDL_MASK)  | \
                                                   ((CONF_URT0_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT0_MSPI_MASK) | \
                                                   ((CONF_URT0_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT0_SC_MASK)   | \
                                                   ((CONF_URT0_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT0_LIN_MASK)  | \
                                                   (((CONF_URT0_TM_BRTRLR-1)    & URT_RLR_RLR_mask_w)  & CONF_URT0_TM_MASK))
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT0_RLR             (((CONF_URT0_UART_BR_BR                                       << URT_RLR_RLR_shift_w) & CONF_URT0_UART_MASK) | \
                                                   ((CONF_URT0_IRDA_BR_BR                                       << URT_RLR_RLR_shift_w) & CONF_URT0_IRDA_MASK) | \
                                                   ((CONF_URT0_MULTIADR_BR_BR                                   << URT_RLR_RLR_shift_w) & CONF_URT0_ADR_MASK)  | \
                                                   ((CONF_URT0_MULTIIDL_BR_BR                                   << URT_RLR_RLR_shift_w) & CONF_URT0_IDL_MASK)  | \
                                                   ((CONF_URT0_SPIMASTER_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT0_MSPI_MASK) | \
                                                   ((CONF_URT0_SPISLAVE_BR_BR                                   << URT_RLR_RLR_shift_w) & CONF_URT0_SSPI_MASK) | \
                                                   (((11*((CONF_URT0_Freq/5000000)+1)+(CONF_URT0_Freq/5000000)) << URT_RLR_RLR_shift_w) & CONF_URT0_SC_MASK)   | \
                                                   ((CONF_URT0_LIN_BR_BR                                        << URT_RLR_RLR_shift_w) & CONF_URT0_LIN_MASK)  | \
                                                   (((CONF_URT0_TM_BRTRLR-1)                                    & URT_RLR_RLR_mask_w)  & CONF_URT0_TM_MASK))    
            #else
                #define CONF_URT0_RLR             (((CONF_URT0_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT0_UART_MASK) | \
                                                   ((CONF_URT0_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT0_IRDA_MASK) | \
                                                   ((CONF_URT0_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_ADR_MASK)  | \
                                                   ((CONF_URT0_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_IDL_MASK)  | \
                                                   ((CONF_URT0_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT0_MSPI_MASK) | \
                                                   ((CONF_URT0_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT0_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT0_SC_MASK)   | \
                                                   ((CONF_URT0_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT0_LIN_MASK)  | \
                                                   (((CONF_URT0_TM_BRTRLR-1)    & URT_RLR_RLR_mask_w)  & CONF_URT0_TM_MASK))
            #endif
        #endif
        /*TMOUT  (Timeout control register)*/
        #if 1
            // (TMO_CKS) Timeout timer clock source select.
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_TMO_CKS     (URT_TMOUT_TMO_CKS_input_w)
            #else
                #define CONF_URT0_TMO_CKS     (URT_TMOUT_TMO_CKS_uart_w)
            #endif
            // (IDTMO_EN) Idle timeout detection enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_IDTMO_EN    (URT_TMOUT_IDTMO_EN_enable_w)
            #else
                #define CONF_URT0_IDTMO_EN    (URT_TMOUT_IDTMO_EN_disable_w)
            #endif 
            // (TMO_MDS) Timeout timer mode select.
            #if CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_TMO_MDS     (URT_TMOUT_TMO_MDS_general_w)
            #else
                #define CONF_URT0_TMO_MDS     (URT_TMOUT_TMO_MDS_uart_w)
            #endif
            // (TMO_RST) Timeout timer force reset enable.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC || CONF_URT0_MODE == CONF_URT_MODE_TM 
                #define CONF_URT0_RST         (URT_TMOUT_TMO_RST_enable_w)
            #else
                #define CONF_URT0_RST         0
            #endif
            // (TMO_EN) Timeout timer enable
            #if CONF_URT0_MODE == CONF_URT_MODE_MULTI_IDL || CONF_URT0_MODE == CONF_URT_MODE_SC 
                #define CONF_URT0_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)
            #elif CONF_URT0_MODE == CONF_URT_MODE_TM && CONF_URT0_TM_TMO == 1
                #define CONF_URT0_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)
            #else
                #define CONF_URT0_TMO_EN      0
            #endif
        #endif
        /*TMOUT2 (Timeout control register 2)*/
        #if 1
            // (IDTMO_TH) Receive idle timeout detect threshold value by using receive bit time.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_IDTMO_TH        CONF_URT0_SC_WT
            #elif CONF_URT0_MODE == CONF_URT_MODE_TM
                #define CONF_URT0_IDTMO_TH        (CONF_URT0_TM_TMORLR-1)
            #else
                #define CONF_URT0_IDTMO_TH        0
            #endif
        #endif
        /*SC     (SmartCard control register)*/
        #if 1
            // (RXE_NUM) RX parity error detect and NACK transmission retry maximum number.
            #define CONF_URT0_RXE_NUM         ((CONF_URT0_SC_RXERRORTIME << 12) & CONF_URT0_SC_MASK)
            // (TXE_NUM) TX error detect and data resend maximum number
            #define CONF_URT0_TXE_NUM         ((CONF_URT0_SC_TXERRORTIME << 8)  & CONF_URT0_SC_MASK)
            // (RXE_LEN) RX parity error detect and NACK transmission bit time length select.
            #define CONF_URT0_RXE_LEN         ((CONF_URT0_SC_RXERRORSIG  << 4)  & CONF_URT0_SC_MASK)
            // (TXE_MDS) TX error detect mode select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_TXE_MDS     (URT_SC_TXE_MDS_chk_low_w)
            #elif CONF_URT0_MODE == CONF_URT_MODE_LIN
                #define CONF_URT0_TXE_MDS     (URT_SC_TXE_MDS_chk_tx_w)
            #else
                #define CONF_URT0_TXE_MDS     (URT_SC_TXE_MDS_disable_w)
            #endif
            // (RXE_MDS) RX parity error detect control mode select.
            #if CONF_URT0_MODE == CONF_URT_MODE_SC
                #define CONF_URT0_RXE_MDS     (URT_SC_RXE_MDS_enable_w) 
            #else
                #define CONF_URT0_RXE_MDS     (URT_SC_RXE_MDS_disable_w)
            #endif
        #endif
        /*SADR   (URT0 slave address detect register)*/
        #if 1
            // (SA_MSK) Multi-processor slave address mask register.
            #define CONF_URT0_SA_MSK          (((CONF_URT0_MULTIADR_ADRMASK << 8) & CONF_URT0_ADR_MASK) | \
                                               ((CONF_URT0_MULTIIDL_ADRMASK << 8) & CONF_URT0_IDL_MASK))
            // (SA_RX) Multi-processor mode received slave address.
            #define CONF_URT0_SA_RX           ((CONF_URT0_MULTIADR_ADR & CONF_URT0_ADR_MASK) | \
                                               (CONF_URT0_MULTIIDL_ADR & CONF_URT0_IDL_MASK))
        #endif
        /*CAL    (Calibration control register)*/
        #if 1
            // (CAL_MDS) Auto baud-rate calibration mode select.
            // (CAL_AUTO) Break detection and auto baud-rate calibration enable.
            #define CONF_URT0_CAL             ((CONF_URT0_LIN_CAL) & CONF_URT0_LIN_MASK)
        #endif
        /*IRDA   (IrDA control register)*/
        #if 1
            // (IR_MDS) IrDA data received mode select.
            // (IR_EN) IrDA data format enable.
            #define CONF_URT0_IR              ((0x00000002 | URT_IRDA_IR_EN_enable_w) & CONF_URT0_IRDA_MASK)
        #endif
        /*HFC    (Hardware flow control register)*/
        #if 1
            // (RTS_INV) RTS output inverse enable.
            // (CTS_INV) CTS input inverse enable.
            // (RTS_EN)  RTS hardware flow control enable.
            // (CTS_EN)  CTS hardware flow control enable.
            #define CONF_URT0_HFC             (((CONF_URT0_HWFLOW_RTS << 1) | CONF_URT0_HWFLOW_CTS) & CONF_URT0_UART_MASK)        
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT0_CALC            ((((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT0_UART_BR_CALC     )& CONF_URT0_UART_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IRDA_OS_MIN << 16)) * CONF_URT0_IRDA_BR_CALC     )& CONF_URT0_IRDA_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_ADR_OS_MIN  << 16)) * CONF_URT0_MULTIADR_BR_CALC )& CONF_URT0_ADR_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IDL_OS_MIN  << 16)) * CONF_URT0_MULTIIDL_BR_CALC )& CONF_URT0_IDL_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_MSPI_OS_MIN << 16)) * CONF_URT0_SPIMASTER_BR_CALC)& CONF_URT0_MSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_SSPI_OS_MIN << 16)) * CONF_URT0_SPISLAVE_BR_CALC )& CONF_URT0_SSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_LIN_OS_MIN  << 16)) * CONF_URT0_LIN_BR_CALC      )& CONF_URT0_LIN_MASK))
                                               
            #define CONF_URT0_BaudRate_Config ((CONF_URT0_UART_BR_CALC     & CONF_URT0_UART_MASK) | \
                                               (CONF_URT0_IRDA_BR_CALC     & CONF_URT0_IRDA_MASK) | \
                                               (CONF_URT0_MULTIADR_BR_CALC & CONF_URT0_ADR_MASK)  | \
                                               (CONF_URT0_MULTIIDL_BR_CALC & CONF_URT0_IDL_MASK)  | \
                                               (CONF_URT0_SPIMASTER_BR_CALC& CONF_URT0_MSPI_MASK) | \
                                               (CONF_URT0_SPISLAVE_BR_CALC & CONF_URT0_SSPI_MASK) | \
                                               (CONF_URT0_LIN_BR_CALC      & CONF_URT0_LIN_MASK))                                           
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT0_BD              ((CONF_URT0_UART_BR      & CONF_URT0_UART_MASK) | \
                                               (CONF_URT0_IRDA_BR      & CONF_URT0_IRDA_MASK) | \
                                               (CONF_URT0_MULTIADR_BR  & CONF_URT0_ADR_MASK)  | \
                                               (CONF_URT0_MULTIIDL_BR  & CONF_URT0_IDL_MASK)  | \
                                               (CONF_URT0_SPIMASTER_BR & CONF_URT0_MSPI_MASK) | \
                                               (CONF_URT0_SPISLAVE_BR  & CONF_URT0_SSPI_MASK) | \
                                               (CONF_URT0_LIN_BR       & CONF_URT0_LIN_MASK))
        #endif
    #endif
#else
    #define CONF_URT0_INIT_EN          0
    #define CONF_URT0_BaudRate_Config  0
    #define CONF_URT0_MODE             CONF_URT_MODE_NA
#endif

#if CONF_URT0_INIT_EN == 1
static const uint32_t CONF_URT0[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT0_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT0_BR_CKS)  | \
     (CONF_URT0_BR_MDS)  | \
     (CONF_URT0_BR_EN)   | \
     (CONF_URT0_TX_CKS)  | \
     (CONF_URT0_RX_CKS)  | \
     (CONF_URT0_CLK_CKS) | \
     (CONF_URT0_CLK_EN)  | \
     (CONF_URT0_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT0_DE)        | \
     (CONF_URT0_TX_INV)    | \
     (CONF_URT0_RX_INV)    | \
     (CONF_URT0_SYNC_MDS)  | \
     (CONF_URT0_IO_SWP)    | \
     (CONF_URT0_GSA_EN)    | \
     (CONF_URT0_MDS)       | \
     (CONF_URT0_DATA_LINE) | \
     (CONF_URT0_HDX_EN)    | \
     (CONF_URT0_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT0_OS_NUM << 16 ) | (CONF_URT0_OS_NUM)) | \
     ((CONF_URT0_STP_LEN<< 16 ) | (CONF_URT0_STP_LEN))| \
     ((CONF_URT0_MSB_EN << 16 ) | (CONF_URT0_MSB_EN)) | \
     ((CONF_URT0_PAR    << 16 ) | (CONF_URT0_PAR))    | \
     ((CONF_URT0_DSIZE  << 16 ) | (CONF_URT0_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT0_DOUT)     | \
     (CONF_URT0_NSSI_EN)  | \
     (CONF_URT0_TX_EN)    | \
     (CONF_URT0_RX_EN)),
    /*CR3    (Control Register 3)*/
    ((CONF_URT0_TXGT_LEN) | \
     (CONF_URT0_DET_IDL)  | \
     (CONF_URT0_DET_BK)   | \
     (CONF_URT0_CPHA)     | \
     (CONF_URT0_CPOL)),
    /*CR4    (Control Register 4)*/
    ((CONF_URT0_TDAT_CLR) | \
     (CONF_URT0_RDAT_CLR) | \
     (CONF_URT0_DAT_INV)), 
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT0_PSR) | \
     (CONF_URT0_RLR)),   
    /*TMOUT  (Timeout control register)*/
    ((CONF_URT0_TMO_CKS) | \
     (CONF_URT0_IDTMO_EN)| \
     (CONF_URT0_TMO_MDS) | \
     (CONF_URT0_RST)     | \
     (CONF_URT0_TMO_EN)),  
    /*TMOUT2 (Timeout control register 2)*/
    (CONF_URT0_IDTMO_TH),
    /*SC     (SmartCard control register)*/
    ((CONF_URT0_RXE_NUM) | \
     (CONF_URT0_TXE_NUM) | \
     (CONF_URT0_RXE_LEN) | \
     (CONF_URT0_TXE_MDS) | \
     (CONF_URT0_RXE_MDS)),
    /*SADR   (URT0 slave address detect register)*/
    ((CONF_URT0_SA_MSK) | \
     (CONF_URT0_SA_RX)),
    /*CAL    (Calibration control register)*/
    (CONF_URT0_CAL),
    /*IRDA   (IrDA control register)*/
    (CONF_URT0_IR),
    /*HFC    (Hardware flow control register)*/
    (CONF_URT0_HFC),
    /*Baud-rate calculation mode*/
    (CONF_URT0_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT0_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT0_BD)
};
#endif
/* URT1 Related Configure-----------------------------------------------*/
#if defined(URT1_Base) 
    /*Disable or Enable check*/
    #if CONF_URT1_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT1_INIT_EN          0
        #define CONF_URT1_BaudRate_Config  0
    #else
        #define CONF_URT1_INIT_EN          1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT1_MODE == CONF_URT_MODE_UART
                #define CONF_URT1_UART_MASK  0xFFFFFFFF
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_IRDA
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0xFFFFFFFF
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0xFFFFFFFF
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0  
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0xFFFFFFFF
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0xFFFFFFFF
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0xFFFFFFFF
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0xFFFFFFFF
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_LIN
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0xFFFFFFFF
                #define CONF_URT1_TM_MASK    0
            #elif CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT1_UART_MASK  0
                #define CONF_URT1_IRDA_MASK  0
                #define CONF_URT1_ADR_MASK   0
                #define CONF_URT1_IDL_MASK   0
                #define CONF_URT1_MSPI_MASK  0
                #define CONF_URT1_SSPI_MASK  0
                #define CONF_URT1_SC_MASK    0
                #define CONF_URT1_LIN_MASK   0
                #define CONF_URT1_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT1_INT    ((URT_INT_IEA_mask_w      * CONF_URT1_IEA)    | \
                                      (URT_INT_UG_IE_mask_w    * CONF_URT1_UGFIE)  | \
                                      (URT_INT_TC_IE_mask_w    * CONF_URT1_TCIE)   | \
                                      (URT_INT_ERR_IE_mask_w   * CONF_URT1_ERRIE)  | \
                                      (URT_INT_LS_IE_mask_w    * CONF_URT1_LSIE)   | \
                                      (URT_INT_RX_IE_mask_w    * CONF_URT1_RXIE)   | \
                                      (URT_INT_TX_IE_mask_w    * CONF_URT1_TXIE)   | \
                                      (URT_INT_SADR_IE_mask_w  * CONF_URT1_SADRIE) | \
                                      (URT_INT_BRT_IE_mask_w   * CONF_URT1_BRTIE)  | \
                                      (URT_INT_TMO_IE_mask_w   * CONF_URT1_TMOIE)  | \
                                      (URT_INT_CALC_IE_mask_w  * CONF_URT1_CALCIE) | \
                                      (URT_INT_BK_IE_mask_w    * CONF_URT1_BKIE)   | \
                                      (URT_INT_IDL_IE_mask_w   * CONF_URT1_IDLIE)  | \
                                      (URT_INT_CTS_IE_mask_w   * CONF_URT1_CTSIE)  | \
                                      (URT_INT_NSS_IE_mask_w   * CONF_URT1_NSSIE)  | \
                                      (URT_INT_PE_IE_mask_w    * CONF_URT1_PEIE)   | \
                                      (URT_INT_FE_IE_mask_w    * CONF_URT1_FEIE)   | \
                                      (URT_INT_NCE_IE_mask_w   * CONF_URT1_NCEIE)  | \
                                      (URT_INT_ROVR_IE_mask_w  * CONF_URT1_ROVRIE) | \
                                      (URT_INT_TXE_IE_mask_w   * CONF_URT1_TXEIE)  | \
                                      (URT_INT_TUDR_IE_mask_w  * CONF_URT1_TUDRIE) | \
                                      (URT_INT_RXTMO_IE_mask_w * CONF_URT1_RXTMOIE)| \
                                      (URT_INT_IDTMO_IE_mask_w * CONF_URT1_IDMO_IE)| \
                                      (URT_INT_BKTMO_IE_mask_w * CONF_URT1_BKTMOIE)| \
                                      (URT_INT_CALTMO_IE_mask_w* CONF_URT1_CALTMOIE)) 
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_CKS) Baud-rate timer clock source select.
            #if CONF_URT1_MODE != CONF_URT_MODE_SC
                #define CONF_URT1_BR_CKS  0
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT1_BR_CKS  URT_CLK_BR_CKS_ck_urtx_w
            #else
                #define CONF_URT1_BR_CKS  0
            #endif
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT1_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT1_UART_BR_MDS     ) & CONF_URT1_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_IRDA_BR_MDS     ) & CONF_URT1_IRDA_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_MULTIADR_BR_MDS ) & CONF_URT1_ADR_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_MULTIIDL_BR_MDS ) & CONF_URT1_IDL_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_SPIMASTER_BR_MDS) & CONF_URT1_MSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_SPISLAVE_BR_MDS ) & CONF_URT1_SSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 0                         ) & CONF_URT1_SC_MASK)   |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT1_LIN_BR_MDS      ) & CONF_URT1_LIN_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT1_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #if CONF_URT1_TM_BRT == 1
                    #define CONF_URT1_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT1_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT1_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (TX_CKS) Transmission clock source select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT1_TX_CKS       URT_CLK_TX_CKS_ext_clk_w
            #else
                #define CONF_URT1_TX_CKS       URT_CLK_TX_CKS_internal_w
            #endif
            // (RX_CKS) Receive clock source select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT1_RX_CKS       URT_CLK_RX_CKS_ext_clk_w
            #else
                #define CONF_URT1_RX_CKS       URT_CLK_RX_CKS_internal_w
            #endif
            // (CLK_CKS) External clock output source select.
            #define CONF_URT1_CLK_CKS      URT_CLK_CLK_CKS_sc_w
            // (CLK_EN) URTx_CLK signal output enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT1_CLK_EN   URT_CLK_CLK_EN_enable_w
            #else
                #define CONF_URT1_CLK_EN   URT_CLK_CLK_EN_disable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT1_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT1_UART_BR_CKSEL      << 1)) & CONF_URT1_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_IRDA_BR_CKSEL      << 1)) & CONF_URT1_IRDA_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_MULTIADR_BR_CKSEL  << 1)) & CONF_URT1_ADR_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_MULTIIDL_BR_CKSEL  << 1)) & CONF_URT1_IDL_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_SPIMASTER_BR_CKSEL << 1)) & CONF_URT1_MSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_SPISLAVE_BR_CKSEL  << 1)) & CONF_URT1_SSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT1_SC_MASK)   |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT1_LIN_BR_CKSEL       << 1)) & CONF_URT1_LIN_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT1_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (DE_GT) URTx_DE signal output guard time select.
            // (DE_INV) URTx_DE signal inverse enable.
            // (DE_EN) URTx_DE signal output enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_UART
                #define CONF_URT1_DE         (CONF_URT1_HWFLOW_DE << 12)
            #else
                #define CONF_URT1_DE         (URT_CR0_DE_GT_1_4_w | URT_CR0_DE_INV_disable_w | URT_CR0_DE_EN_disable_w)
            #endif
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT1_TX_INV         (((CONF_URT1_UART_TX_INV    & CONF_URT1_UART_MASK)| \
                                               (CONF_URT1_IRDA_TX_INV    & CONF_URT1_IRDA_MASK)| \
                                               (CONF_URT1_MULTIADR_TX_INV& CONF_URT1_ADR_MASK) | \
                                               (CONF_URT1_MULTIIDL_TX_INV& CONF_URT1_IDL_MASK))<<11)
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT1_RX_INV         (((CONF_URT1_UART_RX_INV    & CONF_URT1_UART_MASK)| \
                                               (CONF_URT1_IRDA_RX_INV    & CONF_URT1_IRDA_MASK)| \
                                               (CONF_URT1_MULTIADR_RX_INV& CONF_URT1_ADR_MASK) | \
                                               (CONF_URT1_MULTIIDL_RX_INV& CONF_URT1_IDL_MASK))<<10)    
            // (SYNC_MDS) SYNC mode(SPI) select.
            #if defined(URT_CR0_SYNC_MDS_mask_w)
                #define CONF_URT1_SYNC_MDS   ((URT_CR0_SYNC_MDS_master_w & CONF_URT1_MSPI_MASK) |\
                                              (URT_CR0_SYNC_MDS_slave_w  & CONF_URT1_SSPI_MASK))
            #else
                #define CONF_URT1_SYNC_MDS 0
            #endif                           
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT1_IO_SWP         (((CONF_URT1_UART_PINSWAP     & CONF_URT1_UART_MASK)|\
                                               (CONF_URT1_IRDA_PINSWAP     & CONF_URT1_IRDA_MASK)|\
                                               (CONF_URT1_MULTIADR_PINSWAP & CONF_URT1_ADR_MASK) |\
                                               (CONF_URT1_MULTIIDL_PINSWAP & CONF_URT1_IDL_MASK) |\
                                               (CONF_URT1_SPIMASTER_PINSWAP& CONF_URT1_MSPI_MASK)|\
                                               (CONF_URT1_SPISLAVE_PINSWAP & CONF_URT1_SSPI_MASK))<<8)
            // (GSA_EN) Multi-processor global slave address enable.
            #define CONF_URT1_GSA_EN         (((CONF_URT1_MULTIADR_GLOBAL & CONF_URT1_ADR_MASK) |\
                                               (CONF_URT1_MULTIIDL_GLOBAL & CONF_URT1_IDL_MASK))<<7)   
            // (MDS) Mode select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT1_MDS        URT_CR0_MDS_sync_w
            #elif CONF_URT1_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT1_MDS        URT_CR0_MDS_idle_w
            #elif CONF_URT1_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT1_MDS        URT_CR0_MDS_adr_w
            #else
                #define CONF_URT1_MDS        URT_CR0_MDS_uart_w
            #endif
            // (DAT_LINE) Communication data line select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_DATA_LINE  URT_CR0_DAT_LINE_1_w 
            #else
                #define CONF_URT1_DATA_LINE  URT_CR0_DAT_LINE_2_w
            #endif
            // (HDX_EN) Half-duplex mode enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC || CONF_URT1_MODE == CONF_URT_MODE_LIN
                #define CONF_URT1_HDX_EN     URT_CR0_HDX_EN_enable_w 
            #else
                #define CONF_URT1_HDX_EN     URT_CR0_HDX_EN_disable_w
            #endif
            // (EN) Function enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_EN             URT_CR0_EN_disable_w
            #else
                #define CONF_URT1_EN             URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT1_OS_NUM         (((CONF_URT1_UART_BR_OS     & CONF_URT1_UART_MASK) |\
                                               (CONF_URT1_IRDA_BR_OS     & CONF_URT1_IRDA_MASK) |\
                                               (CONF_URT1_MULTIADR_BR_OS & CONF_URT1_ADR_MASK)  |\
                                               (CONF_URT1_MULTIIDL_BR_OS & CONF_URT1_IDL_MASK)  |\
                                               (CONF_URT1_SPIMASTER_BR_OS& CONF_URT1_MSPI_MASK) |\
                                               (CONF_URT1_SPISLAVE_BR_OS & CONF_URT1_SSPI_MASK) |\
                                               (30                       & CONF_URT1_SC_MASK)   |\
                                               (CONF_URT1_LIN_BR_OS      & CONF_URT1_LIN_MASK))<<URT_CR1_RXOS_NUM_shift_w)       
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC || CONF_URT1_MODE == CONF_URT_MODE_LIN
                #define CONF_URT1_STP_LEN    (URT_CR1_RXSTP_LEN_1bit_w)
            #else
                #define CONF_URT1_STP_LEN    (((CONF_URT1_UART_STOP       & CONF_URT1_UART_MASK)  |\
                                               (CONF_URT1_IRDA_STOP       & CONF_URT1_IRDA_MASK)  |\
                                               (CONF_URT1_MULTIADR_STOP   & CONF_URT1_ADR_MASK)   |\
                                               (CONF_URT1_MULTIIDL_STOP   & CONF_URT1_IDL_MASK))<<6)
            #endif
            // (TXMSB_EN) TX data order MSB first enable.
            // (RXMSB_EN) RX data order MSB first enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC || CONF_URT1_MODE == CONF_URT_MODE_LIN
                #define CONF_URT1_MSB_EN     (CONF_URT1_SC_CONVENTION & URT_CR1_RXMSB_EN_mask_w)
            #else
                #define CONF_URT1_MSB_EN     (((CONF_URT1_UART_DATAORDER     & CONF_URT1_UART_MASK)  |\
                                               (CONF_URT1_IRDA_DATAORDER     & CONF_URT1_IRDA_MASK)  |\
                                               (CONF_URT1_MULTIADR_DATAORDER & CONF_URT1_ADR_MASK)   |\
                                               (CONF_URT1_MULTIIDL_DATAORDER & CONF_URT1_IDL_MASK)   |\
                                               (CONF_URT1_SPIMASTER_DATAORDER& CONF_URT1_MSPI_MASK)  |\
                                               (CONF_URT1_SPISLAVE_DATAORDER & CONF_URT1_SSPI_MASK))<<5)
                                               
            #endif     
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_PAR         (URT_CR1_RXPAR_STK_disable_w | URT_CR1_RXPAR_EN_mask_w | (CONF_URT1_SC_CONVENTION & URT_CR1_RXPAR_POL_mask_w))
            #else
                #define CONF_URT1_PAR         (((CONF_URT1_UART_PARITY     & CONF_URT1_UART_MASK) |\
                                                (CONF_URT1_IRDA_PARITY     & CONF_URT1_IRDA_MASK)|\
                                                (CONF_URT1_MULTIADR_PARITY & CONF_URT1_ADR_MASK) |\
                                                (CONF_URT1_MULTIIDL_PARITY & CONF_URT1_IDL_MASK) |\
                                                (0                         & CONF_URT1_LIN_MASK))<<2)
            #endif
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT1_DSIZE           ((CONF_URT1_UART_DATABIT     & CONF_URT1_UART_MASK) | \
                                               (CONF_URT1_IRDA_DATABIT     & CONF_URT1_IRDA_MASK) | \
                                               (CONF_URT1_MULTIADR_DATABIT & CONF_URT1_ADR_MASK)  | \
                                               (CONF_URT1_MULTIIDL_DATABIT & CONF_URT1_IDL_MASK))                                 
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (DOUT_IDL) SPI master mode idle state data output value.
            // (DOUT_MDS) SPI master standard mode idle state data output mode select.
            #if defined(URT_CR2_DOUT_MDS_mask_w)
                #define CONF_URT1_DOUT        ((CONF_URT1_SPIMASTER_DOUT << 29) & CONF_URT1_MSPI_MASK)
            #else
                #define CONF_URT1_DOUT        0
            #endif
            // (NSSI_EN) NSS signal input function enable when UART configure to synchronous mode SPI slave.
            #if defined(URT_CR2_NSSI_EN_mask_w)
                #define CONF_URT1_NSSI_EN     (URT_CR2_NSSI_EN_enable_w & CONF_URT1_SSPI_MASK)
            #else
                #define CONF_URT1_NSSI_EN     0
            #endif
            // (TX_EN) Transmitter enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT1_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT1_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*CR3    (Control Register 3)*/
        #if 1
            // (TXGT_LEN) TX guard time.
            #define CONF_URT1_TXGT_LEN        ((CONF_URT1_SC_GT<<16) & CONF_URT1_SC_MASK)
            // (DET_IDL) Idle line detect threshold value.
            #define CONF_URT1_DET_IDL         (((CONF_URT1_MULTIIDL_IDL-1) << 8) & CONF_URT1_IDL_MASK)
            // (DET_BK) Bit time select for break detection or transmission.
            #define CONF_URT1_DET_BK          ((CONF_URT1_LIN_BK << 4) & CONF_URT1_LIN_MASK)
            // (CPHA) Clock phase select.
            #define CONF_URT1_CPHA            (((CONF_URT1_SPIMASTER_CPHA & CONF_URT1_MSPI_MASK)| \
                                                (CONF_URT1_SPISLAVE_CPHA  & CONF_URT1_SSPI_MASK))<<2)
            // (CPOL) Clock polarity select.
            #define CONF_URT1_CPOL            (((CONF_URT1_SPIMASTER_CPOL & CONF_URT1_MSPI_MASK)| \
                                                (CONF_URT1_SPISLAVE_CPOL  & CONF_URT1_SSPI_MASK))<<1)
        #endif
        /*CR4    (Control Register 4)*/
        #if 1
            // (TDAT_CLR) Transmitted data clear enable.
            #define CONF_URT1_TDAT_CLR        URT_CR4_TDAT_CLR_enable_w
            // (RDAT_CLR) Receive data clear enable.
            #define CONF_URT1_RDAT_CLR        URT_CR4_RDAT_CLR_enable_w
            // (TDAT_INV) Inverse transmitted data enable.
            // (RDAT_INV) Inverse received data enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_DAT_INV         ((CONF_URT1_SC_CONVENTION >> 16) & (URT_CR4_TDAT_INV_mask_w | URT_CR4_RDAT_INV_mask_w))
            #else
                #define CONF_URT1_DAT_INV         ((((CONF_URT1_UART_DATAINV     << 5) | (CONF_URT1_UART_DATAINV     << 4)) & CONF_URT1_UART_MASK)| \
                                                   (((CONF_URT1_IRDA_DATAINV     << 5) | (CONF_URT1_IRDA_DATAINV     << 4)) & CONF_URT1_IRDA_MASK)| \
                                                   (((CONF_URT1_MULTIADR_DATAINV << 5) | (CONF_URT1_MULTIADR_DATAINV << 4)) & CONF_URT1_ADR_MASK) | \
                                                   (((CONF_URT1_MULTIIDL_DATAINV << 5) | (CONF_URT1_MULTIIDL_DATAINV << 4)) & CONF_URT1_IDL_MASK) | \
                                                   (((CONF_URT1_SPIMASTER_DATAINV<< 5) | (CONF_URT1_SPIMASTER_DATAINV<< 4)) & CONF_URT1_MSPI_MASK)| \
                                                   (((CONF_URT1_SPISLAVE_DATAINV << 5) | (CONF_URT1_SPISLAVE_DATAINV << 4)) & CONF_URT1_SSPI_MASK))
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #if CONF_URT1_Freq < 5000000 
                #define CONF_URT1_PSR             (((CONF_URT1_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT1_UART_MASK) | \
                                                   ((CONF_URT1_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT1_IRDA_MASK) | \
                                                   ((CONF_URT1_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_ADR_MASK)  | \
                                                   ((CONF_URT1_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_IDL_MASK)  | \
                                                   ((CONF_URT1_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT1_MSPI_MASK) | \
                                                   ((CONF_URT1_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_SSPI_MASK) | \
                                                   ((0                         << URT_RLR_PSR_shift_w) & CONF_URT1_SC_MASK)   | \
                                                   ((CONF_URT1_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT1_LIN_MASK)  | \
                                                   (((CONF_URT1_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT1_TM_MASK))
            #else
                #define CONF_URT1_PSR             (((CONF_URT1_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT1_UART_MASK) | \
                                                   ((CONF_URT1_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT1_IRDA_MASK) | \
                                                   ((CONF_URT1_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_ADR_MASK)  | \
                                                   ((CONF_URT1_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_IDL_MASK)  | \
                                                   ((CONF_URT1_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT1_MSPI_MASK) | \
                                                   ((CONF_URT1_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT1_SSPI_MASK) | \
                                                   (((CONF_URT1_Freq/5000000)  << URT_RLR_PSR_shift_w) & CONF_URT1_SC_MASK)   | \
                                                   ((CONF_URT1_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT1_LIN_MASK)  | \
                                                   (((CONF_URT1_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT1_TM_MASK))
            #endif
            // (RLR) Baud-rate clock counter reload register.
            #if CONF_URT1_Freq < 5000000
                #define CONF_URT1_RLR             (((CONF_URT1_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT1_UART_MASK) | \
                                                   ((CONF_URT1_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT1_IRDA_MASK) | \
                                                   ((CONF_URT1_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_ADR_MASK)  | \
                                                   ((CONF_URT1_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_IDL_MASK)  | \
                                                   ((CONF_URT1_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT1_MSPI_MASK) | \
                                                   ((CONF_URT1_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT1_SC_MASK)   | \
                                                   ((CONF_URT1_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT1_LIN_MASK)  | \
                                                   (((CONF_URT1_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT1_TM_MASK))
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT1_RLR             (((CONF_URT1_UART_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT1_UART_MASK) | \
                                                   ((CONF_URT1_IRDA_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT1_IRDA_MASK) | \
                                                   ((CONF_URT1_MULTIADR_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT1_ADR_MASK)  | \
                                                   ((CONF_URT1_MULTIIDL_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT1_IDL_MASK)  | \
                                                   ((CONF_URT1_SPIMASTER_BR_BR                                 << URT_RLR_RLR_shift_w) & CONF_URT1_MSPI_MASK) | \
                                                   ((CONF_URT1_SPISLAVE_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT1_SSPI_MASK) | \
                                                   (((11*((CONF_URT1_Freq/5000000)+1)+(CONF_URT1_Freq/5000000))<< URT_RLR_RLR_shift_w) & CONF_URT1_SC_MASK)   | \
                                                   ((CONF_URT1_LIN_BR_BR                                       << URT_RLR_RLR_shift_w) & CONF_URT1_LIN_MASK)  | \
                                                   (((CONF_URT1_TM_BRTRLR-1)                                   &  URT_RLR_RLR_mask_w)  & CONF_URT1_TM_MASK))
            #else
                #define CONF_URT1_RLR             (((CONF_URT1_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT1_UART_MASK) | \
                                                   ((CONF_URT1_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT1_IRDA_MASK) | \
                                                   ((CONF_URT1_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_ADR_MASK)  | \
                                                   ((CONF_URT1_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_IDL_MASK)  | \
                                                   ((CONF_URT1_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT1_MSPI_MASK) | \
                                                   ((CONF_URT1_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT1_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT1_SC_MASK)   | \
                                                   ((CONF_URT1_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT1_LIN_MASK)  | \
                                                   (((CONF_URT1_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT1_TM_MASK))
            #endif
        #endif
        /*TMOUT  (Timeout control register)*/
        #if 1
            // (TMO_CKS) Timeout timer clock source select.
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_TMO_CKS     (URT_TMOUT_TMO_CKS_input_w)
            #else
                #define CONF_URT1_TMO_CKS     (URT_TMOUT_TMO_CKS_uart_w)
            #endif
            // (IDTMO_EN) Idle timeout detection enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_IDTMO_EN    (URT_TMOUT_IDTMO_EN_enable_w)
            #else
                #define CONF_URT1_IDTMO_EN    (URT_TMOUT_IDTMO_EN_disable_w)
            #endif 
            // (TMO_MDS) Timeout timer mode select.
            #if CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_TMO_MDS     (URT_TMOUT_TMO_MDS_general_w)
            #else
                #define CONF_URT1_TMO_MDS     (URT_TMOUT_TMO_MDS_uart_w)
            #endif
            // (TMO_RST) Timeout timer force reset enable.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC || CONF_URT1_MODE == CONF_URT_MODE_TM 
                #define CONF_URT1_RST         (URT_TMOUT_TMO_RST_enable_w)
            #else
                #define CONF_URT1_RST         0
            #endif
            // (TMO_EN) Timeout timer enable
            #if CONF_URT1_MODE == CONF_URT_MODE_MULTI_IDL || CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)
            #elif CONF_URT1_MODE == CONF_URT_MODE_TM && CONF_URT1_TM_TMO == 1
                #define CONF_URT1_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)    
            #else
                #define CONF_URT1_TMO_EN      0
            #endif
        #endif
        /*TMOUT2 (Timeout control register 2)*/
        #if 1
            // (IDTMO_TH) Receive idle timeout detect threshold value by using receive bit time.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_IDTMO_TH        CONF_URT1_SC_WT
            #elif CONF_URT1_MODE == CONF_URT_MODE_TM
                #define CONF_URT1_IDTMO_TH        (CONF_URT1_TM_TMORLR-1)
            #else
                #define CONF_URT1_IDTMO_TH        0
            #endif
        #endif
        /*SC     (SmartCard control register)*/
        #if 1
            // (RXE_NUM) RX parity error detect and NACK transmission retry maximum number.
            #define CONF_URT1_RXE_NUM         ((CONF_URT1_SC_RXERRORTIME << 12) & CONF_URT1_SC_MASK)
            // (TXE_NUM) TX error detect and data resend maximum number
            #define CONF_URT1_TXE_NUM         ((CONF_URT1_SC_TXERRORTIME << 8)  & CONF_URT1_SC_MASK)
            // (RXE_LEN) RX parity error detect and NACK transmission bit time length select.
            #define CONF_URT1_RXE_LEN         ((CONF_URT1_SC_RXERRORSIG  << 4)  & CONF_URT1_SC_MASK)
            // (TXE_MDS) TX error detect mode select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_TXE_MDS     (URT_SC_TXE_MDS_chk_low_w)
            #elif CONF_URT1_MODE == CONF_URT_MODE_LIN
                #define CONF_URT1_TXE_MDS     (URT_SC_TXE_MDS_chk_tx_w)
            #else
                #define CONF_URT1_TXE_MDS     (URT_SC_TXE_MDS_disable_w)
            #endif
            // (RXE_MDS) RX parity error detect control mode select.
            #if CONF_URT1_MODE == CONF_URT_MODE_SC
                #define CONF_URT1_RXE_MDS     (URT_SC_RXE_MDS_enable_w) 
            #else
                #define CONF_URT1_RXE_MDS     (URT_SC_RXE_MDS_disable_w)
            #endif
        #endif
        /*SADR   (URT1 slave address detect register)*/
        #if 1
            // (SA_MSK) Multi-processor slave address mask register.
            #define CONF_URT1_SA_MSK          (((CONF_URT1_MULTIADR_ADRMASK << 8) & CONF_URT1_ADR_MASK) | \
                                               ((CONF_URT1_MULTIIDL_ADRMASK << 8) & CONF_URT1_IDL_MASK))
            // (SA_RX) Multi-processor mode received slave address.
            #define CONF_URT1_SA_RX           ((CONF_URT1_MULTIADR_ADR & CONF_URT1_ADR_MASK) | \
                                               (CONF_URT1_MULTIIDL_ADR & CONF_URT1_IDL_MASK))
        #endif
        /*CAL    (Calibration control register)*/
        #if 1
            // (CAL_MDS) Auto baud-rate calibration mode select.
            // (CAL_AUTO) Break detection and auto baud-rate calibration enable.
            #define CONF_URT1_CAL             ((CONF_URT1_LIN_CAL) & CONF_URT1_LIN_MASK)
        #endif
        /*IRDA   (IrDA control register)*/
        #if 1
            // (IR_MDS) IrDA data received mode select.
            // (IR_EN) IrDA data format enable.
            #define CONF_URT1_IR              ((0x00000002 | URT_IRDA_IR_EN_enable_w) & CONF_URT1_IRDA_MASK)
        #endif
        /*HFC    (Hardware flow control register)*/
        #if 1
            // (RTS_INV) RTS output inverse enable.
            // (CTS_INV) CTS input inverse enable.
            // (RTS_EN)  RTS hardware flow control enable.
            // (CTS_EN)  CTS hardware flow control enable.
            #define CONF_URT1_HFC             (((CONF_URT1_HWFLOW_RTS << 1) | CONF_URT1_HWFLOW_CTS) & CONF_URT1_UART_MASK)        
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT1_CALC            ((((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT1_UART_BR_CALC     )& CONF_URT1_UART_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IRDA_OS_MIN << 16)) * CONF_URT1_IRDA_BR_CALC     )& CONF_URT1_IRDA_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_ADR_OS_MIN  << 16)) * CONF_URT1_MULTIADR_BR_CALC )& CONF_URT1_ADR_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IDL_OS_MIN  << 16)) * CONF_URT1_MULTIIDL_BR_CALC )& CONF_URT1_IDL_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_MSPI_OS_MIN << 16)) * CONF_URT1_SPIMASTER_BR_CALC)& CONF_URT1_MSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_SSPI_OS_MIN << 16)) * CONF_URT1_SPISLAVE_BR_CALC )& CONF_URT1_SSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_LIN_OS_MIN  << 16)) * CONF_URT1_LIN_BR_CALC      )& CONF_URT1_LIN_MASK))
                                               
            #define CONF_URT1_BaudRate_Config ((CONF_URT1_UART_BR_CALC     & CONF_URT1_UART_MASK) | \
                                               (CONF_URT1_IRDA_BR_CALC     & CONF_URT1_IRDA_MASK) | \
                                               (CONF_URT1_MULTIADR_BR_CALC & CONF_URT1_ADR_MASK)  | \
                                               (CONF_URT1_MULTIIDL_BR_CALC & CONF_URT1_IDL_MASK)  | \
                                               (CONF_URT1_SPIMASTER_BR_CALC& CONF_URT1_MSPI_MASK) | \
                                               (CONF_URT1_SPISLAVE_BR_CALC & CONF_URT1_SSPI_MASK) | \
                                               (CONF_URT1_LIN_BR_CALC      & CONF_URT1_LIN_MASK))                                          
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT1_BD              ((CONF_URT1_UART_BR      & CONF_URT1_UART_MASK) | \
                                               (CONF_URT1_IRDA_BR      & CONF_URT1_IRDA_MASK) | \
                                               (CONF_URT1_MULTIADR_BR  & CONF_URT1_ADR_MASK)  | \
                                               (CONF_URT1_MULTIIDL_BR  & CONF_URT1_IDL_MASK)  | \
                                               (CONF_URT1_SPIMASTER_BR & CONF_URT1_MSPI_MASK) | \
                                               (CONF_URT1_SPISLAVE_BR  & CONF_URT1_SSPI_MASK) | \
                                               (CONF_URT1_LIN_BR       & CONF_URT1_LIN_MASK))
        #endif
    #endif
#else
    #define CONF_URT1_INIT_EN          0
    #define CONF_URT1_BaudRate_Config  0
    #define CONF_URT1_MODE             CONF_URT_MODE_NA
#endif
#if CONF_URT1_INIT_EN == 1
static const uint32_t CONF_URT1[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT1_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT1_BR_CKS)  | \
     (CONF_URT1_BR_MDS)  | \
     (CONF_URT1_BR_EN)   | \
     (CONF_URT1_TX_CKS)  | \
     (CONF_URT1_RX_CKS)  | \
     (CONF_URT1_CLK_CKS) | \
     (CONF_URT1_CLK_EN)  | \
     (CONF_URT1_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT1_DE)        | \
     (CONF_URT1_TX_INV)    | \
     (CONF_URT1_RX_INV)    | \
     (CONF_URT1_SYNC_MDS)  | \
     (CONF_URT1_IO_SWP)    | \
     (CONF_URT1_GSA_EN)    | \
     (CONF_URT1_MDS)       | \
     (CONF_URT1_DATA_LINE) | \
     (CONF_URT1_HDX_EN)    | \
     (CONF_URT1_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT1_OS_NUM << 16 ) | (CONF_URT1_OS_NUM)) | \
     ((CONF_URT1_STP_LEN<< 16 ) | (CONF_URT1_STP_LEN))| \
     ((CONF_URT1_MSB_EN << 16 ) | (CONF_URT1_MSB_EN)) | \
     ((CONF_URT1_PAR    << 16 ) | (CONF_URT1_PAR))    | \
     ((CONF_URT1_DSIZE  << 16 ) | (CONF_URT1_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT1_DOUT)     | \
     (CONF_URT1_NSSI_EN)  | \
     (CONF_URT1_TX_EN)    | \
     (CONF_URT1_RX_EN)),
    /*CR3    (Control Register 3)*/
    ((CONF_URT1_TXGT_LEN) | \
     (CONF_URT1_DET_IDL)  | \
     (CONF_URT1_DET_BK)   | \
     (CONF_URT1_CPHA)     | \
     (CONF_URT1_CPOL)),
    /*CR4    (Control Register 4)*/
    ((CONF_URT1_TDAT_CLR) | \
     (CONF_URT1_RDAT_CLR) | \
     (CONF_URT1_DAT_INV)), 
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT1_PSR) | \
     (CONF_URT1_RLR)),   
    /*TMOUT  (Timeout control register)*/
    ((CONF_URT1_TMO_CKS) | \
     (CONF_URT1_IDTMO_EN)| \
     (CONF_URT1_TMO_MDS) | \
     (CONF_URT1_RST)     | \
     (CONF_URT1_TMO_EN)),  
    /*TMOUT2 (Timeout control register 2)*/
    (CONF_URT1_IDTMO_TH),
    /*SC     (SmartCard control register)*/
    ((CONF_URT1_RXE_NUM) | \
     (CONF_URT1_TXE_NUM) | \
     (CONF_URT1_RXE_LEN) | \
     (CONF_URT1_TXE_MDS) | \
     (CONF_URT1_RXE_MDS)),
    /*SADR   (URT1 slave address detect register)*/
    ((CONF_URT1_SA_MSK) | \
     (CONF_URT1_SA_RX)),
    /*CAL    (Calibration control register)*/
    (CONF_URT1_CAL),
    /*IRDA   (IrDA control register)*/
    (CONF_URT1_IR),
    /*HFC    (Hardware flow control register)*/
    (CONF_URT1_HFC),
    /*Baud-rate calculation mode*/
    (CONF_URT1_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT1_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT1_BD)
};
#endif

/* URT2 Related Configure-----------------------------------------------*/
#if defined(URT2_Base) 
    /*Disable or Enable check*/
    #if CONF_URT2_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT2_INIT_EN          0
        #define CONF_URT2_BaudRate_Config  0
    #else
        #define CONF_URT2_INIT_EN          1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT2_MODE == CONF_URT_MODE_UART
                #define CONF_URT2_UART_MASK  0xFFFFFFFF
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_IRDA
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0xFFFFFFFF
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0xFFFFFFFF
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0  
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0xFFFFFFFF
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0xFFFFFFFF
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0xFFFFFFFF
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0xFFFFFFFF
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_LIN
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0xFFFFFFFF
                #define CONF_URT2_TM_MASK    0
            #elif CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT2_UART_MASK  0
                #define CONF_URT2_IRDA_MASK  0
                #define CONF_URT2_ADR_MASK   0
                #define CONF_URT2_IDL_MASK   0
                #define CONF_URT2_MSPI_MASK  0
                #define CONF_URT2_SSPI_MASK  0
                #define CONF_URT2_SC_MASK    0
                #define CONF_URT2_LIN_MASK   0
                #define CONF_URT2_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT2_INT    ((URT_INT_IEA_mask_w      * CONF_URT2_IEA)    | \
                                      (URT_INT_UG_IE_mask_w    * CONF_URT2_UGFIE)  | \
                                      (URT_INT_TC_IE_mask_w    * CONF_URT2_TCIE)   | \
                                      (URT_INT_ERR_IE_mask_w   * CONF_URT2_ERRIE)  | \
                                      (URT_INT_LS_IE_mask_w    * CONF_URT2_LSIE)   | \
                                      (URT_INT_RX_IE_mask_w    * CONF_URT2_RXIE)   | \
                                      (URT_INT_TX_IE_mask_w    * CONF_URT2_TXIE)   | \
                                      (URT_INT_SADR_IE_mask_w  * CONF_URT2_SADRIE) | \
                                      (URT_INT_BRT_IE_mask_w   * CONF_URT2_BRTIE)  | \
                                      (URT_INT_TMO_IE_mask_w   * CONF_URT2_TMOIE)  | \
                                      (URT_INT_CALC_IE_mask_w  * CONF_URT2_CALCIE) | \
                                      (URT_INT_BK_IE_mask_w    * CONF_URT2_BKIE)   | \
                                      (URT_INT_IDL_IE_mask_w   * CONF_URT2_IDLIE)  | \
                                      (URT_INT_CTS_IE_mask_w   * CONF_URT2_CTSIE)  | \
                                      (URT_INT_NSS_IE_mask_w   * CONF_URT2_NSSIE)  | \
                                      (URT_INT_PE_IE_mask_w    * CONF_URT2_PEIE)   | \
                                      (URT_INT_FE_IE_mask_w    * CONF_URT2_FEIE)   | \
                                      (URT_INT_NCE_IE_mask_w   * CONF_URT2_NCEIE)  | \
                                      (URT_INT_ROVR_IE_mask_w  * CONF_URT2_ROVRIE) | \
                                      (URT_INT_TXE_IE_mask_w   * CONF_URT2_TXEIE)  | \
                                      (URT_INT_TUDR_IE_mask_w  * CONF_URT2_TUDRIE) | \
                                      (URT_INT_RXTMO_IE_mask_w * CONF_URT2_RXTMOIE)| \
                                      (URT_INT_IDTMO_IE_mask_w * CONF_URT2_IDMO_IE)| \
                                      (URT_INT_BKTMO_IE_mask_w * CONF_URT2_BKTMOIE)| \
                                      (URT_INT_CALTMO_IE_mask_w* CONF_URT2_CALTMOIE)) 
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_CKS) Baud-rate timer clock source select.
            #if CONF_URT2_MODE != CONF_URT_MODE_SC
                #define CONF_URT2_BR_CKS  0
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT2_BR_CKS  URT_CLK_BR_CKS_ck_urtx_w
            #else
                #define CONF_URT2_BR_CKS  0
            #endif
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT2_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT2_UART_BR_MDS     ) & CONF_URT2_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_IRDA_BR_MDS     ) & CONF_URT2_IRDA_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_MULTIADR_BR_MDS ) & CONF_URT2_ADR_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_MULTIIDL_BR_MDS ) & CONF_URT2_IDL_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_SPIMASTER_BR_MDS) & CONF_URT2_MSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_SPISLAVE_BR_MDS ) & CONF_URT2_SSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 0                         ) & CONF_URT2_SC_MASK)   |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT2_LIN_BR_MDS      ) & CONF_URT2_LIN_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT2_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #if CONF_URT2_TM_BRT == 1
                    #define CONF_URT2_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT2_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT2_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (TX_CKS) Transmission clock source select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT2_TX_CKS       URT_CLK_TX_CKS_ext_clk_w
            #else
                #define CONF_URT2_TX_CKS       URT_CLK_TX_CKS_internal_w
            #endif
            // (RX_CKS) Receive clock source select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT2_RX_CKS       URT_CLK_RX_CKS_ext_clk_w
            #else
                #define CONF_URT2_RX_CKS       URT_CLK_RX_CKS_internal_w
            #endif
            // (CLK_CKS) External clock output source select.
            #define CONF_URT2_CLK_CKS      URT_CLK_CLK_CKS_sc_w
            // (CLK_EN) URTx_CLK signal output enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT2_CLK_EN   URT_CLK_CLK_EN_enable_w
            #else
                #define CONF_URT2_CLK_EN   URT_CLK_CLK_EN_disable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT2_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT2_UART_BR_CKSEL      << 1)) & CONF_URT2_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_IRDA_BR_CKSEL      << 1)) & CONF_URT2_IRDA_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_MULTIADR_BR_CKSEL  << 1)) & CONF_URT2_ADR_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_MULTIIDL_BR_CKSEL  << 1)) & CONF_URT2_IDL_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_SPIMASTER_BR_CKSEL << 1)) & CONF_URT2_MSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_SPISLAVE_BR_CKSEL  << 1)) & CONF_URT2_SSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT2_SC_MASK)   |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT2_LIN_BR_CKSEL       << 1)) & CONF_URT2_LIN_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT2_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (DE_GT) URTx_DE signal output guard time select.
            // (DE_INV) URTx_DE signal inverse enable.
            // (DE_EN) URTx_DE signal output enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_UART
                #define CONF_URT2_DE         (CONF_URT2_HWFLOW_DE << 12)
            #else
                #define CONF_URT2_DE         (URT_CR0_DE_GT_1_4_w | URT_CR0_DE_INV_disable_w | URT_CR0_DE_EN_disable_w)
            #endif
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT2_TX_INV         (((CONF_URT2_UART_TX_INV    & CONF_URT2_UART_MASK)| \
                                               (CONF_URT2_IRDA_TX_INV    & CONF_URT2_IRDA_MASK)| \
                                               (CONF_URT2_MULTIADR_TX_INV& CONF_URT2_ADR_MASK) | \
                                               (CONF_URT2_MULTIIDL_TX_INV& CONF_URT2_IDL_MASK))<<11)
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT2_RX_INV         (((CONF_URT2_UART_RX_INV    & CONF_URT2_UART_MASK)| \
                                               (CONF_URT2_IRDA_RX_INV    & CONF_URT2_IRDA_MASK)| \
                                               (CONF_URT2_MULTIADR_RX_INV& CONF_URT2_ADR_MASK) | \
                                               (CONF_URT2_MULTIIDL_RX_INV& CONF_URT2_IDL_MASK))<<10)    
            // (SYNC_MDS) SYNC mode(SPI) select.
            #if defined(URT_CR0_SYNC_MDS_mask_w)
                #define CONF_URT2_SYNC_MDS   ((URT_CR0_SYNC_MDS_master_w & CONF_URT2_MSPI_MASK) |\
                                              (URT_CR0_SYNC_MDS_slave_w  & CONF_URT2_SSPI_MASK))
            #else
                #define CONF_URT2_SYNC_MDS 0
            #endif                           
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT2_IO_SWP         (((CONF_URT2_UART_PINSWAP     & CONF_URT2_UART_MASK)|\
                                               (CONF_URT2_IRDA_PINSWAP     & CONF_URT2_IRDA_MASK)|\
                                               (CONF_URT2_MULTIADR_PINSWAP & CONF_URT2_ADR_MASK) |\
                                               (CONF_URT2_MULTIIDL_PINSWAP & CONF_URT2_IDL_MASK) |\
                                               (CONF_URT2_SPIMASTER_PINSWAP& CONF_URT2_MSPI_MASK)|\
                                               (CONF_URT2_SPISLAVE_PINSWAP & CONF_URT2_SSPI_MASK))<<8)
            // (GSA_EN) Multi-processor global slave address enable.
            #define CONF_URT2_GSA_EN         (((CONF_URT2_MULTIADR_GLOBAL & CONF_URT2_ADR_MASK) |\
                                               (CONF_URT2_MULTIIDL_GLOBAL & CONF_URT2_IDL_MASK))<<7)   
            // (MDS) Mode select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT2_MDS        URT_CR0_MDS_sync_w
            #elif CONF_URT2_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT2_MDS        URT_CR0_MDS_idle_w
            #elif CONF_URT2_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT2_MDS        URT_CR0_MDS_adr_w
            #else
                #define CONF_URT2_MDS        URT_CR0_MDS_uart_w
            #endif
            // (DAT_LINE) Communication data line select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_DATA_LINE  URT_CR0_DAT_LINE_1_w 
            #else
                #define CONF_URT2_DATA_LINE  URT_CR0_DAT_LINE_2_w
            #endif
            // (HDX_EN) Half-duplex mode enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC || CONF_URT2_MODE == CONF_URT_MODE_LIN
                #define CONF_URT2_HDX_EN     URT_CR0_HDX_EN_enable_w 
            #else
                #define CONF_URT2_HDX_EN     URT_CR0_HDX_EN_disable_w
            #endif
            // (EN) Function enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_EN             URT_CR0_EN_disable_w
            #else
                #define CONF_URT2_EN             URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT2_OS_NUM         (((CONF_URT2_UART_BR_OS     & CONF_URT2_UART_MASK) |\
                                               (CONF_URT2_IRDA_BR_OS     & CONF_URT2_IRDA_MASK) |\
                                               (CONF_URT2_MULTIADR_BR_OS & CONF_URT2_ADR_MASK)  |\
                                               (CONF_URT2_MULTIIDL_BR_OS & CONF_URT2_IDL_MASK)  |\
                                               (CONF_URT2_SPIMASTER_BR_OS& CONF_URT2_MSPI_MASK) |\
                                               (CONF_URT2_SPISLAVE_BR_OS & CONF_URT2_SSPI_MASK) |\
                                               (30                       & CONF_URT2_SC_MASK)   |\
                                               (CONF_URT2_LIN_BR_OS      & CONF_URT2_LIN_MASK))<<URT_CR1_RXOS_NUM_shift_w)       
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC || CONF_URT2_MODE == CONF_URT_MODE_LIN
                #define CONF_URT2_STP_LEN    (URT_CR1_RXSTP_LEN_1bit_w)
            #else
                #define CONF_URT2_STP_LEN    (((CONF_URT2_UART_STOP       & CONF_URT2_UART_MASK)  |\
                                               (CONF_URT2_IRDA_STOP       & CONF_URT2_IRDA_MASK)  |\
                                               (CONF_URT2_MULTIADR_STOP   & CONF_URT2_ADR_MASK)   |\
                                               (CONF_URT2_MULTIIDL_STOP   & CONF_URT2_IDL_MASK))<<6)
            #endif
            // (TXMSB_EN) TX data order MSB first enable.
            // (RXMSB_EN) RX data order MSB first enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC || CONF_URT2_MODE == CONF_URT_MODE_LIN
                #define CONF_URT2_MSB_EN     (CONF_URT2_SC_CONVENTION & URT_CR1_RXMSB_EN_mask_w)
            #else
                #define CONF_URT2_MSB_EN     (((CONF_URT2_UART_DATAORDER     & CONF_URT2_UART_MASK)  |\
                                               (CONF_URT2_IRDA_DATAORDER     & CONF_URT2_IRDA_MASK)  |\
                                               (CONF_URT2_MULTIADR_DATAORDER & CONF_URT2_ADR_MASK)   |\
                                               (CONF_URT2_MULTIIDL_DATAORDER & CONF_URT2_IDL_MASK)   |\
                                               (CONF_URT2_SPIMASTER_DATAORDER& CONF_URT2_MSPI_MASK)  |\
                                               (CONF_URT2_SPISLAVE_DATAORDER & CONF_URT2_SSPI_MASK))<<5)
                                               
            #endif     
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_PAR         (URT_CR1_RXPAR_STK_disable_w | URT_CR1_RXPAR_EN_mask_w | (CONF_URT2_SC_CONVENTION & URT_CR1_RXPAR_POL_mask_w))
            #else
                #define CONF_URT2_PAR         (((CONF_URT2_UART_PARITY     & CONF_URT2_UART_MASK) |\
                                                (CONF_URT2_IRDA_PARITY     & CONF_URT2_IRDA_MASK)|\
                                                (CONF_URT2_MULTIADR_PARITY & CONF_URT2_ADR_MASK) |\
                                                (CONF_URT2_MULTIIDL_PARITY & CONF_URT2_IDL_MASK) |\
                                                (0                         & CONF_URT2_LIN_MASK))<<2)
            #endif
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT2_DSIZE           ((CONF_URT2_UART_DATABIT     & CONF_URT2_UART_MASK) | \
                                               (CONF_URT2_IRDA_DATABIT     & CONF_URT2_IRDA_MASK) | \
                                               (CONF_URT2_MULTIADR_DATABIT & CONF_URT2_ADR_MASK)  | \
                                               (CONF_URT2_MULTIIDL_DATABIT & CONF_URT2_IDL_MASK))                                 
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (DOUT_IDL) SPI master mode idle state data output value.
            // (DOUT_MDS) SPI master standard mode idle state data output mode select.
            #if defined(URT_CR2_DOUT_MDS_mask_w)
                #define CONF_URT2_DOUT        ((CONF_URT2_SPIMASTER_DOUT << 29) & CONF_URT2_MSPI_MASK)
            #else
                #define CONF_URT2_DOUT        0
            #endif
            // (NSSI_EN) NSS signal input function enable when UART configure to synchronous mode SPI slave.
            #if defined(URT_CR2_NSSI_EN_mask_w)
                #define CONF_URT2_NSSI_EN     (URT_CR2_NSSI_EN_enable_w & CONF_URT2_SSPI_MASK)
            #else
                #define CONF_URT2_NSSI_EN     0
            #endif
            // (TX_EN) Transmitter enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT2_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT2_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*CR3    (Control Register 3)*/
        #if 1
            // (TXGT_LEN) TX guard time.
            #define CONF_URT2_TXGT_LEN        ((CONF_URT2_SC_GT<<16) & CONF_URT2_SC_MASK)
            // (DET_IDL) Idle line detect threshold value.
            #define CONF_URT2_DET_IDL         (((CONF_URT2_MULTIIDL_IDL-1) << 8) & CONF_URT2_IDL_MASK)
            // (DET_BK) Bit time select for break detection or transmission.
            #define CONF_URT2_DET_BK          ((CONF_URT2_LIN_BK << 4) & CONF_URT2_LIN_MASK)
            // (CPHA) Clock phase select.
            #define CONF_URT2_CPHA            (((CONF_URT2_SPIMASTER_CPHA & CONF_URT2_MSPI_MASK)| \
                                                (CONF_URT2_SPISLAVE_CPHA  & CONF_URT2_SSPI_MASK))<<2)
            // (CPOL) Clock polarity select.
            #define CONF_URT2_CPOL            (((CONF_URT2_SPIMASTER_CPOL & CONF_URT2_MSPI_MASK)| \
                                                (CONF_URT2_SPISLAVE_CPOL  & CONF_URT2_SSPI_MASK))<<1)
        #endif
        /*CR4    (Control Register 4)*/
        #if 1
            // (TDAT_CLR) Transmitted data clear enable.
            #define CONF_URT2_TDAT_CLR        URT_CR4_TDAT_CLR_enable_w
            // (RDAT_CLR) Receive data clear enable.
            #define CONF_URT2_RDAT_CLR        URT_CR4_RDAT_CLR_enable_w
            // (TDAT_INV) Inverse transmitted data enable.
            // (RDAT_INV) Inverse received data enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_DAT_INV         ((CONF_URT2_SC_CONVENTION >> 16) & (URT_CR4_TDAT_INV_mask_w | URT_CR4_RDAT_INV_mask_w))
            #else
                #define CONF_URT2_DAT_INV         ((((CONF_URT2_UART_DATAINV     << 5) | (CONF_URT2_UART_DATAINV     << 4)) & CONF_URT2_UART_MASK)| \
                                                   (((CONF_URT2_IRDA_DATAINV     << 5) | (CONF_URT2_IRDA_DATAINV     << 4)) & CONF_URT2_IRDA_MASK)| \
                                                   (((CONF_URT2_MULTIADR_DATAINV << 5) | (CONF_URT2_MULTIADR_DATAINV << 4)) & CONF_URT2_ADR_MASK) | \
                                                   (((CONF_URT2_MULTIIDL_DATAINV << 5) | (CONF_URT2_MULTIIDL_DATAINV << 4)) & CONF_URT2_IDL_MASK) | \
                                                   (((CONF_URT2_SPIMASTER_DATAINV<< 5) | (CONF_URT2_SPIMASTER_DATAINV<< 4)) & CONF_URT2_MSPI_MASK)| \
                                                   (((CONF_URT2_SPISLAVE_DATAINV << 5) | (CONF_URT2_SPISLAVE_DATAINV << 4)) & CONF_URT2_SSPI_MASK))
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #if CONF_URT2_Freq < 5000000 
                #define CONF_URT2_PSR             (((CONF_URT2_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT2_UART_MASK) | \
                                                   ((CONF_URT2_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT2_IRDA_MASK) | \
                                                   ((CONF_URT2_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_ADR_MASK)  | \
                                                   ((CONF_URT2_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_IDL_MASK)  | \
                                                   ((CONF_URT2_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT2_MSPI_MASK) | \
                                                   ((CONF_URT2_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_SSPI_MASK) | \
                                                   ((0                         << URT_RLR_PSR_shift_w) & CONF_URT2_SC_MASK)   | \
                                                   ((CONF_URT2_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT2_LIN_MASK)  | \
                                                   (((CONF_URT2_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT2_TM_MASK))
            #else
                #define CONF_URT2_PSR             (((CONF_URT2_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT2_UART_MASK) | \
                                                   ((CONF_URT2_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT2_IRDA_MASK) | \
                                                   ((CONF_URT2_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_ADR_MASK)  | \
                                                   ((CONF_URT2_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_IDL_MASK)  | \
                                                   ((CONF_URT2_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT2_MSPI_MASK) | \
                                                   ((CONF_URT2_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT2_SSPI_MASK) | \
                                                   (((CONF_URT2_Freq/5000000)  << URT_RLR_PSR_shift_w) & CONF_URT2_SC_MASK)   | \
                                                   ((CONF_URT2_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT2_LIN_MASK)  | \
                                                   (((CONF_URT2_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT2_TM_MASK))
            #endif
            // (RLR) Baud-rate clock counter reload register.
            #if CONF_URT2_Freq < 5000000
                #define CONF_URT2_RLR             (((CONF_URT2_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT2_UART_MASK) | \
                                                   ((CONF_URT2_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT2_IRDA_MASK) | \
                                                   ((CONF_URT2_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_ADR_MASK)  | \
                                                   ((CONF_URT2_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_IDL_MASK)  | \
                                                   ((CONF_URT2_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT2_MSPI_MASK) | \
                                                   ((CONF_URT2_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT2_SC_MASK)   | \
                                                   ((CONF_URT2_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT2_LIN_MASK)  | \
                                                   (((CONF_URT2_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT2_TM_MASK))
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT2_RLR             (((CONF_URT2_UART_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT2_UART_MASK) | \
                                                   ((CONF_URT2_IRDA_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT2_IRDA_MASK) | \
                                                   ((CONF_URT2_MULTIADR_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT2_ADR_MASK)  | \
                                                   ((CONF_URT2_MULTIIDL_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT2_IDL_MASK)  | \
                                                   ((CONF_URT2_SPIMASTER_BR_BR                                 << URT_RLR_RLR_shift_w) & CONF_URT2_MSPI_MASK) | \
                                                   ((CONF_URT2_SPISLAVE_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT2_SSPI_MASK) | \
                                                   (((11*((CONF_URT2_Freq/5000000)+1)+(CONF_URT2_Freq/5000000))<< URT_RLR_RLR_shift_w) & CONF_URT2_SC_MASK)   | \
                                                   ((CONF_URT2_LIN_BR_BR                                       << URT_RLR_RLR_shift_w) & CONF_URT2_LIN_MASK)  | \
                                                   (((CONF_URT2_TM_BRTRLR-1)                                   &  URT_RLR_RLR_mask_w)  & CONF_URT2_TM_MASK))
            #else
                #define CONF_URT2_RLR             (((CONF_URT2_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT2_UART_MASK) | \
                                                   ((CONF_URT2_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT2_IRDA_MASK) | \
                                                   ((CONF_URT2_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_ADR_MASK)  | \
                                                   ((CONF_URT2_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_IDL_MASK)  | \
                                                   ((CONF_URT2_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT2_MSPI_MASK) | \
                                                   ((CONF_URT2_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT2_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT2_SC_MASK)   | \
                                                   ((CONF_URT2_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT2_LIN_MASK)  | \
                                                   (((CONF_URT2_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT2_TM_MASK))
            #endif
        #endif
        /*TMOUT  (Timeout control register)*/
        #if 1
            // (TMO_CKS) Timeout timer clock source select.
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_TMO_CKS     (URT_TMOUT_TMO_CKS_input_w)
            #else
                #define CONF_URT2_TMO_CKS     (URT_TMOUT_TMO_CKS_uart_w)
            #endif
            // (IDTMO_EN) Idle timeout detection enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_IDTMO_EN    (URT_TMOUT_IDTMO_EN_enable_w)
            #else
                #define CONF_URT2_IDTMO_EN    (URT_TMOUT_IDTMO_EN_disable_w)
            #endif 
            // (TMO_MDS) Timeout timer mode select.
            #if CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_TMO_MDS     (URT_TMOUT_TMO_MDS_general_w)
            #else
                #define CONF_URT2_TMO_MDS     (URT_TMOUT_TMO_MDS_uart_w)
            #endif
            // (TMO_RST) Timeout timer force reset enable.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC || CONF_URT2_MODE == CONF_URT_MODE_TM 
                #define CONF_URT2_RST         (URT_TMOUT_TMO_RST_enable_w)
            #else
                #define CONF_URT2_RST         0
            #endif
            // (TMO_EN) Timeout timer enable
            #if CONF_URT2_MODE == CONF_URT_MODE_MULTI_IDL || CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)
            #elif CONF_URT2_MODE == CONF_URT_MODE_TM && CONF_URT2_TM_TMO == 1
                #define CONF_URT2_TMO_EN      (URT_TMOUT_TMO_EN_mask_w) 
            #else
                #define CONF_URT2_TMO_EN      0
            #endif
        #endif
        /*TMOUT2 (Timeout control register 2)*/
        #if 1
            // (IDTMO_TH) Receive idle timeout detect threshold value by using receive bit time.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_IDTMO_TH        CONF_URT2_SC_WT
            #elif CONF_URT2_MODE == CONF_URT_MODE_TM
                #define CONF_URT2_IDTMO_TH        (CONF_URT2_TM_TMORLR-1)
            #else
                #define CONF_URT2_IDTMO_TH        0
            #endif
        #endif
        /*SC     (SmartCard control register)*/
        #if 1
            // (RXE_NUM) RX parity error detect and NACK transmission retry maximum number.
            #define CONF_URT2_RXE_NUM         ((CONF_URT2_SC_RXERRORTIME << 12) & CONF_URT2_SC_MASK)
            // (TXE_NUM) TX error detect and data resend maximum number
            #define CONF_URT2_TXE_NUM         ((CONF_URT2_SC_TXERRORTIME << 8)  & CONF_URT2_SC_MASK)
            // (RXE_LEN) RX parity error detect and NACK transmission bit time length select.
            #define CONF_URT2_RXE_LEN         ((CONF_URT2_SC_RXERRORSIG  << 4)  & CONF_URT2_SC_MASK)
            // (TXE_MDS) TX error detect mode select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_TXE_MDS     (URT_SC_TXE_MDS_chk_low_w)
            #elif CONF_URT2_MODE == CONF_URT_MODE_LIN
                #define CONF_URT2_TXE_MDS     (URT_SC_TXE_MDS_chk_tx_w)
            #else
                #define CONF_URT2_TXE_MDS     (URT_SC_TXE_MDS_disable_w)
            #endif
            // (RXE_MDS) RX parity error detect control mode select.
            #if CONF_URT2_MODE == CONF_URT_MODE_SC
                #define CONF_URT2_RXE_MDS     (URT_SC_RXE_MDS_enable_w) 
            #else
                #define CONF_URT2_RXE_MDS     (URT_SC_RXE_MDS_disable_w)
            #endif
        #endif
        /*SADR   (URT2 slave address detect register)*/
        #if 1
            // (SA_MSK) Multi-processor slave address mask register.
            #define CONF_URT2_SA_MSK          (((CONF_URT2_MULTIADR_ADRMASK << 8) & CONF_URT2_ADR_MASK) | \
                                               ((CONF_URT2_MULTIIDL_ADRMASK << 8) & CONF_URT2_IDL_MASK))
            // (SA_RX) Multi-processor mode received slave address.
            #define CONF_URT2_SA_RX           ((CONF_URT2_MULTIADR_ADR & CONF_URT2_ADR_MASK) | \
                                               (CONF_URT2_MULTIIDL_ADR & CONF_URT2_IDL_MASK))
        #endif
        /*CAL    (Calibration control register)*/
        #if 1
            // (CAL_MDS) Auto baud-rate calibration mode select.
            // (CAL_AUTO) Break detection and auto baud-rate calibration enable.
            #define CONF_URT2_CAL             ((CONF_URT2_LIN_CAL) & CONF_URT2_LIN_MASK)
        #endif
        /*IRDA   (IrDA control register)*/
        #if 1
            // (IR_MDS) IrDA data received mode select.
            // (IR_EN) IrDA data format enable.
            #define CONF_URT2_IR              ((0x00000002 | URT_IRDA_IR_EN_enable_w) & CONF_URT2_IRDA_MASK)
        #endif
        /*HFC    (Hardware flow control register)*/
        #if 1
            // (RTS_INV) RTS output inverse enable.
            // (CTS_INV) CTS input inverse enable.
            // (RTS_EN)  RTS hardware flow control enable.
            // (CTS_EN)  CTS hardware flow control enable.
            #define CONF_URT2_HFC             (((CONF_URT2_HWFLOW_RTS << 1) | CONF_URT2_HWFLOW_CTS) & CONF_URT2_UART_MASK)        
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT2_CALC            ((((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT2_UART_BR_CALC     )& CONF_URT2_UART_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IRDA_OS_MIN << 16)) * CONF_URT2_IRDA_BR_CALC     )& CONF_URT2_IRDA_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_ADR_OS_MIN  << 16)) * CONF_URT2_MULTIADR_BR_CALC )& CONF_URT2_ADR_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IDL_OS_MIN  << 16)) * CONF_URT2_MULTIIDL_BR_CALC )& CONF_URT2_IDL_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_MSPI_OS_MIN << 16)) * CONF_URT2_SPIMASTER_BR_CALC)& CONF_URT2_MSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_SSPI_OS_MIN << 16)) * CONF_URT2_SPISLAVE_BR_CALC )& CONF_URT2_SSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_LIN_OS_MIN  << 16)) * CONF_URT2_LIN_BR_CALC      )& CONF_URT2_LIN_MASK))
                                               
            #define CONF_URT2_BaudRate_Config ((CONF_URT2_UART_BR_CALC     & CONF_URT2_UART_MASK) | \
                                               (CONF_URT2_IRDA_BR_CALC     & CONF_URT2_IRDA_MASK) | \
                                               (CONF_URT2_MULTIADR_BR_CALC & CONF_URT2_ADR_MASK)  | \
                                               (CONF_URT2_MULTIIDL_BR_CALC & CONF_URT2_IDL_MASK)  | \
                                               (CONF_URT2_SPIMASTER_BR_CALC& CONF_URT2_MSPI_MASK) | \
                                               (CONF_URT2_SPISLAVE_BR_CALC & CONF_URT2_SSPI_MASK) | \
                                               (CONF_URT2_LIN_BR_CALC      & CONF_URT2_LIN_MASK))                                          
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT2_BD              ((CONF_URT2_UART_BR      & CONF_URT2_UART_MASK) | \
                                               (CONF_URT2_IRDA_BR      & CONF_URT2_IRDA_MASK) | \
                                               (CONF_URT2_MULTIADR_BR  & CONF_URT2_ADR_MASK)  | \
                                               (CONF_URT2_MULTIIDL_BR  & CONF_URT2_IDL_MASK)  | \
                                               (CONF_URT2_SPIMASTER_BR & CONF_URT2_MSPI_MASK) | \
                                               (CONF_URT2_SPISLAVE_BR  & CONF_URT2_SSPI_MASK) | \
                                               (CONF_URT2_LIN_BR       & CONF_URT2_LIN_MASK))
        #endif
    #endif
#else
    #define CONF_URT2_INIT_EN          0
    #define CONF_URT2_BaudRate_Config  0
    #define CONF_URT2_MODE             CONF_URT_MODE_NA
#endif

#if CONF_URT2_INIT_EN == 1
static const uint32_t CONF_URT2[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT2_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT2_BR_CKS)  | \
     (CONF_URT2_BR_MDS)  | \
     (CONF_URT2_BR_EN)   | \
     (CONF_URT2_TX_CKS)  | \
     (CONF_URT2_RX_CKS)  | \
     (CONF_URT2_CLK_CKS) | \
     (CONF_URT2_CLK_EN)  | \
     (CONF_URT2_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT2_DE)        | \
     (CONF_URT2_TX_INV)    | \
     (CONF_URT2_RX_INV)    | \
     (CONF_URT2_SYNC_MDS)  | \
     (CONF_URT2_IO_SWP)    | \
     (CONF_URT2_GSA_EN)    | \
     (CONF_URT2_MDS)       | \
     (CONF_URT2_DATA_LINE) | \
     (CONF_URT2_HDX_EN)    | \
     (CONF_URT2_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT2_OS_NUM << 16 ) | (CONF_URT2_OS_NUM)) | \
     ((CONF_URT2_STP_LEN<< 16 ) | (CONF_URT2_STP_LEN))| \
     ((CONF_URT2_MSB_EN << 16 ) | (CONF_URT2_MSB_EN)) | \
     ((CONF_URT2_PAR    << 16 ) | (CONF_URT2_PAR))    | \
     ((CONF_URT2_DSIZE  << 16 ) | (CONF_URT2_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT2_DOUT)     | \
     (CONF_URT2_NSSI_EN)  | \
     (CONF_URT2_TX_EN)    | \
     (CONF_URT2_RX_EN)),
    /*CR3    (Control Register 3)*/
    ((CONF_URT2_TXGT_LEN) | \
     (CONF_URT2_DET_IDL)  | \
     (CONF_URT2_DET_BK)   | \
     (CONF_URT2_CPHA)     | \
     (CONF_URT2_CPOL)),
    /*CR4    (Control Register 4)*/
    ((CONF_URT2_TDAT_CLR) | \
     (CONF_URT2_RDAT_CLR) | \
     (CONF_URT2_DAT_INV)), 
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT2_PSR) | \
     (CONF_URT2_RLR)),   
    /*TMOUT  (Timeout control register)*/
    ((CONF_URT2_TMO_CKS) | \
     (CONF_URT2_IDTMO_EN)| \
     (CONF_URT2_TMO_MDS) | \
     (CONF_URT2_RST)     | \
     (CONF_URT2_TMO_EN)),  
    /*TMOUT2 (Timeout control register 2)*/
    (CONF_URT2_IDTMO_TH),
    /*SC     (SmartCard control register)*/
    ((CONF_URT2_RXE_NUM) | \
     (CONF_URT2_TXE_NUM) | \
     (CONF_URT2_RXE_LEN) | \
     (CONF_URT2_TXE_MDS) | \
     (CONF_URT2_RXE_MDS)),
    /*SADR   (URT2 slave address detect register)*/
    ((CONF_URT2_SA_MSK) | \
     (CONF_URT2_SA_RX)),
    /*CAL    (Calibration control register)*/
    (CONF_URT2_CAL),
    /*IRDA   (IrDA control register)*/
    (CONF_URT2_IR),
    /*HFC    (Hardware flow control register)*/
    (CONF_URT2_HFC),
    /*Baud-rate calculation mode*/
    (CONF_URT2_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT2_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT2_BD)
};
#endif

/* URT3 Related Configure-----------------------------------------------*/
#if defined(URT3_Base) 
    /*Disable or Enable check*/
    #if CONF_URT3_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT3_INIT_EN          0
        #define CONF_URT3_BaudRate_Config  0
    #else
        #define CONF_URT3_INIT_EN          1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT3_MODE == CONF_URT_MODE_UART
                #define CONF_URT3_UART_MASK  0xFFFFFFFF
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_IRDA
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0xFFFFFFFF
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0xFFFFFFFF
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0  
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0xFFFFFFFF
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0xFFFFFFFF
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0xFFFFFFFF
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0xFFFFFFFF
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_LIN
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0xFFFFFFFF
                #define CONF_URT3_TM_MASK    0
            #elif CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT3_UART_MASK  0
                #define CONF_URT3_IRDA_MASK  0
                #define CONF_URT3_ADR_MASK   0
                #define CONF_URT3_IDL_MASK   0
                #define CONF_URT3_MSPI_MASK  0
                #define CONF_URT3_SSPI_MASK  0
                #define CONF_URT3_SC_MASK    0
                #define CONF_URT3_LIN_MASK   0
                #define CONF_URT3_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT3_INT    ((URT_INT_IEA_mask_w      * CONF_URT3_IEA)    | \
                                      (URT_INT_UG_IE_mask_w    * CONF_URT3_UGFIE)  | \
                                      (URT_INT_TC_IE_mask_w    * CONF_URT3_TCIE)   | \
                                      (URT_INT_ERR_IE_mask_w   * CONF_URT3_ERRIE)  | \
                                      (URT_INT_LS_IE_mask_w    * CONF_URT3_LSIE)   | \
                                      (URT_INT_RX_IE_mask_w    * CONF_URT3_RXIE)   | \
                                      (URT_INT_TX_IE_mask_w    * CONF_URT3_TXIE)   | \
                                      (URT_INT_SADR_IE_mask_w  * CONF_URT3_SADRIE) | \
                                      (URT_INT_BRT_IE_mask_w   * CONF_URT3_BRTIE)  | \
                                      (URT_INT_TMO_IE_mask_w   * CONF_URT3_TMOIE)  | \
                                      (URT_INT_CALC_IE_mask_w  * CONF_URT3_CALCIE) | \
                                      (URT_INT_BK_IE_mask_w    * CONF_URT3_BKIE)   | \
                                      (URT_INT_IDL_IE_mask_w   * CONF_URT3_IDLIE)  | \
                                      (URT_INT_CTS_IE_mask_w   * CONF_URT3_CTSIE)  | \
                                      (URT_INT_NSS_IE_mask_w   * CONF_URT3_NSSIE)  | \
                                      (URT_INT_PE_IE_mask_w    * CONF_URT3_PEIE)   | \
                                      (URT_INT_FE_IE_mask_w    * CONF_URT3_FEIE)   | \
                                      (URT_INT_NCE_IE_mask_w   * CONF_URT3_NCEIE)  | \
                                      (URT_INT_ROVR_IE_mask_w  * CONF_URT3_ROVRIE) | \
                                      (URT_INT_TXE_IE_mask_w   * CONF_URT3_TXEIE)  | \
                                      (URT_INT_TUDR_IE_mask_w  * CONF_URT3_TUDRIE) | \
                                      (URT_INT_RXTMO_IE_mask_w * CONF_URT3_RXTMOIE)| \
                                      (URT_INT_IDTMO_IE_mask_w * CONF_URT3_IDMO_IE)| \
                                      (URT_INT_BKTMO_IE_mask_w * CONF_URT3_BKTMOIE)| \
                                      (URT_INT_CALTMO_IE_mask_w* CONF_URT3_CALTMOIE)) 
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_CKS) Baud-rate timer clock source select.
            #if CONF_URT3_MODE != CONF_URT_MODE_SC
                #define CONF_URT3_BR_CKS  0
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT3_BR_CKS  URT_CLK_BR_CKS_ck_urtx_w
            #else
                #define CONF_URT3_BR_CKS  0
            #endif
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT3_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT3_UART_BR_MDS     ) & CONF_URT3_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_IRDA_BR_MDS     ) & CONF_URT3_IRDA_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_MULTIADR_BR_MDS ) & CONF_URT3_ADR_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_MULTIIDL_BR_MDS ) & CONF_URT3_IDL_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_SPIMASTER_BR_MDS) & CONF_URT3_MSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_SPISLAVE_BR_MDS ) & CONF_URT3_SSPI_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 0                         ) & CONF_URT3_SC_MASK)   |\
                                           ((URT_CLK_BR_MDS_mask_w * CONF_URT3_LIN_BR_MDS      ) & CONF_URT3_LIN_MASK)  |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT3_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #if CONF_URT3_TM_BRT == 1
                    #define CONF_URT3_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT3_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT3_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (TX_CKS) Transmission clock source select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT3_TX_CKS       URT_CLK_TX_CKS_ext_clk_w
            #else
                #define CONF_URT3_TX_CKS       URT_CLK_TX_CKS_internal_w
            #endif
            // (RX_CKS) Receive clock source select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT3_RX_CKS       URT_CLK_RX_CKS_ext_clk_w
            #else
                #define CONF_URT3_RX_CKS       URT_CLK_RX_CKS_internal_w
            #endif
            // (CLK_CKS) External clock output source select.
            #define CONF_URT3_CLK_CKS      URT_CLK_CLK_CKS_sc_w
            // (CLK_EN) URTx_CLK signal output enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER
                #define CONF_URT3_CLK_EN   URT_CLK_CLK_EN_enable_w
            #else
                #define CONF_URT3_CLK_EN   URT_CLK_CLK_EN_disable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT3_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT3_UART_BR_CKSEL      << 1)) & CONF_URT3_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_IRDA_BR_CKSEL      << 1)) & CONF_URT3_IRDA_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_MULTIADR_BR_CKSEL  << 1)) & CONF_URT3_ADR_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_MULTIIDL_BR_CKSEL  << 1)) & CONF_URT3_IDL_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_SPIMASTER_BR_CKSEL << 1)) & CONF_URT3_MSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_SPISLAVE_BR_CKSEL  << 1)) & CONF_URT3_SSPI_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT3_SC_MASK)   |\
                                            ((URT_CLK_CK_SEL_mask_w & (CONF_URT3_LIN_BR_CKSEL       << 1)) & CONF_URT3_LIN_MASK)  |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT3_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (DE_GT) URTx_DE signal output guard time select.
            // (DE_INV) URTx_DE signal inverse enable.
            // (DE_EN) URTx_DE signal output enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_UART
                #define CONF_URT3_DE         (CONF_URT3_HWFLOW_DE << 12)
            #else
                #define CONF_URT3_DE         (URT_CR0_DE_GT_1_4_w | URT_CR0_DE_INV_disable_w | URT_CR0_DE_EN_disable_w)
            #endif
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT3_TX_INV         (((CONF_URT3_UART_TX_INV    & CONF_URT3_UART_MASK)| \
                                               (CONF_URT3_IRDA_TX_INV    & CONF_URT3_IRDA_MASK)| \
                                               (CONF_URT3_MULTIADR_TX_INV& CONF_URT3_ADR_MASK) | \
                                               (CONF_URT3_MULTIIDL_TX_INV& CONF_URT3_IDL_MASK))<<11)
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT3_RX_INV         (((CONF_URT3_UART_RX_INV    & CONF_URT3_UART_MASK)| \
                                               (CONF_URT3_IRDA_RX_INV    & CONF_URT3_IRDA_MASK)| \
                                               (CONF_URT3_MULTIADR_RX_INV& CONF_URT3_ADR_MASK) | \
                                               (CONF_URT3_MULTIIDL_RX_INV& CONF_URT3_IDL_MASK))<<10)    
            // (SYNC_MDS) SYNC mode(SPI) select.
            #if defined(URT_CR0_SYNC_MDS_mask_w)
                #define CONF_URT3_SYNC_MDS   ((URT_CR0_SYNC_MDS_master_w & CONF_URT3_MSPI_MASK) |\
                                              (URT_CR0_SYNC_MDS_slave_w  & CONF_URT3_SSPI_MASK))
            #else
                #define CONF_URT3_SYNC_MDS 0
            #endif                           
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT3_IO_SWP         (((CONF_URT3_UART_PINSWAP     & CONF_URT3_UART_MASK)|\
                                               (CONF_URT3_IRDA_PINSWAP     & CONF_URT3_IRDA_MASK)|\
                                               (CONF_URT3_MULTIADR_PINSWAP & CONF_URT3_ADR_MASK) |\
                                               (CONF_URT3_MULTIIDL_PINSWAP & CONF_URT3_IDL_MASK) |\
                                               (CONF_URT3_SPIMASTER_PINSWAP& CONF_URT3_MSPI_MASK)|\
                                               (CONF_URT3_SPISLAVE_PINSWAP & CONF_URT3_SSPI_MASK))<<8)
            // (GSA_EN) Multi-processor global slave address enable.
            #define CONF_URT3_GSA_EN         (((CONF_URT3_MULTIADR_GLOBAL & CONF_URT3_ADR_MASK) |\
                                               (CONF_URT3_MULTIIDL_GLOBAL & CONF_URT3_IDL_MASK))<<7)   
            // (MDS) Mode select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
                #define CONF_URT3_MDS        URT_CR0_MDS_sync_w
            #elif CONF_URT3_MODE == CONF_URT_MODE_MULTI_IDL
                #define CONF_URT3_MDS        URT_CR0_MDS_idle_w
            #elif CONF_URT3_MODE == CONF_URT_MODE_MULTI_ADR
                #define CONF_URT3_MDS        URT_CR0_MDS_adr_w
            #else
                #define CONF_URT3_MDS        URT_CR0_MDS_uart_w
            #endif
            // (DAT_LINE) Communication data line select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_DATA_LINE  URT_CR0_DAT_LINE_1_w 
            #else
                #define CONF_URT3_DATA_LINE  URT_CR0_DAT_LINE_2_w
            #endif
            // (HDX_EN) Half-duplex mode enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC || CONF_URT3_MODE == CONF_URT_MODE_LIN
                #define CONF_URT3_HDX_EN     URT_CR0_HDX_EN_enable_w 
            #else
                #define CONF_URT3_HDX_EN     URT_CR0_HDX_EN_disable_w
            #endif
            // (EN) Function enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_EN             URT_CR0_EN_disable_w
            #else
                #define CONF_URT3_EN             URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT3_OS_NUM         (((CONF_URT3_UART_BR_OS     & CONF_URT3_UART_MASK) |\
                                               (CONF_URT3_IRDA_BR_OS     & CONF_URT3_IRDA_MASK) |\
                                               (CONF_URT3_MULTIADR_BR_OS & CONF_URT3_ADR_MASK)  |\
                                               (CONF_URT3_MULTIIDL_BR_OS & CONF_URT3_IDL_MASK)  |\
                                               (CONF_URT3_SPIMASTER_BR_OS& CONF_URT3_MSPI_MASK) |\
                                               (CONF_URT3_SPISLAVE_BR_OS & CONF_URT3_SSPI_MASK) |\
                                               (30                       & CONF_URT3_SC_MASK)   |\
                                               (CONF_URT3_LIN_BR_OS      & CONF_URT3_LIN_MASK))<<URT_CR1_RXOS_NUM_shift_w)       
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC || CONF_URT3_MODE == CONF_URT_MODE_LIN
                #define CONF_URT3_STP_LEN    (URT_CR1_RXSTP_LEN_1bit_w)
            #else
                #define CONF_URT3_STP_LEN    (((CONF_URT3_UART_STOP       & CONF_URT3_UART_MASK)  |\
                                               (CONF_URT3_IRDA_STOP       & CONF_URT3_IRDA_MASK)  |\
                                               (CONF_URT3_MULTIADR_STOP   & CONF_URT3_ADR_MASK)   |\
                                               (CONF_URT3_MULTIIDL_STOP   & CONF_URT3_IDL_MASK))<<6)
            #endif
            // (TXMSB_EN) TX data order MSB first enable.
            // (RXMSB_EN) RX data order MSB first enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC || CONF_URT3_MODE == CONF_URT_MODE_LIN
                #define CONF_URT3_MSB_EN     (CONF_URT3_SC_CONVENTION & URT_CR1_RXMSB_EN_mask_w)
            #else
                #define CONF_URT3_MSB_EN     (((CONF_URT3_UART_DATAORDER     & CONF_URT3_UART_MASK)  |\
                                               (CONF_URT3_IRDA_DATAORDER     & CONF_URT3_IRDA_MASK)  |\
                                               (CONF_URT3_MULTIADR_DATAORDER & CONF_URT3_ADR_MASK)   |\
                                               (CONF_URT3_MULTIIDL_DATAORDER & CONF_URT3_IDL_MASK)   |\
                                               (CONF_URT3_SPIMASTER_DATAORDER& CONF_URT3_MSPI_MASK)  |\
                                               (CONF_URT3_SPISLAVE_DATAORDER & CONF_URT3_SSPI_MASK))<<5)
                                               
            #endif     
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_PAR         (URT_CR1_RXPAR_STK_disable_w | URT_CR1_RXPAR_EN_mask_w | (CONF_URT3_SC_CONVENTION & URT_CR1_RXPAR_POL_mask_w))
            #else
                #define CONF_URT3_PAR         (((CONF_URT3_UART_PARITY     & CONF_URT3_UART_MASK) |\
                                                (CONF_URT3_IRDA_PARITY     & CONF_URT3_IRDA_MASK)|\
                                                (CONF_URT3_MULTIADR_PARITY & CONF_URT3_ADR_MASK) |\
                                                (CONF_URT3_MULTIIDL_PARITY & CONF_URT3_IDL_MASK) |\
                                                (0                         & CONF_URT3_LIN_MASK))<<2)
            #endif
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT3_DSIZE           ((CONF_URT3_UART_DATABIT     & CONF_URT3_UART_MASK) | \
                                               (CONF_URT3_IRDA_DATABIT     & CONF_URT3_IRDA_MASK) | \
                                               (CONF_URT3_MULTIADR_DATABIT & CONF_URT3_ADR_MASK)  | \
                                               (CONF_URT3_MULTIIDL_DATABIT & CONF_URT3_IDL_MASK))                                 
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (DOUT_IDL) SPI master mode idle state data output value.
            // (DOUT_MDS) SPI master standard mode idle state data output mode select.
            #if defined(URT_CR2_DOUT_MDS_mask_w)
                #define CONF_URT3_DOUT        ((CONF_URT3_SPIMASTER_DOUT << 29) & CONF_URT3_MSPI_MASK)
            #else
                #define CONF_URT3_DOUT        0
            #endif
            // (NSSI_EN) NSS signal input function enable when UART configure to synchronous mode SPI slave.
            #if defined(URT_CR2_NSSI_EN_mask_w)
                #define CONF_URT3_NSSI_EN     (URT_CR2_NSSI_EN_enable_w & CONF_URT3_SSPI_MASK)
            #else
                #define CONF_URT3_NSSI_EN     0
            #endif
            // (TX_EN) Transmitter enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT3_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT3_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*CR3    (Control Register 3)*/
        #if 1
            // (TXGT_LEN) TX guard time.
            #define CONF_URT3_TXGT_LEN        ((CONF_URT3_SC_GT<<16) & CONF_URT3_SC_MASK)
            // (DET_IDL) Idle line detect threshold value.
            #define CONF_URT3_DET_IDL         (((CONF_URT3_MULTIIDL_IDL-1) << 8) & CONF_URT3_IDL_MASK)
            // (DET_BK) Bit time select for break detection or transmission.
            #define CONF_URT3_DET_BK          ((CONF_URT3_LIN_BK << 4) & CONF_URT3_LIN_MASK)
            // (CPHA) Clock phase select.
            #define CONF_URT3_CPHA            (((CONF_URT3_SPIMASTER_CPHA & CONF_URT3_MSPI_MASK)| \
                                                (CONF_URT3_SPISLAVE_CPHA  & CONF_URT3_SSPI_MASK))<<2)
            // (CPOL) Clock polarity select.
            #define CONF_URT3_CPOL            (((CONF_URT3_SPIMASTER_CPOL & CONF_URT3_MSPI_MASK)| \
                                                (CONF_URT3_SPISLAVE_CPOL  & CONF_URT3_SSPI_MASK))<<1)
        #endif
        /*CR4    (Control Register 4)*/
        #if 1
            // (TDAT_CLR) Transmitted data clear enable.
            #define CONF_URT3_TDAT_CLR        URT_CR4_TDAT_CLR_enable_w
            // (RDAT_CLR) Receive data clear enable.
            #define CONF_URT3_RDAT_CLR        URT_CR4_RDAT_CLR_enable_w
            // (TDAT_INV) Inverse transmitted data enable.
            // (RDAT_INV) Inverse received data enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_DAT_INV         ((CONF_URT3_SC_CONVENTION >> 16) & (URT_CR4_TDAT_INV_mask_w | URT_CR4_RDAT_INV_mask_w))
            #else
                #define CONF_URT3_DAT_INV         ((((CONF_URT3_UART_DATAINV     << 5) | (CONF_URT3_UART_DATAINV     << 4)) & CONF_URT3_UART_MASK)| \
                                                   (((CONF_URT3_IRDA_DATAINV     << 5) | (CONF_URT3_IRDA_DATAINV     << 4)) & CONF_URT3_IRDA_MASK)| \
                                                   (((CONF_URT3_MULTIADR_DATAINV << 5) | (CONF_URT3_MULTIADR_DATAINV << 4)) & CONF_URT3_ADR_MASK) | \
                                                   (((CONF_URT3_MULTIIDL_DATAINV << 5) | (CONF_URT3_MULTIIDL_DATAINV << 4)) & CONF_URT3_IDL_MASK) | \
                                                   (((CONF_URT3_SPIMASTER_DATAINV<< 5) | (CONF_URT3_SPIMASTER_DATAINV<< 4)) & CONF_URT3_MSPI_MASK)| \
                                                   (((CONF_URT3_SPISLAVE_DATAINV << 5) | (CONF_URT3_SPISLAVE_DATAINV << 4)) & CONF_URT3_SSPI_MASK))
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #if CONF_URT3_Freq < 5000000
                #define CONF_URT3_PSR             (((CONF_URT3_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT3_UART_MASK) | \
                                                   ((CONF_URT3_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT3_IRDA_MASK) | \
                                                   ((CONF_URT3_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_ADR_MASK)  | \
                                                   ((CONF_URT3_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_IDL_MASK)  | \
                                                   ((CONF_URT3_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT3_MSPI_MASK) | \
                                                   ((CONF_URT3_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_SSPI_MASK) | \
                                                   ((0                         << URT_RLR_PSR_shift_w) & CONF_URT3_SC_MASK)   | \
                                                   ((CONF_URT3_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT3_LIN_MASK)  | \
                                                   (((CONF_URT3_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT3_TM_MASK))
            #else
                #define CONF_URT3_PSR             (((CONF_URT3_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT3_UART_MASK) | \
                                                   ((CONF_URT3_IRDA_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT3_IRDA_MASK) | \
                                                   ((CONF_URT3_MULTIADR_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_ADR_MASK)  | \
                                                   ((CONF_URT3_MULTIIDL_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_IDL_MASK)  | \
                                                   ((CONF_URT3_SPIMASTER_BR_PRE<< URT_RLR_PSR_shift_w) & CONF_URT3_MSPI_MASK) | \
                                                   ((CONF_URT3_SPISLAVE_BR_PRE << URT_RLR_PSR_shift_w) & CONF_URT3_SSPI_MASK) | \
                                                   (((CONF_URT3_Freq/5000000)  << URT_RLR_PSR_shift_w) & CONF_URT3_SC_MASK)   | \
                                                   ((CONF_URT3_LIN_BR_PRE      << URT_RLR_PSR_shift_w) & CONF_URT3_LIN_MASK)  | \
                                                   (((CONF_URT3_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT3_TM_MASK))
            #endif
            // (RLR) Baud-rate clock counter reload register.
            #if CONF_URT3_Freq < 5000000
                #define CONF_URT3_RLR             (((CONF_URT3_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT3_UART_MASK) | \
                                                   ((CONF_URT3_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT3_IRDA_MASK) | \
                                                   ((CONF_URT3_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_ADR_MASK)  | \
                                                   ((CONF_URT3_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_IDL_MASK)  | \
                                                   ((CONF_URT3_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT3_MSPI_MASK) | \
                                                   ((CONF_URT3_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT3_SC_MASK)   | \
                                                   ((CONF_URT3_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT3_LIN_MASK)  | \
                                                   (((CONF_URT3_TM_BRTRLR-1)    & URT_RLR_RLR_mask_w)  & CONF_URT3_TM_MASK))
            #elif defined(URT_CLK_BR_CKS_mask_w)
                #define CONF_URT3_RLR             (((CONF_URT3_UART_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT3_UART_MASK) | \
                                                   ((CONF_URT3_IRDA_BR_BR                                      << URT_RLR_RLR_shift_w) & CONF_URT3_IRDA_MASK) | \
                                                   ((CONF_URT3_MULTIADR_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT3_ADR_MASK)  | \
                                                   ((CONF_URT3_MULTIIDL_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT3_IDL_MASK)  | \
                                                   ((CONF_URT3_SPIMASTER_BR_BR                                 << URT_RLR_RLR_shift_w) & CONF_URT3_MSPI_MASK) | \
                                                   ((CONF_URT3_SPISLAVE_BR_BR                                  << URT_RLR_RLR_shift_w) & CONF_URT3_SSPI_MASK) | \
                                                   (((11*((CONF_URT3_Freq/5000000)+1)+(CONF_URT3_Freq/5000000))<< URT_RLR_RLR_shift_w) & CONF_URT3_SC_MASK)   | \
                                                   ((CONF_URT3_LIN_BR_BR                                       << URT_RLR_RLR_shift_w) & CONF_URT3_LIN_MASK)  | \
                                                   (((CONF_URT3_TM_BRTRLR-1)                                    & URT_RLR_RLR_mask_w)  & CONF_URT3_TM_MASK))
            #else
                #define CONF_URT3_RLR             (((CONF_URT3_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT3_UART_MASK) | \
                                                   ((CONF_URT3_IRDA_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT3_IRDA_MASK) | \
                                                   ((CONF_URT3_MULTIADR_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_ADR_MASK)  | \
                                                   ((CONF_URT3_MULTIIDL_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_IDL_MASK)  | \
                                                   ((CONF_URT3_SPIMASTER_BR_BR << URT_RLR_RLR_shift_w) & CONF_URT3_MSPI_MASK) | \
                                                   ((CONF_URT3_SPISLAVE_BR_BR  << URT_RLR_RLR_shift_w) & CONF_URT3_SSPI_MASK) | \
                                                   ((11                        << URT_RLR_RLR_shift_w) & CONF_URT3_SC_MASK)   | \
                                                   ((CONF_URT3_LIN_BR_BR       << URT_RLR_RLR_shift_w) & CONF_URT3_LIN_MASK)  | \
                                                   (((CONF_URT3_TM_BRTRLR-1)    & URT_RLR_RLR_mask_w)  & CONF_URT3_TM_MASK))
            #endif
        #endif
        /*TMOUT  (Timeout control register)*/
        #if 1
            // (TMO_CKS) Timeout timer clock source select.
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_TMO_CKS     (URT_TMOUT_TMO_CKS_input_w)
            #else
                #define CONF_URT3_TMO_CKS     (URT_TMOUT_TMO_CKS_uart_w)
            #endif
            // (IDTMO_EN) Idle timeout detection enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_IDTMO_EN    (URT_TMOUT_IDTMO_EN_enable_w)
            #else
                #define CONF_URT3_IDTMO_EN    (URT_TMOUT_IDTMO_EN_disable_w)
            #endif 
            // (TMO_MDS) Timeout timer mode select.
            #if CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_TMO_MDS     (URT_TMOUT_TMO_MDS_general_w)
            #else
                #define CONF_URT3_TMO_MDS     (URT_TMOUT_TMO_MDS_uart_w)
            #endif
            // (TMO_RST) Timeout timer force reset enable.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC || CONF_URT3_MODE == CONF_URT_MODE_TM 
                #define CONF_URT3_RST         (URT_TMOUT_TMO_RST_enable_w)
            #else
                #define CONF_URT3_RST         0
            #endif
            // (TMO_EN) Timeout timer enable
            #if CONF_URT3_MODE == CONF_URT_MODE_MULTI_IDL || CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_TMO_EN      (URT_TMOUT_TMO_EN_mask_w)
            #elif CONF_URT3_MODE == CONF_URT_MODE_TM && CONF_URT3_TM_TMO == 1
                #define CONF_URT3_TMO_EN      (URT_TMOUT_TMO_EN_mask_w) 
            #else
                #define CONF_URT3_TMO_EN      0
            #endif
        #endif
        /*TMOUT2 (Timeout control register 2)*/
        #if 1
            // (IDTMO_TH) Receive idle timeout detect threshold value by using receive bit time.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_IDTMO_TH        CONF_URT3_SC_WT
            #elif CONF_URT3_MODE == CONF_URT_MODE_TM
                #define CONF_URT3_IDTMO_TH        (CONF_URT3_TM_TMORLR-1)
            #else
                #define CONF_URT3_IDTMO_TH        0
            #endif
        #endif
        /*SC     (SmartCard control register)*/
        #if 1
            // (RXE_NUM) RX parity error detect and NACK transmission retry maximum number.
            #define CONF_URT3_RXE_NUM         ((CONF_URT3_SC_RXERRORTIME << 12) & CONF_URT3_SC_MASK)
            // (TXE_NUM) TX error detect and data resend maximum number
            #define CONF_URT3_TXE_NUM         ((CONF_URT3_SC_TXERRORTIME << 8)  & CONF_URT3_SC_MASK)
            // (RXE_LEN) RX parity error detect and NACK transmission bit time length select.
            #define CONF_URT3_RXE_LEN         ((CONF_URT3_SC_RXERRORSIG  << 4)  & CONF_URT3_SC_MASK)
            // (TXE_MDS) TX error detect mode select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_TXE_MDS     (URT_SC_TXE_MDS_chk_low_w)
            #elif CONF_URT3_MODE == CONF_URT_MODE_LIN
                #define CONF_URT3_TXE_MDS     (URT_SC_TXE_MDS_chk_tx_w)
            #else
                #define CONF_URT3_TXE_MDS     (URT_SC_TXE_MDS_disable_w)
            #endif
            // (RXE_MDS) RX parity error detect control mode select.
            #if CONF_URT3_MODE == CONF_URT_MODE_SC
                #define CONF_URT3_RXE_MDS     (URT_SC_RXE_MDS_enable_w) 
            #else
                #define CONF_URT3_RXE_MDS     (URT_SC_RXE_MDS_disable_w)
            #endif
        #endif
        /*SADR   (URT3 slave address detect register)*/
        #if 1
            // (SA_MSK) Multi-processor slave address mask register.
            #define CONF_URT3_SA_MSK          (((CONF_URT3_MULTIADR_ADRMASK << 8) & CONF_URT3_ADR_MASK) | \
                                               ((CONF_URT3_MULTIIDL_ADRMASK << 8) & CONF_URT3_IDL_MASK))
            // (SA_RX) Multi-processor mode received slave address.
            #define CONF_URT3_SA_RX           ((CONF_URT3_MULTIADR_ADR & CONF_URT3_ADR_MASK) | \
                                               (CONF_URT3_MULTIIDL_ADR & CONF_URT3_IDL_MASK))
        #endif
        /*CAL    (Calibration control register)*/
        #if 1
            // (CAL_MDS) Auto baud-rate calibration mode select.
            // (CAL_AUTO) Break detection and auto baud-rate calibration enable.
            #define CONF_URT3_CAL             ((CONF_URT3_LIN_CAL) & CONF_URT3_LIN_MASK)
        #endif
        /*IRDA   (IrDA control register)*/
        #if 1
            // (IR_MDS) IrDA data received mode select.
            // (IR_EN) IrDA data format enable.
            #define CONF_URT3_IR              ((0x00000002 | URT_IRDA_IR_EN_enable_w) & CONF_URT3_IRDA_MASK)
        #endif
        /*HFC    (Hardware flow control register)*/
        #if 1
            // (RTS_INV) RTS output inverse enable.
            // (CTS_INV) CTS input inverse enable.
            // (RTS_EN)  RTS hardware flow control enable.
            // (CTS_EN)  CTS hardware flow control enable.
            #define CONF_URT3_HFC             (((CONF_URT3_HWFLOW_RTS << 1) | CONF_URT3_HWFLOW_CTS) & CONF_URT3_UART_MASK)        
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT3_CALC            ((((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT3_UART_BR_CALC     )& CONF_URT3_UART_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IRDA_OS_MIN << 16)) * CONF_URT3_IRDA_BR_CALC     )& CONF_URT3_IRDA_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_ADR_OS_MIN  << 16)) * CONF_URT3_MULTIADR_BR_CALC )& CONF_URT3_ADR_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_IDL_OS_MIN  << 16)) * CONF_URT3_MULTIIDL_BR_CALC )& CONF_URT3_IDL_MASK)  | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_MSPI_OS_MIN << 16)) * CONF_URT3_SPIMASTER_BR_CALC)& CONF_URT3_MSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_SSPI_OS_MIN << 16)) * CONF_URT3_SPISLAVE_BR_CALC )& CONF_URT3_SSPI_MASK) | \
                                               (((CONF_URT_BR_CALC_MASK | ( CONF_URT_LIN_OS_MIN  << 16)) * CONF_URT3_LIN_BR_CALC      )& CONF_URT3_LIN_MASK))
                                               
            #define CONF_URT3_BaudRate_Config ((CONF_URT3_UART_BR_CALC     & CONF_URT3_UART_MASK) | \
                                               (CONF_URT3_IRDA_BR_CALC     & CONF_URT3_IRDA_MASK) | \
                                               (CONF_URT3_MULTIADR_BR_CALC & CONF_URT3_ADR_MASK)  | \
                                               (CONF_URT3_MULTIIDL_BR_CALC & CONF_URT3_IDL_MASK)  | \
                                               (CONF_URT3_SPIMASTER_BR_CALC& CONF_URT3_MSPI_MASK) | \
                                               (CONF_URT3_SPISLAVE_BR_CALC & CONF_URT3_SSPI_MASK) | \
                                               (CONF_URT3_LIN_BR_CALC      & CONF_URT3_LIN_MASK))                                          
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT3_BD              ((CONF_URT3_UART_BR      & CONF_URT3_UART_MASK) | \
                                               (CONF_URT3_IRDA_BR      & CONF_URT3_IRDA_MASK) | \
                                               (CONF_URT3_MULTIADR_BR  & CONF_URT3_ADR_MASK)  | \
                                               (CONF_URT3_MULTIIDL_BR  & CONF_URT3_IDL_MASK)  | \
                                               (CONF_URT3_SPIMASTER_BR & CONF_URT3_MSPI_MASK) | \
                                               (CONF_URT3_SPISLAVE_BR  & CONF_URT3_SSPI_MASK) | \
                                               (CONF_URT3_LIN_BR       & CONF_URT3_LIN_MASK))
        #endif
    #endif
#else
    #define CONF_URT3_INIT_EN          0
    #define CONF_URT3_BaudRate_Config  0
    #define CONF_URT3_MODE             CONF_URT_MODE_NA
#endif

#if CONF_URT3_INIT_EN == 1
static const uint32_t CONF_URT3[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT3_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT3_BR_CKS)  | \
     (CONF_URT3_BR_MDS)  | \
     (CONF_URT3_BR_EN)   | \
     (CONF_URT3_TX_CKS)  | \
     (CONF_URT3_RX_CKS)  | \
     (CONF_URT3_CLK_CKS) | \
     (CONF_URT3_CLK_EN)  | \
     (CONF_URT3_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT3_DE)        | \
     (CONF_URT3_TX_INV)    | \
     (CONF_URT3_RX_INV)    | \
     (CONF_URT3_SYNC_MDS)  | \
     (CONF_URT3_IO_SWP)    | \
     (CONF_URT3_GSA_EN)    | \
     (CONF_URT3_MDS)       | \
     (CONF_URT3_DATA_LINE) | \
     (CONF_URT3_HDX_EN)    | \
     (CONF_URT3_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT3_OS_NUM << 16 ) | (CONF_URT3_OS_NUM)) | \
     ((CONF_URT3_STP_LEN<< 16 ) | (CONF_URT3_STP_LEN))| \
     ((CONF_URT3_MSB_EN << 16 ) | (CONF_URT3_MSB_EN)) | \
     ((CONF_URT3_PAR    << 16 ) | (CONF_URT3_PAR))    | \
     ((CONF_URT3_DSIZE  << 16 ) | (CONF_URT3_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT3_DOUT)     | \
     (CONF_URT3_NSSI_EN)  | \
     (CONF_URT3_TX_EN)    | \
     (CONF_URT3_RX_EN)),
    /*CR3    (Control Register 3)*/
    ((CONF_URT3_TXGT_LEN) | \
     (CONF_URT3_DET_IDL)  | \
     (CONF_URT3_DET_BK)   | \
     (CONF_URT3_CPHA)     | \
     (CONF_URT3_CPOL)),
    /*CR4    (Control Register 4)*/
    ((CONF_URT3_TDAT_CLR) | \
     (CONF_URT3_RDAT_CLR) | \
     (CONF_URT3_DAT_INV)), 
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT3_PSR) | \
     (CONF_URT3_RLR)),   
    /*TMOUT  (Timeout control register)*/
    ((CONF_URT3_TMO_CKS) | \
     (CONF_URT3_IDTMO_EN)| \
     (CONF_URT3_TMO_MDS) | \
     (CONF_URT3_RST)     | \
     (CONF_URT3_TMO_EN)),  
    /*TMOUT2 (Timeout control register 2)*/
    (CONF_URT3_IDTMO_TH),
    /*SC     (SmartCard control register)*/
    ((CONF_URT3_RXE_NUM) | \
     (CONF_URT3_TXE_NUM) | \
     (CONF_URT3_RXE_LEN) | \
     (CONF_URT3_TXE_MDS) | \
     (CONF_URT3_RXE_MDS)),
    /*SADR   (URT3 slave address detect register)*/
    ((CONF_URT3_SA_MSK) | \
     (CONF_URT3_SA_RX)),
    /*CAL    (Calibration control register)*/
    (CONF_URT3_CAL),
    /*IRDA   (IrDA control register)*/
    (CONF_URT3_IR),
    /*HFC    (Hardware flow control register)*/
    (CONF_URT3_HFC),
    /*Baud-rate calculation mode*/
    (CONF_URT3_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT3_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT3_BD)
};
#endif
/* URT4 Related Configure-----------------------------------------------*/
#if defined(URT4_Base) 
    /*Disable or Enable check*/
    #if CONF_URT4_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT4_INIT_EN             0
        #define CONF_URT4_BaudRate_Config     0
    #else
        #define CONF_URT4_INIT_EN             1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT4_MODE == CONF_URT_MODE_UART
                #define CONF_URT4_UART_MASK  0xFFFFFFFF
                #define CONF_URT4_TM_MASK    0
            #elif CONF_URT4_MODE == CONF_URT_MODE_TM
                #define CONF_URT4_UART_MASK  0
                #define CONF_URT4_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT4_UART_MASK  0
                #define CONF_URT4_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT4_INT         ((URT_INT_IEA_mask_w      * CONF_URT4_IEA)    | \
                                           (URT_INT_TX_IE_mask_w    * CONF_URT4_TXIE)   | \
                                           (URT_INT_TC_IE_mask_w    * CONF_URT4_TCIE)   | \
                                           (URT_INT_RX_IE_mask_w    * CONF_URT4_RXIE)   | \
                                           (URT_INT_UG_IE_mask_w    * CONF_URT4_UGFIE)  | \
                                           (URT_INT_BRT_IE_mask_w   * CONF_URT4_BRTIE)  | \
                                           (URT_INT_ERR_IE_mask_w   * CONF_URT4_ERRIE)  | \
                                           (URT_INT_PE_IE_mask_w    * CONF_URT4_PEIE)   | \
                                           (URT_INT_FE_IE_mask_w    * CONF_URT4_FEIE)   | \
                                           (URT_INT_ROVR_IE_mask_w  * CONF_URT4_ROVRIE))
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT4_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT4_UART_BR_MDS     ) & CONF_URT4_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT4_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT4_MODE == CONF_URT_MODE_TM
                #if CONF_URT4_TM_BRT == 1
                    #define CONF_URT4_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT4_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT4_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT4_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT4_UART_BR_CKSEL      << 1)) & CONF_URT4_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT4_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT4_TX_INV       ((CONF_URT4_UART_TX_INV    & CONF_URT4_UART_MASK)<<11)
        
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT4_RX_INV       ((CONF_URT4_UART_RX_INV    & CONF_URT4_UART_MASK)<<10)
        
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT4_IO_SWP       ((CONF_URT4_UART_PINSWAP   & CONF_URT4_UART_MASK)<<8)
        
            // (EN) Function enable.
            #if CONF_URT4_MODE == CONF_URT_MODE_TM
                #define CONF_URT4_EN        URT_CR0_EN_disable_w
            #else
                #define CONF_URT4_EN        URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT4_OS_NUM       ((CONF_URT4_UART_BR_OS     & CONF_URT4_UART_MASK)<<URT_CR1_RXOS_NUM_shift_w)
        
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #define CONF_URT4_STP_LEN      ((CONF_URT4_UART_STOP       & CONF_URT4_UART_MASK)<<6)
        
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #define CONF_URT4_PAR          ((CONF_URT4_UART_PARITY    & CONF_URT4_UART_MASK)<<2)
        
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT4_DSIZE        (CONF_URT4_UART_DATABIT     & CONF_URT4_UART_MASK)
                              
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (TX_EN) Transmitter enable.
            #if CONF_URT4_MODE == CONF_URT_MODE_TM
                #define CONF_URT4_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT4_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT4_MODE == CONF_URT_MODE_TM
                #define CONF_URT4_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT4_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #define CONF_URT4_PSR          (((CONF_URT4_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT4_UART_MASK) | \
                                            (((CONF_URT4_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT4_TM_MASK))
            // (RLR) Baud-rate clock counter reload register.
            #define CONF_URT4_RLR          (((CONF_URT4_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT4_UART_MASK) | \
                                            (((CONF_URT4_TM_BRTRLR-1)    &  URT_RLR_RLR_mask_w) & CONF_URT4_TM_MASK))
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT4_CALC            (((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT4_UART_BR_CALC     )& CONF_URT4_UART_MASK)
            
            #define CONF_URT4_BaudRate_Config (CONF_URT4_UART_BR_CALC     & CONF_URT4_UART_MASK) 
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT4_BD              (CONF_URT4_UART_BR      & CONF_URT4_UART_MASK)
        #endif
    #endif
#else
    #define CONF_URT4_INIT_EN          0
    #define CONF_URT4_BaudRate_Config  0
    #define CONF_URT4_MODE             CONF_URT_MODE_NA
#endif


#if CONF_URT4_INIT_EN == 1
static const uint32_t CONF_URT4[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT4_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT4_BR_MDS)  | \
     (CONF_URT4_BR_EN)   | \
     (CONF_URT4_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT4_TX_INV)    | \
     (CONF_URT4_RX_INV)    | \
     (CONF_URT4_IO_SWP)    | \
     (CONF_URT4_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT4_OS_NUM << 16 ) | (CONF_URT4_OS_NUM)) | \
     ((CONF_URT4_STP_LEN<< 16 ) | (CONF_URT4_STP_LEN))| \
     ((CONF_URT4_PAR    << 16 ) | (CONF_URT4_PAR))    | \
     ((CONF_URT4_DSIZE  << 16 ) | (CONF_URT4_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT4_TX_EN)     | \
     (CONF_URT4_RX_EN)),
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT4_PSR) | \
     (CONF_URT4_RLR)),   
    /*Baud-rate calculation mode*/
    (CONF_URT4_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT4_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT4_BD)
};
#endif
/* URT5 Related Configure-----------------------------------------------*/
#if defined(URT5_Base) 
    /*Disable or Enable check*/
    #if CONF_URT5_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT5_INIT_EN             0
        #define CONF_URT5_BaudRate_Config     0
    #else
        #define CONF_URT5_INIT_EN             1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT5_MODE == CONF_URT_MODE_UART
                #define CONF_URT5_UART_MASK  0xFFFFFFFF
                #define CONF_URT5_TM_MASK    0
            #elif CONF_URT5_MODE == CONF_URT_MODE_TM
                #define CONF_URT5_UART_MASK  0
                #define CONF_URT5_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT5_UART_MASK  0
                #define CONF_URT5_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT5_INT         ((URT_INT_IEA_mask_w      * CONF_URT5_IEA)    | \
                                           (URT_INT_TX_IE_mask_w    * CONF_URT5_TXIE)   | \
                                           (URT_INT_TC_IE_mask_w    * CONF_URT5_TCIE)   | \
                                           (URT_INT_RX_IE_mask_w    * CONF_URT5_RXIE)   | \
                                           (URT_INT_UG_IE_mask_w    * CONF_URT5_UGFIE)  | \
                                           (URT_INT_BRT_IE_mask_w   * CONF_URT5_BRTIE)  | \
                                           (URT_INT_ERR_IE_mask_w   * CONF_URT5_ERRIE)  | \
                                           (URT_INT_PE_IE_mask_w    * CONF_URT5_PEIE)   | \
                                           (URT_INT_FE_IE_mask_w    * CONF_URT5_FEIE)   | \
                                           (URT_INT_ROVR_IE_mask_w  * CONF_URT5_ROVRIE))
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT5_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT5_UART_BR_MDS     ) & CONF_URT5_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT5_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT5_MODE == CONF_URT_MODE_TM
                #if CONF_URT5_TM_BRT == 1
                    #define CONF_URT5_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT5_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT5_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT5_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT5_UART_BR_CKSEL      << 1)) & CONF_URT5_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT5_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT5_TX_INV       ((CONF_URT5_UART_TX_INV    & CONF_URT5_UART_MASK)<<11)
        
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT5_RX_INV       ((CONF_URT5_UART_RX_INV    & CONF_URT5_UART_MASK)<<10)
        
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT5_IO_SWP       ((CONF_URT5_UART_PINSWAP   & CONF_URT5_UART_MASK)<<8)
        
            // (EN) Function enable.
            #if CONF_URT5_MODE == CONF_URT_MODE_TM
                #define CONF_URT5_EN        URT_CR0_EN_disable_w
            #else
                #define CONF_URT5_EN        URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT5_OS_NUM       ((CONF_URT5_UART_BR_OS     & CONF_URT5_UART_MASK)<<URT_CR1_RXOS_NUM_shift_w)
        
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #define CONF_URT5_STP_LEN      ((CONF_URT5_UART_STOP       & CONF_URT5_UART_MASK)<<6)
        
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #define CONF_URT5_PAR          ((CONF_URT5_UART_PARITY    & CONF_URT5_UART_MASK)<<2)
        
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT5_DSIZE        (CONF_URT5_UART_DATABIT     & CONF_URT5_UART_MASK)
                              
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (TX_EN) Transmitter enable.
            #if CONF_URT5_MODE == CONF_URT_MODE_TM
                #define CONF_URT5_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT5_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT5_MODE == CONF_URT_MODE_TM
                #define CONF_URT5_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT5_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #define CONF_URT5_PSR          (((CONF_URT5_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT5_UART_MASK) | \
                                            (((CONF_URT5_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT5_TM_MASK))
            // (RLR) Baud-rate clock counter reload register.
            #define CONF_URT5_RLR          (((CONF_URT5_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT5_UART_MASK) | \
                                            (((CONF_URT5_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT5_TM_MASK))
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT5_CALC            (((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT5_UART_BR_CALC     )& CONF_URT5_UART_MASK)
            
            #define CONF_URT5_BaudRate_Config (CONF_URT5_UART_BR_CALC     & CONF_URT5_UART_MASK) 
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT5_BD              (CONF_URT5_UART_BR      & CONF_URT5_UART_MASK)
        #endif
    #endif
#else
    #define CONF_URT5_INIT_EN          0
    #define CONF_URT5_BaudRate_Config  0
    #define CONF_URT5_MODE             CONF_URT_MODE_NA
#endif


#if CONF_URT5_INIT_EN == 1
static const uint32_t CONF_URT5[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT5_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT5_BR_MDS)  | \
     (CONF_URT5_BR_EN)   | \
     (CONF_URT5_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT5_TX_INV)    | \
     (CONF_URT5_RX_INV)    | \
     (CONF_URT5_IO_SWP)    | \
     (CONF_URT5_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT5_OS_NUM << 16 ) | (CONF_URT5_OS_NUM)) | \
     ((CONF_URT5_STP_LEN<< 16 ) | (CONF_URT5_STP_LEN))| \
     ((CONF_URT5_PAR    << 16 ) | (CONF_URT5_PAR))    | \
     ((CONF_URT5_DSIZE  << 16 ) | (CONF_URT5_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT5_TX_EN)     | \
     (CONF_URT5_RX_EN)),
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT5_PSR) | \
     (CONF_URT5_RLR)),   
    /*Baud-rate calculation mode*/
    (CONF_URT5_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT5_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT5_BD)
};
#endif

/* URT6 Related Configure-----------------------------------------------*/
#if defined(URT6_Base) 
    /*Disable or Enable check*/
    #if CONF_URT6_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT6_INIT_EN             0
        #define CONF_URT6_BaudRate_Config     0
    #else
        #define CONF_URT6_INIT_EN             1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT6_MODE == CONF_URT_MODE_UART
                #define CONF_URT6_UART_MASK  0xFFFFFFFF
                #define CONF_URT6_TM_MASK    0
            #elif CONF_URT6_MODE == CONF_URT_MODE_TM
                #define CONF_URT6_UART_MASK  0
                #define CONF_URT6_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT6_UART_MASK  0
                #define CONF_URT6_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT6_INT         ((URT_INT_IEA_mask_w      * CONF_URT6_IEA)    | \
                                           (URT_INT_TX_IE_mask_w    * CONF_URT6_TXIE)   | \
                                           (URT_INT_TC_IE_mask_w    * CONF_URT6_TCIE)   | \
                                           (URT_INT_RX_IE_mask_w    * CONF_URT6_RXIE)   | \
                                           (URT_INT_UG_IE_mask_w    * CONF_URT6_UGFIE)  | \
                                           (URT_INT_BRT_IE_mask_w   * CONF_URT6_BRTIE)  | \
                                           (URT_INT_ERR_IE_mask_w   * CONF_URT6_ERRIE)  | \
                                           (URT_INT_PE_IE_mask_w    * CONF_URT6_PEIE)   | \
                                           (URT_INT_FE_IE_mask_w    * CONF_URT6_FEIE)   | \
                                           (URT_INT_ROVR_IE_mask_w  * CONF_URT6_ROVRIE))
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT6_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT6_UART_BR_MDS     ) & CONF_URT6_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT6_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT6_MODE == CONF_URT_MODE_TM
                #if CONF_URT6_TM_BRT == 1
                    #define CONF_URT6_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT6_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT6_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT6_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT6_UART_BR_CKSEL      << 1)) & CONF_URT6_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT6_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT6_TX_INV       ((CONF_URT6_UART_TX_INV    & CONF_URT6_UART_MASK)<<11)
        
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT6_RX_INV       ((CONF_URT6_UART_RX_INV    & CONF_URT6_UART_MASK)<<10)
        
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT6_IO_SWP       ((CONF_URT6_UART_PINSWAP   & CONF_URT6_UART_MASK)<<8)
        
            // (EN) Function enable.
            #if CONF_URT6_MODE == CONF_URT_MODE_TM
                #define CONF_URT6_EN        URT_CR0_EN_disable_w
            #else
                #define CONF_URT6_EN        URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT6_OS_NUM       ((CONF_URT6_UART_BR_OS     & CONF_URT6_UART_MASK)<<URT_CR1_RXOS_NUM_shift_w)
        
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #define CONF_URT6_STP_LEN      ((CONF_URT6_UART_STOP       & CONF_URT6_UART_MASK)<<6)
        
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #define CONF_URT6_PAR          ((CONF_URT6_UART_PARITY    & CONF_URT6_UART_MASK)<<2)
        
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT6_DSIZE        (CONF_URT6_UART_DATABIT     & CONF_URT6_UART_MASK)
                              
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (TX_EN) Transmitter enable.
            #if CONF_URT6_MODE == CONF_URT_MODE_TM
                #define CONF_URT6_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT6_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT6_MODE == CONF_URT_MODE_TM
                #define CONF_URT6_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT6_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #define CONF_URT6_PSR          (((CONF_URT6_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT6_UART_MASK) | \
                                            (((CONF_URT6_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT6_TM_MASK))
            // (RLR) Baud-rate clock counter reload register.
            #define CONF_URT6_RLR          (((CONF_URT6_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT6_UART_MASK) | \
                                            (((CONF_URT6_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT6_TM_MASK))
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT6_CALC            (((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT6_UART_BR_CALC     )& CONF_URT6_UART_MASK)
            
            #define CONF_URT6_BaudRate_Config (CONF_URT6_UART_BR_CALC     & CONF_URT6_UART_MASK) 
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT6_BD              (CONF_URT6_UART_BR      & CONF_URT6_UART_MASK)
        #endif
    #endif
#else
    #define CONF_URT6_INIT_EN          0
    #define CONF_URT6_BaudRate_Config  0
    #define CONF_URT6_MODE             CONF_URT_MODE_NA
#endif


#if CONF_URT6_INIT_EN == 1
static const uint32_t CONF_URT6[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT6_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT6_BR_MDS)  | \
     (CONF_URT6_BR_EN)   | \
     (CONF_URT6_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT6_TX_INV)    | \
     (CONF_URT6_RX_INV)    | \
     (CONF_URT6_IO_SWP)    | \
     (CONF_URT6_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT6_OS_NUM << 16 ) | (CONF_URT6_OS_NUM)) | \
     ((CONF_URT6_STP_LEN<< 16 ) | (CONF_URT6_STP_LEN))| \
     ((CONF_URT6_PAR    << 16 ) | (CONF_URT6_PAR))    | \
     ((CONF_URT6_DSIZE  << 16 ) | (CONF_URT6_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT6_TX_EN)     | \
     (CONF_URT6_RX_EN)),
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT6_PSR) | \
     (CONF_URT6_RLR)),   
    /*Baud-rate calculation mode*/
    (CONF_URT6_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT6_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT6_BD)
};
#endif

/* URT7 Related Configure-----------------------------------------------*/
#if defined(URT7_Base) 
    /*Disable or Enable check*/
    #if CONF_URT7_MODE == CONF_URT_MODE_DISABLE
        #define CONF_URT7_INIT_EN             0
        #define CONF_URT7_BaudRate_Config     0
    #else
        #define CONF_URT7_INIT_EN             1
    
        /*Mode setting mask*/
        #if 1
            #if CONF_URT7_MODE == CONF_URT_MODE_UART
                #define CONF_URT7_UART_MASK  0xFFFFFFFF
                #define CONF_URT7_TM_MASK    0
            #elif CONF_URT7_MODE == CONF_URT_MODE_TM
                #define CONF_URT7_UART_MASK  0
                #define CONF_URT7_TM_MASK    0xFFFFFFFF
            #else
                #define CONF_URT7_UART_MASK  0
                #define CONF_URT7_TM_MASK    0
            #endif
        #endif
        /*INT    (Interrupt Enable Register)*/
        #if 1
            #define CONF_URT7_INT         ((URT_INT_IEA_mask_w      * CONF_URT7_IEA)    | \
                                           (URT_INT_TX_IE_mask_w    * CONF_URT7_TXIE)   | \
                                           (URT_INT_TC_IE_mask_w    * CONF_URT7_TCIE)   | \
                                           (URT_INT_RX_IE_mask_w    * CONF_URT7_RXIE)   | \
                                           (URT_INT_UG_IE_mask_w    * CONF_URT7_UGFIE)  | \
                                           (URT_INT_BRT_IE_mask_w   * CONF_URT7_BRTIE)  | \
                                           (URT_INT_ERR_IE_mask_w   * CONF_URT7_ERRIE)  | \
                                           (URT_INT_PE_IE_mask_w    * CONF_URT7_PEIE)   | \
                                           (URT_INT_FE_IE_mask_w    * CONF_URT7_FEIE)   | \
                                           (URT_INT_ROVR_IE_mask_w  * CONF_URT7_ROVRIE))
        #endif
        /*CLK    (Clock Source Register)*/
        #if 1 
            // (BR_MDS) Baud-rate timer mode select.
            #define CONF_URT7_BR_MDS      (((URT_CLK_BR_MDS_mask_w * CONF_URT7_UART_BR_MDS     ) & CONF_URT7_UART_MASK) |\
                                           ((URT_CLK_BR_MDS_mask_w * 1                         ) & CONF_URT7_TM_MASK))
            // (BR_EN Baud-rate timer enable
            #if CONF_URT7_MODE == CONF_URT_MODE_TM
                #if CONF_URT7_TM_BRT == 1
                    #define CONF_URT7_BR_EN        URT_CLK_BR_EN_enable_w
                #else
                    #define CONF_URT7_BR_EN        URT_CLK_BR_EN_disable_w
                #endif
            #else
                #define CONF_URT7_BR_EN        URT_CLK_BR_EN_enable_w
            #endif
            // (CK_SEL) Internal clock CK_URTx source select.
            #define CONF_URT7_CK_SEL       (((URT_CLK_CK_SEL_mask_w & (CONF_URT7_UART_BR_CKSEL      << 1)) & CONF_URT7_UART_MASK) |\
                                            ((URT_CLK_CK_SEL_mask_w & (0                            << 1)) & CONF_URT7_TM_MASK))
        #endif
        /*CR0    (Control Register 0)*/
        #if 1 
            // (TX_INV) TX output signal inverse enable.
            #define CONF_URT7_TX_INV       ((CONF_URT7_UART_TX_INV   & CONF_URT7_UART_MASK)<<11)
        
            // (RX_INV) RX input signal inverse enable.
            #define CONF_URT7_RX_INV       ((CONF_URT7_UART_RX_INV   & CONF_URT7_UART_MASK)<<10)
        
            // (IO_SWP) RX/TX swap enable bit.
            #define CONF_URT7_IO_SWP       ((CONF_URT7_UART_PINSWAP  & CONF_URT7_UART_MASK)<<8)
        
            // (EN) Function enable.
            #if CONF_URT7_MODE == CONF_URT_MODE_TM
                #define CONF_URT7_EN             URT_CR0_EN_disable_w
            #else
                #define CONF_URT7_EN             URT_CR0_EN_enable_w
            #endif
        #endif
        /*CR1    (Control Register 1)*/
        #if 1 
            // (TXOS_NUM) TX data oversampling samples select.
            // (RXOS_NUM) RX data oversampling samples select.
            #define CONF_URT7_OS_NUM       ((CONF_URT7_UART_BR_OS     & CONF_URT7_UART_MASK)<<URT_CR1_RXOS_NUM_shift_w)
        
            // (TXSTP_LEN) TX stop bit length select.
            // (RXSTP_LEN) RX stop bit length select.
            #define CONF_URT7_STP_LEN      ((CONF_URT7_UART_STOP       & CONF_URT7_UART_MASK)<<6)
        
            // (TXPAR_STK) TX Stuck parity bit output enable.
            // (TXPAR_POL) TX parity bit polarity.
            // (TXPAR_EN)  TX parity bit enable.
            // (RXPAR_STK) RX Stuck parity bit output enable.
            // (RXPAR_POL) RX parity bit polarity.
            // (RXPAR_EN)  RX parity bit enable.
            #define CONF_URT7_PAR          ((CONF_URT7_UART_PARITY    & CONF_URT7_UART_MASK)<<2)
        
            // (TXDSIZE) TX data bit length.
            // (RXDSIZE) RX data bit length.
            #define CONF_URT7_DSIZE        (CONF_URT7_UART_DATABIT     & CONF_URT7_UART_MASK)
                              
        #endif
        /*CR2    (Control Register 2)*/
        #if 1 
            // (TX_EN) Transmitter enable.
            #if CONF_URT7_MODE == CONF_URT_MODE_TM
                #define CONF_URT7_TX_EN       URT_CR2_TX_EN_disable_w
            #else
                #define CONF_URT7_TX_EN       URT_CR2_TX_EN_enable_w
            #endif 
            // (RX_EN) Receive enable.
            #if CONF_URT7_MODE == CONF_URT_MODE_TM
                #define CONF_URT7_RX_EN       URT_CR2_RX_EN_disable_w
            #else
                #define CONF_URT7_RX_EN       URT_CR2_RX_EN_enable_w
            #endif
        #endif
        /*RLR    (Baud-rate clock counter reload register)*/
        #if 1
            // (PSR) Baud-rate clock prescaler reload register.
            #define CONF_URT7_PSR          (((CONF_URT7_UART_BR_PRE     << URT_RLR_PSR_shift_w) & CONF_URT7_UART_MASK) | \
                                            (((CONF_URT7_TM_BRTRLR-1)    & URT_RLR_PSR_mask_w)  & CONF_URT7_TM_MASK))
            // (RLR) Baud-rate clock counter reload register.
            #define CONF_URT7_RLR          (((CONF_URT7_UART_BR_BR      << URT_RLR_RLR_shift_w) & CONF_URT7_UART_MASK) | \
                                            (((CONF_URT7_TM_BRTRLR-1)   &  URT_RLR_RLR_mask_w)  & CONF_URT7_TM_MASK))
        #endif
        /*Baud-rate calculation mode*/
        #if 1
            #define CONF_URT7_CALC            (((CONF_URT_BR_CALC_MASK | ( CONF_URT_UART_OS_MIN << 16)) * CONF_URT7_UART_BR_CALC     )& CONF_URT7_UART_MASK)
            
            #define CONF_URT7_BaudRate_Config (CONF_URT7_UART_BR_CALC     & CONF_URT7_UART_MASK) 
        #endif
        /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
        #if 1
            #define CONF_URT7_BD              (CONF_URT7_UART_BR      & CONF_URT7_UART_MASK)
        #endif
    #endif
#else
    #define CONF_URT7_INIT_EN          0
    #define CONF_URT7_BaudRate_Config  0
    #define CONF_URT7_MODE             CONF_URT_MODE_NA
#endif


#if CONF_URT7_INIT_EN == 1
static const uint32_t CONF_URT7[] = 
{
    /*INT    (URT Interrupt Enable Register)*/
    CONF_URT7_INT,
    /*CLK    (URT Clock Source Register)*/
    ((CONF_URT7_BR_MDS)  | \
     (CONF_URT7_BR_EN)   | \
     (CONF_URT7_CK_SEL)),
    /*CR0    (Control Register 0)*/
    ((CONF_URT7_TX_INV)    | \
     (CONF_URT7_RX_INV)    | \
     (CONF_URT7_IO_SWP)    | \
     (CONF_URT7_EN)),
    /*CR1    (Control Register 1)*/
    (((CONF_URT7_OS_NUM << 16 ) | (CONF_URT7_OS_NUM)) | \
     ((CONF_URT7_STP_LEN<< 16 ) | (CONF_URT7_STP_LEN))| \
     ((CONF_URT7_PAR    << 16 ) | (CONF_URT7_PAR))    | \
     ((CONF_URT7_DSIZE  << 16 ) | (CONF_URT7_DSIZE))),
    /*CR2    (Control Register 2)*/
    ((CONF_URT7_TX_EN)     | \
     (CONF_URT7_RX_EN)),
    /*RLR    (Baud-rate clock counter reload register)*/
    ((CONF_URT7_PSR) | \
     (CONF_URT7_RLR)),   
    /*Baud-rate calculation mode*/
    (CONF_URT7_CALC),
    /*CK_URTn_PR frequence */
    (CONF_URT7_Freq),
    /*Baud-rate value in baud-rate calculation mode is "Dynmical calculation"*/
    (CONF_URT7_BD)
};
#endif


//Preprocessing to judge whether need URT_BaudRate_Config() or not.
#define CONF_URT0123_BaudRate_Config     (CONF_URT0_BaudRate_Config + CONF_URT1_BaudRate_Config + CONF_URT2_BaudRate_Config + CONF_URT3_BaudRate_Config)
#define CONF_URT4567_BaudRate_Config     (CONF_URT4_BaudRate_Config + CONF_URT5_BaudRate_Config + CONF_URT6_BaudRate_Config + CONF_URT7_BaudRate_Config)

/* Private variables ---------------------------------------------------------*/
#if defined(IRQHandler_Middleware_Level_)
#if CONF_URT0_INIT_EN == 1 
    #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE
        SPI_HandleTypeDef        mUSPI0;
    #elif CONF_URT0_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT0;
    #endif
#endif
#if CONF_URT1_INIT_EN == 1 
    #if CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE
        SPI_HandleTypeDef        mUSPI1;
    #elif CONF_URT1_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT1;
    #endif
#endif
#if CONF_URT2_INIT_EN == 1 
    #if CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE
        SPI_HandleTypeDef        mUSPI2;
    #elif CONF_URT2_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT2;
    #endif
#endif
#if CONF_URT3_INIT_EN == 1 
    #if CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE
        SPI_HandleTypeDef        mUSPI3;
    #elif CONF_URT3_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT3;
    #endif
#endif
#if CONF_URT4_INIT_EN == 1
    #if CONF_URT4_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT4;
    #endif
#endif
#if CONF_URT5_INIT_EN == 1
    #if CONF_URT5_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT5;
    #endif
#endif
#if CONF_URT6_INIT_EN == 1
    #if CONF_URT6_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT6;
    #endif
#endif
#if CONF_URT7_INIT_EN == 1
    #if CONF_URT7_MODE != CONF_URT_MODE_TM
        URT_HandleTypeDef        mURT7;
    #endif
#endif
#endif

/* Private function prototypes -----------------------------------------------*/
uint8_t URT_BaudRate_Config( URT_Struct* URTx , uint32_t URTx_CLKFreq,uint32_t URTx_OS_Min,uint32_t URTx_BR);
uint8_t URT0123_Config(URT_Struct* URT0123 , const uint32_t *URT0123_Setting);
uint8_t URT4567_Config(URT_Struct* URT4567 , const uint32_t *URT4567_Setting);


/**
 *******************************************************************************
 * @brief	  URTs inital function.  
 * @details                                                    
 * @return    URTs initial whether success or not.  
 * @exception   
 * @note        
 *******************************************************************************
 */
#if defined(IRQHandler_Middleware_Level_)
    #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE || \
        CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE || \
        CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE || \
        CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE 
    static void URT_SetSPIMiddlewareStatus( SPI_HandleTypeDef* mUSPIx)
    {
        /*Update module state*/
        mUSPIx->State          = MID_SPI_STATE_BUSY;
        
        /*Initial transmission parameter.*/
        mUSPIx->REG_TYPE       = MID_SPI_URT;
        mUSPIx->Init.DataSize  = SPI_DATASIZE_8BIT;
        mUSPIx->Init.DataLine  = SPI_STANDARD_SPI;
        
        /*Map flag to URT*/
        #if (defined(MG32_3RD) || defined(MG32_4TH))
        mUSPIx->SPI_FLAG_TUDRF = URT_STA_TUDRF_mask_w;
        mUSPIx->SPI_FLAG_ROVRF = URT_STA_ROVRF_mask_w;
        mUSPIx->SPI_FLAG_ERROR = (URT_STA_ROVRF_mask_w | URT_STA_TUDRF_mask_w | URT_STA_ERRF_mask_w);
        #else
        mUSPIx->SPI_FLAG_TUDRF = 0;
        mUSPIx->SPI_FLAG_ROVRF = 0;
        mUSPIx->SPI_FLAG_ERROR = 0;
        #endif
        mUSPIx->SPI_FLAG_IDLF  = 0;
        mUSPIx->SPI_FLAG_TCF   = URT_STA_TCF_mask_w;
        
        /*RX shadow buffer level register define*/
        mUSPIx->RX_TH      = &(mUSPIx->Instance->CR0.B[2]);
        mUSPIx->RXTX_LVL   = &(mUSPIx->Instance->STA2.B[3]);
        mUSPIx->RXTX_CLR   = &(mUSPIx->Instance->CR4.B[0]);
        mUSPIx->RNUM       = &(mUSPIx->Instance->CR4.B[1]);
        
        /*Update ErrorCode and module state*/
        mUSPIx->ErrorCode  = MID_SPI_ERROR_NONE;
        mUSPIx->State      = MID_SPI_STATE_READY;
        
    }
    #endif
#endif
    
/**
 *******************************************************************************
 * @brief	  Dynamical calculation baud-rate. 
 * @details   
 * @param[in] URTx: URT module number.
 * @param[in] URTx_CLKFreq: The URT module CK_URTx_PR frequence.
 * @param[in] URTx_OS_Min: Min oversampling number.
 * @param[in] URTx_BaudRate: Baud-rate value.
 * @return    Return baud-rate calculation result whether success or not.
 * @exception   
 * @note        
 *******************************************************************************
 */
#if ( CONF_URT0123_BaudRate_Config != 0) || (CONF_URT4567_BaudRate_Config!=0)
uint8_t URT_BaudRate_Config( URT_Struct* URTx , uint32_t URTx_CLKFreq, uint32_t URTx_OS_Min, uint32_t URTx_BaudRate)
{ 
    uint32_t     URT_TXRXOS_NUM;
    uint32_t     URT_BR_OVSMP_Tmp;
    uint32_t     URT_BR_BSolution;
    uint32_t     URT_BR_CmpTmp;
    
    /*Determining User baud-rate whether is over data spec baud-rate. */
    div_t  URT_BRConfig_Tmp;
    div_t  URT_BR_DivisionResult;
    
    URT_BRConfig_Tmp  = div((int)(URTx_CLKFreq),(int)(URTx_BaudRate));    
    
    
    if((uint32_t)URT_BRConfig_Tmp.quot<(URTx_OS_Min+1))
    {
        return(CONF_URT_INIT_FAILURE);
    }
    else if( (uint32_t)URT_BRConfig_Tmp.rem > (URTx_BaudRate>>1))
    {
        URT_BRConfig_Tmp.quot = URT_BRConfig_Tmp.quot + 1;
    }
    /*Calculate TX / RX oversampling value.*/
    URT_BR_BSolution = 0;
    URT_BR_CmpTmp    = 0;
    URT_TXRXOS_NUM   = URTx_OS_Min;
    
	for(URT_BR_OVSMP_Tmp=URTx_OS_Min;URT_BR_OVSMP_Tmp<32;URT_BR_OVSMP_Tmp++)
	{
        URT_BR_DivisionResult = div(URT_BRConfig_Tmp.quot,((int)((URT_BR_OVSMP_Tmp+1))));    

		if(URT_BR_DivisionResult.rem==0)
		{
            if(((uint32_t)(URT_BR_DivisionResult.quot))<CONF_URT_BRG_MAX)
            {
			    URT_TXRXOS_NUM   = (uint32_t)(URT_BR_OVSMP_Tmp);
                URT_BR_BSolution = (uint32_t)(URT_BR_DivisionResult.quot);
			    break;
            }
		}
		else
		{
            if(((URT_BR_OVSMP_Tmp-((uint32_t)(URT_BR_DivisionResult.rem))+1))>(URT_BR_CmpTmp))
			{
				URT_BR_CmpTmp    = URT_BR_OVSMP_Tmp - ((uint32_t)URT_BR_DivisionResult.rem);
				URT_TXRXOS_NUM   = URT_BR_OVSMP_Tmp;
                URT_BR_BSolution = ((uint32_t)URT_BR_DivisionResult.quot);
			}
		}
	}
    /*Set the URTx TX , RX clock source from URTx_INT*/
	URTx->CLK.W = URTx->CLK.W & (~(URT_CLK_TX_CKS_mask_w| URT_CLK_RX_CKS_mask_w | URT_CLK_CK_SEL_mask_w));
    
    /*Calculate Baud-Rate Generator reload value.*/
    if(URT_BR_BSolution>CONF_URT_BRG_MAX)
    {
        return(CONF_URT_INIT_FAILURE);
    }
    URTx->RLR.H[0] = ((uint16_t)(URT_BR_BSolution - 1));
     
    /*Set oversampling samples.*/
    URTx->CR1.B[3] = (uint8_t)URT_TXRXOS_NUM;
    URTx->CR1.B[1] = (uint8_t)URT_TXRXOS_NUM;
    
    /*Set BR_MDS = Combined mode and baud-rate timer enable.*/
    URTx->CLK.W = URTx->CLK.W | (URT_CLK_BR_MDS_combined_w | URT_CLK_BR_EN_enable_w); 
    
    return(CONF_URT_INIT_SUCCESS);
} 
#endif
/**
 *******************************************************************************
 * @brief	   URT0/URT1/URT2/URT3 configure function.
 * @details                                           
 * @param[in]  URT0123: URTn register base address.
 * @param[in]  URT0123_Setting: Setting table pointer.
 * @return     Configure whether success or not.  
 * @exception   
 * @note         
 *******************************************************************************
 */
uint8_t URT0123_Config(URT_Struct* URT0123 , const uint32_t *URT0123_Setting)
{
    #if CONF_URT0123_BaudRate_Config != 0
        uint32_t URT0123_ConfigTmp;
    #endif
    /* Configure:
        1. Set URT mode.
        2. If URT mode is UART mode, setting DE signal whether existing or not
           and setting the DE signal mode if the DE signal exists.
        3. TX / RX pin whether swap or not.
        4. TX / RX signal whether inverse or not.
        5. If URT is Multi-Processor mode, whether enable global slave address.
    */
    URT0123->CR0.W    = URT0123_Setting[CONF_URT0n_DATA_CR0];
    /* Configure:
        1. Data oversampling number.
        2. Stop bit length.
        3. Data order (MSB first whether enable or not).
        4. Data bit length.
        5. Parity bit whether existing or not and setting parity bit mode if the parity bit exist.
    */
    URT0123->CR1.W    = URT0123_Setting[CONF_URT0n_DATA_CR1];
    /* Configure:
        1. Enable TX / RX function.
        2. If URT is SPI master or slave mode set TX(MOSI) idle state.
        3. If URT is SPI master or slave mode configure NSS pin.
        4. If URT is Multi-Processor mode set slave address.
    */
    URT0123->CR2.W    = URT0123_Setting[CONF_URT0n_DATA_CR2];
    /* Configure:
        1. Set TX guard time.
        2. Set {CPHA,CPOL} mode when URT is SPI master or slave mode.
    */
    URT0123->CR3.W    = URT0123_Setting[CONF_URT0n_DATA_CR3];
    /* Configure:
        1. Clear TX / RX bufffer status.
        2. Control TX / RX data bit whether inverse or not.
    */
    URT0123->CR4.W    = URT0123_Setting[CONF_URT0n_DATA_CR4];
    /* Configure Timeout timer related setting.*/
    URT0123->TMOUT.W  = (URT0123_Setting[CONF_URT0n_DATA_TMOUT] & (~URT_TMOUT_TMO_EN_mask_w));
    URT0123->TMOUT2.W = URT0123_Setting[CONF_URT0n_DATA_TMOUT2];
    
    /*Configure:
        1. If URT mode is SC mode or LIN mode, enable TX error and setting TX error mode.
        2. If URT mode is SC mode, enable RX error mode and setting RX error mode.        
    */
    URT0123->SC.W     = URT0123_Setting[CONF_URT0n_DATA_SC];
    
    /* If the URT mode is Multi-Processor mode, set a slave address and slave address mask.*/
    URT0123->SADR.W   = URT0123_Setting[CONF_URT0n_DATA_SADR];
    
    /* If the URT mode is LIN mode, set baud-rate auto calibration mode.*/
    URT0123->CAL.W    = URT0123_Setting[CONF_URT0n_DATA_CAL];
    
    /* Configure hardware flow control
        1. If URT mode is UART mode, setting RTS signal whether existing or not
           and setting the RTS signal mode if the RTS signal exists.
        2. If URT mode is UART mode, setting CTS signal whether existing or not
           and setting the CTS signal mode if the CTS signal exists.   
    */
    URT0123->HFC.W    = URT0123_Setting[CONF_URT0n_DATA_HFC];
    
    /* Cofigure
        1. If Baud-rate calculation mode is a "Static calculation by user", 
           configuring Baud-Rate Generator.
        2. If Baud-rate calculation mode is a "Dynamical calculation in Code", 
           configuring Baud-Rate Generator and data oversampling number.
    */
    if ((URT0123_Setting[CONF_URT0n_DATA_CALC] & CONF_URT_BR_CALC_MASK)==0)
    {
        URT0123->CLK.W    = (URT0123_Setting[CONF_URT0n_DATA_CLK] & (~URT_CLK_BR_EN_mask_w));
        URT0123->RLR.W    = URT0123_Setting[CONF_URT0n_DATA_RLR];
        URT0123->CLK.W   |= (URT0123_Setting[CONF_URT0n_DATA_CLK] & URT_CLK_BR_EN_mask_w);
    }
    #if CONF_URT0123_BaudRate_Config != 0
    else
    {
        URT0123_ConfigTmp = ((URT0123_Setting[CONF_URT0n_DATA_CALC] & CONF_URT_BR_OS_MASK)>>16);
        
        if( URT_BaudRate_Config( URT0123, URT0123_Setting[CONF_URT0n_DATA_FREQ], URT0123_ConfigTmp , URT0123_Setting[CONF_URT0n_DATA_BD]) == CONF_URT_INIT_FAILURE)
        {
            return(CONF_URT_INIT_FAILURE);
        }
        
        URT0123->CLK.W = ((URT0123->CLK.W & (~(URT_CLK_CLK_EN_mask_w | URT_CLK_CLK_CKS_mask_w | URT_CLK_RX_CKS_mask_w | URT_CLK_TX_CKS_mask_w))) | \
                          (URT0123_Setting[CONF_URT0n_DATA_CLK] & (URT_CLK_CLK_EN_mask_w | URT_CLK_CLK_CKS_mask_w | URT_CLK_RX_CKS_mask_w | URT_CLK_TX_CKS_mask_w)));
    }
    #endif
    
    /* If the URT mode is IrDA, enable IrDA , adjust IrDA mode and set pulse width.*/
    URT0123->IRDA.W   = URT0123_Setting[CONF_URT0n_DATA_IRDA];
    if( URT0123->IRDA.W & URT_IRDA_IR_EN_mask_w)
    {
        URT0123->IRDA.MBIT.IR_PW =  URT_IrDAPulseWidth_Table[(URT0123->CR1.MBIT.TXOS_NUM - 15)];
    }
    /*Enable Timeout timer if the mode need timeout timer.*/
    URT0123->TMOUT.W  |= (URT0123_Setting[CONF_URT0n_DATA_TMOUT] & URT_TMOUT_TMO_EN_mask_w);
    
    /*Enable URT function.*/
    URT0123->CR0.W    |= (URT0123_Setting[CONF_URT0n_DATA_CR0] &URT_CR0_EN_mask_w);
    
    /*Clear URTx flag(flag is writing 1 to clear.).*/
    URT0123->STA.W    = 0xFFFFFFFF;                     
    
    /*Clear TX / RX status*/
    URT0123->CR2.W = URT0123->CR2.W | (URT_CR4_TDAT_CLR_mask_w | URT_CR4_RDAT_CLR_mask_w);
    
    /*Configure URTx Interrupt.*/
    URT0123->INT.W    = URT0123_Setting[CONF_URT0n_DATA_INT];
    
    return(CONF_URT_INIT_SUCCESS);
}

/**
 *******************************************************************************
 * @brief	   URT4/URT5/URT6/URT7 configure function.
 * @details                                           
 * @param[in]  URT4567: URTn register base address.
 * @param[in]  URT4567_Setting: Setting table pointer.
 * @return     Configure whether success or not. 
 * @exception   
 * @note        
 *******************************************************************************
 */
uint8_t URT4567_Config(URT_Struct* URT4567 , const uint32_t *URT4567_Setting)
{
    #if CONF_URT4567_BaudRate_Config != 0
        uint32_t URT4567_ConfigTmp;
    #endif
    /* Configure:
        1. TX / RX pin whether swap or not.
        2. TX / RX signal whether inverse or not.
    */
    URT4567->CR0.W    = URT4567_Setting[CONF_URT4n_DATA_CR0];
    /* Configure:
        1. Data oversampling number.
        2. Stop bit length.
        3. Data bit length.
        4. Parity bit whether existing or not and setting parity bit mode if the parity bit exist.
    */
    URT4567->CR1.W    = URT4567_Setting[CONF_URT4n_DATA_CR1];
    /* Enable TX / RX function.*/
    URT4567->CR2.W    = URT4567_Setting[CONF_URT4n_DATA_CR2];

    /* Cofigure
        1. If Baud-rate calculation mode is a "Static calculation by user", 
           configuring Baud-Rate Generator.
        2. If Baud-rate calculation mode is a "Dynamical calculation in Code", 
           configuring Baud-Rate Generator and data oversampling number.
    */
    if ((URT4567_Setting[CONF_URT4n_DATA_CALC] & CONF_URT_BR_CALC_MASK)==0)
    {
        URT4567->CLK.W    = (URT4567_Setting[CONF_URT4n_DATA_CLK] & (~URT_CLK_BR_EN_mask_w));
        URT4567->RLR.W    =  URT4567_Setting[CONF_URT4n_DATA_RLR];
        URT4567->CLK.W   |= (URT4567_Setting[CONF_URT4n_DATA_CLK] & URT_CLK_BR_EN_mask_w);
    }
    #if CONF_URT4567_BaudRate_Config != 0
    else
    {
        URT4567_ConfigTmp = ((URT4567_Setting[CONF_URT4n_DATA_CALC] & CONF_URT_BR_OS_MASK)>>16);
        
        if( URT_BaudRate_Config( URT4567, URT4567_Setting[CONF_URT4n_DATA_FREQ], URT4567_ConfigTmp , URT4567_Setting[CONF_URT4n_DATA_BD]) == CONF_URT_INIT_FAILURE)
        {
            return(CONF_URT_INIT_FAILURE);
        }
    }
    #endif
    /*Enable URT function.*/
    URT4567->CR0.W    |= (URT4567_Setting[CONF_URT4n_DATA_CR0] &URT_CR0_EN_mask_w);
    
    /*Clear URTx flag.*/
    URT4567->STA.W    = 0xFFFFFFFF;                           // Flag is writing 11 to clear.
    
    /*Configure URTx Interrupt.*/
    URT4567->INT.W    = URT4567_Setting[CONF_URT4n_DATA_INT];
    
    return(CONF_URT_INIT_SUCCESS);
}

/**
 *******************************************************************************
 * @brief	  URTs inital function.  
 * @details                                                    
 * @return    URTs initial whether success or not.  
 * @exception   
 * @note        
 *******************************************************************************
 */
uint8_t URT_Init(void)
{
    uint8_t URT_InitResult = CONF_URT_INIT_SUCCESS;
    
    /*URT0 ~ URT3 Init*/
    #if CONF_URT0_INIT_EN == 1
        URT0_InitCallback();
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT0_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT0_MODE == CONF_URT_MODE_SPI_SLAVE   
                mUSPI0.Instance      = SPI_URT0;    
                mUSPI0.SPI_IRQ       = URT0_IRQn;
                URT_SetSPIMiddlewareStatus(&mUSPI0);
            #elif CONF_URT0_MODE != CONF_URT_MODE_TM
                mURT0.gState    = MID_URT_STATE_BUSY;
                mURT0.Instance  = URT0;
                mURT0.gState    = MID_URT_STATE_READY;
                mURT0.RxState   = MID_URT_STATE_READY;
            #endif
        #endif  
        URT_InitResult |= URT0123_Config( URT0, CONF_URT0);
    #endif
    #if CONF_URT1_INIT_EN == 1
        URT1_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT1_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT1_MODE == CONF_URT_MODE_SPI_SLAVE   
                mUSPI1.Instance      = SPI_URT1;    
                mUSPI1.SPI_IRQ       = URT123_IRQn;
                URT_SetSPIMiddlewareStatus(&mUSPI1);
            #elif CONF_URT1_MODE != CONF_URT_MODE_TM   
                mURT1.gState    = MID_URT_STATE_BUSY;
                mURT1.Instance  = URT1;
                mURT1.gState    = MID_URT_STATE_READY;
                mURT1.RxState   = MID_URT_STATE_READY;
            #endif
        #endif
        URT_InitResult |= URT0123_Config( URT1, CONF_URT1);
    #endif
    #if CONF_URT2_INIT_EN == 1
        URT2_InitCallback();
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT2_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT2_MODE == CONF_URT_MODE_SPI_SLAVE   
                mUSPI2.Instance      = SPI_URT2;    
                mUSPI2.SPI_IRQ       = URT123_IRQn;
                URT_SetSPIMiddlewareStatus(&mUSPI2);
            #elif CONF_URT2_MODE != CONF_URT_MODE_TM
                mURT2.gState    = MID_URT_STATE_BUSY;
                mURT2.Instance = URT2;
                mURT2.gState   = MID_URT_STATE_READY;
                mURT2.RxState  = MID_URT_STATE_READY;
            #endif
        #endif    
        URT_InitResult |= URT0123_Config( URT2, CONF_URT2);
    #endif
    #if CONF_URT3_INIT_EN == 1
        URT3_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT3_MODE == CONF_URT_MODE_SPI_MASTER || CONF_URT3_MODE == CONF_URT_MODE_SPI_SLAVE   
                mUSPI3.Instance      = SPI_URT3;    
                mUSPI3.SPI_IRQ       = URT123_IRQn;
                URT_SetSPIMiddlewareStatus(&mUSPI3);
            #elif CONF_URT3_MODE != CONF_URT_MODE_TM
                mURT3.gState   = MID_URT_STATE_BUSY;
                mURT3.Instance = URT3;
                mURT3.gState   = MID_URT_STATE_READY;
                mURT3.RxState  = MID_URT_STATE_READY;
            #endif
        #endif 
        URT_InitResult |= URT0123_Config( URT3, CONF_URT3);
    #endif
    /*URT4 ~ URT7 Init*/
    
    #if CONF_URT4_INIT_EN == 1
        URT4_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT4_MODE != CONF_URT_MODE_TM
                mURT4.Instance = URT4;
                mURT4.gState   = MID_URT_STATE_READY;
                mURT4.RxState  = MID_URT_STATE_READY;
            #endif
        #endif
        URT_InitResult |= URT4567_Config( URT4, CONF_URT4);
    #endif
    #if CONF_URT5_INIT_EN == 1
        URT5_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT5_MODE != CONF_URT_MODE_TM
                mURT5.Instance = URT5;
                mURT5.gState   = MID_URT_STATE_READY;
                mURT5.RxState  = MID_URT_STATE_READY;
            #endif
        #endif
        URT_InitResult |= URT4567_Config( URT5, CONF_URT5);
    #endif
    #if CONF_URT6_INIT_EN == 1
        URT6_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT6_MODE != CONF_URT_MODE_TM
                mURT6.Instance = URT6;
                mURT6.gState   = MID_URT_STATE_READY;
                mURT6.RxState  = MID_URT_STATE_READY;
            #endif
        #endif
        URT_InitResult |= URT4567_Config( URT6, CONF_URT6);
    #endif
    #if CONF_URT7_INIT_EN == 1
        URT7_InitCallback();    
        #if defined(IRQHandler_Middleware_Level_)
            #if CONF_URT7_MODE != CONF_URT_MODE_TM
                mURT7.Instance = URT7;
                mURT7.gState   = MID_URT_STATE_READY;
                mURT7.RxState  = MID_URT_STATE_READY;
            #endif
        #endif
        URT_InitResult |= URT4567_Config( URT7, CONF_URT7);
        
    #endif
    return(URT_InitResult);
}

/**
 *******************************************************************************
 * @brief     URT0 inital callback. 
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT0_INIT_EN == 1
__WEAK void URT0_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT1 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT1_INIT_EN == 1
__WEAK void URT1_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT2 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT2_INIT_EN == 1
__WEAK void URT2_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT3 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT3_INIT_EN == 1
__WEAK void URT3_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT4 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT4_INIT_EN == 1
__WEAK void URT4_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT5 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT5_INIT_EN == 1
__WEAK void URT5_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT6 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT6_INIT_EN == 1
__WEAK void URT6_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif
/**
 *******************************************************************************
 * @brief     URT7 inital callback.	   
 * @details                                                    
 * @return     
 * @exception   
 * @note        
 *******************************************************************************
 */
#if CONF_URT7_INIT_EN == 1
__WEAK void URT7_InitCallback(void)
{
    //=========================================================
    //Note : This function should not be modified, when the function
    //       is needed, the function can be implemented in the user file.
}
#endif



