/**
 *******************************************************************************
 *
 * @file        MG32_DAC_Init.c
 *
 * @brief       The DAC initial code C file 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2023/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_DAC.h"
#include "MG32_DAC_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
// (Middleware level)
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            DAC_HandleTypeDef        mDAC;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        DAC_HandleTypeDef        mDAC;
    #endif
    // ------------------------------------------------------------------------
#endif

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief  	    Initialized DAC module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void DAC_Init(void)
{
    #if CONF_DAC_MODE != 0
        /* DAC register initial */
        DAC->INT.W  = CONF_DAC_INT;
        DAC->DAT0.W = CONF_DAC_DAT0;
        #if (CONF_DAC_MODE != 0)
            DAC->CR0.W  = CONF_DAC_CR0 | DAC_CR0_DA0_EN_enable_w;
        #else
            DAC->CR0.W  = CONF_DAC_CR0;
        #endif
        
        // --------------------------------------------------------------------
        // Config mDAC structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mDAC.Instance                   = DAC;
            mDAC.Init.TriggerConverionSrc   = mDAC_TriggerConverionSrc_Select;
            mDAC.Init.TriggerConverionEdge  = mDAC_TriggerConverionEdge_Select;
            mDAC.Init.DataAlign             = mDAC_DataAlign_Select;
            #if defined(MG32_1ST)
                mDAC.Init.OutputLevel           = mDAC_OutputLevel_Select;
            #endif
            mDAC.Init.InterruptMode         = DAC_InterruptMode_Select;
            mDAC.State                      = MID_DAC_STATE_RESET;
    #endif
        
    
    #endif
}


