/**
 ******************************************************************************
 *
 * @file        MG32_ADC_Init.H
 *
 * @brief       This file is to configure ADC baudrate setting.
 *              Device : MG32F02A128/U128/A064/U064
 * @par         Project
 *              MG32 
 * @version     V1.02
 * @date        2023/03/31
 * @author      MG32CoGen 
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer 
 *      The Demo software is provided "AS IS"  without any warranty, either 
 *      expressed or implied, including, but not limited to, the implied warranties 
 *      of merchantability and fitness for a particular purpose.  The author will 
 *      not be liable for any special, incidental, consequential or indirect 
 *      damages due to loss of data or any other reason. 
 *      These statements agree with the world wide and local dictated laws about 
 *      authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_ADC_INIT_H
 
#define _MG32_ADC_INIT_H

#include "MG32_ADC_DRV.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_ADC_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>

//<e0.0> Module - Mode Active
    #define CONF_ADC0_MODE                                  0x00000000
//  <h> ADC base parameters
//      <o0.16..23> ADC sampling time select <0-255>
//              <i> 0T ~ 255T clocks.T= CK_ADC0_INT
            #define CONF_ADC0_CR0_SMP_SEL                   0x00000000
//      <o0.6..7> ADC data resolution select <0=> 12-bit <1=> 10-bit <2=> 8-bit
            #define CONF_ADC0_CR0_RES_SEL                   0x00000000
//      <o0.3> ADC data alignment select <0=> Right (Right alignment) <1=> Left (Left alignment)
            #define CONF_ADC0_CR1_ALIGN_SEL                 0x00000000
//      <o0.24..28> Digital Offset adjuster <0x10=> -16 <0x11=> -15 <0x12=> -14 <0x13=> -13 <0x14=> -12 <0x15=> -11
//                                          <0x16=> -10 <0x17=> -9 <0x18=> -8 <0x19=> -7 <0x1A=> -6 <0x1B=> -5
//                                          <0x1C=> -4 <0x1D=> -3 <0x1E=> -2 <0x1F=> -1 <0x00=> 0 <0x01=> +1
//                                          <0x02=> +2 <0x03=> +3 <0x04=> +4 <0x05=> +5 <0x06=> +6 <0x07=> +7
//                                          <0x08=> +8 <0x09=> +9 <0x0A=> +10 <0x0B=> +11 <0x0C=> +12 <0x0D=> +13 <0x0E=> +14 <0x0F=> +15
            #define CONF_ADC0_CR1_DOS_VAL                   0x00000000
//      <o0.2> Stop to convert the next channel (WAIT function)
//          <i> Wait conversion mode enable for low CPU frequency
//          <i> Release condition : 'Read ADC Data' or 'Clear flag'
            #define CONF_ADC0_CR0_WAIT_EN                   0x00000000
//      <o0.8> Overrun mode <0=> Overwritten (Overwritten by new data) <1=> Keep (Preserved old date)
            #define CONF_ADC0_CR1_OVR_MDS                   0x00000000
//      <o0.19..25> ADC conversion mode <0x00=> ADC One shot mode <0x01=> ADC Continue mode <0x20=> Scan mode <0x21=> Scan continue mode <0x40=> Loop mode
//          <i> ADC One Shot mode : Convert one ADC data from single channel after one start trigger, then stop conversion.
//          <i> ADC Continue mode : Convert one ADC data from single channel after one start trigger, then hardware automatically start next ADC conversion continuously and does not stop conversion.
//          <i> Scan mode : Convert one ADC data from one selected channel after one start trigger, then stop conversion. To follow and convert next ADC data from next selected channel after next start trigger. Run the same steps for all selected channels.
//          <i> Scan continue mode : Convert multiple ADC data continuously from multiple selected channels after one start trigger, then stop conversion when scan finished for all selected channels.
//          <i> Loop mode : When ADC conversion start by one start trigger, hardware does the channel scan ADC conversion one by one until finish the conversion for all selected channels. And hardware automatically start next channel scan ADC conversion continuously and does not stop.
            #define CONF_ADC0_START                         0x00000000
//      <o0.16..18> ADC start control source select <0x0=> SW : ADC0_START register setting <0x1=> TM00 : TM00_TRGO <0x2=> PIN : ADC0_TRG : ADC external trigger pin
//                                                  <0x3=> CMP0 : CMP0_OUT <0x4=> CMP1 : CMP1_OUT <0x5=> TM01 : TM01_TRGO <0x6=> TM26 : TM26_TRGO <7=> TM36 : TM36_TRGO
            #define CONF_ADC0_START_SEL                     0x00000000
//          <o0.20..21> ADC0 start trigger selection <0x0=> Disable <0x1=> Rising edge <0x2=> Falling edge <0x4=> Dual-edge
//              <i> When selects Disable, the edge trigger detection is disabled and no start trigger signal output. When ADC0_START_SEL = SW (ADC0_START register setting), this register is no effect.
                #define CONF_ADC0_START_TRG_SEL             0x00000000
//      <o0.8..12> Conversion one channel select
//          <0=> PA0
//          <1=> PA1
//          <2=> PA2
//          <3=> PA3
//          <4=> PA4
//          <5=> PA5
//          <6=> PA6
//          <7=> PA7
//          <8=> PA8
//          <9=> PA9
//          <10=> PA10
//          <11=> PA11
//          <12=> PA12
//          <13=> PA13
//          <14=> PA14
//          <15=> PA15
//          <16=> Internal VSSA
//          <18=> INT_DACP0
//          <19=> INT_VBG (VBUF)
//                  <24=>   INT_LDO (VR0)           
//                  <25=>   TSO Output          
//                  <26=>   1/2 Vdd Output          
//                  <27=>   VPG voltage         
//                  <28=>   V33 voltage (Apply USB type)        
            #define CONF_ADC0_START_CH_MUX                  0x00000000
//      <h> Scan/Loop channel select - sequence channel scan
//          <q0.0> PA0
                #define CONF_ADC0_MSK_B0                    0x00000000
//          <q0.1> PA1
                #define CONF_ADC0_MSK_B1                    0x00000000
//          <q0.2> PA2      
                #define CONF_ADC0_MSK_B2                    0x00000000
//          <q0.3> PA3          
                #define CONF_ADC0_MSK_B3                    0x00000000
//          <q0.4> PA4      
                #define CONF_ADC0_MSK_B4                    0x00000000
//          <q0.5> PA5      
                #define CONF_ADC0_MSK_B5                    0x00000000
//          <q0.6> PA6          
                #define CONF_ADC0_MSK_B6                    0x00000000
//          <q0.7> PA7          
                #define CONF_ADC0_MSK_B7                    0x00000000
//          <q0.8> PA8          
                #define CONF_ADC0_MSK_B8                    0x00000000
//          <q0.9> PA9          
                #define CONF_ADC0_MSK_B9                    0x00000000
//          <q0.10> PA10            
                #define CONF_ADC0_MSK_B10                   0x00000000
//          <q0.11> PA11            
                #define CONF_ADC0_MSK_B11                   0x00000000
//          <q0.12> PA12        
                #define CONF_ADC0_MSK_B12                   0x00000000
//          <q0.13> PA13        
                #define CONF_ADC0_MSK_B13                   0x00000000
//          <q0.14> PA14        
                #define CONF_ADC0_MSK_B14                   0x00000000
//          <q0.15> PA15        
                #define CONF_ADC0_MSK_B15                   0x00000000
//      </h>
//    </h>
//    <h> Clock configuration
//      <o0.8..9> CK_ADC_INT source select <0=> CK_ADC_PR + Divider <1=> CK_PLL + Divider <3=> TM00_TRGO/2 <3=> TM01_TRGO/2
            #define CONF_ADC0_CLK_CK_SEL2                   0x00000000
//          <i> CK_ADC_PR from CSC (AHB or APB).
//          <i> CK_PLL  (CSC must enable PLL).
//          <i> TM00_TRGO : TM00 periodic output overflow event (User must enable TM00).
//          <i> TM01_TRGO : TM01 periodic output overflow event (User must enable TM01).
//      <o0.4..5> CK_ADC_PR input divider <0=> DIV1 <1=> DIV2 <3=> DIV4 <3=> DIV16
            #define CONF_ADC0_CLK_CK_DIV                    0x00000000
//      <o0.10..11> CK_PLL input divider <0=> DIV2 <1=> DIV4 <3=> DIV5 <3=> DIV6
            #define CONF_ADC0_CLK_CK_DIV2                   0x00000000
//    </h>
//    <h> Window detect threshold
//      <o0.0> Window detect threshold enable
            #define CONF_ADC0_CR1_WIND_EN                   0x00000000
//      <o0.14..15> Spike limit function <0=> No operation <1=> Skip <2=> Clamp
            #define CONF_ADC0_CR0_LIM_MDS                   0x00000000
//      <o0.1> Scope of application <0=> Single <1=> All
            #define CONF_ADC0_CR1_WIND_MDS                  0x00000000
//      <o0.4..5> ADC_OUT output signal select <0=> WDL (window detect state for outside low) <1=> WDI (window detect state for inside) <2=> WDH (window detect state for outside high)
            #define CONF_ADC0_CR1_OUT_SEL                       0x00000000
//      <o0.0..11> ADC Voltage window detect lower threshold <0-4095>
//          <i> window detect lower threshold : 0~4095@12bit
            #define CONF_ADC0_WINDTH_WIND_LT                0x00000000
//      <o0.0..11> ADC Voltage window detect higher threshold <0-4095>
//          <i> window detect higher threshold : 0~4095@12bit
            #define CONF_ADC0_WINDTH_WIND_HT                0x00000000
//    </h>
//    <h> Data accumulation
//      <o0.16..22> ADC accumulation data number <0-64>
//          <i> Value 0 indicates to disable accumulation and the maximum value 0x40 indicates 64 data to accumulate.
            #define CONF_ADC0_CR1_SUM_NUM                   0x00000000
//      <o0.10> Accumulation mode <0=> Single (Single channel) <1=> All (All selected scan channels)
//          <i> When selects Single mode for ADC one shot conversion mode, the ADC0_SUM0_MUX selection channel data is accumulated into ADC0_SUM0. When selects All mode, the all selection channel data are accumulated one-by-one into ADC0_SUM0 only.
//          <i> When selects Single mode for ADC channel scan conversion mode, the ADC0_SUM1_MUX/ADC0_SUM2_MUX selection channel data are also separately accumulated into ADC0_SUM1/ADC0_SUM2.   
            #define CONF_ADC0_CR1_SUM_MDS                   0x00000000
//      <o0.9> Accumulation overrun mode select <0=> Overwritten (Overwritten by new data) <1=> Keep (Preserved old date)
            #define CONF_ADC0_CR1_SOVR_MDS                  0x00000000
//      <o0.16..19> Sum0 channel select <0=> PA0 <1=> PA1 <2=> PA2 <3=> PA3 <4=> PA4 <5=> PA5 <6=> PA6 <7=> PA7 <8=> PA8
//                                      <9=> PA9 <10=> PA10 <11=> PA11 <12=> PA12 <13=> PA13 <14=> PA14 <15=> PA15
            #define CONF_ADC0_MSK_SUM0_MUX                  0x00000000
//      <o0.0..15> Sum0 initial data <0-65535>
            #define CONF_ADC0_SUM0_SUM0_DAT                 0x00000000
//      <o0.20..23> Sum1 channel select <0=> PA0 <1=> PA1 <2=> PA2 <3=> PA3 <4=> PA4 <5=> PA5 <6=> PA6 <7=> PA7 <8=> PA8
//                                      <9=> PA9 <10=> PA10 <11=> PA11 <12=> PA12 <13=> PA13 <14=> PA14 <15=> PA15
            #define CONF_ADC0_MSK_SUM1_MUX                  0x00000000
//      <o0.0..15> Sum1 initial data <0-65535>
            #define CONF_ADC0_SUM1_SUM1_DAT                 0x00000000
//      <o0.24..27> Sum2 channel select <0=> PA0 <1=> PA1 <2=> PA2 <3=> PA3 <4=> PA4 <5=> PA5 <6=> PA6 <7=> PA7 <8=> PA8
//                                      <9=> PA9 <10=> PA10 <11=> PA11 <12=> PA12 <13=> PA13 <14=> PA14 <15=> PA15
            #define CONF_ADC0_MSK_SUM2_MUX                  0x00000000
//      <o0.0..15> Sum2 initial data <0-65535>
            #define CONF_ADC0_SUM2_SUM2_DAT                 0x00000000
//    </h>
//      <h> PGA Configuration
//          <o0.1> PGA Enable
            #define CONF_ADC0_ANA_PGA_EN                    0x00000000
//      <o0.24..25> Gain range is x1 ~ x4
//                  <0=>    1.000           
//                  <1=>    1.012           
//                  <2=>    1.024           
//                  <3=>    1.037           
//                  <4=>    1.050           
//                  <5=>    1.063           
//                  <6=>    1.077           
//                  <7=>    1.091           
//                  <8=>    1.105           
//                  <9=>    1.120           
//                  <10=>   1.135           
//                  <11=>   1.151           
//                  <12=>   1.167           
//                  <13=>   1.183           
//                  <14=>   1.200           
//                  <15=>   1.217           
//                  <16=>   1.235           
//                  <17=>   1.254           
//                  <18=>   1.273           
//                  <19=>   1.292           
//                  <20=>   1.313           
//                  <21=>   1.333           
//                  <22=>   1.355           
//                  <23=>   1.377           
//                  <24=>   1.400           
//                  <25=>   1.424           
//                  <26=>   1.448           
//                  <27=>   1.474           
//                  <28=>   1.500           
//                  <29=>   1.527           
//                  <30=>   1.556           
//                  <31=>   1.585           
//                  <32=>   1.615           
//                  <33=>   1.647           
//                  <34=>   1.680           
//                  <35=>   1.714           
//                  <36=>   1.750           
//                  <37=>   1.787           
//                  <38=>   1.826           
//                  <39=>   1.867           
//                  <40=>   1.909           
//                  <41=>   1.953           
//                  <42=>   2.000           
//                  <43=>   2.049           
//                  <44=>   2.100           
//                  <45=>   2.154           
//                  <46=>   2.211           
//                  <47=>   2.270           
//                  <48=>   2.333           
//                  <49=>   2.400           
//                  <50=>   2.471           
//                  <51=>   2.545           
//                  <52=>   2.625           
//                  <53=>   2.710           
//                  <54=>   2.800           
//                  <55=>   2.897           
//                  <56=>   3.000           
//                  <57=>   3.111           
//                  <58=>   3.231           
//                  <59=>   3.360           
//                  <60=>   3.500           
//                  <61=>   3.652           
//                  <62=>   3.818           
//                  <63=>   4.000           
//          <i> Gain = {1+(ADC0_GAIN_PGA*3)/[63+(63-ADC0_GAIN_PGA)*3]}
            #define CONF_ADC0_GAIN_PGA                      0x00000000
//      </h> 
//      <h> Auto-off function
//          <o0.1> Auto-off function Enable
//          <i> The ADC needs time to wake up. So please refer to the power-on configuration of CLK. 
            #define CONF_ADC0_CR0_AUTOFF_EN                 0x00000000
//      <o0.24..25> ADC power-on start up counter clock divider.<0=> DIV1 <1=> DIV4 <2=> DIV16 <3=> DIV32
//          <i> This divider is used to divide the input APB clock to output as the start up counter clock.
            #define CONF_ADC0_CLK_CK_SDIV                   0x00000000
//      <o0.0..3> ADC power-on start up counter. <0-15>
//          <i> This register is only valid when auto power-off mode is enabled (ADC0_AUTOFF_EN=1).
//          <i> The range 0~15 is indicated counter inital value 0~15. 
            #define CONF_ADC0_CLK_SCNT                      0x00000000
//      </h> 
//  </e>

//<e0.0> ADC interrupt all enable (IEA)
            #define CONF_ADC0_INT_IEA                       0x00000000
//      <q0.2> ADC sampling end interrupt (ESMP_IE)
            #define CONF_ADC0_INT_ESMP                      0x00000000
//      <q0.3> ADC one-time conversion end interrupt (E1CNV_IE)
            #define CONF_ADC0_INT_E1CNV                     0x00000000
//      <q0.5> ADC channel scan conversion end interrupt (ESCNV_IE)
            #define CONF_ADC0_INT_ESCNV                     0x00000000
//      <q0.7> ADC conversion overrun event interrupt (OVR_IE)
            #define CONF_ADC0_INT_OVR                       0x00000000
//      <q0.8> ADC voltage window detect outside low event interrupt  (WDL_IE)
            #define CONF_ADC0_INT_WDL                       0x00000000
//      <q0.9> ADC voltage window detect inside low event interrupt  (WDI_IE)
            #define CONF_ADC0_INT_WDI                       0x00000000
//      <q0.10> ADC voltage window detect outside high event interrupt (WDH_IE)
            #define CONF_ADC0_INT_WDH                       0x00000000
//      <q0.13> ADC data sum-0,1,2  accumulation overflow or underflow interrupt (SUMO_IE)
            #define CONF_ADC0_INT_SUMO                      0x00000000
//      <q0.14> ADC data sum-0,1,2  accumulation complete interrupt (SUMC_IE)
            #define CONF_ADC0_INT_SUMC                      0x00000000
//      <q0.15> ADC data sum-0,1,2  overrun event interrupt (SUMOVR_IE)
            #define CONF_ADC0_INT_SUMOVR                    0x00000000
//</e>
// <<< end of Configuration section >>>

    // ----------------------------------------------
    // Combined with ADC_INT register bit function
    #define CONF_ADC_INT    (CONF_ADC0_INT_IEA      |\
                             CONF_ADC0_INT_ESMP     |\
                             CONF_ADC0_INT_E1CNV    |\
                             CONF_ADC0_INT_ESCNV    |\
                             CONF_ADC0_INT_OVR      |\
                             CONF_ADC0_INT_WDL      |\
                             CONF_ADC0_INT_WDI      |\
                             CONF_ADC0_INT_WDH      |\
                             CONF_ADC0_INT_SUMO     |\
                             CONF_ADC0_INT_SUMC     |\
                             CONF_ADC0_INT_SUMOVR   )
            
    // ----------------------------------------------
    // Combined with ADC_CLK register bit function
    #if defined(CONF_ADC0_CLK_SCNT)
    #define CONF_ADC_CLK    (CONF_ADC0_CLK_CK_SEL2  |\
                             CONF_ADC0_CLK_CK_DIV   |\
                             0x00002000             |\
                             CONF_ADC0_CLK_CK_DIV2  |\
                             CONF_ADC0_CLK_CK_SDIV  |\
                             CONF_ADC0_CLK_SCNT     )
    #else                                                
    #define CONF_ADC_CLK    (CONF_ADC0_CLK_CK_SEL2  |\
                             CONF_ADC0_CLK_CK_DIV   |\
                             CONF_ADC0_CLK_CK_DIV2  )
    #endif

    // ----------------------------------------------
    // Combined with ADC_WINDTH register bit function
    #define CONF_ADC_WINDTH ((CONF_ADC0_WINDTH_WIND_HT << 16)   |\
                             (CONF_ADC0_WINDTH_WIND_LT)         )

    // ----------------------------------------------
    // ADC_WINDTH check rule
    #if CONF_ADC0_WINDTH_WIND_LT > CONF_ADC0_WINDTH_WIND_HT
        #error "Error: window detect lower threshold > window detect higher threshold"
    #endif 
                                                     
    // ----------------------------------------------
    // Combined with ADC_CR0 register bit function
    #if defined(CONF_ADC0_CR0_MDS)
    #define CONF_ADC_CR0    (CONF_ADC0_CR0_SMP_SEL  |\
                             CONF_ADC0_CR0_RES_SEL  |\
                             CONF_ADC0_CR0_LIM_MDS  |\
                             CONF_ADC0_CR0_WAIT_EN  |\
                             CONF_ADC0_CR0_MDS      )   
    #elif defined(CONF_ADC0_CR0_AUTOFF_EN)
    #define CONF_ADC_CR0    (CONF_ADC0_CR0_SMP_SEL  |\
                             CONF_ADC0_CR0_RES_SEL  |\
                             CONF_ADC0_CR0_LIM_MDS  |\
                             CONF_ADC0_CR0_WAIT_EN  |\
                             CONF_ADC0_CR0_AUTOFF_EN)   
    #else                                                
    #define CONF_ADC_CR0    (CONF_ADC0_CR0_SMP_SEL  |\
                             CONF_ADC0_CR0_RES_SEL  |\
                             CONF_ADC0_CR0_WAIT_EN  |\
                             CONF_ADC0_CR0_LIM_MDS  )   
    #endif                                               
                                                     
    // ----------------------------------------------
    // Combined with ADC_CR1 register bit function
    #define CONF_ADC_CR1    (CONF_ADC0_CR1_WIND_EN  |\
                             CONF_ADC0_CR1_WIND_MDS |\
                             CONF_ADC0_CR1_OUT_SEL  |\
                             CONF_ADC0_CR1_ALIGN_SEL|\
                             CONF_ADC0_CR1_DOS_VAL  |\
                             CONF_ADC0_CR1_OVR_MDS  |\
                             CONF_ADC0_CR1_SUM_NUM  |\
                             CONF_ADC0_CR1_SUM_MDS  |\
                             CONF_ADC0_CR1_SOVR_MDS )

    // ----------------------------------------------
    // Combined with ADC_MSK register bit function
    #if defined(MG32_1ST) || defined(MG32_3RD)
    #define CONF_ADC_MSK    (CONF_ADC0_MSK_SUM0_MUX |\
                             CONF_ADC0_MSK_SUM1_MUX |\
                             CONF_ADC0_MSK_SUM2_MUX |\
                             CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B4       |\
                             CONF_ADC0_MSK_B5       |\
                             CONF_ADC0_MSK_B6       |\
                             CONF_ADC0_MSK_B7       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      |\
                             CONF_ADC0_MSK_B12      |\
                             CONF_ADC0_MSK_B13      |\
                             CONF_ADC0_MSK_B14      |\
                             CONF_ADC0_MSK_B15      )
    #define CONF_ADC_MSKx   (CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B4       |\
                             CONF_ADC0_MSK_B5       |\
                             CONF_ADC0_MSK_B6       |\
                             CONF_ADC0_MSK_B7       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      |\
                             CONF_ADC0_MSK_B12      |\
                             CONF_ADC0_MSK_B13      |\
                             CONF_ADC0_MSK_B14      |\
                             CONF_ADC0_MSK_B15      )
    #elif defined(MG32_2ND)
    #define CONF_ADC_MSK    (CONF_ADC0_MSK_SUM0_MUX |\
                             CONF_ADC0_MSK_SUM1_MUX |\
                             CONF_ADC0_MSK_SUM2_MUX |\
                             CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      |\
                             CONF_ADC0_MSK_B12      |\
                             CONF_ADC0_MSK_B13      |\
                             CONF_ADC0_MSK_B14      |\
                             CONF_ADC0_MSK_B15      )
    #define CONF_ADC_MSKx   (CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      |\
                             CONF_ADC0_MSK_B12      |\
                             CONF_ADC0_MSK_B13      |\
                             CONF_ADC0_MSK_B14      |\
                             CONF_ADC0_MSK_B15      )
    #elif defined(MG32_4TH)
    #define CONF_ADC_MSK    (CONF_ADC0_MSK_SUM0_MUX |\
                             CONF_ADC0_MSK_SUM1_MUX |\
                             CONF_ADC0_MSK_SUM2_MUX |\
                             CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      )
    #define CONF_ADC_MSKx   (CONF_ADC0_MSK_B0       |\
                             CONF_ADC0_MSK_B1       |\
                             CONF_ADC0_MSK_B2       |\
                             CONF_ADC0_MSK_B3       |\
                             CONF_ADC0_MSK_B8       |\
                             CONF_ADC0_MSK_B9       |\
                             CONF_ADC0_MSK_B10      |\
                             CONF_ADC0_MSK_B11      )
    #endif                                               

    // ----------------------------------------------
    // ADC_MSK check rule
    #if CONF_ADC0_START>=0x01000000
        #if CONF_ADC_MSKx==0
            #error "Error: ADC0 needs to enable sequence channel"
        #endif
    #endif

    // ----------------------------------------------
    // Combined with ADC_START register bit function
    #define CONF_ADC_START  (CONF_ADC0_START        |\
                             CONF_ADC0_START_SEL    |\
                             CONF_ADC0_START_TRG_SEL|\
                             CONF_ADC0_START_CH_MUX )

    // ----------------------------------------------
    // Combined with ADC_ANA register bit function
    #if defined(CONF_ADC0_ANA_PGA_EN)
        #if defined(MG32_1ST)
        #define CONF_ADC_ANA    (CONF_ADC0_ANA_PGA_EN   |\
                                 0x00000000             )
        #else
        #define CONF_ADC_ANA    (CONF_ADC0_ANA_PGA_EN   |\
                                 0x00000300             )
        #endif
    #else
    #define CONF_ADC_ANA    (0x00000300)
    #endif  

    // ----------------------------------------------
    // Combined with ADC_GAIN register bit function
    #define CONF_ADC_GAIN   (CONF_ADC0_GAIN_PGA)

    // ----------------------------------------------
    // Combined with ADC_SUM0 register bit function
    #define CONF_ADC_SUM0   (0x00F00000             |\
                             CONF_ADC0_SUM0_SUM0_DAT)
                                                     
    // ----------------------------------------------
    // Combined with ADC_SUM1 register bit function
    #define CONF_ADC_SUM1   (0x00F00000             |\
                             CONF_ADC0_SUM1_SUM1_DAT)
                                                     
    // ----------------------------------------------
    // Combined with ADC_SUM2 register bit function
    #define CONF_ADC_SUM2   (0x00F00000             |\
                             CONF_ADC0_SUM2_SUM2_DAT)

        
        
    // ------------------------------------------------------------------------
    // Assemble mADC structure within Middleware level
    // ------------------------------------------------------------------------

    // ------------------------------------------------------------------------
    // Single-End or Different mode selection
    #if defined(CONF_ADC0_CR0_MDS)
        #define mADC_Conversion_Type            CONF_ADC0_CR0_MDS
    #else
        #define mADC_Conversion_Type            ADC_CONV_SINGLE
    #endif
        
    // ------------------------------------------------------------------------
    // Clock + Divider selection
    #if CONF_ADC0_CLK_CK_SEL2 == (0 << 8)  

        // Clock divider selection
        #if CONF_ADC0_CLK_CK_DIV == (0 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPROC_DIV1
        #elif CONF_ADC0_CLK_CK_DIV == (1 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPROC_DIV2
        #elif CONF_ADC0_CLK_CK_DIV == (2 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPROC_DIV4
        #elif CONF_ADC0_CLK_CK_DIV == (3 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPROC_DIV16
        #endif    
    #elif CONF_ADC0_CLK_CK_SEL2 == (1 << 8)  

        // Clock divider selection
        #if CONF_ADC0_CLK_CK_DIV2 == (0 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPLL_DIV2
        #elif CONF_ADC0_CLK_CK_DIV2 == (1 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPLL_DIV4
        #elif CONF_ADC0_CLK_CK_DIV2 == (2 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPLL_DIV5
        #elif CONF_ADC0_CLK_CK_DIV2 == (3 << 4)
            #define mADC_Clock_Select           ADC_CLOCKPLL_DIV6
        #endif    

    #elif CONF_ADC0_CLK_CK_SEL2 == (2 << 8)  
        // select TM00_TRGO / 2
        #define mADC_Clock_Select               ADC_TM00UPDATE_DIV2
    #elif CONF_ADC0_CLK_CK_SEL2 == (3 << 8)
        // select TM01_TRGO / 2
        #define mADC_Clock_Select               ADC_TM00UPDATE_DIV2
    #endif

    // ------------------------------------------------------------------------
    // ADC conversion resolution selection
    #define mADC_Resolution_Select              CONF_ADC0_CR0_RES_SEL

    // ------------------------------------------------------------------------
    // Right / Left justified
    #define mADC_Justified_Select               CONF_ADC0_CR1_ALIGN_SEL

    // ------------------------------------------------------------------------
    // ADC Conversion Mode select
    #define mADC_Conversion_Mode                CONF_ADC0_START

    // ------------------------------------------------------------------------
    // ADC Wait_EN Function select
    #define mADC_WaitFunction_Select            CONF_ADC0_CR0_WAIT_EN

    // ------------------------------------------------------------------------
    // Auto Power with  select  
    #if defined(CONF_ADC0_CR0_AUTOFF_EN)
        #define mADC_AutoPowerOff_Select        CONF_ADC0_CR0_AUTOFF_EN
    #else
        #define mADC_AutoPowerOff_Select        0
    #endif

    // ------------------------------------------------------------------------
    // Clock divider select for wake up state   
    #if defined(CONF_ADC0_CLK_CK_SDIV)
        #define mADC_SDIV_Select                CONF_ADC0_CLK_CK_SDIV
        #define mADC_SCNT_Select                CONF_ADC0_CLK_SCNT >> 28        // Clock counter for wake up state  
    #else
        #define mADC_SDIV_Select                0
        #define mADC_SCNT_Select                0        
    #endif

    // ------------------------------------------------------------------------
    // ADC Trigger Converion Source Select 
    #define mADC_TriggerConversion_Select       CONF_ADC0_START_SEL

    // ------------------------------------------------------------------------
    // ADC Trigger Edge Select 
    #define mADC_TriggerEdge_Select             CONF_ADC0_START_TRG_SEL

    // ------------------------------------------------------------------------
    // ADC Over Written Function Select 
    #define mADC_OverWritten_Select             CONF_ADC0_CR1_OVR_MDS

    // ------------------------------------------------------------------------
    // ADC Extend Sampling Time
    #define mADC_ExtendSampleTime_Select        (CONF_ADC0_CR0_SMP_SEL >> 16)

    // ------------------------------------------------------------------------
    // ADC PGA Command + ADC PGA Gain Select
    #if defined(CONF_ADC0_ANA_PGA_EN)
        #define mADC_PGACmd_Select              CONF_ADC0_ANA_PGA_EN
        #define mADC_PGAGain_Select             CONF_ADC0_GAIN_PGA
    #else
        #define mADC_PGACmd_Select              0
        #define mADC_PGAGain_Select             0
    #endif


/**
 * @name    Function announce
 *          
 */
///@{ 
void ADC_Init(void);

///@}
#endif  // _MG32_ADC_INIT_H

