/**
 ******************************************************************************
 *
 * @file        MG32_I2C_Init.h
 *
 * @brief       This file is to configure I2C SCL Clock setting.
 *              Device : MG32F02U128 / U064 / A128 / A064
 *
 * @par         Project
 *              MG32
 * @version     V1.0
 * @date        2022/09/22 (Include File Generated Date)
 *              MG32CoGen: 2.0.0.18 , 2023/5/15 上午 11:17 
 * @copyright   Copyright (c) 2022 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */

#ifndef _MG32_I2C_INIT_H
#define _MG32_I2C_INIT_H

#define MG32_I2C_INIT_VER            63    // I2C Initial .h Version

#ifdef __cplusplus
 extern "C" {
#endif

#include "MG32.h"
#if defined(ModuleExist_I2C0) || defined(ModuleExist_I2C1)

#include "MG32_I2C.h"
#include "RTE_Components.h"
#if defined(IRQHandler_Middleware_Level_)
#include "MG32_I2C_MID.h"
#endif

//*** <<< Use Configuration Wizard in Context Menu >>> ***
// <h>I2C0
//   <o> Mode <0=>Disable <1=>Enable
#define CONF_I2C0_Mode               0
#define CONF_I2C0_CLKSOURCE          0
//   <o>Pre Driver Time(CK_I2Cx) <0=>Disable <1=>1t <2=>2t <3=>3t
#define CONF_I2C0_PDT                0
//   <h>Master Features
//     <o>Clock Speed 1-1000(KHz) <1-1000>
#define CONF_I2C0_SCL_CLK            1000
//     <o>Prescaler <1-16>
#define CONF_I2C0_PRESCALER          1
//     <o>Divider <0=>CK_I2C0_PR / 1 <1=>CK_I2C0_PR / 2 <2=>CK_I2C0_PR / 4
//                 <3=>CK_I2C0_PR / 8 <4=>CK_I2C0_PR / 16 <5=>CK_I2C0_PR / 32
//                 <6=>CK_I2C0_PR / 64 <7=>CK_I2C0_PR / 128
#define CONF_I2C0_DIVIDER            1
//     <o>SCL High cycle time<6-64>
#define CONF_I2C0_HIGHTIME           25
//     <o>SCL Low cycle time<5-64>
#define CONF_I2C0_LOWTIME            24
//   </h>
//   <h>Slave Features
//     <o>General Call Address Detection <0=>Disable <1=>Enable
#define CONF_I2C0_GCEN               0
//     <o>Own 1 Slave Address(0x00-0x7F) <0x00-0x7F>
//       <i>Slave Address bit[6:0]
#define CONF_I2C0_OWN1_ADDR          0
//     <o>Own 1 Slave Address Mask <0x7F=> No Mask 
//                                    <0x7E=> OA1[0] Masked.
//                                    <0x7C=> OA1[1:0] Masked.
//                                    <0x78=> OA1[2:0] Masked.
//                                    <0x70=> OA1[3:0] Masked.
//                                    <0x60=> OA1[4:0] Masked.
//                                    <0x40=> OA1[5:0] Masked.
//                                    <0x00=> OA1[6:0] Masked.
//       <i> bit[6:0] Address Mask bit
#define CONF_I2C0_OWN1_ADDR_MASK     0x7F
//     <e>Dual Address Acknowledged
#define CONF_I2C0_DUAL_ADDR_ACK      0
//       <o>Own 2 Slave Address(0x00-0x7F) <0x00-0x7F>
#define CONF_I2C0_OWN2_ADDR          0
//     </e>
//   </h>
//   <h> Interrupt
//     <e>IEA : I2C global all interrupt
#define CONF_I2C0_IEA                0
//       <q>ENENT_IE : I2C status event interrupt enable.
#define CONF_I2C0_EVENT_IE           0
//       <q>TMOUT_IE : I2C timeout error interrupt enable.
#define CONF_I2C0_TMOUT_IE           0
//       <q>STPSTR_IE : I2C Stop or Start detection interrupt enable.
#define CONF_I2C0_STPSTR_IE          0
//       <q>WUP_IE : I2C wakeup from STOP mode interrupt enable on slave address matched.
#define CONF_I2C0_WUP_IE             0
//     </e>
//   </h>
#define CONF_I2C0_TIMING             0x18170000
#define CONF_I2C0_COMP_SCL_CLK       1000
#define CONF_I2C0_TIMINGx            ((CONF_I2C0_HIGHTIME - 1) << 24) || \
                                     ((CONF_I2C0_LOWTIME - 1) << 16) || \
                                     ((CONF_I2C0_PRESCALER - 1) << 8) || \
                                     ((CONF_I2C0_DIVIDER - 1) << 4) || \
                                     (CONF_I2C0_CLKSOURCE << 2);
// </h>
// <h>I2C1
//   <o> Mode <0=>Disable <1=>Enable
#define CONF_I2C1_Mode               0
#define CONF_I2C1_CLKSOURCE          0
//   <o>Pre Driver Time(CK_I2Cx) <0=>Disable <1=>1t <2=>2t <3=>3t
#define CONF_I2C1_PDT                0
//   <h>Master Features
//     <o>Clock Speed 1-1000(KHz) <1-1000>
#define CONF_I2C1_SCL_CLK            400
//     <o>Prescaler <1-16>
#define CONF_I2C1_PRESCALER          2
//     <o>Divider <0=>CK_I2C1_PR / 1 <1=>CK_I2C1_PR / 2 <2=>CK_I2C1_PR / 4
//                 <3=>CK_I2C1_PR / 8 <4=>CK_I2C1_PR / 16 <5=>CK_I2C1_PR / 32
//                 <6=>CK_I2C1_PR / 64 <7=>CK_I2C1_PR / 128
#define CONF_I2C1_DIVIDER            1
//     <o>SCL High cycle time<6-64>
#define CONF_I2C1_HIGHTIME           31
//     <o>SCL Low cycle time<5-64>
#define CONF_I2C1_LOWTIME            30
//   </h>
//   <h>Slave Features
//     <o>General Call Address Detection <0=>Disable <1=>Enable
#define CONF_I2C1_GCEN               0
//     <o>Own 1 Slave Address(0x00-0x7F) <0x00-0x7F>
//       <i>Slave Address bit[6:0]
#define CONF_I2C1_OWN1_ADDR          0
//     <o>Own 1 Slave Address Mask <0x7F=> No Mask 
//                                    <0x7E=> OA1[0] Masked.
//                                    <0x7C=> OA1[1:0] Masked.
//                                    <0x78=> OA1[2:0] Masked.
//                                    <0x70=> OA1[3:0] Masked.
//                                    <0x60=> OA1[4:0] Masked.
//                                    <0x40=> OA1[5:0] Masked.
//                                    <0x00=> OA1[6:0] Masked.
//       <i> bit[6:0] Address Mask bit
#define CONF_I2C1_OWN1_ADDR_MASK     0x7F
//     <e>Dual Address Acknowledged
#define CONF_I2C1_DUAL_ADDR_ACK      0
//       <o>Own 2 Slave Address(0x00-0x7F) <0x00-0x7F>
#define CONF_I2C1_OWN2_ADDR          0
//     </e>
//   </h>
//   <h> Interrupt
//     <e>IEA : I2C global all interrupt
#define CONF_I2C1_IEA                0
//       <q>ENENT_IE : I2C status event interrupt enable.
#define CONF_I2C1_EVENT_IE           0
//       <q>TMOUT_IE : I2C timeout error interrupt enable.
#define CONF_I2C1_TMOUT_IE           0
//       <q>STPSTR_IE : I2C Stop or Start detection interrupt enable.
#define CONF_I2C1_STPSTR_IE          0
//       <q>WUP_IE : I2C wakeup from STOP mode interrupt enable on slave address matched.
#define CONF_I2C1_WUP_IE             0
//     </e>
//   </h>
#define CONF_I2C1_TIMING             0x1E1D0100
#define CONF_I2C1_COMP_SCL_CLK       400
#define CONF_I2C1_TIMINGx            ((CONF_I2C1_HIGHTIME - 1) << 24) || \
                                     ((CONF_I2C1_LOWTIME - 1) << 16) || \
                                     ((CONF_I2C1_PRESCALER - 1) << 8) || \
                                     ((CONF_I2C1_DIVIDER - 1) << 4) || \
                                     (CONF_I2C1_CLKSOURCE << 2);
// </h>
//*** <<< end of configuration section >>> ***

#if defined(IRQHandler_Middleware_Level_) && defined(ModuleExist_I2C0)
    extern I2C_HandleTypeDef        mI2C0;
#endif

#if defined(IRQHandler_Middleware_Level_) && defined(ModuleExist_I2C1)
    extern I2C_HandleTypeDef        mI2C1;
#endif

void I2C_Init(void);

#ifdef __cplusplus
}
#endif

#endif

#endif  // _MG32_I2C_INIT_H

