

/**
 ******************************************************************************
 *
 * @file        BSP_5_LEDX8.c
 * @brief       
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/05/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/*==============================================================================
                                 User Notes
How To use this function:
-----------------------
   1. Use BSP_LEDX8_Init() function to inital.
   2. By calling "BSP_LEDX8_RefreshStatus" function to control LEDs "ON" or "OFF".
 
Driver architecture:
--------------------
   + MG32_GPIO_DRV

Known Limitations:
------------------
   1. The LED's PIN is conflict for BSP_4X4_Key's pin and BSP_7Segment's pin.

Require parameter
------------------
    Require module : CSC / GPIO 
    
    GPIO pin configuration : 
        Pin / IO mode / AFS
        ---  --------  -----
        PC0 / PPO     / GPIO
        PC1 / PPO     / GPIO
        PC2 / PPO     / GPIO
        PC3 / PPO     / GPIO
        PC7 / PPO     / GPIO
        PC12/ PPO     / GPIO
        PC13/ PPO     / GPIO
        PC14/ PPO     / GPIO
        PB0 / PPO     / GPIO
        PB1 / PPO     / GPIO
        PB2 / PPO     / GPIO
        PB3 / PPO     / GPIO
        PB4 / PPO     / GPIO
        PB5 / PPO     / GPIO
        PB6 / PPO     / GPIO
        PB7 / PPO     / GPIO
        
Example codes:
------------------

==============================================================================*/

/* Includes ------------------------------------------------------------------*/
#include "BSP_6_LEDX8.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//GPIO
#define LED_H0_PIN        PX_Pin_0
#define LED_H1_PIN        PX_Pin_1
#define LED_H2_PIN        PX_Pin_2
#define LED_H3_PIN        PX_Pin_3
#define LED_H4_PIN        PX_Pin_7
#define LED_H5_PIN        PX_Pin_12
#define LED_H6_PIN        PX_Pin_13
#define LED_H7_PIN        PX_Pin_14
#define LED_H_IOM         IOMC
#define LED_H_PORT        GPIOC
#define LED_H_PINMASK     0x708F

#define LED_L0_PIN        PX_Pin_0            
#define LED_L1_PIN        PX_Pin_1
#define LED_L2_PIN        PX_Pin_2
#define LED_L3_PIN        PX_Pin_3
#define LED_L4_PIN        PX_Pin_4
#define LED_L5_PIN        PX_Pin_5
#define LED_L6_PIN        PX_Pin_6
#define LED_L7_PIN        PX_Pin_7
#define LED_L_IOM         IOMB
#define LED_L_PORT        GPIOB
#define LED_L_PINMASK     0x00FF

//LED control
#define LED_H_TOTAL       8
#define LED_L_TOTAL       8

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static const uint16_t LED_H_PinTable[LED_H_TOTAL] = {
                                                        LED_H0_PIN,LED_H1_PIN,LED_H2_PIN,LED_H3_PIN,
                                                        LED_H4_PIN,LED_H5_PIN,LED_H6_PIN,LED_H7_PIN,
                                                    };

static const uint16_t LED_L_PinTable[LED_L_TOTAL] = {
                                                        LED_L0_PIN,LED_L1_PIN,LED_L2_PIN,LED_L3_PIN,
                                                        LED_L4_PIN,LED_L5_PIN,LED_L6_PIN,LED_L7_PIN,
                                                    };
                                                    
                                                                                        
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	  Refresh LED status.  
 * @details                      
 * @param[in] AnodeLED_ON : Control LEDs ON .
 *   \n           1. The LEDs light up by that LEDs anode connect towards VDD.
 *   \n           2. Bit0 control LED0 ~ Bit7 control LED7.
 *   \n           3. 0 is "OFF" , 1 is "ON"                                                      
 * @param[in] CathodeLED_ON : Control LEDs ON . 
 *   \n           1. The LEDs light up by that LEDs cathode connect towards ground.
 *   \n           2. Bit0 control LED0 ~ Bit7 control LED7.
 *   \n           3. 0 is "OFF" , 1 is "ON"                                                    
 * @return      
 * @exception   
 * @note        
 *******************************************************************************
 */                                                         
void BSP_LEDX8_RefreshStatus( uint32_t AnodeLED_ON, uint32_t CathodeLED_ON)
{
    uint8_t  BSP_LEDX8_RefTmp;
    uint8_t  BSP_LEDX8_RefCmp;
    uint16_t BSP_LEDX8_LED_ONTmp;
    
    /*Refresh Anode LED status*/
    BSP_LEDX8_RefCmp    = 0x01;
    BSP_LEDX8_LED_ONTmp = 0;
    for( BSP_LEDX8_RefTmp = 0; BSP_LEDX8_RefTmp < LED_H_TOTAL; BSP_LEDX8_RefTmp++)
    {
        if( AnodeLED_ON & BSP_LEDX8_RefCmp)
        {
            BSP_LEDX8_LED_ONTmp = BSP_LEDX8_LED_ONTmp | LED_H_PinTable[BSP_LEDX8_RefTmp];
        }
        BSP_LEDX8_RefCmp = (uint8_t)(BSP_LEDX8_RefCmp << 1);
    }
    GPIO_SetClearPortBit(LED_H_PORT,BSP_LEDX8_LED_ONTmp,((~BSP_LEDX8_LED_ONTmp)&LED_H_PINMASK));
    
    /*Refresh Cathode LED status*/
    BSP_LEDX8_RefCmp    = 0x01;
    BSP_LEDX8_LED_ONTmp = 0;
    for( BSP_LEDX8_RefTmp = 0; BSP_LEDX8_RefTmp < LED_H_TOTAL; BSP_LEDX8_RefTmp++)
    {
        if( CathodeLED_ON & BSP_LEDX8_RefCmp)
        {
            BSP_LEDX8_LED_ONTmp = BSP_LEDX8_LED_ONTmp | LED_L_PinTable[BSP_LEDX8_RefTmp];
        }
        BSP_LEDX8_RefCmp = (uint8_t)(BSP_LEDX8_RefCmp << 1);
    }
    GPIO_SetClearPortBit(LED_L_PORT,((~BSP_LEDX8_LED_ONTmp)&LED_L_PINMASK), BSP_LEDX8_LED_ONTmp);
}

/**
 *******************************************************************************
 * @brief	  LEDX8 inital  
 * @details                                                    
 * @return      
 * @exception   
 * @note        
 *******************************************************************************
 */                                                         
void BSP_LEDX8_Init(void)
{
    PIN_InitTypeDef         LED_Pin;

    /*Close All LED*/
    BSP_LEDX8_RefreshStatus (0 , 0);
    
    /*GPIO Inital.*/
    LED_Pin.PINX_Pin                = ( LED_H0_PIN | LED_H1_PIN | LED_H2_PIN | LED_H3_PIN |
                                        LED_H4_PIN | LED_H5_PIN | LED_H6_PIN | LED_H7_PIN);
    LED_Pin.PINX_Mode               = PINX_Mode_PushPull_O;
    LED_Pin.PINX_PUResistant        = PINX_PUResistant_Disable;
    LED_Pin.PINX_Speed              = PINX_Speed_Low;
    LED_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    LED_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    LED_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    LED_Pin.PINX_Alternate_Function = 0;                          
    GPIO_PortMode_Config( LED_H_IOM ,&LED_Pin);
    
    LED_Pin.PINX_Pin                = ( LED_L0_PIN | LED_L1_PIN | LED_L2_PIN | LED_L3_PIN |
                                        LED_L4_PIN | LED_L5_PIN | LED_L6_PIN | LED_L7_PIN);
    LED_Pin.PINX_Mode               = PINX_Mode_PushPull_O;
    LED_Pin.PINX_PUResistant        = PINX_PUResistant_Disable;
    LED_Pin.PINX_Speed              = PINX_Speed_Low;
    LED_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    LED_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    LED_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    LED_Pin.PINX_Alternate_Function = 0;                          
    GPIO_PortMode_Config( LED_L_IOM ,&LED_Pin);
    
}












