/**
  ******************************************************************************
 *
 * @file        Sample_MID_APX_CCL.c
 *
 * @brief       Initial APX CCL by middleware.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_APX_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***

// <e0.0> CCL0 configuration
#define APXCCL0En   1

// ----------------------------------------------------------------------------
//  <o0> CCL_IN0 input MUX select.
//      <0=> DISABLE 
//      <1=> CCL_SEQ    
//      <2=> CCL_AO     
//      <3=> PB11       
//      <4=> PA8        
//      <5=> PB0        
//      <6=> PB8        
//      <7=> PE0        
//      <8=> CMP0_OUT   
//      <9=> URT0_TX    
//      <10=> SPI0_MOSI  
//      <11=> TM36_OC00  
//      <12=> TM26_OC00  
//      <13=> SDT_I0     
//      <14=> OBM_P0     
#define CCL0_MUX0       4

// ----------------------------------------------------------------------------
//  <o0> CCL_IN1 input MUX select.
//      <0x00=> DISABLE 
//      <0x10=> CCL_SEQ     
//      <0x20=> CCL_AO      
//      <0x30=> PB3         
//      <0x40=> PA9         
//      <0x50=> PB1         
//      <0x60=> PB9         
//      <0x70=> PE1         
//      <0x80=> CMP1_OUT    
//      <0x90=> URT1_TX     
//      <0xA0=> SPI0_MISO   
//      <0xB0=> TM36_OC10   
//      <0xC0=> TM26_OC10   
//      <0xD0=> SDT_I1      
//      <0xE0=> OBM_I0      
#define CCL0_MUX1       64


// ----------------------------------------------------------------------------
//  <o0> CCL_IN2 input MUX select.
//      <0x000=> DISABLE
//      <0x100=> CCL_SEQ   
//      <0x200=> CCL_AO    
//      <0x300=> PC1       
//      <0x400=> PA10      
//      <0x500=> PB2       
//      <0x600=> PB10      
//      <0x700=> PE2       
//      <0x800=> ADC0_OUT  
//      <0x900=> URT4_TX   
//      <0xA00=> SPI0_CLK   
//      <0xB00=> TM36_OC2   
//      <0xC00=> TM20_OC00  
//      <0xD00=> SDT_P0     
//      <0xE00=> OBM_I1     
#define CCL0_MUX2       1024

// ----------------------------------------------------------------------------
//  <o0.0..7> CCL lookup truth table <0x00-0xFF>
//      <i> user can try 3IN_AND=0x80 or 3IN_OR=0xFE or IN0_NOT=0x55 .... 
//      <i> OUT : IN0, IN1, IN2
//      <i> [0] : 0, 0, 0
//      <i> [1] : 0, 0, 1
//      <i> [2] : 0, 1, 0
//      <i> [3] : 0, 1, 1
//      <i> [4] : 1, 0, 0
//      <i> [5] : 1, 0, 1
//      <i> [6] : 1, 1, 0
//      <i> [7] : 1, 1, 1
#define CCL0_TRUTH      0x80  

// ----------------------------------------------------------------------------
//  <o0> Inverse CCL output <0=> Disable <0x800=> Enable
#define InverseCCL0     0

// ----------------------------------------------------------------------------
//  <o0> CCL internal clock input divider. 
//      <0x00000000=> DIV1 : divided by 1 
//      <0x00001000=> DIV2 : divided by 2 
//      <0x00002000=> DIV4 : divided by 4 
//      <0x00003000=> DIV8 : divided by 8 
#define CCL0ClkDIV      0

// ----------------------------------------------------------------------------
//  <o0> CCL filter select.
//      <0x00=> Disable
//      <0x10=> SYNC : Synchronizer enabled
//      <0x20=> FILTER : Filter enabled
#define CCL0Filter      0

// ----------------------------------------------------------------------------
//  <o0> CCL edge detector mode select
//      <0x00=> Disable
//      <0x40=> Rising
//      <0x80=> Falling
//      <0xC0=> Dual-edge
#define CCL0EDSEL       0        

// ----------------------------------------------------------------------------
//  <o0> CCL sequential logic mode select.
//      <0x000=> Disable
//      <0x100=> DFF : D flip flop
//      <0x200=> JK : JK flip flop
//      <0x300=> DLH : D latch
//      <0x400=> RS : RS latch
#define CCL0SQSEL       0        

// ----------------------------------------------------------------------------
//  <o0> CCL sequential logic input CCL_S0 select
//      <0x00000000=> CCL_SQIN_0 : 0
//      <0x01000000=> CCL_SQIN_1 : 1
//      <0x02000000=> CCL_SQIN_CCL_S1 : CCL_S1 (Active CCL1 by user)
#define CCL0SQIN       0        

// </e>

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// <e0.0> CCL1 configuration
#define APXCCL1En   1

// ----------------------------------------------------------------------------
//  <o0> CCL_IN0 input MUX select.
//      <0=> DISABLE 
//      <1=> CCL_SEQ    
//      <2=> CCL_AO     
//      <3=> PB11       
//      <4=> PA8        
//      <5=> PB0        
//      <6=> PB8        
//      <7=> PE0        
//      <8=> CMP0_OUT   
//      <9=> URT0_TX    
//      <10=> SPI0_MOSI  
//      <11=> TM36_OC00  
//      <12=> TM26_OC00  
//      <13=> SDT_I0     
//      <14=> OBM_P0     
#define CCL1_MUX0       4

// ----------------------------------------------------------------------------
//  <o0> CCL_IN1 input MUX select.
//      <0x00=> DISABLE 
//      <0x10=> CCL_SEQ     
//      <0x20=> CCL_AO      
//      <0x30=> PB3         
//      <0x40=> PA9         
//      <0x50=> PB1         
//      <0x60=> PB9         
//      <0x70=> PE1         
//      <0x80=> CMP1_OUT    
//      <0x90=> URT1_TX     
//      <0xA0=> SPI0_MISO   
//      <0xB0=> TM36_OC10   
//      <0xC0=> TM26_OC10   
//      <0xD0=> SDT_I1      
//      <0xE0=> OBM_I0      
#define CCL1_MUX1       64


// ----------------------------------------------------------------------------
//  <o0> CCL_IN2 input MUX select.
//      <0x000=> DISABLE
//      <0x100=> CCL_SEQ   
//      <0x200=> CCL_AO    
//      <0x300=> PC1       
//      <0x400=> PA10      
//      <0x500=> PB2       
//      <0x600=> PB10      
//      <0x700=> PE2       
//      <0x800=> ADC0_OUT  
//      <0x900=> URT4_TX   
//      <0xA00=> SPI0_CLK   
//      <0xB00=> TM36_OC2   
//      <0xC00=> TM20_OC00  
//      <0xD00=> SDT_P0     
//      <0xE00=> OBM_I1     
#define CCL1_MUX2       1024

// ----------------------------------------------------------------------------
//  <o0.0..7> CCL lookup truth table <0x00-0xFF>
//      <i> user can try 3IN_AND=0x80 or 3IN_OR=0xFE or IN0_NOT=0x55 .... 
//      <i> OUT : IN0, IN1, IN2
//      <i> [0] : 0, 0, 0
//      <i> [1] : 0, 0, 1
//      <i> [2] : 0, 1, 0
//      <i> [3] : 0, 1, 1
//      <i> [4] : 1, 0, 0
//      <i> [5] : 1, 0, 1
//      <i> [6] : 1, 1, 0
//      <i> [7] : 1, 1, 1
#define CCL1_TRUTH      0x80  

// ----------------------------------------------------------------------------
//  <o0> Inverse CCL output <0=> Disable <0x800=> Enable
#define InverseCCL1     0

// ----------------------------------------------------------------------------
//  <o0> CCL internal clock input divider. 
//      <0x00000000=> DIV1 : divided by 1 
//      <0x00001000=> DIV2 : divided by 2 
//      <0x00002000=> DIV4 : divided by 4 
//      <0x00003000=> DIV8 : divided by 8 
#define CCL1ClkDIV      0

// ----------------------------------------------------------------------------
//  <o0> CCL filter select.
//      <0x00=> Disable
//      <0x10=> SYNC : Synchronizer enabled
//      <0x20=> FILTER : Filter enabled
#define CCL1Filter      0

// ----------------------------------------------------------------------------
//  <o0> CCL edge detector mode select
//      <0x00=> Disable
//      <0x40=> Rising
//      <0x80=> Falling
//      <0xC0=> Dual-edge
#define CCL1EDSEL       0        

// ----------------------------------------------------------------------------
//  <o0> CCL sequential logic mode select.
//      <0x000=> Disable
//      <0x100=> DFF : D flip flop
//      <0x200=> JK : JK flip flop
//      <0x300=> DLH : D latch
//      <0x400=> RS : RS latch
#define CCL1SQSEL       0        

// ----------------------------------------------------------------------------
//  <o0> CCL sequential logic input CCL_S0 select
//      <0x00000000=> CCL_SQIN_0 : 0
//      <0x01000000=> CCL_SQIN_1 : 1
#define CCL1SQIN       0        

// </e>

//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if APXCCL0En==1
static CCL_HandleTypeDef mCCL0;
#endif    
#if APXCCL1En==1
static CCL_HandleTypeDef mCCL1;
#endif    

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_APX_CCL(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    Initial APX CCL0/1.
 * @return      None.
 *******************************************************************************
 */
void Sample_MID_APX_CCL(void)
{  
    // make sure :
	
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->APB = Enable
	
    //==Set GPIO init 
    //MUX0/1/2 pin config:
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->PA8,PA9,PA10 (Default)
    //GPIO port initial is 0xFFFF
    //PA8,PA9,PA10 mode is DIN with Pull-up
    //PA8,PA9,PA10 function GPIO

    //==Set GPIO init 
    //CCL_P0 pin config:
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->PA0 
    //GPIO port initial is 0xFFFF
    //PA0 mode is PPO
    //PA0 function CCL_P0

    //==Set GPIO init 
    //CCL_P1 pin config:
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->PA1
    //GPIO port initial is 0xFFFF
    //PA1 mode is PPO
    //PA1 function CCL_P1


#if APXCCL0En==1
    //-------------------------------------------------------------------------
    // CCL0: Verify Truth table (3line, AND, NAND, OR, NOR, XNOR...)
    //-------------------------------------------------------------------------
    // Initial CCL0 for verify truth table (DIRECT OUTPUT)
    
    mCCL0.Instance                  = CCL0;
    mCCL0.TruthTable                = CCL0_TRUTH;                   // Truth table.
    mCCL0.CCL_INTClockDivision      = CCL0ClkDIV;                   // CCL internal clock divider.
    mCCL0.MUX0Input                 = CCL0_MUX0;                    // CCL IN0 input MUX select.
    mCCL0.MUX1Input                 = CCL0_MUX1;                    // CCL IN1 input MUX select.
    mCCL0.MUX2Input                 = CCL0_MUX2;                    // CCL IN2 input MUX select.
    mCCL0.CCL_SQIN                  = CCL0SQIN;                     // CCL sequential input.
    mCCL0.SEQMode                   = CCL0SQSEL;                    // SQSEL effect.
    mCCL0.EdgeDetectMode            = CCL0EDSEL;                    // Edge detect.
    mCCL0.OutputSync                = CCL0Filter;                   // Filter config.
    mCCL0.OutputPol                 = InverseCCL0;                  // Inverse output function.
    
    MID_APX_CCL_Init(&mCCL0);
    // Start APX CCL0
    MID_APX_CCL_Start(&mCCL0);
    
    // Start APX CCL0 with interrupt support
    // CCL0 call bak routine is 'MID_APX_CCL0_TriggerCallback'
//    MID_APX_CCL_Start_IT(&mCCL0);
#endif
#if APXCCL1En==1
    //-------------------------------------------------------------------------
    // CCL1: Verify Truth table (3line, AND, NAND, OR, NOR, XNOR...)
    //-------------------------------------------------------------------------
    // Initial CCL1 for verify truth table (DIRECT OUTPUT)
    
    mCCL1.Instance                  = CCL1;
    mCCL1.TruthTable                = CCL1_TRUTH;                   // Truth table.
    mCCL1.CCL_INTClockDivision      = CCL1ClkDIV;                   // CCL internal clock divider.
    mCCL1.MUX0Input                 = CCL1_MUX0;                    // CCL IN0 input MUX select.
    mCCL1.MUX1Input                 = CCL1_MUX1;                    // CCL IN1 input MUX select.
    mCCL1.MUX2Input                 = CCL1_MUX2;                    // CCL IN2 input MUX select.
    mCCL1.CCL_SQIN                  = CCL1SQIN;                     // CCL sequential input.
    mCCL1.SEQMode                   = CCL1SQSEL;                    // SQSEL effect.
    mCCL1.EdgeDetectMode            = CCL1EDSEL;                    // Edge detect.
    mCCL1.OutputSync                = CCL1Filter;                   // Filter config.
    mCCL1.OutputPol                 = InverseCCL1;                  // Inverse output function.
    
    MID_APX_CCL_Init(&mCCL1);
    // Start APX CCL0
    MID_APX_CCL_Start(&mCCL1);
    
    // Start APX CCL1 with interrupt support
    // CCL1 call bak routine is 'MID_APX_CCL1_TriggerCallback'
//    MID_APX_CCL_Start_IT(&mCCL1);
#endif
        
    return;
}


///**
// *******************************************************************************
// * @brief       APX CCL0 callback.
// * @param[in]   mCCL : pointer to a CCL_HandleTypeDef
// * @return		None
// *******************************************************************************
// */
//void MID_APX_CCL0_TriggerCallback(CCL_HandleTypeDef* mCCL)
//{
//    // to do ...
//}

///**
// *******************************************************************************
// * @brief       APX CCL1 callback.
// * @param[in]   mCCL : pointer to a CCL_HandleTypeDef
// * @return		None
// *******************************************************************************
// */
//void MID_APX_CCL1_TriggerCallback(CCL_HandleTypeDef* mCCL)
//{
//    // to do ...
//}



