/**
 ******************************************************************************
 *
 * @file        onIROM1.c
 * @brief       MG32 demo onIROM1 c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2023/11/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "onIROM1.h"

/* External vairables --------------------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
void onIROM1(void);         // Normal in IROM1

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void onIROM1_Func1(void); // Normal in IROM1
void onIROM1_Func2(void); // Assign to IROM1
void onIROM1_Func3(void); // Normal in IROM2


/* Private user code ---------------------------------------------------------*/
/**
  *******************************************************************************
  * @brief  This function is executed in case of onIROM1.
  * @retval None
  *******************************************************************************
  */
void onIROM1(void)
{
    uint32_t lTemp32 = 0;
    printf("    onIROM1\n\r");

    lTemp32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTemp32 --;
    }while(lTemp32 != 0);

    onIROM1_Func1();
    onIROM1_Func2();
    onIROM1_Func3();
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIROM1 Func1.
  * @retval None
  *******************************************************************************
  */
void onIROM1_Func1(void)
{
    uint32_t lTempZ32 = 0;
    printf("      onIROM1_Func1\n\r");

    lTempZ32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempZ32 --;
    }while(lTempZ32 != 0);
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIROM1 Func2.
  * @retval None
  *******************************************************************************
  */
void onIROM1_Func2(void)
{
    uint32_t lTempY32 = 0;
    printf("      onIROM1_Func2\n\r");

    lTempY32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempY32 --;
    }while(lTempY32 != 0);
}


/**
  *******************************************************************************
  * @brief  This function is executed in case of onIROM1 Func3.
  * @retval None
  *******************************************************************************
  */
void onIROM1_Func3(void)
{
    uint32_t lTempX32 = 0;
    printf("      onIROM1_Func3\n\r");

    lTempX32 = 100;
    do{
        __NOP(); __ISB(); __DSB();
        lTempX32 --;
    }while(lTempX32 != 0);
}


