/**
 *******************************************************************************
 *
 * @file        MG32_OPA_Init.c
 *
 * @brief       The OPA initial code C file 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2025/05/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_OPA.h"
#include "MG32_OPA_Init.h"
#include "MG32__ExtraStruct.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_OPA_MID.h"
#endif

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
// (Middleware level)
#if defined(IRQHandler_Middleware_Level_)       
    #if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
            OPA_HandleTypeDef        mOPA;
        #pragma clang diagnostic pop
    // ------------------------------------------------------------------------
    #else
        OPA_HandleTypeDef        mOPA;
    #endif
    // ------------------------------------------------------------------------
#endif


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief  	    Initialized Analog Comparator module.
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void OPA_Init(void)
{
    
    /* OPA register initial */
    #if CONF_OPA_MODE != 0
        OPA->CR0.W  = CONF_OPA_CR0 | OPA_CR0_OP0_EN_enable_w;
    
        // --------------------------------------------------------------------
        // Config mOPA structure within Middleware level
        // --------------------------------------------------------------------
        #if defined(IRQHandler_Middleware_Level_)       
            mOPA.Instance               = OPA_OP0;
            
            mOPA.Init.InvertingInput    = CONF_OPA_OPAPMUX;
            mOPA.Init.NonInvertingInput = CONF_OPA_OPANMUX;
            mOPA.Init.PowerMode         = CONF_OPA_OPALPEN;
            // MID_OPA_Init(&mADC);
        #endif
        
        // Calibre OPA offset.
        OPA_OffsetCalibration_Cmd(OPA_OP0, ENABLE);
    #endif

}


