/**
 ******************************************************************************
 *
 * @file        MG32_LCD_Init.c
 * @brief       The LCD Init C file.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2025/07/25
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *   
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
/* Wizard menu ---------------------------------------------------------------*/

/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_CSC_Init.h"
#include "MG32_LCD_Init.h"

#if defined(IRQHandler_Middleware_Level_)
  #include "MG32_MID.h"
#endif

/* External vairables --------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void LCD_Init(void);



/**
 *******************************************************************************
 * @brief       LCD_Init
 * @details     
 * @return      LCDx inital is whether pass or not.
 * @exception   No
 * @note        The LCD initial
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void LCD_Init(void)
{
    CSC->KEY.W = 0xA217;
    CSC->APB1.W = (CSC->APB1.W | CSC_APB1_LCD_EN_mask_w);
    CSC->KEY.W = 0;
    LCD->CR0.W = 0;

    LCD->MUX0.W = (uint32_t)CONF_LCD_MUX0;
    LCD->MUX1.W = (uint32_t)CONF_LCD_MUX1;

    LCD->MD0.W = (uint32_t)0xFFFFFFFF;
    LCD->MD1.W = (uint32_t)0xFFFFFFFF;
    LCD->MD2.W = (uint32_t)0xFFFFFFFF;
    LCD->MD3.W = (uint32_t)0xFFFFFFFF;
    LCD->MD4.W = (uint32_t)0xFFFFFFFF;
    LCD->MD5.W = (uint32_t)0xFFFFFFFF;
    LCD->MD6.W = (uint32_t)0xFFFFFFFF;
    LCD->MD7.W = (uint32_t)0xFFFFFFFF;
    LCD->MD8.W = (uint32_t)0xFFFFFFFF;
    LCD->MD9.W = (uint32_t)0xFFFFFFFF;
    LCD->MD10.W = (uint32_t)0xFFFFFFFF;

    #if ((CONF_LCD_CS0 & 0x00000001) != 0)  //LCD_P0 COMn Setting
        LCD->MD0.W &= (CONF_LCD_M0 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS1 & 0x00000002) != 0)  //LCD_P1 COMn Setting
        LCD->MD0.W &= (CONF_LCD_M1 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS2 & 0x00000004) != 0)  //LCD_P2 COMn Setting
        LCD->MD0.W &= (CONF_LCD_M2 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS3 & 0x00000008) != 0)  //LCD_P3 COMn Setting
        LCD->MD0.W &= (CONF_LCD_M3 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS4 & 0x00000010) != 0)  //LCD_P4 COMn Setting
        LCD->MD1.W &= (CONF_LCD_M4 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS5 & 0x00000020) != 0)  //LCD_P5 COMn Setting
        LCD->MD1.W &= (CONF_LCD_M5 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS6 & 0x00000040) != 0)  //LCD_P6 COMn Setting
        LCD->MD1.W &= (CONF_LCD_M6 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS7 & 0x00000080) != 0)  //LCD_P7 COMn Setting
        LCD->MD1.W &= (CONF_LCD_M7 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS8 & 0x00000100) != 0)  //LCD_P8 COMn Setting
        LCD->MD2.W &= (CONF_LCD_M8 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS9 & 0x00000200) != 0)  //LCD_P9 COMn Setting
        LCD->MD2.W &= (CONF_LCD_M9 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS10 & 0x00000400) != 0)  //LCD_P10 COMn Setting
        LCD->MD2.W &= (CONF_LCD_M10 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS11 & 0x00000800) != 0)  //LCD_P11 COMn Setting
        LCD->MD2.W &= (CONF_LCD_M11 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS12 & 0x00001000) != 0)  //LCD_P12 COMn Setting
        LCD->MD3.W &= (CONF_LCD_M12 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS13 & 0x00002000) != 0)  //LCD_P13 COMn Setting
        LCD->MD3.W &= (CONF_LCD_M13 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS14 & 0x00004000) != 0)  //LCD_P14 COMn Setting
        LCD->MD3.W &= (CONF_LCD_M14 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS15 & 0x00008000) != 0)  //LCD_P15 COMn Setting
        LCD->MD3.W &= (CONF_LCD_M15 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS16 & 0x00010000) != 0)  //LCD_P16 COMn Setting
        LCD->MD4.W &= (CONF_LCD_M16 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS17 & 0x00020000) != 0)  //LCD_P17 COMn Setting
        LCD->MD4.W &= (CONF_LCD_M17 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS18 & 0x00040000) != 0)  //LCD_P18 COMn Setting
        LCD->MD4.W &= (CONF_LCD_M18 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS19 & 0x00080000) != 0)  //LCD_P19 COMn Setting
        LCD->MD4.W &= (CONF_LCD_M19 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS20 & 0x00100000) != 0)  //LCD_P20 COMn Setting
        LCD->MD5.W &= (CONF_LCD_M20 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS21 & 0x00200000) != 0)  //LCD_P21 COMn Setting
        LCD->MD5.W &= (CONF_LCD_M21 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS22 & 0x00400000) != 0)  //LCD_P22 COMn Setting
        LCD->MD5.W &= (CONF_LCD_M22 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS23 & 0x00800000) != 0)  //LCD_P23 COMn Setting
        LCD->MD5.W &= (CONF_LCD_M23 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS24 & 0x01000000) != 0)  //LCD_P24 COMn Setting
        LCD->MD6.W &= (CONF_LCD_M24 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS25 & 0x02000000) != 0)  //LCD_P25 COMn Setting
        LCD->MD6.W &= (CONF_LCD_M25 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS26 & 0x04000000) != 0)  //LCD_P26 COMn Setting
        LCD->MD6.W &= (CONF_LCD_M26 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS27 & 0x08000000) != 0)  //LCD_P27 COMn Setting
        LCD->MD6.W &= (CONF_LCD_M27 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS28 & 0x10000000) != 0)  //LCD_P28 COMn Setting
        LCD->MD7.W &= (CONF_LCD_M28 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS29 & 0x20000000) != 0)  //LCD_P29 COMn Setting
        LCD->MD7.W &= (CONF_LCD_M29 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS30 & 0x40000000) != 0)  //LCD_P30 COMn Setting
        LCD->MD7.W &= (CONF_LCD_M30 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS31 & 0x80000000) != 0)  //LCD_P31 COMn Setting
        LCD->MD7.W &= (CONF_LCD_M31 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS32 & 0x00000001) != 0)  //LCD_P32 COMn Setting
        LCD->MD8.W &= (CONF_LCD_M32 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS33 & 0x00000002) != 0)  //LCD_P33 COMn Setting
        LCD->MD8.W &= (CONF_LCD_M33 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS34 & 0x00000004) != 0)  //LCD_P34 COMn Setting
        LCD->MD8.W &= (CONF_LCD_M34 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS35 & 0x00000008) != 0)  //LCD_P35 COMn Setting
        LCD->MD8.W &= (CONF_LCD_M35 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS36 & 0x00000010) != 0)  //LCD_P36 COMn Setting
        LCD->MD9.W &= (CONF_LCD_M36 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS37 & 0x00000020) != 0)  //LCD_P37 COMn Setting
        LCD->MD9.W &= (CONF_LCD_M37 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS38 & 0x00000040) != 0)  //LCD_P38 COMn Setting
        LCD->MD9.W &= (CONF_LCD_M38 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS39 & 0x00000080) != 0)  //LCD_P39 COMn Setting
        LCD->MD9.W &= (CONF_LCD_M39 | 0x00FFFFFF) ;
    #endif

    #if ((CONF_LCD_CS40 & 0x00000100) != 0)  //LCD_P40 COMn Setting
        LCD->MD10.W &= (CONF_LCD_M40 | 0xFFFFFF00) ;
    #endif

    #if ((CONF_LCD_CS41 & 0x00000200) != 0)  //LCD_P41 COMn Setting
        LCD->MD10.W &= (CONF_LCD_M41 | 0xFFFF00FF) ;
    #endif

    #if ((CONF_LCD_CS42 & 0x00000400) != 0)  //LCD_P42 COMn Setting
        LCD->MD10.W &= (CONF_LCD_M42 | 0xFF00FFFF) ;
    #endif

    #if ((CONF_LCD_CS43 & 0x00000800) != 0)  //LCD_P43 COMn Setting
        LCD->MD10.W &= (CONF_LCD_M43 | 0x00FFFFFF) ;
    #endif

    LCD->INT.W = (uint32_t)CONF_LCD_INT;
    LCD->CLK.W = (uint32_t)CONF_LCD_CLK;

    #if(CONF_LCD_Mode == 0)

    #else
        #if(CONF_LCD_RL_SEL == 0)   // use Int-R Ladder
            LCD->CR0.W = ((uint32_t)CONF_LCD_CR0 & (~LCD_CR1_DRV_MDS_mask_w));
        #else
            LCD->CR0.W = ((uint32_t)CONF_LCD_CR0 | LCD_CR1_DRV_MDS_mask_w);
        #endif

        LCD->CR1.W = (((uint32_t)CONF_LCD_CR1) & (~LCD_CR1_CP_EN_mask_w));
        LCD->CR2.W = (uint32_t)CONF_LCD_CR2;

        LCD->CR0.W |= LCD_CR0_EN_mask_w;

        #if(CONF_LCD_VS_SEL == 0x00000006)  // VS_SEL == CP
            LCD->CR1.W |= LCD_CR1_CP_EN_mask_w;
        #endif

        #if(CONF_LCD_RL_SEL == 0)   // use Int-R Ladder
            // Delay(100); Delay 100ms for Charge capacitance.
            LCD->CR0.W = ((uint32_t)CONF_LCD_CR0 & (~LCD_CR1_DRV_MDS_mask_w));
        #endif
    #endif
        LCD->CR2.W |= LCD_CR2_MEM_CLR_mask_w;
}


