/**
 ******************************************************************************
 *
 * @file        MG32_GPIO.h
 *
 * @brief       MG32 GPIO Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.12 (Register File Date : 2025_1014)
 * @date        2026/01/05 10:11 (H File Generated Date)
 * @author      HeadCodeGen V1.61
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_GPIO_H
#define _MG32_GPIO_H
#define _MG32_GPIO_H_VER                            112     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_GPIO_H_VER)
    #error "_MG32_GPIO_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 *              GPIO  [Module Structure Typedef]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 *
 * @struct      GPIO_Struct
 *              GPIO Input/Output Register Control Definitions  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OUT0          :1;     //[0] IO pin PX0 output data bit.
            __IO uint8_t  OUT1          :1;     //[1] IO pin PX1 output data bit.
            __IO uint8_t  OUT2          :1;     //[2] IO pin PX2 output data bit.
            __IO uint8_t  OUT3          :1;     //[3] IO pin PX3 output data bit.
            __I  uint8_t  OUT4          :1;     //[4] IO pin PX4 output data bit.
            __I  uint8_t  OUT5          :1;     //[5] IO pin PX5 output data bit.
            __I  uint8_t  OUT6          :1;     //[6] IO pin PX6 output data bit.
            __I  uint8_t  OUT7          :1;     //[7] IO pin PX7 output data bit.
            __IO uint8_t  OUT8          :1;     //[8] IO pin PX8 output data bit.
            __IO uint8_t  OUT9          :1;     //[9] IO pin PX9 output data bit.
            __IO uint8_t  OUT10         :1;     //[10] IO pin PX10 output data bit.
            __IO uint8_t  OUT11         :1;     //[11] IO pin PX11 output data bit.
            __I  uint8_t  OUT12         :1;     //[12] IO pin PX12 output data bit.
            __I  uint8_t  OUT13         :1;     //[13] IO pin PX13 output data bit.
            __I  uint8_t  OUT14         :1;     //[14] IO pin PX14 output data bit.
            __I  uint8_t  OUT15         :1;     //[15] IO pin PX15 output data bit.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }OUT;                               /*!< OUT        ~ Offset[0x00]  PX output data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  IN0           :1;     //[0] IO pin PX0 input pin status.
            __I  uint8_t  IN1           :1;     //[1] IO pin PX1 input pin status.
            __I  uint8_t  IN2           :1;     //[2] IO pin PX2 input pin status.
            __I  uint8_t  IN3           :1;     //[3] IO pin PX3 input pin status.
            __I  uint8_t  IN4           :1;     //[4] IO pin PX4 input pin status.
            __I  uint8_t  IN5           :1;     //[5] IO pin PX5 input pin status.
            __I  uint8_t  IN6           :1;     //[6] IO pin PX6 input pin status.
            __I  uint8_t  IN7           :1;     //[7] IO pin PX7 input pin status.
            __I  uint8_t  IN8           :1;     //[8] IO pin PX8 input pin status.
            __I  uint8_t  IN9           :1;     //[9] IO pin PX9 input pin status.
            __I  uint8_t  IN10          :1;     //[10] IO pin PX10 input pin status.
            __I  uint8_t  IN11          :1;     //[11] IO pin PX11 input pin status.
            __I  uint8_t  IN12          :1;     //[12] IO pin PX12 input pin status.
            __I  uint8_t  IN13          :1;     //[13] IO pin PX13 input pin status.
            __I  uint8_t  IN14          :1;     //[14] IO pin PX14 input pin status.
            __I  uint8_t  IN15          :1;     //[15] IO pin PX15 input pin status.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }IN;                                /*!< IN         ~ Offset[0x04]  PX input data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __O  uint8_t  SET0          :1;     //[0] IO pin PX0 set data bit
            __O  uint8_t  SET1          :1;     //[1] IO pin PX1 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET2          :1;     //[2] IO pin PX2 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET3          :1;     //[3] IO pin PX3 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET4          :1;     //[4] IO pin PX4 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET5          :1;     //[5] IO pin PX5 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET6          :1;     //[6] IO pin PX6 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET7          :1;     //[7] IO pin PX7 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET8          :1;     //[8] IO pin PX8 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET9          :1;     //[9] IO pin PX9 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET10         :1;     //[10] IO pin PX10 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  SET11         :1;     //[11] IO pin PX11 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET12         :1;     //[12] IO pin PX12 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET13         :1;     //[13] IO pin PX13 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET14         :1;     //[14] IO pin PX14 set data bit. This bit is no effect for writing 0.
            __I  uint8_t  SET15         :1;     //[15] IO pin PX15 set data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR0          :1;     //[16] IO pin PX0 clear data bit
            __O  uint8_t  CLR1          :1;     //[17] IO pin PX1 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR2          :1;     //[18] IO pin PX2 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR3          :1;     //[19] IO pin PX3 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR4          :1;     //[20] IO pin PX4 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR5          :1;     //[21] IO pin PX5 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR6          :1;     //[22] IO pin PX6 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR7          :1;     //[23] IO pin PX7 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR8          :1;     //[24] IO pin PX8 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR9          :1;     //[25] IO pin PX9 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR10         :1;     //[26] IO pin PX10 clear data bit. This bit is no effect for writing 0.
            __O  uint8_t  CLR11         :1;     //[27] IO pin PX11 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR12         :1;     //[28] IO pin PX12 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR13         :1;     //[29] IO pin PX13 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR14         :1;     //[30] IO pin PX14 clear data bit. This bit is no effect for writing 0.
            __I  uint8_t  CLR15         :1;     //[31] IO pin PX15 clear data bit. This bit is no effect for writing 0.
        }MBIT;
    }SC;                                /*!< SC         ~ Offset[0x08]  PX port set / clear register */

    __I uint32_t  RESERVED0;            /*!< Offset[0x0C]       Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SC0           :1;     //[0] GPIO Port set or clear bit for PX0.
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  SC1           :1;     //[8] GPIO Port set or clear bit for PX1.
            __I  uint8_t                :7;     //[15..9] 
            __IO uint8_t  SC2           :1;     //[16] GPIO Port set or clear bit for PX2.
            __I  uint8_t                :7;     //[23..17] 
            __IO uint8_t  SC3           :1;     //[24] GPIO Port set or clear bit for PX3.
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }SCR0;                              /*!< SCR0       ~ Offset[0x10]  PX port set and clear register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SC4           :1;     //[0] GPIO Port set or clear bit for PX4.
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  SC5           :1;     //[8] GPIO Port set or clear bit for PX5.
            __I  uint8_t                :7;     //[15..9] 
            __IO uint8_t  SC6           :1;     //[16] GPIO Port set or clear bit for PX6.
            __I  uint8_t                :7;     //[23..17] 
            __IO uint8_t  SC7           :1;     //[24] GPIO Port set or clear bit for PX7.
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }SCR1;                              /*!< SCR1       ~ Offset[0x14]  PX port set and clear register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SC8           :1;     //[0] GPIO Port set or clear bit for PX8.
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  SC9           :1;     //[8] GPIO Port set or clear bit for PX9.
            __I  uint8_t                :7;     //[15..9] 
            __IO uint8_t  SC10          :1;     //[16] GPIO Port set or clear bit for PX10.
            __I  uint8_t                :7;     //[23..17] 
            __IO uint8_t  SC11          :1;     //[24] GPIO Port set and clear bit for PX11.
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }SCR2;                              /*!< SCR2       ~ Offset[0x18]  PX port set and clear register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SC12          :1;     //[0] GPIO Port set or clear bit for PX12.
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  SC13          :1;     //[8] GPIO Port set or clear bit for PX13.
            __I  uint8_t                :7;     //[15..9] 
            __IO uint8_t  SC14          :1;     //[16] GPIO Port set or clear bit for PX14.
            __I  uint8_t                :7;     //[23..17] 
            __IO uint8_t  SC15          :1;     //[24] GPIO Port set or clear bit for PX15.
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }SCR3;                              /*!< SCR3       ~ Offset[0x1C]  PX port set and clear register 3 */

} GPIO_Struct;

/**
 ******************************************************************************
 *
 * @struct      IOM_Struct
 *              Port IO Mode/AFS Register Control Definitions  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR0;                              /*!< CR0        ~ Offset[0x00]  PX0 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR1;                              /*!< CR1        ~ Offset[0x04]  PX1 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR2;                              /*!< CR2        ~ Offset[0x08]  PX2 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR3;                              /*!< CR3        ~ Offset[0x0C]  PX3 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR4;                              /*!< CR4        ~ Offset[0x10]  PX4 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR5;                              /*!< CR5        ~ Offset[0x14]  PX5 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR6;                              /*!< CR6        ~ Offset[0x18]  PX6 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR7;                              /*!< CR7        ~ Offset[0x1C]  PX7 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR8;                              /*!< CR8        ~ Offset[0x20]  PX8 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR9;                              /*!< CR9        ~ Offset[0x24]  PX9 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR10;                             /*!< CR10       ~ Offset[0x28]  PX10 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR11;                             /*!< CR11       ~ Offset[0x2C]  PX11 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR12;                             /*!< CR12       ~ Offset[0x30]  PX12 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR13;                             /*!< CR13       ~ Offset[0x34]  PX13 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR14;                             /*!< CR14       ~ Offset[0x38]  PX14 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
    } CR15;                             /*!< CR15       ~ Offset[0x3C]  PX15 IO control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  FCKS          :3;     //[2..0] PX port input deglitch filter clock source select for all pins of the port.
                                        //0x0 = CLK_AHB
                                        //0x1 = CLK_AHB_Div8 : CLK_AHB divide by 8
                                        //0x2 = CLK_ILRCO
                                        //0x3 = TM00_TRGO
                                        //0x4 = CK_UT
            __I  uint8_t                :3;     //[5..3] 
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }FLT;                               /*!< FLT        ~ Offset[0x40]  PX port input filter control register */

} IOM_Struct;

/**
 ******************************************************************************
 *
 * @struct      Pin_Struct
 *              Pin IO Mode/AFS Register Control Definitions  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IOM           :3;     //[2..0] PX0 pin IO mode control bits.
                                        //0x0 = AIO : analog IO
                                        //0x1 = ODO : open drain output
                                        //0x2 = PPO : push pull output
                                        //0x3 = DIN : Digital input
                                        //0x4 = QB : Quasi-Bidirectional output drive high one CLK
            __IO uint8_t  HS            :1;     //[3] PX0 pin output high speed mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  PU            :1;     //[5] PX0 pin pull-up resister enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  INV           :1;     //[7] PX0 pin input inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable 
            __I  uint8_t                :2;     //[9..8] 
            __IO uint8_t  FDIV          :2;     //[11..10] PX0 pin input deglitch filter clock divider select.
                                        //0x0 = Bypass : Bypass filter
                                        //0x1 = Div1 : Divided by 1
                                        //0x2 = Div4 : Divided by 4
                                        //0x3 = Div16 : Divided by 16
            __IO uint8_t  AFS           :4;     //[15..12] PX0 pin alternate function select. Refer the GPIO AFS table for detail information.
                                        //0x0 = AF0
                                        //0x1 = AF1
                                        //0x2 = AF2
                                        //0x3 = AF3
                                        //0x4 = AF4
                                        //0x5 = AF5
                                        //0x6 = AF6
                                        //0x7 = AF7
                                        //0x8 = AF8
                                        //0x9 = AF9
                                        //0xA = AF10
                                        //0xB = AF11
            __IO uint8_t  ODC           :3;     //[18..16] PX0 pin output drive strength select.
                                        //0x0 = Level0 : Drive strength-full
                                        //0x1 = Level1 : Drive strength-1/2
                                        //0x2 = Level2 : Drive strength-1/4
                                        //0x3 = Level3 : Drive strength-1/8
                                        //0x4 = Level4 : Drive strength-Extended1
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  LCK           :1;     //[31] PX0 pin control register write un-locked control
                                        //0 = Locked
                                        //1 = Un-Locked
        }MBIT;
    }CR;                                /*!< CR         PXn IO control register (X={A,B,C,D,..},n={0~15}) */

} Pin_Struct;

/**
 ******************************************************************************
 *
 * @name        GPIO  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define GPIOA_Base                      ((uint32_t)0x41000000)              /*!< GPIO Input/Output Register Control Definitions */
#define GPIOB_Base                      ((uint32_t)0x41000020)              /*!< GPIO Input/Output Register Control Definitions */
#define GPIOC_Base                      ((uint32_t)0x41000040)              /*!< GPIO Input/Output Register Control Definitions */
#define GPIOD_Base                      ((uint32_t)0x41000060)              /*!< GPIO Input/Output Register Control Definitions */
#define GPIOA                           ((GPIO_Struct*) GPIOA_Base)
#define GPIOB                           ((GPIO_Struct*) GPIOB_Base)
#define GPIOC                           ((GPIO_Struct*) GPIOC_Base)
#define GPIOD                           ((GPIO_Struct*) GPIOD_Base)

#define IOMA_Base                       ((uint32_t)0x44000000)              /*!< Port IO Mode/AFS Register Control Definitions */
#define IOMB_Base                       ((uint32_t)0x44010000)              /*!< Port IO Mode/AFS Register Control Definitions */
#define IOMC_Base                       ((uint32_t)0x44020000)              /*!< Port IO Mode/AFS Register Control Definitions */
#define IOMD_Base                       ((uint32_t)0x44030000)              /*!< Port IO Mode/AFS Register Control Definitions */
#define IOMA                            ((IOM_Struct*) IOMA_Base)
#define IOMB                            ((IOM_Struct*) IOMB_Base)
#define IOMC                            ((IOM_Struct*) IOMC_Base)
#define IOMD                            ((IOM_Struct*) IOMD_Base)
#define PINA(PinNum)                    ((Pin_Struct*)((uint32_t) (IOMA_Base + (0x4*PinNum))))
#define PINB(PinNum)                    ((Pin_Struct*)((uint32_t) (IOMB_Base + (0x4*PinNum))))
#define PINC(PinNum)                    ((Pin_Struct*)((uint32_t) (IOMC_Base + (0x4*PinNum))))
#define PIND(PinNum)                    ((Pin_Struct*)((uint32_t) (IOMD_Base + (0x4*PinNum))))
///@}

/**
 ******************************************************************************
 *
 * @name          [Register Definitions]
 *
 ******************************************************************************
 */

/*----------------------------------------------------------------------------*/
/* @module      IOP (GPIO Input/Output Register Control Definitions)          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PX_OUT  [register's definitions]
 *              Offset[0x00]  PX output data register (0x41000000)
 ******************************************************************************
 */
///@{
#define PX_OUT_default                              ((uint32_t)0xFFFFFFFF)  /*!< Reg Reset Default Value */

/* Bit fields of PX_OUT */
#define PX_OUT_OUT15_mask_w                         ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT15_mask_h0                        ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT15_mask_b1                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT14_mask_w                         ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT14_mask_h0                        ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT14_mask_b1                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT13_mask_w                         ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT13_mask_h0                        ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT13_mask_b1                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT12_mask_w                         ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT12_mask_h0                        ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT12_mask_b1                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT11_mask_w                         ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT11_mask_h0                        ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT11_mask_b1                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT10_mask_w                         ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT10_mask_h0                        ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT10_mask_b1                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT9_mask_w                          ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT9_mask_h0                         ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT9_mask_b1                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT8_mask_w                          ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT8_mask_h0                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT8_mask_b1                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT7_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT7_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT7_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT6_mask_w                          ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT6_mask_h0                         ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT6_mask_b0                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT5_mask_w                          ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT5_mask_h0                         ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT5_mask_b0                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT4_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT4_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT4_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT3_mask_w                          ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT3_mask_h0                         ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT3_mask_b0                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT2_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT2_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT2_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT1_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT1_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT1_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_OUT_OUT0_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_OUT_OUT0_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_OUT_OUT0_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_IN  [register's definitions]
 *              Offset[0x04]  PX input data register (0x41000004)
 ******************************************************************************
 */
///@{
#define PX_IN_default                               ((uint32_t)0x0000F0F0)  /*!< Reg Reset Default Value */

/* Bit fields of PX_IN */
#define PX_IN_IN15_mask_w                           ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define PX_IN_IN15_mask_h0                          ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define PX_IN_IN15_mask_b1                          ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_IN_IN14_mask_w                           ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define PX_IN_IN14_mask_h0                          ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define PX_IN_IN14_mask_b1                          ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_IN_IN13_mask_w                           ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define PX_IN_IN13_mask_h0                          ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define PX_IN_IN13_mask_b1                          ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_IN_IN12_mask_w                           ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define PX_IN_IN12_mask_h0                          ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define PX_IN_IN12_mask_b1                          ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_IN_IN11_mask_w                           ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define PX_IN_IN11_mask_h0                          ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define PX_IN_IN11_mask_b1                          ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_IN_IN10_mask_w                           ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define PX_IN_IN10_mask_h0                          ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define PX_IN_IN10_mask_b1                          ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_IN_IN9_mask_w                            ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define PX_IN_IN9_mask_h0                           ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PX_IN_IN9_mask_b1                           ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_IN_IN8_mask_w                            ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_IN_IN8_mask_h0                           ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_IN_IN8_mask_b1                           ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_IN_IN7_mask_w                            ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PX_IN_IN7_mask_h0                           ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PX_IN_IN7_mask_b0                           ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_IN_IN6_mask_w                            ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define PX_IN_IN6_mask_h0                           ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PX_IN_IN6_mask_b0                           ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_IN_IN5_mask_w                            ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PX_IN_IN5_mask_h0                           ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PX_IN_IN5_mask_b0                           ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_IN_IN4_mask_w                            ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PX_IN_IN4_mask_h0                           ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PX_IN_IN4_mask_b0                           ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_IN_IN3_mask_w                            ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define PX_IN_IN3_mask_h0                           ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PX_IN_IN3_mask_b0                           ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_IN_IN2_mask_w                            ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define PX_IN_IN2_mask_h0                           ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PX_IN_IN2_mask_b0                           ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_IN_IN1_mask_w                            ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PX_IN_IN1_mask_h0                           ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PX_IN_IN1_mask_b0                           ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_IN_IN0_mask_w                            ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_IN_IN0_mask_h0                           ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_IN_IN0_mask_b0                           ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_SC  [register's definitions]
 *              Offset[0x08]  PX port set / clear register (0x41000008)
 ******************************************************************************
 */
///@{
#define PX_SC_default                               ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PX_SC */
#define PX_SC_CLR15_mask_w                          ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR15_mask_h1                         ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR15_mask_b3                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR14_mask_w                          ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR14_mask_h1                         ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR14_mask_b3                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR13_mask_w                          ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR13_mask_h1                         ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR13_mask_b3                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR12_mask_w                          ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR12_mask_h1                         ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR12_mask_b3                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR11_mask_w                          ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR11_mask_h1                         ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR11_mask_b3                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR10_mask_w                          ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR10_mask_h1                         ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR10_mask_b3                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR9_mask_w                           ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR9_mask_h1                          ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR9_mask_b3                          ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR8_mask_w                           ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR8_mask_h1                          ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR8_mask_b3                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR7_mask_w                           ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR7_mask_h1                          ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR7_mask_b2                          ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR6_mask_w                           ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR6_mask_h1                          ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR6_mask_b2                          ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR5_mask_w                           ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR5_mask_h1                          ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR5_mask_b2                          ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR4_mask_w                           ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR4_mask_h1                          ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR4_mask_b2                          ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR3_mask_w                           ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR3_mask_h1                          ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR3_mask_b2                          ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR2_mask_w                           ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR2_mask_h1                          ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR2_mask_b2                          ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR1_mask_w                           ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR1_mask_h1                          ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR1_mask_b2                          ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_SC_CLR0_mask_w                           ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PX_SC_CLR0_mask_h1                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SC_CLR0_mask_b2                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SC_SET15_mask_w                          ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define PX_SC_SET15_mask_h0                         ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define PX_SC_SET15_mask_b1                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_SC_SET14_mask_w                          ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define PX_SC_SET14_mask_h0                         ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define PX_SC_SET14_mask_b1                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_SC_SET13_mask_w                          ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define PX_SC_SET13_mask_h0                         ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define PX_SC_SET13_mask_b1                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_SC_SET12_mask_w                          ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define PX_SC_SET12_mask_h0                         ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define PX_SC_SET12_mask_b1                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_SC_SET11_mask_w                          ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define PX_SC_SET11_mask_h0                         ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define PX_SC_SET11_mask_b1                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_SC_SET10_mask_w                          ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define PX_SC_SET10_mask_h0                         ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define PX_SC_SET10_mask_b1                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_SC_SET9_mask_w                           ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define PX_SC_SET9_mask_h0                          ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PX_SC_SET9_mask_b1                          ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_SC_SET8_mask_w                           ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_SC_SET8_mask_h0                          ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SC_SET8_mask_b1                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SC_SET7_mask_w                           ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PX_SC_SET7_mask_h0                          ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PX_SC_SET7_mask_b0                          ((uint8_t )0x80)        /*!< Bit Mask of 8bit */

#define PX_SC_SET6_mask_w                           ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define PX_SC_SET6_mask_h0                          ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PX_SC_SET6_mask_b0                          ((uint8_t )0x40)        /*!< Bit Mask of 8bit */

#define PX_SC_SET5_mask_w                           ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PX_SC_SET5_mask_h0                          ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PX_SC_SET5_mask_b0                          ((uint8_t )0x20)        /*!< Bit Mask of 8bit */

#define PX_SC_SET4_mask_w                           ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PX_SC_SET4_mask_h0                          ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PX_SC_SET4_mask_b0                          ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define PX_SC_SET3_mask_w                           ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define PX_SC_SET3_mask_h0                          ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PX_SC_SET3_mask_b0                          ((uint8_t )0x08)        /*!< Bit Mask of 8bit */

#define PX_SC_SET2_mask_w                           ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define PX_SC_SET2_mask_h0                          ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PX_SC_SET2_mask_b0                          ((uint8_t )0x04)        /*!< Bit Mask of 8bit */

#define PX_SC_SET1_mask_w                           ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PX_SC_SET1_mask_h0                          ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PX_SC_SET1_mask_b0                          ((uint8_t )0x02)        /*!< Bit Mask of 8bit */

#define PX_SC_SET0_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_SC_SET0_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SC_SET0_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_SCR0  [register's definitions]
 *              Offset[0x10]  PX port set and clear register 0 (0x41000010)
 ******************************************************************************
 */
///@{
#define PX_SCR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PX_SCR0 */
#define PX_SCR0_SC3_mask_w                          ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define PX_SCR0_SC3_mask_h1                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR0_SC3_mask_b3                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR0_SC2_mask_w                          ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PX_SCR0_SC2_mask_h1                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR0_SC2_mask_b2                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR0_SC1_mask_w                          ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_SCR0_SC1_mask_h0                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR0_SC1_mask_b1                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR0_SC0_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_SCR0_SC0_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR0_SC0_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_SCR1  [register's definitions]
 *              Offset[0x14]  PX port set and clear register 1 (0x41000014)
 ******************************************************************************
 */
///@{
#define PX_SCR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PX_SCR1 */
#define PX_SCR1_SC7_mask_w                          ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define PX_SCR1_SC7_mask_h1                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR1_SC7_mask_b3                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR1_SC6_mask_w                          ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PX_SCR1_SC6_mask_h1                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR1_SC6_mask_b2                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR1_SC5_mask_w                          ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_SCR1_SC5_mask_h0                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR1_SC5_mask_b1                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR1_SC4_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_SCR1_SC4_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR1_SC4_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_SCR2  [register's definitions]
 *              Offset[0x18]  PX port set and clear register 2 (0x41000018)
 ******************************************************************************
 */
///@{
#define PX_SCR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PX_SCR2 */
#define PX_SCR2_SC11_mask_w                         ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define PX_SCR2_SC11_mask_h1                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR2_SC11_mask_b3                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR2_SC10_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PX_SCR2_SC10_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR2_SC10_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR2_SC9_mask_w                          ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_SCR2_SC9_mask_h0                         ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR2_SC9_mask_b1                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR2_SC8_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_SCR2_SC8_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR2_SC8_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_SCR3  [register's definitions]
 *              Offset[0x1C]  PX port set and clear register 3 (0x4100001C)
 ******************************************************************************
 */
///@{
#define PX_SCR3_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PX_SCR3 */
#define PX_SCR3_SC15_mask_w                         ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define PX_SCR3_SC15_mask_h1                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR3_SC15_mask_b3                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR3_SC14_mask_w                         ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PX_SCR3_SC14_mask_h1                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR3_SC14_mask_b2                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR3_SC13_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PX_SCR3_SC13_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PX_SCR3_SC13_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define PX_SCR3_SC12_mask_w                         ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PX_SCR3_SC12_mask_h0                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PX_SCR3_SC12_mask_b0                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PX_CR  [register's definitions]
 *              Pin IO Mode/AFS Register Control Definitions
 ******************************************************************************
 */
///@{
#define PX_CR_LCK_mask_w                            ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define PX_CR_LCK_mask_h1                           ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define PX_CR_LCK_mask_b3                           ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PX_CR_LCK_locked_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define PX_CR_LCK_locked_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define PX_CR_LCK_locked_b3                         ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define PX_CR_LCK_un_locked_w                       ((uint32_t)0x80000000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define PX_CR_LCK_un_locked_h1                      ((uint16_t)0x8000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define PX_CR_LCK_un_locked_b3                      ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define PX_CR_ODC_mask_w                            ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define PX_CR_ODC_mask_h1                           ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define PX_CR_ODC_mask_b2                           ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define PX_CR_ODC_level0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Level0 of 32bit */
#define PX_CR_ODC_level0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Level0 of 16bit */
#define PX_CR_ODC_level0_b2                         ((uint8_t )0x00)        /*!< Bit Value =(0x0):Level0 of 8bit */
#define PX_CR_ODC_level1_w                          ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Level1 of 32bit */
#define PX_CR_ODC_level1_h1                         ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Level1 of 16bit */
#define PX_CR_ODC_level1_b2                         ((uint8_t )0x01)        /*!< Bit Value =(0x1):Level1 of 8bit */
#define PX_CR_ODC_level2_w                          ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Level2 of 32bit */
#define PX_CR_ODC_level2_h1                         ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Level2 of 16bit */
#define PX_CR_ODC_level2_b2                         ((uint8_t )0x02)        /*!< Bit Value =(0x2):Level2 of 8bit */
#define PX_CR_ODC_level3_w                          ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):Level3 of 32bit */
#define PX_CR_ODC_level3_h1                         ((uint16_t)0x0003)      /*!< Bit Value =(0x3):Level3 of 16bit */
#define PX_CR_ODC_level3_b2                         ((uint8_t )0x03)        /*!< Bit Value =(0x3):Level3 of 8bit */
#define PX_CR_ODC_level4_w                          ((uint32_t)0x00040000)  /*!< Bit Value =(0x4):Level4 of 32bit */
#define PX_CR_ODC_level4_h1                         ((uint16_t)0x0004)      /*!< Bit Value =(0x4):Level4 of 16bit */
#define PX_CR_ODC_level4_b2                         ((uint8_t )0x04)        /*!< Bit Value =(0x4):Level4 of 8bit */

#define PX_CR_AFS_mask_w                            ((uint32_t)0x0000F000)  /*!< Bit Mask of 32bit */
#define PX_CR_AFS_mask_h0                           ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define PX_CR_AFS_mask_b1                           ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define PX_CR_AFS_af0_w                             ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):AF0 of 32bit */
#define PX_CR_AFS_af0_h0                            ((uint16_t)0x0000)      /*!< Bit Value =(0x0):AF0 of 16bit */
#define PX_CR_AFS_af0_b1                            ((uint8_t )0x00)        /*!< Bit Value =(0x0):AF0 of 8bit */
#define PX_CR_AFS_af1_w                             ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):AF1 of 32bit */
#define PX_CR_AFS_af1_h0                            ((uint16_t)0x1000)      /*!< Bit Value =(0x1):AF1 of 16bit */
#define PX_CR_AFS_af1_b1                            ((uint8_t )0x10)        /*!< Bit Value =(0x1):AF1 of 8bit */
#define PX_CR_AFS_af2_w                             ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):AF2 of 32bit */
#define PX_CR_AFS_af2_h0                            ((uint16_t)0x2000)      /*!< Bit Value =(0x2):AF2 of 16bit */
#define PX_CR_AFS_af2_b1                            ((uint8_t )0x20)        /*!< Bit Value =(0x2):AF2 of 8bit */
#define PX_CR_AFS_af3_w                             ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):AF3 of 32bit */
#define PX_CR_AFS_af3_h0                            ((uint16_t)0x3000)      /*!< Bit Value =(0x3):AF3 of 16bit */
#define PX_CR_AFS_af3_b1                            ((uint8_t )0x30)        /*!< Bit Value =(0x3):AF3 of 8bit */
#define PX_CR_AFS_af4_w                             ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):AF4 of 32bit */
#define PX_CR_AFS_af4_h0                            ((uint16_t)0x4000)      /*!< Bit Value =(0x4):AF4 of 16bit */
#define PX_CR_AFS_af4_b1                            ((uint8_t )0x40)        /*!< Bit Value =(0x4):AF4 of 8bit */
#define PX_CR_AFS_af5_w                             ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):AF5 of 32bit */
#define PX_CR_AFS_af5_h0                            ((uint16_t)0x5000)      /*!< Bit Value =(0x5):AF5 of 16bit */
#define PX_CR_AFS_af5_b1                            ((uint8_t )0x50)        /*!< Bit Value =(0x5):AF5 of 8bit */
#define PX_CR_AFS_af6_w                             ((uint32_t)0x00006000)  /*!< Bit Value =(0x6):AF6 of 32bit */
#define PX_CR_AFS_af6_h0                            ((uint16_t)0x6000)      /*!< Bit Value =(0x6):AF6 of 16bit */
#define PX_CR_AFS_af6_b1                            ((uint8_t )0x60)        /*!< Bit Value =(0x6):AF6 of 8bit */
#define PX_CR_AFS_af7_w                             ((uint32_t)0x00007000)  /*!< Bit Value =(0x7):AF7 of 32bit */
#define PX_CR_AFS_af7_h0                            ((uint16_t)0x7000)      /*!< Bit Value =(0x7):AF7 of 16bit */
#define PX_CR_AFS_af7_b1                            ((uint8_t )0x70)        /*!< Bit Value =(0x7):AF7 of 8bit */
#define PX_CR_AFS_af8_w                             ((uint32_t)0x00008000)  /*!< Bit Value =(0x8):AF8 of 32bit */
#define PX_CR_AFS_af8_h0                            ((uint16_t)0x8000)      /*!< Bit Value =(0x8):AF8 of 16bit */
#define PX_CR_AFS_af8_b1                            ((uint8_t )0x80)        /*!< Bit Value =(0x8):AF8 of 8bit */
#define PX_CR_AFS_af9_w                             ((uint32_t)0x00009000)  /*!< Bit Value =(0x9):AF9 of 32bit */
#define PX_CR_AFS_af9_h0                            ((uint16_t)0x9000)      /*!< Bit Value =(0x9):AF9 of 16bit */
#define PX_CR_AFS_af9_b1                            ((uint8_t )0x90)        /*!< Bit Value =(0x9):AF9 of 8bit */
#define PX_CR_AFS_af10_w                            ((uint32_t)0x0000A000)  /*!< Bit Value =(0xA):AF10 of 32bit */
#define PX_CR_AFS_af10_h0                           ((uint16_t)0xA000)      /*!< Bit Value =(0xA):AF10 of 16bit */
#define PX_CR_AFS_af10_b1                           ((uint8_t )0xA0)        /*!< Bit Value =(0xA):AF10 of 8bit */
#define PX_CR_AFS_af11_w                            ((uint32_t)0x0000B000)  /*!< Bit Value =(0xB):AF11 of 32bit */
#define PX_CR_AFS_af11_h0                           ((uint16_t)0xB000)      /*!< Bit Value =(0xB):AF11 of 16bit */
#define PX_CR_AFS_af11_b1                           ((uint8_t )0xB0)        /*!< Bit Value =(0xB):AF11 of 8bit */

#define PX_CR_FDIV_mask_w                           ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define PX_CR_FDIV_mask_h0                          ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define PX_CR_FDIV_mask_b1                          ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define PX_CR_FDIV_bypass_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Bypass of 32bit */
#define PX_CR_FDIV_bypass_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Bypass of 16bit */
#define PX_CR_FDIV_bypass_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):Bypass of 8bit */
#define PX_CR_FDIV_div1_w                           ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):Div1 of 32bit */
#define PX_CR_FDIV_div1_h0                          ((uint16_t)0x0400)      /*!< Bit Value =(0x1):Div1 of 16bit */
#define PX_CR_FDIV_div1_b1                          ((uint8_t )0x04)        /*!< Bit Value =(0x1):Div1 of 8bit */
#define PX_CR_FDIV_div4_w                           ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):Div4 of 32bit */
#define PX_CR_FDIV_div4_h0                          ((uint16_t)0x0800)      /*!< Bit Value =(0x2):Div4 of 16bit */
#define PX_CR_FDIV_div4_b1                          ((uint8_t )0x08)        /*!< Bit Value =(0x2):Div4 of 8bit */
#define PX_CR_FDIV_div16_w                          ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):Div16 of 32bit */
#define PX_CR_FDIV_div16_h0                         ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):Div16 of 16bit */
#define PX_CR_FDIV_div16_b1                         ((uint8_t )0x0C)        /*!< Bit Value =(0x3):Div16 of 8bit */

#define PX_CR_INV_mask_w                            ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PX_CR_INV_mask_h0                           ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PX_CR_INV_mask_b0                           ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PX_CR_INV_disable_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PX_CR_INV_disable_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PX_CR_INV_disable_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PX_CR_INV_enable_w                          ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define PX_CR_INV_enable_h0                         ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define PX_CR_INV_enable_b0                         ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define PX_CR_PU_mask_w                             ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PX_CR_PU_mask_h0                            ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PX_CR_PU_mask_b0                            ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PX_CR_PU_disable_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PX_CR_PU_disable_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PX_CR_PU_disable_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PX_CR_PU_enable_w                           ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PX_CR_PU_enable_h0                          ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PX_CR_PU_enable_b0                          ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define PX_CR_HS_mask_w                             ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define PX_CR_HS_mask_h0                            ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PX_CR_HS_mask_b0                            ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define PX_CR_HS_disable_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PX_CR_HS_disable_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PX_CR_HS_disable_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PX_CR_HS_enable_w                           ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define PX_CR_HS_enable_h0                          ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define PX_CR_HS_enable_b0                          ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define PX_CR_IOM_mask_w                            ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define PX_CR_IOM_mask_h0                           ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define PX_CR_IOM_mask_b0                           ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define PX_CR_IOM_aio_w                             ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):AIO of 32bit */
#define PX_CR_IOM_aio_h0                            ((uint16_t)0x0000)      /*!< Bit Value =(0x0):AIO of 16bit */
#define PX_CR_IOM_aio_b0                            ((uint8_t )0x00)        /*!< Bit Value =(0x0):AIO of 8bit */
#define PX_CR_IOM_odo_w                             ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):ODO of 32bit */
#define PX_CR_IOM_odo_h0                            ((uint16_t)0x0001)      /*!< Bit Value =(0x1):ODO of 16bit */
#define PX_CR_IOM_odo_b0                            ((uint8_t )0x01)        /*!< Bit Value =(0x1):ODO of 8bit */
#define PX_CR_IOM_ppo_w                             ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):PPO of 32bit */
#define PX_CR_IOM_ppo_h0                            ((uint16_t)0x0002)      /*!< Bit Value =(0x2):PPO of 16bit */
#define PX_CR_IOM_ppo_b0                            ((uint8_t )0x02)        /*!< Bit Value =(0x2):PPO of 8bit */
#define PX_CR_IOM_din_w                             ((uint32_t)0x00000003)  /*!< Bit Value =(0x3):DIN of 32bit */
#define PX_CR_IOM_din_h0                            ((uint16_t)0x0003)      /*!< Bit Value =(0x3):DIN of 16bit */
#define PX_CR_IOM_din_b0                            ((uint8_t )0x03)        /*!< Bit Value =(0x3):DIN of 8bit */
#define PX_CR_IOM_qb_w                              ((uint32_t)0x00000004)  /*!< Bit Value =(0x4):QB of 32bit */
#define PX_CR_IOM_qb_h0                             ((uint16_t)0x0004)      /*!< Bit Value =(0x4):QB of 16bit */
#define PX_CR_IOM_qb_b0                             ((uint8_t )0x04)        /*!< Bit Value =(0x4):QB of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PA  [register's definitions]
 *              Port IO Mode/AFS Register Control Definitions
 ******************************************************************************
 */
///@{

/**********************  PA_CR0  [register's definitions]**********************/
/*!< Offset[0x00]  PA0 IO control register (0x44000000) */
#define PA_CR0_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_CR1  [register's definitions]**********************/
/*!< Offset[0x04]  PA1 IO control register (0x44000004) */
#define PA_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_CR2  [register's definitions]**********************/
/*!< Offset[0x08]  PA2 IO control register (0x44000008) */
#define PA_CR2_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_CR3  [register's definitions]**********************/
/*!< Offset[0x0C]  PA3 IO control register (0x4400000C) */
#define PA_CR3_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_CR8  [register's definitions]**********************/
/*!< Offset[0x20]  PA8 IO control register (0x44000020) */
#define PA_CR8_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_CR9  [register's definitions]**********************/
/*!< Offset[0x24]  PA9 IO control register (0x44000024) */
#define PA_CR9_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PA_CR10  [register's definitions]**********************/
/*!< Offset[0x28]  PA10 IO control register (0x44000028) */
#define PA_CR10_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PA_CR11  [register's definitions]**********************/
/*!< Offset[0x2C]  PA11 IO control register (0x4400002C) */
#define PA_CR11_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PA_FLT  [register's definitions]**********************/
/*!< Offset[0x40]  PA port input filter control register (0x44000040) */
#define PA_FLT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */
///@}
/**
 ******************************************************************************
 * @name        PB  [register's definitions]
 *              Port IO Mode/AFS Register Control Definitions
 ******************************************************************************
 */
///@{

/**********************  PB_CR0  [register's definitions]**********************/
/*!< Offset[0x00]  PB0 IO control register (0x44010000) */
#define PB_CR0_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_CR1  [register's definitions]**********************/
/*!< Offset[0x04]  PB1 IO control register (0x44010004) */
#define PB_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_CR2  [register's definitions]**********************/
/*!< Offset[0x08]  PB2 IO control register (0x44010008) */
#define PB_CR2_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_CR3  [register's definitions]**********************/
/*!< Offset[0x0C]  PB3 IO control register (0x4401000C) */
#define PB_CR3_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_CR8  [register's definitions]**********************/
/*!< Offset[0x20]  PB8 IO control register (0x44010020) */
#define PB_CR8_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_CR9  [register's definitions]**********************/
/*!< Offset[0x24]  PB9 IO control register (0x44010024) */
#define PB_CR9_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PB_CR10  [register's definitions]**********************/
/*!< Offset[0x28]  PB10 IO control register (0x44010028) */
#define PB_CR10_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PB_CR11  [register's definitions]**********************/
/*!< Offset[0x2C]  PB11 IO control register (0x4401002C) */
#define PB_CR11_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PB_FLT  [register's definitions]**********************/
/*!< Offset[0x40]  PB port input filter control register (0x44010040) */
#define PB_FLT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */
///@}
/**
 ******************************************************************************
 * @name        PC  [register's definitions]
 *              Port IO Mode/AFS Register Control Definitions
 ******************************************************************************
 */
///@{

/**********************  PC_CR0  [register's definitions]**********************/
/*!< Offset[0x00]  PC0 IO control register (0x44020000) */
#define PC_CR0_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PC_CR1  [register's definitions]**********************/
/*!< Offset[0x04]  PC1 IO control register (0x44020004) */
#define PC_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PC_CR4  [register's definitions]**********************/
/*!< Offset[0x10]  PC4 IO control register (0x44020010) */
#define PC_CR4_default                              ((uint32_t)0x00000024)  /*!< Reg Reset Default Value */

/**********************  PC_CR5  [register's definitions]**********************/
/*!< Offset[0x14]  PC5 IO control register (0x44020014) */
#define PC_CR5_default                              ((uint32_t)0x00000024)  /*!< Reg Reset Default Value */

/**********************  PC_CR6  [register's definitions]**********************/
/*!< Offset[0x18]  PC6 IO control register (0x44020018) */
#define PC_CR6_default                              ((uint32_t)0x00000024)  /*!< Reg Reset Default Value */

/**********************  PC_CR8  [register's definitions]**********************/
/*!< Offset[0x20]  PC8 IO control register (0x44020020) */
#define PC_CR8_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PC_CR9  [register's definitions]**********************/
/*!< Offset[0x24]  PC9 IO control register (0x44020024) */
#define PC_CR9_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PC_CR13  [register's definitions]**********************/
/*!< Offset[0x34]  PC13 IO control register (0x44020034) */
#define PC_CR13_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/*********************  PC_CR14  [register's definitions]**********************/
/*!< Offset[0x38]  PC14 IO control register (0x44020038) */
#define PC_CR14_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PC_FLT  [register's definitions]**********************/
/*!< Offset[0x40]  PC port input filter control register (0x44020040) */
#define PC_FLT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */
///@}
/**
 ******************************************************************************
 * @name        PD  [register's definitions]
 *              Port IO Mode/AFS Register Control Definitions
 ******************************************************************************
 */
///@{

/**********************  PD_CR0  [register's definitions]**********************/
/*!< Offset[0x00]  PD0 IO control register (0x44030000) */
#define PD_CR0_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PD_CR1  [register's definitions]**********************/
/*!< Offset[0x04]  PD1 IO control register (0x44030004) */
#define PD_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PD_CR2  [register's definitions]**********************/
/*!< Offset[0x08]  PD2 IO control register (0x44030008) */
#define PD_CR2_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PD_CR7  [register's definitions]**********************/
/*!< Offset[0x1C]  PD7 IO control register (0x4403001C) */
#define PD_CR7_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/**********************  PD_FLT  [register's definitions]**********************/
/*!< Offset[0x40]  PD port input filter control register (0x44030040) */
#define PD_FLT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */
///@}

#endif  // _MG32_GPIO_H

/*----------------------------------------------------------------------------*/
/*                          End of file MG32_GPIO.h                           */
/*----------------------------------------------------------------------------*/
