

/**
 ******************************************************************************
 *
 * @file        BSP_Buzzer.c
 * @brief       This is Buzzer C file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/04/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/*==============================================================================
                                 User Notes
How To use this function:
-----------------------
    1. Use BSP_Buzzer_Init() function to inital
    2. Use BSP_Buzzer_Cmd() function to control Buzzer "ON"/"OFF"
        (1). ENABLE : Buzzer ON.
        (2). DISABLE: Buzzer OFF.
       ,or Use BSP_BUZZER_OFF() and BSP_BUZZER_ON() to control Buzzer "ON"/"OFF"
        
Driver architecture:
--------------------
    + MG32_GPIO_DRV
   
Known Limitations:
------------------

Require parameter
------------------
    Require module : CSC / GPIO
    
    GPIO pin configuration : 
        Pin / IO mode / AFS
        ---  --------  -----
        PB0 / PPO     / GPIO
        
Example codes:
------------------

==============================================================================*/

/* Includes ------------------------------------------------------------------*/
#include "BSP_10_Buzzer.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define BUZZER_IOM           IOMB                   /*!< Buzzer GPIO port.*/
#define BUZZER_PIN           PX_Pin_9               /*!< Buzzer GPIO pin.*/
#define BUZZER_PIN_MODE      PINX_Mode_PushPull_O   /*!< Buzzer GPIO mode*/
#define BUZZER_PIN_AFS       0                      /*!< Buzzer GPIO alternate function.*/

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    Buzzer inital.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void BSP_Buzzer_Init(void)
{
    PIN_InitTypeDef       Buzzer_Pin;
    
    //=========================================================================
    // initial PA2 with PPO mode. (GPIO)
    BSP_BUZZER_OFF();
    
    Buzzer_Pin.PINX_Pin                = BUZZER_PIN;
    Buzzer_Pin.PINX_Mode               = BUZZER_PIN_MODE;
    Buzzer_Pin.PINX_PUResistant        = PINX_PUResistant_Disable;
    Buzzer_Pin.PINX_Speed              = PINX_Speed_Low;
    Buzzer_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    Buzzer_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    Buzzer_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    Buzzer_Pin.PINX_Alternate_Function = BUZZER_PIN_AFS;                          
    GPIO_PortMode_Config( BUZZER_IOM ,&Buzzer_Pin);

}
/**
 *******************************************************************************
 * @brief	  Buzzer main flow.
 * @details   
 * @param[in] Buzzer_EN: Control Buzzer "ON" or "OFF"
 *  @arg\b    DISABLE: Buzzer OFF.
 *  @arg\b    ENABLE : Buzzer ON.
 * @return     
 * @exception No 
 * @note      No
 *******************************************************************************
 */
void BSP_Buzzer_Cmd(FunctionalState Buzzer_EN)
{
    if( Buzzer_EN == ENABLE)
    {
        BSP_BUZZER_ON();
    }
    else
    {
        BSP_BUZZER_OFF();
    }
}






