

/**
 ******************************************************************************
 *
 * @file        BSP_2ColorDotMatrixLED.h
 * @brief       This is two color dot matrix LED H file.
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/04/20
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _BSP_2COLORDOTMATRIXLED_H

#define _BSP_2COLORDOTMATRIXLED_H


#include "MG32.h"
#include "MG32_GPIO_DRV.h"


/**
 * @name typedef
 *   		
 */ 
///@{

#define DOTLED_DISABLE   0x0         /*!< Black state.*/
#define DOTLED_RED       0x1         /*!< Turn Red LED.*/
#define DOTLED_GREEN     0x2         /*!< Turn Green LED.*/
#define DOTLED_ORANGE    0x3         /*!< Turn Orange LED (Red + Green).*/

///@}

/**
 * @name	============== Function ==============
 *   		
 */ 
///@{
void BSP_2ColorDotMatrixLED_Init(void);
void BSP_2ColorDotMatrixLED_RefreshFrame(uint8_t *pDotLED_Buf);
void BSP_2ColorDotMatrixLED_main(void);
///@}

#endif






