

 /**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       main file in the project.
 *
 * @par         Project
 *              MG32F02N128
 * @version     V1.00
 * @date        2025/04/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_ChipInit.h"
#include "Sample_GPIO.h"
#include "Sample_CAN.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define SMP0_TX_ID    0x04843
#define SMP0_TX_IDE   1
#define SMP0_TX_DLC   8

#define SMP1_TX_ID    0x055
#define SMP1_TX_IDE   0
#define SMP1_TX_DLC   8



/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static uint8_t SMP0_TX_Buf[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
static uint8_t SMP1_TX_Buf[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	   main function  
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */
int main(void)
{
    uint8_t main_tmp;   
    
    /*Chip Initial
      1. APB = 48 MHz
      2. AHB = 24 MHz
    */
    ChipInit();
    
    /*Button initial*/
    Button_Initial();
    
    /*LED initial*/
    LED_Initial();
    
    /*CAN module initial*/
    CAN_Initial();

    while(1)
    {
        if( BUTTON0 == 0)
        {
            Button_Button0SimpleDebounce();
            
            main_tmp = CAN_TransmitDataFrame(SMP0_TX_ID,  SMP0_TX_IDE, SMP0_TX_DLC, SMP0_TX_Buf );
            if( main_tmp == SMP_CAN_TX_BUSY)
            {
                //All TX message buffer busy to do...
            }
        }
        if( BUTTON1 == 0)
        {
            Button_Button1SimpleDebounce();
                     
            main_tmp = CAN_TransmitDataFrame(SMP1_TX_ID,  SMP1_TX_IDE, SMP1_TX_DLC, SMP1_TX_Buf );
            if( main_tmp == SMP_CAN_TX_BUSY)
            {
                //All TX message buffer busy to do...
            }
        }
    }
}


/**
 *******************************************************************************
 * @brief	    RX FIFO0 receive IRQ handler
 * @details     
 * @param[in]   CAN_Rx1Cplt_Frame : RX FIFO0 receive frame.
 * @return      No.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
//void CAN_RxFIFO0_CpltCallback(CAN_RXBuf_TypeDef CAN_Rx1Cplt_Frame)
//{
//    uint32_t  CAN_Rx0Cplt_ID;
//    uint8_t   CAN_Rx0Cplt_TXBufStatus; 

//    if( CAN_Rx1Cplt_Frame.Format.Field.IDE == 0)
//    {
//        CAN_Rx0Cplt_ID = CAN_Rx1Cplt_Frame.Format.Field.SID;
//    }
//    else
//    {
//        CAN_Rx0Cplt_ID = (((CAN_Rx1Cplt_Frame.Format.Field.SID<<18) & 0x1FFC0000) | CAN_Rx1Cplt_Frame.Format.Field.EID);
////        CAN_Rx0Cplt_ID = ( CAN_Rx1Cplt_Frame.Format.W[0] & 0x1FFFFFFF);
//    }
//    
//    if( CAN_Rx1Cplt_Frame.Format.Field.RTR == 0)
//    {
//        CAN_Rx0Cplt_TXBufStatus = CAN_TransmitDataFrame(CAN_Rx0Cplt_ID,
//                                  CAN_Rx1Cplt_Frame.Format.Field.IDE,
//                                  CAN_Rx1Cplt_Frame.Format.Field.DLC,
//                                  CAN_Rx1Cplt_Frame.Format.Field.Data);
//    }
//    else
//    {
//        CAN_Rx0Cplt_TXBufStatus = CAN_TransmitRemoteFrame(CAN_Rx0Cplt_ID,
//                                  CAN_Rx1Cplt_Frame.Format.Field.IDE,
//                                  CAN_Rx1Cplt_Frame.Format.Field.DLC);
//    }
//    
//    if( CAN_Rx0Cplt_TXBufStatus == SMP_CAN_TX_BUSY)
//    {
//        //TX Buffer all busy to do...
//    }
//}


/**
 *******************************************************************************
 * @brief	    RX FIFO1 receive IRQ handler
 * @details     
 * @param[in]   CAN_Rx1Cplt_Frame : RX FIFO1 receive frame.
 * @return      No.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
//void CAN_RxFIFO1_CpltCallback(CAN_RXBuf_TypeDef CAN_Rx1Cplt_Frame)
//{
//    uint32_t  CAN_Rx0Cplt_ID;
//    uint8_t   CAN_Rx0Cplt_TXBufStatus; 

//    if( CAN_Rx1Cplt_Frame.Format.Field.IDE == 0)
//    {
//        CAN_Rx0Cplt_ID = CAN_Rx1Cplt_Frame.Format.Field.SID;
//    }
//    else
//    {
//        CAN_Rx0Cplt_ID = (((CAN_Rx1Cplt_Frame.Format.Field.SID<<18) & 0x1FFC0000) | CAN_Rx1Cplt_Frame.Format.Field.EID);
////        CAN_Rx0Cplt_ID = ( CAN_Rx1Cplt_Frame.Format.W[0] & 0x1FFFFFFF);
//    }
//    
//    if( CAN_Rx1Cplt_Frame.Format.Field.RTR == 0)
//    {
//        CAN_Rx0Cplt_TXBufStatus = CAN_TransmitDataFrame(CAN_Rx0Cplt_ID,
//                                  CAN_Rx1Cplt_Frame.Format.Field.IDE,
//                                  CAN_Rx1Cplt_Frame.Format.Field.DLC,
//                                  CAN_Rx1Cplt_Frame.Format.Field.Data);
//    }
//    else
//    {
//        CAN_Rx0Cplt_TXBufStatus = CAN_TransmitRemoteFrame(CAN_Rx0Cplt_ID,
//                                  CAN_Rx1Cplt_Frame.Format.Field.IDE,
//                                  CAN_Rx1Cplt_Frame.Format.Field.DLC);
//    }
//    
//    if( CAN_Rx0Cplt_TXBufStatus == SMP_CAN_TX_BUSY)
//    {
//        //TX Buffer all busy to do...
//    }
//}

/**
 *******************************************************************************
 * @brief	    TX Buffer call back function.
 * @details     
 * @param[in]   CAN_TxBuf_Index : TX message buffer inedex number
 * @return      No.
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void CAN_TXBuf_CpltCallback(CAN_TXIndex_TypeDef CAN_TxBuf_Index)
{
    uint32_t CAN_TXBuf_CpltTmp;
    
    CAN_TXBuf_CpltTmp = CAN_GetTXBufferStatus(CAN_Module,CAN_TxBuf_Index);
    
    /*Transmit success*/
    if( CAN_TXBuf_CpltTmp == CAN_TRANSMIT_STATE_SUCCESS)
    {
        LED_G = LED_ON;
    }
}


