/**
 ******************************************************************************
 *
 * @file        MG32_URT.h
 *
 * @brief       MG32 URT Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.01 (Register File Date : 2025_0401)
 * @date        2025/06/16 10:22 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_URT_H
#define _MG32_URT_H
#define _MG32_URT_H_VER                             101     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_URT_H_VER)
    #error "_MG32_URT_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      URT_Struct
 *              URT  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RHF           :1;     //[0] UART receive hold flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  UGF           :1;     //[1] UART general event flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TCF           :1;     //[2] UART transmission complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ERRF          :1;     //[3] UART error interrupt flag for parity error, frame error, overrun error, receive time 
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  LSF           :1;     //[4] UART line statue flag for break condition, idle line, CTS detect
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  RXDF          :1;     //[5] UART received data byte number is different from previous received data byte number f
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RXF           :1;     //[6] UART receive data register not empty
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXF           :1;     //[7] UART transmit data register empty
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  SADRF         :1;     //[10] UART slave address matched flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BRTF          :1;     //[11] UART baud-rate generator timer timeout flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TMOF          :1;     //[12] UART timeout timer timeout flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CALCF         :1;     //[13] UART auto baud-rate calibration complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  CALUDF        :1;     //[14] UART auto baud-rate calibration underflow status flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  CALOVF        :1;     //[15] UART auto baud-rate calibration overflow status flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BKF           :1;     //[16] UART break condition detect flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  IDLF          :1;     //[17] UART idle line detect flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CTSF          :1;     //[18] UART CTS change detect interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  NSSF          :1;     //[19] UART SPI slave mode NSS signal inactive detect interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PEF           :1;     //[20] UART parity error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  FEF           :1;     //[21] UART frame error flag.  (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  NCEF          :1;     //[22] UART receive noised character error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  ROVRF         :1;     //[23] UART receive overrun error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TXEF          :1;     //[24] UART TX error detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TUDRF         :1;     //[25] UART SPI slave mode transmit underrun flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[26] 
            __IO uint8_t  RXTMOF        :1;     //[27] UART receive time out flag.  (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  IDTMOF        :1;     //[28] UART idle state time out flag.  (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  BKTMOF        :1;     //[29] UART break receive time out flag.  (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  CALTMOF       :1;     //[30] UART auto baud-rate calibration sync field receive time-out time out flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  URT status register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] UART interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  UG_IE         :1;     //[1] UART general event interrupt enable for URTx_SADRF , URTx_TF , URTx_RCNTF or URTx_TCN
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TC_IE         :1;     //[2] UART transmission complete interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ERR_IE        :1;     //[3] UART error interrupt enable for parity error, frame error, overrun error, receive tim
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LS_IE         :1;     //[4] UART line statue flag for break condition, idle line, CTS detect.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  RX_IE         :1;     //[6] UART receive data register not empty interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_IE         :1;     //[7] UART transmit data register empty interrupt enable. Refer to URTx_TXF for the detail.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __IO uint8_t  SADR_IE       :1;     //[10] UART slave address matched interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BRT_IE        :1;     //[11] UART baud-rate generator timer timeout interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_IE        :1;     //[12] UART timeout timer timeout interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CALC_IE       :1;     //[13] UART auto baud-rate calibration complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  BK_IE         :1;     //[16] UART break condition detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IDL_IE        :1;     //[17] UART idle line detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CTS_IE        :1;     //[18] UART CTS change detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSS_IE        :1;     //[19] UART SPI slave mode NSS signal inactive detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PE_IE         :1;     //[20] UART parity error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  FE_IE         :1;     //[21] UART frame error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NCE_IE        :1;     //[22] UART receive noised character interrupt enable. 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ROVR_IE       :1;     //[23] UART receive overrun error interrupt enable. Refer to URTx_ROVRF for the detail.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXE_IE        :1;     //[24] UART TX error detect interrupt enable. Refer to URTx_TXE_MDS for detail.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TUDR_IE       :1;     //[25] UART SPI slave mode transmit underrun interrupt enable. 
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[26] 
            __IO uint8_t  RXTMO_IE      :1;     //[27] UART receive time out interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IDTMO_IE      :1;     //[28] UART idle state time out interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKTMO_IE      :1;     //[29] UART break receive time out interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CALTMO_IE     :1;     //[30] UART auto baud-rate calibration sync field receive time-out time out interrupt enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  UART interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  CK_SEL        :3;     //[3..1] UART internal clock CK_URTx source select.
                                        //0x0 = PROC : CK_URTx_PR process clock from CSC
                                        //0x1 = NCO_P0
                                        //0x2 = CK_LS
                                        //0x3 = TM00_TRGO
                                        //0x4 = EXT_CLK (external clock from URTx_ECK signal)
            __IO uint8_t  CLK_EN        :1;     //[4] URTx_CLK signal output enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CLK_CKS       :1;     //[5] UART external clock output source select.
                                        //0 = OUT : CK_URTx_OUT from clock output divider
                                        //1 = SC : CK_URTx_SC from clock  input prescaler
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  ECK_CKS       :1;     //[7] UART external clock IO select
                                        //0 = CLK : URTx_CLK pin
                                        //1 = RX : receiving signal
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  RX_CKS        :2;     //[17..16] UART receive clock source select.
                                        //0x0 = Internal : UART internal clock source CK_URTx_INT
                                        //0x1 = TM01_TRGO
                                        //0x2 = TM10_TRGO
                                        //0x3 = EXT_CLK (external clock from URTx_CLK pin)
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  TX_CKS        :2;     //[21..20] UART transmission clock source select.
                                        //0x0 = Internal : UART internal clock source CK_URTx_INT
                                        //0x1 = TM01_TRGO
                                        //0x2 = TM10_TRGO
                                        //0x3 = EXT_CLK (external clock from URTx_CLK pin)
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  BR_EN         :1;     //[24] UART baud-rate timer enable. When enables, the baud-rate timer 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BR_MDS        :1;     //[25] UART baud-rate timer mode select
                                        //0 = Separated : Separated PSC and CNT counters for UART baud-rate generator
                                        //1 = Combined : Combine to a linear counter for general using timer
            __IO uint8_t  BRO_STA       :1;     //[26] UART baud-rate timer timeout signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  BRO_LCK       :1;     //[27] UART baud-rate timer timeout signal initial state control
                                        //0 = Locked
                                        //1 = Un-Locked
            __IO uint8_t  CKO_STA       :1;     //[28] UART PSC clock output signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  CKO_LCK       :1;     //[29] UART PSC clock output signal initial state control
                                        //0 = Locked
                                        //1 = Un-Locked
            __IO uint8_t  BR_CKS        :1;     //[30] UART baud-rate timer clock source select.
                                        //0 = PSC : CK_URTx_PSC from clock prescaler output
                                        //1 = CK_URTx : CK_URTx from UART internal clock input 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  URT clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BUSYF         :1;     //[0] UART RX busy flag
                                        //0 = Normal (No event occurred)
                                        //1 = Busy (Event happened)
            __I  uint8_t  PAR           :1;     //[1] UART data receive parity bit of shift buffer
            __I  uint8_t  ADR           :1;     //[2] UART data receive slave address bit of shift buffer.
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t  NCF           :1;     //[5] UART receive noised character flag.  (set and clear by hardware)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  BKBF          :1;     //[6] UART send break busy flag.  (set and clear by hardware)
                                        //0 = Normal (No break transmitted or transmit finished)
                                        //1 = Busy (Event happened)
            __I  uint8_t  IR_BUSYF      :1;     //[7] UART IrDA data received busy flag. 
                                        //0 = No (No IrDA signal detect)
                                        //1 = Busy (detect some IrDA signal)
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :2;     //[11..10] 
            __I  uint8_t  CTS           :1;     //[12] UART CTS line status bit
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t  RX_LVL        :3;     //[26..24] UART data buffer received level indications.
                                        //0x0 = 0 (0-byte,empty)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t  TX_LVL        :3;     //[30..28] UART data buffer transmission remained level indications.
                                        //0x0 = 0 (0-byte,empty)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }STA2;                              /*!< STA2       ~ Offset[0x0C]  URT status register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] UART function enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OS_MDS        :1;     //[1] UART RX data oversampling majority vote select.
                                        //0 = Three : Three sample bits method
                                        //1 = One : One sample bit method and noise free
            __IO uint8_t  HDX_EN        :1;     //[2] UART Half-duplex mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DAT_LINE      :1;     //[3] UART communication data line select.
                                        //0 = 2 : 2-lines separated ~ URTx_RX , URTx_TX
                                        //1 = 1 : 1-line Bidirectional ~URTx_TX only.
            __IO uint8_t  MDS           :3;     //[6..4] UART mode select
                                        //0x0 = UART : UART mode
                                        //0x1 = SYNC : Synchronous/SPI mode
                                        //0x2 = IDLE : Idle-line mode for multi-processor
                                        //0x3 = ADR : Address-bit mode for multi-processor
            __IO uint8_t  GSA_EN        :1;     //[7] UART multi-processor global slave address enable.
            __IO uint8_t  IO_SWP        :1;     //[8] URTx_RX/URTx_TX swap enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SYNC_MDS      :1;     //[9] UART SYNC mode(SPI) select.
                                        //0 = Master : SPI Master
                                        //1 = Slave : SPI Slave
            __IO uint8_t  RX_INV        :1;     //[10] URTx_RX input signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_INV        :1;     //[11] URTx_TX output signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DE_EN         :1;     //[12] URTx_DE signal output enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DE_INV        :1;     //[13] URTx_DE signal inverse enable. The hardware DE output default is low level.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DE_GT         :2;     //[15..14] URTx_DE signal output guard time select by unit of bit time
                                        //0x0 = 1/4
                                        //0x1 = 1/2
                                        //0x2 = 1
                                        //0x3 = 2
            __IO uint8_t  RX_TH         :2;     //[17..16] UART data buffer high threshold for received access
                                        //0x0 = 1byte (default)
                                        //0x1 = 2byte
                                        //0x2 = 3byte
                                        //0x3 = 4byte
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  IDL_MDS       :1;     //[20] UART idle line detect management mode select
                                        //0 = No (No operation)
                                        //1 = Load (Force to load shadow buffer)
            __IO uint8_t  NCHAR_HE      :1;     //[21] UART receiving hold enable bit if receives a noised character
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NCHAR_DIS     :1;     //[22] UART receiving noised character disable bit
                                        //0 = Enable (Accept noised character)
                                        //1 = Disable (Skip noised character)
            __IO uint8_t  LBM_EN        :1;     //[23] UART loop back mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :2;     //[26..25] 
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t                :1;     //[28] 
            __IO uint8_t  DDTX_EN       :1;     //[29] Hardware force to disable DMA TX function enable bit when detects a break condition
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_RXEN      :1;     //[30] Direct memory access enable to receive
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  DMA_TXEN      :1;     //[31] Direct memory access enable to transmit
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  URT control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXDSIZE       :2;     //[1..0] UART RX data bit length
                                        //0x0 = 8bit
                                        //0x1 = 7bit
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __IO uint8_t  RXPAR_EN      :1;     //[2] UART RX parity bit enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXPAR_POL     :1;     //[3] UART RX parity bit polarity. This bit is no effect for SYNC mods.
                                        //0x0 = Even
                                        //0x1 = Odd
            __IO uint8_t  RXPAR_STK     :1;     //[4] UART stuck parity bit input enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXMSB_EN      :1;     //[5] UART RX data order Msb first enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXSTP_LEN     :2;     //[7..6] UART RX stop bit length select
                                        //0x0 = 0.5bit
                                        //0x1 = 1bit
                                        //0x2 = 1.5bit
                                        //0x3 = 2bit
            __IO uint8_t  RXOS_NUM      :5;     //[12..8] UART RX data oversampling samples select
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  TXDSIZE       :2;     //[17..16] UART TX data bit length
                                        //0x0 = 8bit
                                        //0x1 = 7bit
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __IO uint8_t  TXPAR_EN      :1;     //[18] UART TX parity bit enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXPAR_POL     :1;     //[19] UART TX parity bit polarity. This bit is no effect for SPI and SYNC mods.
                                        //0x0 = Even
                                        //0x1 = Odd
            __IO uint8_t  TXPAR_STK     :1;     //[20] UART stuck parity bit output enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXMSB_EN      :1;     //[21] UART TX data order Msb first enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TXSTP_LEN     :2;     //[23..22] UART TX stop bit length select
                                        //0x0 = 0.5bit
                                        //0x1 = 1bit
                                        //0x2 = 1.5bit
                                        //0x3 = 2bit
            __IO uint8_t  TXOS_NUM      :5;     //[28..24] UART TX data oversampling samples select
            __I  uint8_t                :2;     //[30..29] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  URT control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  BK_TX         :1;     //[0] UART break condition for next data transmitted
                                        //0 = Normal
                                        //1 = Send : Send Break
            __IO uint8_t  ADR_TX        :1;     //[1] UART slave address for next data transmitted
                                        //0 = Normal
                                        //1 = Send : Send Address
            __IO uint8_t  RX_EN         :1;     //[2] UART receiver enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_EN         :1;     //[3] UART transmitter enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TX_HALT       :1;     //[4] UART transmitter halt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[7..5] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  NSS_SWO       :1;     //[16] UART NSS signal software output control bit when URTx_NSS_SWEN is enable.
            __I  uint8_t  NSS_SWI       :1;     //[17] UART NSS signal software input status bit.
            __I  uint8_t                :6;     //[23..18] 
            __IO uint8_t  NSSI_INV      :1;     //[24] UART NSS input signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSS_INV       :1;     //[25] UART NSS output signal inverse enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSS_SWEN      :1;     //[26] UART NSS signal output set by software control function enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  NSSI_EN       :1;     //[27] UART NSS signal input function enable when UART configure to synchronous mode SPI Sla
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[28] 
            __IO uint8_t  DOUT_MDS      :1;     //[29] UART SPI master standard mode idle state data output mode select
                                        //0 = Disable : Output with tristate
                                        //1 = Enable : Output with driving
            __IO uint8_t  DOUT_IDL      :2;     //[31..30] UART SPI mode idle state data output value
                                        //0x0 = LBIT (Last data bit)
                                        //0x1 = Reserved
                                        //0x2 = 0 (Output 0)
                                        //0x3 = 1 (Output 1)
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  URT control register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  CPOL          :1;     //[1] UART clock polarity select. It is used to select the SPI clock level in idle state.
                                        //0 = Low
                                        //1 = High
            __IO uint8_t  CPHA          :1;     //[2] UART clock phase select
                                        //0 = Leading edge
                                        //1 = Trailing edge
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  DET_BK        :1;     //[4] UART bit time select for break detection or transmission
                                        //0x0 = 1Bit
                                        //0x1 = 3Bit
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  DET_IDL       :8;     //[15..8] UART idle line detect threshold value by using receive bit time
            __IO uint8_t  TXGT_LEN      :8;     //[23..16] UART TX guard time or idle-line length
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR3;                               /*!< CR3        ~ Offset[0x1C]  URT control register 3 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  RDAT_INV      :1;     //[4] UART inverse received data enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TDAT_INV      :1;     //[5] UART inverse transmitted data enable
                                        //0 = Disable
                                        //1 = Enable
            __O  uint8_t  RDAT_CLR      :1;     //[6] UART  received data clear enable
                                        //0 = Disable
                                        //1 = Enable
            __O  uint8_t  TDAT_CLR      :1;     //[7] UART  transmitted data clear enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RNUM          :3;     //[10..8] UART received data byte number when data shadow buffer last transfer to URTx_RDAT reg
                                        //0x0 = 0 (0-byte)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t  TNUM          :3;     //[14..12] UART remained data byte number in data register. Value 0~4 is valid only.
                                        //0x0 = 0 (0-byte)
                                        //0x1 = 1 (1-byte)
                                        //0x2 = 2 (2-byte)
                                        //0x3 = 3 (3-byte)
                                        //0x4 = 4 (4-byte)
            __I  uint8_t                :1;     //[15] 
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR4;                               /*!< CR4        ~ Offset[0x20]  URT control register 4 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RLR           :8;     //[7..0] UART baud-rate clock counter reload register
            __IO uint8_t  PSR           :6;     //[13..8] UART baud-rate clock prescaler reload register
            __I  uint8_t                :2;     //[15..14] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }RLR;                               /*!< RLR        ~ Offset[0x24]  URT baud-rate clock counter reload register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  CNT           :8;     //[7..0] UART baud-rate clock counter value register.
            __I  uint8_t  PSC           :6;     //[13..8] UART baud-rate clock prescaler value register.
            __I  uint8_t                :2;     //[15..14] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CNT;                               /*!< CNT        ~ Offset[0x28]  URT baud-rate clock counter register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RCAP_DAT      :8;     //[7..0] UART capture data from RX shift buffer for Parity error / Frame error / Break detect 
            __IO uint8_t  RCAP_STP      :1;     //[8] UART capture stop bit from RX shift buffer.
            __IO uint8_t  RCAP_PAR      :1;     //[9] UART capture parity bit from RX shift buffer.
            __IO uint8_t  RCAP_ADR      :1;     //[10] UART capture address bit from RX shift buffer.
            __I  uint8_t                :5;     //[15..11] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }RCAP;                              /*!< RCAP       ~ Offset[0x2C]  URT RX data capture register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t RDAT          :32;    //[31..0] UART received data register
        }MBIT;
    }RDAT;                              /*!< RDAT       ~ Offset[0x30]  URT RX data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t TDAT          :32;    //[31..0] UART transmitted data register
        }MBIT;
    }TDAT;                              /*!< TDAT       ~ Offset[0x34]  URT TX data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __O  uint32_t TDAT3         :24;    //[23..0] UART transmitted data register for 3-byte data write only
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }TDAT3;                             /*!< TDAT3      ~ Offset[0x38]  URT TX data 3-byte register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  RSBUF         :8;     //[7..0] UART RX data shift buffer register.
            __I  uint8_t  TSBUF         :8;     //[15..8] UART TX data shift buffer register.
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }SBUF;                              /*!< SBUF       ~ Offset[0x3C]  URT data shift buffer register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  TMO_EN        :1;     //[0] UART timeout timer enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_RST       :1;     //[1] UART timeout timer force reset enable. (set by software and clear by hardware)
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_MDS       :2;     //[3..2] UART timeout timer mode select
                                        //0x0 = UART : UART timeout timer
                                        //0x1 = General : general using timer
            __IO uint8_t  IDTMO_EN      :1;     //[4] UART Idle timeout detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RXTMO_EN      :1;     //[5] UART RX timeout enable bit for shadow buffer data loading into URTx_RDAT
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BKTMO_EN      :1;     //[6] UART Break timeout detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CALTMO_EN     :1;     //[7] UART Calibration timeout detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TMO_CKS       :3;     //[10..8] UART timeout timer clock source select
                                        //0x0 = UART (CK_URTx_BIT clock)
                                        //0x1 = Input (CK_UART clock input) 
                                        //0x2 = Noise (Noise bit receive event)
                                        //0x3 = Reserved
            __I  uint8_t                :3;     //[13..11] 
            __IO uint8_t  TMO_STA       :1;     //[14] UART timeout timer timeout signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  TMO_LCK       :1;     //[15] UART timeout timer timeout signal initial state control
                                        //0 = Locked
                                        //1 = Un-Locked
            __IO uint8_t  RXTMO_TH      :8;     //[23..16] UART RX data buffer timeout detect threshold value by using receive bit time
            __IO uint8_t  BKTMO_TH      :4;     //[27..24] UART receive Break timeout detect threshold value by using receive bit time
            __IO uint8_t  CALTMO_TH     :4;     //[31..28] UART calibration timeout detect threshold value for TMO counter value comparison
        }MBIT;
    }TMOUT;                             /*!< TMOUT      ~ Offset[0x40]  URT timeout control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t IDTMO_TH      :16;    //[15..0] UART receive idle timeout detect threshold value by using receive bit time
            __IO uint16_t TMO_CNT       :16;    //[31..16] UART timeout counter value.
        }MBIT;
    }TMOUT2;                            /*!< TMOUT2     ~ Offset[0x44]  URT timeout control register 2 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RXE_MDS       :2;     //[1..0] UART RX parity error detect control mode select
                                        //0x0 = Disable
                                        //0x1 = Enable : hardware RX auto retry number by setting URTx_RXE_NUM
                                        //0x2 = Auto : hardware RX auto retry always unless receiving parity correct character
            __IO uint8_t  TXE_MDS       :2;     //[3..2] UART TX error detect mode select
                                        //0x0 = Disable
                                        //0x1 = CHK_Low : check asserted low by RX device (for SmartCard)
                                        //0x2 = CHK_TX : check TX data by RX input data (for LIN mode)
                                        //0x3 = Reserved
            __IO uint8_t  RXE_LEN       :1;     //[4] UART RX parity error detect and NACK transmission 
                                        //0x0 = 1Bit
                                        //0x1 = 2Bit
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  TXE_NUM       :3;     //[10..8] UART TX error detect and data resend maximum number
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  RXE_NUM       :3;     //[14..12] UART RX parity error detect and NACK transmission retry maximum number
            __I  uint8_t                :1;     //[15] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }SC;                                /*!< SC         ~ Offset[0x48]  URT SmartCard control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SA_RX         :8;     //[7..0] UART multi-processor mode received slave address
            __IO uint8_t  SA_MSK        :8;     //[15..8] UART multi-processor slave address mask register
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }SADR;                              /*!< SADR       ~ Offset[0x4C]  URT slave address detect register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CAL_EN        :1;     //[0] UART baud-rate calibration enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CAL_AUTO      :1;     //[1] UART Break detection and auto baud-rate calibration enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CAL_MDS       :2;     //[3..2] UART auto baud-rate calibration mode select.
                                        //0x0 = Start : measure the start bit
                                        //0x1 = Edge : measure start falling edge to next falling edge
                                        //0x2 = Reserved
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  CALC_HE       :1;     //[7] UART auto baud-rate calibration complete data receive hold enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[11..8] 
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CAL;                               /*!< CAL        ~ Offset[0x50]  URT calibration control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IR_EN         :1;     //[0] UART IrDA data format enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IR_MDS        :1;     //[1] UART IrDA data received mode select
                                        //0 = Normal
                                        //1 = Wide
            __I  uint8_t                :6;     //[7..2] 
            __IO uint8_t  IR_PW         :4;     //[11..8] UART IrDA output pulse width select
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }IRDA;                              /*!< IRDA       ~ Offset[0x54]  URT IrDA control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CTS_EN        :1;     //[0] UART CTS hardware flow control enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RTS_EN        :1;     //[1] UART RTS hardware flow control enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CTS_INV       :1;     //[2] URTx_CTS input inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RTS_INV       :1;     //[3] URTx_RTS output inverse enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RTS_OUT       :1;     //[4] URTx_RTS output control data bit. This bit is no effect when URTx_RTS_EN is set.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }HFC;                               /*!< HFC        ~ Offset[0x58]  URT hardware flow control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  MUTE_EN       :1;     //[0] UART mute mode enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __IO uint8_t  MUTE_AEN0     :1;     //[8] UART mute mode auto enter by multi-processor slave address unmatched condition enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MUTE_AEN1     :1;     //[9] UART mute mode auto enter by idle line detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __IO uint8_t  MUTE_AEX0     :1;     //[16] UART auto exit mute mode and receive data by multi-processor slave address matched co
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MUTE_AEX1     :1;     //[17] UART auto exit mute mode and receive data by Break condition detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MUTE_AEX2     :1;     //[18] UART auto exit mute mode and receive data by  idle line detection enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }MUTE;                              /*!< MUTE       ~ Offset[0x5C]  URT mute control register */

} URT_Struct;

/**
 ******************************************************************************
 *
 * @name        URT  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define URT0_Base                       ((uint32_t)0x52000000)              /*!< UART Control Module-0 */
#define URT1_Base                       ((uint32_t)0x52010000)              /*!< UART Control Module-1 */
#define URT2_Base                       ((uint32_t)0x52020000)              /*!< UART Control Module-2 */
#define URT4_Base                       ((uint32_t)0x52040000)              /*!< UART Control Module-4 */
#define URT5_Base                       ((uint32_t)0x52050000)              /*!< UART Control Module-5 */
#define URT6_Base                       ((uint32_t)0x52060000)              /*!< UART Control Module-6 */
#define URT7_Base                       ((uint32_t)0x52070000)              /*!< UART Control Module-7 */
#define URT0                            ((URT_Struct*) URT0_Base)
#define URT1                            ((URT_Struct*) URT1_Base)
#define URT2                            ((URT_Struct*) URT2_Base)
#define URT4                            ((URT_Struct*) URT4_Base)
#define URT5                            ((URT_Struct*) URT5_Base)
#define URT6                            ((URT_Struct*) URT6_Base)
#define URT7                            ((URT_Struct*) URT7_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        URT  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        URT_STA  [register's definitions]
 *              Offset[0x00]  URT status register 1
 ******************************************************************************
 */
///@{
#define URT_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_STA */
#define URT_STA_CALTMOF_mask_w                      ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define URT_STA_CALTMOF_mask_h1                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_STA_CALTMOF_mask_b3                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_STA_CALTMOF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_CALTMOF_normal_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_CALTMOF_normal_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_CALTMOF_happened_w                  ((uint32_t)0x40000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_CALTMOF_happened_h1                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_CALTMOF_happened_b3                 ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_BKTMOF_mask_w                       ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define URT_STA_BKTMOF_mask_h1                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_STA_BKTMOF_mask_b3                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_STA_BKTMOF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_BKTMOF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_BKTMOF_normal_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_BKTMOF_happened_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_BKTMOF_happened_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_BKTMOF_happened_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_IDTMOF_mask_w                       ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define URT_STA_IDTMOF_mask_h1                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_STA_IDTMOF_mask_b3                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_STA_IDTMOF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_IDTMOF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_IDTMOF_normal_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_IDTMOF_happened_w                   ((uint32_t)0x10000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_IDTMOF_happened_h1                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_IDTMOF_happened_b3                  ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_RXTMOF_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define URT_STA_RXTMOF_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_STA_RXTMOF_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_STA_RXTMOF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_RXTMOF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_RXTMOF_normal_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_RXTMOF_happened_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_RXTMOF_happened_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_RXTMOF_happened_b3                  ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_TUDRF_mask_w                        ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define URT_STA_TUDRF_mask_h1                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_STA_TUDRF_mask_b3                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_STA_TUDRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_TUDRF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_TUDRF_normal_b3                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_TUDRF_happened_w                    ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_TUDRF_happened_h1                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_TUDRF_happened_b3                   ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_TXEF_mask_w                         ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define URT_STA_TXEF_mask_h1                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_STA_TXEF_mask_b3                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_STA_TXEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_TXEF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_TXEF_normal_b3                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_TXEF_happened_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_TXEF_happened_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_TXEF_happened_b3                    ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_ROVRF_mask_w                        ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define URT_STA_ROVRF_mask_h1                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_STA_ROVRF_mask_b2                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_STA_ROVRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_ROVRF_normal_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_ROVRF_normal_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_ROVRF_happened_w                    ((uint32_t)0x00800000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_ROVRF_happened_h1                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_ROVRF_happened_b2                   ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_NCEF_mask_w                         ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define URT_STA_NCEF_mask_h1                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_STA_NCEF_mask_b2                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_STA_NCEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_NCEF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_NCEF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_NCEF_happened_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_NCEF_happened_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_NCEF_happened_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_FEF_mask_w                          ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define URT_STA_FEF_mask_h1                         ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_STA_FEF_mask_b2                         ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_STA_FEF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_FEF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_FEF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_FEF_happened_w                      ((uint32_t)0x00200000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_FEF_happened_h1                     ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_FEF_happened_b2                     ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_PEF_mask_w                          ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define URT_STA_PEF_mask_h1                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_STA_PEF_mask_b2                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_STA_PEF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_PEF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_PEF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_PEF_happened_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_PEF_happened_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_PEF_happened_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_NSSF_mask_w                         ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define URT_STA_NSSF_mask_h1                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_STA_NSSF_mask_b2                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_STA_NSSF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_NSSF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_NSSF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_NSSF_happened_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_NSSF_happened_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_NSSF_happened_b2                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_CTSF_mask_w                         ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define URT_STA_CTSF_mask_h1                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_STA_CTSF_mask_b2                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_STA_CTSF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_CTSF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_CTSF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_CTSF_happened_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_CTSF_happened_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_CTSF_happened_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_IDLF_mask_w                         ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define URT_STA_IDLF_mask_h1                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_STA_IDLF_mask_b2                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_STA_IDLF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_IDLF_normal_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_IDLF_normal_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_IDLF_happened_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_IDLF_happened_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_IDLF_happened_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_BKF_mask_w                          ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define URT_STA_BKF_mask_h1                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_STA_BKF_mask_b2                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_STA_BKF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_BKF_normal_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_BKF_normal_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_BKF_happened_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_BKF_happened_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_BKF_happened_b2                     ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_CALOVF_mask_w                       ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define URT_STA_CALOVF_mask_h0                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define URT_STA_CALOVF_mask_b1                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_STA_CALOVF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_CALOVF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_CALOVF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_CALOVF_happened_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_CALOVF_happened_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_CALOVF_happened_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_CALUDF_mask_w                       ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define URT_STA_CALUDF_mask_h0                      ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_STA_CALUDF_mask_b1                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_STA_CALUDF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_CALUDF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_CALUDF_normal_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_CALUDF_happened_w                   ((uint32_t)0x00004000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_CALUDF_happened_h0                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_CALUDF_happened_b1                  ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_CALCF_mask_w                        ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define URT_STA_CALCF_mask_h0                       ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_STA_CALCF_mask_b1                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_STA_CALCF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_CALCF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_CALCF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_CALCF_happened_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_CALCF_happened_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_CALCF_happened_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_TMOF_mask_w                         ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define URT_STA_TMOF_mask_h0                        ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_STA_TMOF_mask_b1                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_STA_TMOF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_TMOF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_TMOF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_TMOF_happened_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_TMOF_happened_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_TMOF_happened_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_BRTF_mask_w                         ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define URT_STA_BRTF_mask_h0                        ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_STA_BRTF_mask_b1                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_STA_BRTF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_BRTF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_BRTF_normal_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_BRTF_happened_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_BRTF_happened_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_BRTF_happened_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_SADRF_mask_w                        ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define URT_STA_SADRF_mask_h0                       ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_STA_SADRF_mask_b1                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_STA_SADRF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_SADRF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_SADRF_normal_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_SADRF_happened_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_SADRF_happened_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_SADRF_happened_b1                   ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_TXF_mask_w                          ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_STA_TXF_mask_h0                         ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_STA_TXF_mask_b0                         ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_STA_TXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_TXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_TXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_TXF_happened_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_TXF_happened_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_TXF_happened_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_RXF_mask_w                          ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define URT_STA_RXF_mask_h0                         ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_STA_RXF_mask_b0                         ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_STA_RXF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_RXF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_RXF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_RXF_happened_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_RXF_happened_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_RXF_happened_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_RXDF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_STA_RXDF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_STA_RXDF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_STA_RXDF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_RXDF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_RXDF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_RXDF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_RXDF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_RXDF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_LSF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_STA_LSF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_STA_LSF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_STA_LSF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_LSF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_LSF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_LSF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_LSF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_LSF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_ERRF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_STA_ERRF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_STA_ERRF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_STA_ERRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_ERRF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_ERRF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_ERRF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_ERRF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_ERRF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_TCF_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_STA_TCF_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_STA_TCF_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_STA_TCF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_TCF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_TCF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_TCF_happened_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_TCF_happened_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_TCF_happened_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_UGF_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_STA_UGF_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_STA_UGF_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_STA_UGF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_UGF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_UGF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_UGF_happened_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_UGF_happened_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_UGF_happened_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA_RHF_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_STA_RHF_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_STA_RHF_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_STA_RHF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA_RHF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA_RHF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA_RHF_happened_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA_RHF_happened_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA_RHF_happened_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_INT  [register's definitions]
 *              Offset[0x04]  UART interrupt enable register
 ******************************************************************************
 */
///@{
#define URT_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_INT */
#define URT_INT_CALTMO_IE_mask_w                    ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define URT_INT_CALTMO_IE_mask_h1                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_INT_CALTMO_IE_mask_b3                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_INT_CALTMO_IE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_CALTMO_IE_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_CALTMO_IE_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_CALTMO_IE_enable_w                  ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_CALTMO_IE_enable_h1                 ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_CALTMO_IE_enable_b3                 ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_BKTMO_IE_mask_w                     ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define URT_INT_BKTMO_IE_mask_h1                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_INT_BKTMO_IE_mask_b3                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_INT_BKTMO_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_BKTMO_IE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_BKTMO_IE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_BKTMO_IE_enable_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_BKTMO_IE_enable_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_BKTMO_IE_enable_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_IDTMO_IE_mask_w                     ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define URT_INT_IDTMO_IE_mask_h1                    ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_INT_IDTMO_IE_mask_b3                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_INT_IDTMO_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_IDTMO_IE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_IDTMO_IE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_IDTMO_IE_enable_w                   ((uint32_t)0x10000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_IDTMO_IE_enable_h1                  ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_IDTMO_IE_enable_b3                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_RXTMO_IE_mask_w                     ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define URT_INT_RXTMO_IE_mask_h1                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_INT_RXTMO_IE_mask_b3                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_INT_RXTMO_IE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_RXTMO_IE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_RXTMO_IE_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_RXTMO_IE_enable_w                   ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_RXTMO_IE_enable_h1                  ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_RXTMO_IE_enable_b3                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_TUDR_IE_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define URT_INT_TUDR_IE_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_INT_TUDR_IE_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_INT_TUDR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_TUDR_IE_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_TUDR_IE_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_TUDR_IE_enable_w                    ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_TUDR_IE_enable_h1                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_TUDR_IE_enable_b3                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_TXE_IE_mask_w                       ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define URT_INT_TXE_IE_mask_h1                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_INT_TXE_IE_mask_b3                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_INT_TXE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_TXE_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_TXE_IE_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_TXE_IE_enable_w                     ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_TXE_IE_enable_h1                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_TXE_IE_enable_b3                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_ROVR_IE_mask_w                      ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define URT_INT_ROVR_IE_mask_h1                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_INT_ROVR_IE_mask_b2                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_INT_ROVR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_ROVR_IE_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_ROVR_IE_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_ROVR_IE_enable_w                    ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_ROVR_IE_enable_h1                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_ROVR_IE_enable_b2                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_NCE_IE_mask_w                       ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define URT_INT_NCE_IE_mask_h1                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_INT_NCE_IE_mask_b2                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_INT_NCE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_NCE_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_NCE_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_NCE_IE_enable_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_NCE_IE_enable_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_NCE_IE_enable_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_FE_IE_mask_w                        ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define URT_INT_FE_IE_mask_h1                       ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_INT_FE_IE_mask_b2                       ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_INT_FE_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_FE_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_FE_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_FE_IE_enable_w                      ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_FE_IE_enable_h1                     ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_FE_IE_enable_b2                     ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_PE_IE_mask_w                        ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define URT_INT_PE_IE_mask_h1                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_INT_PE_IE_mask_b2                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_INT_PE_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_PE_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_PE_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_PE_IE_enable_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_PE_IE_enable_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_PE_IE_enable_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_NSS_IE_mask_w                       ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define URT_INT_NSS_IE_mask_h1                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_INT_NSS_IE_mask_b2                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_INT_NSS_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_NSS_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_NSS_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_NSS_IE_enable_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_NSS_IE_enable_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_NSS_IE_enable_b2                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_CTS_IE_mask_w                       ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define URT_INT_CTS_IE_mask_h1                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_INT_CTS_IE_mask_b2                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_INT_CTS_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_CTS_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_CTS_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_CTS_IE_enable_w                     ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_CTS_IE_enable_h1                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_CTS_IE_enable_b2                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_IDL_IE_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define URT_INT_IDL_IE_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_INT_IDL_IE_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_INT_IDL_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_IDL_IE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_IDL_IE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_IDL_IE_enable_w                     ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_IDL_IE_enable_h1                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_IDL_IE_enable_b2                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_BK_IE_mask_w                        ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define URT_INT_BK_IE_mask_h1                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_INT_BK_IE_mask_b2                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_INT_BK_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_BK_IE_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_BK_IE_disable_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_BK_IE_enable_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_BK_IE_enable_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_BK_IE_enable_b2                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_CALC_IE_mask_w                      ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define URT_INT_CALC_IE_mask_h0                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_INT_CALC_IE_mask_b1                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_INT_CALC_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_CALC_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_CALC_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_CALC_IE_enable_w                    ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_CALC_IE_enable_h0                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_CALC_IE_enable_b1                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_TMO_IE_mask_w                       ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define URT_INT_TMO_IE_mask_h0                      ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_INT_TMO_IE_mask_b1                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_INT_TMO_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_TMO_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_TMO_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_TMO_IE_enable_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_TMO_IE_enable_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_TMO_IE_enable_b1                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_BRT_IE_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define URT_INT_BRT_IE_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_INT_BRT_IE_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_INT_BRT_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_BRT_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_BRT_IE_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_BRT_IE_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_BRT_IE_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_BRT_IE_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_SADR_IE_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define URT_INT_SADR_IE_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_INT_SADR_IE_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_INT_SADR_IE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_SADR_IE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_SADR_IE_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_SADR_IE_enable_w                    ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_SADR_IE_enable_h0                   ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_SADR_IE_enable_b1                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_TX_IE_mask_w                        ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_INT_TX_IE_mask_h0                       ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_INT_TX_IE_mask_b0                       ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_INT_TX_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_TX_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_TX_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_TX_IE_enable_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_TX_IE_enable_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_TX_IE_enable_b0                     ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_RX_IE_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define URT_INT_RX_IE_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_INT_RX_IE_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_INT_RX_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_RX_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_RX_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_RX_IE_enable_w                      ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_RX_IE_enable_h0                     ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_RX_IE_enable_b0                     ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_LS_IE_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_INT_LS_IE_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_INT_LS_IE_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_INT_LS_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_LS_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_LS_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_LS_IE_enable_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_LS_IE_enable_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_LS_IE_enable_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_ERR_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_INT_ERR_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_INT_ERR_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_INT_ERR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_ERR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_ERR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_ERR_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_ERR_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_ERR_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_TC_IE_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_INT_TC_IE_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_INT_TC_IE_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_INT_TC_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_TC_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_TC_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_TC_IE_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_TC_IE_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_TC_IE_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_UG_IE_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_INT_UG_IE_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_INT_UG_IE_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_INT_UG_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_UG_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_UG_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_UG_IE_enable_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_UG_IE_enable_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_UG_IE_enable_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CLK  [register's definitions]
 *              Offset[0x08]  URT clock source register
 ******************************************************************************
 */
///@{
#define URT_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CLK */
#define URT_CLK_BR_CKS_mask_w                       ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_BR_CKS_mask_h1                      ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_CLK_BR_CKS_mask_b3                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_CLK_BR_CKS_psc_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):PSC of 32bit */
#define URT_CLK_BR_CKS_psc_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):PSC of 16bit */
#define URT_CLK_BR_CKS_psc_b3                       ((uint8_t )0x00)        /*!< Bit Value =(0):PSC of 8bit */
#define URT_CLK_BR_CKS_ck_urtx_w                    ((uint32_t)0x40000000)  /*!< Bit Value =(1):CK_URTx of 32bit */
#define URT_CLK_BR_CKS_ck_urtx_h1                   ((uint16_t)0x4000)      /*!< Bit Value =(1):CK_URTx of 16bit */
#define URT_CLK_BR_CKS_ck_urtx_b3                   ((uint8_t )0x40)        /*!< Bit Value =(1):CK_URTx of 8bit */

#define URT_CLK_CKO_LCK_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_CKO_LCK_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_CLK_CKO_LCK_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CLK_CKO_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define URT_CLK_CKO_LCK_locked_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define URT_CLK_CKO_LCK_locked_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define URT_CLK_CKO_LCK_un_locked_w                 ((uint32_t)0x20000000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define URT_CLK_CKO_LCK_un_locked_h1                ((uint16_t)0x2000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define URT_CLK_CKO_LCK_un_locked_b3                ((uint8_t )0x20)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define URT_CLK_CKO_STA_mask_w                      ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_CKO_STA_mask_h1                     ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_CLK_CKO_STA_mask_b3                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CLK_CKO_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define URT_CLK_CKO_STA_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define URT_CLK_CKO_STA_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define URT_CLK_CKO_STA_1_w                         ((uint32_t)0x10000000)  /*!< Bit Value =(1):1 of 32bit */
#define URT_CLK_CKO_STA_1_h1                        ((uint16_t)0x1000)      /*!< Bit Value =(1):1 of 16bit */
#define URT_CLK_CKO_STA_1_b3                        ((uint8_t )0x10)        /*!< Bit Value =(1):1 of 8bit */

#define URT_CLK_BRO_LCK_mask_w                      ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_BRO_LCK_mask_h1                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_CLK_BRO_LCK_mask_b3                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CLK_BRO_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define URT_CLK_BRO_LCK_locked_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define URT_CLK_BRO_LCK_locked_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define URT_CLK_BRO_LCK_un_locked_w                 ((uint32_t)0x08000000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define URT_CLK_BRO_LCK_un_locked_h1                ((uint16_t)0x0800)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define URT_CLK_BRO_LCK_un_locked_b3                ((uint8_t )0x08)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define URT_CLK_BRO_STA_mask_w                      ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_BRO_STA_mask_h1                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_CLK_BRO_STA_mask_b3                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CLK_BRO_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define URT_CLK_BRO_STA_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define URT_CLK_BRO_STA_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define URT_CLK_BRO_STA_1_w                         ((uint32_t)0x04000000)  /*!< Bit Value =(1):1 of 32bit */
#define URT_CLK_BRO_STA_1_h1                        ((uint16_t)0x0400)      /*!< Bit Value =(1):1 of 16bit */
#define URT_CLK_BRO_STA_1_b3                        ((uint8_t )0x04)        /*!< Bit Value =(1):1 of 8bit */

#define URT_CLK_BR_MDS_mask_w                       ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_BR_MDS_mask_h1                      ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_CLK_BR_MDS_mask_b3                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CLK_BR_MDS_separated_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Separated of 32bit */
#define URT_CLK_BR_MDS_separated_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Separated of 16bit */
#define URT_CLK_BR_MDS_separated_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Separated of 8bit */
#define URT_CLK_BR_MDS_combined_w                   ((uint32_t)0x02000000)  /*!< Bit Value =(1):Combined of 32bit */
#define URT_CLK_BR_MDS_combined_h1                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Combined of 16bit */
#define URT_CLK_BR_MDS_combined_b3                  ((uint8_t )0x02)        /*!< Bit Value =(1):Combined of 8bit */

#define URT_CLK_BR_EN_mask_w                        ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define URT_CLK_BR_EN_mask_h1                       ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_CLK_BR_EN_mask_b3                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CLK_BR_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CLK_BR_EN_disable_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CLK_BR_EN_disable_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CLK_BR_EN_enable_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CLK_BR_EN_enable_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CLK_BR_EN_enable_b3                     ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CLK_TX_CKS_mask_w                       ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define URT_CLK_TX_CKS_mask_h1                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define URT_CLK_TX_CKS_mask_b2                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define URT_CLK_TX_CKS_internal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Internal of 32bit */
#define URT_CLK_TX_CKS_internal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Internal of 16bit */
#define URT_CLK_TX_CKS_internal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Internal of 8bit */
#define URT_CLK_TX_CKS_tm01_trgo_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):TM01_TRGO of 32bit */
#define URT_CLK_TX_CKS_tm01_trgo_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(0x1):TM01_TRGO of 16bit */
#define URT_CLK_TX_CKS_tm01_trgo_b2                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):TM01_TRGO of 8bit */
#define URT_CLK_TX_CKS_tm10_trgo_w                  ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):TM10_TRGO of 32bit */
#define URT_CLK_TX_CKS_tm10_trgo_h1                 ((uint16_t)0x0020)      /*!< Bit Value =(0x2):TM10_TRGO of 16bit */
#define URT_CLK_TX_CKS_tm10_trgo_b2                 ((uint8_t )0x20)        /*!< Bit Value =(0x2):TM10_TRGO of 8bit */
#define URT_CLK_TX_CKS_ext_clk_w                    ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):EXT_CLK of 32bit */
#define URT_CLK_TX_CKS_ext_clk_h1                   ((uint16_t)0x0030)      /*!< Bit Value =(0x3):EXT_CLK of 16bit */
#define URT_CLK_TX_CKS_ext_clk_b2                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):EXT_CLK of 8bit */

#define URT_CLK_RX_CKS_mask_w                       ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define URT_CLK_RX_CKS_mask_h1                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define URT_CLK_RX_CKS_mask_b2                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define URT_CLK_RX_CKS_internal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Internal of 32bit */
#define URT_CLK_RX_CKS_internal_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Internal of 16bit */
#define URT_CLK_RX_CKS_internal_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Internal of 8bit */
#define URT_CLK_RX_CKS_tm01_trgo_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):TM01_TRGO of 32bit */
#define URT_CLK_RX_CKS_tm01_trgo_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(0x1):TM01_TRGO of 16bit */
#define URT_CLK_RX_CKS_tm01_trgo_b2                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):TM01_TRGO of 8bit */
#define URT_CLK_RX_CKS_tm10_trgo_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):TM10_TRGO of 32bit */
#define URT_CLK_RX_CKS_tm10_trgo_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(0x2):TM10_TRGO of 16bit */
#define URT_CLK_RX_CKS_tm10_trgo_b2                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):TM10_TRGO of 8bit */
#define URT_CLK_RX_CKS_ext_clk_w                    ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):EXT_CLK of 32bit */
#define URT_CLK_RX_CKS_ext_clk_h1                   ((uint16_t)0x0003)      /*!< Bit Value =(0x3):EXT_CLK of 16bit */
#define URT_CLK_RX_CKS_ext_clk_b2                   ((uint8_t )0x03)        /*!< Bit Value =(0x3):EXT_CLK of 8bit */

#define URT_CLK_ECK_CKS_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_CLK_ECK_CKS_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_CLK_ECK_CKS_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CLK_ECK_CKS_clk_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):CLK of 32bit */
#define URT_CLK_ECK_CKS_clk_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):CLK of 16bit */
#define URT_CLK_ECK_CKS_clk_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):CLK of 8bit */
#define URT_CLK_ECK_CKS_rx_w                        ((uint32_t)0x00000080)  /*!< Bit Value =(1):RX of 32bit */
#define URT_CLK_ECK_CKS_rx_h0                       ((uint16_t)0x0080)      /*!< Bit Value =(1):RX of 16bit */
#define URT_CLK_ECK_CKS_rx_b0                       ((uint8_t )0x80)        /*!< Bit Value =(1):RX of 8bit */

#define URT_CLK_CLK_CKS_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_CLK_CLK_CKS_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_CLK_CLK_CKS_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CLK_CLK_CKS_out_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):OUT of 32bit */
#define URT_CLK_CLK_CKS_out_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):OUT of 16bit */
#define URT_CLK_CLK_CKS_out_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):OUT of 8bit */
#define URT_CLK_CLK_CKS_sc_w                        ((uint32_t)0x00000020)  /*!< Bit Value =(1):SC of 32bit */
#define URT_CLK_CLK_CKS_sc_h0                       ((uint16_t)0x0020)      /*!< Bit Value =(1):SC of 16bit */
#define URT_CLK_CLK_CKS_sc_b0                       ((uint8_t )0x20)        /*!< Bit Value =(1):SC of 8bit */

#define URT_CLK_CLK_EN_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_CLK_CLK_EN_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CLK_CLK_EN_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CLK_CLK_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CLK_CLK_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CLK_CLK_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CLK_CLK_EN_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CLK_CLK_EN_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CLK_CLK_EN_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000E)  /*!< Bit Mask of 32bit */
#define URT_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000E)      /*!< Bit Mask of 16bit */
#define URT_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0E)        /*!< Bit Mask of 8bit */
#define URT_CLK_CK_SEL_proc_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):PROC of 32bit */
#define URT_CLK_CK_SEL_proc_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):PROC of 16bit */
#define URT_CLK_CK_SEL_proc_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):PROC of 8bit */
#define URT_CLK_CK_SEL_nco_p0_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(0x1):NCO_P0 of 32bit */
#define URT_CLK_CK_SEL_nco_p0_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(0x1):NCO_P0 of 16bit */
#define URT_CLK_CK_SEL_nco_p0_b0                    ((uint8_t )0x02)        /*!< Bit Value =(0x1):NCO_P0 of 8bit */
#define URT_CLK_CK_SEL_ck_ls_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(0x2):CK_LS of 32bit */
#define URT_CLK_CK_SEL_ck_ls_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(0x2):CK_LS of 16bit */
#define URT_CLK_CK_SEL_ck_ls_b0                     ((uint8_t )0x04)        /*!< Bit Value =(0x2):CK_LS of 8bit */
#define URT_CLK_CK_SEL_tm00_trgo_w                  ((uint32_t)0x00000006)  /*!< Bit Value =(0x3):TM00_TRGO of 32bit */
#define URT_CLK_CK_SEL_tm00_trgo_h0                 ((uint16_t)0x0006)      /*!< Bit Value =(0x3):TM00_TRGO of 16bit */
#define URT_CLK_CK_SEL_tm00_trgo_b0                 ((uint8_t )0x06)        /*!< Bit Value =(0x3):TM00_TRGO of 8bit */
#define URT_CLK_CK_SEL_ext_clk_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(0x4):EXT_CLK of 32bit */
#define URT_CLK_CK_SEL_ext_clk_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(0x4):EXT_CLK of 16bit */
#define URT_CLK_CK_SEL_ext_clk_b0                   ((uint8_t )0x08)        /*!< Bit Value =(0x4):EXT_CLK of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_STA2  [register's definitions]
 *              Offset[0x0C]  URT status register 2
 ******************************************************************************
 */
///@{
#define URT_STA2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_STA2 */
#define URT_STA2_TX_LVL_mask_w                      ((uint32_t)0x70000000)  /*!< Bit Mask of 32bit */
#define URT_STA2_TX_LVL_mask_h1                     ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define URT_STA2_TX_LVL_mask_b3                     ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define URT_STA2_TX_LVL_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define URT_STA2_TX_LVL_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define URT_STA2_TX_LVL_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define URT_STA2_TX_LVL_1_w                         ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):1 of 32bit */
#define URT_STA2_TX_LVL_1_h1                        ((uint16_t)0x1000)      /*!< Bit Value =(0x1):1 of 16bit */
#define URT_STA2_TX_LVL_1_b3                        ((uint8_t )0x10)        /*!< Bit Value =(0x1):1 of 8bit */
#define URT_STA2_TX_LVL_2_w                         ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):2 of 32bit */
#define URT_STA2_TX_LVL_2_h1                        ((uint16_t)0x2000)      /*!< Bit Value =(0x2):2 of 16bit */
#define URT_STA2_TX_LVL_2_b3                        ((uint8_t )0x20)        /*!< Bit Value =(0x2):2 of 8bit */
#define URT_STA2_TX_LVL_3_w                         ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):3 of 32bit */
#define URT_STA2_TX_LVL_3_h1                        ((uint16_t)0x3000)      /*!< Bit Value =(0x3):3 of 16bit */
#define URT_STA2_TX_LVL_3_b3                        ((uint8_t )0x30)        /*!< Bit Value =(0x3):3 of 8bit */
#define URT_STA2_TX_LVL_4_w                         ((uint32_t)0x40000000)  /*!< Bit Value =(0x4):4 of 32bit */
#define URT_STA2_TX_LVL_4_h1                        ((uint16_t)0x4000)      /*!< Bit Value =(0x4):4 of 16bit */
#define URT_STA2_TX_LVL_4_b3                        ((uint8_t )0x40)        /*!< Bit Value =(0x4):4 of 8bit */

#define URT_STA2_RX_LVL_mask_w                      ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define URT_STA2_RX_LVL_mask_h1                     ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define URT_STA2_RX_LVL_mask_b3                     ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define URT_STA2_RX_LVL_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define URT_STA2_RX_LVL_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define URT_STA2_RX_LVL_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define URT_STA2_RX_LVL_1_w                         ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):1 of 32bit */
#define URT_STA2_RX_LVL_1_h1                        ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1 of 16bit */
#define URT_STA2_RX_LVL_1_b3                        ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */
#define URT_STA2_RX_LVL_2_w                         ((uint32_t)0x02000000)  /*!< Bit Value =(0x2):2 of 32bit */
#define URT_STA2_RX_LVL_2_h1                        ((uint16_t)0x0200)      /*!< Bit Value =(0x2):2 of 16bit */
#define URT_STA2_RX_LVL_2_b3                        ((uint8_t )0x02)        /*!< Bit Value =(0x2):2 of 8bit */
#define URT_STA2_RX_LVL_3_w                         ((uint32_t)0x03000000)  /*!< Bit Value =(0x3):3 of 32bit */
#define URT_STA2_RX_LVL_3_h1                        ((uint16_t)0x0300)      /*!< Bit Value =(0x3):3 of 16bit */
#define URT_STA2_RX_LVL_3_b3                        ((uint8_t )0x03)        /*!< Bit Value =(0x3):3 of 8bit */
#define URT_STA2_RX_LVL_4_w                         ((uint32_t)0x04000000)  /*!< Bit Value =(0x4):4 of 32bit */
#define URT_STA2_RX_LVL_4_h1                        ((uint16_t)0x0400)      /*!< Bit Value =(0x4):4 of 16bit */
#define URT_STA2_RX_LVL_4_b3                        ((uint8_t )0x04)        /*!< Bit Value =(0x4):4 of 8bit */

#define URT_STA2_CTS_mask_w                         ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define URT_STA2_CTS_mask_h0                        ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_STA2_CTS_mask_b1                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_STA2_CTS_shift_w                        (12)                    /*!< Bit Shift of 32bit */
#define URT_STA2_CTS_shift_h0                       (12)                    /*!< Bit Shift of 16bit */
#define URT_STA2_CTS_shift_b1                       (4)                     /*!< Bit Shift of 8bit */

#define URT_STA2_IR_BUSYF_mask_w                    ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_STA2_IR_BUSYF_mask_h0                   ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_STA2_IR_BUSYF_mask_b0                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_STA2_IR_BUSYF_no_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define URT_STA2_IR_BUSYF_no_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define URT_STA2_IR_BUSYF_no_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define URT_STA2_IR_BUSYF_busy_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Busy of 32bit */
#define URT_STA2_IR_BUSYF_busy_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Busy of 16bit */
#define URT_STA2_IR_BUSYF_busy_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Busy of 8bit */

#define URT_STA2_BKBF_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define URT_STA2_BKBF_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_STA2_BKBF_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_STA2_BKBF_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA2_BKBF_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA2_BKBF_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA2_BKBF_busy_w                        ((uint32_t)0x00000040)  /*!< Bit Value =(1):Busy of 32bit */
#define URT_STA2_BKBF_busy_h0                       ((uint16_t)0x0040)      /*!< Bit Value =(1):Busy of 16bit */
#define URT_STA2_BKBF_busy_b0                       ((uint8_t )0x40)        /*!< Bit Value =(1):Busy of 8bit */

#define URT_STA2_NCF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_STA2_NCF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_STA2_NCF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_STA2_NCF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA2_NCF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA2_NCF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA2_NCF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define URT_STA2_NCF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define URT_STA2_NCF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define URT_STA2_ADR_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_STA2_ADR_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_STA2_ADR_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_STA2_ADR_shift_w                        (2)                     /*!< Bit Shift of 32bit */
#define URT_STA2_ADR_shift_h0                       (2)                     /*!< Bit Shift of 16bit */
#define URT_STA2_ADR_shift_b0                       (2)                     /*!< Bit Shift of 8bit */

#define URT_STA2_PAR_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_STA2_PAR_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_STA2_PAR_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_STA2_PAR_shift_w                        (1)                     /*!< Bit Shift of 32bit */
#define URT_STA2_PAR_shift_h0                       (1)                     /*!< Bit Shift of 16bit */
#define URT_STA2_PAR_shift_b0                       (1)                     /*!< Bit Shift of 8bit */

#define URT_STA2_BUSYF_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_STA2_BUSYF_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_STA2_BUSYF_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_STA2_BUSYF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_STA2_BUSYF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_STA2_BUSYF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_STA2_BUSYF_busy_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(1):Busy of 32bit */
#define URT_STA2_BUSYF_busy_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(1):Busy of 16bit */
#define URT_STA2_BUSYF_busy_b0                      ((uint8_t )0x01)        /*!< Bit Value =(1):Busy of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CR0  [register's definitions]
 *              Offset[0x10]  URT control register 0
 ******************************************************************************
 */
///@{
#define URT_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CR0 */
#define URT_CR0_DMA_TXEN_mask_w                     ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DMA_TXEN_mask_h1                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DMA_TXEN_mask_b3                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CR0_DMA_TXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_DMA_TXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_DMA_TXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_DMA_TXEN_enable_w                   ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_DMA_TXEN_enable_h1                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_DMA_TXEN_enable_b3                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_DMA_RXEN_mask_w                     ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DMA_RXEN_mask_h1                    ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DMA_RXEN_mask_b3                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_CR0_DMA_RXEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_DMA_RXEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_DMA_RXEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_DMA_RXEN_enable_w                   ((uint32_t)0x40000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_DMA_RXEN_enable_h1                  ((uint16_t)0x4000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_DMA_RXEN_enable_b3                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_DDTX_EN_mask_w                      ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DDTX_EN_mask_h1                     ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DDTX_EN_mask_b3                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR0_DDTX_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_DDTX_EN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_DDTX_EN_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_DDTX_EN_enable_w                    ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_DDTX_EN_enable_h1                   ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_DDTX_EN_enable_b3                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_LBM_EN_mask_w                       ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define URT_CR0_LBM_EN_mask_h1                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_CR0_LBM_EN_mask_b2                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CR0_LBM_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_LBM_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_LBM_EN_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_LBM_EN_enable_w                     ((uint32_t)0x00800000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_LBM_EN_enable_h1                    ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_LBM_EN_enable_b2                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_NCHAR_DIS_mask_w                    ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define URT_CR0_NCHAR_DIS_mask_h1                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_CR0_NCHAR_DIS_mask_b2                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_CR0_NCHAR_DIS_enable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Enable of 32bit */
#define URT_CR0_NCHAR_DIS_enable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Enable of 16bit */
#define URT_CR0_NCHAR_DIS_enable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Enable of 8bit */
#define URT_CR0_NCHAR_DIS_disable_w                 ((uint32_t)0x00400000)  /*!< Bit Value =(1):Disable of 32bit */
#define URT_CR0_NCHAR_DIS_disable_h1                ((uint16_t)0x0040)      /*!< Bit Value =(1):Disable of 16bit */
#define URT_CR0_NCHAR_DIS_disable_b2                ((uint8_t )0x40)        /*!< Bit Value =(1):Disable of 8bit */

#define URT_CR0_NCHAR_HE_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define URT_CR0_NCHAR_HE_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_CR0_NCHAR_HE_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR0_NCHAR_HE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_NCHAR_HE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_NCHAR_HE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_NCHAR_HE_enable_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_NCHAR_HE_enable_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_NCHAR_HE_enable_b2                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_IDL_MDS_mask_w                      ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define URT_CR0_IDL_MDS_mask_h1                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR0_IDL_MDS_mask_b2                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR0_IDL_MDS_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define URT_CR0_IDL_MDS_no_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define URT_CR0_IDL_MDS_no_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define URT_CR0_IDL_MDS_load_w                      ((uint32_t)0x00100000)  /*!< Bit Value =(1):Load of 32bit */
#define URT_CR0_IDL_MDS_load_h1                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Load of 16bit */
#define URT_CR0_IDL_MDS_load_b2                     ((uint8_t )0x10)        /*!< Bit Value =(1):Load of 8bit */

#define URT_CR0_RX_TH_mask_w                        ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define URT_CR0_RX_TH_mask_h1                       ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define URT_CR0_RX_TH_mask_b2                       ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define URT_CR0_RX_TH_1byte_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1byte of 32bit */
#define URT_CR0_RX_TH_1byte_h1                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1byte of 16bit */
#define URT_CR0_RX_TH_1byte_b2                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):1byte of 8bit */
#define URT_CR0_RX_TH_2byte_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):2byte of 32bit */
#define URT_CR0_RX_TH_2byte_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(0x1):2byte of 16bit */
#define URT_CR0_RX_TH_2byte_b2                      ((uint8_t )0x01)        /*!< Bit Value =(0x1):2byte of 8bit */
#define URT_CR0_RX_TH_3byte_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):3byte of 32bit */
#define URT_CR0_RX_TH_3byte_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):3byte of 16bit */
#define URT_CR0_RX_TH_3byte_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):3byte of 8bit */
#define URT_CR0_RX_TH_4byte_w                       ((uint32_t)0x00030000)  /*!< Bit Value =(0x3):4byte of 32bit */
#define URT_CR0_RX_TH_4byte_h1                      ((uint16_t)0x0003)      /*!< Bit Value =(0x3):4byte of 16bit */
#define URT_CR0_RX_TH_4byte_b2                      ((uint8_t )0x03)        /*!< Bit Value =(0x3):4byte of 8bit */

#define URT_CR0_DE_GT_mask_w                        ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DE_GT_mask_h0                       ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DE_GT_mask_b1                       ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define URT_CR0_DE_GT_1_4_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1/4 of 32bit */
#define URT_CR0_DE_GT_1_4_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1/4 of 16bit */
#define URT_CR0_DE_GT_1_4_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):1/4 of 8bit */
#define URT_CR0_DE_GT_1_2_w                         ((uint32_t)0x00004000)  /*!< Bit Value =(0x1):1/2 of 32bit */
#define URT_CR0_DE_GT_1_2_h0                        ((uint16_t)0x4000)      /*!< Bit Value =(0x1):1/2 of 16bit */
#define URT_CR0_DE_GT_1_2_b1                        ((uint8_t )0x40)        /*!< Bit Value =(0x1):1/2 of 8bit */
#define URT_CR0_DE_GT_1_w                           ((uint32_t)0x00008000)  /*!< Bit Value =(0x2):1 of 32bit */
#define URT_CR0_DE_GT_1_h0                          ((uint16_t)0x8000)      /*!< Bit Value =(0x2):1 of 16bit */
#define URT_CR0_DE_GT_1_b1                          ((uint8_t )0x80)        /*!< Bit Value =(0x2):1 of 8bit */
#define URT_CR0_DE_GT_2_w                           ((uint32_t)0x0000C000)  /*!< Bit Value =(0x3):2 of 32bit */
#define URT_CR0_DE_GT_2_h0                          ((uint16_t)0xC000)      /*!< Bit Value =(0x3):2 of 16bit */
#define URT_CR0_DE_GT_2_b1                          ((uint8_t )0xC0)        /*!< Bit Value =(0x3):2 of 8bit */

#define URT_CR0_DE_INV_mask_w                       ((uint32_t)0x00002000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DE_INV_mask_h0                      ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DE_INV_mask_b1                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR0_DE_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_DE_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_DE_INV_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_DE_INV_enable_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_DE_INV_enable_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_DE_INV_enable_b1                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_DE_EN_mask_w                        ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define URT_CR0_DE_EN_mask_h0                       ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define URT_CR0_DE_EN_mask_b1                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR0_DE_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_DE_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_DE_EN_disable_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_DE_EN_enable_w                      ((uint32_t)0x00001000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_DE_EN_enable_h0                     ((uint16_t)0x1000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_DE_EN_enable_b1                     ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_TX_INV_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define URT_CR0_TX_INV_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_CR0_TX_INV_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR0_TX_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_TX_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_TX_INV_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_TX_INV_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_TX_INV_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_TX_INV_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_RX_INV_mask_w                       ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define URT_CR0_RX_INV_mask_h0                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_CR0_RX_INV_mask_b1                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR0_RX_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_RX_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_RX_INV_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_RX_INV_enable_w                     ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_RX_INV_enable_h0                    ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_RX_INV_enable_b1                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_SYNC_MDS_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define URT_CR0_SYNC_MDS_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_CR0_SYNC_MDS_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR0_SYNC_MDS_master_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Master of 32bit */
#define URT_CR0_SYNC_MDS_master_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Master of 16bit */
#define URT_CR0_SYNC_MDS_master_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Master of 8bit */
#define URT_CR0_SYNC_MDS_slave_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Slave of 32bit */
#define URT_CR0_SYNC_MDS_slave_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Slave of 16bit */
#define URT_CR0_SYNC_MDS_slave_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Slave of 8bit */

#define URT_CR0_IO_SWP_mask_w                       ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define URT_CR0_IO_SWP_mask_h0                      ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_CR0_IO_SWP_mask_b1                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CR0_IO_SWP_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_IO_SWP_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_IO_SWP_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_IO_SWP_enable_w                     ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_IO_SWP_enable_h0                    ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_IO_SWP_enable_b1                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_GSA_EN_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_CR0_GSA_EN_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_CR0_GSA_EN_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CR0_GSA_EN_shift_w                      (7)                     /*!< Bit Shift of 32bit */
#define URT_CR0_GSA_EN_shift_h0                     (7)                     /*!< Bit Shift of 16bit */
#define URT_CR0_GSA_EN_shift_b0                     (7)                     /*!< Bit Shift of 8bit */

#define URT_CR0_MDS_mask_w                          ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define URT_CR0_MDS_mask_h0                         ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define URT_CR0_MDS_mask_b0                         ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define URT_CR0_MDS_uart_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):UART of 32bit */
#define URT_CR0_MDS_uart_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):UART of 16bit */
#define URT_CR0_MDS_uart_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0x0):UART of 8bit */
#define URT_CR0_MDS_sync_w                          ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):SYNC of 32bit */
#define URT_CR0_MDS_sync_h0                         ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SYNC of 16bit */
#define URT_CR0_MDS_sync_b0                         ((uint8_t )0x10)        /*!< Bit Value =(0x1):SYNC of 8bit */
#define URT_CR0_MDS_idle_w                          ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):IDLE of 32bit */
#define URT_CR0_MDS_idle_h0                         ((uint16_t)0x0020)      /*!< Bit Value =(0x2):IDLE of 16bit */
#define URT_CR0_MDS_idle_b0                         ((uint8_t )0x20)        /*!< Bit Value =(0x2):IDLE of 8bit */
#define URT_CR0_MDS_adr_w                           ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):ADR of 32bit */
#define URT_CR0_MDS_adr_h0                          ((uint16_t)0x0030)      /*!< Bit Value =(0x3):ADR of 16bit */
#define URT_CR0_MDS_adr_b0                          ((uint8_t )0x30)        /*!< Bit Value =(0x3):ADR of 8bit */

#define URT_CR0_DAT_LINE_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_CR0_DAT_LINE_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_CR0_DAT_LINE_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR0_DAT_LINE_2_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):2 of 32bit */
#define URT_CR0_DAT_LINE_2_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):2 of 16bit */
#define URT_CR0_DAT_LINE_2_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):2 of 8bit */
#define URT_CR0_DAT_LINE_1_w                        ((uint32_t)0x00000008)  /*!< Bit Value =(1):1 of 32bit */
#define URT_CR0_DAT_LINE_1_h0                       ((uint16_t)0x0008)      /*!< Bit Value =(1):1 of 16bit */
#define URT_CR0_DAT_LINE_1_b0                       ((uint8_t )0x08)        /*!< Bit Value =(1):1 of 8bit */

#define URT_CR0_HDX_EN_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_CR0_HDX_EN_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_CR0_HDX_EN_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR0_HDX_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_HDX_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_HDX_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_HDX_EN_enable_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_HDX_EN_enable_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_HDX_EN_enable_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR0_OS_MDS_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_CR0_OS_MDS_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_CR0_OS_MDS_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR0_OS_MDS_three_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Three of 32bit */
#define URT_CR0_OS_MDS_three_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Three of 16bit */
#define URT_CR0_OS_MDS_three_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Three of 8bit */
#define URT_CR0_OS_MDS_one_w                        ((uint32_t)0x00000002)  /*!< Bit Value =(1):One of 32bit */
#define URT_CR0_OS_MDS_one_h0                       ((uint16_t)0x0002)      /*!< Bit Value =(1):One of 16bit */
#define URT_CR0_OS_MDS_one_b0                       ((uint8_t )0x02)        /*!< Bit Value =(1):One of 8bit */

#define URT_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CR1  [register's definitions]
 *              Offset[0x14]  URT control register 1
 ******************************************************************************
 */
///@{
#define URT_CR1_default                             ((uint32_t)0x0F400F40)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CR1 */
#define URT_CR1_TXOS_NUM_mask_w                     ((uint32_t)0x1F000000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXOS_NUM_mask_h1                    ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXOS_NUM_mask_b3                    ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXOS_NUM_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define URT_CR1_TXOS_NUM_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define URT_CR1_TXOS_NUM_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define URT_CR1_TXSTP_LEN_mask_w                    ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXSTP_LEN_mask_h1                   ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXSTP_LEN_mask_b2                   ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXSTP_LEN_0_5bit_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0.5bit of 32bit */
#define URT_CR1_TXSTP_LEN_0_5bit_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0.5bit of 16bit */
#define URT_CR1_TXSTP_LEN_0_5bit_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):0.5bit of 8bit */
#define URT_CR1_TXSTP_LEN_1bit_w                    ((uint32_t)0x00400000)  /*!< Bit Value =(0x1):1bit of 32bit */
#define URT_CR1_TXSTP_LEN_1bit_h1                   ((uint16_t)0x0040)      /*!< Bit Value =(0x1):1bit of 16bit */
#define URT_CR1_TXSTP_LEN_1bit_b2                   ((uint8_t )0x40)        /*!< Bit Value =(0x1):1bit of 8bit */
#define URT_CR1_TXSTP_LEN_1_5bit_w                  ((uint32_t)0x00800000)  /*!< Bit Value =(0x2):1.5bit of 32bit */
#define URT_CR1_TXSTP_LEN_1_5bit_h1                 ((uint16_t)0x0080)      /*!< Bit Value =(0x2):1.5bit of 16bit */
#define URT_CR1_TXSTP_LEN_1_5bit_b2                 ((uint8_t )0x80)        /*!< Bit Value =(0x2):1.5bit of 8bit */
#define URT_CR1_TXSTP_LEN_2bit_w                    ((uint32_t)0x00C00000)  /*!< Bit Value =(0x3):2bit of 32bit */
#define URT_CR1_TXSTP_LEN_2bit_h1                   ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):2bit of 16bit */
#define URT_CR1_TXSTP_LEN_2bit_b2                   ((uint8_t )0xC0)        /*!< Bit Value =(0x3):2bit of 8bit */

#define URT_CR1_TXMSB_EN_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXMSB_EN_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXMSB_EN_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXMSB_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_TXMSB_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_TXMSB_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_TXMSB_EN_enable_w                   ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_TXMSB_EN_enable_h1                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_TXMSB_EN_enable_b2                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_TXPAR_STK_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXPAR_STK_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXPAR_STK_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXPAR_STK_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_TXPAR_STK_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_TXPAR_STK_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_TXPAR_STK_enable_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_TXPAR_STK_enable_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_TXPAR_STK_enable_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_TXPAR_POL_mask_w                    ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXPAR_POL_mask_h1                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXPAR_POL_mask_b2                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXPAR_POL_even_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Even of 32bit */
#define URT_CR1_TXPAR_POL_even_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Even of 16bit */
#define URT_CR1_TXPAR_POL_even_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):Even of 8bit */
#define URT_CR1_TXPAR_POL_odd_w                     ((uint32_t)0x00080000)  /*!< Bit Value =(0x1):Odd of 32bit */
#define URT_CR1_TXPAR_POL_odd_h1                    ((uint16_t)0x0008)      /*!< Bit Value =(0x1):Odd of 16bit */
#define URT_CR1_TXPAR_POL_odd_b2                    ((uint8_t )0x08)        /*!< Bit Value =(0x1):Odd of 8bit */

#define URT_CR1_TXPAR_EN_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXPAR_EN_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXPAR_EN_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXPAR_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_TXPAR_EN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_TXPAR_EN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_TXPAR_EN_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_TXPAR_EN_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_TXPAR_EN_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_TXDSIZE_mask_w                      ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define URT_CR1_TXDSIZE_mask_h1                     ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define URT_CR1_TXDSIZE_mask_b2                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define URT_CR1_TXDSIZE_8bit_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):8bit of 32bit */
#define URT_CR1_TXDSIZE_8bit_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):8bit of 16bit */
#define URT_CR1_TXDSIZE_8bit_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):8bit of 8bit */
#define URT_CR1_TXDSIZE_7bit_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):7bit of 32bit */
#define URT_CR1_TXDSIZE_7bit_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):7bit of 16bit */
#define URT_CR1_TXDSIZE_7bit_b2                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):7bit of 8bit */

#define URT_CR1_RXOS_NUM_mask_w                     ((uint32_t)0x00001F00)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXOS_NUM_mask_h0                    ((uint16_t)0x1F00)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXOS_NUM_mask_b1                    ((uint8_t )0x1F)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXOS_NUM_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define URT_CR1_RXOS_NUM_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define URT_CR1_RXOS_NUM_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define URT_CR1_RXSTP_LEN_mask_w                    ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXSTP_LEN_mask_h0                   ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXSTP_LEN_mask_b0                   ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXSTP_LEN_0_5bit_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0.5bit of 32bit */
#define URT_CR1_RXSTP_LEN_0_5bit_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0.5bit of 16bit */
#define URT_CR1_RXSTP_LEN_0_5bit_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0x0):0.5bit of 8bit */
#define URT_CR1_RXSTP_LEN_1bit_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(0x1):1bit of 32bit */
#define URT_CR1_RXSTP_LEN_1bit_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(0x1):1bit of 16bit */
#define URT_CR1_RXSTP_LEN_1bit_b0                   ((uint8_t )0x40)        /*!< Bit Value =(0x1):1bit of 8bit */
#define URT_CR1_RXSTP_LEN_1_5bit_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(0x2):1.5bit of 32bit */
#define URT_CR1_RXSTP_LEN_1_5bit_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(0x2):1.5bit of 16bit */
#define URT_CR1_RXSTP_LEN_1_5bit_b0                 ((uint8_t )0x80)        /*!< Bit Value =(0x2):1.5bit of 8bit */
#define URT_CR1_RXSTP_LEN_2bit_w                    ((uint32_t)0x000000C0)  /*!< Bit Value =(0x3):2bit of 32bit */
#define URT_CR1_RXSTP_LEN_2bit_h0                   ((uint16_t)0x00C0)      /*!< Bit Value =(0x3):2bit of 16bit */
#define URT_CR1_RXSTP_LEN_2bit_b0                   ((uint8_t )0xC0)        /*!< Bit Value =(0x3):2bit of 8bit */

#define URT_CR1_RXMSB_EN_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXMSB_EN_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXMSB_EN_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXMSB_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_RXMSB_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_RXMSB_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_RXMSB_EN_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_RXMSB_EN_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_RXMSB_EN_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_RXPAR_STK_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXPAR_STK_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXPAR_STK_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXPAR_STK_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_RXPAR_STK_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_RXPAR_STK_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_RXPAR_STK_enable_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_RXPAR_STK_enable_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_RXPAR_STK_enable_b0                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_RXPAR_POL_mask_w                    ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXPAR_POL_mask_h0                   ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXPAR_POL_mask_b0                   ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXPAR_POL_even_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Even of 32bit */
#define URT_CR1_RXPAR_POL_even_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Even of 16bit */
#define URT_CR1_RXPAR_POL_even_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):Even of 8bit */
#define URT_CR1_RXPAR_POL_odd_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(0x1):Odd of 32bit */
#define URT_CR1_RXPAR_POL_odd_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(0x1):Odd of 16bit */
#define URT_CR1_RXPAR_POL_odd_b0                    ((uint8_t )0x08)        /*!< Bit Value =(0x1):Odd of 8bit */

#define URT_CR1_RXPAR_EN_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXPAR_EN_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXPAR_EN_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXPAR_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR1_RXPAR_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR1_RXPAR_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR1_RXPAR_EN_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR1_RXPAR_EN_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR1_RXPAR_EN_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR1_RXDSIZE_mask_w                      ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define URT_CR1_RXDSIZE_mask_h0                     ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define URT_CR1_RXDSIZE_mask_b0                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define URT_CR1_RXDSIZE_8bit_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):8bit of 32bit */
#define URT_CR1_RXDSIZE_8bit_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):8bit of 16bit */
#define URT_CR1_RXDSIZE_8bit_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):8bit of 8bit */
#define URT_CR1_RXDSIZE_7bit_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):7bit of 32bit */
#define URT_CR1_RXDSIZE_7bit_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(0x1):7bit of 16bit */
#define URT_CR1_RXDSIZE_7bit_b0                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):7bit of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CR2  [register's definitions]
 *              Offset[0x18]  URT control register 2
 ******************************************************************************
 */
///@{
#define URT_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CR2 */
#define URT_CR2_DOUT_IDL_mask_w                     ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_DOUT_IDL_mask_h1                    ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define URT_CR2_DOUT_IDL_mask_b3                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define URT_CR2_DOUT_IDL_lbit_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LBIT of 32bit */
#define URT_CR2_DOUT_IDL_lbit_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LBIT of 16bit */
#define URT_CR2_DOUT_IDL_lbit_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):LBIT of 8bit */
#define URT_CR2_DOUT_IDL_0_w                        ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):0 of 32bit */
#define URT_CR2_DOUT_IDL_0_h1                       ((uint16_t)0x8000)      /*!< Bit Value =(0x2):0 of 16bit */
#define URT_CR2_DOUT_IDL_0_b3                       ((uint8_t )0x80)        /*!< Bit Value =(0x2):0 of 8bit */
#define URT_CR2_DOUT_IDL_1_w                        ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):1 of 32bit */
#define URT_CR2_DOUT_IDL_1_h1                       ((uint16_t)0xC000)      /*!< Bit Value =(0x3):1 of 16bit */
#define URT_CR2_DOUT_IDL_1_b3                       ((uint8_t )0xC0)        /*!< Bit Value =(0x3):1 of 8bit */

#define URT_CR2_DOUT_MDS_mask_w                     ((uint32_t)0x20000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_DOUT_MDS_mask_h1                    ((uint16_t)0x2000)      /*!< Bit Mask of 16bit */
#define URT_CR2_DOUT_MDS_mask_b3                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR2_DOUT_MDS_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_DOUT_MDS_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_DOUT_MDS_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_DOUT_MDS_enable_w                   ((uint32_t)0x20000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_DOUT_MDS_enable_h1                  ((uint16_t)0x2000)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_DOUT_MDS_enable_b3                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_NSSI_EN_mask_w                      ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSSI_EN_mask_h1                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSSI_EN_mask_b3                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSSI_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_NSSI_EN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_NSSI_EN_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_NSSI_EN_enable_w                    ((uint32_t)0x08000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_NSSI_EN_enable_h1                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_NSSI_EN_enable_b3                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_NSS_SWEN_mask_w                     ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSS_SWEN_mask_h1                    ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSS_SWEN_mask_b3                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSS_SWEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_NSS_SWEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_NSS_SWEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_NSS_SWEN_enable_w                   ((uint32_t)0x04000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_NSS_SWEN_enable_h1                  ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_NSS_SWEN_enable_b3                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_NSS_INV_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSS_INV_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSS_INV_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSS_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_NSS_INV_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_NSS_INV_disable_b3                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_NSS_INV_enable_w                    ((uint32_t)0x02000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_NSS_INV_enable_h1                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_NSS_INV_enable_b3                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_NSSI_INV_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSSI_INV_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSSI_INV_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSSI_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_NSSI_INV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_NSSI_INV_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_NSSI_INV_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_NSSI_INV_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_NSSI_INV_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_NSS_SWI_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSS_SWI_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSS_SWI_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSS_SWI_shift_w                     (17)                    /*!< Bit Shift of 32bit */
#define URT_CR2_NSS_SWI_shift_h1                    (1)                     /*!< Bit Shift of 16bit */
#define URT_CR2_NSS_SWI_shift_b2                    (1)                     /*!< Bit Shift of 8bit */

#define URT_CR2_NSS_SWO_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define URT_CR2_NSS_SWO_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_CR2_NSS_SWO_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CR2_NSS_SWO_shift_w                     (16)                    /*!< Bit Shift of 32bit */
#define URT_CR2_NSS_SWO_shift_h1                    (0)                     /*!< Bit Shift of 16bit */
#define URT_CR2_NSS_SWO_shift_b2                    (0)                     /*!< Bit Shift of 8bit */

#define URT_CR2_TX_HALT_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_CR2_TX_HALT_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR2_TX_HALT_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR2_TX_HALT_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_TX_HALT_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_TX_HALT_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_TX_HALT_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_TX_HALT_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_TX_HALT_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_TX_EN_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_CR2_TX_EN_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_CR2_TX_EN_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_CR2_TX_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_TX_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_TX_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_TX_EN_enable_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_TX_EN_enable_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_TX_EN_enable_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_RX_EN_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_CR2_RX_EN_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_CR2_RX_EN_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR2_RX_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR2_RX_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR2_RX_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR2_RX_EN_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR2_RX_EN_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR2_RX_EN_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR2_ADR_TX_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_CR2_ADR_TX_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_CR2_ADR_TX_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR2_ADR_TX_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_CR2_ADR_TX_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_CR2_ADR_TX_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_CR2_ADR_TX_send_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(1):Send of 32bit */
#define URT_CR2_ADR_TX_send_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(1):Send of 16bit */
#define URT_CR2_ADR_TX_send_b0                      ((uint8_t )0x02)        /*!< Bit Value =(1):Send of 8bit */

#define URT_CR2_BK_TX_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_CR2_BK_TX_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_CR2_BK_TX_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CR2_BK_TX_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_CR2_BK_TX_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_CR2_BK_TX_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_CR2_BK_TX_send_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Send of 32bit */
#define URT_CR2_BK_TX_send_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Send of 16bit */
#define URT_CR2_BK_TX_send_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Send of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CR3  [register's definitions]
 *              Offset[0x1C]  URT control register 3
 ******************************************************************************
 */
///@{
#define URT_CR3_default                             ((uint32_t)0x00000A00)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CR3 */
#define URT_CR3_TXGT_LEN_mask_w                     ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define URT_CR3_TXGT_LEN_mask_h1                    ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_CR3_TXGT_LEN_mask_b2                    ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

#define URT_CR3_DET_IDL_mask_w                      ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define URT_CR3_DET_IDL_mask_h0                     ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define URT_CR3_DET_IDL_mask_b1                     ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_CR3_DET_IDL_shift_w                     (8)                     /*!< Bit Shift of 32bit */
#define URT_CR3_DET_IDL_shift_h0                    (8)                     /*!< Bit Shift of 16bit */
#define URT_CR3_DET_IDL_shift_b1                    (0)                     /*!< Bit Shift of 8bit */

#define URT_CR3_DET_BK_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_CR3_DET_BK_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR3_DET_BK_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR3_DET_BK_1bit_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1Bit of 32bit */
#define URT_CR3_DET_BK_1bit_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1Bit of 16bit */
#define URT_CR3_DET_BK_1bit_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):1Bit of 8bit */
#define URT_CR3_DET_BK_3bit_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):3Bit of 32bit */
#define URT_CR3_DET_BK_3bit_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):3Bit of 16bit */
#define URT_CR3_DET_BK_3bit_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):3Bit of 8bit */

#define URT_CR3_CPHA_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_CR3_CPHA_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_CR3_CPHA_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_CR3_CPHA_leading_edge_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Leading edge of 32bit */
#define URT_CR3_CPHA_leading_edge_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Leading edge of 16bit */
#define URT_CR3_CPHA_leading_edge_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Leading edge of 8bit */
#define URT_CR3_CPHA_trailing_edge_w                ((uint32_t)0x00000004)  /*!< Bit Value =(1):Trailing edge of 32bit */
#define URT_CR3_CPHA_trailing_edge_h0               ((uint16_t)0x0004)      /*!< Bit Value =(1):Trailing edge of 16bit */
#define URT_CR3_CPHA_trailing_edge_b0               ((uint8_t )0x04)        /*!< Bit Value =(1):Trailing edge of 8bit */

#define URT_CR3_CPOL_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_CR3_CPOL_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_CR3_CPOL_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CR3_CPOL_low_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):Low of 32bit */
#define URT_CR3_CPOL_low_h0                         ((uint16_t)0x0000)      /*!< Bit Value =(0):Low of 16bit */
#define URT_CR3_CPOL_low_b0                         ((uint8_t )0x00)        /*!< Bit Value =(0):Low of 8bit */
#define URT_CR3_CPOL_high_w                         ((uint32_t)0x00000002)  /*!< Bit Value =(1):High of 32bit */
#define URT_CR3_CPOL_high_h0                        ((uint16_t)0x0002)      /*!< Bit Value =(1):High of 16bit */
#define URT_CR3_CPOL_high_b0                        ((uint8_t )0x02)        /*!< Bit Value =(1):High of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CR4  [register's definitions]
 *              Offset[0x20]  URT control register 4
 ******************************************************************************
 */
///@{
#define URT_CR4_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CR4 */
#define URT_CR4_TNUM_mask_w                         ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define URT_CR4_TNUM_mask_h0                        ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define URT_CR4_TNUM_mask_b1                        ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define URT_CR4_TNUM_0_w                            ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define URT_CR4_TNUM_0_h0                           ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define URT_CR4_TNUM_0_b1                           ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define URT_CR4_TNUM_1_w                            ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):1 of 32bit */
#define URT_CR4_TNUM_1_h0                           ((uint16_t)0x1000)      /*!< Bit Value =(0x1):1 of 16bit */
#define URT_CR4_TNUM_1_b1                           ((uint8_t )0x10)        /*!< Bit Value =(0x1):1 of 8bit */
#define URT_CR4_TNUM_2_w                            ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):2 of 32bit */
#define URT_CR4_TNUM_2_h0                           ((uint16_t)0x2000)      /*!< Bit Value =(0x2):2 of 16bit */
#define URT_CR4_TNUM_2_b1                           ((uint8_t )0x20)        /*!< Bit Value =(0x2):2 of 8bit */
#define URT_CR4_TNUM_3_w                            ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):3 of 32bit */
#define URT_CR4_TNUM_3_h0                           ((uint16_t)0x3000)      /*!< Bit Value =(0x3):3 of 16bit */
#define URT_CR4_TNUM_3_b1                           ((uint8_t )0x30)        /*!< Bit Value =(0x3):3 of 8bit */
#define URT_CR4_TNUM_4_w                            ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):4 of 32bit */
#define URT_CR4_TNUM_4_h0                           ((uint16_t)0x4000)      /*!< Bit Value =(0x4):4 of 16bit */
#define URT_CR4_TNUM_4_b1                           ((uint8_t )0x40)        /*!< Bit Value =(0x4):4 of 8bit */

#define URT_CR4_RNUM_mask_w                         ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define URT_CR4_RNUM_mask_h0                        ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define URT_CR4_RNUM_mask_b1                        ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define URT_CR4_RNUM_0_w                            ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):0 of 32bit */
#define URT_CR4_RNUM_0_h0                           ((uint16_t)0x0000)      /*!< Bit Value =(0x0):0 of 16bit */
#define URT_CR4_RNUM_0_b1                           ((uint8_t )0x00)        /*!< Bit Value =(0x0):0 of 8bit */
#define URT_CR4_RNUM_1_w                            ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):1 of 32bit */
#define URT_CR4_RNUM_1_h0                           ((uint16_t)0x0100)      /*!< Bit Value =(0x1):1 of 16bit */
#define URT_CR4_RNUM_1_b1                           ((uint8_t )0x01)        /*!< Bit Value =(0x1):1 of 8bit */
#define URT_CR4_RNUM_2_w                            ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):2 of 32bit */
#define URT_CR4_RNUM_2_h0                           ((uint16_t)0x0200)      /*!< Bit Value =(0x2):2 of 16bit */
#define URT_CR4_RNUM_2_b1                           ((uint8_t )0x02)        /*!< Bit Value =(0x2):2 of 8bit */
#define URT_CR4_RNUM_3_w                            ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):3 of 32bit */
#define URT_CR4_RNUM_3_h0                           ((uint16_t)0x0300)      /*!< Bit Value =(0x3):3 of 16bit */
#define URT_CR4_RNUM_3_b1                           ((uint8_t )0x03)        /*!< Bit Value =(0x3):3 of 8bit */
#define URT_CR4_RNUM_4_w                            ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):4 of 32bit */
#define URT_CR4_RNUM_4_h0                           ((uint16_t)0x0400)      /*!< Bit Value =(0x4):4 of 16bit */
#define URT_CR4_RNUM_4_b1                           ((uint8_t )0x04)        /*!< Bit Value =(0x4):4 of 8bit */

#define URT_CR4_TDAT_CLR_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_CR4_TDAT_CLR_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_CR4_TDAT_CLR_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CR4_TDAT_CLR_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR4_TDAT_CLR_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR4_TDAT_CLR_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR4_TDAT_CLR_enable_w                   ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR4_TDAT_CLR_enable_h0                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR4_TDAT_CLR_enable_b0                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR4_RDAT_CLR_mask_w                     ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define URT_CR4_RDAT_CLR_mask_h0                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_CR4_RDAT_CLR_mask_b0                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_CR4_RDAT_CLR_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR4_RDAT_CLR_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR4_RDAT_CLR_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR4_RDAT_CLR_enable_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR4_RDAT_CLR_enable_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR4_RDAT_CLR_enable_b0                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR4_TDAT_INV_mask_w                     ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_CR4_TDAT_INV_mask_h0                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_CR4_TDAT_INV_mask_b0                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_CR4_TDAT_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR4_TDAT_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR4_TDAT_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR4_TDAT_INV_enable_w                   ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR4_TDAT_INV_enable_h0                  ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR4_TDAT_INV_enable_b0                  ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CR4_RDAT_INV_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_CR4_RDAT_INV_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_CR4_RDAT_INV_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_CR4_RDAT_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CR4_RDAT_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CR4_RDAT_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CR4_RDAT_INV_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CR4_RDAT_INV_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CR4_RDAT_INV_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_RLR  [register's definitions]
 *              Offset[0x24]  URT baud-rate clock counter reload register
 ******************************************************************************
 */
///@{
#define URT_RLR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_RLR */
#define URT_RLR_PSR_mask_w                          ((uint32_t)0x00003F00)  /*!< Bit Mask of 32bit */
#define URT_RLR_PSR_mask_h0                         ((uint16_t)0x3F00)      /*!< Bit Mask of 16bit */
#define URT_RLR_PSR_mask_b1                         ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define URT_RLR_PSR_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define URT_RLR_PSR_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define URT_RLR_PSR_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define URT_RLR_RLR_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define URT_RLR_RLR_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_RLR_RLR_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_RLR_RLR_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define URT_RLR_RLR_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define URT_RLR_RLR_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CNT  [register's definitions]
 *              Offset[0x28]  URT baud-rate clock counter register
 ******************************************************************************
 */
///@{
#define URT_CNT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CNT */
#define URT_CNT_PSC_mask_w                          ((uint32_t)0x00003F00)  /*!< Bit Mask of 32bit */
#define URT_CNT_PSC_mask_h0                         ((uint16_t)0x3F00)      /*!< Bit Mask of 16bit */
#define URT_CNT_PSC_mask_b1                         ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define URT_CNT_PSC_shift_w                         (8)                     /*!< Bit Shift of 32bit */
#define URT_CNT_PSC_shift_h0                        (8)                     /*!< Bit Shift of 16bit */
#define URT_CNT_PSC_shift_b1                        (0)                     /*!< Bit Shift of 8bit */

#define URT_CNT_CNT_mask_w                          ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define URT_CNT_CNT_mask_h0                         ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_CNT_CNT_mask_b0                         ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_CNT_CNT_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define URT_CNT_CNT_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define URT_CNT_CNT_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_RCAP  [register's definitions]
 *              Offset[0x2C]  URT RX data capture register
 ******************************************************************************
 */
///@{
#define URT_RCAP_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_RCAP */
#define URT_RCAP_RCAP_ADR_mask_w                    ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define URT_RCAP_RCAP_ADR_mask_h0                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define URT_RCAP_RCAP_ADR_mask_b1                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_RCAP_RCAP_ADR_shift_w                   (10)                    /*!< Bit Shift of 32bit */
#define URT_RCAP_RCAP_ADR_shift_h0                  (10)                    /*!< Bit Shift of 16bit */
#define URT_RCAP_RCAP_ADR_shift_b1                  (2)                     /*!< Bit Shift of 8bit */

#define URT_RCAP_RCAP_PAR_mask_w                    ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define URT_RCAP_RCAP_PAR_mask_h0                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_RCAP_RCAP_PAR_mask_b1                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_RCAP_RCAP_PAR_shift_w                   (9)                     /*!< Bit Shift of 32bit */
#define URT_RCAP_RCAP_PAR_shift_h0                  (9)                     /*!< Bit Shift of 16bit */
#define URT_RCAP_RCAP_PAR_shift_b1                  (1)                     /*!< Bit Shift of 8bit */

#define URT_RCAP_RCAP_STP_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define URT_RCAP_RCAP_STP_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_RCAP_RCAP_STP_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_RCAP_RCAP_STP_shift_w                   (8)                     /*!< Bit Shift of 32bit */
#define URT_RCAP_RCAP_STP_shift_h0                  (8)                     /*!< Bit Shift of 16bit */
#define URT_RCAP_RCAP_STP_shift_b1                  (0)                     /*!< Bit Shift of 8bit */

#define URT_RCAP_RCAP_DAT_mask_w                    ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define URT_RCAP_RCAP_DAT_mask_h0                   ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_RCAP_RCAP_DAT_mask_b0                   ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_RCAP_RCAP_DAT_shift_w                   (0)                     /*!< Bit Shift of 32bit */
#define URT_RCAP_RCAP_DAT_shift_h0                  (0)                     /*!< Bit Shift of 16bit */
#define URT_RCAP_RCAP_DAT_shift_b0                  (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_RDAT  [register's definitions]
 *              Offset[0x30]  URT RX data register
 ******************************************************************************
 */
///@{
#define URT_RDAT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_RDAT */
#define URT_RDAT_RDAT_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define URT_RDAT_RDAT_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define URT_RDAT_RDAT_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define URT_RDAT_RDAT_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_TDAT  [register's definitions]
 *              Offset[0x34]  URT TX data register
 ******************************************************************************
 */
///@{
#define URT_TDAT_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_TDAT */
#define URT_TDAT_TDAT_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define URT_TDAT_TDAT_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define URT_TDAT_TDAT_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define URT_TDAT_TDAT_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_TDAT3  [register's definitions]
 *              Offset[0x38]  URT TX data 3-byte register
 ******************************************************************************
 */
///@{
#define URT_TDAT3_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_TDAT3 */
#define URT_TDAT3_TDAT3_mask_w                      ((uint32_t)0x00FFFFFF)  /*!< Bit Mask of 32bit */
#define URT_TDAT3_TDAT3_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define URT_TDAT3_TDAT3_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define URT_TDAT3_TDAT3_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_SBUF  [register's definitions]
 *              Offset[0x3C]  URT data shift buffer register
 ******************************************************************************
 */
///@{
#define URT_SBUF_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_SBUF */
#define URT_SBUF_TSBUF_mask_w                       ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define URT_SBUF_TSBUF_mask_h0                      ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define URT_SBUF_TSBUF_mask_b1                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_SBUF_TSBUF_shift_w                      (8)                     /*!< Bit Shift of 32bit */
#define URT_SBUF_TSBUF_shift_h0                     (8)                     /*!< Bit Shift of 16bit */
#define URT_SBUF_TSBUF_shift_b1                     (0)                     /*!< Bit Shift of 8bit */

#define URT_SBUF_RSBUF_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define URT_SBUF_RSBUF_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_SBUF_RSBUF_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_SBUF_RSBUF_shift_w                      (0)                     /*!< Bit Shift of 32bit */
#define URT_SBUF_RSBUF_shift_h0                     (0)                     /*!< Bit Shift of 16bit */
#define URT_SBUF_RSBUF_shift_b0                     (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT  [register's definitions]
 *              Offset[0x40]  URT timeout control register
 ******************************************************************************
 */
///@{
#define URT_TMOUT_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_TMOUT */
#define URT_TMOUT_CALTMO_TH_mask_w                  ((uint32_t)0xF0000000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_CALTMO_TH_mask_h1                 ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_CALTMO_TH_mask_b3                 ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_CALTMO_TH_shift_w                 (28)                    /*!< Bit Shift of 32bit */
#define URT_TMOUT_CALTMO_TH_shift_h1                (12)                    /*!< Bit Shift of 16bit */
#define URT_TMOUT_CALTMO_TH_shift_b3                (4)                     /*!< Bit Shift of 8bit */

#define URT_TMOUT_BKTMO_TH_mask_w                   ((uint32_t)0x0F000000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_BKTMO_TH_mask_h1                  ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_BKTMO_TH_mask_b3                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_BKTMO_TH_shift_w                  (24)                    /*!< Bit Shift of 32bit */
#define URT_TMOUT_BKTMO_TH_shift_h1                 (8)                     /*!< Bit Shift of 16bit */
#define URT_TMOUT_BKTMO_TH_shift_b3                 (0)                     /*!< Bit Shift of 8bit */

#define URT_TMOUT_RXTMO_TH_mask_w                   ((uint32_t)0x00FF0000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_RXTMO_TH_mask_h1                  ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_RXTMO_TH_mask_b2                  ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_RXTMO_TH_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define URT_TMOUT_RXTMO_TH_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define URT_TMOUT_RXTMO_TH_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define URT_TMOUT_TMO_LCK_mask_w                    ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_LCK_mask_h0                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_LCK_mask_b1                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_LCK_locked_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define URT_TMOUT_TMO_LCK_locked_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define URT_TMOUT_TMO_LCK_locked_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define URT_TMOUT_TMO_LCK_un_locked_w               ((uint32_t)0x00008000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define URT_TMOUT_TMO_LCK_un_locked_h0              ((uint16_t)0x8000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define URT_TMOUT_TMO_LCK_un_locked_b1              ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define URT_TMOUT_TMO_STA_mask_w                    ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_STA_mask_h0                   ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_STA_mask_b1                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_STA_0_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define URT_TMOUT_TMO_STA_0_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define URT_TMOUT_TMO_STA_0_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define URT_TMOUT_TMO_STA_1_w                       ((uint32_t)0x00004000)  /*!< Bit Value =(1):1 of 32bit */
#define URT_TMOUT_TMO_STA_1_h0                      ((uint16_t)0x4000)      /*!< Bit Value =(1):1 of 16bit */
#define URT_TMOUT_TMO_STA_1_b1                      ((uint8_t )0x40)        /*!< Bit Value =(1):1 of 8bit */

#define URT_TMOUT_TMO_CKS_mask_w                    ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_CKS_mask_h0                   ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_CKS_mask_b1                   ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_CKS_uart_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):UART of 32bit */
#define URT_TMOUT_TMO_CKS_uart_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):UART of 16bit */
#define URT_TMOUT_TMO_CKS_uart_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):UART of 8bit */
#define URT_TMOUT_TMO_CKS_input_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Input of 32bit */
#define URT_TMOUT_TMO_CKS_input_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Input of 16bit */
#define URT_TMOUT_TMO_CKS_input_b1                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):Input of 8bit */
#define URT_TMOUT_TMO_CKS_noise_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Noise of 32bit */
#define URT_TMOUT_TMO_CKS_noise_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Noise of 16bit */
#define URT_TMOUT_TMO_CKS_noise_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Noise of 8bit */

#define URT_TMOUT_CALTMO_EN_mask_w                  ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_CALTMO_EN_mask_h0                 ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_CALTMO_EN_mask_b0                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_CALTMO_EN_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_CALTMO_EN_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_CALTMO_EN_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_CALTMO_EN_enable_w                ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_CALTMO_EN_enable_h0               ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_CALTMO_EN_enable_b0               ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_TMOUT_BKTMO_EN_mask_w                   ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_BKTMO_EN_mask_h0                  ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_BKTMO_EN_mask_b0                  ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_BKTMO_EN_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_BKTMO_EN_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_BKTMO_EN_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_BKTMO_EN_enable_w                 ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_BKTMO_EN_enable_h0                ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_BKTMO_EN_enable_b0                ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_TMOUT_RXTMO_EN_mask_w                   ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_RXTMO_EN_mask_h0                  ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_RXTMO_EN_mask_b0                  ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_RXTMO_EN_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_RXTMO_EN_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_RXTMO_EN_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_RXTMO_EN_enable_w                 ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_RXTMO_EN_enable_h0                ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_RXTMO_EN_enable_b0                ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_TMOUT_IDTMO_EN_mask_w                   ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_IDTMO_EN_mask_h0                  ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_IDTMO_EN_mask_b0                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_IDTMO_EN_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_IDTMO_EN_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_IDTMO_EN_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_IDTMO_EN_enable_w                 ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_IDTMO_EN_enable_h0                ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_IDTMO_EN_enable_b0                ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_TMOUT_TMO_MDS_mask_w                    ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_MDS_mask_h0                   ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_MDS_mask_b0                   ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_MDS_uart_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):UART of 32bit */
#define URT_TMOUT_TMO_MDS_uart_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):UART of 16bit */
#define URT_TMOUT_TMO_MDS_uart_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):UART of 8bit */
#define URT_TMOUT_TMO_MDS_general_w                 ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):General of 32bit */
#define URT_TMOUT_TMO_MDS_general_h0                ((uint16_t)0x0004)      /*!< Bit Value =(0x1):General of 16bit */
#define URT_TMOUT_TMO_MDS_general_b0                ((uint8_t )0x04)        /*!< Bit Value =(0x1):General of 8bit */

#define URT_TMOUT_TMO_RST_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_RST_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_RST_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_RST_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_TMO_RST_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_TMO_RST_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_TMO_RST_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_TMO_RST_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_TMO_RST_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_TMOUT_TMO_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_TMOUT_TMO_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_TMOUT_TMO_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_TMOUT_TMO_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_TMOUT_TMO_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_TMOUT_TMO_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_TMOUT_TMO_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_TMOUT_TMO_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_TMOUT_TMO_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT2  [register's definitions]
 *              Offset[0x44]  URT timeout control register 2
 ******************************************************************************
 */
///@{
#define URT_TMOUT2_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_TMOUT2 */
#define URT_TMOUT2_TMO_CNT_mask_w                   ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define URT_TMOUT2_TMO_CNT_mask_h1                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define URT_TMOUT2_TMO_CNT_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define URT_TMOUT2_TMO_CNT_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define URT_TMOUT2_TMO_CNT_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define URT_TMOUT2_IDTMO_TH_mask_w                  ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define URT_TMOUT2_IDTMO_TH_mask_h0                 ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define URT_TMOUT2_IDTMO_TH_shift_w                 (0)                     /*!< Bit Shift of 32bit */
#define URT_TMOUT2_IDTMO_TH_shift_h0                (0)                     /*!< Bit Shift of 16bit */
#define URT_TMOUT2_IDTMO_TH_shift_b0                (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_SC  [register's definitions]
 *              Offset[0x48]  URT SmartCard control register
 ******************************************************************************
 */
///@{
#define URT_SC_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_SC */
#define URT_SC_RXE_NUM_mask_w                       ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define URT_SC_RXE_NUM_mask_h0                      ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define URT_SC_RXE_NUM_mask_b1                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define URT_SC_RXE_NUM_shift_w                      (12)                    /*!< Bit Shift of 32bit */
#define URT_SC_RXE_NUM_shift_h0                     (12)                    /*!< Bit Shift of 16bit */
#define URT_SC_RXE_NUM_shift_b1                     (4)                     /*!< Bit Shift of 8bit */

#define URT_SC_TXE_NUM_mask_w                       ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define URT_SC_TXE_NUM_mask_h0                      ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define URT_SC_TXE_NUM_mask_b1                      ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define URT_SC_TXE_NUM_shift_w                      (8)                     /*!< Bit Shift of 32bit */
#define URT_SC_TXE_NUM_shift_h0                     (8)                     /*!< Bit Shift of 16bit */
#define URT_SC_TXE_NUM_shift_b1                     (0)                     /*!< Bit Shift of 8bit */

#define URT_SC_RXE_LEN_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_SC_RXE_LEN_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_SC_RXE_LEN_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_SC_RXE_LEN_1bit_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):1Bit of 32bit */
#define URT_SC_RXE_LEN_1bit_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):1Bit of 16bit */
#define URT_SC_RXE_LEN_1bit_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):1Bit of 8bit */
#define URT_SC_RXE_LEN_2bit_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):2Bit of 32bit */
#define URT_SC_RXE_LEN_2bit_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):2Bit of 16bit */
#define URT_SC_RXE_LEN_2bit_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):2Bit of 8bit */

#define URT_SC_TXE_MDS_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define URT_SC_TXE_MDS_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define URT_SC_TXE_MDS_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define URT_SC_TXE_MDS_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define URT_SC_TXE_MDS_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define URT_SC_TXE_MDS_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define URT_SC_TXE_MDS_chk_low_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):CHK_Low of 32bit */
#define URT_SC_TXE_MDS_chk_low_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CHK_Low of 16bit */
#define URT_SC_TXE_MDS_chk_low_b0                   ((uint8_t )0x04)        /*!< Bit Value =(0x1):CHK_Low of 8bit */
#define URT_SC_TXE_MDS_chk_tx_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):CHK_TX of 32bit */
#define URT_SC_TXE_MDS_chk_tx_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(0x2):CHK_TX of 16bit */
#define URT_SC_TXE_MDS_chk_tx_b0                    ((uint8_t )0x08)        /*!< Bit Value =(0x2):CHK_TX of 8bit */

#define URT_SC_RXE_MDS_mask_w                       ((uint32_t)0x00000003)  /*!< Bit Mask of 32bit */
#define URT_SC_RXE_MDS_mask_h0                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define URT_SC_RXE_MDS_mask_b0                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define URT_SC_RXE_MDS_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define URT_SC_RXE_MDS_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define URT_SC_RXE_MDS_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define URT_SC_RXE_MDS_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(0x1):Enable of 32bit */
#define URT_SC_RXE_MDS_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Enable of 16bit */
#define URT_SC_RXE_MDS_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(0x1):Enable of 8bit */
#define URT_SC_RXE_MDS_auto_w                       ((uint32_t)0x00000002)  /*!< Bit Value =(0x2):Auto of 32bit */
#define URT_SC_RXE_MDS_auto_h0                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Auto of 16bit */
#define URT_SC_RXE_MDS_auto_b0                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):Auto of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_SADR  [register's definitions]
 *              Offset[0x4C]  URT slave address detect register
 ******************************************************************************
 */
///@{
#define URT_SADR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_SADR */
#define URT_SADR_SA_MSK_mask_w                      ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define URT_SADR_SA_MSK_mask_h0                     ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define URT_SADR_SA_MSK_mask_b1                     ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define URT_SADR_SA_MSK_shift_w                     (8)                     /*!< Bit Shift of 32bit */
#define URT_SADR_SA_MSK_shift_h0                    (8)                     /*!< Bit Shift of 16bit */
#define URT_SADR_SA_MSK_shift_b1                    (0)                     /*!< Bit Shift of 8bit */

#define URT_SADR_SA_RX_mask_w                       ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define URT_SADR_SA_RX_mask_h0                      ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define URT_SADR_SA_RX_mask_b0                      ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_CAL  [register's definitions]
 *              Offset[0x50]  URT calibration control register
 ******************************************************************************
 */
///@{
#define URT_CAL_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_CAL */
#define URT_CAL_CALC_HE_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define URT_CAL_CALC_HE_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define URT_CAL_CALC_HE_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define URT_CAL_CALC_HE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CAL_CALC_HE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CAL_CALC_HE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CAL_CALC_HE_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CAL_CALC_HE_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CAL_CALC_HE_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CAL_CAL_MDS_mask_w                      ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define URT_CAL_CAL_MDS_mask_h0                     ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define URT_CAL_CAL_MDS_mask_b0                     ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define URT_CAL_CAL_MDS_start_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Start of 32bit */
#define URT_CAL_CAL_MDS_start_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Start of 16bit */
#define URT_CAL_CAL_MDS_start_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):Start of 8bit */
#define URT_CAL_CAL_MDS_edge_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):Edge of 32bit */
#define URT_CAL_CAL_MDS_edge_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(0x1):Edge of 16bit */
#define URT_CAL_CAL_MDS_edge_b0                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):Edge of 8bit */

#define URT_CAL_CAL_AUTO_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_CAL_CAL_AUTO_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_CAL_CAL_AUTO_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_CAL_CAL_AUTO_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CAL_CAL_AUTO_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CAL_CAL_AUTO_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CAL_CAL_AUTO_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CAL_CAL_AUTO_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CAL_CAL_AUTO_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_CAL_CAL_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_CAL_CAL_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_CAL_CAL_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_CAL_CAL_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_CAL_CAL_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_CAL_CAL_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_CAL_CAL_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_CAL_CAL_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_CAL_CAL_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_IRDA  [register's definitions]
 *              Offset[0x54]  URT IrDA control register
 ******************************************************************************
 */
///@{
#define URT_IRDA_default                            ((uint32_t)0x00000300)  /*!< Reg Reset Default Value */

/* Bit fields of URT_IRDA */
#define URT_IRDA_IR_PW_mask_w                       ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define URT_IRDA_IR_PW_mask_h0                      ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define URT_IRDA_IR_PW_mask_b1                      ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */

#define URT_IRDA_IR_MDS_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_IRDA_IR_MDS_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_IRDA_IR_MDS_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_IRDA_IR_MDS_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define URT_IRDA_IR_MDS_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define URT_IRDA_IR_MDS_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define URT_IRDA_IR_MDS_wide_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Wide of 32bit */
#define URT_IRDA_IR_MDS_wide_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Wide of 16bit */
#define URT_IRDA_IR_MDS_wide_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Wide of 8bit */

#define URT_IRDA_IR_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_IRDA_IR_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_IRDA_IR_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_IRDA_IR_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_IRDA_IR_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_IRDA_IR_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_IRDA_IR_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_IRDA_IR_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_IRDA_IR_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_HFC  [register's definitions]
 *              Offset[0x58]  URT hardware flow control register
 ******************************************************************************
 */
///@{
#define URT_HFC_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of URT_HFC */
#define URT_HFC_RTS_OUT_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define URT_HFC_RTS_OUT_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define URT_HFC_RTS_OUT_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define URT_HFC_RTS_OUT_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define URT_HFC_RTS_OUT_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define URT_HFC_RTS_OUT_0_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define URT_HFC_RTS_OUT_1_w                         ((uint32_t)0x00000010)  /*!< Bit Value =(1):1 of 32bit */
#define URT_HFC_RTS_OUT_1_h0                        ((uint16_t)0x0010)      /*!< Bit Value =(1):1 of 16bit */
#define URT_HFC_RTS_OUT_1_b0                        ((uint8_t )0x10)        /*!< Bit Value =(1):1 of 8bit */

#define URT_HFC_RTS_INV_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define URT_HFC_RTS_INV_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define URT_HFC_RTS_INV_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define URT_HFC_RTS_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_HFC_RTS_INV_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_HFC_RTS_INV_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_HFC_RTS_INV_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_HFC_RTS_INV_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_HFC_RTS_INV_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_HFC_CTS_INV_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define URT_HFC_CTS_INV_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_HFC_CTS_INV_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_HFC_CTS_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_HFC_CTS_INV_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_HFC_CTS_INV_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_HFC_CTS_INV_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_HFC_CTS_INV_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_HFC_CTS_INV_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_HFC_RTS_EN_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define URT_HFC_RTS_EN_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_HFC_RTS_EN_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_HFC_RTS_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_HFC_RTS_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_HFC_RTS_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_HFC_RTS_EN_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_HFC_RTS_EN_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_HFC_RTS_EN_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_HFC_CTS_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_HFC_CTS_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_HFC_CTS_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_HFC_CTS_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_HFC_CTS_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_HFC_CTS_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_HFC_CTS_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_HFC_CTS_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_HFC_CTS_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        URT_MUTE  [register's definitions]
 *              Offset[0x5C]  URT mute control register
 ******************************************************************************
 */
///@{
#define URT_MUTE_default                            ((uint32_t)0x00010100)  /*!< Reg Reset Default Value */

/* Bit fields of URT_MUTE */
#define URT_MUTE_MUTE_AEX2_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_AEX2_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_AEX2_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_AEX2_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_AEX2_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_AEX2_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_AEX2_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_AEX2_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_AEX2_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_MUTE_MUTE_AEX1_mask_w                   ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_AEX1_mask_h1                  ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_AEX1_mask_b2                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_AEX1_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_AEX1_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_AEX1_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_AEX1_enable_w                 ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_AEX1_enable_h1                ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_AEX1_enable_b2                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_MUTE_MUTE_AEX0_mask_w                   ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_AEX0_mask_h1                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_AEX0_mask_b2                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_AEX0_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_AEX0_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_AEX0_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_AEX0_enable_w                 ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_AEX0_enable_h1                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_AEX0_enable_b2                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_MUTE_MUTE_AEN1_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_AEN1_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_AEN1_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_AEN1_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_AEN1_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_AEN1_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_AEN1_enable_w                 ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_AEN1_enable_h0                ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_AEN1_enable_b1                ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_MUTE_MUTE_AEN0_mask_w                   ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_AEN0_mask_h0                  ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_AEN0_mask_b1                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_AEN0_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_AEN0_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_AEN0_disable_b1               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_AEN0_enable_w                 ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_AEN0_enable_h0                ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_AEN0_enable_b1                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define URT_MUTE_MUTE_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define URT_MUTE_MUTE_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define URT_MUTE_MUTE_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define URT_MUTE_MUTE_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define URT_MUTE_MUTE_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define URT_MUTE_MUTE_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define URT_MUTE_MUTE_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define URT_MUTE_MUTE_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define URT_MUTE_MUTE_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32_URT_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_URT.h                           */
/*----------------------------------------------------------------------------*/
