/**
 ******************************************************************************
 *
 * @file        MG32_OPA.h
 *
 * @brief       MG32 OPA Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.01 (Register File Date : 2025_0401)
 * @date        2025/06/16 10:22 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_OPA_H
#define _MG32_OPA_H
#define _MG32_OPA_H_VER                             101     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_OPA_H_VER)
    #error "_MG32_OPA_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      OPA_Struct
 *              OPA  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  OP0_S         :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  OP0_RF        :1;     //[2] 
            __IO uint8_t  OP0_FF        :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  OPA OPA status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  OP0_RIE       :1;     //[2] 
            __IO uint8_t  OP0_FIE       :1;     //[3] 
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  OPA OPA interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OP0_EN        :1;     //[0] OPA OP0 power-on enable bit. When disables, it will force the OPA output low.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OP0_CCEN      :1;     //[1] OP0 compensation capacitor enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  OP0_LPEN      :1;     //[2] OP0 low power mode enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  OP0_MDS       :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  OP0_PMUX      :2;     //[9..8] OP0 Analog input positive channel selection.
                                        //0x0 = VBUF
                                        //0x1 = OP0_I0
                                        //0x2 = PGA_P0
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  OP0_NMUX      :2;     //[13..12] OP0 Analog input negative channel selection.
                                        //0x0 = VBUF
                                        //0x1 = OP0_I1
                                        //0x2 = OP0_P0
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  OP0_INV       :1;     //[16] 
            __I  uint8_t                :1;     //[17] 
            __IO uint8_t  OP0_FSEL      :2;     //[19..18] 
            __IO uint8_t  OP0_FDIV      :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  OP0_OFFT      :6;     //[29..24] OP0 input offset adjust bits
            __I  uint8_t                :2;     //[31..30] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  OPA OPA-0 control register */

} OPA_Struct;

/**
 ******************************************************************************
 *
 * @name        OPA  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define OPA_Base                        ((uint32_t)0x5A080000)              /*!< Operational Amplifier Controller */
#define OPA                             ((OPA_Struct*) OPA_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        OPA  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        OPA_STA  [register's definitions]
 *              Offset[0x00]  OPA OPA status register (0x5A080000)
 ******************************************************************************
 */
///@{
#define OPA_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of OPA_STA */
#define OPA_STA_OP0_FF_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define OPA_STA_OP0_FF_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define OPA_STA_OP0_FF_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define OPA_STA_OP0_FF_normal_w                     ((uint32_t)0x00000000)
#define OPA_STA_OP0_FF_normal_h0                    ((uint16_t)0x0000)
#define OPA_STA_OP0_FF_normal_b0                    ((uint8_t )0x00)
#define OPA_STA_OP0_FF_happened_w                   ((uint32_t)0x00000008)
#define OPA_STA_OP0_FF_happened_h0                  ((uint16_t)0x0008)
#define OPA_STA_OP0_FF_happened_b0                  ((uint8_t )0x08)

#define OPA_STA_OP0_RF_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define OPA_STA_OP0_RF_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define OPA_STA_OP0_RF_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define OPA_STA_OP0_RF_normal_w                     ((uint32_t)0x00000000)
#define OPA_STA_OP0_RF_normal_h0                    ((uint16_t)0x0000)
#define OPA_STA_OP0_RF_normal_b0                    ((uint8_t )0x00)
#define OPA_STA_OP0_RF_happened_w                   ((uint32_t)0x00000004)
#define OPA_STA_OP0_RF_happened_h0                  ((uint16_t)0x0004)
#define OPA_STA_OP0_RF_happened_b0                  ((uint8_t )0x04)

#define OPA_STA_OP0_S_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define OPA_STA_OP0_S_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define OPA_STA_OP0_S_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        OPA_INT  [register's definitions]
 *              Offset[0x04]  OPA OPA interrupt enable register (0x5A080004)
 ******************************************************************************
 */
///@{
#define OPA_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of OPA_INT */
#define OPA_INT_OP0_FIE_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define OPA_INT_OP0_FIE_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define OPA_INT_OP0_FIE_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define OPA_INT_OP0_FIE_disable_w                   ((uint32_t)0x00000000)
#define OPA_INT_OP0_FIE_disable_h0                  ((uint16_t)0x0000)
#define OPA_INT_OP0_FIE_disable_b0                  ((uint8_t )0x00)
#define OPA_INT_OP0_FIE_enable_w                    ((uint32_t)0x00000008)
#define OPA_INT_OP0_FIE_enable_h0                   ((uint16_t)0x0008)
#define OPA_INT_OP0_FIE_enable_b0                   ((uint8_t )0x08)

#define OPA_INT_OP0_RIE_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define OPA_INT_OP0_RIE_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define OPA_INT_OP0_RIE_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define OPA_INT_OP0_RIE_disable_w                   ((uint32_t)0x00000000)
#define OPA_INT_OP0_RIE_disable_h0                  ((uint16_t)0x0000)
#define OPA_INT_OP0_RIE_disable_b0                  ((uint8_t )0x00)
#define OPA_INT_OP0_RIE_enable_w                    ((uint32_t)0x00000004)
#define OPA_INT_OP0_RIE_enable_h0                   ((uint16_t)0x0004)
#define OPA_INT_OP0_RIE_enable_b0                   ((uint8_t )0x04)

#define OPA_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define OPA_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define OPA_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define OPA_INT_IEA_disable_w                       ((uint32_t)0x00000000)
#define OPA_INT_IEA_disable_h0                      ((uint16_t)0x0000)
#define OPA_INT_IEA_disable_b0                      ((uint8_t )0x00)
#define OPA_INT_IEA_enable_w                        ((uint32_t)0x00000001)
#define OPA_INT_IEA_enable_h0                       ((uint16_t)0x0001)
#define OPA_INT_IEA_enable_b0                       ((uint8_t )0x01)

///@}
/**
 ******************************************************************************
 * @name        OPA_CR0  [register's definitions]
 *              Offset[0x10]  OPA OPA-0 control register (0x5A080010)
 ******************************************************************************
 */
///@{
#define OPA_CR0_default                             ((uint32_t)0x00000002)  /*!< Reg Reset Default Value */

/* Bit fields of OPA_CR0 */
#define OPA_CR0_OP0_OFFT_mask_w                     ((uint32_t)0x3F000000)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_OFFT_mask_h1                    ((uint16_t)0x3F00)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_OFFT_mask_b3                    ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_OFFT_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define OPA_CR0_OP0_OFFT_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define OPA_CR0_OP0_OFFT_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define OPA_CR0_OP0_FDIV_mask_w                     ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_FDIV_mask_h1                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_FDIV_mask_b2                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_FDIV_div1_w                     ((uint32_t)0x00000000)
#define OPA_CR0_OP0_FDIV_div1_h1                    ((uint16_t)0x0000)
#define OPA_CR0_OP0_FDIV_div1_b2                    ((uint8_t )0x00)
#define OPA_CR0_OP0_FDIV_div2_w                     ((uint32_t)0x00100000)
#define OPA_CR0_OP0_FDIV_div2_h1                    ((uint16_t)0x0010)
#define OPA_CR0_OP0_FDIV_div2_b2                    ((uint8_t )0x10)
#define OPA_CR0_OP0_FDIV_div4_w                     ((uint32_t)0x00200000)
#define OPA_CR0_OP0_FDIV_div4_h1                    ((uint16_t)0x0020)
#define OPA_CR0_OP0_FDIV_div4_b2                    ((uint8_t )0x20)
#define OPA_CR0_OP0_FDIV_div8_w                     ((uint32_t)0x00300000)
#define OPA_CR0_OP0_FDIV_div8_h1                    ((uint16_t)0x0030)
#define OPA_CR0_OP0_FDIV_div8_b2                    ((uint8_t )0x30)

#define OPA_CR0_OP0_FSEL_mask_w                     ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_FSEL_mask_h1                    ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_FSEL_mask_b2                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_FSEL_bypass_w                   ((uint32_t)0x00000000)
#define OPA_CR0_OP0_FSEL_bypass_h1                  ((uint16_t)0x0000)
#define OPA_CR0_OP0_FSEL_bypass_b2                  ((uint8_t )0x00)
#define OPA_CR0_OP0_FSEL_opa_ck_w                   ((uint32_t)0x00040000)
#define OPA_CR0_OP0_FSEL_opa_ck_h1                  ((uint16_t)0x0004)
#define OPA_CR0_OP0_FSEL_opa_ck_b2                  ((uint8_t )0x04)
#define OPA_CR0_OP0_FSEL_tm00_trgo_w                ((uint32_t)0x00080000)
#define OPA_CR0_OP0_FSEL_tm00_trgo_h1               ((uint16_t)0x0008)
#define OPA_CR0_OP0_FSEL_tm00_trgo_b2               ((uint8_t )0x08)
#define OPA_CR0_OP0_FSEL_tm01_trgo_w                ((uint32_t)0x000C0000)
#define OPA_CR0_OP0_FSEL_tm01_trgo_h1               ((uint16_t)0x000C)
#define OPA_CR0_OP0_FSEL_tm01_trgo_b2               ((uint8_t )0x0C)

#define OPA_CR0_OP0_INV_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_INV_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_INV_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_INV_positive_w                  ((uint32_t)0x00000000)
#define OPA_CR0_OP0_INV_positive_h1                 ((uint16_t)0x0000)
#define OPA_CR0_OP0_INV_positive_b2                 ((uint8_t )0x00)
#define OPA_CR0_OP0_INV_negative_w                  ((uint32_t)0x00010000)
#define OPA_CR0_OP0_INV_negative_h1                 ((uint16_t)0x0001)
#define OPA_CR0_OP0_INV_negative_b2                 ((uint8_t )0x01)

#define OPA_CR0_OP0_NMUX_mask_w                     ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_NMUX_mask_h0                    ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_NMUX_mask_b1                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_NMUX_vbuf_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):VBUF of 32bit */
#define OPA_CR0_OP0_NMUX_vbuf_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):VBUF of 16bit */
#define OPA_CR0_OP0_NMUX_vbuf_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):VBUF of 8bit */
#define OPA_CR0_OP0_NMUX_op0_i1_w                   ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):OP0_I1 of 32bit */
#define OPA_CR0_OP0_NMUX_op0_i1_h0                  ((uint16_t)0x1000)      /*!< Bit Value =(0x1):OP0_I1 of 16bit */
#define OPA_CR0_OP0_NMUX_op0_i1_b1                  ((uint8_t )0x10)        /*!< Bit Value =(0x1):OP0_I1 of 8bit */
#define OPA_CR0_OP0_NMUX_op0_p0_w                   ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):OP0_P0 of 32bit */
#define OPA_CR0_OP0_NMUX_op0_p0_h0                  ((uint16_t)0x2000)      /*!< Bit Value =(0x2):OP0_P0 of 16bit */
#define OPA_CR0_OP0_NMUX_op0_p0_b1                  ((uint8_t )0x20)        /*!< Bit Value =(0x2):OP0_P0 of 8bit */

#define OPA_CR0_OP0_PMUX_mask_w                     ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_PMUX_mask_h0                    ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_PMUX_mask_b1                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_PMUX_vbuf_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):VBUF of 32bit */
#define OPA_CR0_OP0_PMUX_vbuf_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):VBUF of 16bit */
#define OPA_CR0_OP0_PMUX_vbuf_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):VBUF of 8bit */
#define OPA_CR0_OP0_PMUX_op0_i0_w                   ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):OP0_I0 of 32bit */
#define OPA_CR0_OP0_PMUX_op0_i0_h0                  ((uint16_t)0x0100)      /*!< Bit Value =(0x1):OP0_I0 of 16bit */
#define OPA_CR0_OP0_PMUX_op0_i0_b1                  ((uint8_t )0x01)        /*!< Bit Value =(0x1):OP0_I0 of 8bit */
#define OPA_CR0_OP0_PMUX_pga_p0_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):PGA_P0 of 32bit */
#define OPA_CR0_OP0_PMUX_pga_p0_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):PGA_P0 of 16bit */
#define OPA_CR0_OP0_PMUX_pga_p0_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):PGA_P0 of 8bit */

#define OPA_CR0_OP0_MDS_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_MDS_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_MDS_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_MDS_disable_w                   ((uint32_t)0x00000000)
#define OPA_CR0_OP0_MDS_disable_h0                  ((uint16_t)0x0000)
#define OPA_CR0_OP0_MDS_disable_b0                  ((uint8_t )0x00)
#define OPA_CR0_OP0_MDS_enable_w                    ((uint32_t)0x00000040)
#define OPA_CR0_OP0_MDS_enable_h0                   ((uint16_t)0x0040)
#define OPA_CR0_OP0_MDS_enable_b0                   ((uint8_t )0x40)

#define OPA_CR0_OP0_LPEN_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_LPEN_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_LPEN_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_LPEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define OPA_CR0_OP0_LPEN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define OPA_CR0_OP0_LPEN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define OPA_CR0_OP0_LPEN_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define OPA_CR0_OP0_LPEN_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define OPA_CR0_OP0_LPEN_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define OPA_CR0_OP0_CCEN_mask_w                     ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_CCEN_mask_h0                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_CCEN_mask_b0                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_CCEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define OPA_CR0_OP0_CCEN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define OPA_CR0_OP0_CCEN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define OPA_CR0_OP0_CCEN_enable_w                   ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define OPA_CR0_OP0_CCEN_enable_h0                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define OPA_CR0_OP0_CCEN_enable_b0                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define OPA_CR0_OP0_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define OPA_CR0_OP0_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define OPA_CR0_OP0_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define OPA_CR0_OP0_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define OPA_CR0_OP0_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define OPA_CR0_OP0_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define OPA_CR0_OP0_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define OPA_CR0_OP0_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define OPA_CR0_OP0_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32_OPA_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_OPA.h                           */
/*----------------------------------------------------------------------------*/
