/**
 ******************************************************************************
 *
 * @file        MG32_CMP.h
 *
 * @brief       MG32 CMP Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.30 (Register File Date : 2024_1225)
 * @date        2025/06/16 10:39 (H File Generated Date)
 * @author      HeadCodeGen V1.52
 * @copyright   Copyright (c) 2024 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_CMP_H
#define _MG32_CMP_H
#define _MG32_CMP_H_VER                             130     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_CMP_H_VER)
    #error "_MG32_CMP_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      CMP_Struct
 *              CMP  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  AC0_S         :1;     //[0] Analog comparator CMP0 result status
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  AC0_RF        :1;     //[2] Analog comparator CMP0 rising edge interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  AC0_FF        :1;     //[3] Analog comparator CMP0 falling edge interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t  AC1_S         :1;     //[4] Analog comparator CMP1 result status
            __I  uint8_t                :1;     //[5] 
            __IO uint8_t  AC1_RF        :1;     //[6] Analog comparator CMP1 rising edge interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  AC1_FF        :1;     //[7] Analog comparator CMP1 falling edge interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :1;     //[12] 
            __I  uint8_t                :1;     //[13] 
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  CMP Analog comparator status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] Analog comparator interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  AC0_RIE       :1;     //[2] Analog comparator CMP0 rising edge interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AC0_FIE       :1;     //[3] Analog comparator CMP0 falling edge interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[5..4] 
            __IO uint8_t  AC1_RIE       :1;     //[6] Analog comparator CMP1 rising edge interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AC1_FIE       :1;     //[7] Analog comparator CMP1 falling edge interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[9..8] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :2;     //[13..12] 
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  CMP Analog comparator interrupt enable register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IVREF_EN      :1;     //[0] Comparator CMP0 power-on enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IVREF_SEL     :1;     //[1] Analog comparator main internal reference (R-ladder) top voltage IVRT source select.
                                        //0x0 = VDDA (analog power voltage)
                                        //0x1 = VR0 (LDO VR0 output)
            __IO uint8_t  IVREF_RS      :6;     //[7..2] Analog comparator main internal reference (R-ladder) voltage select
            __IO uint8_t  IVREF2_EN     :1;     //[8] Comparator CMP1 power-on enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IVREF2_SEL    :1;     //[9] Analog comparator 2nd internal reference (R-ladder) top voltage IVRT source select.
                                        //0x0 = VDDA (analog power voltage)
                                        //0x1 = VR0 (LDO VR0 output)
            __IO uint8_t  IVREF2_RS     :6;     //[15..10] Analog comparator 2nd internal reference (R-ladder) voltage select
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }ANA;                               /*!< ANA        ~ Offset[0x0C]  CMP Analog comparator analog control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  AC0_EN        :1;     //[0] Analog comparator CMP0 power-on enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :1;     //[2] 
            __IO uint8_t  AC0_RES       :1;     //[3] CMP0 compare response time select.
                                        //0x0 = 200ns 
                                        //0x1 = 10us (5~10us)
            __IO uint8_t  AC0_HYS       :1;     //[4] CMP0 input hysteresis window select.
                                        //0x0 = No : no hysteresis
                                        //0x1 = LVL1 : with hysteresis about 10mv
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  AC0_PMUX      :3;     //[10..8] CMP0 Analog input positive channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMP0_I0
                                        //0x2 = CMP0_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  AC0_NMUX      :3;     //[14..12] CMP0 Analog input negative channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMP0_I0
                                        //0x2 = CMP0_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  AC0_INV       :1;     //[16] CMP0 analog comparator output signal polarity select.
                                        //0 = Positive
                                        //1 = Negative
            __IO uint8_t  AC0_PINV      :1;     //[17] CMP0 output to pins' signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AC0_FSEL      :2;     //[19..18] CMP0 analog comparator output signal select with synchronized filter
                                        //0x0 = Bypass
                                        //0x1 = CMP_CK : filter with CMP_CLK 
                                        //0x2 = TM00_TRGO : filter with TM00_TRGO
                                        //0x3 = TM01_TRGO : filter with TM01_TRGO
            __IO uint8_t  AC0_FDIV      :2;     //[21..20] CMP0 analog comparator output synchronized filter divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  AC0_IVROE     :1;     //[31] IVREF output to CMP0_I0 pin enable bit for positive channel MUX .
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  CMP Analog comparator-0 control register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  AC1_EN        :1;     //[0] Analog comparator CMP1 power-on enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[2..1] 
            __IO uint8_t  AC1_RES       :1;     //[3] CMP1 compare response time select.
                                        //0x0 = 200ns 
                                        //0x1 = 10us (5~10us)
            __IO uint8_t  AC1_HYS       :1;     //[4] CMP1 input hysteresis window select.
                                        //0x0 = No : no hysteresis
                                        //0x1 = LVL1 : with hysteresis about 10mv
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  AC1_PMUX      :3;     //[10..8] CMP1 Analog input positive channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMP0_I0
                                        //0x2 = CMP0_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  AC1_NMUX      :3;     //[14..12] CMP1 Analog input negative channel selection.
                                        //0x0 =  IVREF
                                        //0x1 = CMP0_I0
                                        //0x2 = CMP0_I1
                                        //0x3 = CMP_C0
                                        //0x4 = CMP_C1
                                        //0x5 = DAC_P0
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  AC1_INV       :1;     //[16] CMP1 analog comparator output signal polarity select.
                                        //0 = Positive
                                        //1 = Negative
            __IO uint8_t  AC1_PINV      :1;     //[17] CMP1 output to pins' signal inverse enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  AC1_FSEL      :2;     //[19..18] CMP1 analog comparator output signal select with synchronized filter
                                        //0x0 = Bypass
                                        //0x1 = CMP_CK : filter with CMP_CLK 
                                        //0x2 = TM00_TRGO : filter with TM00_TRGO
                                        //0x3 = TM01_TRGO : filter with TM01_TRGO
            __IO uint8_t  AC1_FDIV      :2;     //[21..20] CMP1 analog comparator output synchronized filter divider.
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :7;     //[30..24] 
            __IO uint8_t  AC1_IVROE     :1;     //[31] IVREF output to CMP1_I0 pin enable bit for positive channel MUX .
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  CMP Analog comparator-1 control register */

} CMP_Struct;

/**
 ******************************************************************************
 *
 * @name        CMP  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CMP_Base                        ((uint32_t)0x5C000000)              /*!< Analog Comparator Control */
#define CMP                             ((CMP_Struct*) CMP_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        CMP  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        CMP_STA  [register's definitions]
 *              Offset[0x00]  CMP Analog comparator status register (0x5C000000)
 ******************************************************************************
 */
///@{
#define CMP_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CMP_STA */
#define CMP_STA_AC1_FF_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC1_FF_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC1_FF_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CMP_STA_AC1_FF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CMP_STA_AC1_FF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CMP_STA_AC1_FF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CMP_STA_AC1_FF_happened_w                   ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define CMP_STA_AC1_FF_happened_h0                  ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define CMP_STA_AC1_FF_happened_b0                  ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define CMP_STA_AC1_RF_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC1_RF_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC1_RF_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CMP_STA_AC1_RF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CMP_STA_AC1_RF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CMP_STA_AC1_RF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CMP_STA_AC1_RF_happened_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define CMP_STA_AC1_RF_happened_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define CMP_STA_AC1_RF_happened_b0                  ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define CMP_STA_AC1_S_mask_w                        ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC1_S_mask_h0                       ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC1_S_mask_b0                       ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define CMP_STA_AC0_FF_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC0_FF_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC0_FF_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CMP_STA_AC0_FF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CMP_STA_AC0_FF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CMP_STA_AC0_FF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CMP_STA_AC0_FF_happened_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define CMP_STA_AC0_FF_happened_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define CMP_STA_AC0_FF_happened_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define CMP_STA_AC0_RF_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC0_RF_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC0_RF_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CMP_STA_AC0_RF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define CMP_STA_AC0_RF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define CMP_STA_AC0_RF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define CMP_STA_AC0_RF_happened_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define CMP_STA_AC0_RF_happened_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define CMP_STA_AC0_RF_happened_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define CMP_STA_AC0_S_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CMP_STA_AC0_S_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_STA_AC0_S_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CMP_INT  [register's definitions]
 *              Offset[0x04]  CMP Analog comparator interrupt enable register (0x5C000004)
 ******************************************************************************
 */
///@{
#define CMP_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CMP_INT */
#define CMP_INT_AC1_FIE_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define CMP_INT_AC1_FIE_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define CMP_INT_AC1_FIE_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CMP_INT_AC1_FIE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_INT_AC1_FIE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_INT_AC1_FIE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_INT_AC1_FIE_enable_w                    ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_INT_AC1_FIE_enable_h0                   ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_INT_AC1_FIE_enable_b0                   ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_INT_AC1_RIE_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define CMP_INT_AC1_RIE_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CMP_INT_AC1_RIE_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CMP_INT_AC1_RIE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_INT_AC1_RIE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_INT_AC1_RIE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_INT_AC1_RIE_enable_w                    ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_INT_AC1_RIE_enable_h0                   ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_INT_AC1_RIE_enable_b0                   ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_INT_AC0_FIE_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CMP_INT_AC0_FIE_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CMP_INT_AC0_FIE_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CMP_INT_AC0_FIE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_INT_AC0_FIE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_INT_AC0_FIE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_INT_AC0_FIE_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_INT_AC0_FIE_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_INT_AC0_FIE_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_INT_AC0_RIE_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CMP_INT_AC0_RIE_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CMP_INT_AC0_RIE_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CMP_INT_AC0_RIE_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_INT_AC0_RIE_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_INT_AC0_RIE_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_INT_AC0_RIE_enable_w                    ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_INT_AC0_RIE_enable_h0                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_INT_AC0_RIE_enable_b0                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CMP_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CMP_ANA  [register's definitions]
 *              Offset[0x0C]  CMP Analog comparator analog control register (0x5C00000C)
 ******************************************************************************
 */
///@{
#define CMP_ANA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CMP_ANA */
#define CMP_ANA_IVREF2_RS_mask_w                    ((uint32_t)0x0000FC00)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF2_RS_mask_h0                   ((uint16_t)0xFC00)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF2_RS_mask_b1                   ((uint8_t )0xFC)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF2_RS_shift_w                   (10)                    /*!< Bit Shift of 32bit */
#define CMP_ANA_IVREF2_RS_shift_h0                  (10)                    /*!< Bit Shift of 16bit */
#define CMP_ANA_IVREF2_RS_shift_b1                  (2)                     /*!< Bit Shift of 8bit */

#define CMP_ANA_IVREF2_SEL_mask_w                   ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF2_SEL_mask_h0                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF2_SEL_mask_b1                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF2_SEL_vdda_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):VDDA of 32bit */
#define CMP_ANA_IVREF2_SEL_vdda_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):VDDA of 16bit */
#define CMP_ANA_IVREF2_SEL_vdda_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):VDDA of 8bit */
#define CMP_ANA_IVREF2_SEL_vr0_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(0x1):VR0 of 32bit */
#define CMP_ANA_IVREF2_SEL_vr0_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(0x1):VR0 of 16bit */
#define CMP_ANA_IVREF2_SEL_vr0_b1                   ((uint8_t )0x02)        /*!< Bit Value =(0x1):VR0 of 8bit */

#define CMP_ANA_IVREF2_EN_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF2_EN_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF2_EN_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF2_EN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_ANA_IVREF2_EN_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_ANA_IVREF2_EN_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_ANA_IVREF2_EN_enable_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_ANA_IVREF2_EN_enable_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_ANA_IVREF2_EN_enable_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_ANA_IVREF_RS_mask_w                     ((uint32_t)0x000000FC)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF_RS_mask_h0                    ((uint16_t)0x00FC)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF_RS_mask_b0                    ((uint8_t )0xFC)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF_RS_shift_w                    (2)                     /*!< Bit Shift of 32bit */
#define CMP_ANA_IVREF_RS_shift_h0                   (2)                     /*!< Bit Shift of 16bit */
#define CMP_ANA_IVREF_RS_shift_b0                   (2)                     /*!< Bit Shift of 8bit */

#define CMP_ANA_IVREF_SEL_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF_SEL_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF_SEL_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF_SEL_vdda_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):VDDA of 32bit */
#define CMP_ANA_IVREF_SEL_vdda_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):VDDA of 16bit */
#define CMP_ANA_IVREF_SEL_vdda_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):VDDA of 8bit */
#define CMP_ANA_IVREF_SEL_vr0_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(0x1):VR0 of 32bit */
#define CMP_ANA_IVREF_SEL_vr0_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(0x1):VR0 of 16bit */
#define CMP_ANA_IVREF_SEL_vr0_b0                    ((uint8_t )0x02)        /*!< Bit Value =(0x1):VR0 of 8bit */

#define CMP_ANA_IVREF_EN_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CMP_ANA_IVREF_EN_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_ANA_IVREF_EN_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_ANA_IVREF_EN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_ANA_IVREF_EN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_ANA_IVREF_EN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_ANA_IVREF_EN_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_ANA_IVREF_EN_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_ANA_IVREF_EN_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CMP_CR0  [register's definitions]
 *              Offset[0x10]  CMP Analog comparator-0 control register (0x5C000010)
 ******************************************************************************
 */
///@{
#define CMP_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CMP_CR0 */
#define CMP_CR0_AC0_IVROE_mask_w                    ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_IVROE_mask_h1                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_IVROE_mask_b3                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_IVROE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR0_AC0_IVROE_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR0_AC0_IVROE_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR0_AC0_IVROE_enable_w                  ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR0_AC0_IVROE_enable_h1                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR0_AC0_IVROE_enable_b3                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_CR0_AC0_FDIV_mask_w                     ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_FDIV_mask_h1                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_FDIV_mask_b2                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_FDIV_div1_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CMP_CR0_AC0_FDIV_div1_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CMP_CR0_AC0_FDIV_div1_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CMP_CR0_AC0_FDIV_div2_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CMP_CR0_AC0_FDIV_div2_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CMP_CR0_AC0_FDIV_div2_b2                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CMP_CR0_AC0_FDIV_div4_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CMP_CR0_AC0_FDIV_div4_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CMP_CR0_AC0_FDIV_div4_b2                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CMP_CR0_AC0_FDIV_div8_w                     ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CMP_CR0_AC0_FDIV_div8_h1                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CMP_CR0_AC0_FDIV_div8_b2                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define CMP_CR0_AC0_FSEL_mask_w                     ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_FSEL_mask_h1                    ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_FSEL_mask_b2                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_FSEL_bypass_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Bypass of 32bit */
#define CMP_CR0_AC0_FSEL_bypass_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Bypass of 16bit */
#define CMP_CR0_AC0_FSEL_bypass_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Bypass of 8bit */
#define CMP_CR0_AC0_FSEL_cmp_ck_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):CMP_CK of 32bit */
#define CMP_CR0_AC0_FSEL_cmp_ck_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CMP_CK of 16bit */
#define CMP_CR0_AC0_FSEL_cmp_ck_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x1):CMP_CK of 8bit */
#define CMP_CR0_AC0_FSEL_tm00_trgo_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):TM00_TRGO of 32bit */
#define CMP_CR0_AC0_FSEL_tm00_trgo_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):TM00_TRGO of 16bit */
#define CMP_CR0_AC0_FSEL_tm00_trgo_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):TM00_TRGO of 8bit */
#define CMP_CR0_AC0_FSEL_tm01_trgo_w                ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):TM01_TRGO of 32bit */
#define CMP_CR0_AC0_FSEL_tm01_trgo_h1               ((uint16_t)0x000C)      /*!< Bit Value =(0x3):TM01_TRGO of 16bit */
#define CMP_CR0_AC0_FSEL_tm01_trgo_b2               ((uint8_t )0x0C)        /*!< Bit Value =(0x3):TM01_TRGO of 8bit */

#define CMP_CR0_AC0_PINV_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_PINV_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_PINV_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_PINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR0_AC0_PINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR0_AC0_PINV_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR0_AC0_PINV_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR0_AC0_PINV_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR0_AC0_PINV_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_CR0_AC0_INV_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_INV_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_INV_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_INV_positive_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Positive of 32bit */
#define CMP_CR0_AC0_INV_positive_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Positive of 16bit */
#define CMP_CR0_AC0_INV_positive_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Positive of 8bit */
#define CMP_CR0_AC0_INV_negative_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Negative of 32bit */
#define CMP_CR0_AC0_INV_negative_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Negative of 16bit */
#define CMP_CR0_AC0_INV_negative_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Negative of 8bit */

#define CMP_CR0_AC0_NMUX_mask_w                     ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_NMUX_mask_h0                    ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_NMUX_mask_b1                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_NMUX_ivref_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IVREF of 32bit */
#define CMP_CR0_AC0_NMUX_ivref_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IVREF of 16bit */
#define CMP_CR0_AC0_NMUX_ivref_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):IVREF of 8bit */
#define CMP_CR0_AC0_NMUX_cmp0_i0_w                  ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):CMP0_I0 of 32bit */
#define CMP_CR0_AC0_NMUX_cmp0_i0_h0                 ((uint16_t)0x1000)      /*!< Bit Value =(0x1):CMP0_I0 of 16bit */
#define CMP_CR0_AC0_NMUX_cmp0_i0_b1                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):CMP0_I0 of 8bit */
#define CMP_CR0_AC0_NMUX_cmp0_i1_w                  ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):CMP0_I1 of 32bit */
#define CMP_CR0_AC0_NMUX_cmp0_i1_h0                 ((uint16_t)0x2000)      /*!< Bit Value =(0x2):CMP0_I1 of 16bit */
#define CMP_CR0_AC0_NMUX_cmp0_i1_b1                 ((uint8_t )0x20)        /*!< Bit Value =(0x2):CMP0_I1 of 8bit */
#define CMP_CR0_AC0_NMUX_cmp_c0_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):CMP_C0 of 32bit */
#define CMP_CR0_AC0_NMUX_cmp_c0_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):CMP_C0 of 16bit */
#define CMP_CR0_AC0_NMUX_cmp_c0_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):CMP_C0 of 8bit */
#define CMP_CR0_AC0_NMUX_cmp_c1_w                   ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):CMP_C1 of 32bit */
#define CMP_CR0_AC0_NMUX_cmp_c1_h0                  ((uint16_t)0x4000)      /*!< Bit Value =(0x4):CMP_C1 of 16bit */
#define CMP_CR0_AC0_NMUX_cmp_c1_b1                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):CMP_C1 of 8bit */
#define CMP_CR0_AC0_NMUX_dac_p0_w                   ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):DAC_P0 of 32bit */
#define CMP_CR0_AC0_NMUX_dac_p0_h0                  ((uint16_t)0x5000)      /*!< Bit Value =(0x5):DAC_P0 of 16bit */
#define CMP_CR0_AC0_NMUX_dac_p0_b1                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):DAC_P0 of 8bit */

#define CMP_CR0_AC0_PMUX_mask_w                     ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_PMUX_mask_h0                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_PMUX_mask_b1                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_PMUX_ivref_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IVREF of 32bit */
#define CMP_CR0_AC0_PMUX_ivref_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IVREF of 16bit */
#define CMP_CR0_AC0_PMUX_ivref_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):IVREF of 8bit */
#define CMP_CR0_AC0_PMUX_cmp0_i0_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CMP0_I0 of 32bit */
#define CMP_CR0_AC0_PMUX_cmp0_i0_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CMP0_I0 of 16bit */
#define CMP_CR0_AC0_PMUX_cmp0_i0_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CMP0_I0 of 8bit */
#define CMP_CR0_AC0_PMUX_cmp0_i1_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):CMP0_I1 of 32bit */
#define CMP_CR0_AC0_PMUX_cmp0_i1_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CMP0_I1 of 16bit */
#define CMP_CR0_AC0_PMUX_cmp0_i1_b1                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):CMP0_I1 of 8bit */
#define CMP_CR0_AC0_PMUX_cmp_c0_w                   ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):CMP_C0 of 32bit */
#define CMP_CR0_AC0_PMUX_cmp_c0_h0                  ((uint16_t)0x0300)      /*!< Bit Value =(0x3):CMP_C0 of 16bit */
#define CMP_CR0_AC0_PMUX_cmp_c0_b1                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):CMP_C0 of 8bit */
#define CMP_CR0_AC0_PMUX_cmp_c1_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):CMP_C1 of 32bit */
#define CMP_CR0_AC0_PMUX_cmp_c1_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CMP_C1 of 16bit */
#define CMP_CR0_AC0_PMUX_cmp_c1_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):CMP_C1 of 8bit */
#define CMP_CR0_AC0_PMUX_dac_p0_w                   ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):DAC_P0 of 32bit */
#define CMP_CR0_AC0_PMUX_dac_p0_h0                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):DAC_P0 of 16bit */
#define CMP_CR0_AC0_PMUX_dac_p0_b1                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):DAC_P0 of 8bit */

#define CMP_CR0_AC0_HYS_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_HYS_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_HYS_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_HYS_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define CMP_CR0_AC0_HYS_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define CMP_CR0_AC0_HYS_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define CMP_CR0_AC0_HYS_lvl1_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):LVL1 of 32bit */
#define CMP_CR0_AC0_HYS_lvl1_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):LVL1 of 16bit */
#define CMP_CR0_AC0_HYS_lvl1_b0                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):LVL1 of 8bit */

#define CMP_CR0_AC0_RES_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_RES_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_RES_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_RES_200ns_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):200ns of 32bit */
#define CMP_CR0_AC0_RES_200ns_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):200ns of 16bit */
#define CMP_CR0_AC0_RES_200ns_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):200ns of 8bit */
#define CMP_CR0_AC0_RES_10us_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(0x1):10us of 32bit */
#define CMP_CR0_AC0_RES_10us_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(0x1):10us of 16bit */
#define CMP_CR0_AC0_RES_10us_b0                     ((uint8_t )0x08)        /*!< Bit Value =(0x1):10us of 8bit */

#define CMP_CR0_AC0_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CMP_CR0_AC0_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_CR0_AC0_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_CR0_AC0_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR0_AC0_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR0_AC0_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR0_AC0_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR0_AC0_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR0_AC0_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CMP_CR1  [register's definitions]
 *              Offset[0x14]  CMP Analog comparator-1 control register (0x5C000014)
 ******************************************************************************
 */
///@{
#define CMP_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CMP_CR1 */
#define CMP_CR1_AC1_IVROE_mask_w                    ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_IVROE_mask_h1                   ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_IVROE_mask_b3                   ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_IVROE_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR1_AC1_IVROE_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR1_AC1_IVROE_disable_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR1_AC1_IVROE_enable_w                  ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR1_AC1_IVROE_enable_h1                 ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR1_AC1_IVROE_enable_b3                 ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_CR1_AC1_FDIV_mask_w                     ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_FDIV_mask_h1                    ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_FDIV_mask_b2                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_FDIV_div1_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define CMP_CR1_AC1_FDIV_div1_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define CMP_CR1_AC1_FDIV_div1_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define CMP_CR1_AC1_FDIV_div2_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define CMP_CR1_AC1_FDIV_div2_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define CMP_CR1_AC1_FDIV_div2_b2                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define CMP_CR1_AC1_FDIV_div4_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define CMP_CR1_AC1_FDIV_div4_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define CMP_CR1_AC1_FDIV_div4_b2                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define CMP_CR1_AC1_FDIV_div8_w                     ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define CMP_CR1_AC1_FDIV_div8_h1                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define CMP_CR1_AC1_FDIV_div8_b2                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define CMP_CR1_AC1_FSEL_mask_w                     ((uint32_t)0x000C0000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_FSEL_mask_h1                    ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_FSEL_mask_b2                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_FSEL_bypass_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Bypass of 32bit */
#define CMP_CR1_AC1_FSEL_bypass_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Bypass of 16bit */
#define CMP_CR1_AC1_FSEL_bypass_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Bypass of 8bit */
#define CMP_CR1_AC1_FSEL_cmp_ck_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(0x1):CMP_CK of 32bit */
#define CMP_CR1_AC1_FSEL_cmp_ck_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CMP_CK of 16bit */
#define CMP_CR1_AC1_FSEL_cmp_ck_b2                  ((uint8_t )0x04)        /*!< Bit Value =(0x1):CMP_CK of 8bit */
#define CMP_CR1_AC1_FSEL_tm00_trgo_w                ((uint32_t)0x00080000)  /*!< Bit Value =(0x2):TM00_TRGO of 32bit */
#define CMP_CR1_AC1_FSEL_tm00_trgo_h1               ((uint16_t)0x0008)      /*!< Bit Value =(0x2):TM00_TRGO of 16bit */
#define CMP_CR1_AC1_FSEL_tm00_trgo_b2               ((uint8_t )0x08)        /*!< Bit Value =(0x2):TM00_TRGO of 8bit */
#define CMP_CR1_AC1_FSEL_tm01_trgo_w                ((uint32_t)0x000C0000)  /*!< Bit Value =(0x3):TM01_TRGO of 32bit */
#define CMP_CR1_AC1_FSEL_tm01_trgo_h1               ((uint16_t)0x000C)      /*!< Bit Value =(0x3):TM01_TRGO of 16bit */
#define CMP_CR1_AC1_FSEL_tm01_trgo_b2               ((uint8_t )0x0C)        /*!< Bit Value =(0x3):TM01_TRGO of 8bit */

#define CMP_CR1_AC1_PINV_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_PINV_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_PINV_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_PINV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR1_AC1_PINV_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR1_AC1_PINV_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR1_AC1_PINV_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR1_AC1_PINV_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR1_AC1_PINV_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define CMP_CR1_AC1_INV_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_INV_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_INV_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_INV_positive_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Positive of 32bit */
#define CMP_CR1_AC1_INV_positive_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Positive of 16bit */
#define CMP_CR1_AC1_INV_positive_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Positive of 8bit */
#define CMP_CR1_AC1_INV_negative_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Negative of 32bit */
#define CMP_CR1_AC1_INV_negative_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Negative of 16bit */
#define CMP_CR1_AC1_INV_negative_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Negative of 8bit */

#define CMP_CR1_AC1_NMUX_mask_w                     ((uint32_t)0x00007000)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_NMUX_mask_h0                    ((uint16_t)0x7000)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_NMUX_mask_b1                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_NMUX_ivref_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IVREF of 32bit */
#define CMP_CR1_AC1_NMUX_ivref_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IVREF of 16bit */
#define CMP_CR1_AC1_NMUX_ivref_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):IVREF of 8bit */
#define CMP_CR1_AC1_NMUX_cmp0_i0_w                  ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):CMP0_I0 of 32bit */
#define CMP_CR1_AC1_NMUX_cmp0_i0_h0                 ((uint16_t)0x1000)      /*!< Bit Value =(0x1):CMP0_I0 of 16bit */
#define CMP_CR1_AC1_NMUX_cmp0_i0_b1                 ((uint8_t )0x10)        /*!< Bit Value =(0x1):CMP0_I0 of 8bit */
#define CMP_CR1_AC1_NMUX_cmp0_i1_w                  ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):CMP0_I1 of 32bit */
#define CMP_CR1_AC1_NMUX_cmp0_i1_h0                 ((uint16_t)0x2000)      /*!< Bit Value =(0x2):CMP0_I1 of 16bit */
#define CMP_CR1_AC1_NMUX_cmp0_i1_b1                 ((uint8_t )0x20)        /*!< Bit Value =(0x2):CMP0_I1 of 8bit */
#define CMP_CR1_AC1_NMUX_cmp_c0_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):CMP_C0 of 32bit */
#define CMP_CR1_AC1_NMUX_cmp_c0_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):CMP_C0 of 16bit */
#define CMP_CR1_AC1_NMUX_cmp_c0_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):CMP_C0 of 8bit */
#define CMP_CR1_AC1_NMUX_cmp_c1_w                   ((uint32_t)0x00004000)  /*!< Bit Value =(0x4):CMP_C1 of 32bit */
#define CMP_CR1_AC1_NMUX_cmp_c1_h0                  ((uint16_t)0x4000)      /*!< Bit Value =(0x4):CMP_C1 of 16bit */
#define CMP_CR1_AC1_NMUX_cmp_c1_b1                  ((uint8_t )0x40)        /*!< Bit Value =(0x4):CMP_C1 of 8bit */
#define CMP_CR1_AC1_NMUX_dac_p0_w                   ((uint32_t)0x00005000)  /*!< Bit Value =(0x5):DAC_P0 of 32bit */
#define CMP_CR1_AC1_NMUX_dac_p0_h0                  ((uint16_t)0x5000)      /*!< Bit Value =(0x5):DAC_P0 of 16bit */
#define CMP_CR1_AC1_NMUX_dac_p0_b1                  ((uint8_t )0x50)        /*!< Bit Value =(0x5):DAC_P0 of 8bit */

#define CMP_CR1_AC1_PMUX_mask_w                     ((uint32_t)0x00000700)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_PMUX_mask_h0                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_PMUX_mask_b1                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_PMUX_ivref_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):IVREF of 32bit */
#define CMP_CR1_AC1_PMUX_ivref_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):IVREF of 16bit */
#define CMP_CR1_AC1_PMUX_ivref_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):IVREF of 8bit */
#define CMP_CR1_AC1_PMUX_cmp0_i0_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):CMP0_I0 of 32bit */
#define CMP_CR1_AC1_PMUX_cmp0_i0_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):CMP0_I0 of 16bit */
#define CMP_CR1_AC1_PMUX_cmp0_i0_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):CMP0_I0 of 8bit */
#define CMP_CR1_AC1_PMUX_cmp0_i1_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):CMP0_I1 of 32bit */
#define CMP_CR1_AC1_PMUX_cmp0_i1_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(0x2):CMP0_I1 of 16bit */
#define CMP_CR1_AC1_PMUX_cmp0_i1_b1                 ((uint8_t )0x02)        /*!< Bit Value =(0x2):CMP0_I1 of 8bit */
#define CMP_CR1_AC1_PMUX_cmp_c0_w                   ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):CMP_C0 of 32bit */
#define CMP_CR1_AC1_PMUX_cmp_c0_h0                  ((uint16_t)0x0300)      /*!< Bit Value =(0x3):CMP_C0 of 16bit */
#define CMP_CR1_AC1_PMUX_cmp_c0_b1                  ((uint8_t )0x03)        /*!< Bit Value =(0x3):CMP_C0 of 8bit */
#define CMP_CR1_AC1_PMUX_cmp_c1_w                   ((uint32_t)0x00000400)  /*!< Bit Value =(0x4):CMP_C1 of 32bit */
#define CMP_CR1_AC1_PMUX_cmp_c1_h0                  ((uint16_t)0x0400)      /*!< Bit Value =(0x4):CMP_C1 of 16bit */
#define CMP_CR1_AC1_PMUX_cmp_c1_b1                  ((uint8_t )0x04)        /*!< Bit Value =(0x4):CMP_C1 of 8bit */
#define CMP_CR1_AC1_PMUX_dac_p0_w                   ((uint32_t)0x00000500)  /*!< Bit Value =(0x5):DAC_P0 of 32bit */
#define CMP_CR1_AC1_PMUX_dac_p0_h0                  ((uint16_t)0x0500)      /*!< Bit Value =(0x5):DAC_P0 of 16bit */
#define CMP_CR1_AC1_PMUX_dac_p0_b1                  ((uint8_t )0x05)        /*!< Bit Value =(0x5):DAC_P0 of 8bit */

#define CMP_CR1_AC1_HYS_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_HYS_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_HYS_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_HYS_no_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define CMP_CR1_AC1_HYS_no_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define CMP_CR1_AC1_HYS_no_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define CMP_CR1_AC1_HYS_lvl1_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):LVL1 of 32bit */
#define CMP_CR1_AC1_HYS_lvl1_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(0x1):LVL1 of 16bit */
#define CMP_CR1_AC1_HYS_lvl1_b0                     ((uint8_t )0x10)        /*!< Bit Value =(0x1):LVL1 of 8bit */

#define CMP_CR1_AC1_RES_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_RES_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_RES_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_RES_200ns_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):200ns of 32bit */
#define CMP_CR1_AC1_RES_200ns_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):200ns of 16bit */
#define CMP_CR1_AC1_RES_200ns_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):200ns of 8bit */
#define CMP_CR1_AC1_RES_10us_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(0x1):10us of 32bit */
#define CMP_CR1_AC1_RES_10us_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(0x1):10us of 16bit */
#define CMP_CR1_AC1_RES_10us_b0                     ((uint8_t )0x08)        /*!< Bit Value =(0x1):10us of 8bit */

#define CMP_CR1_AC1_EN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CMP_CR1_AC1_EN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CMP_CR1_AC1_EN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CMP_CR1_AC1_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CMP_CR1_AC1_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CMP_CR1_AC1_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CMP_CR1_AC1_EN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CMP_CR1_AC1_EN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CMP_CR1_AC1_EN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32_CMP_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32_CMP.h                           */
/*----------------------------------------------------------------------------*/
