


/**
 ******************************************************************************
 *
 * @file        BSP_5_DIPSwitch.c
 * @brief       
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/05/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/*==============================================================================
                                 User Notes
How To use this function:
-----------------------
   1. Use BSP_DIPSwitch_Init() function to inital.
   2. By calling "BSP_DIPSwitch_GetStatus" function to get DIP switch status.
 
Driver architecture:
--------------------
   + MG32_GPIO_DRV

Known Limitations:
------------------
   1. BSP_DIPSwitch_GetStatus() no handle debounce.   
   2. The LED's PIN is conflict for BSP_StepMotor's pin.

Require parameter
------------------
    Require module : CSC / GPIO 
    
    GPIO pin configuration : 
        Pin / IO mode / AFS
        ---  --------  -----
        PC8 / DIN     / GPIO
        PC9 / DIN     / GPIO
        PC10/ DIN     / GPIO
        PC11/ DIN     / GPIO

Example codes:
------------------

==============================================================================*/


/* Includes ------------------------------------------------------------------*/
#include "BSP_5_DIPSwitch.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//GPIO
#define DIPSWITCH_1_PIN            PX_Pin_8
#define DIPSWITCH_2_PIN            PX_Pin_9
#define DIPSWITCH_3_PIN            PX_Pin_10
#define DIPSWITCH_4_PIN            PX_Pin_11
#define DIPSWITCH_IOM              IOMC
#define DIPSWITCH_PORT             GPIOC
                                   
//DIP Switch                       
#define DIPSWITCH_1_PXn            PC8
#define DIPSWITCH_2_PXn            PC9
#define DIPSWITCH_3_PXn            PC10
#define DIPSWITCH_4_PXn            PC11

#define DIPSWITCH_1_STATUS_SHIFT   0
#define DIPSWITCH_2_STATUS_SHIFT   1
#define DIPSWITCH_3_STATUS_SHIFT   2
#define DIPSWITCH_4_STATUS_SHIFT   3

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/     
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	  DIP switch inital.  
 * @details                                                    
 * @return      
 * @exception   
 * @note        
 *******************************************************************************
 */
void BSP_DIPSwitch_Init(void)
{
    PIN_InitTypeDef DIPSwitch_Pin;
    
    /*GPIO Inital*/
    DIPSwitch_Pin.PINX_Pin                = (DIPSWITCH_1_PIN | DIPSWITCH_2_PIN | DIPSWITCH_3_PIN | DIPSWITCH_4_PIN);
    DIPSwitch_Pin.PINX_Mode               = PINX_Mode_Digital_I;
    DIPSwitch_Pin.PINX_PUResistant        = PINX_PUResistant_Enable;
    DIPSwitch_Pin.PINX_Speed              = PINX_Speed_Low;
    DIPSwitch_Pin.PINX_Inverse            = PINX_Inverse_Disable;
    DIPSwitch_Pin.PINX_OUTDrive           = PINX_OUTDrive_Level0;
    DIPSwitch_Pin.PINX_FilterDivider      = PINX_FilterDivider_Bypass;
    DIPSwitch_Pin.PINX_Alternate_Function = 0;                          
    GPIO_PortMode_Config( DIPSWITCH_IOM ,&DIPSwitch_Pin);
    
}

/**
 *******************************************************************************
 * @brief	  Get DIP switch status.  
 * @details                                                    
 * @return    DIP switch status now.  
 * @exception   
 * @note      No debounce control.
 *******************************************************************************
 */
uint8_t BSP_DIPSwitch_GetStatus(void)
{
    return( (uint8_t)(DIPSWITCH_1_PXn << DIPSWITCH_1_STATUS_SHIFT) |
            (uint8_t)(DIPSWITCH_2_PXn << DIPSWITCH_2_STATUS_SHIFT) |
            (uint8_t)(DIPSWITCH_3_PXn << DIPSWITCH_3_STATUS_SHIFT) |
            (uint8_t)(DIPSWITCH_4_PXn << DIPSWITCH_4_STATUS_SHIFT));
}































