/*********************************************************************
*	 项目名称:MG82F6P32-DEMO
*			测试板使用 TH253A MG82F6P32_LQFP32_QFN32_EV_V11 EV Board
*			CpuCLK=32MHz, SysCLK=32MHz
*	功能描述：
*			CH0(P22),CH1(P23),CH2(P24),CH3(P34),CH4(P32),CH5(P35)
*	注意事项：
*
*	 建立时间: 2024.2.26
*	 修改日志:
*
*********************************************************************/
#define	_MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>	// for printf

#include ".\include\REG_MG82F6P32.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6P32.H"
#include ".\include\API_Uart_BRGRL_MG82F6P32.H"

/*************************************************
*定义系统时钟SysClk (MAX.50MHz)
*可选:
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define	MCU_SYSCLK		32000000
/*************************************************/
/*************************************************
*定义CPU时钟 CpuClk	(MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define	MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define	TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256)
#define	TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define	TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000))))	/256)
#define	TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000))))	%256)
#define	TIMER_12T_10mS_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) /256)
#define	TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) %256)

#define	IO_LED_R		P22
#define	IO_LED_Y		P24
#define	IO_LED_G		P26


#define	PTM0_RELOAD			(1000)
#define	PTM0_CH0_SET_POINT	(100)
#define	PTM0_CH0_CLR_POINT	(300)
#define	PTM0_CH2_SET_POINT	(400)
#define	PTM0_CH2_CLR_POINT	(600)
#define	PTM0_CH4_SET_POINT	(700)
#define	PTM0_CH4_CLR_POINT	(900)

#define	PTM0_C			 (65536)

#define	PTM0_CL(x)		(u8)((~(u16)x)+1)
#define	PTM0_CH(x)		(u8)(((~(u16)x)+1)>>8)

/***********************************************************************************
*函数名称:	 void INT_PCA(void)
*功能描述:PCA 中断服务程序

*输入参数:
*返回参数:
*************************************************************************************/
void INT_PTM0(void)	interrupt INT_VECTOR_PTM0
{
	_push_(SFRPI);
	SFRPI=0;
	if(CF)
	{
		IO_LED_R=!IO_LED_R;
		CF=0;
		// Todo...
	}
	_pop_(SFRPI);
}


/*************************************************
*函数名称:	   void	DelayXus(u16 xUs)
*功能描述:		延时程序，单位为us
*输入参数:	   u8 Us ->	*1us  (1~255)
*返回参数:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if	(MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if	(MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if	(MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*函数名称:	   void	DelayXms(u16 xMs)
*功能描述:	   延时程序，单位为ms
*输入参数:	   u16 xMs -> *1ms	(1~65535)
*返回参数:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
*函数名称:	 void InitPort(void)
*功能描述:	 IO配置
*输入参数:
*返回参数:
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT6);						// 设置P26为推挽输出(LED)
	PORT_SetP2PushPull(BIT2|BIT3|BIT4);				// 设置P22(CEX0),P23(CEX2),P24(CEX4)为推挽输出
	PORT_SetP3PushPull(BIT2|BIT4|BIT5);				// 设置P32(CEX1),P34(CEX3),P35(CEX5)为推挽输出
}

/***********************************************************************************
*函数名称:	 void InitPTM0_PhaseVariable(void)
*功能描述:	 PTM0初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitPTM0_PhaseVariable(void)
{
	PTM0_SetCLOCK_SYSCLK();								// PCA时钟为SysClk	= 32MHz

	PTM0_CH0_SetMode_COPM();							// 设置CH0 为比较输出模式
	PTM0_CH1_SetMode_COPM();							// 设置CH1 为比较输出模式
	PTM0_CH2_SetMode_COPM();							// 设置CH2 为比较输出模式
	PTM0_CH3_SetMode_COPM();							// 设置CH3 为比较输出模式
	PTM0_CH4_SetMode_COPM();							// 设置CH4 为比较输出模式
	PTM0_CH5_SetMode_COPM();							// 设置CH5 为比较输出模式

	PTM0_CH0_SetPWM_16Bit();							// 设置为16位
	PTM0_CH1_SetPWM_16Bit();							// 设置为16位
	PTM0_CH2_SetPWM_16Bit();							// 设置为16位
	PTM0_CH3_SetPWM_16Bit();							// 设置为16位
	PTM0_CH4_SetPWM_16Bit();							// 设置为16位
	PTM0_CH5_SetPWM_16Bit();							// 设置为16位

	PTM0_CH01_SetPWM_EnBufferMode();					// CH0,CH1 使能缓冲模式
	PTM0_CH23_SetPWM_EnBufferMode();					// CH2,CH3 使能缓冲模式
	PTM0_CH45_SetPWM_EnBufferMode();					// CH4,CH5 使能缓冲模式

	PTM0_SetCounter(PTM0_C-PTM0_RELOAD);
	PTM0_SetCounterReload(PTM0_C-PTM0_RELOAD);

	PTM0_CH0_SetValue(PTM0_CH(PTM0_CH0_SET_POINT),PTM0_CL(PTM0_CH0_SET_POINT));		// CEX0	Set	point
	PTM0_CH1_SetValue(PTM0_CH(PTM0_CH0_CLR_POINT),PTM0_CL(PTM0_CH0_CLR_POINT));		// CEX0	Clear point
	PTM0_CH2_SetValue(PTM0_CH(PTM0_CH2_SET_POINT),PTM0_CL(PTM0_CH2_SET_POINT));		// CEX2	Set	point
	PTM0_CH3_SetValue(PTM0_CH(PTM0_CH2_CLR_POINT),PTM0_CL(PTM0_CH2_CLR_POINT));		// CEX2	Clear point
	PTM0_CH4_SetValue(PTM0_CH(PTM0_CH4_SET_POINT),PTM0_CL(PTM0_CH4_SET_POINT));		// CEX4	Set	point
	PTM0_CH5_SetValue(PTM0_CH(PTM0_CH4_CLR_POINT),PTM0_CL(PTM0_CH4_CLR_POINT));		// CEX4	Clear point

	// 设置PWM输出引脚
	PTM0_SetCEXn_Pin(CEX0_P22|CEX1_P23|CEX2_P24|CEX3_P34|CEX4_P32|CEX5_P35);

	PTM0_SetPWM0_EnOutput();
	PTM0_SetPWM1_EnOutput();
	PTM0_SetPWM2_EnOutput();
	PTM0_SetPWM3_EnOutput();
	PTM0_SetPWM4_EnOutput();
	PTM0_SetPWM5_EnOutput();

	PTM0_CF_EnInterrupt();					// 使能CF中断

	PTM0_EnPCACounter();					// 使能PCA计数器,
}

/***********************************************************************************
*函数名称:	 void InitClock(void)
*功能描述:	 时钟初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitClock(void)
{
#if	(MCU_SYSCLK==11059200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==12000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=12MHz	CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==22118400)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==24000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==29491200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==32000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz	CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz	CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if	(MCU_SYSCLK==48000000)
	// SysClk=48MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60 输出 MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*函数名称:	 void InitInterrupt(void)
*功能描述:	 中断初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnPTM0();							// 使能PCA中断

}

/***********************************************************************************
*函数名称:	 void InitSystem(void)
*功能描述:	 系统初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPTM0_PhaseVariable();
	InitInterrupt();

	INT_EnAll();
}

void main()
{

	InitSystem();

	IO_LED_G=0;
	DelayXms(1000);
	IO_LED_G=1;

	while(1)
	{
		DelayXms(200);
		IO_LED_G=!IO_LED_G;
	}
}

