/*********************************************************************
*	 项目名称:MG82F6P32-DEMO
*			测试板使用 TH253A MG82F6P32_LQFP32_QFN32_EV_V11 EV Board
*			CpuCLK=32MHz, SysCLK=32MHz
*	功能描述：
*			设置P10,P15,P11,P16用于INT0,INT1,INT2,INT3下降沿触发
*			20s无中断触发,进入掉电模式
*			INT0(P10),INT1(P15),INT2(P11),INT3(P16)低电平唤醒
*	注意事项：
*
*	 建立时间: 2024.2.26
*	 修改日志:
*
*********************************************************************/
#define	_MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>	// for printf

#include ".\include\REG_MG82F6P32.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6P32.H"
#include ".\include\API_Uart_BRGRL_MG82F6P32.H"

/*************************************************
*定义系统时钟SysClk (MAX.50MHz)
*可选:
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define	MCU_SYSCLK		32000000
/*************************************************/
/*************************************************
*定义CPU时钟 CpuClk	(MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define	MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define	IO_LED_R		P22
#define	IO_LED_Y		P24
#define	IO_LED_G		P26

#define	IO_nINT0		P10
#define	IO_nINT1		P15
#define	IO_nINT2		P11
#define	IO_nINT3		P16


u8 WakeUpSorce;
u8 INTCnt;

/***********************************************************************************
*函数名称:	 void INT_INT0(void)
*功能描述:INT0中断服务程序
*输入参数:
*返回参数:
*************************************************************************************/
void INT_INT0(void)		interrupt INT_VECTOR_INT0
{
	WakeUpSorce=0;
}

/***********************************************************************************
*函数名称:	 void INT_INT1(void)
*功能描述:INT1中断服务程序
*输入参数:
*返回参数:
*************************************************************************************/
void INT_INT1(void)		interrupt INT_VECTOR_INT1
{
	WakeUpSorce=1;
}

/***********************************************************************************
*函数名称:	 void INT_INT2(void)
*功能描述:INT2中断服务程序
*输入参数:
*返回参数:
*************************************************************************************/
void INT_INT2(void)		interrupt INT_VECTOR_INT2
{
	WakeUpSorce=2;
}

/***********************************************************************************
*函数名称:	 void INT_INT3(void)
*功能描述:INT3中断服务程序
*输入参数:
*返回参数:
*************************************************************************************/
void INT_INT3(void)		interrupt INT_VECTOR_INT3
{
	WakeUpSorce=3;
}

/*************************************************
*函数名称:	   void	DelayXus(u16 xUs)
*功能描述:		延时程序，单位为us
*输入参数:	   u8 Us ->	*1us  (1~255)
*返回参数:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if	(MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if	(MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if	(MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if	(MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*函数名称:	   void	DelayXms(u16 xMs)
*功能描述:	   延时程序，单位为ms
*输入参数:	   u16 xMs -> *1ms	(1~65535)
*返回参数:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
*函数名称:	 u8	IAP_ReadPPage(u8 PsfrAddr)
*功能描述:读取P页特殊功能器内容
*输入参数:
*		 u8	PsfrAddr: P页地址
*返回参数:
*		 u8: P页内容
*************************************************************************************/
u8 IAP_ReadPPage(u8	PsfrAddr)
{
	bit	bEA=EA;
	EA = 0;						//关中断
	IFADRH = 0;					//IFADRH必须为0
	IFADRL=	PsfrAddr;			//送P页地址;
	IFMT = ISP_READ_P;
	ISPCR =	0x80;				//设置等待时间, 允许ISP/IAP操作
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR =	0;					//清ISP/IAP特殊寄存器，防止误操作
	EA = bEA;					//恢复中断
	return IFD;
}

/***********************************************************************************
*函数名称:	 void IAP_WritePPage(u8	PsfrAddr,u8	PsfrData)
*功能描述:写P页特殊功能器
*输入参数:
*		 u8	PsfrAddr: P页地址
*		 u8	PsfrData: P页内容
*返回参数:
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit	bEA=EA;
	EA = 0;						//关中断
	IFADRH = 0;					//IFADRH必须为0
	IFADRL=	PsfrAddr;			//送P页地址;
	IFD= PsfrData;				//送P页内容
	IFMT = ISP_WRITE_P;
	ISPCR =	0x80;				//设置等待时间, 允许ISP/IAP操作
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR =	0;					//清ISP/IAP特殊寄存器，防止误操作
	EA = bEA;					//恢复中断
}

/***********************************************************************************
*函数名称:	 void InitPort(void)
*功能描述:	 IO配置
*输入参数:
*返回参数:
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);		// 设置P22,P24,P26为推挽输出(LED)
	PORT_SetP1OpenDrainPu(BIT0|BIT1|BIT5|BIT6);		// 设置P10,P11,P15,P16为开漏输出带上拉，做INT使用
}

/***********************************************************************************
*函数名称:	 void InitClock(void)
*功能描述:	 时钟初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitClock(void)
{
#if	(MCU_SYSCLK==11059200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==12000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);

#else
	// SysClk=12MHz	CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if	(MCU_SYSCLK==22118400)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==24000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz	CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==29491200)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==32000000)
#if	(MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz	CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz	CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if	(MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if	(MCU_SYSCLK==48000000)
	// SysClk=48MHz	CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60 输出 MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*函数名称:	 void InitInterrupt_WakeUp(void)
*功能描述:	 中断初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitInterrupt_WakeUp(void)
{
	INT_DisINT0();							//	禁止INT0中断
	INT_DisINT1();							//	禁止INT1中断
	INT_DisINT2();							//	禁止INT2中断
	INT_DisINT3();							//	禁止INT3中断
	INT_DisAll();							//	禁止总中断
}

/***********************************************************************************
*函数名称:	 void InitInterrupt_PD(void)
*功能描述:	 中断初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitInterrupt_PD(void)
{
	INT_EnINT0();							//	使能INT0中断
	INT_EnINT1();							//	使能INT1中断
	INT_EnINT2();							//	使能INT2中断
	INT_EnINT3();							//	使能INT3中断
	INT_EnAll();							//	开启总中断
}

/***********************************************************************************
*函数名称:	 void InitINT0(void)
*功能描述:	 INT0初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitINT0(void)
{
	INT_SetINT0P10();						//设置INT0引脚P10
	INT_SetINT0_DetectEdge();				//设置INT0外部中断检测方式为边沿检测, 当进入掉电模式后,自动转为电平检测
	INT_SetINT0_DetectLowFalling();			//设置INT0外部中断检测方式为低电平或下降沿触发
	INT_SetINT0Filter_SysclkDiv6_x3();		//设置INT0滤波为（sysclk/6）*3

}

/***********************************************************************************
*函数名称:	 void InitINT1(void)
*功能描述:	 INT1初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitINT1(void)
{
	INT_SetINT1P15();						//设置INT1引脚P10
	INT_SetINT1_DetectEdge();				//设置INT1外部中断检测方式为边沿检测, 当进入掉电模式后,自动转为电平检测
	INT_SetINT1_DetectLowFalling();			//设置INT1外部中断检测方式为低电平或下降沿触发
	INT_SetINT1Filter_SysclkDiv6_x3();		//设置INT1滤波为（sysclk/6）*3

}

/***********************************************************************************
*函数名称:	 void InitINT2(void)
*功能描述:	 INT2初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitINT2(void)
{
	INT_SetINT2P11();						//设置INT2引脚P11
	INT_SetINT2_DetectEdge();				//设置INT2外部中断检测方式为边沿检测, 当进入掉电模式后,自动转为电平检测
	INT_SetINT2_DetectLowFalling();			//设置INT2外部中断检测方式为低电平或下降沿触发
	INT_SetINT2Filter_SysclkDiv6_x3();		//设置INT2滤波为（sysclk/6）*3

}

/***********************************************************************************
*函数名称:	 void InitINT3(void)
*功能描述:	 INT3初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitINT3(void)
{
	INT_SetINT3P16();							//设置INT3引脚P16
	INT_SetINT3_DetectEdge();				//设置INT3外部中断检测方式为边沿检测, 当进入掉电模式后,自动转为电平检测
	INT_SetINT3_DetectLowFalling();			//设置INT3外部中断检测方式为低电平或下降沿触发
	INT_SetINT3Filter_SysclkDiv6_x3();		//设置INT3滤波为（sysclk/6）*3

}

/***********************************************************************************
*函数名称:	 void InitSystem(void)
*功能描述:	 系统初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitINT0();
	InitINT1();
	InitINT2();
	InitINT3();
	InitInterrupt_WakeUp();
}

/***********************************************************************************
*函数名称:	 void PowerDownProc(void)
*功能描述:	 掉电程序处理
*输入参数:
*返回参数:
*************************************************************************************/
void PowerDownProc(void)
{
	u8 i;
	u8 BakCKCON2;													// 备份CKCON2	(使用了PLL	CKM倍频的情况下)

	// MCK=OSCin
	BakCKCON2=IAP_ReadPPage(CKCON2_P);								// 备份CKCON2	(使用了PLL	CKM倍频的情况下)
	IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));		// MCK=OSCin (使用了PLL CKM倍频的情况下)

	i=0;
	while(1)
	{
		DelayXus(10);
		if((IO_nINT0==0)||(IO_nINT1==0)||(IO_nINT2==0)||(IO_nINT3==0))
		{
			i=0;
		}
		else
		{
			i++;
			if(i>=200) break;
		}
	}
	InitInterrupt_PD();

	POW_SetMode_PD();												// 进入掉电模式
	_nop_();

	InitInterrupt_WakeUp();

	while((CKCON1&PLLOCKF)==0);										// 等待CKM稳定 (使用了PLL CKM倍频的情况下)
	IAP_WritePPage(CKCON2_P,BakCKCON2);								// 恢复CKCON2,选择使用倍频 (使用了PLL CKM倍频的情况下)

}

void main()
{
	u8 i;

	InitSystem();
	IO_LED_G=0;IO_LED_Y=0;IO_LED_R=0;
	DelayXms(2000);
	IO_LED_G=1;IO_LED_Y=1;IO_LED_R=1;
	INTCnt=0;
	WakeUpSorce=0;
	while(1)
	{
		for(i=0;i<20;i++)
		{
			DelayXms(100);
			if(WakeUpSorce == 0)
			{
				IO_LED_G=!IO_LED_G;
			}
			else if(WakeUpSorce	== 1)
			{
				IO_LED_R=!IO_LED_R;
			}
			else if(WakeUpSorce	== 2)
			{
				IO_LED_Y=!IO_LED_Y;
			}
			else if(WakeUpSorce	== 3)
			{
				IO_LED_G=!IO_LED_G;
				IO_LED_Y=!IO_LED_Y;
			}
		}
		IO_LED_G=1;
		IO_LED_Y=1;
		IO_LED_R=1;

		PowerDownProc();

	}

}


