/*********************************************************************
*	 项目名称:MG82F6P32-DEMO
*			测试板使用 TH253A MG82F6P32_LQFP32_QFN32_EV_V11 EV Board
*			CpuCLK=32KHz, SysCLK=32KHz
*	功能描述：
*			设置时钟为 ILRCO	32KHz, P60输出MCK/4
*	注意事项：
*
*	 建立时间: 2024.2.26
*	 修改日志:
*
*********************************************************************/
#define	_MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>	// for printf

#include ".\include\REG_MG82F6P32.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6P32.H"
#include ".\include\API_Uart_BRGRL_MG82F6P32.H"

#define	IO_LED_R		P22
#define	IO_LED_Y		P24
#define	IO_LED_G		P26

/*************************************************
*函数名称:	   void	DelayXms(u16 xMs)
*功能描述:			延时程序，单位为ms
*输入参数:	   u16 xMs -> *1ms	(1~65535)
*返回参数:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();

		xMs--;

	}
}

/***********************************************************************************
*函数名称:	 void InitPort(void)
*功能描述:	 IO配置
*输入参数:
*返回参数:
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);		// 设置P22,P24,P26为推挽输出(LED)
	PORT_SetP6PushPull(BIT0);						// 设置P60 为推挽输出模式

}

/***********************************************************************************
*函数名称:	 void InitClock_ILRCO(void)
*功能描述:	 初始化Clock配置
*输入参数:
*返回参数:
*************************************************************************************/
void InitClock_ILRCO(void)
{
	// P60 输出 MCK/4
	CLK_P60OC_MCKDiv4();			//32KHz/4=8KHz

	// IHRCO Enable, MCK=OSCin,	OSCin=ILRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);
	nop();
	// IHRCO Disable, MCK=OSCin, OSCin=ILRCO
	CLK_SetCKCON2(DISABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);

}

/***********************************************************************************
*函数名称:	 void InitSystem(void)
*功能描述:	 系统初始化
*输入参数:
*返回参数:
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock_ILRCO();
}

void main()
{
	InitSystem();

	IO_LED_G=0;IO_LED_Y=0;IO_LED_R=0;
	DelayXms(1000);
	IO_LED_G=1;IO_LED_Y=1;IO_LED_R=1;

	while(1)
	{
		IO_LED_G=0;
		DelayXms(200);
		IO_LED_G=1;
		IO_LED_Y=0;
		DelayXms(200);
		IO_LED_Y=1;
		IO_LED_R=0;
		DelayXms(200);
		IO_LED_R=1;

	}
}

