/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32x02z demo main c Code. 
 *
 * @par         Project
 *              MG32x02z
 *							demoּжϽURTݣ
 *							ٴӦݡ
 *				
 *				ע⣺
 *
 * @version     
 * @date        
 * @author      
 * @copyright   
 *             
 *
 ******************************************************************************* 
 * @par Disclaimer

 *******************************************************************************
 */

#include "MG32x02z_DRV.H"
#include <stdio.h>

#define URTX URT0
#define UARTX_RX_BUF_SIZE		1048

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

u8 UarxRxBuf[UARTX_RX_BUF_SIZE];		//Эʹõʵʴڽջ
u16 UartxRxIn=0;							//Эʹõʵʴڽλ
u16 UartxRxOut=0;							//Эʹõʵʴڽնȡλ

/***********************************************************************************
:	void URT0_IRQHandler(void)
:	URT0 жϴ
:	
ز:	  
*************************************************************************************/
void URT0_IRQHandler(void)
{
    uint8_t IRQ_ID;
	uint32_t URT_Flag;
	uint32_t URT_IT_Msk;
	uint8_t URT_Data;
    
    
    IRQ_ID = EXIC_GetITSourceID(URT0_IRQn);  
    if(IRQ_ID & EXIC_SRC5_ID20_urt0_b0)
    {
		URT_Flag = URT_GetITAllFlagStatus(URT0);
		URT_IT_Msk = URT_GetITStatus(URT0);
			
					if((URT_Flag & URT_STA_RXF_mask_w) && (URT_IT_Msk & URT_INT_RX_IE_mask_w))
			{
				URT_Data=URT_GetRXData(URT0);
				URT_ClearITFlag(URT0,URT_IT_RX);
				UarxRxBuf[UartxRxIn] = URT_Data;
			  UartxRxIn++;
			  if(UartxRxIn>= UARTX_RX_BUF_SIZE)
			  {
				 UartxRxIn=0;	  
			  }
			}	
    }
		
}

/***********************************************************************************
:	void CSC_Init (void)
:	ϵͳʱӳʼ
:	
ز:	  
*************************************************************************************/
void CSC_Init (void)
{
	CSC_PLL_TypeDef CSC_PLL_CFG;

  UnProtectModuleReg(MEMprotect);     	// Setting flash wait state
  MEM_SetFlashWaitState(MEM_FWAIT_ONE);	// 50MHz> Sysclk >=25MHz
  ProtectModuleReg(MEMprotect);

  UnProtectModuleReg(CSCprotect);
	CSC_CK_APB_Divider_Select(APB_DIV_1);	// Modify CK_APB divider	APB=CK_MAIN/1
	CSC_CK_AHB_Divider_Select(AHB_DIV_1);	// Modify CK_AHB divider	AHB=APB/1

	/* CK_HS selection */
	CSC_IHRCO_Select(IHRCO_12MHz);			// IHRCO Sel 12MHz
	CSC_IHRCO_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_IHRCOF) == DRV_Normal);
	CSC_ClearFlag(CSC_IHRCOF);
	CSC_CK_HS_Select(HS_CK_IHRCO);			// CK_HS select IHRCO

	/* PLL */
	/**********************************************************/
	CSC_PLL_CFG.InputDivider=PLLI_DIV_2;	// 12M/2=6M
	CSC_PLL_CFG.Multiplication=PLLIx16;		// 6M*16=96M
	CSC_PLL_CFG.OutputDivider=PLLO_DIV_2;	// PLLO=96M/2=48M
	CSC_PLL_Config(&CSC_PLL_CFG);
	CSC_PLL_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_PLLF) == DRV_Normal);
	CSC_ClearFlag(CSC_PLLF);
	/**********************************************************/

	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_PLLO);	
	
	/* Configure peripheral clock */
  ProtectModuleReg(CSCprotect);
    
}

/***********************************************************************************
:	int fputc(int ch,FILE *f)
:	printfض
:	int ch,FILE *f
ز:	ch  
*************************************************************************************/
int fputc(int ch,FILE *f)
{
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
	return ch;
}

/***********************************************************************************
:	void UartSendByte(int ch)
:	Uartͺ
:	int ch
ز:	
*************************************************************************************/
void UartSendByte(int ch)
{
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
}

/***********************************************************************************
:	void URT0_Init(void)
:	UART0ʼ 
		  TXD(PB8),RXD(PB9)
		  8,n,1 115200bps@48MHz
:	
ز:	  
*************************************************************************************/
void URT0_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
		PIN_InitTypeDef PINX_InitStruct;

		UnProtectModuleReg(CSCprotect);
		CSC_PeriphProcessClockSource_Config(CSC_UART0_CKS, CK_APB);
		CSC_PeriphOnModeClock_Config(CSC_ON_UART0,ENABLE);
		CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);	
		ProtectModuleReg(CSCprotect);

			
		//==Set GPIO init
		//PB8 PPO TX ,PB9 ODO RX
		PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
		PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
		PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
		PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
		PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
		PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
		PINX_InitStruct.PINX_Alternate_Function  = 3;				// Pin AFS = URT0_TX
		GPIO_PinMode_Config(PINB(8),&PINX_InitStruct); 					 		// TXD at PBB

		PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
		PINX_InitStruct.PINX_Alternate_Function  = 3;				// Pin AFS = URT0_RX
		GPIO_PinMode_Config(PINB(9),&PINX_InitStruct); 					 		// RXD at PB9

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 12;	                	//Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URTX, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URTX, 31);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 31);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_3TIME);
    URT_TX_Cmd(URTX, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                            	//Enable RX
    
    
 
    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URTX, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URTX, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URTX, URT_DataLine_2);
    
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URTX, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URTX, URT_IDLEMode_No);
    URT_TXGuardTime_Select(URTX, 0);
    
    //=====Enable URT Interrupt=====//
    URT_IT_Config(URT0, URT_IT_RX, ENABLE);
    URT_ITEA_Cmd(URT0, ENABLE);
    NVIC_EnableIRQ(URT0_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URT0, ENABLE);
		
	//==See MG32x02z_URT0_IRQ.c when interrupt in
}


/***********************************************************************************
:	int main()
:	
:	
ز:	  
*************************************************************************************/
int main()
{
	u8 RxData;
	CSC_Init();
	URT0_Init();
	printf("Hello!\n");
	
	while(1)
	{
		if(UartxRxIn!=UartxRxOut)				//һֽϢн
		{
			RxData=UarxRxBuf[UartxRxOut];
			UartSendByte(RxData);
			UartxRxOut++;
			if(UartxRxOut>=UARTX_RX_BUF_SIZE)
			{
				UartxRxOut=0;
			}
    }
	}

}

