/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32x02z demo main c Code. 
 *
 * @par         Project
 *              MG32x02z
 *				demoּTM10ȫܣѧ
 *				ʱƵʡ
 *				demoڶʱʱתPE15 IO״̬
 *				PE9Ϊ͵ƽʱʱڡ
 *				
 *				
 *				ע⣺
 *
 *
 *
 *				
 * @version     
 * @date        
 * @author      
 * @copyright   
 *             
 *
 ******************************************************************************* 
 * @par Disclaimer

 *******************************************************************************
 */


#include "MG32x02z_DRV.H"
#include <stdio.h>
#include "TYPE.h"


#define URTX URT0

#define TM10_PRE_2nd_RELOAD			(u16)((u32)(200*1000*12.00/1-1)%65536)		// 200ms 200msҪļֵǣ
																				//ÿ12MHzʱֵ+1,Ҳ1T=1/fô200msҪӶ٣(200*1000)/T   %65536ȡ16λ /ǵ16λ
#define TM10_MAIN_RELOAD			(u16)((u32)(200*1000*12.00/1-1)/65536)		// 200ms


/***********************************************************************************
:	void Sample_URT0_Init(void)
:	UART0ʼ 
		  TXD(PB8),RXD(PB9)
		  8,n,1 115200bps@12MHz
:	
ز:	  
*************************************************************************************/
void Sample_URT0_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
    PIN_InitTypeDef PINX_InitStruct;
    
    UnProtectModuleReg(CSCprotect);
		CSC_PeriphProcessClockSource_Config(CSC_UART0_CKS, CK_APB);
		CSC_PeriphOnModeClock_Config(CSC_ON_UART0,ENABLE);						// Enable UART0 Clock
		CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);						// Enable PortB Clock
    ProtectModuleReg(CSCprotect);

		PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
		PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
		PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
		PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
		PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
		PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
		PINX_InitStruct.PINX_Alternate_Function  = 3;				// Pin AFS = URT0_TX
		GPIO_PinMode_Config(PINB(8),&PINX_InitStruct); 					 		// TXD at PB8

		PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
		PINX_InitStruct.PINX_Alternate_Function  = 3;				// Pin AFS = URT0_RX
		GPIO_PinMode_Config(PINB(9),&PINX_InitStruct); 					 		// RXD at PB9  
    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InternalClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                //Set PSR
    URT_BRG.URT_BaudRateCounterReload = 3;	                //Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);		    //BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);	            //Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX, URT_TXClock_Internal);	//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URTX, URT_RXClock_Internal);	//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URTX, 25);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 25);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_3TIME);
    URT_TX_Cmd(URTX, ENABLE);	                            //Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                            //Enable RX

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URTX, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URTX, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URTX, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URTX, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URTX, URT_IDLEMode_No);
    URT_TXGuardTime_Select(URTX, 0);
    
    //=====Enable URT Interrupt=====//
 //   URT_IT_Config(URTX, URT_IT_RX, ENABLE);
  //  URT_ITEA_Cmd(URTX, ENABLE);
  //  NVIC_EnableIRQ(URT0_IRQn);
		
    //=====Enable URT=====//
    URT_Cmd(URTX, ENABLE);
		
	//==See MG32x02z_URT0_IRQ.c when interrupt in
}

/***********************************************************************************
:	int fputc(int ch,FILE *f)
:	printfض
:	int ch,FILE *f
ز:	ch  
*************************************************************************************/
int fputc(int ch,FILE *f)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
	return ch;
}

/***********************************************************************************
:	void UartSendByte(int ch)
:	Uartͺ
:	int ch
ز:	
*************************************************************************************/
void UartSendByte(int ch)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
}

/***********************************************************************************
:	void TM10_IRQHandler(int ch)
:	TM10жϺ
:	void
ز:	
*************************************************************************************/
void TM10_IRQHandler(void)
{
	if (TM_GetSingleFlagStatus(TM10, TMx_TOF) == DRV_Happened)	   // Main Timer overflow flag
	{
		PE15=~PE15;
		TM_ClearFlag (TM10, TMx_TOF);
	}

}

/***********************************************************************************
:	void TM10_Init(void)
:	TM10ʼ
:	void
ز:	
*************************************************************************************/
void TM10_Init(void)
{	
	TM_TimeBaseInitTypeDef TM_TimeBase_InitStruct;
	 
	//==Set TM1x Clock
	UnProtectModuleReg(CSCprotect);
	CSC_PeriphProcessClockSource_Config(CSC_TM10_CKS, CK_APB);
	CSC_PeriphOnModeClock_Config(CSC_ON_TM10,ENABLE);						// Enable TM10 Clock
	ProtectModuleReg(CSCprotect);					
		
	TM_DeInit(TM10);
			
	// ----------------------------------------------------
	// Set TimeBase structure parameter
	TM_TimeBase_InitStruct.TM_CounterMode = Full_Counter;					// ȫģʽ
	TM_TimeBase_InitStruct.TM_MainClockSource = TM_CK_INT;					// Դ: (ȫģʽ,)
	TM_TimeBase_InitStruct.TM_2ndClockSource = TM_CK_INT;					// ԤƵ(2nd)Դ: TM_CK_INT
	TM_TimeBase_InitStruct.TM_MainClockDirection = TM_UpCount;				// ϼ 
	TM_TimeBase_InitStruct.TM_2ndClockDirection = TM_UpCount;				// ԤƵ(2nd)ϼ
		
	TM_TimeBase_InitStruct.TM_Prescaler = TM10_PRE_2nd_RELOAD;				// ԤƵ(2nd)ֵ	
	TM_TimeBase_InitStruct.TM_Period = TM10_MAIN_RELOAD;					// ֵ
	TM_TimeBase_Init(TM10, &TM_TimeBase_InitStruct);
		 
	//== SET TM10 ClockOut
	TM_ClockOutSource_Select(TM10, MainCKO);
	TM_ClockOut_Cmd(TM10, ENABLE);	

	// ----------------------------------------------------
	// 2.clear TOF flag
	TM_ClearFlag(TM10, TMx_TOF);
			
	// ----------------------------------------------------
	// 3.Enable TM10/TM16 interrupt 
	TM_IT_Config(TM10,TMx_TIE_IE,ENABLE);									// жʹ
		
	TM_ITEA_Cmd(TM10,ENABLE);

	// ----------------------------------------------------
	// Timer enable
	TM_Timer_Cmd(TM10,ENABLE);
		
	// ----------------------------------------------------
	// NVIC Enable TM10/TM16
	NVIC_EnableIRQ(TM10_IRQn); 

	
}

/***********************************************************************************
:	void SetT1xReload(u32 dwFreq)
:	TIM10ֵ
:	
ز:	  
*************************************************************************************/
void SetT1xReload(u32 dwFreq)
{
	DWordTypeDef dwT1Value;
	dwFreq=dwFreq*2;
	dwT1Value.DW=(48*1000000)/dwFreq-1;    //TM1Xֵһֵֵ0ʼֵҪTǵ1/dwFreq
																					//ÿ48MHzʱֵ+11/48MHzʱֵ+1ôܵҪֵT/ϵͳƵʱ䣬 1/dwFreq/1/48MHz -1
	TM10->ARR.H[0]=dwT1Value.W.WHigh;				//ֲ278ҳΪȫģʽģʽʱTMX_ARRPSARR
	TM10->PSARR.H[0]=dwT1Value.W.WLow;
}


/***********************************************************************************
:	void CSC_Init (void)
:	ϵͳʱӳʼ
:	
ز:	  
*************************************************************************************/
void CSC_Init (void)
{

  UnProtectModuleReg(MEMprotect);     	// Setting flash wait state
  MEM_SetFlashWaitState(MEM_FWAIT_ONE);	// 50MHz> Sysclk >=25MHz
  ProtectModuleReg(MEMprotect);

  UnProtectModuleReg(CSCprotect);
  CSC_CK_APB_Divider_Select(APB_DIV_1);	// Modify CK_APB divider	APB=CK_MAIN/1
  CSC_CK_AHB_Divider_Select(AHB_DIV_1);	// Modify CK_AHB divider	AHB=APB/1

	
	/* CK_HS selection */
	CSC_IHRCO_Select(IHRCO_12MHz);			// IHRCO Sel 12MHz
	CSC_IHRCO_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_IHRCOF) == DRV_Normal);
	CSC_ClearFlag(CSC_IHRCOF);
	CSC_CK_HS_Select(HS_CK_IHRCO);			// CK_HS select IHRCO
	
	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_HS);	

	/* Configure peripheral clock */
	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);						// Enable PortE Clock
	
  ProtectModuleReg(CSCprotect);
    
}



/***********************************************************************************
:	int main()
:	
:	
ز:	  
*************************************************************************************/
int main()
{
	uint32_t i=0;
	PIN_InitTypeDef PINX_InitStruct;
	CSC_Init();

	//==Set GPIO init
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push pull Output mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_High;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	
	PINX_InitStruct.PINX_Alternate_Function  = 0;			
	GPIO_PinMode_Config(PINE(14),&PINX_InitStruct);							//LEDָʾIO 
	GPIO_PinMode_Config(PINE(15),&PINX_InitStruct);							//LEDָʾIO 
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 	 	// Pin select open drain Output mode
	GPIO_PinMode_Config(PINE(9),&PINX_InitStruct);							//ģⰴIO
	PE15=1;
	Sample_URT0_Init();
	TM10_Init();
	printf("hello!\n");

	while(1)
	{
		if(PE9 == 0)			//
		{
			i+=50;
			SetT1xReload(i);
		}
	}
			
}
