/**
 ******************************************************************************
 *
 * @file        MG32x02z_SYS.h
 *
 * @brief       MG32x02z SYS Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_SYS_H
#define _MG32x02z_SYS_H
#define _MG32x02z_SYS_H_VER                         3.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z_SYS_H_VER)
    #error "MG32x02z_SYS_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      SYS_Struct
 *              SYS  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x00]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] System interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  SYS interrupt enable register */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t MID           :32;    //[31..0] Chip manufacture identification code.
        }MBIT;
    }MID;                               /*!< MID        ~ Offset[0x0C]  SYS chip manufacture identification code */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :6;     //[7..2] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  CH0_LAST      :1;     //[16] DMA Channel-0 last loop command
                                        //0 = Not
                                        //1 = Yes
            __IO uint8_t  CH1_LAST      :1;     //[17] DMA Channel-1 last loop command
                                        //0 = Not
                                        //1 = Yes
            __IO uint8_t  CH2_LAST      :1;     //[18] DMA Channel-2 last loop command
                                        //0 = Not
                                        //1 = Yes
            __IO uint8_t  GPR           :5;     //[23..19] General purpose data register bits.
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  SYS System control register 0 */

} SYS_Struct;

/**
 ******************************************************************************
 *
 * @name        SYS  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define SYS_Base                        ((uint32_t)0x4C030000)              /*!< System and Chip Control */
#define SYS                             ((SYS_Struct*) SYS_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        SYS  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        SYS_INT  [register's definitions]
 *              Offset[0x04]  SYS interrupt enable register (0x4C030004)
 ******************************************************************************
 */
///@{
#define SYS_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_INT */
#define SYS_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define SYS_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SYS_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SYS_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define SYS_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define SYS_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define SYS_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define SYS_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define SYS_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_MID  [register's definitions]
 *              Offset[0x0C]  SYS chip manufacture identification code (0x4C03000C)
 ******************************************************************************
 */
///@{
#define SYS_MID_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_MID */
#define SYS_MID_MID_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define SYS_MID_MID_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define SYS_MID_MID_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define SYS_MID_MID_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        SYS_CR0  [register's definitions]
 *              Offset[0x10]  SYS System control register 0 (0x4C030010)
 ******************************************************************************
 */
///@{
#define SYS_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of SYS_CR0 */
#define SYS_CR0_GPR_mask_w                          ((uint32_t)0x00F80000)  /*!< Bit Mask of 32bit */
#define SYS_CR0_GPR_mask_h1                         ((uint16_t)0x00F8)      /*!< Bit Mask of 16bit */
#define SYS_CR0_GPR_mask_b2                         ((uint8_t )0xF8)        /*!< Bit Mask of 8bit */
#define SYS_CR0_GPR_shift_w                         (19)                    /*!< Bit Shift of 32bit */
#define SYS_CR0_GPR_shift_h1                        (3)                     /*!< Bit Shift of 16bit */
#define SYS_CR0_GPR_shift_b2                        (3)                     /*!< Bit Shift of 8bit */

#define SYS_CR0_CH2_LAST_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define SYS_CR0_CH2_LAST_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define SYS_CR0_CH2_LAST_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define SYS_CR0_CH2_LAST_not_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define SYS_CR0_CH2_LAST_not_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define SYS_CR0_CH2_LAST_not_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define SYS_CR0_CH2_LAST_yes_w                      ((uint32_t)0x00040000)  /*!< Bit Value =(1):Yes of 32bit */
#define SYS_CR0_CH2_LAST_yes_h1                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Yes of 16bit */
#define SYS_CR0_CH2_LAST_yes_b2                     ((uint8_t )0x04)        /*!< Bit Value =(1):Yes of 8bit */

#define SYS_CR0_CH1_LAST_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define SYS_CR0_CH1_LAST_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define SYS_CR0_CH1_LAST_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define SYS_CR0_CH1_LAST_not_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define SYS_CR0_CH1_LAST_not_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define SYS_CR0_CH1_LAST_not_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define SYS_CR0_CH1_LAST_yes_w                      ((uint32_t)0x00020000)  /*!< Bit Value =(1):Yes of 32bit */
#define SYS_CR0_CH1_LAST_yes_h1                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Yes of 16bit */
#define SYS_CR0_CH1_LAST_yes_b2                     ((uint8_t )0x02)        /*!< Bit Value =(1):Yes of 8bit */

#define SYS_CR0_CH0_LAST_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define SYS_CR0_CH0_LAST_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define SYS_CR0_CH0_LAST_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define SYS_CR0_CH0_LAST_not_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define SYS_CR0_CH0_LAST_not_h1                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define SYS_CR0_CH0_LAST_not_b2                     ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define SYS_CR0_CH0_LAST_yes_w                      ((uint32_t)0x00010000)  /*!< Bit Value =(1):Yes of 32bit */
#define SYS_CR0_CH0_LAST_yes_h1                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Yes of 16bit */
#define SYS_CR0_CH0_LAST_yes_b2                     ((uint8_t )0x01)        /*!< Bit Value =(1):Yes of 8bit */

///@}

#endif  // _MG32x02z_SYS_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_SYS.h                         */
/*----------------------------------------------------------------------------*/
