/**
 ******************************************************************************
 *
 * @file        MG32x02z_RTC.h
 *
 * @brief       MG32x02z RTC Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_RTC_H
#define _MG32x02z_RTC_H
#define _MG32x02z_RTC_H_VER                         3.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z_RTC_H_VER)
    #error "MG32x02z_RTC_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      RTC_Struct
 *              RTC  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  ALMF          :1;     //[1] RTC alarm matched interrupt flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  PCF           :1;     //[2] RTC periodic interrupt flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TSF           :1;     //[3] RTC time stamp interrupt flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  TOF           :1;     //[4] RTC timer overflow interrupt flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __IO uint8_t  RCRF          :1;     //[5] RTC reload or capture flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  RTC status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] RTC interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALM_IE        :1;     //[1] RTC alarm matched interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PC_IE         :1;     //[2] RTC periodic interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TS_IE         :1;     //[3] RTC time stamp interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  TIE           :1;     //[4] RTC timer overflow/underflow interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RCR_IE        :1;     //[5] RTC_RCR register reload finished, software capture finished or RTC_ALM register value
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  RTC interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :2;     //[1..0] 
            __IO uint8_t  CK_SEL        :2;     //[3..2] RTC input clock CK_RTC source select.
                                        //0x0 = CK_LS
                                        //0x1 = CK_UT
                                        //0x2 = CK_APB
                                        //0x3 = TM01_TRGO
            __IO uint8_t  CK_DIV        :2;     //[5..4] RTC internal clock CK_RTC_INT input divider
                                        //0x0 = DIV1 : divided by 1
                                        //0x1 = DIV2 : divided by 2
                                        //0x2 = DIV4 : divided by 4
                                        //0x3 = DIV8 : divided by 8
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  CK_PDIV       :1;     //[7] RTC internal clock CK_RTC_INT input pre-divider
                                        //0x0 = DIV4096 : divided by 4096
                                        //0x1 = DIV1 : divided by 1
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  RTC clock source register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] RTC key register
                                        //0 = Unprotected
                                        //1 = Protected
            __IO uint16_t LOCK          :16;    //[31..16] RTC lock register
                                        //0 = Unlocked
                                        //1 = Locked
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  RTC write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] RTC function enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALM_EN        :1;     //[1] RTC Alarm enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  RCR_MDS       :2;     //[5..4] RTC timer reload or capture control mode select
                                        //0x0 = Directly capture
                                        //0x1 = Delayed capture
                                        //0x2 = Forced reload
                                        //0x3 = Auto reload
            __I  uint8_t                :2;     //[7..6] 
            __IO uint8_t  OUT_SEL       :2;     //[9..8] RTC output signal select
                                        //0x0 = ALM : Alarm compare output event
                                        //0x1 = PC : CK_RTC_INT periodic clock signal
                                        //0x2 = TS : Time stamp trigger event
                                        //0x3 = TO : Timer overflow signal toggle output
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  TS_TRGS       :2;     //[13..12] RTC time stamp trigger edge select.
                                        //0x0 = Disable
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __IO uint8_t  OUT_STA       :1;     //[14] RTC_OUT output signal initial state
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  OUT_LCK       :1;     //[15] RTC_OUT output signal initial state control
                                        //0 = Locked
                                        //1 = Un-Locked
            __IO uint8_t  ALM_WPEN      :1;     //[16] RTC detect RTC_ALMF flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PC_WPEN       :1;     //[17] RTC detect RTC_PCF flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[18] 
            __IO uint8_t  TF_WPEN       :1;     //[19] RTC detect RTC_TOF flag wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  RTC control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  RC_START      :1;     //[0] RTC timer counter reload and software capture start enable
                                        //0 = No effect
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  RTC control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t RLR           :32;    //[31..0] RTC counter reload and capture register
        }MBIT;
    }RLR;                               /*!< RLR        ~ Offset[0x18]  RTC reload register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t ALM           :32;    //[31..0] RTC alarm compared value register
        }MBIT;
    }ALM;                               /*!< ALM        ~ Offset[0x1C]  RTC alarm compare register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CAP           :32;    //[31..0] RTC counter capture register
        }MBIT;
    }CAP;                               /*!< CAP        ~ Offset[0x20]  RTC capture register */

} RTC_Struct;

/**
 ******************************************************************************
 *
 * @name        RTC  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define RTC_Base                        ((uint32_t)0x5D040000)              /*!< Real Time Clock Control */
#define RTC                             ((RTC_Struct*) RTC_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        RTC  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        RTC_STA  [register's definitions]
 *              Offset[0x00]  RTC status register (0x5D040000)
 ******************************************************************************
 */
///@{
#define RTC_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_STA */
#define RTC_STA_RCRF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RTC_STA_RCRF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RTC_STA_RCRF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RTC_STA_RCRF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RTC_STA_RCRF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RTC_STA_RCRF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RTC_STA_RCRF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define RTC_STA_RCRF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define RTC_STA_RCRF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define RTC_STA_TOF_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RTC_STA_TOF_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RTC_STA_TOF_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RTC_STA_TOF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RTC_STA_TOF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RTC_STA_TOF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RTC_STA_TOF_happened_w                      ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define RTC_STA_TOF_happened_h0                     ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define RTC_STA_TOF_happened_b0                     ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define RTC_STA_TSF_mask_w                          ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RTC_STA_TSF_mask_h0                         ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RTC_STA_TSF_mask_b0                         ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RTC_STA_TSF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RTC_STA_TSF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RTC_STA_TSF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RTC_STA_TSF_happened_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define RTC_STA_TSF_happened_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define RTC_STA_TSF_happened_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define RTC_STA_PCF_mask_w                          ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RTC_STA_PCF_mask_h0                         ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RTC_STA_PCF_mask_b0                         ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RTC_STA_PCF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RTC_STA_PCF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RTC_STA_PCF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RTC_STA_PCF_happened_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define RTC_STA_PCF_happened_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define RTC_STA_PCF_happened_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define RTC_STA_ALMF_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RTC_STA_ALMF_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RTC_STA_ALMF_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RTC_STA_ALMF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define RTC_STA_ALMF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define RTC_STA_ALMF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define RTC_STA_ALMF_happened_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define RTC_STA_ALMF_happened_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define RTC_STA_ALMF_happened_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_INT  [register's definitions]
 *              Offset[0x04]  RTC interrupt enable register (0x5D040004)
 ******************************************************************************
 */
///@{
#define RTC_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_INT */
#define RTC_INT_RCR_IE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define RTC_INT_RCR_IE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define RTC_INT_RCR_IE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define RTC_INT_RCR_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_RCR_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_RCR_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_RCR_IE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_RCR_IE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_RCR_IE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_INT_TIE_mask_w                          ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define RTC_INT_TIE_mask_h0                         ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define RTC_INT_TIE_mask_b0                         ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define RTC_INT_TIE_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_TIE_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_TIE_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_TIE_enable_w                        ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_TIE_enable_h0                       ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_TIE_enable_b0                       ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_INT_TS_IE_mask_w                        ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define RTC_INT_TS_IE_mask_h0                       ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RTC_INT_TS_IE_mask_b0                       ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RTC_INT_TS_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_TS_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_TS_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_TS_IE_enable_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_TS_IE_enable_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_TS_IE_enable_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_INT_PC_IE_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define RTC_INT_PC_IE_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define RTC_INT_PC_IE_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define RTC_INT_PC_IE_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_PC_IE_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_PC_IE_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_PC_IE_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_PC_IE_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_PC_IE_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_INT_ALM_IE_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RTC_INT_ALM_IE_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RTC_INT_ALM_IE_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RTC_INT_ALM_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_ALM_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_ALM_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_ALM_IE_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_ALM_IE_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_ALM_IE_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RTC_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RTC_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RTC_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_CLK  [register's definitions]
 *              Offset[0x08]  RTC clock source register (0x5D040008)
 ******************************************************************************
 */
///@{
#define RTC_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_CLK */
#define RTC_CLK_CK_PDIV_mask_w                      ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define RTC_CLK_CK_PDIV_mask_h0                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define RTC_CLK_CK_PDIV_mask_b0                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RTC_CLK_CK_PDIV_div4096_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV4096 of 32bit */
#define RTC_CLK_CK_PDIV_div4096_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV4096 of 16bit */
#define RTC_CLK_CK_PDIV_div4096_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV4096 of 8bit */
#define RTC_CLK_CK_PDIV_div1_w                      ((uint32_t)0x00000080)  /*!< Bit Value =(0x1):DIV1 of 32bit */
#define RTC_CLK_CK_PDIV_div1_h0                     ((uint16_t)0x0080)      /*!< Bit Value =(0x1):DIV1 of 16bit */
#define RTC_CLK_CK_PDIV_div1_b0                     ((uint8_t )0x80)        /*!< Bit Value =(0x1):DIV1 of 8bit */

#define RTC_CLK_CK_DIV_mask_w                       ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define RTC_CLK_CK_DIV_mask_h0                      ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define RTC_CLK_CK_DIV_mask_b0                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define RTC_CLK_CK_DIV_div1_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DIV1 of 32bit */
#define RTC_CLK_CK_DIV_div1_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DIV1 of 16bit */
#define RTC_CLK_CK_DIV_div1_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):DIV1 of 8bit */
#define RTC_CLK_CK_DIV_div2_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):DIV2 of 32bit */
#define RTC_CLK_CK_DIV_div2_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DIV2 of 16bit */
#define RTC_CLK_CK_DIV_div2_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):DIV2 of 8bit */
#define RTC_CLK_CK_DIV_div4_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):DIV4 of 32bit */
#define RTC_CLK_CK_DIV_div4_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DIV4 of 16bit */
#define RTC_CLK_CK_DIV_div4_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):DIV4 of 8bit */
#define RTC_CLK_CK_DIV_div8_w                       ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):DIV8 of 32bit */
#define RTC_CLK_CK_DIV_div8_h0                      ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DIV8 of 16bit */
#define RTC_CLK_CK_DIV_div8_b0                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):DIV8 of 8bit */

#define RTC_CLK_CK_SEL_mask_w                       ((uint32_t)0x0000000C)  /*!< Bit Mask of 32bit */
#define RTC_CLK_CK_SEL_mask_h0                      ((uint16_t)0x000C)      /*!< Bit Mask of 16bit */
#define RTC_CLK_CK_SEL_mask_b0                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define RTC_CLK_CK_SEL_ck_ls_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CK_LS of 32bit */
#define RTC_CLK_CK_SEL_ck_ls_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CK_LS of 16bit */
#define RTC_CLK_CK_SEL_ck_ls_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):CK_LS of 8bit */
#define RTC_CLK_CK_SEL_ck_ut_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(0x1):CK_UT of 32bit */
#define RTC_CLK_CK_SEL_ck_ut_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(0x1):CK_UT of 16bit */
#define RTC_CLK_CK_SEL_ck_ut_b0                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):CK_UT of 8bit */
#define RTC_CLK_CK_SEL_ck_apb_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(0x2):CK_APB of 32bit */
#define RTC_CLK_CK_SEL_ck_apb_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(0x2):CK_APB of 16bit */
#define RTC_CLK_CK_SEL_ck_apb_b0                    ((uint8_t )0x08)        /*!< Bit Value =(0x2):CK_APB of 8bit */
#define RTC_CLK_CK_SEL_tm01_trgo_w                  ((uint32_t)0x0000000C)  /*!< Bit Value =(0x3):TM01_TRGO of 32bit */
#define RTC_CLK_CK_SEL_tm01_trgo_h0                 ((uint16_t)0x000C)      /*!< Bit Value =(0x3):TM01_TRGO of 16bit */
#define RTC_CLK_CK_SEL_tm01_trgo_b0                 ((uint8_t )0x0C)        /*!< Bit Value =(0x3):TM01_TRGO of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_KEY  [register's definitions]
 *              Offset[0x0C]  RTC write protected Key register (0x5D04000C)
 ******************************************************************************
 */
///@{
#define RTC_KEY_default                             ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_KEY */
#define RTC_KEY_LOCK_mask_w                         ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define RTC_KEY_LOCK_mask_h1                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define RTC_KEY_LOCK_unlocked_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unlocked of 32bit */
#define RTC_KEY_LOCK_unlocked_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Unlocked of 16bit */
#define RTC_KEY_LOCK_unlocked_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Unlocked of 8bit */
#define RTC_KEY_LOCK_locked_w                       ((uint32_t)0x00010000)  /*!< Bit Value =(1):Locked of 32bit */
#define RTC_KEY_LOCK_locked_h1                      ((uint16_t)0x0001)      /*!< Bit Value =(1):Locked of 16bit */
#define RTC_KEY_LOCK_locked_b2                      ((uint8_t )0x01)        /*!< Bit Value =(1):Locked of 8bit */

#define RTC_KEY_KEY_mask_w                          ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define RTC_KEY_KEY_mask_h0                         ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define RTC_KEY_KEY_unprotected_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define RTC_KEY_KEY_unprotected_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define RTC_KEY_KEY_unprotected_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define RTC_KEY_KEY_protected_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define RTC_KEY_KEY_protected_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define RTC_KEY_KEY_protected_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_CR0  [register's definitions]
 *              Offset[0x10]  RTC control register 0 (0x5D040010)
 ******************************************************************************
 */
///@{
#define RTC_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_CR0 */
#define RTC_CR0_TF_WPEN_mask_w                      ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_TF_WPEN_mask_h1                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define RTC_CR0_TF_WPEN_mask_b2                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define RTC_CR0_TF_WPEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_CR0_TF_WPEN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_CR0_TF_WPEN_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_CR0_TF_WPEN_enable_w                    ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR0_TF_WPEN_enable_h1                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR0_TF_WPEN_enable_b2                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_CR0_PC_WPEN_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_PC_WPEN_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RTC_CR0_PC_WPEN_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RTC_CR0_PC_WPEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_CR0_PC_WPEN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_CR0_PC_WPEN_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_CR0_PC_WPEN_enable_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR0_PC_WPEN_enable_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR0_PC_WPEN_enable_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_CR0_ALM_WPEN_mask_w                     ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_ALM_WPEN_mask_h1                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RTC_CR0_ALM_WPEN_mask_b2                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RTC_CR0_ALM_WPEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_CR0_ALM_WPEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_CR0_ALM_WPEN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_CR0_ALM_WPEN_enable_w                   ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR0_ALM_WPEN_enable_h1                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR0_ALM_WPEN_enable_b2                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_CR0_OUT_LCK_mask_w                      ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_OUT_LCK_mask_h0                     ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define RTC_CR0_OUT_LCK_mask_b1                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define RTC_CR0_OUT_LCK_locked_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Locked of 32bit */
#define RTC_CR0_OUT_LCK_locked_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Locked of 16bit */
#define RTC_CR0_OUT_LCK_locked_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Locked of 8bit */
#define RTC_CR0_OUT_LCK_un_locked_w                 ((uint32_t)0x00008000)  /*!< Bit Value =(1):Un-Locked of 32bit */
#define RTC_CR0_OUT_LCK_un_locked_h0                ((uint16_t)0x8000)      /*!< Bit Value =(1):Un-Locked of 16bit */
#define RTC_CR0_OUT_LCK_un_locked_b1                ((uint8_t )0x80)        /*!< Bit Value =(1):Un-Locked of 8bit */

#define RTC_CR0_OUT_STA_mask_w                      ((uint32_t)0x00004000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_OUT_STA_mask_h0                     ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define RTC_CR0_OUT_STA_mask_b1                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define RTC_CR0_OUT_STA_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define RTC_CR0_OUT_STA_0_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define RTC_CR0_OUT_STA_0_b1                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define RTC_CR0_OUT_STA_1_w                         ((uint32_t)0x00004000)  /*!< Bit Value =(1):1 of 32bit */
#define RTC_CR0_OUT_STA_1_h0                        ((uint16_t)0x4000)      /*!< Bit Value =(1):1 of 16bit */
#define RTC_CR0_OUT_STA_1_b1                        ((uint8_t )0x40)        /*!< Bit Value =(1):1 of 8bit */

#define RTC_CR0_TS_TRGS_mask_w                      ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define RTC_CR0_TS_TRGS_mask_h0                     ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define RTC_CR0_TS_TRGS_mask_b1                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define RTC_CR0_TS_TRGS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define RTC_CR0_TS_TRGS_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define RTC_CR0_TS_TRGS_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define RTC_CR0_TS_TRGS_rising_edge_w               ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define RTC_CR0_TS_TRGS_rising_edge_h0              ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define RTC_CR0_TS_TRGS_rising_edge_b1              ((uint8_t )0x10)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define RTC_CR0_TS_TRGS_falling_edge_w              ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define RTC_CR0_TS_TRGS_falling_edge_h0             ((uint16_t)0x2000)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define RTC_CR0_TS_TRGS_falling_edge_b1             ((uint8_t )0x20)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define RTC_CR0_TS_TRGS_dual_edge_w                 ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define RTC_CR0_TS_TRGS_dual_edge_h0                ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define RTC_CR0_TS_TRGS_dual_edge_b1                ((uint8_t )0x30)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define RTC_CR0_OUT_SEL_mask_w                      ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define RTC_CR0_OUT_SEL_mask_h0                     ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define RTC_CR0_OUT_SEL_mask_b1                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define RTC_CR0_OUT_SEL_alm_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ALM of 32bit */
#define RTC_CR0_OUT_SEL_alm_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ALM of 16bit */
#define RTC_CR0_OUT_SEL_alm_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):ALM of 8bit */
#define RTC_CR0_OUT_SEL_pc_w                        ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):PC of 32bit */
#define RTC_CR0_OUT_SEL_pc_h0                       ((uint16_t)0x0100)      /*!< Bit Value =(0x1):PC of 16bit */
#define RTC_CR0_OUT_SEL_pc_b1                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):PC of 8bit */
#define RTC_CR0_OUT_SEL_ts_w                        ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):TS of 32bit */
#define RTC_CR0_OUT_SEL_ts_h0                       ((uint16_t)0x0200)      /*!< Bit Value =(0x2):TS of 16bit */
#define RTC_CR0_OUT_SEL_ts_b1                       ((uint8_t )0x02)        /*!< Bit Value =(0x2):TS of 8bit */
#define RTC_CR0_OUT_SEL_to_w                        ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):TO of 32bit */
#define RTC_CR0_OUT_SEL_to_h0                       ((uint16_t)0x0300)      /*!< Bit Value =(0x3):TO of 16bit */
#define RTC_CR0_OUT_SEL_to_b1                       ((uint8_t )0x03)        /*!< Bit Value =(0x3):TO of 8bit */

#define RTC_CR0_RCR_MDS_mask_w                      ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define RTC_CR0_RCR_MDS_mask_h0                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define RTC_CR0_RCR_MDS_mask_b0                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define RTC_CR0_RCR_MDS_directly_capture_w          ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Directly capture of 32bit */
#define RTC_CR0_RCR_MDS_directly_capture_h0         ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Directly capture of 16bit */
#define RTC_CR0_RCR_MDS_directly_capture_b0         ((uint8_t )0x00)        /*!< Bit Value =(0x0):Directly capture of 8bit */
#define RTC_CR0_RCR_MDS_delayed_capture_w           ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Delayed capture of 32bit */
#define RTC_CR0_RCR_MDS_delayed_capture_h0          ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Delayed capture of 16bit */
#define RTC_CR0_RCR_MDS_delayed_capture_b0          ((uint8_t )0x10)        /*!< Bit Value =(0x1):Delayed capture of 8bit */
#define RTC_CR0_RCR_MDS_forced_reload_w             ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Forced reload of 32bit */
#define RTC_CR0_RCR_MDS_forced_reload_h0            ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Forced reload of 16bit */
#define RTC_CR0_RCR_MDS_forced_reload_b0            ((uint8_t )0x20)        /*!< Bit Value =(0x2):Forced reload of 8bit */
#define RTC_CR0_RCR_MDS_auto_reload_w               ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):Auto reload of 32bit */
#define RTC_CR0_RCR_MDS_auto_reload_h0              ((uint16_t)0x0030)      /*!< Bit Value =(0x3):Auto reload of 16bit */
#define RTC_CR0_RCR_MDS_auto_reload_b0              ((uint8_t )0x30)        /*!< Bit Value =(0x3):Auto reload of 8bit */

#define RTC_CR0_ALM_EN_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define RTC_CR0_ALM_EN_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define RTC_CR0_ALM_EN_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define RTC_CR0_ALM_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_CR0_ALM_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_CR0_ALM_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_CR0_ALM_EN_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR0_ALM_EN_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR0_ALM_EN_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define RTC_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RTC_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RTC_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RTC_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define RTC_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define RTC_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define RTC_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_CR1  [register's definitions]
 *              Offset[0x14]  RTC control register 1 (0x5D040014)
 ******************************************************************************
 */
///@{
#define RTC_CR1_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_CR1 */
#define RTC_CR1_RC_START_mask_w                     ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define RTC_CR1_RC_START_mask_h0                    ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define RTC_CR1_RC_START_mask_b0                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define RTC_CR1_RC_START_no_effect_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):No effect of 32bit */
#define RTC_CR1_RC_START_no_effect_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):No effect of 16bit */
#define RTC_CR1_RC_START_no_effect_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):No effect of 8bit */
#define RTC_CR1_RC_START_enable_w                   ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define RTC_CR1_RC_START_enable_h0                  ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define RTC_CR1_RC_START_enable_b0                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_RLR  [register's definitions]
 *              Offset[0x18]  RTC reload register (0x5D040018)
 ******************************************************************************
 */
///@{
#define RTC_RLR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_RLR */
#define RTC_RLR_RLR_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define RTC_RLR_RLR_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define RTC_RLR_RLR_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define RTC_RLR_RLR_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_ALM  [register's definitions]
 *              Offset[0x1C]  RTC alarm compare register (0x5D04001C)
 ******************************************************************************
 */
///@{
#define RTC_ALM_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_ALM */
#define RTC_ALM_ALM_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */

///@}
/**
 ******************************************************************************
 * @name        RTC_CAP  [register's definitions]
 *              Offset[0x20]  RTC capture register (0x5D040020)
 ******************************************************************************
 */
///@{
#define RTC_CAP_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of RTC_CAP */
#define RTC_CAP_CAP_mask_w                          ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define RTC_CAP_CAP_shift_w                         (0)                     /*!< Bit Shift of 32bit */
#define RTC_CAP_CAP_shift_h0                        (0)                     /*!< Bit Shift of 16bit */
#define RTC_CAP_CAP_shift_b0                        (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32x02z_RTC_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_RTC.h                         */
/*----------------------------------------------------------------------------*/
