/**
 ******************************************************************************
 *
 * @file        MG32x02z_DMA.h
 *
 * @brief       MG32x02z DMA Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V2.0 (Register File Date : 2018_0124)
 * @date        2018/01/24 09:21 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_DMA_EX_H
#define _MG32x02z_DMA_EX_H
#define _MG32x02z_DMA_EX_H_VER                         2.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z_DMA_EX_H_VER)
    #error "MG32x02z_DMA_EX_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      DMA_CHx_Struct
 *              DMA_CHx [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CHx_EN        :1;     //[0] DMA channel operation enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_HOLD      :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_LOOP      :1;     //[2] DMA destination or peripheral transfer address auto increased enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_ADSEL     :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CHx_XMDS      :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __IO uint8_t  CHx_PLS       :2;     //[11..10] DMA channel priority level select.
                                        //0x0 = LV0 : lowest priority
                                        //0x1 = LV1 : normal priority
                                        //0x2 = LV2 : high priority
                                        //0x3 = LV3 : highest priority
            __IO uint8_t  CHx_BSIZE     :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  CHx_REQ       :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CHx_CIE       :1;     //[17] DMA channel-0 transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_HIE       :1;     //[18] DMA channel-0 transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_EIE       :1;     //[19] DMA channel-0 transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  CHx_TC2F      :1;     //[25] DMA channel-0 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CHx_TH2F      :1;     //[26] DMA channel-0 transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CHx_ERR2F     :1;     //[27] DMA channel-0 transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CHxA;                              /*!< CH0A       ~ Offset[0x20]  DMA channel-0 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CHx_SRC       :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CHx_DET       :4;     //[11..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  CHx_SINC      :1;     //[16] DMA source or memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_DINC      :1;     //[17] DMA destination or peripheral transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_SSYNC     :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CHx_DSYNC     :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  CHx_XPIN      :1;     //[24] DMA channel external trigger pin select.
                                        //0x0 = TRG0 : DMA_TRG0 pin
                                        //0x1 = TRG1 : DMA_TRG1 pin
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }CHxB;                              /*!< CH0B       ~ Offset[0x24]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CHx_NUM       :16;    //[15..0] DMA transfer data count initial number
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CHxNUM;                            /*!< CH0NUM     ~ Offset[0x28]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CHx_CNT       :16;    //[15..0] DMA transfer data count current value
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CHxCNT;                            /*!< CH0CNT     ~ Offset[0x2C]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CHx_SSA       :32;    //[31..0] DMA source or memory transfer start address.
        }MBIT;
    }CHxSSA;                            /*!< CH0SSA     ~ Offset[0x30]  DMA channel-0 source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CHx_SCA       :32;    //[31..0] DMA source or memory transfer current address
        }MBIT;
    }CHxSCA;                            /*!< CH0SCA     ~ Offset[0x34]  DMA channel-0 source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CHx_DSA       :32;    //[31..0] DMA destination or peripheral transfer start address.
        }MBIT;
    }CHxDSA;                            /*!< CH0DSA     ~ Offset[0x38]  DMA channel-0 destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CHx_DCA       :32;    //[31..0] DMA destination or peripheral transfer current address
        }MBIT;
    }CHxDCA;                            /*!< CH0DCA     ~ Offset[0x3C]  DMA channel-0 destination current address register */
}DMA_CHx_Struct;



/**
 ******************************************************************************
 *
 * @name        DMA  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define DMA_CH0_Base                    ((uint32_t)0x4BF00020)              /*!< Direct Memory Access Control */
#define DMA_CH1_Base                    ((uint32_t)0x4BF00040)              /*!< Direct Memory Access Control */
#define DMA_CH2_Base                    ((uint32_t)0x4BF00060)              /*!< Direct Memory Access Control */

#define DMA_CH0                         ((DMA_CHx_Struct*)DMA_CH0_Base)     /*!< Direct Memory Access Control */
#define DMA_CH1                         ((DMA_CHx_Struct*)DMA_CH1_Base)     /*!< Direct Memory Access Control */
#define DMA_CH2                         ((DMA_CHx_Struct*)DMA_CH2_Base)     /*!< Direct Memory Access Control */

///@}



/**
 ******************************************************************************
 * @name        DMA_CHxA  [register's definitions]
 *              Offset[0x0]   DMA channel-0 control register 0 (0x4BF00020)
 *              Offset[0x0]   DMA channel-1 control register 0 (0x4BF00040)
 *              Offset[0x0]   DMA channel-2 control register 0 (0x4BF00060)
 ******************************************************************************
 */
///@{
#define DMA_CHxA_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxA */
#define DMA_CHxA_CHx_ERR2F_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_ERR2F_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_ERR2F_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_ERR2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CHxA_CHx_ERR2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CHxA_CHx_ERR2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CHxA_CHx_ERR2F_happened_w               ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CHxA_CHx_ERR2F_happened_h1              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CHxA_CHx_ERR2F_happened_b3              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CHxA_CHx_TH2F_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_TH2F_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_TH2F_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_TH2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CHxA_CHx_TH2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CHxA_CHx_TH2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CHxA_CHx_TH2F_happened_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CHxA_CHx_TH2F_happened_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CHxA_CHx_TH2F_happened_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CHxA_CHx_TC2F_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_TC2F_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_TC2F_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_TC2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CHxA_CHx_TC2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CHxA_CHx_TC2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CHxA_CHx_TC2F_happened_w                ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CHxA_CHx_TC2F_happened_h1               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CHxA_CHx_TC2F_happened_b3               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CHxA_CHx_EIE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_EIE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_EIE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_EIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_EIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_EIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_EIE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_EIE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_EIE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_HIE_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_HIE_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_HIE_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_HIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_HIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_HIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_HIE_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_HIE_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_HIE_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_CIE_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_CIE_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_CIE_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_CIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_CIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_CIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_CIE_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_CIE_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_CIE_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_REQ_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_REQ_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_REQ_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_REQ_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define DMA_CHxA_CHx_REQ_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define DMA_CHxA_CHx_REQ_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define DMA_CHxA_CHx_REQ_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_REQ_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_REQ_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_BSIZE_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_BSIZE_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_BSIZE_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_BSIZE_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define DMA_CHxA_CHx_BSIZE_one_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define DMA_CHxA_CHx_BSIZE_one_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define DMA_CHxA_CHx_BSIZE_two_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Two of 32bit */
#define DMA_CHxA_CHx_BSIZE_two_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Two of 16bit */
#define DMA_CHxA_CHx_BSIZE_two_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):Two of 8bit */
#define DMA_CHxA_CHx_BSIZE_four_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Four of 32bit */
#define DMA_CHxA_CHx_BSIZE_four_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Four of 16bit */
#define DMA_CHxA_CHx_BSIZE_four_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):Four of 8bit */

#define DMA_CHxA_CHx_PLS_mask_w                     ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_PLS_mask_h0                    ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_PLS_mask_b1                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_PLS_lv0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LV0 of 32bit */
#define DMA_CHxA_CHx_PLS_lv0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LV0 of 16bit */
#define DMA_CHxA_CHx_PLS_lv0_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):LV0 of 8bit */
#define DMA_CHxA_CHx_PLS_lv1_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):LV1 of 32bit */
#define DMA_CHxA_CHx_PLS_lv1_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x1):LV1 of 16bit */
#define DMA_CHxA_CHx_PLS_lv1_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):LV1 of 8bit */
#define DMA_CHxA_CHx_PLS_lv2_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):LV2 of 32bit */
#define DMA_CHxA_CHx_PLS_lv2_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):LV2 of 16bit */
#define DMA_CHxA_CHx_PLS_lv2_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):LV2 of 8bit */
#define DMA_CHxA_CHx_PLS_lv3_w                      ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):LV3 of 32bit */
#define DMA_CHxA_CHx_PLS_lv3_h0                     ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):LV3 of 16bit */
#define DMA_CHxA_CHx_PLS_lv3_b1                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):LV3 of 8bit */

#define DMA_CHxA_CHx_XMDS_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_XMDS_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_XMDS_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_XMDS_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CHxA_CHx_XMDS_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CHxA_CHx_XMDS_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CHxA_CHx_XMDS_single_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Single of 32bit */
#define DMA_CHxA_CHx_XMDS_single_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Single of 16bit */
#define DMA_CHxA_CHx_XMDS_single_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):Single of 8bit */
#define DMA_CHxA_CHx_XMDS_block_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Block of 32bit */
#define DMA_CHxA_CHx_XMDS_block_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Block of 16bit */
#define DMA_CHxA_CHx_XMDS_block_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Block of 8bit */
#define DMA_CHxA_CHx_XMDS_demand_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Demand of 32bit */
#define DMA_CHxA_CHx_XMDS_demand_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Demand of 16bit */
#define DMA_CHxA_CHx_XMDS_demand_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):Demand of 8bit */

#define DMA_CHxA_CHx_ADSEL_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_ADSEL_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_ADSEL_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_ADSEL_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CHxA_CHx_ADSEL_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CHxA_CHx_ADSEL_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CHxA_CHx_ADSEL_skip3_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):SKIP3 of 32bit */
#define DMA_CHxA_CHx_ADSEL_skip3_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):SKIP3 of 16bit */
#define DMA_CHxA_CHx_ADSEL_skip3_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):SKIP3 of 8bit */

#define DMA_CHxA_CHx_LOOP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_LOOP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_LOOP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_LOOP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_LOOP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_LOOP_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_LOOP_enable_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_LOOP_enable_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_LOOP_enable_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_HOLD_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_HOLD_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_HOLD_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_HOLD_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_HOLD_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_HOLD_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_HOLD_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_HOLD_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_HOLD_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxA_CHx_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CHxA_CHx_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CHxA_CHx_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CHxA_CHx_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxA_CHx_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxA_CHx_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxA_CHx_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxA_CHx_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxA_CHx_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxB  [register's definitions]
 *              Offset[0x04]  DMA channel-0 control register 1 (0x4BF00024)
 *              Offset[0x04]  DMA channel-1 control register 1 (0x4BF00044)
 *              Offset[0x04]  DMA channel-2 control register 1 (0x4BF00064)
 ******************************************************************************
 */
///@{
#define DMA_CHxB_default                            ((uint32_t)0x00030000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxB */
#define DMA_CHxB_CHx_XPIN_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_XPIN_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_XPIN_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_XPIN_trg0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define DMA_CHxB_CHx_XPIN_trg0_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define DMA_CHxB_CHx_XPIN_trg0_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define DMA_CHxB_CHx_XPIN_trg1_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define DMA_CHxB_CHx_XPIN_trg1_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define DMA_CHxB_CHx_XPIN_trg1_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):TRG1 of 8bit */

#define DMA_CHxB_CHx_DSYNC_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_DSYNC_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_DSYNC_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_DSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxB_CHx_DSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxB_CHx_DSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxB_CHx_DSYNC_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxB_CHx_DSYNC_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxB_CHx_DSYNC_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxB_CHx_SSYNC_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_SSYNC_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_SSYNC_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_SSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxB_CHx_SSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxB_CHx_SSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxB_CHx_SSYNC_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxB_CHx_SSYNC_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxB_CHx_SSYNC_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxB_CHx_DINC_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_DINC_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_DINC_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_DINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxB_CHx_DINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxB_CHx_DINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxB_CHx_DINC_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxB_CHx_DINC_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxB_CHx_DINC_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxB_CHx_SINC_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_SINC_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_SINC_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_SINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CHxB_CHx_SINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CHxB_CHx_SINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CHxB_CHx_SINC_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CHxB_CHx_SINC_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CHxB_CHx_SINC_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CHxB_CHx_DET_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_DET_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_DET_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_DET_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define DMA_CHxB_CHx_DET_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CHxB_CHx_DET_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CHxB_CHx_SRC_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define DMA_CHxB_CHx_SRC_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define DMA_CHxB_CHx_SRC_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CHxB_CHx_SRC_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxB_CHx_SRC_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxB_CHx_SRC_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxNUM  [register's definitions]
 *              Offset[0x08]  DMA channel-0 control register 1 (0x4BF00028)
 *              Offset[0x08]  DMA channel-1 control register 1 (0x4BF00048)
 *              Offset[0x08]  DMA channel-2 control register 1 (0x4BF00068)
 ******************************************************************************
 */
///@{
#define DMA_CHxNUM_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxNUM */
#define DMA_CHxNUM_CHx_NUM_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxNUM_CHx_NUM_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CHxNUM_CHx_NUM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxNUM_CHx_NUM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxNUM_CHx_NUM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxCNT  [register's definitions]
 *              Offset[0x0C]  DMA channel-0 control register 1 (0x4BF0002C)
 *              Offset[0x0C]  DMA channel-1 control register 1 (0x4BF0004C)
 *              Offset[0x0C]  DMA channel-2 control register 1 (0x4BF0006C)
 ******************************************************************************
 */
///@{
#define DMA_CHxCNT_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxCNT */
#define DMA_CHxCNT_CHx_CNT_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxCNT_CHx_CNT_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CHxCNT_CHx_CNT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxCNT_CHx_CNT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxCNT_CHx_CNT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxSSA  [register's definitions]
 *              Offset[0x10]  DMA channel-0 source start address register (0x4BF00030)
 *              Offset[0x10]  DMA channel-1 source start address register (0x4BF00050)
 *              Offset[0x10]  DMA channel-2 source start address register (0x4BF00070)
 ******************************************************************************
 */
///@{
#define DMA_CHxSSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxSSA */
#define DMA_CHxSSA_CHx_SSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxSSA_CHx_SSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxSSA_CHx_SSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxSSA_CHx_SSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxSCA  [register's definitions]
 *              Offset[0x14]  DMA channel-0 source current address register (0x4BF00034)
 *              Offset[0x14]  DMA channel-1 source current address register (0x4BF00054)
 *              Offset[0x14]  DMA channel-2 source current address register (0x4BF00074)
 ******************************************************************************
 */
///@{
#define DMA_CHxSCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxSCA */
#define DMA_CHxSCA_CHx_SCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxSCA_CHx_SCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxSCA_CHx_SCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxSCA_CHx_SCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxDSA  [register's definitions]
 *              Offset[0x18]  DMA channel-0 destination start address register (0x4BF00038)
 *              Offset[0x18]  DMA channel-1 destination start address register (0x4BF00058)
 *              Offset[0x18]  DMA channel-2 destination start address register (0x4BF00078)
 ******************************************************************************
 */
///@{
#define DMA_CHxDSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxDSA */
#define DMA_CHxDSA_CHx_DSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxDSA_CHx_DSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxDSA_CHx_DSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxDSA_CHx_DSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CHxDCA  [register's definitions]
 *              Offset[0x1C]  DMA channel-0 destination current address register (0x4BF0003C)
 *              Offset[0x1C]  DMA channel-1 destination current address register (0x4BF0005C)
 *              Offset[0x1C]  DMA channel-2 destination current address register (0x4BF0007C)
 ******************************************************************************
 */
///@{
#define DMA_CHxDCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CHxDCA */
#define DMA_CHxDCA_CHx_DCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CHxDCA_CHx_DCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CHxDCA_CHx_DCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CHxDCA_CHx_DCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}



#endif


