/**
 ******************************************************************************
 *
 * @file        MG32x02z.h
 *
 * @brief       MG32x02z Device Peripheral Access Layer Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_H
#define _MG32x02z_H
#define _MG32x02z_H_VER                             3.0     /*!< File Version */



/**
 *************************************************
 *  Chip definitions
 *************************************************
 */
// IC Version
#define CHIP_FZ217  	217A        /*!< *[Test Chip Debug]*	*/
#define CHIP_Mx92G8A	2170        /*!< Mx92G8Axxx Chip		*/
// Package Type
#define PKG_DIP28	28			/*!< IC Package Type - DIP 28-pin		*/
#define PKG_LQFP32	32			/*!< IC Package Type - LQFP 32-pin		*/
#define PKG_LQFP48	48			/*!< IC Package Type - LQFP 48-pin		*/
#define PKG_LQFP64	64			/*!< IC Package Type - LQFP 64-pin		*/
#define PKG_LQFP80	80			/*!< IC Package Type - LQFP 80-pin		*/
#define PKG_LQFP100	100			/*!< IC Package Type - LQFP 100-pin     */
// Flash Size
#define FSIZE_128K	128			/*!< 128KB Flash Memory                 */
#define FSIZE_96K	96			/*!< 96KB Flash Memory                  */
#define FSIZE_64K	64			/*!< 64KB Flash Memory                  */
#define FSIZE_32K	32			/*!< 32KB Flash Memory                  */

//[Using on User Configuration File]
//#define IC_CHIP   	CHIP_FZ217		/*!< IC Chip Version                */
//#define IC_PKG   	    PKG_LQFP80		/*!< IC Chip Package Type           */
//#define IC_FSIZE   	FSIZE_128K		/*!< IC Flash Memory Size           */

/**
 *************************************************
 *  ARM CPU Configuration Setting
 *************************************************
 */
#define __CM0_REV                 0 /*!< Core Revision r0p0                             */
#define __MPU_PRESENT             0 /*!< Chip do not provide MPU                       */
#define __NVIC_PRIO_BITS          2 /*!< Chip uses 2 Bits for the Priority Levels      */
#define __Vendor_SysTickConfig    0 /*!< Set to 1 if different SysTick Config is used   */

/**
 ******************************************************************************
 * @enum        IRQn
 *              Interrupt Number Definition
 ******************************************************************************
 */
typedef enum IRQn
{
/******  Cortex-M0 Processor Exceptions Numbers Definitions *****************************************/
    NMI_IRQn                    = -14 , /*!<  ;Non Maskable Interrupt                               */
    HardFault_IRQn              = -13 , /*!<  ;Cortex-M0 Hard Fault Interrupt                       */
    SVC_IRQn                    = -5 ,  /*!<  ;Cortex-M0 SV Call Interrupt                          */
    PendSV_IRQn                 = -2 ,  /*!<  ;Cortex-M0 Pend SV Interrupt                          */
    SysTick_IRQn                = -1 ,  /*!<  ;Cortex-M0 System Tick Interrupt                      */
/******  Peripheral Interrupt Numbers Definitions ***************************************************/
    WWDT_IRQn                   =  0 ,  /*!<  ;Window Watchdog                                      */
    SYS_IRQn                    =  1 ,  /*!<  ;System global Interrupt                              */
    EXINT0_IRQn                 =  3 ,  /*!<  ;EXIC EXINT0                                          */
    EXINT1_IRQn                 =  4 ,  /*!<  ;EXIC EXINT1                                          */
    EXINT2_IRQn                 =  5 ,  /*!<  ;EXIC EXINT2                                          */
    EXINT3_IRQn                 =  6 ,  /*!<  ;EXIC EXINT3                                          */
    COMP_IRQn                   =  7 ,  /*!<  ;Analog Comparators global Interrupt                  */
    DMA_IRQn                    =  8 ,  /*!<  ;DMA all channel global Interrupt                     */
    ADC_IRQn                    =  10 , /*!<  ;ADC                                                  */
    DAC_IRQn                    =  11 , /*!<  ;DAC                                                  */
    TM0x_IRQn                   =  12 , /*!<  ;Timer TM0x global Interrupt                          */
    TM10_IRQn                   =  13 , /*!<  ;Timer TM10                                           */
    TM1x_IRQn                   =  14 , /*!<  ;Timer TM1x global Interrupt                          */
    TM20_IRQn                   =  15 , /*!<  ;Timer TM20                                           */
    TM2x_IRQn                   =  16 , /*!<  ;Timer TM2x global Interrupt                          */
    TM3x_IRQn                   =  17 , /*!<  ;Timer TM3x global Interrupt                          */
    URT0_IRQn                   =  20 , /*!<  ;UART URT0                                            */
    URT123_IRQn                 =  21 , /*!<  ;UART URT1/2/3 global Interrupt                       */
    SPI0_IRQn                   =  24 , /*!<  ;SPI0                                                 */
    I2C0_IRQn                   =  28 , /*!<  ;I2C0                                                 */
    I2Cx_IRQn                   =  29 , /*!<  ;I2Cx global Interrupt                                */
} IRQn_Type;                    /*!< Interrupt Number Definition */


#include "core_cm0.h"
//#include "system_FA217.h"
#include <stdint.h>

/**
 *************************************************
 *  New type definitions
 *************************************************
 */
typedef signed char boolean;		/*!< Boolean	*/
typedef unsigned char byte;			/*!< Byte		*/
//typedef signed char int8;
//typedef signed char sint8;
//typedef unsigned char uint8;
//typedef signed short int16;
//typedef signed short sint16;
//typedef unsigned short uint16;
//typedef signed int int16;
//typedef signed int sint16;
//typedef unsigned int uint16;
//typedef signed long int32;
//typedef signed long sint32;
//typedef unsigned long uint32;
typedef unsigned long long uint64;	/*!< Uint 64-bit	*/
typedef float float32;				/*!< Float 32-bit	*/
typedef double float64;				/*!< Float 64-bit	*/

/**
 *************************************************
 *  @union		ctype
 *				Combined 32/16/8-bit type
 *************************************************
 */
typedef union
{								
	__IO uint8_t    B[4];			/*!< Byte 8-bit 		*/
	__IO uint16_t   H[2];			/*!< Half-Word 16-bit 	*/
	__IO uint32_t   W;				/*!< Word 32-bit 		*/
} ctype;


/**
 *************************************************
 *  General definitions
 *************************************************
 */
//#define     __I     volatile                /*!< defines 'read only' permissions		*/
//#define     __O     volatile                /*!< defines 'write only' permissions		*/
//#define     __IO    volatile                /*!< defines 'read / write' permissions	*/

#define TRUE		1				/*!< True	*/
#define FALSE		0				/*!< False	*/

//#define ENABLE		1
//#define DISABLE		0

#define MASK8(val)  (((val) < 256) ? (val) : (val) < 65536 ? (val) >> 8 : (val) < 16777216 ?  (val) >> 16 : (val) >> 24)	/*!< Mask 8-bit		*/  
#define MASK16(val)  (((val) < 65536) ? (val) : (val)>> 16) 																/*!< Mask 16-bit	*/

/**
 ******************************************************************************
 * @enum        FunctionalState
 *              Enable/Disable
 ******************************************************************************
 */
typedef enum {DISABLE = 0, ENABLE = !DISABLE} FunctionalState;										/*!< Enable/Disable	*/
/**
 ******************************************************************************
 * @enum        FlagStatus
 *              Clear/Se
 ******************************************************************************
 */
typedef enum {CLR = 0, SET = !CLR} FlagStatus ,BitAction;											/*!< Clear/Set	*/
/**
 ******************************************************************************
 * @enum        ITStatus
 *              None/Happened/Stable/Unstable
 ******************************************************************************
 */
typedef enum {NONE = 0,  HAPPENED = !NONE, UNSTABLE = 0, STABLE = !UNSTABLE} ITStatus, CSCStatus;	/*!< None/Happened/Stable/Unstablee	*/
///**
// ******************************************************************************
// *         	  DriverReturn
// *              Success/Fail
// ******************************************************************************
// */
//typedef enum {SUCCESS = 0, FAIL = !SUCCESS}DriverReturn;											/*!< Success/Fail	*/


///**
// *************************************************
// *  Bit MASK
// *************************************************
// */
//#define	BIT0		(0x01<<0)
//#define	BIT1		(0x01<<1)
//#define	BIT2		(0x01<<2)
//#define	BIT3		(0x01<<3)
//#define	BIT4		(0x01<<4)
//#define	BIT5		(0x01<<5)
//#define	BIT6		(0x01<<6)
//#define	BIT7		(0x01<<7)
//#define	BIT8		(0x01<<8)
//#define	BIT9		(0x01<<9)
//#define	BIT10		(0x01<<10)
//#define	BIT11		(0x01<<11)
//#define	BIT12		(0x01<<12)
//#define	BIT13		(0x01<<13)
//#define	BIT14		(0x01<<14)
//#define	BIT15		(0x01<<15)
//#define	BIT16		(0x01<<16)
//#define BIT17		(0x01<<17)
//#define BIT18		(0x01<<18)
//#define BIT19		(0x01<<19)
//#define BIT20		(0x01<<20)
//#define BIT21		(0x01<<21)
//#define BIT22		(0x01<<22)
//#define BIT23		(0x01<<23)
//#define BIT24		(0x01<<24)
//#define BIT25		(0x01<<25)
//#define BIT26		(0x01<<26)
//#define BIT27		(0x01<<27)
//#define BIT28		(0x01<<28)
//#define BIT29		(0x01<<29)
//#define BIT30		(0x01<<30)
//#define BIT31		(0x01<<31)
//
//#define HBIT0       (0x01<<0)
//#define HBIT1       (0x01<<1)
//#define HBIT2       (0x01<<2)
//#define HBIT3       (0x01<<3)
//#define HBIT4       (0x01<<4)
//#define HBIT5       (0x01<<5)
//#define HBIT6       (0x01<<6)
//#define HBIT7       (0x01<<7)
//#define HBIT8       (0x01<<8)
//#define HBIT9       (0x01<<9)
//#define HBIT10      (0x01<<10)
//#define HBIT11      (0x01<<11)
//#define HBIT12      (0x01<<12)
//#define HBIT13      (0x01<<13)
//#define HBIT14      (0x01<<14)
//#define HBIT15      (0x01<<15)
//#define HBIT16      (0x01<<0)
//#define HBIT17      (0x01<<1)
//#define HBIT18      (0x01<<2)
//#define HBIT19      (0x01<<3)
//#define HBIT20      (0x01<<4)
//#define HBIT21      (0x01<<5)
//#define HBIT22      (0x01<<6)
//#define HBIT23      (0x01<<7)
//#define HBIT24      (0x01<<8)
//#define HBIT25      (0x01<<9)
//#define HBIT26      (0x01<<10)
//#define HBIT27      (0x01<<11)
//#define HBIT28      (0x01<<12)
//#define HBIT29      (0x01<<13)
//#define HBIT30      (0x01<<14)
//#define HBIT31      (0x01<<15)
//
//#define BBIT0       (0x01<<0)
//#define BBIT1       (0x01<<1)
//#define BBIT2       (0x01<<2)
//#define BBIT3       (0x01<<3)
//#define BBIT4       (0x01<<4)
//#define BBIT5       (0x01<<5)
//#define BBIT6       (0x01<<6)
//#define BBIT7       (0x01<<7)
//#define BBIT8       (0x01<<0)
//#define BBIT9       (0x01<<1)
//#define BBIT10      (0x01<<2)
//#define BBIT11      (0x01<<3)
//#define BBIT12      (0x01<<4)
//#define BBIT13      (0x01<<5)
//#define BBIT14      (0x01<<6)
//#define BBIT15      (0x01<<7)
//#define BBIT16      (0x01<<0)
//#define BBIT17      (0x01<<1)
//#define BBIT18      (0x01<<2)
//#define BBIT19      (0x01<<3)
//#define BBIT20      (0x01<<4)
//#define BBIT21      (0x01<<5)
//#define BBIT22      (0x01<<6)
//#define BBIT23      (0x01<<7)
//#define BBIT24      (0x01<<0)
//#define BBIT25      (0x01<<1)
//#define BBIT26      (0x01<<2)
//#define BBIT27      (0x01<<3)
//#define BBIT28      (0x01<<4)
//#define BBIT29      (0x01<<5)
//#define BBIT30      (0x01<<6)
//#define BBIT31      (0x01<<7)
        

/**
 *************************************************
 *  Hardware Access
 *************************************************
 */
 
/**
 * @brief  get register value
 * @param  _reg : definitions of register name, like MODULE_REGNAME
 */
#define HW_ReadReg(_reg)             (_reg)											/*!< Hardware Read Register	*/

/**
 * @brief  set register value
 * @param  _reg : definitions of register name, like MODULE_REGNAME
 * @param  _value : definitions of register value, like MODULE_REGNAME_xyz
 */
#define HW_WriteReg(_reg, _value)     _reg = (_value)								/*!< Hardware Write Register	*/

/**
 * @brief  set register bits value =1
 * @param  _reg : definitions of register name, like MODULE_REGNAME
 * @param  _mask : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define HW_SetBit(_reg, _mask)		HW_SetReg(_reg, (HW_GetReg(_reg) | (_mask)))	/*!< Hardware Set Register Bit	*/

/**
 * @brief  set register bits value =0
 * @param  _reg : definitions of register name, like MODULE_REGNAME
 * @param  _mask : definitions of register mask value, like MODULE_REGNAME_mask
 */
#define HW_ClrBit(_reg, _mask)		HW_SetReg(_reg, (HW_GetReg(_reg) & ~(_mask)))	/*!< Hardware Clear Register Bit	*/


/**
 ******************************************************************************
 *
 *              Header Files Include
 *
 ******************************************************************************
 */
//#include "MG32x02z__RegPointer.h"
//#include "MG32x02z__RegAddress.h"
#include "MG32x02z_GPIO.h"
#include "MG32x02z_GPL.h"
#include "MG32x02z_DMA.h"
#include "MG32x02z_RST.h"
#include "MG32x02z_CSC.h"
#include "MG32x02z_PW.h"
#include "MG32x02z_SYS.h"
#include "MG32x02z_MEM.h"
#include "MG32x02z_EMB.h"
#include "MG32x02z_CFG.h"
#include "MG32x02z_EXIC.h"
#include "MG32x02z_I2C.h"
#include "MG32x02z_URT.h"
#include "MG32x02z_SPI.h"
#include "MG32x02z_TM.h"
#include "MG32x02z_ADC.h"
#include "MG32x02z_CMP.h"
#include "MG32x02z_DAC.h"
#include "MG32x02z_IWDT.h"
#include "MG32x02z_WWDT.h"
#include "MG32x02z_RTC.h"
#include "MG32x02z_APB.h"
//#include "MG32x02z_CPU.h"

#endif  // _MG32x02z_H

/*----------------------------------------------------------------------------*/
/*                           End of file MG32x02z.h                           */
/*----------------------------------------------------------------------------*/
