/**
 ******************************************************************************
 *
 * @file        MG32x02z_GPIO_Init.H
 *
 * @brief       This file is to opition GPIO setting.
 *   
 * @par         Project
 *              MG32x02z
 * @version     V1.03
 * @date        2018/03/09
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 */

#ifndef _MG32x02z_GPIO_Init_H
 
#define _MG32x02z_GPIO_Init_H

// <<< Use Configuration Wizard in Context Menu >>>

#define MG32x02z_PIN0_Mask        0x0001
#define MG32x02z_PIN1_Mask        0x0002
#define MG32x02z_PIN2_Mask        0x0004
#define MG32x02z_PIN3_Mask        0x0008
#define MG32x02z_PIN4_Mask        0x0010
#define MG32x02z_PIN5_Mask        0x0020
#define MG32x02z_PIN6_Mask        0x0040
#define MG32x02z_PIN7_Mask        0x0080
#define MG32x02z_PIN8_Mask        0x0100
#define MG32x02z_PIN9_Mask        0x0200
#define MG32x02z_PIN10_Mask       0x0400
#define MG32x02z_PIN11_Mask       0x0800
#define MG32x02z_PIN12_Mask       0x1000
#define MG32x02z_PIN13_Mask       0x2000
#define MG32x02z_PIN14_Mask       0x4000
#define MG32x02z_PIN15_Mask       0x8000


#define PX_LCK_MSK               0x80000000

#define PA_OUT_ADR               GPIOA_Base + 0
#define PA_FLT_ADR               IOMA_Base + 0x40
#define PA0_CR_ADR               IOMA_Base + 4*0
#define PA1_CR_ADR               IOMA_Base + 4*1
#define PA2_CR_ADR               IOMA_Base + 4*2
#define PA3_CR_ADR               IOMA_Base + 4*3
#define PA4_CR_ADR               IOMA_Base + 4*4
#define PA5_CR_ADR               IOMA_Base + 4*5
#define PA6_CR_ADR               IOMA_Base + 4*6
#define PA7_CR_ADR               IOMA_Base + 4*7
#define PA8_CR_ADR               IOMA_Base + 4*8
#define PA9_CR_ADR               IOMA_Base + 4*9
#define PA10_CR_ADR              IOMA_Base + 4*10
#define PA11_CR_ADR              IOMA_Base + 4*11
#define PA12_CR_ADR              IOMA_Base + 4*12
#define PA13_CR_ADR              IOMA_Base + 4*13
#define PA14_CR_ADR              IOMA_Base + 4*14
#define PA15_CR_ADR              IOMA_Base + 4*15

#define PB_OUT_ADR               GPIOB_Base + 0
#define PB_FLT_ADR               IOMB_Base + 0x40
#define PB0_CR_ADR               IOMB_Base + 4*0
#define PB1_CR_ADR               IOMB_Base + 4*1
#define PB2_CR_ADR               IOMB_Base + 4*2
#define PB3_CR_ADR               IOMB_Base + 4*3
#define PB4_CR_ADR               IOMB_Base + 4*4
#define PB5_CR_ADR               IOMB_Base + 4*5
#define PB6_CR_ADR               IOMB_Base + 4*6
#define PB7_CR_ADR               IOMB_Base + 4*7
#define PB8_CR_ADR               IOMB_Base + 4*8
#define PB9_CR_ADR               IOMB_Base + 4*9
#define PB10_CR_ADR              IOMB_Base + 4*10
#define PB11_CR_ADR              IOMB_Base + 4*11
#define PB12_CR_ADR              IOMB_Base + 4*12
#define PB13_CR_ADR              IOMB_Base + 4*13
#define PB14_CR_ADR              IOMB_Base + 4*14
#define PB15_CR_ADR              IOMB_Base + 4*15

#define PC_OUT_ADR               GPIOC_Base + 0
#define PC_FLT_ADR               IOMC_Base + 0x40
#define PC0_CR_ADR               IOMC_Base + 4*0
#define PC1_CR_ADR               IOMC_Base + 4*1
#define PC2_CR_ADR               IOMC_Base + 4*2
#define PC3_CR_ADR               IOMC_Base + 4*3
#define PC4_CR_ADR               IOMC_Base + 4*4
#define PC5_CR_ADR               IOMC_Base + 4*5
#define PC6_CR_ADR               IOMC_Base + 4*6
#define PC7_CR_ADR               IOMC_Base + 4*7
#define PC8_CR_ADR               IOMC_Base + 4*8
#define PC9_CR_ADR               IOMC_Base + 4*9
#define PC10_CR_ADR              IOMC_Base + 4*10
#define PC11_CR_ADR              IOMC_Base + 4*11
#define PC12_CR_ADR              IOMC_Base + 4*12
#define PC13_CR_ADR              IOMC_Base + 4*13
#define PC14_CR_ADR              IOMC_Base + 4*14
#define PC15_CR_ADR              IOMC_Base + 4*15

#define PD_OUT_ADR               GPIOD_Base + 0
#define PD_FLT_ADR               IOMD_Base + 0x40
#define PD0_CR_ADR               IOMD_Base + 4*0
#define PD1_CR_ADR               IOMD_Base + 4*1
#define PD2_CR_ADR               IOMD_Base + 4*2
#define PD3_CR_ADR               IOMD_Base + 4*3
#define PD4_CR_ADR               IOMD_Base + 4*4
#define PD5_CR_ADR               IOMD_Base + 4*5
#define PD6_CR_ADR               IOMD_Base + 4*6
#define PD7_CR_ADR               IOMD_Base + 4*7
#define PD8_CR_ADR               IOMD_Base + 4*8
#define PD9_CR_ADR               IOMD_Base + 4*9
#define PD10_CR_ADR              IOMD_Base + 4*10
#define PD11_CR_ADR              IOMD_Base + 4*11
#define PD12_CR_ADR              IOMD_Base + 4*12
#define PD13_CR_ADR              IOMD_Base + 4*13
#define PD14_CR_ADR              IOMD_Base + 4*14
#define PD15_CR_ADR              IOMD_Base + 4*15

#define PE_OUT_ADR               GPIOE_Base + 0
#define PE_FLT_ADR               IOME_Base + 0x40
#define PE0_CR_ADR               IOME_Base + 4*0
#define PE1_CR_ADR               IOME_Base + 4*1
#define PE2_CR_ADR               IOME_Base + 4*2
#define PE3_CR_ADR               IOME_Base + 4*3
//#define PE4_CR_ADR               IOME_Base + 4*4
//#define PE5_CR_ADR               IOME_Base + 4*5
//#define PE6_CR_ADR               IOME_Base + 4*6
//#define PE7_CR_ADR               IOME_Base + 4*7
#define PE8_CR_ADR               IOME_Base + 4*8
#define PE9_CR_ADR               IOME_Base + 4*9
//#define PE10_CR_ADR              IOME_Base + 4*10
//#define PE11_CR_ADR              IOME_Base + 4*11
#define PE12_CR_ADR              IOME_Base + 4*12
#define PE13_CR_ADR              IOME_Base + 4*13
#define PE14_CR_ADR              IOME_Base + 4*14
#define PE15_CR_ADR              IOME_Base + 4*15



//<h> GPIO Inital
    //<e0>GPIOA configuration
        //<o1> PA Output setting<0x0000-0xFFFF>
        //<o2> PA input filter clock source is  <0=> CLK_AHB <1=> CLK_AHB/8 <2=> CLK_ILRCO <3=> TM00_TRGO <4=> CK_UT
        //<e3.0>PA0 configuration
            //<o4.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o4.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o4.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o4.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o4.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o4.12..15>Pin alternate function                         <0=> GPA0 <8=> MA0 
        //</e>
        //<e3.1>PA1 configuration
            //<o5.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o5.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o5.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o5.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o5.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o5.12..15>Pin alternate function                         <0=> GPA1 <8=> MA1 
        //</e>
        //<e3.2>PA2 configuration
            //<o6.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o6.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o6.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o6.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o6.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o6.12..15>Pin alternate function                         <0=> GPA2 <8=> MA2 
        //</e>
        //<e3.3>PA3 configuration
            //<o7.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o7.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o7.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o7.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o7.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o7.12..15>Pin alternate function                         <0=> GPA3 <8=> MA3 
        //</e>
        //<e3.4>PA4 configuration
            //<o8.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o8.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o8.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o8.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o8.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o8.12..15>Pin alternate function                         <0=> GPA4 <8=> MA4 
        //</e>
        //<e3.5>PA5 configuration
            //<o9.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o9.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o9.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o9.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o9.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o9.12..15>Pin alternate function                         <0=> GPA5 <8=> MA5 
        //</e>
        //<e3.6>PA6 configuration
            //<o10.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o10.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o10.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o10.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o10.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o10.12..15>Pin alternate function                         <0=> GPA6 <8=> MA6 
        //</e>
        //<e3.7>PA7 configuration
            //<o11.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o11.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o11.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o11.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o11.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o11.12..15>Pin alternate function                         <0=> GPA7 <8=> MA7 
        //</e>
        //<e3.8>PA8 configuration
            //<o12.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o12.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o12.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o12.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o12.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o12.12..15>Pin alternate function                         <0=> GPA8 <8=> MA8 
        //</e>
        //<e3.9>PA9 configuration
            //<o13.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o13.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o13.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o13.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o13.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o13.12..15>Pin alternate function                         <0=> GPA9 <8=> MA9 
        //</e>
        //<e3.10>PA10 configuration
            //<o14.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o14.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o14.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o14.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o14.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o14.12..15>Pin alternate function                         <0=> GPA10 <8=> MA10 
        //</e>
        //<e3.11>PA11 configuration
            //<o15.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o15.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o15.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o15.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o15.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o15.12..15>Pin alternate function                         <0=> GPA11 <8=> MA11 
        //</e>
        //<e3.12>PA12 configuration
            //<o16.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o16.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o16.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o16.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o16.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o16.12..15>Pin alternate function                         <0=> GPA12 <8=> MA12 
        //</e>
        //<e3.13>PA13 configuration
            //<o17.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o17.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o17.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o17.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o17.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o17.12..15>Pin alternate function                         <0=> GPA13 <8=> MA13
        //</e>
        //<e3.14>PA14 configuration
            //<o18.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o18.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o18.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o18.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o18.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o18.12..15>Pin alternate function                         <0=> GPA14 <8=> MA14 
        //</e>
        //<e3.15>PA15 configuration
            //<o19.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o19.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o19.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o19.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o19.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o19.12..15>Pin alternate function                         <0=> GPA15 <8=> MA15 
        //</e>
        #define MG32x02z_GPIOAInit_EN      1
        #define PA_OUTPUT_DEFAULT          0xFFFF
        #define PA_FILTER_CLK              0
        #define MG32x02z_GPIOAInit_Mask    0x0300
        #define PA0_CR_CONFIG              0x00000000
        #define PA1_CR_CONFIG              0x00000000
        #define PA2_CR_CONFIG              0x00000000
        #define PA3_CR_CONFIG              0x00000000
        #define PA4_CR_CONFIG              0x00000000
        #define PA5_CR_CONFIG              0x00000000
        #define PA6_CR_CONFIG              0x00000000
        #define PA7_CR_CONFIG              0x00000000
        #define PA8_CR_CONFIG              0x00000000
        #define PA9_CR_CONFIG              0x00000000
        #define PA10_CR_CONFIG             0x00000000
        #define PA11_CR_CONFIG             0x00000000
        #define PA12_CR_CONFIG             0x00000000
        #define PA13_CR_CONFIG             0x00000000
        #define PA14_CR_CONFIG             0x00000000
        #define PA15_CR_CONFIG             0x00000000
    //</e>
    
    //<e0>GPIOB configuration
        //<o1> PB Output setting<0x0000-0xFFFF>
        //<o2> PB input filter clock source is  <0=> CLK_AHB <1=> CLK_AHB/8 <2=> CLK_ILRCO <3=> TM00_TRGO <4=> CK_UT
        //<e3.0>PB0 configuration
            //<o4.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o4.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o4.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o4.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o4.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o4.12..15>Pin alternate function                         <0=> GPB0 <1=> I2C1_SCL <2=> SPI0_NSS <3=> TM01_ETR <4=> TM00_CKO
            //                                                          <5=> TM16_ETR <6=> TM26_IC0 <8=> MA15            
        //</e>
        //<e3.1>PB1 configuration
            //<o5.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o5.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o5.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o5.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o5.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o5.12..15>Pin alternate function                         <0=> GPB1     <1=> I2C1_SDA <2=> SPI0_MISO <3=> TM01_TRGO <4=> TM10_CKO
            //                                                          <5=> TM16_TRGO<6=> TM26_IC1             
        //</e>
        //<e3.2>PB2 configuration
            //<o6.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o6.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o6.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o6.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o6.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o6.12..15>Pin alternate function                         <0=> GPB2 <1=> ADC0_TRG <2=> SPI0_CLK <3=> TM01_CKO <4=> URT2_TX <5=> TM16_CKO
            //                                                          <6=> TM26_OC0H            
        //</e>
        //<e3.3>PB3 configuration
            //<o7.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o7.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o7.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o7.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o7.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o7.12..15>Pin alternate function                         <0=> GPB3 <1=> ADC0_OUT <2=> SPI0_MOSI <4=>URT2_RX <6=> TM26_OC1H 
        //</e>
        //<e3.4>PB4 configuration
            //<o8.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o8.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o8.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o8.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o8.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o8.12..15>Pin alternate function                         <0=> GPB4 <1=> TM01_CKO <2=> SPI0_D3 <3=> TM26_TRGO <4=> URT2_CLK
            //                                                          <5=> TM20_IC0 <6=> TM36_IC0 <8=> MALE <9=>MAD8          
        //</e>
        //<e3.5>PB5 configuration
            //<o9.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o9.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o9.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o9.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o9.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o9.12..15>Pin alternate function                         <0=> GPB5     <1=> TM16_CKO <2=> SPI0_D2 <3=> TM26_ETR <4=> URT2_NSS <5=> TM20_IC1
            //                                                          <6=> TM36_IC1 <8=> MOE <9=> MAD9            
        //</e>
        //<e3.6>PB6 configuration
            //<o10.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o10.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o10.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o10.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o10.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o10.12..15>Pin alternate function                         <0=> GPB6 <1=> CPU_RXEV <2=> SPI0_NSSI <3=> URT0_BRO <4=> URT2_CTS <5=> TM20_ETR
            //                                                           <6=> TM36_IC2 <8=> MWE <9=> MAD10            
        //</e>
        //<e3.7>PB7 configuration
            //<o11.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o11.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o11.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o11.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o11.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o11.12..15>Pin alternate function                         <0=> GPB7      <1=> CPU_TXEV <3=> URT0_TMO <4=> URT2_RTS <5=> TM20_TRGO 
            //                                                           <6=> TM36_IC3  <8=> MCE <9=> MALE2              
        //</e>
        //<e3.8>PB8 configuration
            //<o12.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o12.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o12.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o12.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o12.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o12.12..15>Pin alternate function                         <0=> GPB8 <1=> CMP0_P0  <2=> RTC_OUT <3=> URT0_TX <4=> URT2_BRO <5=> TM20_OC01
            //                                                           <6=> TM36_OC01 <8=> MAD0            
        //</e>
        //<e3.9>PB9 configuration
            //<o13.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o13.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o13.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o13.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o13.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o13.12..15>Pin alternate function                         <0=> GPB9 <1=> CMP1_P0 <2=> RTC_TS <3=> URT0_RX <4=> URT2_TMO <5=> TM20_OC02
            //                                                           <6=> TM36_OC02 <8=> MAD1 <9=> MAD8
        //</e>
        //<e3.10>PB10 configuration
            //<o14.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o14.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o14.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o14.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o14.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o14.12..15>Pin alternate function                         <0=> GPB10 <1=> CMP2_P0 <2=> I2C0_SCL <3=> URT0_NSS <4=> URT2_DE 
            //                                                           <5=> TM20_OC11 <6=>TM36_OC11 <8=>MAD2 <9=> MAD1 
        //</e>
        //<e3.11>PB11 configuration
            //<o15.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o15.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o15.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o15.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o15.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o15.12..15>Pin alternate function                         <0=> GPB11 <1=> CMP3_P0 <2=> I2C0_SDA <3=> URT0_DE <5=> TM20_OC12 
            //                                                           <6=> TM36_OC12 <8=>MAD3 <9=> MAD9
        //</e>
        //<e3.12>PB12 configuration
            //<o16.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o16.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o16.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o16.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o16.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o16.12..15>Pin alternate function                         <0=> GPB12 <1=> DMA_TRG0 <8=> MAD4 <9=> MAD2
        //</e>
        //<e3.13>PB13 configuration
            //<o17.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o17.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o17.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o17.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o17.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o17.12..15>Pin alternate function                         <0=> GPB13 <1=> DAC_TRG0 <2=> TM00_ETR <3=> URT0_CTS <4=> URT3_RX
            //                                                           <5=> TM20_ETR <6=> TM36_ETR <8=> MAD5 <9=> MAD10
        //</e>
        //<e3.14>PB14 configuration
            //<o18.0..2>  Pin mode is                                    <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o18.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o18.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o18.8..9>  Pin output drive strength select               <0=> Drive strength full <2=> Drive strength 1/4
            //<o18.10..11>Pin input deglitch filter clock divider select <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o18.12..15>Pin alternate function                         <0=> GPB14  <2=> TM00_TRGO <3=> URT0_RTS <4=> URT3_TX <5=>TM20_TRGO 
            //                                                           <6=> TM36_BK0<8=> MAD6  <9=> MAD3
        //</e>
        //<e3.15>PB15 configuration
            //<o19.0..2>  Pin mode is                                    <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o19.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o19.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o19.8..9>  Pin output drive strength select               <0=> Drive strength full <2=> Drive strength 1/4
            //<o19.10..11>Pin input deglitch filter clock divider select <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o19.12..15>Pin alternate function                         <0=> GPB15 <1=> IR_OUT <8=> MAD7 <9=> MAD11
        //</e>
        #define MG32x02z_GPIOBInit_EN      1
        #define PB_OUTPUT_DEFAULT          0xFFFF
        #define PB_FILTER_CLK              0
        #define MG32x02z_GPIOBInit_Mask    0x0004
        #define PB0_CR_CONFIG              0x00000000
        #define PB1_CR_CONFIG              0x00000000
        #define PB2_CR_CONFIG              0x00000000
        #define PB3_CR_CONFIG              0x00000000
        #define PB4_CR_CONFIG              0x00000000
        #define PB5_CR_CONFIG              0x00000000
        #define PB6_CR_CONFIG              0x00000000
        #define PB7_CR_CONFIG              0x00000000
        #define PB8_CR_CONFIG              0x00000000
        #define PB9_CR_CONFIG              0x00000000
        #define PB10_CR_CONFIG             0x00000000
        #define PB11_CR_CONFIG             0x00000000
        #define PB12_CR_CONFIG             0x00000000
        #define PB13_CR_CONFIG             0x00000000
        #define PB14_CR_CONFIG             0x00000000
        #define PB15_CR_CONFIG             0x00000000
        
    //</e>
    //<e0>GPIOC configuration
        //<o1> PC Output setting<0x0000-0xFFFF>
        //<o2> PC input filter clock source is  <0=> CLK_AHB <1=> CLK_AHB/8 <2=> CLK_ILRCO <3=> TM00_TRGO <4=> CK_UT
        //<e3.0>PC0 configuration
            //<o4.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi
            //<o4.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o4.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o4.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o4.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o4.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o4.12..15>Pin alternate function                         <0=> GPC0 <1=> ICKO <2=> TM00_CKO <3=> URT0_CLK <4=> URT2_CLK
            //                                                          <5=> TM20_OC00 <6=> TM36_OC00 <8=> MCLK <9=> MWE
        //</e>
        //<e3.1>PC1 configuration
            //<o5.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o5.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o5.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o5.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o5.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o5.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o5.12..15>Pin alternate function                         <0=> GPC1 <1=> ADC0_TRG <2=> TM01_CKO <4=> URT1_CLK <5=> TM20_OC0N
            //                                                          <6=> TM36_OC0N <8=> MAD8 <9=> MAD4            
        //</e>
        //<e3.2>PC2 configuration
            //<o6.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o6.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o6.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o6.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o6.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o6.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o6.12..15>Pin alternate function                         <0=> GPC2 <1=> ADC0_OUT <2=> TM10_CKO <4=> URT2_CLK 
            //                                                          <5=> TM20_OC10 <6=> TM36_OC10 <8=> MAD9 <9=> MAD12
        //</e>
        //<e3.3>PC3 configuration
            //<o7.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi
            //<o7.3>     Pin output high speed mode                     <0=> Disable <1=> Enable            
            //<o7.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o7.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o7.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o7.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o7.12..15>Pin alternate function                         <0=> GPC3 <1=> OBM_P1 <2=> TM16_CKO <3=> URT0_CLK <4=> URT1_CLK <5=> TM20_OC1N
            //                                                          <6=> TM36_OC1N <8=> MAD10 <9=> MAD5
        //</e>
        //<e3.4>PC4 configuration    
            //<o8.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o8.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o8.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o8.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o8.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o8.12..15>Pin alternate function                         <0=> GPC4 <1=> SWCLK <2=> I2C0_SCL <3=> URT0_RX <4=> URT1_RX
        //</e>
        //<e3.5>PC5 configuration
            //<o9.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o9.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o9.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o9.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o9.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o9.12..15>Pin alternate function                         <0=> GPC5 <1=> SWDIO <2=> I2C0_SDA <3=> URT0_TX <4=> URT1_TX 
        //</e>
        //<e3.6>PC6 configuration
            //<o10.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o10.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o10.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o10.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o10.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o10.12..15>Pin alternate function                         <0=> GPC6 <1=> RSTN <2=> RTC_TS <3=> URT0_NSS <5=> TM20_ETR
            //                                                           <6=> TM26_ETR <8=> MBW1 <9=> MALE 
        //</e>
        //<e3.7>PC7 configuration
            //<o11.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o11.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o11.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o11.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o11.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o11.12..15>Pin alternate function                         <0=> GPC7 <1=> ADC0_TRG <2=> RTC_OUT <3=>URT0_DE <6=> TM36_TRGO <8=> MBW0
            //                                                           <9=> MCE
        //</e>
        //<e3.8>PC8 configuration
            //<o12.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o12.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o12.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o12.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o12.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o12.12..15>Pin alternate function                         <0=> GPC8 <1=>ADC0_OUT <2=> I2C0_SCL <3=> URT0_BRO <4=> URT1_TX <5=> TM20_OC0H
            //                                                           <6=> TM36_OC0H <8=> MAD11 <9=> MAD13            
        //</e>
        //<e3.9>PC9 configuration
            //<o13.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o13.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o13.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o13.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o13.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o13.12..15>Pin alternate function                         <0=> GPC9 <1=> CMP0_P0 <2=> I2C0_SDA <3=> URT0_TMO <4=> URT1_RX <5=> TM20_OC1H
            //                                                           <6=> TM36_OC1H <8=> MAD12 <9=>MAD6
        //</e>
        //<e3.10>PC10 configuration
            //<o14.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o14.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o14.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o14.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o14.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o14.12..15>Pin alternate function                         <0=> GPC10 <1=> CMP1_P0 <2=> I2C1_SCL <3=> URT0_TX <4=> URT2_TX
            //                                                           <6=> TM36_OC2H <8=> MAD13 <9=> MAD14            
        //</e>
        //<e3.11>PC11 configuration
            //<o15.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o15.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o15.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o15.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o15.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o15.12..15>Pin alternate function                         <0=> GPC11 <1=> CMP2_P0 <2=> I2C1_SDA <3=> URT0_RX <4=> URT2_RX 
            //                                                           <6=> TM36_OC3H <8=> MAD14 <9=> MAD7            
        //</e>
        //<e3.12>PC12 configuration
            //<o16.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o16.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o16.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o16.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o16.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o16.12..15>Pin alternate function                         <0=> GPC12 <1=> CMP3_P0 <2=> IR_OUT <3=> DAC_TRG0 <5=> TM10_TRGO
            //                                                           <6=> TM36_OC3 <8=> MAD15
        //</e>
        //<e3.13>PC13 configuration
            //<o17.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o17.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o17.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o17.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o17.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o17.12..15>Pin alternate function                         <0=> GPC13 <1=> XIN <3=> URT0_CTS <4=> URT2_RX <5=> TM10_ETR <6=> TM26_ETR
        //</e>
        //<e3.14>PC14 configuration
            //<o18.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN <4=> Quasi 
            //<o18.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o18.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o18.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o18.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o18.12..15>Pin alternate function                         <0=> GPC14 <1=> XOUT <3=> URT0_RTS <4=> URT2_TX <5=> TM10_CKO <6=>TM26_TRGO
        //</e>
        #define MG32x02z_GPIOCInit_EN      0
        #define PC_OUTPUT_DEFAULT          0xFFFF
        #define PC_FILTER_CLK              0
        #define MG32x02z_GPIOCInit_Mask    0x0000
        #define PC0_CR_CONFIG              0x00000000
        #define PC1_CR_CONFIG              0x00000000
        #define PC2_CR_CONFIG              0x00000000
        #define PC3_CR_CONFIG              0x00000000
        #define PC4_CR_CONFIG              0x00000000
        #define PC5_CR_CONFIG              0x00000000
        #define PC6_CR_CONFIG              0x00000000
        #define PC7_CR_CONFIG              0x00000000
        #define PC8_CR_CONFIG              0x00000000
        #define PC9_CR_CONFIG              0x00000000
        #define PC10_CR_CONFIG             0x00000000
        #define PC11_CR_CONFIG             0x00000000
        #define PC12_CR_CONFIG             0x00000000
        #define PC13_CR_CONFIG             0x00000000
        #define PC14_CR_CONFIG             0x00000000
    //</e>
    
    //<e0>GPIOD configuration
        //<o1> PD Output setting<0x0000-0xFFFF>
        //<o2> PD input filter clock source is  <0=> CLK_AHB <1=> CLK_AHB/8 <2=> CLK_ILRCO <3=> TM00_TRGO <4=> CK_UT
        //<e3.0>PD0 configuration
            //<o4.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o4.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o4.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o4.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o4.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o4.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o4.12..15>Pin alternate function                         <0=> GPD0 <1=> OBM_I0 <2=> TM10_CKO <3=> URT0_CLK <5=> TM20_CKO
            //                                                          <6=> TM36_OC2 <9=> MCLK
        //</e>
        //<e3.1>PD1 configuration
            //<o5.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o5.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o5.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o5.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o5.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o5.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o5.12..15>Pin alternate function                         <0=> GPD1 <1=> OBM_I1 <2=> TM16_CKO <3=>URT0_CLK <5=> TM26_CKO <6=>TM36_OC2N
            //                                                          <7=> SPI0_CLK 
        //</e>
        //<e3.2>PD2 configuration
            //<o6.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o6.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o6.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o6.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o6.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o6.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o6.12..15>Pin alternate function                         <0=> GPD2 <2=> TM00_CKO <3=> URT1_CLK <4=>TM26_OC00 <5=>TM20_CKO
            //                                                          <6=> TM36_CKO <7=> SPI0_MOSI <9=> MAD4            
        //</e>
        //<e3.3>PD3 configuration
            //<o7.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN
            //<o7.3>     Pin output high speed mode                     <0=> Disable <1=> Enable
            //<o7.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o7.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o7.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o7.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o7.12..15>Pin alternate function                         <0=> GPD3 <2=> TM01_CKO <3=> URT1_CLK <4=> URT3_CLK <6=> TM26_CKO
            //                                                          <7=> SPI0_D3 <9=> MAD7
        //</e>
        //<e3.4>PD4 configuration
            //<o8.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o8.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o8.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o8.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o8.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o8.12..15>Pin alternate function                         <0=> GPD4 <1=> TM00_TRGO <2=> TM01_TRGO <3=> URT1_TX <4=> URT3_RTS
            //                                                          <6=> TM26_OC00 <7=> SPI0_D2 <9=> MAD6
        //</e>
        //<e3.5>PD5 configuration
            //<o9.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o9.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o9.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o9.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o9.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o9.12..15>Pin alternate function                         <0=> GPD5 <1=> TM00_ETR <3=> URT1_RX <4=> URT3_CTS
            //                                                          <6=> TM26_OC01 <7=> SPI0_MISO <9=> MAD5
        //</e>
        //<e3.6>PD6 configuration
            //<o10.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o10.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o10.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o10.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o10.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o10.12..15>Pin alternate function                         <0=> GPD6 <1=> CPU_NMI <3=>URT1_NSS <4=> URT3_DE
            //                                                           <5=> SPI0_NSSI <6=> TM26_OC02 <7=> SPI0_NSS
        //</e>
        //<e3.7>PD7 configuration
            //<o11.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o11.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o11.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o11.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o11.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o11.12..15>Pin alternate function                         <0=> GPD7 <1=> TM00_CKO <2=> TM01_ETR <3=> URT1_DE <4=> URT3_NSS 
            //                                                           <6=> TM26_OC0N <7=> SPI0_D4 <9=> MAD0
        //</e>
        //<e3.8>PD8 configuration
            //<o12.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o12.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o12.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o12.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o12.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o12.12..15>Pin alternate function                         <0=> GPD8 <3=> URT1_RTS <4=> URT3_TX 
            //                                                           <6=> TM26_OC10 <7=> SPI0_D7 <9=> MAD3
        //</e>
        //<e3.9>PD9 configuration
            //<o13.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o13.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o13.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o13.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o13.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o13.12..15>Pin alternate function                         <0=> GPD9 <3=> URT1_CTS <4=> URT3_RX <6=> TM26_OC11 <7=> SPI0_D6
            //                                                           <9=> MAD2
        //</e>
        //<e3.10>PD10 configuration
            //<o14.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o14.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o14.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o14.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o14.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o14.12..15>Pin alternate function                         <0=> GPD10 <3=> URT1_BRO <4=> URT3_BRO <6=> TM26_OC12
            //                                                           <7=> SPI0_D5 <9=> MAD1            
        //</e>
        //<e3.11>PD11 configuration
            //<o15.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o15.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o15.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o15.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o15.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o15.12..15>Pin alternate function                         <0=> GPD11 <1=> CPU_NMI <2=> DMA_TRG1 <3=> URT1_TMO <4=> URT3_TMO 
            //                                                           <6=> TM26_OC1N <7=>SPI0_NSS <9=> MWE
        //</e>
        //<e3.12>PD12 configuration
            //<o16.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o16.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o16.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o16.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o16.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o16.12..15>Pin alternate function                         <0=> GPD12 <1=> CMP0_P0 <4=> TM00_CKO
            //                                                           <5=> SPI0_CLK <6=> TM20_OC0H <7=> TM26_OC0H <9=> MALE2
        //</e>
        //<e3.13>PD13 configuration
            //<o17.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o17.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o17.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o17.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o17.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o17.12..15>Pin alternate function                         <0=> GPD13 <1=> CMP1_P0 <3=> OBM_P1 <4=> TM00_TRGO
            //                                                           <6=> TM20_OC1H <7=>TM26_OC1H <9=> MCE
        //</e>
        //<e3.14>PD14 configuration
            //<o18.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o18.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o18.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o18.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o18.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o18.12..15>Pin alternate function                         <0=> GPD14 <1=> CMP2_P0 <3=>DAC_TRG0 <4=> TM00_ETR
            //                                                           <6=> TM20_IC0 <7=> TM26_IC0 <9=> MOE
        //</e>
        //<e3.15>PD15 configuration
            //<o19.0..2>  Pin mode                                       <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o19.5>     Pin pull-up resister                           <0=> Disable <1=> Enable 
            //<o19.7>     Pin input inverse                              <0=> Disable <1=> Enable
            //<o19.8..9>  Pin output drive strength                      <0=> Drive strength full <2=> Drive strength 1/4
            //<o19.10..11>Pin input deglitch filter clock divider        <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o19.12..15>Pin alternate function                         <0=> GPD15 <1=> CMP3_P0 <3=> IR_OUT <4=>DMA_TRG0 <6=> TM20_IC1 <7=> TM26_IC1
        //</e>
        #define MG32x02z_GPIODInit_EN      0
        #define PD_OUTPUT_DEFAULT          0xFFFF
        #define PD_FILTER_CLK              0
        #define MG32x02z_GPIODInit_Mask    0x0066
        #define PD0_CR_CONFIG              0x00000000
        #define PD1_CR_CONFIG              0x00007002
        #define PD2_CR_CONFIG              0x00007002
        #define PD3_CR_CONFIG              0x00000000
        #define PD4_CR_CONFIG              0x00000000
        #define PD5_CR_CONFIG              0x00007023
        #define PD6_CR_CONFIG              0x00007021
        #define PD7_CR_CONFIG              0x00000000
        #define PD8_CR_CONFIG              0x00000000
        #define PD9_CR_CONFIG              0x00000000
        #define PD10_CR_CONFIG             0x00000000
        #define PD11_CR_CONFIG             0x00000000
        #define PD12_CR_CONFIG             0x00000000
        #define PD13_CR_CONFIG             0x00000000
        #define PD14_CR_CONFIG             0x00000000
        #define PD15_CR_CONFIG             0x00000000
    //</e>
    //<e0>GPIOE configuration
        //<o1> PE Output  <0x0000-0xFFFF>
        //<o2> PE input filter clock source is  <0=> CLK_AHB <1=> CLK_AHB/8 <2=> CLK_ILRCO <3=> TM00_TRGO <4=> CK_UT
        //<e3.0>PE0 configuration
            //<o4.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o4.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o4.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o4.8..9>  Pin output drive strength                        <0=> Drive strength full <1=> Drive strength 1/2 <2=> Drive strength 1/4
            //                                                            <3=> Drive strength 1/8
            //<o4.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o4.12..15>Pin alternate function                           <0=> GPE0 <1=> OBM_I0 <3=> URT0_TX 
            //                                                            <6=> TM20_OC00 <7=>TM26_OC00 <8=> MALE 
        //</e>
        //<e3.1>PE1 configuration
            //<o5.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o5.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o5.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o5.8..9>  Pin output drive strength                        <0=> Drive strength full <1=> Drive strength 1/2 <2=> Drive strength 1/4
            //                                                            <3=> Drive strength 1/8
            //<o5.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o5.12..15>Pin alternate function                           <0=> GPE1 <1=> OBM_I1 <3=> URT0_RX <4=> DMA_TRG1
            //                                                            <6=> TM20_OC01 <7=> TM26_OC01 <8=> MOE 
        //</e>
        //<e3.2>PE2 configuration
            //<o6.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o6.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o6.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o6.8..9>  Pin output drive strength                        <0=> Drive strength full <1=> Drive strength 1/2 <2=> Drive strength 1/4
            //                                                            <3=> Drive strength 1/8
            //<o6.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o6.12..15>Pin alternate function                           <0=> GPE2 <3=> URT1_TX 
            //                                                            <6=> TM20_OC02 <7=> TM26_OC02 <8=> MWE 
        //</e>
        //<e3.3>PE3 configuration
            //<o7.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o7.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o7.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o7.8..9>  Pin output drive strength                        <0=> Drive strength full <1=> Drive strength 1/2 <2=> Drive strength 1/4
            //                                                            <3=> Drive strength 1/8
            //<o7.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o7.12..15>Pin alternate function                           <0=> GPE3 <1=> OBM_P1 <3=> URT1_RX 
            //                                                            <6=> TM20_OC0N <7=> TM26_OC0N <8=> MCE <9=> MALE2
        //</e>
        //<e3.8>PE8 configuration
            //<o8.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o8.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o8.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o8.8..9>  Pin output drive strength                        <0=> Drive strength full <2=> Drive strength 1/4
            //<o8.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o8.12..15>Pin alternate function                           <0=> GPE8 <1=> CPU_TXEV <2=> OBM_I0 <3=> URT2_TX <5=> TM36_CKO
            //                                                            <6=> TM20_CKO <7=> TM26_CKO 
        //</e>
        //<e3.9>PE9 configuration
            //<o9.0..2>  Pin mode                                         <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o9.5>     Pin pull-up resister                             <0=> Disable <1=> Enable 
            //<o9.7>     Pin input inverse                                <0=> Disable <1=> Enable
            //<o9.8..9>  Pin output drive strength                        <0=> Drive strength full <2=> Drive strength 1/4
            //<o9.10..11>Pin input deglitch filter clock divider          <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o9.12..15>Pin alternate function                           <0=> GPE9 <1=> CPU_REXV <2=> OBM_I1 <3=> URT2_RX <5=> TM36_TRGO 
            //                                                            <6=> TM20_TRGO <7=> TM26_TRGO <9=> MOE
        //</e>
        //<e3.12>PE12 configuration
            //<o10.0..2>  Pin mode                                        <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o10.5>     Pin pull-up resister                            <0=> Disable <1=> Enable 
            //<o10.7>     Pin input inverse                               <0=> Disable <1=> Enable
            //<o10.8..9>  Pin output drive strength                       <0=> Drive strength full <2=> Drive strength 1/4
            //<o10.10..11>Pin input deglitch filter clock divider         <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o10.12..15>Pin alternate function                          <0=> GPE12 <1=> ADC0_TRG <3=> URT3_TX <4=> TM01_CKO
            //                                                            <5=> TM16_CKO <6=> TM20_OC10 <7=> TM26_OC10 <8=> MBW0
        //</e>
        //<e3.13>PE13 configuration
            //<o11.0..2>  Pin mode                                        <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o11.5>     Pin pull-up resister                            <0=> Disable <1=> Enable 
            //<o11.7>     Pin input inverse                               <0=> Disable <1=> Enable
            //<o11.8..9>  Pin output drive strength                       <0=> Drive strength full <2=> Drive strength 1/4
            //<o11.10..11>Pin input deglitch filter clock divider         <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o11.12..15>Pin alternate function                          <0=> GPE13 <1=> ADC0_OUT <3=> URT3_RX <4=> TM01_TRGO <5=> TM16_TRGO
            //                                                            <6=> TM20_OC11 <7=> TM26_OC11 <8=> MBW1
        //</e>
        //<e3.14>PE14 configuration
            //<o12.0..2>  Pin mode                                        <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o12.5>     Pin pull-up resister                            <0=> Disable <1=> Enable 
            //<o12.7>     Pin input inverse                               <0=> Disable <1=> Enable
            //<o12.8..9>  Pin output drive strength                       <0=> Drive strength full <2=> Drive strength 1/4
            //<o12.10..11>Pin input deglitch filter clock divider         <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o12.12..15>Pin alternate function                          <0=> GPE14 <1=> RTC_OUT <4=> TM01_ETR <5=> TM16_ETR
            //                                                            <6=> TM20_OC12 <7=> TM26_OC12 <8=> MALE2 
        //</e>
        //<e3.15>PE15 configuration
            //<o13.0..2>  Pin mode                                        <0=> AIO <1=> ODO <2=> PPO <3=> DIN 
            //<o13.5>     Pin pull-up resister                            <0=> Disable <1=> Enable 
            //<o13.7>     Pin input inverse                               <0=> Disable <1=> Enable
            //<o13.8..9>  Pin output drive strength                       <0=> Drive strength full <2=> Drive strength 1/4
            //<o13.10..11>Pin input deglitch filter clock divider         <0=> Bypass <1=> /1 <2=> /4 <3=> /16
            //<o13.12..15>Pin alternate function                          <0=> GPE15 <1=> RTC_TS <5=> TM36_ETR <6=> TM20_OC1N
            //                                                            <7=> TM26_OC1N <9=> MALE
        //</e>
        #define MG32x02z_GPIOEInit_EN      0
        #define PE_OUTPUT_DEFAULT          0xFFFF
        #define PE_FILTER_CLK              0
        #define MG32x02z_GPIOEInit_Mask    0xE000
        #define PE0_CR_CONFIG              0x00000000
        #define PE1_CR_CONFIG              0x00000000
        #define PE2_CR_CONFIG              0x00000000
        #define PE3_CR_CONFIG              0x00000000
        #define PE8_CR_CONFIG              0x00000000
        #define PE9_CR_CONFIG              0x00000000
        #define PE12_CR_CONFIG             0x00000000
        #define PE13_CR_CONFIG             0x00000002
        #define PE14_CR_CONFIG             0x00000002
        #define PE15_CR_CONFIG             0x00000002
    //</e>
//</h>

    static const uint32_t GPIO_CFG[]=
    {
        #if MG32x02z_GPIOAInit_EN == 1
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN0_Mask) == MG32x02z_PIN0_Mask
                PA0_CR_ADR,PA0_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN1_Mask) == MG32x02z_PIN1_Mask
                PA1_CR_ADR,PA1_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN2_Mask) == MG32x02z_PIN2_Mask
                PA2_CR_ADR,PA2_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN3_Mask) == MG32x02z_PIN3_Mask
                PA3_CR_ADR,PA3_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN4_Mask) == MG32x02z_PIN4_Mask
                PA4_CR_ADR,PA4_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN5_Mask) == MG32x02z_PIN5_Mask
                PA5_CR_ADR,PA5_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN6_Mask) == MG32x02z_PIN6_Mask
                PA6_CR_ADR,PA6_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN7_Mask) == MG32x02z_PIN7_Mask
                PA7_CR_ADR,PA7_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN8_Mask) == MG32x02z_PIN8_Mask
                PA8_CR_ADR,PA8_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN9_Mask) == MG32x02z_PIN9_Mask
                PA9_CR_ADR,PA9_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN10_Mask) == MG32x02z_PIN10_Mask
                PA10_CR_ADR,PA10_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN11_Mask) == MG32x02z_PIN11_Mask
                PA11_CR_ADR,PA11_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN12_Mask) == MG32x02z_PIN12_Mask
                PA12_CR_ADR,PA12_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN13_Mask) == MG32x02z_PIN13_Mask
                PA13_CR_ADR,PA13_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN14_Mask) == MG32x02z_PIN14_Mask
                PA14_CR_ADR,PA14_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOAInit_Mask & MG32x02z_PIN15_Mask) == MG32x02z_PIN15_Mask
                PA15_CR_ADR,PA15_CR_CONFIG,
            #endif
            PA_FLT_ADR,PA_FILTER_CLK,
            PA_OUT_ADR,PA_OUTPUT_DEFAULT,            
        #endif
        #if MG32x02z_GPIOBInit_EN == 1
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN0_Mask) == MG32x02z_PIN0_Mask
                PB0_CR_ADR,PB0_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN1_Mask) == MG32x02z_PIN1_Mask
                PB1_CR_ADR,PB1_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN2_Mask) == MG32x02z_PIN2_Mask
                PB2_CR_ADR,PB2_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN3_Mask) == MG32x02z_PIN3_Mask
                PB3_CR_ADR,PB3_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN4_Mask) == MG32x02z_PIN4_Mask
                PB4_CR_ADR,PB4_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN5_Mask) == MG32x02z_PIN5_Mask
                PB5_CR_ADR,PB5_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN6_Mask) == MG32x02z_PIN6_Mask
                PB6_CR_ADR,PB6_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN7_Mask) == MG32x02z_PIN7_Mask
                PB7_CR_ADR,PB7_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN8_Mask) == MG32x02z_PIN8_Mask
                PB8_CR_ADR,PB8_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN9_Mask) == MG32x02z_PIN9_Mask
                PB9_CR_ADR,PB9_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN10_Mask) == MG32x02z_PIN10_Mask
                PB10_CR_ADR,PB10_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN11_Mask) == MG32x02z_PIN11_Mask
                PB11_CR_ADR,PB11_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN12_Mask) == MG32x02z_PIN12_Mask
                PB12_CR_ADR,PB12_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN13_Mask) == MG32x02z_PIN13_Mask
                PB13_CR_ADR,PB13_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN14_Mask) == MG32x02z_PIN14_Mask
                PB14_CR_ADR,PB14_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOBInit_Mask & MG32x02z_PIN15_Mask) == MG32x02z_PIN15_Mask
                PB15_CR_ADR,PB15_CR_CONFIG,
            #endif  
            PB_FLT_ADR,PB_FILTER_CLK,
            PB_OUT_ADR,PB_OUTPUT_DEFAULT,              
        #endif
        #if MG32x02z_GPIOCInit_EN == 1
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN0_Mask) == MG32x02z_PIN0_Mask
                PC0_CR_ADR,PC0_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN1_Mask) == MG32x02z_PIN1_Mask
                PC1_CR_ADR,PC1_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN2_Mask) == MG32x02z_PIN2_Mask
                PC2_CR_ADR,PC2_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN3_Mask) == MG32x02z_PIN3_Mask
                PC3_CR_ADR,PC3_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN4_Mask) == MG32x02z_PIN4_Mask
                PC4_CR_ADR, (PC4_CR_CONFIG | PX_LCK_MSK),                                      // PC4 AFS need unlock
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN5_Mask) == MG32x02z_PIN5_Mask
                PC5_CR_ADR, (PC5_CR_CONFIG | PX_LCK_MSK),                                      // PC5 AFS need unlock
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN6_Mask) == MG32x02z_PIN6_Mask
                PC6_CR_ADR, (PC6_CR_CONFIG | PX_LCK_MSK),                                      // PC6 AFS need unlock
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN7_Mask) == MG32x02z_PIN7_Mask
                PC7_CR_ADR,PC7_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN8_Mask) == MG32x02z_PIN8_Mask
                PC8_CR_ADR,PC8_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN9_Mask) == MG32x02z_PIN9_Mask
                PC9_CR_ADR,PC9_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN10_Mask) == MG32x02z_PIN10_Mask
                PC10_CR_ADR,PC10_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN11_Mask) == MG32x02z_PIN11_Mask
                PC11_CR_ADR,PC11_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN12_Mask) == MG32x02z_PIN12_Mask
                PC12_CR_ADR,PC12_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN13_Mask) == MG32x02z_PIN13_Mask
                PC13_CR_ADR,PC13_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOCInit_Mask & MG32x02z_PIN14_Mask) == MG32x02z_PIN14_Mask
                PC14_CR_ADR,PC14_CR_CONFIG,
            #endif  
            PC_FLT_ADR,PC_FILTER_CLK,
            PC_OUT_ADR,PC_OUTPUT_DEFAULT,           
        #endif
        #if MG32x02z_GPIODInit_EN == 1
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN0_Mask) == MG32x02z_PIN0_Mask
                PD0_CR_ADR,PD0_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN1_Mask) == MG32x02z_PIN1_Mask
                PD1_CR_ADR,PD1_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN2_Mask) == MG32x02z_PIN2_Mask
                PD2_CR_ADR,PD2_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN3_Mask) == MG32x02z_PIN3_Mask
                PD3_CR_ADR,PD3_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN4_Mask) == MG32x02z_PIN4_Mask
                PD4_CR_ADR,PD4_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN5_Mask) == MG32x02z_PIN5_Mask
                PD5_CR_ADR,PD5_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN6_Mask) == MG32x02z_PIN6_Mask
                PD6_CR_ADR,PD6_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN7_Mask) == MG32x02z_PIN7_Mask
                PD7_CR_ADR,PD7_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN8_Mask) == MG32x02z_PIN8_Mask
                PD8_CR_ADR,PD8_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN9_Mask) == MG32x02z_PIN9_Mask
                PD9_CR_ADR,PD9_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN10_Mask) == MG32x02z_PIN10_Mask
                PD10_CR_ADR,PD10_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN11_Mask) == MG32x02z_PIN11_Mask
                PD11_CR_ADR,PD11_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN12_Mask) == MG32x02z_PIN12_Mask
                PD12_CR_ADR,PD12_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN13_Mask) == MG32x02z_PIN13_Mask
                PD13_CR_ADR,PD13_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN14_Mask) == MG32x02z_PIN14_Mask
                PD14_CR_ADR,PD14_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIODInit_Mask & MG32x02z_PIN15_Mask) == MG32x02z_PIN15_Mask
                PD15_CR_ADR,PD15_CR_CONFIG,
            #endif 
            PD_FLT_ADR,PD_FILTER_CLK,
            PD_OUT_ADR,PD_OUTPUT_DEFAULT,             
        #endif
        #if MG32x02z_GPIOEInit_EN == 1
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN0_Mask) == MG32x02z_PIN0_Mask
                PE0_CR_ADR,PE0_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN1_Mask) == MG32x02z_PIN1_Mask
                PE1_CR_ADR,PE1_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN2_Mask) == MG32x02z_PIN2_Mask
                PE2_CR_ADR,PE2_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN3_Mask) == MG32x02z_PIN3_Mask
                PE3_CR_ADR,PE3_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN8_Mask) == MG32x02z_PIN8_Mask
                PE8_CR_ADR,PE8_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN9_Mask) == MG32x02z_PIN9_Mask
                PE9_CR_ADR,PE9_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN12_Mask) == MG32x02z_PIN12_Mask
                PE12_CR_ADR,PE12_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN13_Mask) == MG32x02z_PIN13_Mask
                PE13_CR_ADR,PE13_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN14_Mask) == MG32x02z_PIN14_Mask
                PE14_CR_ADR,PE14_CR_CONFIG,
            #endif
            #if (MG32x02z_GPIOEInit_Mask & MG32x02z_PIN15_Mask) == MG32x02z_PIN15_Mask
                PE15_CR_ADR,PE15_CR_CONFIG,
            #endif  
            PE_FLT_ADR,PE_FILTER_CLK,
            PE_OUT_ADR,PE_OUTPUT_DEFAULT,             
        #endif   
        0,        
    };
// <<< end of configuration section >>>    
 
    
void GPIO_Init(void);    
    
    
#endif





