
/**
 *******************************************************************************
 *
 * @file        MG32x02z_I2C_IRQ.h
 *
 * @brief       The I2C Interrupt Request Handler H file
 *
 * MG32x02z     remote controller
 * @version     V1.00
 * @date        2016/10/25
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2015 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */



// <<< Use Configuration Wizard in Context Menu >>>


// <<< end of configuration section >>>    



#ifndef _MG32x02z_I2C_IRQ_H
#define _MG32x02z_I2C_IRQ_H
#define _MG32x02z_I2C_IRQ_H_VER                          0.01        /*!< File Version */

#ifdef __cplusplus
 extern "C" {
#endif

#if !(MG32x02z_H_VER == MG32x02z_I2C_IRQ_H_VER)
    #error "MG32x02z_I2C_H - Main/Module Version Mismatch !"
#endif


#include "MG32x02z_DRV.h"



void I2C_WakeUp_Handler(I2C_Struct* I2Cx);
void I2C_Timeout_Handler(I2C_Struct* I2Cx);
void I2C_ByteMode_Event_Handler(I2C_Struct* I2Cx);

void I2C0_IRQ(void);

void I2C1_IRQ(void);

#ifdef __cplusplus
}
#endif

#endif


