

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32x02z demo main c Code. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2017/07/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */

#include "MG32x02z_DRV.H"
#include <stdio.h>

#define URTX URT0

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

#define DATA_LENGTH          20
uint8_t TestBuf[DATA_LENGTH] __attribute__((at(0x20001000)));

#define Dummy_Data 	0xFFFFFFFF

#define SPI_NSS 	PB0     // SPI_NSS

void SysTick_Handler(void)
{
    //to do......
	IncTick();
}


void CSC_Init (void)
{
	CSC_PLL_TyprDef CSC_PLL_CFG;
    
	
    UnProtectModuleReg(MEMprotect);     	// Setting flash wait state
    MEM_SetFlashWaitState(MEM_FWAIT_ONE);	// 50MHz> Sysclk >=25MHz
    ProtectModuleReg(MEMprotect);

    UnProtectModuleReg(CSCprotect);
	CSC_CK_APB_Divider_Select(APB_DIV_1);	// Modify CK_APB divider	APB=CK_MAIN/1
	CSC_CK_AHB_Divider_Select(AHB_DIV_1);	// Modify CK_AHB divider	AHB=APB/1

	
	/* CK_HS selection */
	CSC_IHRCO_Select(IHRCO_12MHz);			// IHRCO Sel 12MHz
	CSC_IHRCO_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_IHRCOF) == DRV_Normal);
	CSC_ClearFlag(CSC_IHRCOF);
	CSC_CK_HS_Select(HS_CK_IHRCO);			// CK_HS select IHRCO


	/* PLL */
	/**********************************************************/
	CSC_PLL_CFG.InputDivider=PLLI_DIV_2;	// 12M/2=6M
	CSC_PLL_CFG.Multiplication=PLLIx16;		// 6M*16=96M
	CSC_PLL_CFG.OutputDivider=PLLO_DIV_2;	// PLLO=96M/2=48M
	CSC_PLL_Config(&CSC_PLL_CFG);
	CSC_PLL_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_PLLF) == DRV_Normal);
	CSC_ClearFlag(CSC_PLLF);
	/**********************************************************/

	
	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_PLLO);	


	/* Configure ICKO function */
		
	/* Configure peripheral clock */
	CSC_PeriphProcessClockSource_Config(CSC_UART0_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_UART0,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortC,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);
	
	CSC_PeriphProcessClockSource_Config(CSC_SPI0_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_SPI0,ENABLE);

 	CSC_PeriphOnModeClock_Config(CSC_ON_DMA,ENABLE);
	

    ProtectModuleReg(CSCprotect);
    
}


int fputc(int ch,FILE *f)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
	return ch;
}

void UartSendByte(int ch)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
}


void URT0_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
	PIN_InitTypeDef PINX_InitStruct;
    
	//==Set GPIO init
	//PB8 PPO TX ,PB9 ODO RX
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	PINX_InitStruct.PINX_Alternate_Function  = PB8_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINB(8),&PINX_InitStruct); 					 		// TXD at PB8

	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PB9_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINB(9),&PINX_InitStruct); 					 		// RXD at PB9

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InteranlClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 12;	                	//Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URTX, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URTX, 31);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 31);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_3TIME);
    URT_TX_Cmd(URTX, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                            	//Enable RX
    
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URTX, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URTX, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URTX, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URTX, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URTX, URT_IDLEMode_No);
    URT_TXGaudTime_Select(URTX, 0);
    
    //=====Enable URT Interrupt=====//
    //URT_IT_Cmd(URTX, URT_IT_RX, ENABLE);
    //URT_ITEA_Cmd(URTX, ENABLE);
    //NVIC_EnableIRQ(URT0_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URTX, ENABLE);
		
	//==See MG32x02z_URT0_IRQ.c when interrupt in
}

void InitDMA0(void)
{  
    // make sure :
    // Enable DMA clock from CSC macro (reference MG32x02z_CSC_Init.h file)
    
    DMA_BaseInitTypeDef DMATestPattern;

    // ------------------------------------------------------------------------
    // 1.Enable DMA
    DMA_Cmd(ENABLE);
    
    // ------------------------------------------------------------------------
    // 2.Enable Channel0
    DMA_Channel_Cmd(DMAChannel0, ENABLE);
    
    // ------------------------------------------------------------------------
    DMA_BaseInitStructure_Init(&DMATestPattern);
    
    // 3.initial & modify parameter
    {   
        // DMA channel select
        DMATestPattern.DMAChx = DMAChannel0;
        
        // channel x source/destination auto increase address
        DMATestPattern.SrcSINCSel = DISABLE;
        DMATestPattern.DestDINCSel = ENABLE;
        
        // DMA source peripheral config
        DMATestPattern.SrcSymSel = DMA_SPI0_RX;
        
        // DMA destination peripheral config
        DMATestPattern.DestSymSel = DMA_MEM_Wrtie;
        
        // DMA Burst size config
        DMATestPattern.BurstDataSize = DMA_BurstSize_1Byte;
        
        // DMA transfer data count initial number
        DMATestPattern.DMATransferNUM = DATA_LENGTH;
    
        // source/destination config
        DMATestPattern.DMASourceAddr = (uint8_t *)&SPI0->RDAT.B[0];
        DMATestPattern.DMADestinationAddr = (uint8_t *)&TestBuf;
    }
    
    // ------------------------------------------------------------------------
    // Setting M2M simple parameter
    DMA_Base_Init(&DMATestPattern);
    
	
    
    return;
}



void InitSPI0(void)
{  
   
	PIN_InitTypeDef PINX_InitStruct;
	
	//===Set CSC init====
	//MG32x02z_CSC_Init.h(Configuration Wizard)
	//Select CK_HS source = CK_IHRCO
	//Select IHRCO = 12Mz
	//Select CK_MAIN Source = CK_HS
	//Configure PLL->Select APB Prescaler = CK_MAIN/1

	/*=== 1. Enable CSC to SPI clock ===*/
	//[A] When Use Wizard
	//Configure Peripheral On Mode Clock->SPI0 = Enable and Select SPI0_PR Source = CK_APB
	//Configure Peripheral On Mode Clock->Port B = Enable
	//[B] When Use Driver
	//	  UnProtectModuleReg(CSCprotect);							  // Unprotect CSC module
	//	  CSC_PeriphOnModeClock_Config(CSC_ON_SPI0, ENABLE);		  // Enable SPI0 module clock
	//	  CSC_PeriphOnModeClock_Config(CSC_ON_PortB, ENABLE);		  // Enable PortB clock
	//	  CSC_PeriphProcessClockSource_Config(CSC_SPI0_CKS, CK_APB);  // CK_SPIx_PR = CK_APB = 12MHz
	//	  ProtectModuleReg(CSCprotect); 							  // protect CSC module

	/*=== 2. Default Initial SPI ===*/
	SPI_DeInit(SPI0);

	/*=== 3. Configure clock divider ===*/						// SPI clock = 1MHz
	SPI_Clock_Select(SPI0, SPI_CK_SPIx_PR); 					// CK_SPIx = CK_SPIx_PR
	SPI_PreDivider_Select(SPI0, SPI_PDIV_2);					// PDIV outpu = CK_SPIx /2
	SPI_Prescaler_Select(SPI0, SPI_PSC_3);						// Prescaler outpu = PDIV outpu /3
	SPI_Divider_Select(SPI0, SPI_DIV_2);						// DIV outpu = PDIV outpu /2

	/*=== 4. Configure SPI data line, mode and data size... ===*/
	SPI_DataLine_Select(SPI0, SPI_Standard);					// SPI data line Standard
	SPI_ModeAndNss_Select(SPI0, SPI_SlaveWithNss);				// Slave with NSS
	SPI_NSSInputSignal_Select(SPI0,SPI_NssPin);					// Nss
	SPI_ClockPhase_Select(SPI0, SPI_LeadingEdge);				// CPHA = 0
	SPI_ClockPolarity_Select(SPI0, SPI_Low);					// CPOL = 0
	SPI_FirstBit_Select(SPI0, SPI_MSB); 						// MSB first
	SPI_DataSize_Select(SPI0, SPI_8bits);						// Data size 8bits
	SPI_SlaveModeReceivedThreshold_Select(SPI0, SPI_1Byte);     // Set SPI0 received data buffer high threshold

	/*=== 5. Config SPI0 IO ===*/
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_Digital_I; 	 	// Pin select digital input mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	
	PINX_InitStruct.PINX_Alternate_Function  = PB0_AF_SPI0_NSS;				// Pin AFS = SPI0_NSS
	GPIO_PinMode_Config(PINB(0),&PINX_InitStruct); 					 		// NSS setup at PB0

	PINX_InitStruct.PINX_Alternate_Function  = PB2_AF_SPI0_CLK;		 		// Pin AFS = SPI0_CLK
	GPIO_PinMode_Config(PINB(2),&PINX_InitStruct); 					 		// CLK setup at PB2

	PINX_InitStruct.PINX_Alternate_Function  = PB3_AF_SPI0_MOSI;			// Pin AFS = SPI0_MOSI
	GPIO_PinMode_Config(PINB(3),&PINX_InitStruct); 					 		// MOSI setup at PB3

	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_Alternate_Function  = PB1_AF_SPI0_MISO;			// Pin AFS = SPI0_MISO
	GPIO_PinMode_Config(PINB(1),&PINX_InitStruct); 					 		// MISO setup at PB1


	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_Alternate_Function  = 0;						 	// Pin AFS = 0
	GPIO_PinMode_Config(PINE(13),&PINX_InitStruct); 					 	// PE13
	GPIO_PinMode_Config(PINE(14),&PINX_InitStruct); 					 	// PE14
	GPIO_PinMode_Config(PINE(15),&PINX_InitStruct); 					 	// PE15


	/*=== 6. Enable SPI ===*/
	SPI_Cmd(SPI0, ENABLE); 											 		// Enable SPI 

}



int main()
{
	u8 x,i;
	u32 dt;
	CSC_Init();
	URT0_Init();
	
	InitTick(48000000,0);
	NVIC_EnableIRQ(SysTick_IRQn);

	InitSPI0();	
	InitDMA0();
	
	printf("Hello!\n");

	x=0;
	dt=GetTick();

	SPI_DMAReceive_Cmd(SPI0, ENABLE);
	
	// ------------------------------------------------------------------------
	// 4.clear flag
	DMA_ClearFlag(DMA, DMA_FLAG_CH0_TCF);
	
	// ------------------------------------------------------------------------
	// 5.start request
	DMA_StartRequest(DMAChannel0);
	

	while(1)
    {

		if((GetTick()-dt)>=100)
		{
			PE15=!PE15;
			dt=GetTick();
		}
		if(DMA_GetSingleFlagStatus(DMA, DMA_FLAG_CH0_TCF) == DRV_Happened)
		{
			DMA_ClearFlag(DMA, DMA_FLAG_CH0_TCF);
			for(x=0;x<DATA_LENGTH;x++)
			{
				if(TestBuf[x]!=x) break;
			}
			if(x<DATA_LENGTH)
			{
				PE14=0;
				printf("RX Fail!\n");

				for(i=0;i<DATA_LENGTH;i++)
				{
					printf("0x%X ",TestBuf[i]);
				}
				printf("\n");
				SPI_ClearFlag(SPI0, SPI_ALLF);										// Clear flag
				//InitSPI0();
				PE14=1;
			}
			else
			{
				PE13=0;
				printf("RX OK! \n");
				PE13=1;
			}
			for(x=0;x<DATA_LENGTH;x++)
			{
				TestBuf[x]=0xFF;
			}
			while(PB0==0);
			
			SPI_DMAReceive_Cmd(SPI0, ENABLE);

			// ------------------------------------------------------------------------
			// 4.clear flag
			DMA_ClearFlag(DMA, DMA_FLAG_CH0_TCF|DMA_FLAG_CH0_ERRF);
			
			// ------------------------------------------------------------------------
			// 5.start request
			DMA_StartRequest(DMAChannel0);
		}
    }
}




















