

/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32x02z demo main c Code. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2017/07/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 */

#include "MG32x02z_DRV.H"
#include <stdio.h>

#define URTX URT0

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

typedef struct
{
        I2C_Struct         *Instance;
        uint32_t            CK_I2C_PR_Frequency;
        uint32_t            SCL_Clock;
}I2C_InitTypeDef;

typedef struct{
    __IO I2C_Struct                 *Instance;
    __IO uint8_t                    *pData;
    __IO Sample_I2C_StateTypeDef    State;
    __IO Sample_I2C_ControlTypeDef  Control;
    __IO uint16_t                   Count;
    __IO uint8_t                    SlaveAddress;
}I2C_HandleTypeDef;


#define DATA_LENGTH          20
uint8_t TestBuf[DATA_LENGTH] __attribute__((at(0x20001000)));

#define Dummy_Data 	0xFFFFFFFF

#define SPI_NSS 	PB0     // SPI_NSS

void SysTick_Handler(void)
{
    //to do......
	IncTick();
}


void CSC_Init (void)
{
	CSC_PLL_TyprDef CSC_PLL_CFG;
    
	
    UnProtectModuleReg(MEMprotect);     	// Setting flash wait state
    MEM_SetFlashWaitState(MEM_FWAIT_ONE);	// 50MHz> Sysclk >=25MHz
    ProtectModuleReg(MEMprotect);

    UnProtectModuleReg(CSCprotect);
	CSC_CK_APB_Divider_Select(APB_DIV_1);	// Modify CK_APB divider	APB=CK_MAIN/1
	CSC_CK_AHB_Divider_Select(AHB_DIV_1);	// Modify CK_AHB divider	AHB=APB/1

	
	/* CK_HS selection */
	CSC_IHRCO_Select(IHRCO_12MHz);			// IHRCO Sel 12MHz
	CSC_IHRCO_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_IHRCOF) == DRV_Normal);
	CSC_ClearFlag(CSC_IHRCOF);
	CSC_CK_HS_Select(HS_CK_IHRCO);			// CK_HS select IHRCO


	/* PLL */
	/**********************************************************/
	CSC_PLL_CFG.InputDivider=PLLI_DIV_2;	// 12M/2=6M
	CSC_PLL_CFG.Multiplication=PLLIx16;		// 6M*16=96M
	CSC_PLL_CFG.OutputDivider=PLLO_DIV_2;	// PLLO=96M/2=48M
	CSC_PLL_Config(&CSC_PLL_CFG);
	CSC_PLL_Cmd(ENABLE);
	while(CSC_GetSingleFlagStatus(CSC_PLLF) == DRV_Normal);
	CSC_ClearFlag(CSC_PLLF);
	/**********************************************************/

	
	/* CK_MAIN */ 
	CSC_CK_MAIN_Select(MAIN_CK_PLLO);	


	/* Configure ICKO function */
		
	/* Configure peripheral clock */
	CSC_PeriphProcessClockSource_Config(CSC_UART0_CKS, CK_APB);
 	CSC_PeriphOnModeClock_Config(CSC_ON_UART0,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortB,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortC,ENABLE);
 	CSC_PeriphOnModeClock_Config(CSC_ON_PortE,ENABLE);
	
	CSC_PeriphProcessClockSource_Config(CSC_SPI0_CKS, CK_APB);
	CSC_PeriphOnModeClock_Config(CSC_ON_I2C0, ENABLE);					  // Enable IIC0 module clock

 	CSC_PeriphOnModeClock_Config(CSC_ON_DMA,ENABLE);
	

    ProtectModuleReg(CSCprotect);
    
}


int fputc(int ch,FILE *f)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
	return ch;
}

void UartSendByte(int ch)
{
	
	URT_SetTXData(URTX,1,ch);
	while(URT_GetITSingleFlagStatus(URTX,URT_IT_TC)==DRV_UnHappened);
	URT_ClearITFlag(URTX,URT_IT_TC);
	
}


void URT0_Init(void)
{
    URT_BRG_TypeDef  URT_BRG;
    URT_Data_TypeDef DataDef;
	PIN_InitTypeDef PINX_InitStruct;
    
	//==Set GPIO init
	//PB8 PPO TX ,PB9 ODO RX
	PINX_InitStruct.PINX_Mode				 = PINX_Mode_PushPull_O; 	 	// Pin select Push Pull mode
	PINX_InitStruct.PINX_PUResistant		 = PINX_PUResistant_Enable;  	// Enable pull up resistor
	PINX_InitStruct.PINX_Speed 			 	 = PINX_Speed_Low;			 
	PINX_InitStruct.PINX_OUTDrive			 = PINX_OUTDrive_Level0;	 	// Pin output driver full strength.
	PINX_InitStruct.PINX_FilterDivider 	 	 = PINX_FilterDivider_Bypass;	// Pin input deglitch filter clock divider bypass
	PINX_InitStruct.PINX_Inverse			 = PINX_Inverse_Disable;	 	// Pin input data not inverse
	PINX_InitStruct.PINX_Alternate_Function  = PB8_AF_URT0_TX;				// Pin AFS = URT0_TX
	GPIO_PinMode_Config(PINB(8),&PINX_InitStruct); 					 		// TXD at PB8

	PINX_InitStruct.PINX_Mode				 = PINX_Mode_OpenDrain_O; 		// Pin select Open Drain mode
	PINX_InitStruct.PINX_Alternate_Function  = PB9_AF_URT0_RX;				// Pin AFS = URT0_RX
	GPIO_PinMode_Config(PINB(9),&PINX_InitStruct); 					 		// RXD at PB9

    
    //=====Set Clock=====//
    //---Set BaudRate---//
    URT_BRG.URT_InteranlClockSource = URT_BDClock_PROC;
    URT_BRG.URT_BaudRateMode = URT_BDMode_Separated;
    URT_BRG.URT_PrescalerCounterReload = 0;	                	//Set PSR
    URT_BRG.URT_BaudRateCounterReload = 12;	                	//Set RLR
    URT_BaudRateGenerator_Config(URTX, &URT_BRG);		    	//BR115200 = f(CK_URTx)/(PSR+1)/(RLR+1)/(OS_NUM+1)
    URT_BaudRateGenerator_Cmd(URTX, ENABLE);	            	//Enable BaudRateGenerator
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX, URT_TXClock_Internal);		//URT_TX use BaudRateGenerator
    URT_RXClockSource_Select(URTX, URT_RXClock_Internal);		//URT_RX use BaudRateGenerator
    URT_TXOverSamplingSampleNumber_Select(URTX, 31);	        //Set TX OS_NUM
    URT_RXOverSamplingSampleNumber_Select(URTX, 31);	        //Set RX OS_NUM
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_3TIME);
    URT_TX_Cmd(URTX, ENABLE);	                            	//Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                            	//Enable RX
    
    

    //=====Set Mode=====//
    //---Set Data character config---//
    DataDef.URT_TX_DataLength  = URT_DataLength_8;
    DataDef.URT_RX_DataLength  = URT_DataLength_8;
    DataDef.URT_TX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_RX_DataOrder   = URT_DataTyped_LSB;
    DataDef.URT_TX_Parity      = URT_Parity_No;
    DataDef.URT_RX_Parity      = URT_Parity_No;
    DataDef.URT_TX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_RX_StopBits    = URT_StopBits_1_0;
    DataDef.URT_TX_DataInverse = DISABLE;
    DataDef.URT_RX_DataInverse = DISABLE;
    URT_DataCharacter_Config(URTX, &DataDef);
    //---Set Mode Select---//
    URT_Mode_Select(URTX, URT_URT_mode);
    //---Set DataLine Select---//
    URT_DataLine_Select(URTX, URT_DataLine_2);
    
    //=====Set Error Control=====//
    // to do...
    
    //=====Set Bus Status Detect Control=====//
    // to do...
    
    //=====Set Data Control=====//
    URT_RXShadowBufferThreshold_Select(URTX, URT_RXTH_1BYTE);
    URT_IdlehandleMode_Select(URTX, URT_IDLEMode_No);
    URT_TXGaudTime_Select(URTX, 0);
    
    //=====Enable URT Interrupt=====//
    //URT_IT_Cmd(URTX, URT_IT_RX, ENABLE);
    //URT_ITEA_Cmd(URTX, ENABLE);
    //NVIC_EnableIRQ(URT0_IRQn);

    //=====Enable URT=====//
    URT_Cmd(URTX, ENABLE);
		
	//==See MG32x02z_URT0_IRQ.c when interrupt in
}

void InitDMA0(void)
{  
    // make sure :
    // Enable DMA clock from CSC macro (reference MG32x02z_CSC_Init.h file)
    
    DMA_BaseInitTypeDef DMATestPattern;

    // ------------------------------------------------------------------------
    // 1.Enable DMA
    DMA_Cmd(ENABLE);
    
    // ------------------------------------------------------------------------
    // 2.Enable Channel0
    DMA_Channel_Cmd(DMAChannel0, ENABLE);
    
    // ------------------------------------------------------------------------
    DMA_BaseInitStructure_Init(&DMATestPattern);
    
    // 3.initial & modify parameter
    {   
        // DMA channel select
        DMATestPattern.DMAChx = DMAChannel0;
        
        // channel x source/destination auto increase address
        DMATestPattern.SrcSINCSel = DISABLE;
        DMATestPattern.DestDINCSel = ENABLE;
        
        // DMA source peripheral config
        DMATestPattern.SrcSymSel = DMA_SPI0_RX;
        
        // DMA destination peripheral config
        DMATestPattern.DestSymSel = DMA_MEM_Wrtie;
        
        // DMA Burst size config
        DMATestPattern.BurstDataSize = DMA_BurstSize_1Byte;
        
        // DMA transfer data count initial number
        DMATestPattern.DMATransferNUM = DATA_LENGTH;
    
        // source/destination config
        DMATestPattern.DMASourceAddr = (uint8_t *)&SPI0->RDAT.B[0];
        DMATestPattern.DMADestinationAddr = (uint8_t *)&TestBuf;
    }
    
    // ------------------------------------------------------------------------
    // Setting M2M simple parameter
    DMA_Base_Init(&DMATestPattern);
    
	
    
    return;
}



DRV_Return I2C_Init(I2C_InitTypeDef *SI2C)
{
//    PIN_InitTypeDef PINX_InitStruct;
    uint16_t lI2C_Pre = 1;
    uint16_t lI2C_DIV = 1;
    uint16_t lI2C_HT_LT = 0;
    uint16_t lI2C_LT;
    uint16_t lI2C_HT;
    
	PIN_InitTypeDef PINX_InitStruct;

    //===== Check I2C Busy =====//
    if(__I2C_GetFlagStatus(SI2C->Instance, I2C_FLAG_BUSYF))
        return DRV_Busy;

    __I2C_Disable(SI2C->Instance);

      //===== GPIO Config =====//
    PINX_InitStruct.PINX_Mode	            = PINX_Mode_OpenDrain_O;            // Pin select pusu pull mode
    PINX_InitStruct.PINX_PUResistant        = PINX_PUResistant_Disable;         // Enable pull up resistor
    PINX_InitStruct.PINX_Speed              = PINX_Speed_High;           
    PINX_InitStruct.PINX_OUTDrive           = PINX_OUTDrive_Level0;             // Pin output driver full strength.
    PINX_InitStruct.PINX_FilterDivider      = PINX_FilterDivider_Bypass;        // Pin input deglitch filter clock divider bypass
    PINX_InitStruct.PINX_Inverse            = PINX_Inverse_Disable;             // Pin input data not inverse
    PINX_InitStruct.PINX_Alternate_Function = 2;               					// Pin AFS = 2

    if(sI2C->Instance == I2C0)
    {
        GPIO_PinMode_Config(PINB(10),&PINX_InitStruct);                         // I2C0 SCL setup at PB10
        GPIO_PinMode_Config(PINB(11),&PINX_InitStruct);                         // I2C0 SDA setup at PB11

////        GPIO_PinMode_Config(PINC(4),&PINX_InitStruct);                          // I2C0 SCL setup at PC4
////        GPIO_PinMode_Config(PINC(5),&PINX_InitStruct);                          // I2C0 SDA setup at PC5

////        GPIO_PinMode_Config(PINC(8),&PINX_InitStruct);                          // I2C0 SCL setup at PC8
////        GPIO_PinMode_Config(PINC(9),&PINX_InitStruct);                          // I2C0 SDA setup at PC9

////        GPIO_PinMode_Config(PIND(5),&PINX_InitStruct);                          // I2C0 SCL setup at PD5
////        GPIO_PinMode_Config(PIND(6),&PINX_InitStruct);                          // I2C0 SDA setup at PD6

////        GPIO_PinMode_Config(PINE(0),&PINX_InitStruct);                          // I2C0 SCL setup at PE0
////        GPIO_PinMode_Config(PINE(1),&PINX_InitStruct);                          // I2C0 SDA setup at PE1
    }

    if(sI2C->Instance == I2C1)
    {
        GPIO_PinMode_Config(PINC(10),&PINX_InitStruct);                         // I2C1 SCL setup at PC10
        GPIO_PinMode_Config(PINC(11),&PINX_InitStruct);                         // I2C1 SDA setup at PC11

////        GPIO_PinMode_Config(PIND(8),&PINX_InitStruct);                          // I2C1 SCL setup at PD8
////        GPIO_PinMode_Config(PIND(9),&PINX_InitStruct);                          // I2C1 SDA setup at PD9

////        GPIO_PinMode_Config(PINE(2),&PINX_InitStruct);                          // I2C1 SCL setup at PE2
////        GPIO_PinMode_Config(PINE(3),&PINX_InitStruct);                          // I2C1 SDA setup at PE3
    }


      //=== I2C Config ===//
    //===== I2C Output Clock Config =====//
    // CK_I2C_PR
    // SCL Output Clock
    // HT + LT, <= 32 >=9, CK_I2C_PR / SCL Clock / Prescaler / DIV

    do{
        lI2C_HT_LT = SI2C->CK_I2C_PR_Frequency / SI2C->SCL_Clock / lI2C_Pre / lI2C_DIV;
        if((lI2C_HT_LT >= 32) || (lI2C_HT_LT <=9)) 
        {
            lI2C_Pre ++;
            if(lI2C_Pre > 8)
            {
                lI2C_Pre = 1;
                lI2C_DIV ++;
            }
        }
    }while((lI2C_HT_LT >= 32) || (lI2C_HT_LT <=9));

    lI2C_LT = (lI2C_HT_LT >> 1);
    lI2C_HT = lI2C_HT_LT - lI2C_LT;

    __I2C_SetClockSource(SI2C->Instance, I2C_CLK_SRC_PROC);
    __I2C_SetClockPrescaler(SI2C->Instance, lI2C_Pre - 1);
    __I2C_SetClockDivider(SI2C->Instance, lI2C_DIV - 1);
    __I2C_SetSCLHighTime(SI2C->Instance, lI2C_HT - 1);
    __I2C_SetSCLLowTime(SI2C->Instance, lI2C_HT - 1);

    //===== I2C Opration Mode Config =====//
    __I2C_GeneralCallAddress_Disable(SI2C->Instance);
    __I2C_SlaveAddressDetect_Disable(SI2C->Instance, (I2C_SADR_1 | I2C_SADR_2));
    
    //===== I2C Interrupt Config =====//
    if(SI2C->Instance == I2C0)
    {
        NVIC_EnableIRQ(I2C0_IRQn);
        NVIC_SetPriority(I2C0_IRQn, 1);                                         // Suggest SYSTICK Priority = 0
                                                                                //           Other Priority > 0
    }

    if(SI2C->Instance == I2C1)
    {
        NVIC_EnableIRQ(I2Cx_IRQn);
        NVIC_SetPriority(I2Cx_IRQn, 1);                                         // Suggest SYSTICK Priority = 0
                                                                                //           Other Priority > 0
    }

    __I2C_ITEA_Disable(SI2C->Instance);
    __I2C_IT_Disable(SI2C->Instance, (I2C_IT_TMOUT | I2C_IT_EVENT | I2C_IT_ERR | I2C_IT_BUF | I2C_IT_WUP));

    //===== I2C Timeout Config =====//
    __I2C_TMO_Disable(SI2C->Instance);
    __I2C_SetTimeOutClockSource(SI2C->Instance, I2C_TMO_CKS_DIV64);
    __I2C_SetTimeOutDetectionMode(SI2C->Instance, I2C_TMO_MDS_GENERAL);
    __I2C_SetTimeOutCount(SI2C->Instance, I2C_TMO_MDS_GENERAL);

    //===== I2C Enable =====//
    __I2C_Enable(SI2C->Instance);
    return DRV_Success;
}


void InitIIC0(void)
{  
    I2C_InitTypeDef SI2C0_Init;
	SI2C0_Init.Instance = I2C0;
	SI2C0_Init.CK_I2C_PR_Frequency = 12000000;
	SI2C0_Init.SCL_Clock = 400000;	  
	I2C_Init(&SI2C0_Init);

	

}

void I2C_Handle(I2C_HandleTypeDef *Sample_I2C)
{
    uint8_t lState;

    if(__I2C_GetStateFlag(Sample_I2C->Instance) == 0)
        return;

    lState = __I2C_GetStatusCode(Sample_I2C->Instance);
    switch(lState){
        case 0x00:  // Bus Error 
            Sample_I2C->State.W |= Sample_I2C_State_BusError | \
                                   Sample_I2C_State_Done;;
            break;

        case 0x08:  // SLA+W sent and ACK received 
        case 0x10:  // Repeated start condition
            Set_STA_STO_AA_000(Sample_I2C->Instance);
            __I2C_SendSBUF(Sample_I2C->Instance, ((uint8_t)Sample_I2C->SlaveAddress));
            break;

        case 0x18:  // MT SLA+W sent and ACK received
        case 0x28:  // MT DATA sent and ACK received
            if(Sample_I2C->Count == 0)
            {
                Set_STA_STO_AA_010(Sample_I2C->Instance);
                __I2C_ClearStateFlag(Sample_I2C->Instance);
                while(__I2C_GetStatusCode(Sample_I2C->Instance) == lState);
                lState = __I2C_GetStatusCode(Sample_I2C->Instance);
                Sample_I2C->State.W |= Sample_I2C_State_Done;
                return;
            }
            __I2C_SendSBUF(Sample_I2C->Instance, ((uint8_t)*Sample_I2C->pData));
            Sample_I2C->pData ++;
            Sample_I2C->Count --;
            break;

        case 0x20:  // MT SLA+W sent NACK received 
        case 0x30:  // MT DATA sent NACK received
        case 0x48:  // MR SLA+R sent NACK received
            Set_STA_STO_AA_010(Sample_I2C->Instance);
            __I2C_ClearStateFlag(Sample_I2C->Instance);
            while(__I2C_GetStatusCode(Sample_I2C->Instance) == lState);
            lState = __I2C_GetStatusCode(Sample_I2C->Instance);
            Sample_I2C->State.W |= Sample_I2C_State_NACK | \
                                   Sample_I2C_State_Done;
            return;

        case 0x38:  // Arbitration lost
            Set_STA_STO_AA_000(Sample_I2C->Instance);
            Sample_I2C->State.W |= Sample_I2C_State_ArbitrationLost | \
                                   Sample_I2C_State_Done;
            break;

        case 0x40:  // SLA+R sent and ACK received
            Set_STA_STO_AA_001(Sample_I2C->Instance);
        case 0x50:  // Data Received and ACK sent
            if(Sample_I2C->Count <= 1)
                Set_STA_STO_AA_000(Sample_I2C->Instance);
            *Sample_I2C->pData = __I2C_ReceiveSBUF(Sample_I2C->Instance);
            Sample_I2C->Count--;
            Sample_I2C->pData++;
            break;

        case 0x58:  // Data Received and NACK sent
            if((Sample_I2C->Control.W & Sample_I2C_XferNext_Mask) == Sample_I2C_XferNext_RepeatStart)
                Set_STA_STO_AA_100(Sample_I2C->Instance);
            else
                Set_STA_STO_AA_010(Sample_I2C->Instance);

            Sample_I2C->State.W |= Sample_I2C_State_Done;
            break;

//-------------------------------------
        case 0x60:  // Own SLA+W has bee Received ACK has been returned

        case 0x68:  // Arbitration lost in SLA+R/W as master,
                    // Own SLA+W has been Received ACK has bee returned

        case 0x70:  // General Call address has been received ACK has been returned

        case 0x78:  // Arbitration lost in SLA+R/W as master,
                    // General Call address has been received ACK has been returned

        case 0x80:  // Data byte has been received ACK has been return

        case 0x88:  // Data byte has been received Not ACK has been return

        case 0x90:  // Previously address with General Call address
                    // Data byte has been received ACK has been return

        case 0x98:  // Previously address with General Call address
                    // Data byte has been received Not ACK has been return

        case 0xA0:  // A STOP or repeated START has been received while will addressed as SLV/REC

        case 0xA8:  // Own SLA+R has bee Received ACK has been returned

        case 0xB0:  // Arbitration lost in SLA+R/W as master,
                    // Own SLA+R has been Received ACK has bee returned

        case 0xB8:  // Data byte in SIDAT has been transmitted ACK has been received

        case 0xC0:  // Data byte or Last data byte in SIDAT has been transmitted Not ACK has been received

        case 0xC8:  // Last Data byte in SIDAT has been transmitted ACK has been received

        case 0xD0: 
        case 0xD8:
        case 0xE0:
        case 0xE8:
        case 0xF0:
                    
        case 0xF8:  // Bus Idle

        default:
            break;
    }
    __I2C_ClearStateFlag(Sample_I2C->Instance);
    while(__I2C_GetStateFlag(Sample_I2C->Instance) != 0);
}


u8 I2CReadByte(I2C_HandleTypeDef *SI2C,u8 DevAddr,u8 RegAddr)
{
	u8 x,i;

	PE13= 0;

	Set_STA_STO_AA_100(SI2C->Instance);
	SICON |= STA;				// START
	SICON &=~SI;			
	while((SICON&SI)!=SI);		// ȴ
	SICON &=~STA;

	SIDAT = DevAddr&0xFE;		// ַ 
	SICON &=~SI;
	while((SICON&SI)!=SI);

	SIDAT = RegAddr;			// ͵ַ
	SICON &=~SI;
	while((SICON&SI)!=SI);

	SICON |= STA;				// ٴηSTART
	SICON &=~SI;			
	while((SICON&SI)!=SI);		// ȴ
	SICON &=~STA;

	SIDAT = DevAddr|0x01;		// ַ ,ģʽ
	SICON &=~SI;			
	while((SICON&SI)!=SI);		// ȴ

	
	SICON=SICON&(~AA);	   
	SICON &=~SI;			
	while((SICON&SI)!=SI);		// ȴ
	x = SIDAT; 					// ȡ


	SICON |= STO;				// STOP
	SICON &=~SI;
	while((SICON&STO)==STO);
	SICON &=~STO;

	SICON = SICON &(~SI);		// жϱ־

	P25=1;
	
	return x;
}


int main()
{
	u8 x,i;
	u32 dt;
	CSC_Init();
	URT0_Init();
	
	InitTick(48000000,0);
	NVIC_EnableIRQ(SysTick_IRQn);

	InitIIC0();	
	
	printf("Hello!\n");

	x=0;
	dt=GetTick();


	while(1)
    {

		Delay(100);
		PE15=!PE15;

		
		
    }
}




















