/**
 ******************************************************************************
 *
 * @file        MG32x02z_DMA.h
 *
 * @brief       MG32x02z DMA Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_DMA_H
#define _MG32x02z_DMA_H
#define _MG32x02z_DMA_H_VER                         3.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z_DMA_H_VER)
    #error "MG32x02z_DMA_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      DMA_Struct
 *              DMA  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  CH0_GIF       :1;     //[0] DMA channel-0 global interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_TCF       :1;     //[1] DMA channel-0 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_THF       :1;     //[2] DMA channel-0 transfer half flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_ERRF      :1;     //[3] DMA channel-0 transfer error flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t  CH1_GIF       :1;     //[4] DMA channel-1 global interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH1_TCF       :1;     //[5] DMA channel-1 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH1_THF       :1;     //[6] DMA channel-1 transfer half flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH1_ERRF      :1;     //[7] DMA channel-1 transfer error flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t  CH2_GIF       :1;     //[8] DMA channel-2 global interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH2_TCF       :1;     //[9] DMA channel-2 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH2_THF       :1;     //[10] DMA channel-2 transfer half flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH2_ERRF      :1;     //[11] DMA channel-2 transfer error flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :15;    //[30..16] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  DMA status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] DMA interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :15;    //[30..16] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  DMA interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] DMA controller enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  PRI_MDS       :1;     //[1] DMA channel priority mode select.
                                        //0 = Round : control by Round Robin method
                                        //1 = Level : control by channel priority level
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  GPL_CHS       :2;     //[5..4] DMA channel select for extra GPL function
                                        //0x0 = Disable : no any channel with GPL function
                                        //0x1 = CH0
                                        //0x2 = CH1
                                        //0x3 = CH2
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  CH0_ENB       :1;     //[16] DMA channel-0 operation enable bit. This bit is as same as DMA_CH0_EN.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_ENB       :1;     //[17] DMA channel-0 operation enable bit. This bit is as same as DMA_CH1_EN.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_ENB       :1;     //[18] DMA channel-0 operation enable bit. This bit is as same as DMA_CH2_EN.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  DMA global control register 0 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  MAIN_STA      :3;     //[2..0] DMA main state machine status for debug only.
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t  CH_STA        :3;     //[6..4] DMA channel state machine status for debug only.
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t  SEL_CH0       :1;     //[8] DMA channel select channel-0 status for debug only.
            __I  uint8_t  SEL_CH1       :1;     //[9] DMA channel select channel-1 status for debug only.
            __I  uint8_t  SEL_CH2       :1;     //[10] DMA channel select channel-2 status for debug only.
            __I  uint8_t                :5;     //[15..11] 
            __I  uint8_t  XMDS_CH0      :3;     //[18..16] DMA channel-0 XMDA control status for debug only.
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t  XMDS_CH1      :3;     //[22..20] DMA channel-1 XMDA control status for debug only.
            __I  uint8_t                :1;     //[23] 
            __I  uint8_t  XMDS_CH2      :3;     //[26..24] DMA channel-2 XMDA control status for debug only.
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  DMA global control register 2 */

    __I uint32_t  RESERVED2;            /*!< RESERVED2  ~ Offset[0x1C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH0_EN        :1;     //[0] DMA channel operation enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_HOLD      :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_LOOP      :1;     //[2] DMA loop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_ADSEL     :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CH0_XMDS      :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __IO uint8_t  CH0_PLS       :2;     //[11..10] DMA channel priority level select.
                                        //0x0 = LV0 : lowest priority
                                        //0x1 = LV1 : normal priority
                                        //0x2 = LV2 : high priority
                                        //0x3 = LV3 : highest priority
            __IO uint8_t  CH0_BSIZE     :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  CH0_REQ       :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CH0_CIE       :1;     //[17] DMA channel-0 transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_HIE       :1;     //[18] DMA channel-0 transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_EIE       :1;     //[19] DMA channel-0 transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  CH0_TC2F      :1;     //[25] DMA channel-0 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_TH2F      :1;     //[26] DMA channel-0 transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_ERR2F     :1;     //[27] DMA channel-0 transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CH0A;                              /*!< CH0A       ~ Offset[0x20]  DMA channel-0 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH0_SRC       :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CH0_DET       :4;     //[11..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  CH0_SINC      :1;     //[16] DMA source memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_DINC      :1;     //[17] DMA destination memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_SSYNC     :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_DSYNC     :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  CH0_XPIN      :1;     //[24] DMA channel external trigger pin select.
                                        //0x0 = TRG0 : DMA_TRG0 pin
                                        //0x1 = TRG1 : DMA_TRG1 pin
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }CH0B;                              /*!< CH0B       ~ Offset[0x24]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CH0_NUM       :16;    //[15..0] DMA transfer data count initial number
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH0NUM;                            /*!< CH0NUM     ~ Offset[0x28]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CH0_CNT       :16;    //[15..0] DMA transfer data count current value
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH0CNT;                            /*!< CH0CNT     ~ Offset[0x2C]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH0_SSA       :32;    //[31..0] DMA source memory transfer start address.
        }MBIT;
    }CH0SSA;                            /*!< CH0SSA     ~ Offset[0x30]  DMA channel-0 source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH0_SCA       :32;    //[31..0] DMA source memory transfer current address
        }MBIT;
    }CH0SCA;                            /*!< CH0SCA     ~ Offset[0x34]  DMA channel-0 source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH0_DSA       :32;    //[31..0] DMA destination memory transfer start address.
        }MBIT;
    }CH0DSA;                            /*!< CH0DSA     ~ Offset[0x38]  DMA channel-0 destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH0_DCA       :32;    //[31..0] DMA destination memory transfer current address
        }MBIT;
    }CH0DCA;                            /*!< CH0DCA     ~ Offset[0x3C]  DMA channel-0 destination current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH1_EN        :1;     //[0] DMA channel operation enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_HOLD      :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_LOOP      :1;     //[2] DMA loop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_ADSEL     :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CH1_XMDS      :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __IO uint8_t  CH1_PLS       :2;     //[11..10] DMA channel priority level select.
                                        //0x0 = LV0 : lowest priority
                                        //0x1 = LV1 : normal priority
                                        //0x2 = LV2 : high priority
                                        //0x3 = LV3 : highest priority
            __IO uint8_t  CH1_BSIZE     :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  CH1_REQ       :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CH1_CIE       :1;     //[17] DMA channel-1 transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_HIE       :1;     //[18] DMA channel-1 transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_EIE       :1;     //[19] DMA channel-1 transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  CH1_TC2F      :1;     //[25] DMA channel-1 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH1_TH2F      :1;     //[26] DMA channel-1 transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH1_ERR2F     :1;     //[27] DMA channel-1 transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CH1A;                              /*!< CH1A       ~ Offset[0x40]  DMA channel-1 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH1_SRC       :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CH1_DET       :4;     //[11..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  CH1_SINC      :1;     //[16] DMA source memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_DINC      :1;     //[17] DMA destination memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_SSYNC     :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH1_DSYNC     :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  CH1_XPIN      :1;     //[24] DMA channel external trigger pin select.
                                        //0x0 = TRG0 : DMA_TRG0 pin
                                        //0x1 = TRG1 : DMA_TRG1 pin
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }CH1B;                              /*!< CH1B       ~ Offset[0x44]  DMA channel-1 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CH1_NUM       :16;    //[15..0] DMA transfer data count initial number
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH1NUM;                            /*!< CH1NUM     ~ Offset[0x48]  DMA channel-1 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CH1_CNT       :16;    //[15..0] DMA transfer data count current value
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH1CNT;                            /*!< CH1CNT     ~ Offset[0x4C]  DMA channel-1 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH1_SSA       :32;    //[31..0] DMA source memory transfer start address.
        }MBIT;
    }CH1SSA;                            /*!< CH1SSA     ~ Offset[0x50]  DMA channel-1 source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH1_SCA       :32;    //[31..0] DMA source memory transfer current address
        }MBIT;
    }CH1SCA;                            /*!< CH1SCA     ~ Offset[0x54]  DMA channel-1 source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH1_DSA       :32;    //[31..0] DMA destination memory transfer start address.
        }MBIT;
    }CH1DSA;                            /*!< CH1DSA     ~ Offset[0x58]  DMA channel-1 destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH1_DCA       :32;    //[31..0] DMA destination memory transfer current address
        }MBIT;
    }CH1DCA;                            /*!< CH1DCA     ~ Offset[0x5C]  DMA channel-1 destination current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH2_EN        :1;     //[0] DMA channel operation enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_HOLD      :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_LOOP      :1;     //[2] DMA loop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_ADSEL     :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CH2_XMDS      :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __IO uint8_t  CH2_PLS       :2;     //[11..10] DMA channel priority level select.
                                        //0x0 = LV0 : lowest priority
                                        //0x1 = LV1 : normal priority
                                        //0x2 = LV2 : high priority
                                        //0x3 = LV3 : highest priority
            __IO uint8_t  CH2_BSIZE     :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  CH2_REQ       :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CH2_CIE       :1;     //[17] DMA channel-2 transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_HIE       :1;     //[18] DMA channel-2 transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_EIE       :1;     //[19] DMA channel-2 transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  CH2_TC2F      :1;     //[25] DMA channel-2 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH2_TH2F      :1;     //[26] DMA channel-2 transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH2_ERR2F     :1;     //[27] DMA channel-2 transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CH2A;                              /*!< CH2A       ~ Offset[0x60]  DMA channel-2 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH2_SRC       :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CH2_DET       :4;     //[11..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  CH2_SINC      :1;     //[16] DMA source memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_DINC      :1;     //[17] DMA destination memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_SSYNC     :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH2_DSYNC     :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __IO uint8_t  CH2_XPIN      :1;     //[24] DMA channel external trigger pin select.
                                        //0x0 = TRG0 : DMA_TRG0 pin
                                        //0x1 = TRG1 : DMA_TRG1 pin
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }CH2B;                              /*!< CH2B       ~ Offset[0x64]  DMA channel-2 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CH2_NUM       :16;    //[15..0] DMA transfer data count initial number
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH2NUM;                            /*!< CH2NUM     ~ Offset[0x68]  DMA channel-2 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CH2_CNT       :16;    //[15..0] DMA transfer data count current value
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH2CNT;                            /*!< CH2CNT     ~ Offset[0x6C]  DMA channel-2 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH2_SSA       :32;    //[31..0] DMA source memory transfer start address.
        }MBIT;
    }CH2SSA;                            /*!< CH2SSA     ~ Offset[0x70]  DMA channel-2 source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH2_SCA       :32;    //[31..0] DMA source memory transfer current address
        }MBIT;
    }CH2SCA;                            /*!< CH2SCA     ~ Offset[0x74]  DMA channel-2 source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH2_DSA       :32;    //[31..0] DMA destination memory transfer start address.
        }MBIT;
    }CH2DSA;                            /*!< CH2DSA     ~ Offset[0x78]  DMA channel-2 destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH2_DCA       :32;    //[31..0] DMA destination memory transfer current address
        }MBIT;
    }CH2DCA;                            /*!< CH2DCA     ~ Offset[0x7C]  DMA channel-2 destination current address register */

} DMA_Struct;

/**
 ******************************************************************************
 *
 * @name        DMA  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define DMA_Base                        ((uint32_t)0x4BF00000)              /*!< Direct Memory Access Control */
#define DMA                             ((DMA_Struct*) DMA_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        DMA  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        DMA_STA  [register's definitions]
 *              Offset[0x00]  DMA status register (0x4BF00000)
 ******************************************************************************
 */
///@{
#define DMA_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_STA */
#define DMA_STA_CH2_ERRF_mask_w                     ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH2_ERRF_mask_h0                    ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH2_ERRF_mask_b1                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH2_ERRF_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH2_ERRF_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH2_ERRF_normal_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH2_ERRF_happened_w                 ((uint32_t)0x00000800)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH2_ERRF_happened_h0                ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH2_ERRF_happened_b1                ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH2_THF_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH2_THF_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH2_THF_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH2_THF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH2_THF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH2_THF_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH2_THF_happened_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH2_THF_happened_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH2_THF_happened_b1                 ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH2_TCF_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH2_TCF_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH2_TCF_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH2_TCF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH2_TCF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH2_TCF_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH2_TCF_happened_w                  ((uint32_t)0x00000200)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH2_TCF_happened_h0                 ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH2_TCF_happened_b1                 ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH2_GIF_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH2_GIF_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH2_GIF_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH2_GIF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH2_GIF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH2_GIF_normal_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH2_GIF_happened_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH2_GIF_happened_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH2_GIF_happened_b1                 ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH1_ERRF_mask_w                     ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH1_ERRF_mask_h0                    ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH1_ERRF_mask_b0                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH1_ERRF_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH1_ERRF_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH1_ERRF_normal_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH1_ERRF_happened_w                 ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH1_ERRF_happened_h0                ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH1_ERRF_happened_b0                ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH1_THF_mask_w                      ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH1_THF_mask_h0                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH1_THF_mask_b0                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH1_THF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH1_THF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH1_THF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH1_THF_happened_w                  ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH1_THF_happened_h0                 ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH1_THF_happened_b0                 ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH1_TCF_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH1_TCF_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH1_TCF_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH1_TCF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH1_TCF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH1_TCF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH1_TCF_happened_w                  ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH1_TCF_happened_h0                 ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH1_TCF_happened_b0                 ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH1_GIF_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH1_GIF_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH1_GIF_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH1_GIF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH1_GIF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH1_GIF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH1_GIF_happened_w                  ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH1_GIF_happened_h0                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH1_GIF_happened_b0                 ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_ERRF_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_ERRF_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_ERRF_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_ERRF_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_ERRF_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_ERRF_normal_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_ERRF_happened_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_ERRF_happened_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_ERRF_happened_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_THF_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_THF_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_THF_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_THF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_THF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_THF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_THF_happened_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_THF_happened_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_THF_happened_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_TCF_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_TCF_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_TCF_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_TCF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_TCF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_TCF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_TCF_happened_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_TCF_happened_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_TCF_happened_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_GIF_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_GIF_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_GIF_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_GIF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_GIF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_GIF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_GIF_happened_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_GIF_happened_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_GIF_happened_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_INT  [register's definitions]
 *              Offset[0x04]  DMA interrupt enable register (0x4BF00004)
 ******************************************************************************
 */
///@{
#define DMA_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_INT */
#define DMA_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CR0  [register's definitions]
 *              Offset[0x10]  DMA global control register 0 (0x4BF00010)
 ******************************************************************************
 */
///@{
#define DMA_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CR0 */
#define DMA_CR0_CH2_ENB_mask_w                      ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CR0_CH2_ENB_mask_h1                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CR0_CH2_ENB_mask_b2                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CR0_CH2_ENB_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_CH2_ENB_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_CH2_ENB_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_CH2_ENB_enable_w                    ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_CH2_ENB_enable_h1                   ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_CH2_ENB_enable_b2                   ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CR0_CH1_ENB_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CR0_CH1_ENB_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CR0_CH1_ENB_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CR0_CH1_ENB_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_CH1_ENB_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_CH1_ENB_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_CH1_ENB_enable_w                    ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_CH1_ENB_enable_h1                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_CH1_ENB_enable_b2                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CR0_CH0_ENB_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CR0_CH0_ENB_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CR0_CH0_ENB_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR0_CH0_ENB_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_CH0_ENB_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_CH0_ENB_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_CH0_ENB_enable_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_CH0_ENB_enable_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_CH0_ENB_enable_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CR0_GPL_CHS_mask_w                      ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define DMA_CR0_GPL_CHS_mask_h0                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define DMA_CR0_GPL_CHS_mask_b0                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CR0_GPL_CHS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CR0_GPL_CHS_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CR0_GPL_CHS_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CR0_GPL_CHS_ch0_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):CH0 of 32bit */
#define DMA_CR0_GPL_CHS_ch0_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):CH0 of 16bit */
#define DMA_CR0_GPL_CHS_ch0_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):CH0 of 8bit */
#define DMA_CR0_GPL_CHS_ch1_w                       ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):CH1 of 32bit */
#define DMA_CR0_GPL_CHS_ch1_h0                      ((uint16_t)0x0020)      /*!< Bit Value =(0x2):CH1 of 16bit */
#define DMA_CR0_GPL_CHS_ch1_b0                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):CH1 of 8bit */
#define DMA_CR0_GPL_CHS_ch2_w                       ((uint32_t)0x00000030)  /*!< Bit Value =(0x3):CH2 of 32bit */
#define DMA_CR0_GPL_CHS_ch2_h0                      ((uint16_t)0x0030)      /*!< Bit Value =(0x3):CH2 of 16bit */
#define DMA_CR0_GPL_CHS_ch2_b0                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):CH2 of 8bit */

#define DMA_CR0_PRI_MDS_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CR0_PRI_MDS_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CR0_PRI_MDS_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CR0_PRI_MDS_round_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Round of 32bit */
#define DMA_CR0_PRI_MDS_round_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Round of 16bit */
#define DMA_CR0_PRI_MDS_round_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Round of 8bit */
#define DMA_CR0_PRI_MDS_level_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Level of 32bit */
#define DMA_CR0_PRI_MDS_level_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Level of 16bit */
#define DMA_CR0_PRI_MDS_level_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Level of 8bit */

#define DMA_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CR2  [register's definitions]
 *              Offset[0x18]  DMA global control register 2 (0x4BF00018)
 ******************************************************************************
 */
///@{
#define DMA_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CR2 */
#define DMA_CR2_XMDS_CH2_mask_w                     ((uint32_t)0x07000000)  /*!< Bit Mask of 32bit */
#define DMA_CR2_XMDS_CH2_mask_h1                    ((uint16_t)0x0700)      /*!< Bit Mask of 16bit */
#define DMA_CR2_XMDS_CH2_mask_b3                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DMA_CR2_XMDS_CH2_shift_w                    (24)                    /*!< Bit Shift of 32bit */
#define DMA_CR2_XMDS_CH2_shift_h1                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_XMDS_CH2_shift_b3                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_XMDS_CH1_mask_w                     ((uint32_t)0x00700000)  /*!< Bit Mask of 32bit */
#define DMA_CR2_XMDS_CH1_mask_h1                    ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define DMA_CR2_XMDS_CH1_mask_b2                    ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define DMA_CR2_XMDS_CH1_shift_w                    (20)                    /*!< Bit Shift of 32bit */
#define DMA_CR2_XMDS_CH1_shift_h1                   (4)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_XMDS_CH1_shift_b2                   (4)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_XMDS_CH0_mask_w                     ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define DMA_CR2_XMDS_CH0_mask_h1                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define DMA_CR2_XMDS_CH0_mask_b2                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DMA_CR2_XMDS_CH0_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define DMA_CR2_XMDS_CH0_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_XMDS_CH0_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_SEL_CH2_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define DMA_CR2_SEL_CH2_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CR2_SEL_CH2_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CR2_SEL_CH2_shift_w                     (10)                    /*!< Bit Shift of 32bit */
#define DMA_CR2_SEL_CH2_shift_h0                    (10)                    /*!< Bit Shift of 16bit */
#define DMA_CR2_SEL_CH2_shift_b1                    (2)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_SEL_CH1_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define DMA_CR2_SEL_CH1_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CR2_SEL_CH1_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CR2_SEL_CH1_shift_w                     (9)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_SEL_CH1_shift_h0                    (9)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_SEL_CH1_shift_b1                    (1)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_SEL_CH0_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define DMA_CR2_SEL_CH0_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CR2_SEL_CH0_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR2_SEL_CH0_shift_w                     (8)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_SEL_CH0_shift_h0                    (8)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_SEL_CH0_shift_b1                    (0)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_CH_STA_mask_w                       ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define DMA_CR2_CH_STA_mask_h0                      ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define DMA_CR2_CH_STA_mask_b0                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define DMA_CR2_CH_STA_shift_w                      (4)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_CH_STA_shift_h0                     (4)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_CH_STA_shift_b0                     (4)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_MAIN_STA_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define DMA_CR2_MAIN_STA_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define DMA_CR2_MAIN_STA_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DMA_CR2_MAIN_STA_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_MAIN_STA_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_MAIN_STA_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0A  [register's definitions]
 *              Offset[0x20]  DMA channel-0 control register 0 (0x4BF00020)
 ******************************************************************************
 */
///@{
#define DMA_CH0A_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0A */
#define DMA_CH0A_CH0_ERR2F_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_ERR2F_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_ERR2F_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_ERR2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_ERR2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_ERR2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_ERR2F_happened_w               ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_ERR2F_happened_h1              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_ERR2F_happened_b3              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_TH2F_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_TH2F_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_TH2F_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_TH2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_TH2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_TH2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_TH2F_happened_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_TH2F_happened_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_TH2F_happened_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_TC2F_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_TC2F_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_TC2F_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_TC2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_TC2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_TC2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_TC2F_happened_w                ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_TC2F_happened_h1               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_TC2F_happened_b3               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_EIE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_EIE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_EIE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_EIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_EIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_EIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_EIE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_EIE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_EIE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_HIE_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_HIE_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_HIE_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_HIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_HIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_HIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_HIE_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_HIE_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_HIE_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_CIE_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_CIE_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_CIE_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_CIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_CIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_CIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_CIE_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_CIE_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_CIE_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_REQ_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_REQ_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_REQ_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_REQ_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define DMA_CH0A_CH0_REQ_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define DMA_CH0A_CH0_REQ_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define DMA_CH0A_CH0_REQ_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_REQ_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_REQ_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_BSIZE_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_BSIZE_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_BSIZE_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_BSIZE_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define DMA_CH0A_CH0_BSIZE_one_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define DMA_CH0A_CH0_BSIZE_one_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define DMA_CH0A_CH0_BSIZE_two_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Two of 32bit */
#define DMA_CH0A_CH0_BSIZE_two_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Two of 16bit */
#define DMA_CH0A_CH0_BSIZE_two_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):Two of 8bit */
#define DMA_CH0A_CH0_BSIZE_four_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Four of 32bit */
#define DMA_CH0A_CH0_BSIZE_four_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Four of 16bit */
#define DMA_CH0A_CH0_BSIZE_four_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):Four of 8bit */

#define DMA_CH0A_CH0_PLS_mask_w                     ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_PLS_mask_h0                    ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_PLS_mask_b1                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_PLS_lv0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LV0 of 32bit */
#define DMA_CH0A_CH0_PLS_lv0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LV0 of 16bit */
#define DMA_CH0A_CH0_PLS_lv0_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):LV0 of 8bit */
#define DMA_CH0A_CH0_PLS_lv1_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):LV1 of 32bit */
#define DMA_CH0A_CH0_PLS_lv1_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x1):LV1 of 16bit */
#define DMA_CH0A_CH0_PLS_lv1_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):LV1 of 8bit */
#define DMA_CH0A_CH0_PLS_lv2_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):LV2 of 32bit */
#define DMA_CH0A_CH0_PLS_lv2_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):LV2 of 16bit */
#define DMA_CH0A_CH0_PLS_lv2_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):LV2 of 8bit */
#define DMA_CH0A_CH0_PLS_lv3_w                      ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):LV3 of 32bit */
#define DMA_CH0A_CH0_PLS_lv3_h0                     ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):LV3 of 16bit */
#define DMA_CH0A_CH0_PLS_lv3_b1                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):LV3 of 8bit */

#define DMA_CH0A_CH0_XMDS_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_XMDS_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_XMDS_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_XMDS_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CH0A_CH0_XMDS_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CH0A_CH0_XMDS_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CH0A_CH0_XMDS_single_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Single of 32bit */
#define DMA_CH0A_CH0_XMDS_single_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Single of 16bit */
#define DMA_CH0A_CH0_XMDS_single_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):Single of 8bit */
#define DMA_CH0A_CH0_XMDS_block_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Block of 32bit */
#define DMA_CH0A_CH0_XMDS_block_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Block of 16bit */
#define DMA_CH0A_CH0_XMDS_block_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Block of 8bit */
#define DMA_CH0A_CH0_XMDS_demand_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Demand of 32bit */
#define DMA_CH0A_CH0_XMDS_demand_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Demand of 16bit */
#define DMA_CH0A_CH0_XMDS_demand_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):Demand of 8bit */

#define DMA_CH0A_CH0_ADSEL_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_ADSEL_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_ADSEL_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_ADSEL_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_ADSEL_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_ADSEL_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_ADSEL_skip3_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):SKIP3 of 32bit */
#define DMA_CH0A_CH0_ADSEL_skip3_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):SKIP3 of 16bit */
#define DMA_CH0A_CH0_ADSEL_skip3_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):SKIP3 of 8bit */

#define DMA_CH0A_CH0_LOOP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_LOOP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_LOOP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_LOOP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_LOOP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_LOOP_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_LOOP_enable_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_LOOP_enable_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_LOOP_enable_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_HOLD_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_HOLD_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_HOLD_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_HOLD_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_HOLD_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_HOLD_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_HOLD_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_HOLD_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_HOLD_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0B  [register's definitions]
 *              Offset[0x24]  DMA channel-0 control register 1 (0x4BF00024)
 ******************************************************************************
 */
///@{
#define DMA_CH0B_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0B */
#define DMA_CH0B_CH0_XPIN_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_XPIN_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_XPIN_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_XPIN_trg0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define DMA_CH0B_CH0_XPIN_trg0_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define DMA_CH0B_CH0_XPIN_trg0_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define DMA_CH0B_CH0_XPIN_trg1_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define DMA_CH0B_CH0_XPIN_trg1_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define DMA_CH0B_CH0_XPIN_trg1_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):TRG1 of 8bit */

#define DMA_CH0B_CH0_DSYNC_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DSYNC_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DSYNC_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_DSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_DSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_DSYNC_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_DSYNC_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_DSYNC_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_SSYNC_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SSYNC_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SSYNC_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_SSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_SSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_SSYNC_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_SSYNC_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_SSYNC_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_DINC_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DINC_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DINC_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_DINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_DINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_DINC_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_DINC_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_DINC_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_SINC_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SINC_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SINC_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_SINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_SINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_SINC_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_SINC_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_SINC_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_DET_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DET_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DET_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DET_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define DMA_CH0B_CH0_DET_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CH0B_CH0_DET_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CH0B_CH0_SRC_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SRC_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SRC_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SRC_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0B_CH0_SRC_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0B_CH0_SRC_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0NUM  [register's definitions]
 *              Offset[0x28]  DMA channel-0 control register 1 (0x4BF00028)
 ******************************************************************************
 */
///@{
#define DMA_CH0NUM_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0NUM */
#define DMA_CH0NUM_CH0_NUM_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0NUM_CH0_NUM_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH0NUM_CH0_NUM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0NUM_CH0_NUM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0NUM_CH0_NUM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0CNT  [register's definitions]
 *              Offset[0x2C]  DMA channel-0 control register 1 (0x4BF0002C)
 ******************************************************************************
 */
///@{
#define DMA_CH0CNT_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0CNT */
#define DMA_CH0CNT_CH0_CNT_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0CNT_CH0_CNT_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH0CNT_CH0_CNT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0CNT_CH0_CNT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0CNT_CH0_CNT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SSA  [register's definitions]
 *              Offset[0x30]  DMA channel-0 source start address register (0x4BF00030)
 ******************************************************************************
 */
///@{
#define DMA_CH0SSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0SSA */
#define DMA_CH0SSA_CH0_SSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0SSA_CH0_SSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0SSA_CH0_SSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0SSA_CH0_SSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SCA  [register's definitions]
 *              Offset[0x34]  DMA channel-0 source current address register (0x4BF00034)
 ******************************************************************************
 */
///@{
#define DMA_CH0SCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0SCA */
#define DMA_CH0SCA_CH0_SCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0SCA_CH0_SCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0SCA_CH0_SCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0SCA_CH0_SCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DSA  [register's definitions]
 *              Offset[0x38]  DMA channel-0 destination start address register (0x4BF00038)
 ******************************************************************************
 */
///@{
#define DMA_CH0DSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0DSA */
#define DMA_CH0DSA_CH0_DSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0DSA_CH0_DSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0DSA_CH0_DSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0DSA_CH0_DSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DCA  [register's definitions]
 *              Offset[0x3C]  DMA channel-0 destination current address register (0x4BF0003C)
 ******************************************************************************
 */
///@{
#define DMA_CH0DCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0DCA */
#define DMA_CH0DCA_CH0_DCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0DCA_CH0_DCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0DCA_CH0_DCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0DCA_CH0_DCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1A  [register's definitions]
 *              Offset[0x40]  DMA channel-1 control register 0 (0x4BF00040)
 ******************************************************************************
 */
///@{
#define DMA_CH1A_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1A */
#define DMA_CH1A_CH1_ERR2F_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_ERR2F_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_ERR2F_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_ERR2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH1A_CH1_ERR2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH1A_CH1_ERR2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH1A_CH1_ERR2F_happened_w               ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH1A_CH1_ERR2F_happened_h1              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH1A_CH1_ERR2F_happened_b3              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH1A_CH1_TH2F_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_TH2F_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_TH2F_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_TH2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH1A_CH1_TH2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH1A_CH1_TH2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH1A_CH1_TH2F_happened_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH1A_CH1_TH2F_happened_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH1A_CH1_TH2F_happened_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH1A_CH1_TC2F_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_TC2F_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_TC2F_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_TC2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH1A_CH1_TC2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH1A_CH1_TC2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH1A_CH1_TC2F_happened_w                ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH1A_CH1_TC2F_happened_h1               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH1A_CH1_TC2F_happened_b3               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH1A_CH1_EIE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_EIE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_EIE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_EIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_EIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_EIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_EIE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_EIE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_EIE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_HIE_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_HIE_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_HIE_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_HIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_HIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_HIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_HIE_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_HIE_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_HIE_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_CIE_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_CIE_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_CIE_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_CIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_CIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_CIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_CIE_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_CIE_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_CIE_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_REQ_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_REQ_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_REQ_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_REQ_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define DMA_CH1A_CH1_REQ_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define DMA_CH1A_CH1_REQ_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define DMA_CH1A_CH1_REQ_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_REQ_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_REQ_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_BSIZE_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_BSIZE_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_BSIZE_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_BSIZE_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define DMA_CH1A_CH1_BSIZE_one_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define DMA_CH1A_CH1_BSIZE_one_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define DMA_CH1A_CH1_BSIZE_two_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Two of 32bit */
#define DMA_CH1A_CH1_BSIZE_two_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Two of 16bit */
#define DMA_CH1A_CH1_BSIZE_two_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):Two of 8bit */
#define DMA_CH1A_CH1_BSIZE_four_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Four of 32bit */
#define DMA_CH1A_CH1_BSIZE_four_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Four of 16bit */
#define DMA_CH1A_CH1_BSIZE_four_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):Four of 8bit */

#define DMA_CH1A_CH1_PLS_mask_w                     ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_PLS_mask_h0                    ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_PLS_mask_b1                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_PLS_lv0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LV0 of 32bit */
#define DMA_CH1A_CH1_PLS_lv0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LV0 of 16bit */
#define DMA_CH1A_CH1_PLS_lv0_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):LV0 of 8bit */
#define DMA_CH1A_CH1_PLS_lv1_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):LV1 of 32bit */
#define DMA_CH1A_CH1_PLS_lv1_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x1):LV1 of 16bit */
#define DMA_CH1A_CH1_PLS_lv1_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):LV1 of 8bit */
#define DMA_CH1A_CH1_PLS_lv2_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):LV2 of 32bit */
#define DMA_CH1A_CH1_PLS_lv2_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):LV2 of 16bit */
#define DMA_CH1A_CH1_PLS_lv2_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):LV2 of 8bit */
#define DMA_CH1A_CH1_PLS_lv3_w                      ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):LV3 of 32bit */
#define DMA_CH1A_CH1_PLS_lv3_h0                     ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):LV3 of 16bit */
#define DMA_CH1A_CH1_PLS_lv3_b1                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):LV3 of 8bit */

#define DMA_CH1A_CH1_XMDS_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_XMDS_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_XMDS_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_XMDS_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CH1A_CH1_XMDS_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CH1A_CH1_XMDS_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CH1A_CH1_XMDS_single_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Single of 32bit */
#define DMA_CH1A_CH1_XMDS_single_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Single of 16bit */
#define DMA_CH1A_CH1_XMDS_single_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):Single of 8bit */
#define DMA_CH1A_CH1_XMDS_block_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Block of 32bit */
#define DMA_CH1A_CH1_XMDS_block_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Block of 16bit */
#define DMA_CH1A_CH1_XMDS_block_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Block of 8bit */
#define DMA_CH1A_CH1_XMDS_demand_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Demand of 32bit */
#define DMA_CH1A_CH1_XMDS_demand_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Demand of 16bit */
#define DMA_CH1A_CH1_XMDS_demand_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):Demand of 8bit */

#define DMA_CH1A_CH1_ADSEL_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_ADSEL_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_ADSEL_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_ADSEL_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH1A_CH1_ADSEL_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH1A_CH1_ADSEL_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH1A_CH1_ADSEL_skip3_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):SKIP3 of 32bit */
#define DMA_CH1A_CH1_ADSEL_skip3_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):SKIP3 of 16bit */
#define DMA_CH1A_CH1_ADSEL_skip3_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):SKIP3 of 8bit */

#define DMA_CH1A_CH1_LOOP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_LOOP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_LOOP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_LOOP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_LOOP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_LOOP_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_LOOP_enable_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_LOOP_enable_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_LOOP_enable_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_HOLD_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_HOLD_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_HOLD_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_HOLD_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_HOLD_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_HOLD_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_HOLD_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_HOLD_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_HOLD_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1A_CH1_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CH1A_CH1_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH1A_CH1_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH1A_CH1_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1A_CH1_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1A_CH1_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1A_CH1_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1A_CH1_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1A_CH1_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1B  [register's definitions]
 *              Offset[0x44]  DMA channel-1 control register 1 (0x4BF00044)
 ******************************************************************************
 */
///@{
#define DMA_CH1B_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1B */
#define DMA_CH1B_CH1_XPIN_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_XPIN_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_XPIN_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_XPIN_trg0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define DMA_CH1B_CH1_XPIN_trg0_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define DMA_CH1B_CH1_XPIN_trg0_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define DMA_CH1B_CH1_XPIN_trg1_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define DMA_CH1B_CH1_XPIN_trg1_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define DMA_CH1B_CH1_XPIN_trg1_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):TRG1 of 8bit */

#define DMA_CH1B_CH1_DSYNC_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_DSYNC_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_DSYNC_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_DSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1B_CH1_DSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1B_CH1_DSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1B_CH1_DSYNC_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1B_CH1_DSYNC_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1B_CH1_DSYNC_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1B_CH1_SSYNC_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_SSYNC_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_SSYNC_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_SSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1B_CH1_SSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1B_CH1_SSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1B_CH1_SSYNC_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1B_CH1_SSYNC_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1B_CH1_SSYNC_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1B_CH1_DINC_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_DINC_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_DINC_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_DINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1B_CH1_DINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1B_CH1_DINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1B_CH1_DINC_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1B_CH1_DINC_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1B_CH1_DINC_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1B_CH1_SINC_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_SINC_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_SINC_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_SINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH1B_CH1_SINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH1B_CH1_SINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH1B_CH1_SINC_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH1B_CH1_SINC_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH1B_CH1_SINC_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH1B_CH1_DET_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_DET_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_DET_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_DET_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define DMA_CH1B_CH1_DET_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CH1B_CH1_DET_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CH1B_CH1_SRC_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define DMA_CH1B_CH1_SRC_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define DMA_CH1B_CH1_SRC_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH1B_CH1_SRC_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1B_CH1_SRC_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1B_CH1_SRC_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1NUM  [register's definitions]
 *              Offset[0x48]  DMA channel-1 control register 1 (0x4BF00048)
 ******************************************************************************
 */
///@{
#define DMA_CH1NUM_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1NUM */
#define DMA_CH1NUM_CH1_NUM_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1NUM_CH1_NUM_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH1NUM_CH1_NUM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1NUM_CH1_NUM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1NUM_CH1_NUM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1CNT  [register's definitions]
 *              Offset[0x4C]  DMA channel-1 control register 1 (0x4BF0004C)
 ******************************************************************************
 */
///@{
#define DMA_CH1CNT_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1CNT */
#define DMA_CH1CNT_CH1_CNT_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1CNT_CH1_CNT_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH1CNT_CH1_CNT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1CNT_CH1_CNT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1CNT_CH1_CNT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SSA  [register's definitions]
 *              Offset[0x50]  DMA channel-1 source start address register (0x4BF00050)
 ******************************************************************************
 */
///@{
#define DMA_CH1SSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1SSA */
#define DMA_CH1SSA_CH1_SSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1SSA_CH1_SSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1SSA_CH1_SSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1SSA_CH1_SSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SCA  [register's definitions]
 *              Offset[0x54]  DMA channel-1 source current address register (0x4BF00054)
 ******************************************************************************
 */
///@{
#define DMA_CH1SCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1SCA */
#define DMA_CH1SCA_CH1_SCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1SCA_CH1_SCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1SCA_CH1_SCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1SCA_CH1_SCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DSA  [register's definitions]
 *              Offset[0x58]  DMA channel-1 destination start address register (0x4BF00058)
 ******************************************************************************
 */
///@{
#define DMA_CH1DSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1DSA */
#define DMA_CH1DSA_CH1_DSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1DSA_CH1_DSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1DSA_CH1_DSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1DSA_CH1_DSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DCA  [register's definitions]
 *              Offset[0x5C]  DMA channel-1 destination current address register (0x4BF0005C)
 ******************************************************************************
 */
///@{
#define DMA_CH1DCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH1DCA */
#define DMA_CH1DCA_CH1_DCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH1DCA_CH1_DCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH1DCA_CH1_DCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH1DCA_CH1_DCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2A  [register's definitions]
 *              Offset[0x60]  DMA channel-2 control register 0 (0x4BF00060)
 ******************************************************************************
 */
///@{
#define DMA_CH2A_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2A */
#define DMA_CH2A_CH2_ERR2F_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_ERR2F_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_ERR2F_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_ERR2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH2A_CH2_ERR2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH2A_CH2_ERR2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH2A_CH2_ERR2F_happened_w               ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH2A_CH2_ERR2F_happened_h1              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH2A_CH2_ERR2F_happened_b3              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH2A_CH2_TH2F_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_TH2F_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_TH2F_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_TH2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH2A_CH2_TH2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH2A_CH2_TH2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH2A_CH2_TH2F_happened_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH2A_CH2_TH2F_happened_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH2A_CH2_TH2F_happened_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH2A_CH2_TC2F_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_TC2F_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_TC2F_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_TC2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH2A_CH2_TC2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH2A_CH2_TC2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH2A_CH2_TC2F_happened_w                ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH2A_CH2_TC2F_happened_h1               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH2A_CH2_TC2F_happened_b3               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH2A_CH2_EIE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_EIE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_EIE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_EIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_EIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_EIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_EIE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_EIE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_EIE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_HIE_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_HIE_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_HIE_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_HIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_HIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_HIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_HIE_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_HIE_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_HIE_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_CIE_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_CIE_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_CIE_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_CIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_CIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_CIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_CIE_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_CIE_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_CIE_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_REQ_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_REQ_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_REQ_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_REQ_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define DMA_CH2A_CH2_REQ_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define DMA_CH2A_CH2_REQ_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define DMA_CH2A_CH2_REQ_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_REQ_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_REQ_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_BSIZE_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_BSIZE_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_BSIZE_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_BSIZE_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define DMA_CH2A_CH2_BSIZE_one_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define DMA_CH2A_CH2_BSIZE_one_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define DMA_CH2A_CH2_BSIZE_two_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Two of 32bit */
#define DMA_CH2A_CH2_BSIZE_two_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Two of 16bit */
#define DMA_CH2A_CH2_BSIZE_two_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):Two of 8bit */
#define DMA_CH2A_CH2_BSIZE_four_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Four of 32bit */
#define DMA_CH2A_CH2_BSIZE_four_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Four of 16bit */
#define DMA_CH2A_CH2_BSIZE_four_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):Four of 8bit */

#define DMA_CH2A_CH2_PLS_mask_w                     ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_PLS_mask_h0                    ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_PLS_mask_b1                    ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_PLS_lv0_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):LV0 of 32bit */
#define DMA_CH2A_CH2_PLS_lv0_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0x0):LV0 of 16bit */
#define DMA_CH2A_CH2_PLS_lv0_b1                     ((uint8_t )0x00)        /*!< Bit Value =(0x0):LV0 of 8bit */
#define DMA_CH2A_CH2_PLS_lv1_w                      ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):LV1 of 32bit */
#define DMA_CH2A_CH2_PLS_lv1_h0                     ((uint16_t)0x0400)      /*!< Bit Value =(0x1):LV1 of 16bit */
#define DMA_CH2A_CH2_PLS_lv1_b1                     ((uint8_t )0x04)        /*!< Bit Value =(0x1):LV1 of 8bit */
#define DMA_CH2A_CH2_PLS_lv2_w                      ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):LV2 of 32bit */
#define DMA_CH2A_CH2_PLS_lv2_h0                     ((uint16_t)0x0800)      /*!< Bit Value =(0x2):LV2 of 16bit */
#define DMA_CH2A_CH2_PLS_lv2_b1                     ((uint8_t )0x08)        /*!< Bit Value =(0x2):LV2 of 8bit */
#define DMA_CH2A_CH2_PLS_lv3_w                      ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):LV3 of 32bit */
#define DMA_CH2A_CH2_PLS_lv3_h0                     ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):LV3 of 16bit */
#define DMA_CH2A_CH2_PLS_lv3_b1                     ((uint8_t )0x0C)        /*!< Bit Value =(0x3):LV3 of 8bit */

#define DMA_CH2A_CH2_XMDS_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_XMDS_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_XMDS_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_XMDS_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CH2A_CH2_XMDS_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CH2A_CH2_XMDS_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CH2A_CH2_XMDS_single_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Single of 32bit */
#define DMA_CH2A_CH2_XMDS_single_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Single of 16bit */
#define DMA_CH2A_CH2_XMDS_single_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):Single of 8bit */
#define DMA_CH2A_CH2_XMDS_block_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Block of 32bit */
#define DMA_CH2A_CH2_XMDS_block_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Block of 16bit */
#define DMA_CH2A_CH2_XMDS_block_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Block of 8bit */
#define DMA_CH2A_CH2_XMDS_demand_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Demand of 32bit */
#define DMA_CH2A_CH2_XMDS_demand_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Demand of 16bit */
#define DMA_CH2A_CH2_XMDS_demand_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):Demand of 8bit */

#define DMA_CH2A_CH2_ADSEL_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_ADSEL_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_ADSEL_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_ADSEL_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH2A_CH2_ADSEL_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH2A_CH2_ADSEL_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH2A_CH2_ADSEL_skip3_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):SKIP3 of 32bit */
#define DMA_CH2A_CH2_ADSEL_skip3_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):SKIP3 of 16bit */
#define DMA_CH2A_CH2_ADSEL_skip3_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):SKIP3 of 8bit */

#define DMA_CH2A_CH2_LOOP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_LOOP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_LOOP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_LOOP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_LOOP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_LOOP_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_LOOP_enable_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_LOOP_enable_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_LOOP_enable_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_HOLD_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_HOLD_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_HOLD_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_HOLD_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_HOLD_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_HOLD_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_HOLD_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_HOLD_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_HOLD_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2A_CH2_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CH2A_CH2_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH2A_CH2_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH2A_CH2_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2A_CH2_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2A_CH2_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2A_CH2_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2A_CH2_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2A_CH2_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2B  [register's definitions]
 *              Offset[0x64]  DMA channel-2 control register 1 (0x4BF00064)
 ******************************************************************************
 */
///@{
#define DMA_CH2B_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2B */
#define DMA_CH2B_CH2_XPIN_mask_w                    ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_XPIN_mask_h1                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_XPIN_mask_b3                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_XPIN_trg0_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TRG0 of 32bit */
#define DMA_CH2B_CH2_XPIN_trg0_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TRG0 of 16bit */
#define DMA_CH2B_CH2_XPIN_trg0_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):TRG0 of 8bit */
#define DMA_CH2B_CH2_XPIN_trg1_w                    ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):TRG1 of 32bit */
#define DMA_CH2B_CH2_XPIN_trg1_h1                   ((uint16_t)0x0100)      /*!< Bit Value =(0x1):TRG1 of 16bit */
#define DMA_CH2B_CH2_XPIN_trg1_b3                   ((uint8_t )0x01)        /*!< Bit Value =(0x1):TRG1 of 8bit */

#define DMA_CH2B_CH2_DSYNC_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_DSYNC_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_DSYNC_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_DSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2B_CH2_DSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2B_CH2_DSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2B_CH2_DSYNC_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2B_CH2_DSYNC_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2B_CH2_DSYNC_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2B_CH2_SSYNC_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_SSYNC_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_SSYNC_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_SSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2B_CH2_SSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2B_CH2_SSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2B_CH2_SSYNC_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2B_CH2_SSYNC_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2B_CH2_SSYNC_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2B_CH2_DINC_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_DINC_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_DINC_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_DINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2B_CH2_DINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2B_CH2_DINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2B_CH2_DINC_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2B_CH2_DINC_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2B_CH2_DINC_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2B_CH2_SINC_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_SINC_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_SINC_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_SINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH2B_CH2_SINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH2B_CH2_SINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH2B_CH2_SINC_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH2B_CH2_SINC_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH2B_CH2_SINC_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH2B_CH2_DET_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_DET_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_DET_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_DET_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define DMA_CH2B_CH2_DET_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CH2B_CH2_DET_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CH2B_CH2_SRC_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define DMA_CH2B_CH2_SRC_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define DMA_CH2B_CH2_SRC_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH2B_CH2_SRC_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2B_CH2_SRC_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2B_CH2_SRC_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2NUM  [register's definitions]
 *              Offset[0x68]  DMA channel-2 control register 1 (0x4BF00068)
 ******************************************************************************
 */
///@{
#define DMA_CH2NUM_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2NUM */
#define DMA_CH2NUM_CH2_NUM_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2NUM_CH2_NUM_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH2NUM_CH2_NUM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2NUM_CH2_NUM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2NUM_CH2_NUM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2CNT  [register's definitions]
 *              Offset[0x6C]  DMA channel-2 control register 1 (0x4BF0006C)
 ******************************************************************************
 */
///@{
#define DMA_CH2CNT_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2CNT */
#define DMA_CH2CNT_CH2_CNT_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2CNT_CH2_CNT_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH2CNT_CH2_CNT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2CNT_CH2_CNT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2CNT_CH2_CNT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SSA  [register's definitions]
 *              Offset[0x70]  DMA channel-2 source start address register (0x4BF00070)
 ******************************************************************************
 */
///@{
#define DMA_CH2SSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2SSA */
#define DMA_CH2SSA_CH2_SSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2SSA_CH2_SSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2SSA_CH2_SSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2SSA_CH2_SSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SCA  [register's definitions]
 *              Offset[0x74]  DMA channel-2 source current address register (0x4BF00074)
 ******************************************************************************
 */
///@{
#define DMA_CH2SCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2SCA */
#define DMA_CH2SCA_CH2_SCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2SCA_CH2_SCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2SCA_CH2_SCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2SCA_CH2_SCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DSA  [register's definitions]
 *              Offset[0x78]  DMA channel-2 destination start address register (0x4BF00078)
 ******************************************************************************
 */
///@{
#define DMA_CH2DSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2DSA */
#define DMA_CH2DSA_CH2_DSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2DSA_CH2_DSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2DSA_CH2_DSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2DSA_CH2_DSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DCA  [register's definitions]
 *              Offset[0x7C]  DMA channel-2 destination current address register (0x4BF0007C)
 ******************************************************************************
 */
///@{
#define DMA_CH2DCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH2DCA */
#define DMA_CH2DCA_CH2_DCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH2DCA_CH2_DCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH2DCA_CH2_DCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH2DCA_CH2_DCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32x02z_DMA_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_DMA.h                         */
/*----------------------------------------------------------------------------*/
