/**
 ******************************************************************************
 *
 * @file        MG32x02z__RegAddress.h
 *
 * @brief       MG32x02z Register Absolute Addressing Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z__RegAddress_H
#define _MG32x02z__RegAddress_H
#define _MG32x02z__RegAddress_H_VER                 3.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z__RegAddress_H_VER)
    #error "MG32x02z__RegAddress_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @name        [Register Absolute Address Definitions]
 *
 ******************************************************************************
 */

/*----------------------------------------------------------------------------*/
/* @module      IOP (GPIO Input/Output Register Control Definitions)          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PX_OUT  [register's definitions]
 *              Offset[0x00]  PX output data register (0x41000000)
 ******************************************************************************
 */
///@{
#define PA_OUT_w                                    ((uint32_t)0x41000000)  /*!< Reg Absolute Address */
#define PA_OUT_h0                                   ((uint32_t)0x41000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_OUT_h1                                   ((uint32_t)0x41000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_OUT_b0                                   ((uint32_t)0x41000000)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_OUT_b1                                   ((uint32_t)0x41000001)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_OUT_b2                                   ((uint32_t)0x41000002)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_OUT_b3                                   ((uint32_t)0x41000003)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_OUT_w                                    ((uint32_t)0x41000020)  /*!< Reg Absolute Address */
#define PB_OUT_h0                                   ((uint32_t)0x41000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_OUT_h1                                   ((uint32_t)0x41000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_OUT_b0                                   ((uint32_t)0x41000020)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_OUT_b1                                   ((uint32_t)0x41000021)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_OUT_b2                                   ((uint32_t)0x41000022)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_OUT_b3                                   ((uint32_t)0x41000023)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_OUT_w                                    ((uint32_t)0x41000040)  /*!< Reg Absolute Address */
#define PC_OUT_h0                                   ((uint32_t)0x41000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_OUT_h1                                   ((uint32_t)0x41000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_OUT_b0                                   ((uint32_t)0x41000040)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_OUT_b1                                   ((uint32_t)0x41000041)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_OUT_b2                                   ((uint32_t)0x41000042)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_OUT_b3                                   ((uint32_t)0x41000043)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_OUT_w                                    ((uint32_t)0x41000060)  /*!< Reg Absolute Address */
#define PD_OUT_h0                                   ((uint32_t)0x41000060)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_OUT_h1                                   ((uint32_t)0x41000062)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_OUT_b0                                   ((uint32_t)0x41000060)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_OUT_b1                                   ((uint32_t)0x41000061)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_OUT_b2                                   ((uint32_t)0x41000062)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_OUT_b3                                   ((uint32_t)0x41000063)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_OUT_w                                    ((uint32_t)0x41000080)  /*!< Reg Absolute Address */
#define PE_OUT_h0                                   ((uint32_t)0x41000080)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_OUT_h1                                   ((uint32_t)0x41000082)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_OUT_b0                                   ((uint32_t)0x41000080)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_OUT_b1                                   ((uint32_t)0x41000081)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_OUT_b2                                   ((uint32_t)0x41000082)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_OUT_b3                                   ((uint32_t)0x41000083)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_IN  [register's definitions]
 *              Offset[0x04]  PX input data register (0x41000004)
 ******************************************************************************
 */
///@{
#define PA_IN_w                                     ((uint32_t)0x41000004)  /*!< Reg Absolute Address */
#define PA_IN_h0                                    ((uint32_t)0x41000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_IN_h1                                    ((uint32_t)0x41000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_IN_b0                                    ((uint32_t)0x41000004)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_IN_b1                                    ((uint32_t)0x41000005)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_IN_b2                                    ((uint32_t)0x41000006)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_IN_b3                                    ((uint32_t)0x41000007)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_IN_w                                     ((uint32_t)0x41000024)  /*!< Reg Absolute Address */
#define PB_IN_h0                                    ((uint32_t)0x41000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_IN_h1                                    ((uint32_t)0x41000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_IN_b0                                    ((uint32_t)0x41000024)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_IN_b1                                    ((uint32_t)0x41000025)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_IN_b2                                    ((uint32_t)0x41000026)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_IN_b3                                    ((uint32_t)0x41000027)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_IN_w                                     ((uint32_t)0x41000044)  /*!< Reg Absolute Address */
#define PC_IN_h0                                    ((uint32_t)0x41000044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_IN_h1                                    ((uint32_t)0x41000046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_IN_b0                                    ((uint32_t)0x41000044)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_IN_b1                                    ((uint32_t)0x41000045)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_IN_b2                                    ((uint32_t)0x41000046)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_IN_b3                                    ((uint32_t)0x41000047)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_IN_w                                     ((uint32_t)0x41000064)  /*!< Reg Absolute Address */
#define PD_IN_h0                                    ((uint32_t)0x41000064)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_IN_h1                                    ((uint32_t)0x41000066)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_IN_b0                                    ((uint32_t)0x41000064)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_IN_b1                                    ((uint32_t)0x41000065)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_IN_b2                                    ((uint32_t)0x41000066)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_IN_b3                                    ((uint32_t)0x41000067)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_IN_w                                     ((uint32_t)0x41000084)  /*!< Reg Absolute Address */
#define PE_IN_h0                                    ((uint32_t)0x41000084)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_IN_h1                                    ((uint32_t)0x41000086)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_IN_b0                                    ((uint32_t)0x41000084)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_IN_b1                                    ((uint32_t)0x41000085)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_IN_b2                                    ((uint32_t)0x41000086)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_IN_b3                                    ((uint32_t)0x41000087)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_SC  [register's definitions]
 *              Offset[0x08]  PX port set / clear register (0x41000008)
 ******************************************************************************
 */
///@{
#define PA_SC_w                                     ((uint32_t)0x41000008)  /*!< Reg Absolute Address */
#define PA_SC_h0                                    ((uint32_t)0x41000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_SC_h1                                    ((uint32_t)0x4100000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_SC_b0                                    ((uint32_t)0x41000008)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_SC_b1                                    ((uint32_t)0x41000009)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_SC_b2                                    ((uint32_t)0x4100000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_SC_b3                                    ((uint32_t)0x4100000B)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_SC_w                                     ((uint32_t)0x41000028)  /*!< Reg Absolute Address */
#define PB_SC_h0                                    ((uint32_t)0x41000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_SC_h1                                    ((uint32_t)0x4100002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_SC_b0                                    ((uint32_t)0x41000028)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_SC_b1                                    ((uint32_t)0x41000029)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_SC_b2                                    ((uint32_t)0x4100002A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_SC_b3                                    ((uint32_t)0x4100002B)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_SC_w                                     ((uint32_t)0x41000048)  /*!< Reg Absolute Address */
#define PC_SC_h0                                    ((uint32_t)0x41000048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_SC_h1                                    ((uint32_t)0x4100004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_SC_b0                                    ((uint32_t)0x41000048)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_SC_b1                                    ((uint32_t)0x41000049)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_SC_b2                                    ((uint32_t)0x4100004A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_SC_b3                                    ((uint32_t)0x4100004B)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_SC_w                                     ((uint32_t)0x41000068)  /*!< Reg Absolute Address */
#define PD_SC_h0                                    ((uint32_t)0x41000068)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_SC_h1                                    ((uint32_t)0x4100006A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_SC_b0                                    ((uint32_t)0x41000068)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_SC_b1                                    ((uint32_t)0x41000069)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_SC_b2                                    ((uint32_t)0x4100006A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_SC_b3                                    ((uint32_t)0x4100006B)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_SC_w                                     ((uint32_t)0x41000088)  /*!< Reg Absolute Address */
#define PE_SC_h0                                    ((uint32_t)0x41000088)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_SC_h1                                    ((uint32_t)0x4100008A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_SC_b0                                    ((uint32_t)0x41000088)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_SC_b1                                    ((uint32_t)0x41000089)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_SC_b2                                    ((uint32_t)0x4100008A)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_SC_b3                                    ((uint32_t)0x4100008B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_SCR0  [register's definitions]
 *              Offset[0x10]  PX port set and clear register 0 (0x41000010)
 ******************************************************************************
 */
///@{
#define PA_SCR0_w                                   ((uint32_t)0x41000010)  /*!< Reg Absolute Address */
#define PA_SCR0_h0                                  ((uint32_t)0x41000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_SCR0_h1                                  ((uint32_t)0x41000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_SCR0_b0                                  ((uint32_t)0x41000010)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_SCR0_b1                                  ((uint32_t)0x41000011)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_SCR0_b2                                  ((uint32_t)0x41000012)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_SCR0_b3                                  ((uint32_t)0x41000013)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_SCR0_w                                   ((uint32_t)0x41000030)  /*!< Reg Absolute Address */
#define PB_SCR0_h0                                  ((uint32_t)0x41000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_SCR0_h1                                  ((uint32_t)0x41000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_SCR0_b0                                  ((uint32_t)0x41000030)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_SCR0_b1                                  ((uint32_t)0x41000031)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_SCR0_b2                                  ((uint32_t)0x41000032)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_SCR0_b3                                  ((uint32_t)0x41000033)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_SCR0_w                                   ((uint32_t)0x41000050)  /*!< Reg Absolute Address */
#define PC_SCR0_h0                                  ((uint32_t)0x41000050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_SCR0_h1                                  ((uint32_t)0x41000052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_SCR0_b0                                  ((uint32_t)0x41000050)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_SCR0_b1                                  ((uint32_t)0x41000051)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_SCR0_b2                                  ((uint32_t)0x41000052)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_SCR0_b3                                  ((uint32_t)0x41000053)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_SCR0_w                                   ((uint32_t)0x41000070)  /*!< Reg Absolute Address */
#define PD_SCR0_h0                                  ((uint32_t)0x41000070)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_SCR0_h1                                  ((uint32_t)0x41000072)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_SCR0_b0                                  ((uint32_t)0x41000070)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_SCR0_b1                                  ((uint32_t)0x41000071)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_SCR0_b2                                  ((uint32_t)0x41000072)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_SCR0_b3                                  ((uint32_t)0x41000073)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_SCR0_w                                   ((uint32_t)0x41000090)  /*!< Reg Absolute Address */
#define PE_SCR0_h0                                  ((uint32_t)0x41000090)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_SCR0_h1                                  ((uint32_t)0x41000092)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_SCR0_b0                                  ((uint32_t)0x41000090)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_SCR0_b1                                  ((uint32_t)0x41000091)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_SCR0_b2                                  ((uint32_t)0x41000092)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_SCR0_b3                                  ((uint32_t)0x41000093)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_SCR1  [register's definitions]
 *              Offset[0x14]  PX port set and clear register 1 (0x41000014)
 ******************************************************************************
 */
///@{
#define PA_SCR1_w                                   ((uint32_t)0x41000014)  /*!< Reg Absolute Address */
#define PA_SCR1_h0                                  ((uint32_t)0x41000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_SCR1_h1                                  ((uint32_t)0x41000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_SCR1_b0                                  ((uint32_t)0x41000014)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_SCR1_b1                                  ((uint32_t)0x41000015)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_SCR1_b2                                  ((uint32_t)0x41000016)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_SCR1_b3                                  ((uint32_t)0x41000017)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_SCR1_w                                   ((uint32_t)0x41000034)  /*!< Reg Absolute Address */
#define PB_SCR1_h0                                  ((uint32_t)0x41000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_SCR1_h1                                  ((uint32_t)0x41000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_SCR1_b0                                  ((uint32_t)0x41000034)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_SCR1_b1                                  ((uint32_t)0x41000035)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_SCR1_b2                                  ((uint32_t)0x41000036)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_SCR1_b3                                  ((uint32_t)0x41000037)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_SCR1_w                                   ((uint32_t)0x41000054)  /*!< Reg Absolute Address */
#define PC_SCR1_h0                                  ((uint32_t)0x41000054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_SCR1_h1                                  ((uint32_t)0x41000056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_SCR1_b0                                  ((uint32_t)0x41000054)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_SCR1_b1                                  ((uint32_t)0x41000055)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_SCR1_b2                                  ((uint32_t)0x41000056)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_SCR1_b3                                  ((uint32_t)0x41000057)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_SCR1_w                                   ((uint32_t)0x41000074)  /*!< Reg Absolute Address */
#define PD_SCR1_h0                                  ((uint32_t)0x41000074)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_SCR1_h1                                  ((uint32_t)0x41000076)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_SCR1_b0                                  ((uint32_t)0x41000074)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_SCR1_b1                                  ((uint32_t)0x41000075)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_SCR1_b2                                  ((uint32_t)0x41000076)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_SCR1_b3                                  ((uint32_t)0x41000077)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_SCR1_w                                   ((uint32_t)0x41000094)  /*!< Reg Absolute Address */
#define PE_SCR1_h0                                  ((uint32_t)0x41000094)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_SCR1_h1                                  ((uint32_t)0x41000096)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_SCR1_b0                                  ((uint32_t)0x41000094)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_SCR1_b1                                  ((uint32_t)0x41000095)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_SCR1_b2                                  ((uint32_t)0x41000096)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_SCR1_b3                                  ((uint32_t)0x41000097)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_SCR2  [register's definitions]
 *              Offset[0x18]  PX port set and clear register 2 (0x41000018)
 ******************************************************************************
 */
///@{
#define PA_SCR2_w                                   ((uint32_t)0x41000018)  /*!< Reg Absolute Address */
#define PA_SCR2_h0                                  ((uint32_t)0x41000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_SCR2_h1                                  ((uint32_t)0x4100001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_SCR2_b0                                  ((uint32_t)0x41000018)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_SCR2_b1                                  ((uint32_t)0x41000019)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_SCR2_b2                                  ((uint32_t)0x4100001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_SCR2_b3                                  ((uint32_t)0x4100001B)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_SCR2_w                                   ((uint32_t)0x41000038)  /*!< Reg Absolute Address */
#define PB_SCR2_h0                                  ((uint32_t)0x41000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_SCR2_h1                                  ((uint32_t)0x4100003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_SCR2_b0                                  ((uint32_t)0x41000038)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_SCR2_b1                                  ((uint32_t)0x41000039)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_SCR2_b2                                  ((uint32_t)0x4100003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_SCR2_b3                                  ((uint32_t)0x4100003B)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_SCR2_w                                   ((uint32_t)0x41000058)  /*!< Reg Absolute Address */
#define PC_SCR2_h0                                  ((uint32_t)0x41000058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_SCR2_h1                                  ((uint32_t)0x4100005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_SCR2_b0                                  ((uint32_t)0x41000058)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_SCR2_b1                                  ((uint32_t)0x41000059)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_SCR2_b2                                  ((uint32_t)0x4100005A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_SCR2_b3                                  ((uint32_t)0x4100005B)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_SCR2_w                                   ((uint32_t)0x41000078)  /*!< Reg Absolute Address */
#define PD_SCR2_h0                                  ((uint32_t)0x41000078)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_SCR2_h1                                  ((uint32_t)0x4100007A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_SCR2_b0                                  ((uint32_t)0x41000078)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_SCR2_b1                                  ((uint32_t)0x41000079)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_SCR2_b2                                  ((uint32_t)0x4100007A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_SCR2_b3                                  ((uint32_t)0x4100007B)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_SCR2_w                                   ((uint32_t)0x41000098)  /*!< Reg Absolute Address */
#define PE_SCR2_h0                                  ((uint32_t)0x41000098)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_SCR2_h1                                  ((uint32_t)0x4100009A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_SCR2_b0                                  ((uint32_t)0x41000098)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_SCR2_b1                                  ((uint32_t)0x41000099)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_SCR2_b2                                  ((uint32_t)0x4100009A)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_SCR2_b3                                  ((uint32_t)0x4100009B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PX_SCR3  [register's definitions]
 *              Offset[0x1C]  PX port set and clear register 3 (0x4100001C)
 ******************************************************************************
 */
///@{
#define PA_SCR3_w                                   ((uint32_t)0x4100001C)  /*!< Reg Absolute Address */
#define PA_SCR3_h0                                  ((uint32_t)0x4100001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_SCR3_h1                                  ((uint32_t)0x4100001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_SCR3_b0                                  ((uint32_t)0x4100001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_SCR3_b1                                  ((uint32_t)0x4100001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_SCR3_b2                                  ((uint32_t)0x4100001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_SCR3_b3                                  ((uint32_t)0x4100001F)  /*!< Reg Absolute Address of [Byte-3] */
#define PB_SCR3_w                                   ((uint32_t)0x4100003C)  /*!< Reg Absolute Address */
#define PB_SCR3_h0                                  ((uint32_t)0x4100003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_SCR3_h1                                  ((uint32_t)0x4100003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_SCR3_b0                                  ((uint32_t)0x4100003C)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_SCR3_b1                                  ((uint32_t)0x4100003D)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_SCR3_b2                                  ((uint32_t)0x4100003E)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_SCR3_b3                                  ((uint32_t)0x4100003F)  /*!< Reg Absolute Address of [Byte-3] */
#define PC_SCR3_w                                   ((uint32_t)0x4100005C)  /*!< Reg Absolute Address */
#define PC_SCR3_h0                                  ((uint32_t)0x4100005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_SCR3_h1                                  ((uint32_t)0x4100005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_SCR3_b0                                  ((uint32_t)0x4100005C)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_SCR3_b1                                  ((uint32_t)0x4100005D)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_SCR3_b2                                  ((uint32_t)0x4100005E)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_SCR3_b3                                  ((uint32_t)0x4100005F)  /*!< Reg Absolute Address of [Byte-3] */
#define PD_SCR3_w                                   ((uint32_t)0x4100007C)  /*!< Reg Absolute Address */
#define PD_SCR3_h0                                  ((uint32_t)0x4100007C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_SCR3_h1                                  ((uint32_t)0x4100007E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_SCR3_b0                                  ((uint32_t)0x4100007C)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_SCR3_b1                                  ((uint32_t)0x4100007D)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_SCR3_b2                                  ((uint32_t)0x4100007E)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_SCR3_b3                                  ((uint32_t)0x4100007F)  /*!< Reg Absolute Address of [Byte-3] */
#define PE_SCR3_w                                   ((uint32_t)0x4100009C)  /*!< Reg Absolute Address */
#define PE_SCR3_h0                                  ((uint32_t)0x4100009C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_SCR3_h1                                  ((uint32_t)0x4100009E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_SCR3_b0                                  ((uint32_t)0x4100009C)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_SCR3_b1                                  ((uint32_t)0x4100009D)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_SCR3_b2                                  ((uint32_t)0x4100009E)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_SCR3_b3                                  ((uint32_t)0x4100009F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PA (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PA_CR0  [register's definitions]
 *              Offset[0x00]  PA0 IO control register (0x44000000)
 ******************************************************************************
 */
///@{
#define PA_CR0_w                                    ((uint32_t)0x44000000)  /*!< Reg Absolute Address */
#define PA_CR0_h0                                   ((uint32_t)0x44000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR0_h1                                   ((uint32_t)0x44000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR0_b0                                   ((uint32_t)0x44000000)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR0_b1                                   ((uint32_t)0x44000001)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR0_b2                                   ((uint32_t)0x44000002)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR0_b3                                   ((uint32_t)0x44000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR1  [register's definitions]
 *              Offset[0x04]  PA1 IO control register (0x44000004)
 ******************************************************************************
 */
///@{
#define PA_CR1_w                                    ((uint32_t)0x44000004)  /*!< Reg Absolute Address */
#define PA_CR1_h0                                   ((uint32_t)0x44000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR1_h1                                   ((uint32_t)0x44000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR1_b0                                   ((uint32_t)0x44000004)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR1_b1                                   ((uint32_t)0x44000005)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR1_b2                                   ((uint32_t)0x44000006)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR1_b3                                   ((uint32_t)0x44000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR2  [register's definitions]
 *              Offset[0x08]  PA2 IO control register (0x44000008)
 ******************************************************************************
 */
///@{
#define PA_CR2_w                                    ((uint32_t)0x44000008)  /*!< Reg Absolute Address */
#define PA_CR2_h0                                   ((uint32_t)0x44000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR2_h1                                   ((uint32_t)0x4400000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR2_b0                                   ((uint32_t)0x44000008)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR2_b1                                   ((uint32_t)0x44000009)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR2_b2                                   ((uint32_t)0x4400000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR2_b3                                   ((uint32_t)0x4400000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR3  [register's definitions]
 *              Offset[0x0C]  PA3 IO control register (0x4400000C)
 ******************************************************************************
 */
///@{
#define PA_CR3_w                                    ((uint32_t)0x4400000C)  /*!< Reg Absolute Address */
#define PA_CR3_h0                                   ((uint32_t)0x4400000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR3_h1                                   ((uint32_t)0x4400000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR3_b0                                   ((uint32_t)0x4400000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR3_b1                                   ((uint32_t)0x4400000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR3_b2                                   ((uint32_t)0x4400000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR3_b3                                   ((uint32_t)0x4400000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR4  [register's definitions]
 *              Offset[0x10]  PA4 IO control register (0x44000010)
 ******************************************************************************
 */
///@{
#define PA_CR4_w                                    ((uint32_t)0x44000010)  /*!< Reg Absolute Address */
#define PA_CR4_h0                                   ((uint32_t)0x44000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR4_h1                                   ((uint32_t)0x44000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR4_b0                                   ((uint32_t)0x44000010)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR4_b1                                   ((uint32_t)0x44000011)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR4_b2                                   ((uint32_t)0x44000012)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR4_b3                                   ((uint32_t)0x44000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR5  [register's definitions]
 *              Offset[0x14]  PA5 IO control register (0x44000014)
 ******************************************************************************
 */
///@{
#define PA_CR5_w                                    ((uint32_t)0x44000014)  /*!< Reg Absolute Address */
#define PA_CR5_h0                                   ((uint32_t)0x44000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR5_h1                                   ((uint32_t)0x44000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR5_b0                                   ((uint32_t)0x44000014)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR5_b1                                   ((uint32_t)0x44000015)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR5_b2                                   ((uint32_t)0x44000016)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR5_b3                                   ((uint32_t)0x44000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR6  [register's definitions]
 *              Offset[0x18]  PA6 IO control register (0x44000018)
 ******************************************************************************
 */
///@{
#define PA_CR6_w                                    ((uint32_t)0x44000018)  /*!< Reg Absolute Address */
#define PA_CR6_h0                                   ((uint32_t)0x44000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR6_h1                                   ((uint32_t)0x4400001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR6_b0                                   ((uint32_t)0x44000018)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR6_b1                                   ((uint32_t)0x44000019)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR6_b2                                   ((uint32_t)0x4400001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR6_b3                                   ((uint32_t)0x4400001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR7  [register's definitions]
 *              Offset[0x1C]  PA7 IO control register (0x4400001C)
 ******************************************************************************
 */
///@{
#define PA_CR7_w                                    ((uint32_t)0x4400001C)  /*!< Reg Absolute Address */
#define PA_CR7_h0                                   ((uint32_t)0x4400001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR7_h1                                   ((uint32_t)0x4400001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR7_b0                                   ((uint32_t)0x4400001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR7_b1                                   ((uint32_t)0x4400001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR7_b2                                   ((uint32_t)0x4400001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR7_b3                                   ((uint32_t)0x4400001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR8  [register's definitions]
 *              Offset[0x20]  PA8 IO control register (0x44000020)
 ******************************************************************************
 */
///@{
#define PA_CR8_w                                    ((uint32_t)0x44000020)  /*!< Reg Absolute Address */
#define PA_CR8_h0                                   ((uint32_t)0x44000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR8_h1                                   ((uint32_t)0x44000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR8_b0                                   ((uint32_t)0x44000020)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR8_b1                                   ((uint32_t)0x44000021)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR8_b2                                   ((uint32_t)0x44000022)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR8_b3                                   ((uint32_t)0x44000023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR9  [register's definitions]
 *              Offset[0x24]  PA9 IO control register (0x44000024)
 ******************************************************************************
 */
///@{
#define PA_CR9_w                                    ((uint32_t)0x44000024)  /*!< Reg Absolute Address */
#define PA_CR9_h0                                   ((uint32_t)0x44000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR9_h1                                   ((uint32_t)0x44000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR9_b0                                   ((uint32_t)0x44000024)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR9_b1                                   ((uint32_t)0x44000025)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR9_b2                                   ((uint32_t)0x44000026)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR9_b3                                   ((uint32_t)0x44000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR10  [register's definitions]
 *              Offset[0x28]  PA10 IO control register (0x44000028)
 ******************************************************************************
 */
///@{
#define PA_CR10_w                                   ((uint32_t)0x44000028)  /*!< Reg Absolute Address */
#define PA_CR10_h0                                  ((uint32_t)0x44000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR10_h1                                  ((uint32_t)0x4400002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR10_b0                                  ((uint32_t)0x44000028)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR10_b1                                  ((uint32_t)0x44000029)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR10_b2                                  ((uint32_t)0x4400002A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR10_b3                                  ((uint32_t)0x4400002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR11  [register's definitions]
 *              Offset[0x2C]  PA11 IO control register (0x4400002C)
 ******************************************************************************
 */
///@{
#define PA_CR11_w                                   ((uint32_t)0x4400002C)  /*!< Reg Absolute Address */
#define PA_CR11_h0                                  ((uint32_t)0x4400002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR11_h1                                  ((uint32_t)0x4400002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR11_b0                                  ((uint32_t)0x4400002C)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR11_b1                                  ((uint32_t)0x4400002D)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR11_b2                                  ((uint32_t)0x4400002E)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR11_b3                                  ((uint32_t)0x4400002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR12  [register's definitions]
 *              Offset[0x30]  PA12 IO control register (0x44000030)
 ******************************************************************************
 */
///@{
#define PA_CR12_w                                   ((uint32_t)0x44000030)  /*!< Reg Absolute Address */
#define PA_CR12_h0                                  ((uint32_t)0x44000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR12_h1                                  ((uint32_t)0x44000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR12_b0                                  ((uint32_t)0x44000030)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR12_b1                                  ((uint32_t)0x44000031)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR12_b2                                  ((uint32_t)0x44000032)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR12_b3                                  ((uint32_t)0x44000033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR13  [register's definitions]
 *              Offset[0x34]  PA13 IO control register (0x44000034)
 ******************************************************************************
 */
///@{
#define PA_CR13_w                                   ((uint32_t)0x44000034)  /*!< Reg Absolute Address */
#define PA_CR13_h0                                  ((uint32_t)0x44000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR13_h1                                  ((uint32_t)0x44000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR13_b0                                  ((uint32_t)0x44000034)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR13_b1                                  ((uint32_t)0x44000035)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR13_b2                                  ((uint32_t)0x44000036)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR13_b3                                  ((uint32_t)0x44000037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR14  [register's definitions]
 *              Offset[0x38]  PA14 IO control register (0x44000038)
 ******************************************************************************
 */
///@{
#define PA_CR14_w                                   ((uint32_t)0x44000038)  /*!< Reg Absolute Address */
#define PA_CR14_h0                                  ((uint32_t)0x44000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR14_h1                                  ((uint32_t)0x4400003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR14_b0                                  ((uint32_t)0x44000038)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR14_b1                                  ((uint32_t)0x44000039)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR14_b2                                  ((uint32_t)0x4400003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR14_b3                                  ((uint32_t)0x4400003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_CR15  [register's definitions]
 *              Offset[0x3C]  PA15 IO control register (0x4400003C)
 ******************************************************************************
 */
///@{
#define PA_CR15_w                                   ((uint32_t)0x4400003C)  /*!< Reg Absolute Address */
#define PA_CR15_h0                                  ((uint32_t)0x4400003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_CR15_h1                                  ((uint32_t)0x4400003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_CR15_b0                                  ((uint32_t)0x4400003C)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_CR15_b1                                  ((uint32_t)0x4400003D)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_CR15_b2                                  ((uint32_t)0x4400003E)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_CR15_b3                                  ((uint32_t)0x4400003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PA_FLT  [register's definitions]
 *              Offset[0x40]  PA port input filter control register (0x44000040)
 ******************************************************************************
 */
///@{
#define PA_FLT_w                                    ((uint32_t)0x44000040)  /*!< Reg Absolute Address */
#define PA_FLT_h0                                   ((uint32_t)0x44000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PA_FLT_h1                                   ((uint32_t)0x44000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PA_FLT_b0                                   ((uint32_t)0x44000040)  /*!< Reg Absolute Address of [Byte-0] */
#define PA_FLT_b1                                   ((uint32_t)0x44000041)  /*!< Reg Absolute Address of [Byte-1] */
#define PA_FLT_b2                                   ((uint32_t)0x44000042)  /*!< Reg Absolute Address of [Byte-2] */
#define PA_FLT_b3                                   ((uint32_t)0x44000043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PB (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PB_CR0  [register's definitions]
 *              Offset[0x00]  PB0 IO control register (0x44010000)
 ******************************************************************************
 */
///@{
#define PB_CR0_w                                    ((uint32_t)0x44010000)  /*!< Reg Absolute Address */
#define PB_CR0_h0                                   ((uint32_t)0x44010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR0_h1                                   ((uint32_t)0x44010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR0_b0                                   ((uint32_t)0x44010000)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR0_b1                                   ((uint32_t)0x44010001)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR0_b2                                   ((uint32_t)0x44010002)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR0_b3                                   ((uint32_t)0x44010003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR1  [register's definitions]
 *              Offset[0x04]  PB1 IO control register (0x44010004)
 ******************************************************************************
 */
///@{
#define PB_CR1_w                                    ((uint32_t)0x44010004)  /*!< Reg Absolute Address */
#define PB_CR1_h0                                   ((uint32_t)0x44010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR1_h1                                   ((uint32_t)0x44010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR1_b0                                   ((uint32_t)0x44010004)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR1_b1                                   ((uint32_t)0x44010005)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR1_b2                                   ((uint32_t)0x44010006)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR1_b3                                   ((uint32_t)0x44010007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR2  [register's definitions]
 *              Offset[0x08]  PB2 IO control register (0x44010008)
 ******************************************************************************
 */
///@{
#define PB_CR2_w                                    ((uint32_t)0x44010008)  /*!< Reg Absolute Address */
#define PB_CR2_h0                                   ((uint32_t)0x44010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR2_h1                                   ((uint32_t)0x4401000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR2_b0                                   ((uint32_t)0x44010008)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR2_b1                                   ((uint32_t)0x44010009)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR2_b2                                   ((uint32_t)0x4401000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR2_b3                                   ((uint32_t)0x4401000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR3  [register's definitions]
 *              Offset[0x0C]  PB3 IO control register (0x4401000C)
 ******************************************************************************
 */
///@{
#define PB_CR3_w                                    ((uint32_t)0x4401000C)  /*!< Reg Absolute Address */
#define PB_CR3_h0                                   ((uint32_t)0x4401000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR3_h1                                   ((uint32_t)0x4401000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR3_b0                                   ((uint32_t)0x4401000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR3_b1                                   ((uint32_t)0x4401000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR3_b2                                   ((uint32_t)0x4401000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR3_b3                                   ((uint32_t)0x4401000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR4  [register's definitions]
 *              Offset[0x10]  PB4 IO control register (0x44010010)
 ******************************************************************************
 */
///@{
#define PB_CR4_w                                    ((uint32_t)0x44010010)  /*!< Reg Absolute Address */
#define PB_CR4_h0                                   ((uint32_t)0x44010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR4_h1                                   ((uint32_t)0x44010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR4_b0                                   ((uint32_t)0x44010010)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR4_b1                                   ((uint32_t)0x44010011)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR4_b2                                   ((uint32_t)0x44010012)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR4_b3                                   ((uint32_t)0x44010013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR5  [register's definitions]
 *              Offset[0x14]  PB5 IO control register (0x44010014)
 ******************************************************************************
 */
///@{
#define PB_CR5_w                                    ((uint32_t)0x44010014)  /*!< Reg Absolute Address */
#define PB_CR5_h0                                   ((uint32_t)0x44010014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR5_h1                                   ((uint32_t)0x44010016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR5_b0                                   ((uint32_t)0x44010014)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR5_b1                                   ((uint32_t)0x44010015)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR5_b2                                   ((uint32_t)0x44010016)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR5_b3                                   ((uint32_t)0x44010017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR6  [register's definitions]
 *              Offset[0x18]  PB6 IO control register (0x44010018)
 ******************************************************************************
 */
///@{
#define PB_CR6_w                                    ((uint32_t)0x44010018)  /*!< Reg Absolute Address */
#define PB_CR6_h0                                   ((uint32_t)0x44010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR6_h1                                   ((uint32_t)0x4401001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR6_b0                                   ((uint32_t)0x44010018)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR6_b1                                   ((uint32_t)0x44010019)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR6_b2                                   ((uint32_t)0x4401001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR6_b3                                   ((uint32_t)0x4401001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR7  [register's definitions]
 *              Offset[0x1C]  PB7 IO control register (0x4401001C)
 ******************************************************************************
 */
///@{
#define PB_CR7_w                                    ((uint32_t)0x4401001C)  /*!< Reg Absolute Address */
#define PB_CR7_h0                                   ((uint32_t)0x4401001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR7_h1                                   ((uint32_t)0x4401001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR7_b0                                   ((uint32_t)0x4401001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR7_b1                                   ((uint32_t)0x4401001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR7_b2                                   ((uint32_t)0x4401001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR7_b3                                   ((uint32_t)0x4401001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR8  [register's definitions]
 *              Offset[0x20]  PB8 IO control register (0x44010020)
 ******************************************************************************
 */
///@{
#define PB_CR8_w                                    ((uint32_t)0x44010020)  /*!< Reg Absolute Address */
#define PB_CR8_h0                                   ((uint32_t)0x44010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR8_h1                                   ((uint32_t)0x44010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR8_b0                                   ((uint32_t)0x44010020)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR8_b1                                   ((uint32_t)0x44010021)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR8_b2                                   ((uint32_t)0x44010022)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR8_b3                                   ((uint32_t)0x44010023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR9  [register's definitions]
 *              Offset[0x24]  PB9 IO control register (0x44010024)
 ******************************************************************************
 */
///@{
#define PB_CR9_w                                    ((uint32_t)0x44010024)  /*!< Reg Absolute Address */
#define PB_CR9_h0                                   ((uint32_t)0x44010024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR9_h1                                   ((uint32_t)0x44010026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR9_b0                                   ((uint32_t)0x44010024)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR9_b1                                   ((uint32_t)0x44010025)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR9_b2                                   ((uint32_t)0x44010026)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR9_b3                                   ((uint32_t)0x44010027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR10  [register's definitions]
 *              Offset[0x28]  PB10 IO control register (0x44010028)
 ******************************************************************************
 */
///@{
#define PB_CR10_w                                   ((uint32_t)0x44010028)  /*!< Reg Absolute Address */
#define PB_CR10_h0                                  ((uint32_t)0x44010028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR10_h1                                  ((uint32_t)0x4401002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR10_b0                                  ((uint32_t)0x44010028)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR10_b1                                  ((uint32_t)0x44010029)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR10_b2                                  ((uint32_t)0x4401002A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR10_b3                                  ((uint32_t)0x4401002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR11  [register's definitions]
 *              Offset[0x2C]  PB11 IO control register (0x4401002C)
 ******************************************************************************
 */
///@{
#define PB_CR11_w                                   ((uint32_t)0x4401002C)  /*!< Reg Absolute Address */
#define PB_CR11_h0                                  ((uint32_t)0x4401002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR11_h1                                  ((uint32_t)0x4401002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR11_b0                                  ((uint32_t)0x4401002C)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR11_b1                                  ((uint32_t)0x4401002D)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR11_b2                                  ((uint32_t)0x4401002E)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR11_b3                                  ((uint32_t)0x4401002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR12  [register's definitions]
 *              Offset[0x30]  PB12 IO control register (0x44010030)
 ******************************************************************************
 */
///@{
#define PB_CR12_w                                   ((uint32_t)0x44010030)  /*!< Reg Absolute Address */
#define PB_CR12_h0                                  ((uint32_t)0x44010030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR12_h1                                  ((uint32_t)0x44010032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR12_b0                                  ((uint32_t)0x44010030)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR12_b1                                  ((uint32_t)0x44010031)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR12_b2                                  ((uint32_t)0x44010032)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR12_b3                                  ((uint32_t)0x44010033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR13  [register's definitions]
 *              Offset[0x34]  PB13 IO control register (0x44010034)
 ******************************************************************************
 */
///@{
#define PB_CR13_w                                   ((uint32_t)0x44010034)  /*!< Reg Absolute Address */
#define PB_CR13_h0                                  ((uint32_t)0x44010034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR13_h1                                  ((uint32_t)0x44010036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR13_b0                                  ((uint32_t)0x44010034)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR13_b1                                  ((uint32_t)0x44010035)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR13_b2                                  ((uint32_t)0x44010036)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR13_b3                                  ((uint32_t)0x44010037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR14  [register's definitions]
 *              Offset[0x38]  PB14 IO control register (0x44010038)
 ******************************************************************************
 */
///@{
#define PB_CR14_w                                   ((uint32_t)0x44010038)  /*!< Reg Absolute Address */
#define PB_CR14_h0                                  ((uint32_t)0x44010038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR14_h1                                  ((uint32_t)0x4401003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR14_b0                                  ((uint32_t)0x44010038)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR14_b1                                  ((uint32_t)0x44010039)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR14_b2                                  ((uint32_t)0x4401003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR14_b3                                  ((uint32_t)0x4401003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_CR15  [register's definitions]
 *              Offset[0x3C]  PB15 IO control register (0x4401003C)
 ******************************************************************************
 */
///@{
#define PB_CR15_w                                   ((uint32_t)0x4401003C)  /*!< Reg Absolute Address */
#define PB_CR15_h0                                  ((uint32_t)0x4401003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_CR15_h1                                  ((uint32_t)0x4401003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_CR15_b0                                  ((uint32_t)0x4401003C)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_CR15_b1                                  ((uint32_t)0x4401003D)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_CR15_b2                                  ((uint32_t)0x4401003E)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_CR15_b3                                  ((uint32_t)0x4401003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PB_FLT  [register's definitions]
 *              Offset[0x40]  PB port input filter control register (0x44010040)
 ******************************************************************************
 */
///@{
#define PB_FLT_w                                    ((uint32_t)0x44010040)  /*!< Reg Absolute Address */
#define PB_FLT_h0                                   ((uint32_t)0x44010040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PB_FLT_h1                                   ((uint32_t)0x44010042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PB_FLT_b0                                   ((uint32_t)0x44010040)  /*!< Reg Absolute Address of [Byte-0] */
#define PB_FLT_b1                                   ((uint32_t)0x44010041)  /*!< Reg Absolute Address of [Byte-1] */
#define PB_FLT_b2                                   ((uint32_t)0x44010042)  /*!< Reg Absolute Address of [Byte-2] */
#define PB_FLT_b3                                   ((uint32_t)0x44010043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PC (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PC_CR0  [register's definitions]
 *              Offset[0x00]  PC0 IO control register (0x44020000)
 ******************************************************************************
 */
///@{
#define PC_CR0_w                                    ((uint32_t)0x44020000)  /*!< Reg Absolute Address */
#define PC_CR0_h0                                   ((uint32_t)0x44020000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR0_h1                                   ((uint32_t)0x44020002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR0_b0                                   ((uint32_t)0x44020000)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR0_b1                                   ((uint32_t)0x44020001)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR0_b2                                   ((uint32_t)0x44020002)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR0_b3                                   ((uint32_t)0x44020003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR1  [register's definitions]
 *              Offset[0x04]  PC1 IO control register (0x44020004)
 ******************************************************************************
 */
///@{
#define PC_CR1_w                                    ((uint32_t)0x44020004)  /*!< Reg Absolute Address */
#define PC_CR1_h0                                   ((uint32_t)0x44020004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR1_h1                                   ((uint32_t)0x44020006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR1_b0                                   ((uint32_t)0x44020004)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR1_b1                                   ((uint32_t)0x44020005)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR1_b2                                   ((uint32_t)0x44020006)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR1_b3                                   ((uint32_t)0x44020007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR2  [register's definitions]
 *              Offset[0x08]  PC2 IO control register (0x44020008)
 ******************************************************************************
 */
///@{
#define PC_CR2_w                                    ((uint32_t)0x44020008)  /*!< Reg Absolute Address */
#define PC_CR2_h0                                   ((uint32_t)0x44020008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR2_h1                                   ((uint32_t)0x4402000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR2_b0                                   ((uint32_t)0x44020008)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR2_b1                                   ((uint32_t)0x44020009)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR2_b2                                   ((uint32_t)0x4402000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR2_b3                                   ((uint32_t)0x4402000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR3  [register's definitions]
 *              Offset[0x0C]  PC3 IO control register (0x4402000C)
 ******************************************************************************
 */
///@{
#define PC_CR3_w                                    ((uint32_t)0x4402000C)  /*!< Reg Absolute Address */
#define PC_CR3_h0                                   ((uint32_t)0x4402000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR3_h1                                   ((uint32_t)0x4402000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR3_b0                                   ((uint32_t)0x4402000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR3_b1                                   ((uint32_t)0x4402000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR3_b2                                   ((uint32_t)0x4402000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR3_b3                                   ((uint32_t)0x4402000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR4  [register's definitions]
 *              Offset[0x10]  PC4 IO control register (0x44020010)
 ******************************************************************************
 */
///@{
#define PC_CR4_w                                    ((uint32_t)0x44020010)  /*!< Reg Absolute Address */
#define PC_CR4_h0                                   ((uint32_t)0x44020010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR4_h1                                   ((uint32_t)0x44020012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR4_b0                                   ((uint32_t)0x44020010)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR4_b1                                   ((uint32_t)0x44020011)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR4_b2                                   ((uint32_t)0x44020012)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR4_b3                                   ((uint32_t)0x44020013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR5  [register's definitions]
 *              Offset[0x14]  PC5 IO control register (0x44020014)
 ******************************************************************************
 */
///@{
#define PC_CR5_w                                    ((uint32_t)0x44020014)  /*!< Reg Absolute Address */
#define PC_CR5_h0                                   ((uint32_t)0x44020014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR5_h1                                   ((uint32_t)0x44020016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR5_b0                                   ((uint32_t)0x44020014)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR5_b1                                   ((uint32_t)0x44020015)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR5_b2                                   ((uint32_t)0x44020016)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR5_b3                                   ((uint32_t)0x44020017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR6  [register's definitions]
 *              Offset[0x18]  PC6 IO control register (0x44020018)
 ******************************************************************************
 */
///@{
#define PC_CR6_w                                    ((uint32_t)0x44020018)  /*!< Reg Absolute Address */
#define PC_CR6_h0                                   ((uint32_t)0x44020018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR6_h1                                   ((uint32_t)0x4402001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR6_b0                                   ((uint32_t)0x44020018)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR6_b1                                   ((uint32_t)0x44020019)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR6_b2                                   ((uint32_t)0x4402001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR6_b3                                   ((uint32_t)0x4402001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR7  [register's definitions]
 *              Offset[0x1C]  PC7 IO control register (0x4402001C)
 ******************************************************************************
 */
///@{
#define PC_CR7_w                                    ((uint32_t)0x4402001C)  /*!< Reg Absolute Address */
#define PC_CR7_h0                                   ((uint32_t)0x4402001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR7_h1                                   ((uint32_t)0x4402001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR7_b0                                   ((uint32_t)0x4402001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR7_b1                                   ((uint32_t)0x4402001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR7_b2                                   ((uint32_t)0x4402001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR7_b3                                   ((uint32_t)0x4402001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR8  [register's definitions]
 *              Offset[0x20]  PC8 IO control register (0x44020020)
 ******************************************************************************
 */
///@{
#define PC_CR8_w                                    ((uint32_t)0x44020020)  /*!< Reg Absolute Address */
#define PC_CR8_h0                                   ((uint32_t)0x44020020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR8_h1                                   ((uint32_t)0x44020022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR8_b0                                   ((uint32_t)0x44020020)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR8_b1                                   ((uint32_t)0x44020021)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR8_b2                                   ((uint32_t)0x44020022)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR8_b3                                   ((uint32_t)0x44020023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR9  [register's definitions]
 *              Offset[0x24]  PC9 IO control register (0x44020024)
 ******************************************************************************
 */
///@{
#define PC_CR9_w                                    ((uint32_t)0x44020024)  /*!< Reg Absolute Address */
#define PC_CR9_h0                                   ((uint32_t)0x44020024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR9_h1                                   ((uint32_t)0x44020026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR9_b0                                   ((uint32_t)0x44020024)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR9_b1                                   ((uint32_t)0x44020025)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR9_b2                                   ((uint32_t)0x44020026)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR9_b3                                   ((uint32_t)0x44020027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR10  [register's definitions]
 *              Offset[0x28]  PC10 IO control register (0x44020028)
 ******************************************************************************
 */
///@{
#define PC_CR10_w                                   ((uint32_t)0x44020028)  /*!< Reg Absolute Address */
#define PC_CR10_h0                                  ((uint32_t)0x44020028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR10_h1                                  ((uint32_t)0x4402002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR10_b0                                  ((uint32_t)0x44020028)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR10_b1                                  ((uint32_t)0x44020029)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR10_b2                                  ((uint32_t)0x4402002A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR10_b3                                  ((uint32_t)0x4402002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR11  [register's definitions]
 *              Offset[0x2C]  PC11 IO control register (0x4402002C)
 ******************************************************************************
 */
///@{
#define PC_CR11_w                                   ((uint32_t)0x4402002C)  /*!< Reg Absolute Address */
#define PC_CR11_h0                                  ((uint32_t)0x4402002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR11_h1                                  ((uint32_t)0x4402002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR11_b0                                  ((uint32_t)0x4402002C)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR11_b1                                  ((uint32_t)0x4402002D)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR11_b2                                  ((uint32_t)0x4402002E)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR11_b3                                  ((uint32_t)0x4402002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR12  [register's definitions]
 *              Offset[0x30]  PC12 IO control register (0x44020030)
 ******************************************************************************
 */
///@{
#define PC_CR12_w                                   ((uint32_t)0x44020030)  /*!< Reg Absolute Address */
#define PC_CR12_h0                                  ((uint32_t)0x44020030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR12_h1                                  ((uint32_t)0x44020032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR12_b0                                  ((uint32_t)0x44020030)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR12_b1                                  ((uint32_t)0x44020031)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR12_b2                                  ((uint32_t)0x44020032)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR12_b3                                  ((uint32_t)0x44020033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR13  [register's definitions]
 *              Offset[0x34]  PC13 IO control register (0x44020034)
 ******************************************************************************
 */
///@{
#define PC_CR13_w                                   ((uint32_t)0x44020034)  /*!< Reg Absolute Address */
#define PC_CR13_h0                                  ((uint32_t)0x44020034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR13_h1                                  ((uint32_t)0x44020036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR13_b0                                  ((uint32_t)0x44020034)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR13_b1                                  ((uint32_t)0x44020035)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR13_b2                                  ((uint32_t)0x44020036)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR13_b3                                  ((uint32_t)0x44020037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_CR14  [register's definitions]
 *              Offset[0x38]  PC14 IO control register (0x44020038)
 ******************************************************************************
 */
///@{
#define PC_CR14_w                                   ((uint32_t)0x44020038)  /*!< Reg Absolute Address */
#define PC_CR14_h0                                  ((uint32_t)0x44020038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_CR14_h1                                  ((uint32_t)0x4402003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_CR14_b0                                  ((uint32_t)0x44020038)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_CR14_b1                                  ((uint32_t)0x44020039)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_CR14_b2                                  ((uint32_t)0x4402003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_CR14_b3                                  ((uint32_t)0x4402003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PC_FLT  [register's definitions]
 *              Offset[0x40]  PC port input filter control register (0x44020040)
 ******************************************************************************
 */
///@{
#define PC_FLT_w                                    ((uint32_t)0x44020040)  /*!< Reg Absolute Address */
#define PC_FLT_h0                                   ((uint32_t)0x44020040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PC_FLT_h1                                   ((uint32_t)0x44020042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PC_FLT_b0                                   ((uint32_t)0x44020040)  /*!< Reg Absolute Address of [Byte-0] */
#define PC_FLT_b1                                   ((uint32_t)0x44020041)  /*!< Reg Absolute Address of [Byte-1] */
#define PC_FLT_b2                                   ((uint32_t)0x44020042)  /*!< Reg Absolute Address of [Byte-2] */
#define PC_FLT_b3                                   ((uint32_t)0x44020043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PD (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PD_CR0  [register's definitions]
 *              Offset[0x00]  PD0 IO control register (0x44030000)
 ******************************************************************************
 */
///@{
#define PD_CR0_w                                    ((uint32_t)0x44030000)  /*!< Reg Absolute Address */
#define PD_CR0_h0                                   ((uint32_t)0x44030000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR0_h1                                   ((uint32_t)0x44030002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR0_b0                                   ((uint32_t)0x44030000)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR0_b1                                   ((uint32_t)0x44030001)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR0_b2                                   ((uint32_t)0x44030002)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR0_b3                                   ((uint32_t)0x44030003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR1  [register's definitions]
 *              Offset[0x04]  PD1 IO control register (0x44030004)
 ******************************************************************************
 */
///@{
#define PD_CR1_w                                    ((uint32_t)0x44030004)  /*!< Reg Absolute Address */
#define PD_CR1_h0                                   ((uint32_t)0x44030004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR1_h1                                   ((uint32_t)0x44030006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR1_b0                                   ((uint32_t)0x44030004)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR1_b1                                   ((uint32_t)0x44030005)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR1_b2                                   ((uint32_t)0x44030006)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR1_b3                                   ((uint32_t)0x44030007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR2  [register's definitions]
 *              Offset[0x08]  PD2 IO control register (0x44030008)
 ******************************************************************************
 */
///@{
#define PD_CR2_w                                    ((uint32_t)0x44030008)  /*!< Reg Absolute Address */
#define PD_CR2_h0                                   ((uint32_t)0x44030008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR2_h1                                   ((uint32_t)0x4403000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR2_b0                                   ((uint32_t)0x44030008)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR2_b1                                   ((uint32_t)0x44030009)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR2_b2                                   ((uint32_t)0x4403000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR2_b3                                   ((uint32_t)0x4403000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR3  [register's definitions]
 *              Offset[0x0C]  PD3 IO control register (0x4403000C)
 ******************************************************************************
 */
///@{
#define PD_CR3_w                                    ((uint32_t)0x4403000C)  /*!< Reg Absolute Address */
#define PD_CR3_h0                                   ((uint32_t)0x4403000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR3_h1                                   ((uint32_t)0x4403000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR3_b0                                   ((uint32_t)0x4403000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR3_b1                                   ((uint32_t)0x4403000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR3_b2                                   ((uint32_t)0x4403000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR3_b3                                   ((uint32_t)0x4403000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR4  [register's definitions]
 *              Offset[0x10]  PD4 IO control register (0x44030010)
 ******************************************************************************
 */
///@{
#define PD_CR4_w                                    ((uint32_t)0x44030010)  /*!< Reg Absolute Address */
#define PD_CR4_h0                                   ((uint32_t)0x44030010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR4_h1                                   ((uint32_t)0x44030012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR4_b0                                   ((uint32_t)0x44030010)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR4_b1                                   ((uint32_t)0x44030011)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR4_b2                                   ((uint32_t)0x44030012)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR4_b3                                   ((uint32_t)0x44030013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR5  [register's definitions]
 *              Offset[0x14]  PD5 IO control register (0x44030014)
 ******************************************************************************
 */
///@{
#define PD_CR5_w                                    ((uint32_t)0x44030014)  /*!< Reg Absolute Address */
#define PD_CR5_h0                                   ((uint32_t)0x44030014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR5_h1                                   ((uint32_t)0x44030016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR5_b0                                   ((uint32_t)0x44030014)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR5_b1                                   ((uint32_t)0x44030015)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR5_b2                                   ((uint32_t)0x44030016)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR5_b3                                   ((uint32_t)0x44030017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR6  [register's definitions]
 *              Offset[0x18]  PD6 IO control register (0x44030018)
 ******************************************************************************
 */
///@{
#define PD_CR6_w                                    ((uint32_t)0x44030018)  /*!< Reg Absolute Address */
#define PD_CR6_h0                                   ((uint32_t)0x44030018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR6_h1                                   ((uint32_t)0x4403001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR6_b0                                   ((uint32_t)0x44030018)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR6_b1                                   ((uint32_t)0x44030019)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR6_b2                                   ((uint32_t)0x4403001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR6_b3                                   ((uint32_t)0x4403001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR7  [register's definitions]
 *              Offset[0x1C]  PD7 IO control register (0x4403001C)
 ******************************************************************************
 */
///@{
#define PD_CR7_w                                    ((uint32_t)0x4403001C)  /*!< Reg Absolute Address */
#define PD_CR7_h0                                   ((uint32_t)0x4403001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR7_h1                                   ((uint32_t)0x4403001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR7_b0                                   ((uint32_t)0x4403001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR7_b1                                   ((uint32_t)0x4403001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR7_b2                                   ((uint32_t)0x4403001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR7_b3                                   ((uint32_t)0x4403001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR8  [register's definitions]
 *              Offset[0x20]  PD8 IO control register (0x44030020)
 ******************************************************************************
 */
///@{
#define PD_CR8_w                                    ((uint32_t)0x44030020)  /*!< Reg Absolute Address */
#define PD_CR8_h0                                   ((uint32_t)0x44030020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR8_h1                                   ((uint32_t)0x44030022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR8_b0                                   ((uint32_t)0x44030020)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR8_b1                                   ((uint32_t)0x44030021)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR8_b2                                   ((uint32_t)0x44030022)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR8_b3                                   ((uint32_t)0x44030023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR9  [register's definitions]
 *              Offset[0x24]  PD9 IO control register (0x44030024)
 ******************************************************************************
 */
///@{
#define PD_CR9_w                                    ((uint32_t)0x44030024)  /*!< Reg Absolute Address */
#define PD_CR9_h0                                   ((uint32_t)0x44030024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR9_h1                                   ((uint32_t)0x44030026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR9_b0                                   ((uint32_t)0x44030024)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR9_b1                                   ((uint32_t)0x44030025)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR9_b2                                   ((uint32_t)0x44030026)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR9_b3                                   ((uint32_t)0x44030027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR10  [register's definitions]
 *              Offset[0x28]  PD10 IO control register (0x44030028)
 ******************************************************************************
 */
///@{
#define PD_CR10_w                                   ((uint32_t)0x44030028)  /*!< Reg Absolute Address */
#define PD_CR10_h0                                  ((uint32_t)0x44030028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR10_h1                                  ((uint32_t)0x4403002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR10_b0                                  ((uint32_t)0x44030028)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR10_b1                                  ((uint32_t)0x44030029)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR10_b2                                  ((uint32_t)0x4403002A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR10_b3                                  ((uint32_t)0x4403002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR11  [register's definitions]
 *              Offset[0x2C]  PD11 IO control register (0x4403002C)
 ******************************************************************************
 */
///@{
#define PD_CR11_w                                   ((uint32_t)0x4403002C)  /*!< Reg Absolute Address */
#define PD_CR11_h0                                  ((uint32_t)0x4403002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR11_h1                                  ((uint32_t)0x4403002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR11_b0                                  ((uint32_t)0x4403002C)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR11_b1                                  ((uint32_t)0x4403002D)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR11_b2                                  ((uint32_t)0x4403002E)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR11_b3                                  ((uint32_t)0x4403002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR12  [register's definitions]
 *              Offset[0x30]  PD12 IO control register (0x44030030)
 ******************************************************************************
 */
///@{
#define PD_CR12_w                                   ((uint32_t)0x44030030)  /*!< Reg Absolute Address */
#define PD_CR12_h0                                  ((uint32_t)0x44030030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR12_h1                                  ((uint32_t)0x44030032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR12_b0                                  ((uint32_t)0x44030030)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR12_b1                                  ((uint32_t)0x44030031)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR12_b2                                  ((uint32_t)0x44030032)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR12_b3                                  ((uint32_t)0x44030033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR13  [register's definitions]
 *              Offset[0x34]  PD13 IO control register (0x44030034)
 ******************************************************************************
 */
///@{
#define PD_CR13_w                                   ((uint32_t)0x44030034)  /*!< Reg Absolute Address */
#define PD_CR13_h0                                  ((uint32_t)0x44030034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR13_h1                                  ((uint32_t)0x44030036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR13_b0                                  ((uint32_t)0x44030034)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR13_b1                                  ((uint32_t)0x44030035)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR13_b2                                  ((uint32_t)0x44030036)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR13_b3                                  ((uint32_t)0x44030037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR14  [register's definitions]
 *              Offset[0x38]  PD14 IO control register (0x44030038)
 ******************************************************************************
 */
///@{
#define PD_CR14_w                                   ((uint32_t)0x44030038)  /*!< Reg Absolute Address */
#define PD_CR14_h0                                  ((uint32_t)0x44030038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR14_h1                                  ((uint32_t)0x4403003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR14_b0                                  ((uint32_t)0x44030038)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR14_b1                                  ((uint32_t)0x44030039)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR14_b2                                  ((uint32_t)0x4403003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR14_b3                                  ((uint32_t)0x4403003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_CR15  [register's definitions]
 *              Offset[0x3C]  PD15 IO control register (0x4403003C)
 ******************************************************************************
 */
///@{
#define PD_CR15_w                                   ((uint32_t)0x4403003C)  /*!< Reg Absolute Address */
#define PD_CR15_h0                                  ((uint32_t)0x4403003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_CR15_h1                                  ((uint32_t)0x4403003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_CR15_b0                                  ((uint32_t)0x4403003C)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_CR15_b1                                  ((uint32_t)0x4403003D)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_CR15_b2                                  ((uint32_t)0x4403003E)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_CR15_b3                                  ((uint32_t)0x4403003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PD_FLT  [register's definitions]
 *              Offset[0x40]  PD port input filter control register (0x44030040)
 ******************************************************************************
 */
///@{
#define PD_FLT_w                                    ((uint32_t)0x44030040)  /*!< Reg Absolute Address */
#define PD_FLT_h0                                   ((uint32_t)0x44030040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PD_FLT_h1                                   ((uint32_t)0x44030042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PD_FLT_b0                                   ((uint32_t)0x44030040)  /*!< Reg Absolute Address of [Byte-0] */
#define PD_FLT_b1                                   ((uint32_t)0x44030041)  /*!< Reg Absolute Address of [Byte-1] */
#define PD_FLT_b2                                   ((uint32_t)0x44030042)  /*!< Reg Absolute Address of [Byte-2] */
#define PD_FLT_b3                                   ((uint32_t)0x44030043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PE (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PE_CR0  [register's definitions]
 *              Offset[0x00]  PE0 IO control register (0x44040000)
 ******************************************************************************
 */
///@{
#define PE_CR0_w                                    ((uint32_t)0x44040000)  /*!< Reg Absolute Address */
#define PE_CR0_h0                                   ((uint32_t)0x44040000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR0_h1                                   ((uint32_t)0x44040002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR0_b0                                   ((uint32_t)0x44040000)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR0_b1                                   ((uint32_t)0x44040001)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR0_b2                                   ((uint32_t)0x44040002)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR0_b3                                   ((uint32_t)0x44040003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR1  [register's definitions]
 *              Offset[0x04]  PE1 IO control register (0x44040004)
 ******************************************************************************
 */
///@{
#define PE_CR1_w                                    ((uint32_t)0x44040004)  /*!< Reg Absolute Address */
#define PE_CR1_h0                                   ((uint32_t)0x44040004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR1_h1                                   ((uint32_t)0x44040006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR1_b0                                   ((uint32_t)0x44040004)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR1_b1                                   ((uint32_t)0x44040005)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR1_b2                                   ((uint32_t)0x44040006)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR1_b3                                   ((uint32_t)0x44040007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR2  [register's definitions]
 *              Offset[0x08]  PE2 IO control register (0x44040008)
 ******************************************************************************
 */
///@{
#define PE_CR2_w                                    ((uint32_t)0x44040008)  /*!< Reg Absolute Address */
#define PE_CR2_h0                                   ((uint32_t)0x44040008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR2_h1                                   ((uint32_t)0x4404000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR2_b0                                   ((uint32_t)0x44040008)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR2_b1                                   ((uint32_t)0x44040009)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR2_b2                                   ((uint32_t)0x4404000A)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR2_b3                                   ((uint32_t)0x4404000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR3  [register's definitions]
 *              Offset[0x0C]  PE3 IO control register (0x4404000C)
 ******************************************************************************
 */
///@{
#define PE_CR3_w                                    ((uint32_t)0x4404000C)  /*!< Reg Absolute Address */
#define PE_CR3_h0                                   ((uint32_t)0x4404000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR3_h1                                   ((uint32_t)0x4404000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR3_b0                                   ((uint32_t)0x4404000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR3_b1                                   ((uint32_t)0x4404000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR3_b2                                   ((uint32_t)0x4404000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR3_b3                                   ((uint32_t)0x4404000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR8  [register's definitions]
 *              Offset[0x20]  PE8 IO control register (0x44040020)
 ******************************************************************************
 */
///@{
#define PE_CR8_w                                    ((uint32_t)0x44040020)  /*!< Reg Absolute Address */
#define PE_CR8_h0                                   ((uint32_t)0x44040020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR8_h1                                   ((uint32_t)0x44040022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR8_b0                                   ((uint32_t)0x44040020)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR8_b1                                   ((uint32_t)0x44040021)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR8_b2                                   ((uint32_t)0x44040022)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR8_b3                                   ((uint32_t)0x44040023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR9  [register's definitions]
 *              Offset[0x24]  PE9 IO control register (0x44040024)
 ******************************************************************************
 */
///@{
#define PE_CR9_w                                    ((uint32_t)0x44040024)  /*!< Reg Absolute Address */
#define PE_CR9_h0                                   ((uint32_t)0x44040024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR9_h1                                   ((uint32_t)0x44040026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR9_b0                                   ((uint32_t)0x44040024)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR9_b1                                   ((uint32_t)0x44040025)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR9_b2                                   ((uint32_t)0x44040026)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR9_b3                                   ((uint32_t)0x44040027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR12  [register's definitions]
 *              Offset[0x30]  PE12 IO control register (0x44040030)
 ******************************************************************************
 */
///@{
#define PE_CR12_w                                   ((uint32_t)0x44040030)  /*!< Reg Absolute Address */
#define PE_CR12_h0                                  ((uint32_t)0x44040030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR12_h1                                  ((uint32_t)0x44040032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR12_b0                                  ((uint32_t)0x44040030)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR12_b1                                  ((uint32_t)0x44040031)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR12_b2                                  ((uint32_t)0x44040032)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR12_b3                                  ((uint32_t)0x44040033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR13  [register's definitions]
 *              Offset[0x34]  PE13 IO control register (0x44040034)
 ******************************************************************************
 */
///@{
#define PE_CR13_w                                   ((uint32_t)0x44040034)  /*!< Reg Absolute Address */
#define PE_CR13_h0                                  ((uint32_t)0x44040034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR13_h1                                  ((uint32_t)0x44040036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR13_b0                                  ((uint32_t)0x44040034)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR13_b1                                  ((uint32_t)0x44040035)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR13_b2                                  ((uint32_t)0x44040036)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR13_b3                                  ((uint32_t)0x44040037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR14  [register's definitions]
 *              Offset[0x38]  PE14 IO control register (0x44040038)
 ******************************************************************************
 */
///@{
#define PE_CR14_w                                   ((uint32_t)0x44040038)  /*!< Reg Absolute Address */
#define PE_CR14_h0                                  ((uint32_t)0x44040038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR14_h1                                  ((uint32_t)0x4404003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR14_b0                                  ((uint32_t)0x44040038)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR14_b1                                  ((uint32_t)0x44040039)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR14_b2                                  ((uint32_t)0x4404003A)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR14_b3                                  ((uint32_t)0x4404003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_CR15  [register's definitions]
 *              Offset[0x3C]  PE15 IO control register (0x4404003C)
 ******************************************************************************
 */
///@{
#define PE_CR15_w                                   ((uint32_t)0x4404003C)  /*!< Reg Absolute Address */
#define PE_CR15_h0                                  ((uint32_t)0x4404003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_CR15_h1                                  ((uint32_t)0x4404003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_CR15_b0                                  ((uint32_t)0x4404003C)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_CR15_b1                                  ((uint32_t)0x4404003D)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_CR15_b2                                  ((uint32_t)0x4404003E)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_CR15_b3                                  ((uint32_t)0x4404003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PE_FLT  [register's definitions]
 *              Offset[0x40]  PE port input filter control register (0x44040040)
 ******************************************************************************
 */
///@{
#define PE_FLT_w                                    ((uint32_t)0x44040040)  /*!< Reg Absolute Address */
#define PE_FLT_h0                                   ((uint32_t)0x44040040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PE_FLT_h1                                   ((uint32_t)0x44040042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PE_FLT_b0                                   ((uint32_t)0x44040040)  /*!< Reg Absolute Address of [Byte-0] */
#define PE_FLT_b1                                   ((uint32_t)0x44040041)  /*!< Reg Absolute Address of [Byte-1] */
#define PE_FLT_b2                                   ((uint32_t)0x44040042)  /*!< Reg Absolute Address of [Byte-2] */
#define PE_FLT_b3                                   ((uint32_t)0x44040043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      GPL (GPL Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        GPL_STA  [register's definitions]
 *              Offset[0x00]  GPL status register (0x4B000000)
 ******************************************************************************
 */
///@{
#define GPL_STA_w                                   ((uint32_t)0x4B000000)  /*!< Reg Absolute Address */
#define GPL_STA_h0                                  ((uint32_t)0x4B000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_STA_h1                                  ((uint32_t)0x4B000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_STA_b0                                  ((uint32_t)0x4B000000)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_STA_b1                                  ((uint32_t)0x4B000001)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_STA_b2                                  ((uint32_t)0x4B000002)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_STA_b3                                  ((uint32_t)0x4B000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        GPL_CR0  [register's definitions]
 *              Offset[0x10]  GPL control register 0 (0x4B000010)
 ******************************************************************************
 */
///@{
#define GPL_CR0_w                                   ((uint32_t)0x4B000010)  /*!< Reg Absolute Address */
#define GPL_CR0_h0                                  ((uint32_t)0x4B000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_CR0_h1                                  ((uint32_t)0x4B000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_CR0_b0                                  ((uint32_t)0x4B000010)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_CR0_b1                                  ((uint32_t)0x4B000011)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_CR0_b2                                  ((uint32_t)0x4B000012)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_CR0_b3                                  ((uint32_t)0x4B000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        GPL_CR1  [register's definitions]
 *              Offset[0x14]  GPL control register 1 (0x4B000014)
 ******************************************************************************
 */
///@{
#define GPL_CR1_w                                   ((uint32_t)0x4B000014)  /*!< Reg Absolute Address */
#define GPL_CR1_h0                                  ((uint32_t)0x4B000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_CR1_h1                                  ((uint32_t)0x4B000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_CR1_b0                                  ((uint32_t)0x4B000014)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_CR1_b1                                  ((uint32_t)0x4B000015)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_CR1_b2                                  ((uint32_t)0x4B000016)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_CR1_b3                                  ((uint32_t)0x4B000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        GPL_DIN  [register's definitions]
 *              Offset[0x18]  GPL data input register (0x4B000018)
 ******************************************************************************
 */
///@{
#define GPL_DIN_w                                   ((uint32_t)0x4B000018)  /*!< Reg Absolute Address */
#define GPL_DIN_h0                                  ((uint32_t)0x4B000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_DIN_h1                                  ((uint32_t)0x4B00001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_DIN_b0                                  ((uint32_t)0x4B000018)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_DIN_b1                                  ((uint32_t)0x4B000019)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_DIN_b2                                  ((uint32_t)0x4B00001A)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_DIN_b3                                  ((uint32_t)0x4B00001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        GPL_DOUT  [register's definitions]
 *              Offset[0x1C]  GPL data output register (0x4B00001C)
 ******************************************************************************
 */
///@{
#define GPL_DOUT_w                                  ((uint32_t)0x4B00001C)  /*!< Reg Absolute Address */
#define GPL_DOUT_h0                                 ((uint32_t)0x4B00001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_DOUT_h1                                 ((uint32_t)0x4B00001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_DOUT_b0                                 ((uint32_t)0x4B00001C)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_DOUT_b1                                 ((uint32_t)0x4B00001D)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_DOUT_b2                                 ((uint32_t)0x4B00001E)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_DOUT_b3                                 ((uint32_t)0x4B00001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        GPL_CRCINIT  [register's definitions]
 *              Offset[0x24]  GPL CRC initial register (0x4B000024)
 ******************************************************************************
 */
///@{
#define GPL_CRCINIT_w                               ((uint32_t)0x4B000024)  /*!< Reg Absolute Address */
#define GPL_CRCINIT_h0                              ((uint32_t)0x4B000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define GPL_CRCINIT_h1                              ((uint32_t)0x4B000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define GPL_CRCINIT_b0                              ((uint32_t)0x4B000024)  /*!< Reg Absolute Address of [Byte-0] */
#define GPL_CRCINIT_b1                              ((uint32_t)0x4B000025)  /*!< Reg Absolute Address of [Byte-1] */
#define GPL_CRCINIT_b2                              ((uint32_t)0x4B000026)  /*!< Reg Absolute Address of [Byte-2] */
#define GPL_CRCINIT_b3                              ((uint32_t)0x4B000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      DMA (DMA Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        DMA_STA  [register's definitions]
 *              Offset[0x00]  DMA status register (0x4BF00000)
 ******************************************************************************
 */
///@{
#define DMA_STA_w                                   ((uint32_t)0x4BF00000)  /*!< Reg Absolute Address */
#define DMA_STA_h0                                  ((uint32_t)0x4BF00000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_STA_h1                                  ((uint32_t)0x4BF00002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_STA_b0                                  ((uint32_t)0x4BF00000)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_STA_b1                                  ((uint32_t)0x4BF00001)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_STA_b2                                  ((uint32_t)0x4BF00002)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_STA_b3                                  ((uint32_t)0x4BF00003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_INT  [register's definitions]
 *              Offset[0x04]  DMA interrupt enable register (0x4BF00004)
 ******************************************************************************
 */
///@{
#define DMA_INT_w                                   ((uint32_t)0x4BF00004)  /*!< Reg Absolute Address */
#define DMA_INT_h0                                  ((uint32_t)0x4BF00004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_INT_h1                                  ((uint32_t)0x4BF00006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_INT_b0                                  ((uint32_t)0x4BF00004)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_INT_b1                                  ((uint32_t)0x4BF00005)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_INT_b2                                  ((uint32_t)0x4BF00006)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_INT_b3                                  ((uint32_t)0x4BF00007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CR0  [register's definitions]
 *              Offset[0x10]  DMA global control register 0 (0x4BF00010)
 ******************************************************************************
 */
///@{
#define DMA_CR0_w                                   ((uint32_t)0x4BF00010)  /*!< Reg Absolute Address */
#define DMA_CR0_h0                                  ((uint32_t)0x4BF00010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CR0_h1                                  ((uint32_t)0x4BF00012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CR0_b0                                  ((uint32_t)0x4BF00010)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CR0_b1                                  ((uint32_t)0x4BF00011)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CR0_b2                                  ((uint32_t)0x4BF00012)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CR0_b3                                  ((uint32_t)0x4BF00013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CR2  [register's definitions]
 *              Offset[0x18]  DMA global control register 2 (0x4BF00018)
 ******************************************************************************
 */
///@{
#define DMA_CR2_w                                   ((uint32_t)0x4BF00018)  /*!< Reg Absolute Address */
#define DMA_CR2_h0                                  ((uint32_t)0x4BF00018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CR2_h1                                  ((uint32_t)0x4BF0001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CR2_b0                                  ((uint32_t)0x4BF00018)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CR2_b1                                  ((uint32_t)0x4BF00019)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CR2_b2                                  ((uint32_t)0x4BF0001A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CR2_b3                                  ((uint32_t)0x4BF0001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0A  [register's definitions]
 *              Offset[0x20]  DMA channel-0 control register 0 (0x4BF00020)
 ******************************************************************************
 */
///@{
#define DMA_CH0A_w                                  ((uint32_t)0x4BF00020)  /*!< Reg Absolute Address */
#define DMA_CH0A_h0                                 ((uint32_t)0x4BF00020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0A_h1                                 ((uint32_t)0x4BF00022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0A_b0                                 ((uint32_t)0x4BF00020)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0A_b1                                 ((uint32_t)0x4BF00021)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0A_b2                                 ((uint32_t)0x4BF00022)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0A_b3                                 ((uint32_t)0x4BF00023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0B  [register's definitions]
 *              Offset[0x24]  DMA channel-0 control register 1 (0x4BF00024)
 ******************************************************************************
 */
///@{
#define DMA_CH0B_w                                  ((uint32_t)0x4BF00024)  /*!< Reg Absolute Address */
#define DMA_CH0B_h0                                 ((uint32_t)0x4BF00024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0B_h1                                 ((uint32_t)0x4BF00026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0B_b0                                 ((uint32_t)0x4BF00024)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0B_b1                                 ((uint32_t)0x4BF00025)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0B_b2                                 ((uint32_t)0x4BF00026)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0B_b3                                 ((uint32_t)0x4BF00027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0NUM  [register's definitions]
 *              Offset[0x28]  DMA channel-0 control register 1 (0x4BF00028)
 ******************************************************************************
 */
///@{
#define DMA_CH0NUM_w                                ((uint32_t)0x4BF00028)  /*!< Reg Absolute Address */
#define DMA_CH0NUM_h0                               ((uint32_t)0x4BF00028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0NUM_h1                               ((uint32_t)0x4BF0002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0NUM_b0                               ((uint32_t)0x4BF00028)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0NUM_b1                               ((uint32_t)0x4BF00029)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0NUM_b2                               ((uint32_t)0x4BF0002A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0NUM_b3                               ((uint32_t)0x4BF0002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0CNT  [register's definitions]
 *              Offset[0x2C]  DMA channel-0 control register 1 (0x4BF0002C)
 ******************************************************************************
 */
///@{
#define DMA_CH0CNT_w                                ((uint32_t)0x4BF0002C)  /*!< Reg Absolute Address */
#define DMA_CH0CNT_h0                               ((uint32_t)0x4BF0002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0CNT_h1                               ((uint32_t)0x4BF0002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0CNT_b0                               ((uint32_t)0x4BF0002C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0CNT_b1                               ((uint32_t)0x4BF0002D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0CNT_b2                               ((uint32_t)0x4BF0002E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0CNT_b3                               ((uint32_t)0x4BF0002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SSA  [register's definitions]
 *              Offset[0x30]  DMA channel-0 source start address register (0x4BF00030)
 ******************************************************************************
 */
///@{
#define DMA_CH0SSA_w                                ((uint32_t)0x4BF00030)  /*!< Reg Absolute Address */
#define DMA_CH0SSA_h0                               ((uint32_t)0x4BF00030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0SSA_h1                               ((uint32_t)0x4BF00032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0SSA_b0                               ((uint32_t)0x4BF00030)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0SSA_b1                               ((uint32_t)0x4BF00031)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0SSA_b2                               ((uint32_t)0x4BF00032)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0SSA_b3                               ((uint32_t)0x4BF00033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SCA  [register's definitions]
 *              Offset[0x34]  DMA channel-0 source current address register (0x4BF00034)
 ******************************************************************************
 */
///@{
#define DMA_CH0SCA_w                                ((uint32_t)0x4BF00034)  /*!< Reg Absolute Address */
#define DMA_CH0SCA_h0                               ((uint32_t)0x4BF00034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0SCA_h1                               ((uint32_t)0x4BF00036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0SCA_b0                               ((uint32_t)0x4BF00034)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0SCA_b1                               ((uint32_t)0x4BF00035)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0SCA_b2                               ((uint32_t)0x4BF00036)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0SCA_b3                               ((uint32_t)0x4BF00037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DSA  [register's definitions]
 *              Offset[0x38]  DMA channel-0 destination start address register (0x4BF00038)
 ******************************************************************************
 */
///@{
#define DMA_CH0DSA_w                                ((uint32_t)0x4BF00038)  /*!< Reg Absolute Address */
#define DMA_CH0DSA_h0                               ((uint32_t)0x4BF00038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0DSA_h1                               ((uint32_t)0x4BF0003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0DSA_b0                               ((uint32_t)0x4BF00038)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0DSA_b1                               ((uint32_t)0x4BF00039)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0DSA_b2                               ((uint32_t)0x4BF0003A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0DSA_b3                               ((uint32_t)0x4BF0003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DCA  [register's definitions]
 *              Offset[0x3C]  DMA channel-0 destination current address register (0x4BF0003C)
 ******************************************************************************
 */
///@{
#define DMA_CH0DCA_w                                ((uint32_t)0x4BF0003C)  /*!< Reg Absolute Address */
#define DMA_CH0DCA_h0                               ((uint32_t)0x4BF0003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH0DCA_h1                               ((uint32_t)0x4BF0003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH0DCA_b0                               ((uint32_t)0x4BF0003C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH0DCA_b1                               ((uint32_t)0x4BF0003D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH0DCA_b2                               ((uint32_t)0x4BF0003E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH0DCA_b3                               ((uint32_t)0x4BF0003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1A  [register's definitions]
 *              Offset[0x40]  DMA channel-1 control register 0 (0x4BF00040)
 ******************************************************************************
 */
///@{
#define DMA_CH1A_w                                  ((uint32_t)0x4BF00040)  /*!< Reg Absolute Address */
#define DMA_CH1A_h0                                 ((uint32_t)0x4BF00040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1A_h1                                 ((uint32_t)0x4BF00042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1A_b0                                 ((uint32_t)0x4BF00040)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1A_b1                                 ((uint32_t)0x4BF00041)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1A_b2                                 ((uint32_t)0x4BF00042)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1A_b3                                 ((uint32_t)0x4BF00043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1B  [register's definitions]
 *              Offset[0x44]  DMA channel-1 control register 1 (0x4BF00044)
 ******************************************************************************
 */
///@{
#define DMA_CH1B_w                                  ((uint32_t)0x4BF00044)  /*!< Reg Absolute Address */
#define DMA_CH1B_h0                                 ((uint32_t)0x4BF00044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1B_h1                                 ((uint32_t)0x4BF00046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1B_b0                                 ((uint32_t)0x4BF00044)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1B_b1                                 ((uint32_t)0x4BF00045)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1B_b2                                 ((uint32_t)0x4BF00046)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1B_b3                                 ((uint32_t)0x4BF00047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1NUM  [register's definitions]
 *              Offset[0x48]  DMA channel-1 control register 1 (0x4BF00048)
 ******************************************************************************
 */
///@{
#define DMA_CH1NUM_w                                ((uint32_t)0x4BF00048)  /*!< Reg Absolute Address */
#define DMA_CH1NUM_h0                               ((uint32_t)0x4BF00048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1NUM_h1                               ((uint32_t)0x4BF0004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1NUM_b0                               ((uint32_t)0x4BF00048)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1NUM_b1                               ((uint32_t)0x4BF00049)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1NUM_b2                               ((uint32_t)0x4BF0004A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1NUM_b3                               ((uint32_t)0x4BF0004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1CNT  [register's definitions]
 *              Offset[0x4C]  DMA channel-1 control register 1 (0x4BF0004C)
 ******************************************************************************
 */
///@{
#define DMA_CH1CNT_w                                ((uint32_t)0x4BF0004C)  /*!< Reg Absolute Address */
#define DMA_CH1CNT_h0                               ((uint32_t)0x4BF0004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1CNT_h1                               ((uint32_t)0x4BF0004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1CNT_b0                               ((uint32_t)0x4BF0004C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1CNT_b1                               ((uint32_t)0x4BF0004D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1CNT_b2                               ((uint32_t)0x4BF0004E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1CNT_b3                               ((uint32_t)0x4BF0004F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SSA  [register's definitions]
 *              Offset[0x50]  DMA channel-1 source start address register (0x4BF00050)
 ******************************************************************************
 */
///@{
#define DMA_CH1SSA_w                                ((uint32_t)0x4BF00050)  /*!< Reg Absolute Address */
#define DMA_CH1SSA_h0                               ((uint32_t)0x4BF00050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1SSA_h1                               ((uint32_t)0x4BF00052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1SSA_b0                               ((uint32_t)0x4BF00050)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1SSA_b1                               ((uint32_t)0x4BF00051)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1SSA_b2                               ((uint32_t)0x4BF00052)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1SSA_b3                               ((uint32_t)0x4BF00053)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SCA  [register's definitions]
 *              Offset[0x54]  DMA channel-1 source current address register (0x4BF00054)
 ******************************************************************************
 */
///@{
#define DMA_CH1SCA_w                                ((uint32_t)0x4BF00054)  /*!< Reg Absolute Address */
#define DMA_CH1SCA_h0                               ((uint32_t)0x4BF00054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1SCA_h1                               ((uint32_t)0x4BF00056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1SCA_b0                               ((uint32_t)0x4BF00054)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1SCA_b1                               ((uint32_t)0x4BF00055)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1SCA_b2                               ((uint32_t)0x4BF00056)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1SCA_b3                               ((uint32_t)0x4BF00057)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DSA  [register's definitions]
 *              Offset[0x58]  DMA channel-1 destination start address register (0x4BF00058)
 ******************************************************************************
 */
///@{
#define DMA_CH1DSA_w                                ((uint32_t)0x4BF00058)  /*!< Reg Absolute Address */
#define DMA_CH1DSA_h0                               ((uint32_t)0x4BF00058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1DSA_h1                               ((uint32_t)0x4BF0005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1DSA_b0                               ((uint32_t)0x4BF00058)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1DSA_b1                               ((uint32_t)0x4BF00059)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1DSA_b2                               ((uint32_t)0x4BF0005A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1DSA_b3                               ((uint32_t)0x4BF0005B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DCA  [register's definitions]
 *              Offset[0x5C]  DMA channel-1 destination current address register (0x4BF0005C)
 ******************************************************************************
 */
///@{
#define DMA_CH1DCA_w                                ((uint32_t)0x4BF0005C)  /*!< Reg Absolute Address */
#define DMA_CH1DCA_h0                               ((uint32_t)0x4BF0005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH1DCA_h1                               ((uint32_t)0x4BF0005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH1DCA_b0                               ((uint32_t)0x4BF0005C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH1DCA_b1                               ((uint32_t)0x4BF0005D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH1DCA_b2                               ((uint32_t)0x4BF0005E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH1DCA_b3                               ((uint32_t)0x4BF0005F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2A  [register's definitions]
 *              Offset[0x60]  DMA channel-2 control register 0 (0x4BF00060)
 ******************************************************************************
 */
///@{
#define DMA_CH2A_w                                  ((uint32_t)0x4BF00060)  /*!< Reg Absolute Address */
#define DMA_CH2A_h0                                 ((uint32_t)0x4BF00060)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2A_h1                                 ((uint32_t)0x4BF00062)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2A_b0                                 ((uint32_t)0x4BF00060)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2A_b1                                 ((uint32_t)0x4BF00061)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2A_b2                                 ((uint32_t)0x4BF00062)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2A_b3                                 ((uint32_t)0x4BF00063)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2B  [register's definitions]
 *              Offset[0x64]  DMA channel-2 control register 1 (0x4BF00064)
 ******************************************************************************
 */
///@{
#define DMA_CH2B_w                                  ((uint32_t)0x4BF00064)  /*!< Reg Absolute Address */
#define DMA_CH2B_h0                                 ((uint32_t)0x4BF00064)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2B_h1                                 ((uint32_t)0x4BF00066)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2B_b0                                 ((uint32_t)0x4BF00064)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2B_b1                                 ((uint32_t)0x4BF00065)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2B_b2                                 ((uint32_t)0x4BF00066)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2B_b3                                 ((uint32_t)0x4BF00067)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2NUM  [register's definitions]
 *              Offset[0x68]  DMA channel-2 control register 1 (0x4BF00068)
 ******************************************************************************
 */
///@{
#define DMA_CH2NUM_w                                ((uint32_t)0x4BF00068)  /*!< Reg Absolute Address */
#define DMA_CH2NUM_h0                               ((uint32_t)0x4BF00068)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2NUM_h1                               ((uint32_t)0x4BF0006A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2NUM_b0                               ((uint32_t)0x4BF00068)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2NUM_b1                               ((uint32_t)0x4BF00069)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2NUM_b2                               ((uint32_t)0x4BF0006A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2NUM_b3                               ((uint32_t)0x4BF0006B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2CNT  [register's definitions]
 *              Offset[0x6C]  DMA channel-2 control register 1 (0x4BF0006C)
 ******************************************************************************
 */
///@{
#define DMA_CH2CNT_w                                ((uint32_t)0x4BF0006C)  /*!< Reg Absolute Address */
#define DMA_CH2CNT_h0                               ((uint32_t)0x4BF0006C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2CNT_h1                               ((uint32_t)0x4BF0006E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2CNT_b0                               ((uint32_t)0x4BF0006C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2CNT_b1                               ((uint32_t)0x4BF0006D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2CNT_b2                               ((uint32_t)0x4BF0006E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2CNT_b3                               ((uint32_t)0x4BF0006F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SSA  [register's definitions]
 *              Offset[0x70]  DMA channel-2 source start address register (0x4BF00070)
 ******************************************************************************
 */
///@{
#define DMA_CH2SSA_w                                ((uint32_t)0x4BF00070)  /*!< Reg Absolute Address */
#define DMA_CH2SSA_h0                               ((uint32_t)0x4BF00070)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2SSA_h1                               ((uint32_t)0x4BF00072)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2SSA_b0                               ((uint32_t)0x4BF00070)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2SSA_b1                               ((uint32_t)0x4BF00071)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2SSA_b2                               ((uint32_t)0x4BF00072)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2SSA_b3                               ((uint32_t)0x4BF00073)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SCA  [register's definitions]
 *              Offset[0x74]  DMA channel-2 source current address register (0x4BF00074)
 ******************************************************************************
 */
///@{
#define DMA_CH2SCA_w                                ((uint32_t)0x4BF00074)  /*!< Reg Absolute Address */
#define DMA_CH2SCA_h0                               ((uint32_t)0x4BF00074)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2SCA_h1                               ((uint32_t)0x4BF00076)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2SCA_b0                               ((uint32_t)0x4BF00074)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2SCA_b1                               ((uint32_t)0x4BF00075)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2SCA_b2                               ((uint32_t)0x4BF00076)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2SCA_b3                               ((uint32_t)0x4BF00077)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DSA  [register's definitions]
 *              Offset[0x78]  DMA channel-2 destination start address register (0x4BF00078)
 ******************************************************************************
 */
///@{
#define DMA_CH2DSA_w                                ((uint32_t)0x4BF00078)  /*!< Reg Absolute Address */
#define DMA_CH2DSA_h0                               ((uint32_t)0x4BF00078)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2DSA_h1                               ((uint32_t)0x4BF0007A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2DSA_b0                               ((uint32_t)0x4BF00078)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2DSA_b1                               ((uint32_t)0x4BF00079)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2DSA_b2                               ((uint32_t)0x4BF0007A)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2DSA_b3                               ((uint32_t)0x4BF0007B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DCA  [register's definitions]
 *              Offset[0x7C]  DMA channel-2 destination current address register (0x4BF0007C)
 ******************************************************************************
 */
///@{
#define DMA_CH2DCA_w                                ((uint32_t)0x4BF0007C)  /*!< Reg Absolute Address */
#define DMA_CH2DCA_h0                               ((uint32_t)0x4BF0007C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DMA_CH2DCA_h1                               ((uint32_t)0x4BF0007E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DMA_CH2DCA_b0                               ((uint32_t)0x4BF0007C)  /*!< Reg Absolute Address of [Byte-0] */
#define DMA_CH2DCA_b1                               ((uint32_t)0x4BF0007D)  /*!< Reg Absolute Address of [Byte-1] */
#define DMA_CH2DCA_b2                               ((uint32_t)0x4BF0007E)  /*!< Reg Absolute Address of [Byte-2] */
#define DMA_CH2DCA_b3                               ((uint32_t)0x4BF0007F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      RST (Reset Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        RST_STA  [register's definitions]
 *              Offset[0x00]  RST Reset status register (0x4C000000)
 ******************************************************************************
 */
///@{
#define RST_STA_w                                   ((uint32_t)0x4C000000)  /*!< Reg Absolute Address */
#define RST_STA_h0                                  ((uint32_t)0x4C000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_STA_h1                                  ((uint32_t)0x4C000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_STA_b0                                  ((uint32_t)0x4C000000)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_STA_b1                                  ((uint32_t)0x4C000001)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_STA_b2                                  ((uint32_t)0x4C000002)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_STA_b3                                  ((uint32_t)0x4C000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_KEY  [register's definitions]
 *              Offset[0x0C]  RST write protected Key register (0x4C00000C)
 ******************************************************************************
 */
///@{
#define RST_KEY_w                                   ((uint32_t)0x4C00000C)  /*!< Reg Absolute Address */
#define RST_KEY_h0                                  ((uint32_t)0x4C00000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_KEY_h1                                  ((uint32_t)0x4C00000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_KEY_b0                                  ((uint32_t)0x4C00000C)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_KEY_b1                                  ((uint32_t)0x4C00000D)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_KEY_b2                                  ((uint32_t)0x4C00000E)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_KEY_b3                                  ((uint32_t)0x4C00000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_CR0  [register's definitions]
 *              Offset[0x10]  RST control register 0 (0x4C000010)
 ******************************************************************************
 */
///@{
#define RST_CR0_w                                   ((uint32_t)0x4C000010)  /*!< Reg Absolute Address */
#define RST_CR0_h0                                  ((uint32_t)0x4C000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_CR0_h1                                  ((uint32_t)0x4C000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_CR0_b0                                  ((uint32_t)0x4C000010)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_CR0_b1                                  ((uint32_t)0x4C000011)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_CR0_b2                                  ((uint32_t)0x4C000012)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_CR0_b3                                  ((uint32_t)0x4C000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_CE  [register's definitions]
 *              Offset[0x14]  RST Cold reset enable register (0x4C000014)
 ******************************************************************************
 */
///@{
#define RST_CE_w                                    ((uint32_t)0x4C000014)  /*!< Reg Absolute Address */
#define RST_CE_h0                                   ((uint32_t)0x4C000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_CE_h1                                   ((uint32_t)0x4C000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_CE_b0                                   ((uint32_t)0x4C000014)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_CE_b1                                   ((uint32_t)0x4C000015)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_CE_b2                                   ((uint32_t)0x4C000016)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_CE_b3                                   ((uint32_t)0x4C000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_WE  [register's definitions]
 *              Offset[0x18]  RST Warm reset enable register (0x4C000018)
 ******************************************************************************
 */
///@{
#define RST_WE_w                                    ((uint32_t)0x4C000018)  /*!< Reg Absolute Address */
#define RST_WE_h0                                   ((uint32_t)0x4C000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_WE_h1                                   ((uint32_t)0x4C00001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_WE_b0                                   ((uint32_t)0x4C000018)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_WE_b1                                   ((uint32_t)0x4C000019)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_WE_b2                                   ((uint32_t)0x4C00001A)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_WE_b3                                   ((uint32_t)0x4C00001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_AHB  [register's definitions]
 *              Offset[0x1C]  RST AHB reset register (0x4C00001C)
 ******************************************************************************
 */
///@{
#define RST_AHB_w                                   ((uint32_t)0x4C00001C)  /*!< Reg Absolute Address */
#define RST_AHB_h0                                  ((uint32_t)0x4C00001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_AHB_h1                                  ((uint32_t)0x4C00001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_AHB_b0                                  ((uint32_t)0x4C00001C)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_AHB_b1                                  ((uint32_t)0x4C00001D)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_AHB_b2                                  ((uint32_t)0x4C00001E)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_AHB_b3                                  ((uint32_t)0x4C00001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_APB0  [register's definitions]
 *              Offset[0x20]  RST APB reset register 0 (0x4C000020)
 ******************************************************************************
 */
///@{
#define RST_APB0_w                                  ((uint32_t)0x4C000020)  /*!< Reg Absolute Address */
#define RST_APB0_h0                                 ((uint32_t)0x4C000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_APB0_h1                                 ((uint32_t)0x4C000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_APB0_b0                                 ((uint32_t)0x4C000020)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_APB0_b1                                 ((uint32_t)0x4C000021)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_APB0_b2                                 ((uint32_t)0x4C000022)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_APB0_b3                                 ((uint32_t)0x4C000023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RST_APB1  [register's definitions]
 *              Offset[0x24]  RST APB reset register 1 (0x4C000024)
 ******************************************************************************
 */
///@{
#define RST_APB1_w                                  ((uint32_t)0x4C000024)  /*!< Reg Absolute Address */
#define RST_APB1_h0                                 ((uint32_t)0x4C000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RST_APB1_h1                                 ((uint32_t)0x4C000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RST_APB1_b0                                 ((uint32_t)0x4C000024)  /*!< Reg Absolute Address of [Byte-0] */
#define RST_APB1_b1                                 ((uint32_t)0x4C000025)  /*!< Reg Absolute Address of [Byte-1] */
#define RST_APB1_b2                                 ((uint32_t)0x4C000026)  /*!< Reg Absolute Address of [Byte-2] */
#define RST_APB1_b3                                 ((uint32_t)0x4C000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      CSC (Clock Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CSC_STA  [register's definitions]
 *              Offset[0x00]  CSC status register (0x4C010000)
 ******************************************************************************
 */
///@{
#define CSC_STA_w                                   ((uint32_t)0x4C010000)  /*!< Reg Absolute Address */
#define CSC_STA_h0                                  ((uint32_t)0x4C010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_STA_h1                                  ((uint32_t)0x4C010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_STA_b0                                  ((uint32_t)0x4C010000)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_STA_b1                                  ((uint32_t)0x4C010001)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_STA_b2                                  ((uint32_t)0x4C010002)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_STA_b3                                  ((uint32_t)0x4C010003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_INT  [register's definitions]
 *              Offset[0x04]  CSC interrupt enable register (0x4C010004)
 ******************************************************************************
 */
///@{
#define CSC_INT_w                                   ((uint32_t)0x4C010004)  /*!< Reg Absolute Address */
#define CSC_INT_h0                                  ((uint32_t)0x4C010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_INT_h1                                  ((uint32_t)0x4C010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_INT_b0                                  ((uint32_t)0x4C010004)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_INT_b1                                  ((uint32_t)0x4C010005)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_INT_b2                                  ((uint32_t)0x4C010006)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_INT_b3                                  ((uint32_t)0x4C010007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_PLL  [register's definitions]
 *              Offset[0x08]  CSC OSC and PLL control register (0x4C010008)
 ******************************************************************************
 */
///@{
#define CSC_PLL_w                                   ((uint32_t)0x4C010008)  /*!< Reg Absolute Address */
#define CSC_PLL_h0                                  ((uint32_t)0x4C010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_PLL_h1                                  ((uint32_t)0x4C01000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_PLL_b0                                  ((uint32_t)0x4C010008)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_PLL_b1                                  ((uint32_t)0x4C010009)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_PLL_b2                                  ((uint32_t)0x4C01000A)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_PLL_b3                                  ((uint32_t)0x4C01000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_KEY  [register's definitions]
 *              Offset[0x0C]  CSC write protected Key register (0x4C01000C)
 ******************************************************************************
 */
///@{
#define CSC_KEY_w                                   ((uint32_t)0x4C01000C)  /*!< Reg Absolute Address */
#define CSC_KEY_h0                                  ((uint32_t)0x4C01000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_KEY_h1                                  ((uint32_t)0x4C01000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_KEY_b0                                  ((uint32_t)0x4C01000C)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_KEY_b1                                  ((uint32_t)0x4C01000D)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_KEY_b2                                  ((uint32_t)0x4C01000E)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_KEY_b3                                  ((uint32_t)0x4C01000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_CR0  [register's definitions]
 *              Offset[0x10]  CSC clock source control register 0 (0x4C010010)
 ******************************************************************************
 */
///@{
#define CSC_CR0_w                                   ((uint32_t)0x4C010010)  /*!< Reg Absolute Address */
#define CSC_CR0_h0                                  ((uint32_t)0x4C010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_CR0_h1                                  ((uint32_t)0x4C010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_CR0_b0                                  ((uint32_t)0x4C010010)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_CR0_b1                                  ((uint32_t)0x4C010011)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_CR0_b2                                  ((uint32_t)0x4C010012)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_CR0_b3                                  ((uint32_t)0x4C010013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_DIV  [register's definitions]
 *              Offset[0x14]  CSC clock  divider register (0x4C010014)
 ******************************************************************************
 */
///@{
#define CSC_DIV_w                                   ((uint32_t)0x4C010014)  /*!< Reg Absolute Address */
#define CSC_DIV_h0                                  ((uint32_t)0x4C010014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_DIV_h1                                  ((uint32_t)0x4C010016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_DIV_b0                                  ((uint32_t)0x4C010014)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_DIV_b1                                  ((uint32_t)0x4C010015)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_DIV_b2                                  ((uint32_t)0x4C010016)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_DIV_b3                                  ((uint32_t)0x4C010017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_CKO  [register's definitions]
 *              Offset[0x18]  CSC internal clock output control register (0x4C010018)
 ******************************************************************************
 */
///@{
#define CSC_CKO_w                                   ((uint32_t)0x4C010018)  /*!< Reg Absolute Address */
#define CSC_CKO_h0                                  ((uint32_t)0x4C010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_CKO_h1                                  ((uint32_t)0x4C01001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_CKO_b0                                  ((uint32_t)0x4C010018)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_CKO_b1                                  ((uint32_t)0x4C010019)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_CKO_b2                                  ((uint32_t)0x4C01001A)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_CKO_b3                                  ((uint32_t)0x4C01001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_AHB  [register's definitions]
 *              Offset[0x1C]  CSC AHB clock control register (0x4C01001C)
 ******************************************************************************
 */
///@{
#define CSC_AHB_w                                   ((uint32_t)0x4C01001C)  /*!< Reg Absolute Address */
#define CSC_AHB_h0                                  ((uint32_t)0x4C01001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_AHB_h1                                  ((uint32_t)0x4C01001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_AHB_b0                                  ((uint32_t)0x4C01001C)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_AHB_b1                                  ((uint32_t)0x4C01001D)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_AHB_b2                                  ((uint32_t)0x4C01001E)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_AHB_b3                                  ((uint32_t)0x4C01001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_APB0  [register's definitions]
 *              Offset[0x20]  CSC APB clock control register 0 (0x4C010020)
 ******************************************************************************
 */
///@{
#define CSC_APB0_w                                  ((uint32_t)0x4C010020)  /*!< Reg Absolute Address */
#define CSC_APB0_h0                                 ((uint32_t)0x4C010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_APB0_h1                                 ((uint32_t)0x4C010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_APB0_b0                                 ((uint32_t)0x4C010020)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_APB0_b1                                 ((uint32_t)0x4C010021)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_APB0_b2                                 ((uint32_t)0x4C010022)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_APB0_b3                                 ((uint32_t)0x4C010023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_APB1  [register's definitions]
 *              Offset[0x24]  CSC APB clock control register 1 (0x4C010024)
 ******************************************************************************
 */
///@{
#define CSC_APB1_w                                  ((uint32_t)0x4C010024)  /*!< Reg Absolute Address */
#define CSC_APB1_h0                                 ((uint32_t)0x4C010024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_APB1_h1                                 ((uint32_t)0x4C010026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_APB1_b0                                 ((uint32_t)0x4C010024)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_APB1_b1                                 ((uint32_t)0x4C010025)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_APB1_b2                                 ((uint32_t)0x4C010026)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_APB1_b3                                 ((uint32_t)0x4C010027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_SLP0  [register's definitions]
 *              Offset[0x30]  CSC SLEEP mode clock enable register 0 (0x4C010030)
 ******************************************************************************
 */
///@{
#define CSC_SLP0_w                                  ((uint32_t)0x4C010030)  /*!< Reg Absolute Address */
#define CSC_SLP0_h0                                 ((uint32_t)0x4C010030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_SLP0_h1                                 ((uint32_t)0x4C010032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_SLP0_b0                                 ((uint32_t)0x4C010030)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_SLP0_b1                                 ((uint32_t)0x4C010031)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_SLP0_b2                                 ((uint32_t)0x4C010032)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_SLP0_b3                                 ((uint32_t)0x4C010033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_SLP1  [register's definitions]
 *              Offset[0x34]  CSC SLEEP mode clock enable register 1 (0x4C010034)
 ******************************************************************************
 */
///@{
#define CSC_SLP1_w                                  ((uint32_t)0x4C010034)  /*!< Reg Absolute Address */
#define CSC_SLP1_h0                                 ((uint32_t)0x4C010034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_SLP1_h1                                 ((uint32_t)0x4C010036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_SLP1_b0                                 ((uint32_t)0x4C010034)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_SLP1_b1                                 ((uint32_t)0x4C010035)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_SLP1_b2                                 ((uint32_t)0x4C010036)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_SLP1_b3                                 ((uint32_t)0x4C010037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_STP0  [register's definitions]
 *              Offset[0x38]  CSC STOP mode clock enable register 0 (0x4C010038)
 ******************************************************************************
 */
///@{
#define CSC_STP0_w                                  ((uint32_t)0x4C010038)  /*!< Reg Absolute Address */
#define CSC_STP0_h0                                 ((uint32_t)0x4C010038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_STP0_h1                                 ((uint32_t)0x4C01003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_STP0_b0                                 ((uint32_t)0x4C010038)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_STP0_b1                                 ((uint32_t)0x4C010039)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_STP0_b2                                 ((uint32_t)0x4C01003A)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_STP0_b3                                 ((uint32_t)0x4C01003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS0  [register's definitions]
 *              Offset[0x40]  CSC clock source select register 0 (0x4C010040)
 ******************************************************************************
 */
///@{
#define CSC_CKS0_w                                  ((uint32_t)0x4C010040)  /*!< Reg Absolute Address */
#define CSC_CKS0_h0                                 ((uint32_t)0x4C010040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_CKS0_h1                                 ((uint32_t)0x4C010042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_CKS0_b0                                 ((uint32_t)0x4C010040)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_CKS0_b1                                 ((uint32_t)0x4C010041)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_CKS0_b2                                 ((uint32_t)0x4C010042)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_CKS0_b3                                 ((uint32_t)0x4C010043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS1  [register's definitions]
 *              Offset[0x44]  CSC clock source select register 1 (0x4C010044)
 ******************************************************************************
 */
///@{
#define CSC_CKS1_w                                  ((uint32_t)0x4C010044)  /*!< Reg Absolute Address */
#define CSC_CKS1_h0                                 ((uint32_t)0x4C010044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_CKS1_h1                                 ((uint32_t)0x4C010046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_CKS1_b0                                 ((uint32_t)0x4C010044)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_CKS1_b1                                 ((uint32_t)0x4C010045)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_CKS1_b2                                 ((uint32_t)0x4C010046)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_CKS1_b3                                 ((uint32_t)0x4C010047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS2  [register's definitions]
 *              Offset[0x48]  CSC clock source select register 2 (0x4C010048)
 ******************************************************************************
 */
///@{
#define CSC_CKS2_w                                  ((uint32_t)0x4C010048)  /*!< Reg Absolute Address */
#define CSC_CKS2_h0                                 ((uint32_t)0x4C010048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CSC_CKS2_h1                                 ((uint32_t)0x4C01004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CSC_CKS2_b0                                 ((uint32_t)0x4C010048)  /*!< Reg Absolute Address of [Byte-0] */
#define CSC_CKS2_b1                                 ((uint32_t)0x4C010049)  /*!< Reg Absolute Address of [Byte-1] */
#define CSC_CKS2_b2                                 ((uint32_t)0x4C01004A)  /*!< Reg Absolute Address of [Byte-2] */
#define CSC_CKS2_b3                                 ((uint32_t)0x4C01004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      PW (Power Control)                                            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PW_STA  [register's definitions]
 *              Offset[0x00]  PW status register (0x4C020000)
 ******************************************************************************
 */
///@{
#define PW_STA_w                                    ((uint32_t)0x4C020000)  /*!< Reg Absolute Address */
#define PW_STA_h0                                   ((uint32_t)0x4C020000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_STA_h1                                   ((uint32_t)0x4C020002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_STA_b0                                   ((uint32_t)0x4C020000)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_STA_b1                                   ((uint32_t)0x4C020001)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_STA_b2                                   ((uint32_t)0x4C020002)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_STA_b3                                   ((uint32_t)0x4C020003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_INT  [register's definitions]
 *              Offset[0x04]  PW interrupt enable register (0x4C020004)
 ******************************************************************************
 */
///@{
#define PW_INT_w                                    ((uint32_t)0x4C020004)  /*!< Reg Absolute Address */
#define PW_INT_h0                                   ((uint32_t)0x4C020004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_INT_h1                                   ((uint32_t)0x4C020006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_INT_b0                                   ((uint32_t)0x4C020004)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_INT_b1                                   ((uint32_t)0x4C020005)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_INT_b2                                   ((uint32_t)0x4C020006)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_INT_b3                                   ((uint32_t)0x4C020007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_KEY  [register's definitions]
 *              Offset[0x0C]  PW write protected Key register (0x4C02000C)
 ******************************************************************************
 */
///@{
#define PW_KEY_w                                    ((uint32_t)0x4C02000C)  /*!< Reg Absolute Address */
#define PW_KEY_h0                                   ((uint32_t)0x4C02000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_KEY_h1                                   ((uint32_t)0x4C02000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_KEY_b0                                   ((uint32_t)0x4C02000C)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_KEY_b1                                   ((uint32_t)0x4C02000D)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_KEY_b2                                   ((uint32_t)0x4C02000E)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_KEY_b3                                   ((uint32_t)0x4C02000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_CR0  [register's definitions]
 *              Offset[0x10]  PW control register 0 (0x4C020010)
 ******************************************************************************
 */
///@{
#define PW_CR0_w                                    ((uint32_t)0x4C020010)  /*!< Reg Absolute Address */
#define PW_CR0_h0                                   ((uint32_t)0x4C020010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_CR0_h1                                   ((uint32_t)0x4C020012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_CR0_b0                                   ((uint32_t)0x4C020010)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_CR0_b1                                   ((uint32_t)0x4C020011)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_CR0_b2                                   ((uint32_t)0x4C020012)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_CR0_b3                                   ((uint32_t)0x4C020013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_CR1  [register's definitions]
 *              Offset[0x14]  PW control register 1 (0x4C020014)
 ******************************************************************************
 */
///@{
#define PW_CR1_w                                    ((uint32_t)0x4C020014)  /*!< Reg Absolute Address */
#define PW_CR1_h0                                   ((uint32_t)0x4C020014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_CR1_h1                                   ((uint32_t)0x4C020016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_CR1_b0                                   ((uint32_t)0x4C020014)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_CR1_b1                                   ((uint32_t)0x4C020015)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_CR1_b2                                   ((uint32_t)0x4C020016)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_CR1_b3                                   ((uint32_t)0x4C020017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP0  [register's definitions]
 *              Offset[0x18]  PW STOP mode wakeup control register 0 (0x4C020018)
 ******************************************************************************
 */
///@{
#define PW_WKSTP0_w                                 ((uint32_t)0x4C020018)  /*!< Reg Absolute Address */
#define PW_WKSTP0_h0                                ((uint32_t)0x4C020018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_WKSTP0_h1                                ((uint32_t)0x4C02001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_WKSTP0_b0                                ((uint32_t)0x4C020018)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_WKSTP0_b1                                ((uint32_t)0x4C020019)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_WKSTP0_b2                                ((uint32_t)0x4C02001A)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_WKSTP0_b3                                ((uint32_t)0x4C02001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP1  [register's definitions]
 *              Offset[0x1C]  PW STOP mode wakeup control register 1 (0x4C02001C)
 ******************************************************************************
 */
///@{
#define PW_WKSTP1_w                                 ((uint32_t)0x4C02001C)  /*!< Reg Absolute Address */
#define PW_WKSTP1_h0                                ((uint32_t)0x4C02001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define PW_WKSTP1_h1                                ((uint32_t)0x4C02001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define PW_WKSTP1_b0                                ((uint32_t)0x4C02001C)  /*!< Reg Absolute Address of [Byte-0] */
#define PW_WKSTP1_b1                                ((uint32_t)0x4C02001D)  /*!< Reg Absolute Address of [Byte-1] */
#define PW_WKSTP1_b2                                ((uint32_t)0x4C02001E)  /*!< Reg Absolute Address of [Byte-2] */
#define PW_WKSTP1_b3                                ((uint32_t)0x4C02001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      SYS (System Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        SYS_INT  [register's definitions]
 *              Offset[0x04]  SYS interrupt enable register (0x4C030004)
 ******************************************************************************
 */
///@{
#define SYS_INT_w                                   ((uint32_t)0x4C030004)  /*!< Reg Absolute Address */
#define SYS_INT_h0                                  ((uint32_t)0x4C030004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SYS_INT_h1                                  ((uint32_t)0x4C030006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SYS_INT_b0                                  ((uint32_t)0x4C030004)  /*!< Reg Absolute Address of [Byte-0] */
#define SYS_INT_b1                                  ((uint32_t)0x4C030005)  /*!< Reg Absolute Address of [Byte-1] */
#define SYS_INT_b2                                  ((uint32_t)0x4C030006)  /*!< Reg Absolute Address of [Byte-2] */
#define SYS_INT_b3                                  ((uint32_t)0x4C030007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SYS_MID  [register's definitions]
 *              Offset[0x0C]  SYS chip manufacture identification code (0x4C03000C)
 ******************************************************************************
 */
///@{
#define SYS_MID_w                                   ((uint32_t)0x4C03000C)  /*!< Reg Absolute Address */
#define SYS_MID_h0                                  ((uint32_t)0x4C03000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SYS_MID_h1                                  ((uint32_t)0x4C03000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SYS_MID_b0                                  ((uint32_t)0x4C03000C)  /*!< Reg Absolute Address of [Byte-0] */
#define SYS_MID_b1                                  ((uint32_t)0x4C03000D)  /*!< Reg Absolute Address of [Byte-1] */
#define SYS_MID_b2                                  ((uint32_t)0x4C03000E)  /*!< Reg Absolute Address of [Byte-2] */
#define SYS_MID_b3                                  ((uint32_t)0x4C03000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SYS_CR0  [register's definitions]
 *              Offset[0x10]  SYS System control register 0 (0x4C030010)
 ******************************************************************************
 */
///@{
#define SYS_CR0_w                                   ((uint32_t)0x4C030010)  /*!< Reg Absolute Address */
#define SYS_CR0_h0                                  ((uint32_t)0x4C030010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SYS_CR0_h1                                  ((uint32_t)0x4C030012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SYS_CR0_b0                                  ((uint32_t)0x4C030010)  /*!< Reg Absolute Address of [Byte-0] */
#define SYS_CR0_b1                                  ((uint32_t)0x4C030011)  /*!< Reg Absolute Address of [Byte-1] */
#define SYS_CR0_b2                                  ((uint32_t)0x4C030012)  /*!< Reg Absolute Address of [Byte-2] */
#define SYS_CR0_b3                                  ((uint32_t)0x4C030013)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      MEM (Memory Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        MEM_STA  [register's definitions]
 *              Offset[0x00]  MEM status register (0x4D000000)
 ******************************************************************************
 */
///@{
#define MEM_STA_w                                   ((uint32_t)0x4D000000)  /*!< Reg Absolute Address */
#define MEM_STA_h0                                  ((uint32_t)0x4D000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_STA_h1                                  ((uint32_t)0x4D000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_STA_b0                                  ((uint32_t)0x4D000000)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_STA_b1                                  ((uint32_t)0x4D000001)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_STA_b2                                  ((uint32_t)0x4D000002)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_STA_b3                                  ((uint32_t)0x4D000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_INT  [register's definitions]
 *              Offset[0x04]  MEM interrupt enable register (0x4D000004)
 ******************************************************************************
 */
///@{
#define MEM_INT_w                                   ((uint32_t)0x4D000004)  /*!< Reg Absolute Address */
#define MEM_INT_h0                                  ((uint32_t)0x4D000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_INT_h1                                  ((uint32_t)0x4D000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_INT_b0                                  ((uint32_t)0x4D000004)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_INT_b1                                  ((uint32_t)0x4D000005)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_INT_b2                                  ((uint32_t)0x4D000006)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_INT_b3                                  ((uint32_t)0x4D000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_KEY  [register's definitions]
 *              Offset[0x0C]  MEM write protected key register (0x4D00000C)
 ******************************************************************************
 */
///@{
#define MEM_KEY_w                                   ((uint32_t)0x4D00000C)  /*!< Reg Absolute Address */
#define MEM_KEY_h0                                  ((uint32_t)0x4D00000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_KEY_h1                                  ((uint32_t)0x4D00000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_KEY_b0                                  ((uint32_t)0x4D00000C)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_KEY_b1                                  ((uint32_t)0x4D00000D)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_KEY_b2                                  ((uint32_t)0x4D00000E)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_KEY_b3                                  ((uint32_t)0x4D00000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_CR0  [register's definitions]
 *              Offset[0x10]  MEM control register 0 (0x4D000010)
 ******************************************************************************
 */
///@{
#define MEM_CR0_w                                   ((uint32_t)0x4D000010)  /*!< Reg Absolute Address */
#define MEM_CR0_h0                                  ((uint32_t)0x4D000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_CR0_h1                                  ((uint32_t)0x4D000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_CR0_b0                                  ((uint32_t)0x4D000010)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_CR0_b1                                  ((uint32_t)0x4D000011)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_CR0_b2                                  ((uint32_t)0x4D000012)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_CR0_b3                                  ((uint32_t)0x4D000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_CR1  [register's definitions]
 *              Offset[0x14]  MEM control register 1 (0x4D000014)
 ******************************************************************************
 */
///@{
#define MEM_CR1_w                                   ((uint32_t)0x4D000014)  /*!< Reg Absolute Address */
#define MEM_CR1_h0                                  ((uint32_t)0x4D000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_CR1_h1                                  ((uint32_t)0x4D000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_CR1_b0                                  ((uint32_t)0x4D000014)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_CR1_b1                                  ((uint32_t)0x4D000015)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_CR1_b2                                  ((uint32_t)0x4D000016)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_CR1_b3                                  ((uint32_t)0x4D000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_SKEY  [register's definitions]
 *              Offset[0x1C]  MEM Flash memory protected key register (0x4D00001C)
 ******************************************************************************
 */
///@{
#define MEM_SKEY_w                                  ((uint32_t)0x4D00001C)  /*!< Reg Absolute Address */
#define MEM_SKEY_h0                                 ((uint32_t)0x4D00001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_SKEY_h1                                 ((uint32_t)0x4D00001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_SKEY_b0                                 ((uint32_t)0x4D00001C)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_SKEY_b1                                 ((uint32_t)0x4D00001D)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_SKEY_b2                                 ((uint32_t)0x4D00001E)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_SKEY_b3                                 ((uint32_t)0x4D00001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_FADR  [register's definitions]
 *              Offset[0x20]  MEM Flash memory address register (0x4D000020)
 ******************************************************************************
 */
///@{
#define MEM_FADR_w                                  ((uint32_t)0x4D000020)  /*!< Reg Absolute Address */
#define MEM_FADR_h0                                 ((uint32_t)0x4D000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_FADR_h1                                 ((uint32_t)0x4D000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_FADR_b0                                 ((uint32_t)0x4D000020)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_FADR_b1                                 ((uint32_t)0x4D000021)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_FADR_b2                                 ((uint32_t)0x4D000022)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_FADR_b3                                 ((uint32_t)0x4D000023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_FDAT  [register's definitions]
 *              Offset[0x24]  MEM Flash memory data register (0x4D000024)
 ******************************************************************************
 */
///@{
#define MEM_FDAT_w                                  ((uint32_t)0x4D000024)  /*!< Reg Absolute Address */
#define MEM_FDAT_h0                                 ((uint32_t)0x4D000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_FDAT_h1                                 ((uint32_t)0x4D000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_FDAT_b0                                 ((uint32_t)0x4D000024)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_FDAT_b1                                 ((uint32_t)0x4D000025)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_FDAT_b2                                 ((uint32_t)0x4D000026)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_FDAT_b3                                 ((uint32_t)0x4D000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_IAPSZ  [register's definitions]
 *              Offset[0x28]  MEM Flash memory IAP size register (0x4D000028)
 ******************************************************************************
 */
///@{
#define MEM_IAPSZ_w                                 ((uint32_t)0x4D000028)  /*!< Reg Absolute Address */
#define MEM_IAPSZ_h0                                ((uint32_t)0x4D000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_IAPSZ_h1                                ((uint32_t)0x4D00002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_IAPSZ_b0                                ((uint32_t)0x4D000028)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_IAPSZ_b1                                ((uint32_t)0x4D000029)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_IAPSZ_b2                                ((uint32_t)0x4D00002A)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_IAPSZ_b3                                ((uint32_t)0x4D00002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        MEM_MCR  [register's definitions]
 *              Offset[0x2C]  MEM manufacturer control register (0x4D00002C)
 ******************************************************************************
 */
///@{
#define MEM_MCR_w                                   ((uint32_t)0x4D00002C)  /*!< Reg Absolute Address */
#define MEM_MCR_h0                                  ((uint32_t)0x4D00002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define MEM_MCR_h1                                  ((uint32_t)0x4D00002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define MEM_MCR_b0                                  ((uint32_t)0x4D00002C)  /*!< Reg Absolute Address of [Byte-0] */
#define MEM_MCR_b1                                  ((uint32_t)0x4D00002D)  /*!< Reg Absolute Address of [Byte-1] */
#define MEM_MCR_b2                                  ((uint32_t)0x4D00002E)  /*!< Reg Absolute Address of [Byte-2] */
#define MEM_MCR_b3                                  ((uint32_t)0x4D00002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      EMB (Ext Memory Bus)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        EMB_STA  [register's definitions]
 *              Offset[0x00]  EMB status register (0x4D020000)
 ******************************************************************************
 */
///@{
#define EMB_STA_w                                   ((uint32_t)0x4D020000)  /*!< Reg Absolute Address */
#define EMB_STA_h0                                  ((uint32_t)0x4D020000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_STA_h1                                  ((uint32_t)0x4D020002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_STA_b0                                  ((uint32_t)0x4D020000)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_STA_b1                                  ((uint32_t)0x4D020001)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_STA_b2                                  ((uint32_t)0x4D020002)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_STA_b3                                  ((uint32_t)0x4D020003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EMB_INT  [register's definitions]
 *              Offset[0x04]  EMB interrupt enable register (0x4D020004)
 ******************************************************************************
 */
///@{
#define EMB_INT_w                                   ((uint32_t)0x4D020004)  /*!< Reg Absolute Address */
#define EMB_INT_h0                                  ((uint32_t)0x4D020004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_INT_h1                                  ((uint32_t)0x4D020006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_INT_b0                                  ((uint32_t)0x4D020004)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_INT_b1                                  ((uint32_t)0x4D020005)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_INT_b2                                  ((uint32_t)0x4D020006)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_INT_b3                                  ((uint32_t)0x4D020007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EMB_CLK  [register's definitions]
 *              Offset[0x08]  EMB clock source register (0x4D020008)
 ******************************************************************************
 */
///@{
#define EMB_CLK_w                                   ((uint32_t)0x4D020008)  /*!< Reg Absolute Address */
#define EMB_CLK_h0                                  ((uint32_t)0x4D020008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_CLK_h1                                  ((uint32_t)0x4D02000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_CLK_b0                                  ((uint32_t)0x4D020008)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_CLK_b1                                  ((uint32_t)0x4D020009)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_CLK_b2                                  ((uint32_t)0x4D02000A)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_CLK_b3                                  ((uint32_t)0x4D02000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EMB_CR0  [register's definitions]
 *              Offset[0x10]  EMB control register 0 (0x4D020010)
 ******************************************************************************
 */
///@{
#define EMB_CR0_w                                   ((uint32_t)0x4D020010)  /*!< Reg Absolute Address */
#define EMB_CR0_h0                                  ((uint32_t)0x4D020010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_CR0_h1                                  ((uint32_t)0x4D020012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_CR0_b0                                  ((uint32_t)0x4D020010)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_CR0_b1                                  ((uint32_t)0x4D020011)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_CR0_b2                                  ((uint32_t)0x4D020012)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_CR0_b3                                  ((uint32_t)0x4D020013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EMB_CR1  [register's definitions]
 *              Offset[0x14]  EMB control register 1 (0x4D020014)
 ******************************************************************************
 */
///@{
#define EMB_CR1_w                                   ((uint32_t)0x4D020014)  /*!< Reg Absolute Address */
#define EMB_CR1_h0                                  ((uint32_t)0x4D020014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_CR1_h1                                  ((uint32_t)0x4D020016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_CR1_b0                                  ((uint32_t)0x4D020014)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_CR1_b1                                  ((uint32_t)0x4D020015)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_CR1_b2                                  ((uint32_t)0x4D020016)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_CR1_b3                                  ((uint32_t)0x4D020017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EMB_CR2  [register's definitions]
 *              Offset[0x18]  EMB control register 2 (0x4D020018)
 ******************************************************************************
 */
///@{
#define EMB_CR2_w                                   ((uint32_t)0x4D020018)  /*!< Reg Absolute Address */
#define EMB_CR2_h0                                  ((uint32_t)0x4D020018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EMB_CR2_h1                                  ((uint32_t)0x4D02001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EMB_CR2_b0                                  ((uint32_t)0x4D020018)  /*!< Reg Absolute Address of [Byte-0] */
#define EMB_CR2_b1                                  ((uint32_t)0x4D020019)  /*!< Reg Absolute Address of [Byte-1] */
#define EMB_CR2_b2                                  ((uint32_t)0x4D02001A)  /*!< Reg Absolute Address of [Byte-2] */
#define EMB_CR2_b3                                  ((uint32_t)0x4D02001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      CFG (Hardware Configure)                                      */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CFG_KEY  [register's definitions]
 *              Offset[0x0C]  CFG write protected Key register (0x4FF0000C)
 ******************************************************************************
 */
///@{
#define CFG_KEY_w                                   ((uint32_t)0x4FF0000C)  /*!< Reg Absolute Address */
#define CFG_KEY_h0                                  ((uint32_t)0x4FF0000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_KEY_h1                                  ((uint32_t)0x4FF0000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_KEY_b0                                  ((uint32_t)0x4FF0000C)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_KEY_b1                                  ((uint32_t)0x4FF0000D)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_KEY_b2                                  ((uint32_t)0x4FF0000E)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_KEY_b3                                  ((uint32_t)0x4FF0000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR00  [register's definitions]
 *              Offset[0x10]  CFG option byte register 00 (0x4FF00010)
 ******************************************************************************
 */
///@{
#define CFG_OR00_w                                  ((uint32_t)0x4FF00010)  /*!< Reg Absolute Address */
#define CFG_OR00_h0                                 ((uint32_t)0x4FF00010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR00_h1                                 ((uint32_t)0x4FF00012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR00_b0                                 ((uint32_t)0x4FF00010)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR00_b1                                 ((uint32_t)0x4FF00011)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR00_b2                                 ((uint32_t)0x4FF00012)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR00_b3                                 ((uint32_t)0x4FF00013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR01  [register's definitions]
 *              Offset[0x14]  CFG option byte register 01 (0x4FF00014)
 ******************************************************************************
 */
///@{
#define CFG_OR01_w                                  ((uint32_t)0x4FF00014)  /*!< Reg Absolute Address */
#define CFG_OR01_h0                                 ((uint32_t)0x4FF00014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR01_h1                                 ((uint32_t)0x4FF00016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR01_b0                                 ((uint32_t)0x4FF00014)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR01_b1                                 ((uint32_t)0x4FF00015)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR01_b2                                 ((uint32_t)0x4FF00016)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR01_b3                                 ((uint32_t)0x4FF00017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR02  [register's definitions]
 *              Offset[0x18]  CFG option byte register 02 (0x4FF00018)
 ******************************************************************************
 */
///@{
#define CFG_OR02_w                                  ((uint32_t)0x4FF00018)  /*!< Reg Absolute Address */
#define CFG_OR02_h0                                 ((uint32_t)0x4FF00018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR02_h1                                 ((uint32_t)0x4FF0001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR02_b0                                 ((uint32_t)0x4FF00018)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR02_b1                                 ((uint32_t)0x4FF00019)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR02_b2                                 ((uint32_t)0x4FF0001A)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR02_b3                                 ((uint32_t)0x4FF0001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR03  [register's definitions]
 *              Offset[0x1C]  CFG option byte register 03 (0x4FF0001C)
 ******************************************************************************
 */
///@{
#define CFG_OR03_w                                  ((uint32_t)0x4FF0001C)  /*!< Reg Absolute Address */
#define CFG_OR03_h0                                 ((uint32_t)0x4FF0001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR03_h1                                 ((uint32_t)0x4FF0001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR03_b0                                 ((uint32_t)0x4FF0001C)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR03_b1                                 ((uint32_t)0x4FF0001D)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR03_b2                                 ((uint32_t)0x4FF0001E)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR03_b3                                 ((uint32_t)0x4FF0001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR04  [register's definitions]
 *              Offset[0x20]  CFG option byte register 04 (0x4FF00020)
 ******************************************************************************
 */
///@{
#define CFG_OR04_w                                  ((uint32_t)0x4FF00020)  /*!< Reg Absolute Address */
#define CFG_OR04_h0                                 ((uint32_t)0x4FF00020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR04_h1                                 ((uint32_t)0x4FF00022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR04_b0                                 ((uint32_t)0x4FF00020)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR04_b1                                 ((uint32_t)0x4FF00021)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR04_b2                                 ((uint32_t)0x4FF00022)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR04_b3                                 ((uint32_t)0x4FF00023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR05  [register's definitions]
 *              Offset[0x24]  CFG option byte register 05 (0x4FF00024)
 ******************************************************************************
 */
///@{
#define CFG_OR05_w                                  ((uint32_t)0x4FF00024)  /*!< Reg Absolute Address */
#define CFG_OR05_h0                                 ((uint32_t)0x4FF00024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR05_h1                                 ((uint32_t)0x4FF00026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR05_b0                                 ((uint32_t)0x4FF00024)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR05_b1                                 ((uint32_t)0x4FF00025)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR05_b2                                 ((uint32_t)0x4FF00026)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR05_b3                                 ((uint32_t)0x4FF00027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR07  [register's definitions]
 *              Offset[0x2C]  CFG option byte register 07 (0x4FF0002C)
 ******************************************************************************
 */
///@{
#define CFG_OR07_w                                  ((uint32_t)0x4FF0002C)  /*!< Reg Absolute Address */
#define CFG_OR07_h0                                 ((uint32_t)0x4FF0002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR07_h1                                 ((uint32_t)0x4FF0002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR07_b0                                 ((uint32_t)0x4FF0002C)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR07_b1                                 ((uint32_t)0x4FF0002D)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR07_b2                                 ((uint32_t)0x4FF0002E)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR07_b3                                 ((uint32_t)0x4FF0002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR11  [register's definitions]
 *              Offset[0x34]  CFG option byte register 11 (0x4FF00034)
 ******************************************************************************
 */
///@{
#define CFG_OR11_w                                  ((uint32_t)0x4FF00034)  /*!< Reg Absolute Address */
#define CFG_OR11_h0                                 ((uint32_t)0x4FF00034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR11_h1                                 ((uint32_t)0x4FF00036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR11_b0                                 ((uint32_t)0x4FF00034)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR11_b1                                 ((uint32_t)0x4FF00035)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR11_b2                                 ((uint32_t)0x4FF00036)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR11_b3                                 ((uint32_t)0x4FF00037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR12  [register's definitions]
 *              Offset[0x38]  CFG option byte register 12 (0x4FF00038)
 ******************************************************************************
 */
///@{
#define CFG_OR12_w                                  ((uint32_t)0x4FF00038)  /*!< Reg Absolute Address */
#define CFG_OR12_h0                                 ((uint32_t)0x4FF00038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR12_h1                                 ((uint32_t)0x4FF0003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR12_b0                                 ((uint32_t)0x4FF00038)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR12_b1                                 ((uint32_t)0x4FF00039)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR12_b2                                 ((uint32_t)0x4FF0003A)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR12_b3                                 ((uint32_t)0x4FF0003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR13  [register's definitions]
 *              Offset[0x3C]  CFG option byte register 13 (0x4FF0003C)
 ******************************************************************************
 */
///@{
#define CFG_OR13_w                                  ((uint32_t)0x4FF0003C)  /*!< Reg Absolute Address */
#define CFG_OR13_h0                                 ((uint32_t)0x4FF0003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR13_h1                                 ((uint32_t)0x4FF0003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR13_b0                                 ((uint32_t)0x4FF0003C)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR13_b1                                 ((uint32_t)0x4FF0003D)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR13_b2                                 ((uint32_t)0x4FF0003E)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR13_b3                                 ((uint32_t)0x4FF0003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR14  [register's definitions]
 *              Offset[0x40]  CFG option byte register 14 (0x4FF00040)
 ******************************************************************************
 */
///@{
#define CFG_OR14_w                                  ((uint32_t)0x4FF00040)  /*!< Reg Absolute Address */
#define CFG_OR14_h0                                 ((uint32_t)0x4FF00040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR14_h1                                 ((uint32_t)0x4FF00042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR14_b0                                 ((uint32_t)0x4FF00040)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR14_b1                                 ((uint32_t)0x4FF00041)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR14_b2                                 ((uint32_t)0x4FF00042)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR14_b3                                 ((uint32_t)0x4FF00043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR15  [register's definitions]
 *              Offset[0x44]  CFG option byte register 15 (0x4FF00044)
 ******************************************************************************
 */
///@{
#define CFG_OR15_w                                  ((uint32_t)0x4FF00044)  /*!< Reg Absolute Address */
#define CFG_OR15_h0                                 ((uint32_t)0x4FF00044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR15_h1                                 ((uint32_t)0x4FF00046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR15_b0                                 ((uint32_t)0x4FF00044)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR15_b1                                 ((uint32_t)0x4FF00045)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR15_b2                                 ((uint32_t)0x4FF00046)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR15_b3                                 ((uint32_t)0x4FF00047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR16  [register's definitions]
 *              Offset[0x48]  CFG option byte register 16 (0x4FF00048)
 ******************************************************************************
 */
///@{
#define CFG_OR16_w                                  ((uint32_t)0x4FF00048)  /*!< Reg Absolute Address */
#define CFG_OR16_h0                                 ((uint32_t)0x4FF00048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR16_h1                                 ((uint32_t)0x4FF0004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR16_b0                                 ((uint32_t)0x4FF00048)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR16_b1                                 ((uint32_t)0x4FF00049)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR16_b2                                 ((uint32_t)0x4FF0004A)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR16_b3                                 ((uint32_t)0x4FF0004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_OR17  [register's definitions]
 *              Offset[0x4C]  CFG option byte register 17 (0x4FF0004C)
 ******************************************************************************
 */
///@{
#define CFG_OR17_w                                  ((uint32_t)0x4FF0004C)  /*!< Reg Absolute Address */
#define CFG_OR17_h0                                 ((uint32_t)0x4FF0004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_OR17_h1                                 ((uint32_t)0x4FF0004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_OR17_b0                                 ((uint32_t)0x4FF0004C)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_OR17_b1                                 ((uint32_t)0x4FF0004D)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_OR17_b2                                 ((uint32_t)0x4FF0004E)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_OR17_b3                                 ((uint32_t)0x4FF0004F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_TST0  [register's definitions]
 *              Offset[0x60]  CFG Test register 0 (not load from flash memory) (0x4FF00060)
 ******************************************************************************
 */
///@{
#define CFG_TST0_w                                  ((uint32_t)0x4FF00060)  /*!< Reg Absolute Address */
#define CFG_TST0_h0                                 ((uint32_t)0x4FF00060)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_TST0_h1                                 ((uint32_t)0x4FF00062)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_TST0_b0                                 ((uint32_t)0x4FF00060)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_TST0_b1                                 ((uint32_t)0x4FF00061)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_TST0_b2                                 ((uint32_t)0x4FF00062)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_TST0_b3                                 ((uint32_t)0x4FF00063)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CFG_TST1  [register's definitions]
 *              Offset[0x64]  CFG Test register 1 (not load from flash memory) (0x4FF00064)
 ******************************************************************************
 */
///@{
#define CFG_TST1_w                                  ((uint32_t)0x4FF00064)  /*!< Reg Absolute Address */
#define CFG_TST1_h0                                 ((uint32_t)0x4FF00064)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CFG_TST1_h1                                 ((uint32_t)0x4FF00066)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CFG_TST1_b0                                 ((uint32_t)0x4FF00064)  /*!< Reg Absolute Address of [Byte-0] */
#define CFG_TST1_b1                                 ((uint32_t)0x4FF00065)  /*!< Reg Absolute Address of [Byte-1] */
#define CFG_TST1_b2                                 ((uint32_t)0x4FF00066)  /*!< Reg Absolute Address of [Byte-2] */
#define CFG_TST1_b3                                 ((uint32_t)0x4FF00067)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      EXIC (EXIC Interrupt)                                         */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        EXIC_STA  [register's definitions]
 *              Offset[0x00]  EXIC interrupt status register (0x50000000)
 ******************************************************************************
 */
///@{
#define EXIC_STA_w                                  ((uint32_t)0x50000000)  /*!< Reg Absolute Address */
#define EXIC_STA_h0                                 ((uint32_t)0x50000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_STA_h1                                 ((uint32_t)0x50000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_STA_b0                                 ((uint32_t)0x50000000)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_STA_b1                                 ((uint32_t)0x50000001)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_STA_b2                                 ((uint32_t)0x50000002)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_STA_b3                                 ((uint32_t)0x50000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_INT  [register's definitions]
 *              Offset[0x04]  EXIC interrupt enable register (0x50000004)
 ******************************************************************************
 */
///@{
#define EXIC_INT_w                                  ((uint32_t)0x50000004)  /*!< Reg Absolute Address */
#define EXIC_INT_h0                                 ((uint32_t)0x50000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_INT_h1                                 ((uint32_t)0x50000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_INT_b0                                 ((uint32_t)0x50000004)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_INT_b1                                 ((uint32_t)0x50000005)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_INT_b2                                 ((uint32_t)0x50000006)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_INT_b3                                 ((uint32_t)0x50000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_CR0  [register's definitions]
 *              Offset[0x10]  EXIC control register 0 (0x50000010)
 ******************************************************************************
 */
///@{
#define EXIC_CR0_w                                  ((uint32_t)0x50000010)  /*!< Reg Absolute Address */
#define EXIC_CR0_h0                                 ((uint32_t)0x50000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_CR0_h1                                 ((uint32_t)0x50000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_CR0_b0                                 ((uint32_t)0x50000010)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_CR0_b1                                 ((uint32_t)0x50000011)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_CR0_b2                                 ((uint32_t)0x50000012)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_CR0_b3                                 ((uint32_t)0x50000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_PF  [register's definitions]
 *              Offset[0x20]  EXIC PA input interrupt pending flag register (0x50000020)
 ******************************************************************************
 */
///@{
#define EXIC_PA_PF_w                                ((uint32_t)0x50000020)  /*!< Reg Absolute Address */
#define EXIC_PA_PF_h0                               ((uint32_t)0x50000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PA_PF_h1                               ((uint32_t)0x50000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PA_PF_b0                               ((uint32_t)0x50000020)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PA_PF_b1                               ((uint32_t)0x50000021)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PA_PF_b2                               ((uint32_t)0x50000022)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PA_PF_b3                               ((uint32_t)0x50000023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_TRGS  [register's definitions]
 *              Offset[0x24]  EXIC PA Pad input trigger select register (0x50000024)
 ******************************************************************************
 */
///@{
#define EXIC_PA_TRGS_w                              ((uint32_t)0x50000024)  /*!< Reg Absolute Address */
#define EXIC_PA_TRGS_h0                             ((uint32_t)0x50000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PA_TRGS_h1                             ((uint32_t)0x50000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PA_TRGS_b0                             ((uint32_t)0x50000024)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PA_TRGS_b1                             ((uint32_t)0x50000025)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PA_TRGS_b2                             ((uint32_t)0x50000026)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PA_TRGS_b3                             ((uint32_t)0x50000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_MSK  [register's definitions]
 *              Offset[0x28]  EXIC PA AOI Mask register (0x50000028)
 ******************************************************************************
 */
///@{
#define EXIC_PA_MSK_w                               ((uint32_t)0x50000028)  /*!< Reg Absolute Address */
#define EXIC_PA_MSK_h0                              ((uint32_t)0x50000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PA_MSK_h1                              ((uint32_t)0x5000002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PA_MSK_b0                              ((uint32_t)0x50000028)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PA_MSK_b1                              ((uint32_t)0x50000029)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PA_MSK_b2                              ((uint32_t)0x5000002A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PA_MSK_b3                              ((uint32_t)0x5000002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_PF  [register's definitions]
 *              Offset[0x30]  EXIC PB input interrupt pending flag register (0x50000030)
 ******************************************************************************
 */
///@{
#define EXIC_PB_PF_w                                ((uint32_t)0x50000030)  /*!< Reg Absolute Address */
#define EXIC_PB_PF_h0                               ((uint32_t)0x50000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PB_PF_h1                               ((uint32_t)0x50000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PB_PF_b0                               ((uint32_t)0x50000030)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PB_PF_b1                               ((uint32_t)0x50000031)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PB_PF_b2                               ((uint32_t)0x50000032)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PB_PF_b3                               ((uint32_t)0x50000033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_TRGS  [register's definitions]
 *              Offset[0x34]  EXIC PB Pad input trigger select register (0x50000034)
 ******************************************************************************
 */
///@{
#define EXIC_PB_TRGS_w                              ((uint32_t)0x50000034)  /*!< Reg Absolute Address */
#define EXIC_PB_TRGS_h0                             ((uint32_t)0x50000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PB_TRGS_h1                             ((uint32_t)0x50000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PB_TRGS_b0                             ((uint32_t)0x50000034)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PB_TRGS_b1                             ((uint32_t)0x50000035)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PB_TRGS_b2                             ((uint32_t)0x50000036)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PB_TRGS_b3                             ((uint32_t)0x50000037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_MSK  [register's definitions]
 *              Offset[0x38]  EXIC PB AOI Mask register (0x50000038)
 ******************************************************************************
 */
///@{
#define EXIC_PB_MSK_w                               ((uint32_t)0x50000038)  /*!< Reg Absolute Address */
#define EXIC_PB_MSK_h0                              ((uint32_t)0x50000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PB_MSK_h1                              ((uint32_t)0x5000003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PB_MSK_b0                              ((uint32_t)0x50000038)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PB_MSK_b1                              ((uint32_t)0x50000039)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PB_MSK_b2                              ((uint32_t)0x5000003A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PB_MSK_b3                              ((uint32_t)0x5000003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_PF  [register's definitions]
 *              Offset[0x40]  EXIC PC input interrupt pending flag register (0x50000040)
 ******************************************************************************
 */
///@{
#define EXIC_PC_PF_w                                ((uint32_t)0x50000040)  /*!< Reg Absolute Address */
#define EXIC_PC_PF_h0                               ((uint32_t)0x50000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PC_PF_h1                               ((uint32_t)0x50000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PC_PF_b0                               ((uint32_t)0x50000040)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PC_PF_b1                               ((uint32_t)0x50000041)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PC_PF_b2                               ((uint32_t)0x50000042)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PC_PF_b3                               ((uint32_t)0x50000043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_TRGS  [register's definitions]
 *              Offset[0x44]  EXIC PC Pad input trigger select register (0x50000044)
 ******************************************************************************
 */
///@{
#define EXIC_PC_TRGS_w                              ((uint32_t)0x50000044)  /*!< Reg Absolute Address */
#define EXIC_PC_TRGS_h0                             ((uint32_t)0x50000044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PC_TRGS_h1                             ((uint32_t)0x50000046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PC_TRGS_b0                             ((uint32_t)0x50000044)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PC_TRGS_b1                             ((uint32_t)0x50000045)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PC_TRGS_b2                             ((uint32_t)0x50000046)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PC_TRGS_b3                             ((uint32_t)0x50000047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_MSK  [register's definitions]
 *              Offset[0x48]  EXIC  PC AOI Mask register (0x50000048)
 ******************************************************************************
 */
///@{
#define EXIC_PC_MSK_w                               ((uint32_t)0x50000048)  /*!< Reg Absolute Address */
#define EXIC_PC_MSK_h0                              ((uint32_t)0x50000048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PC_MSK_h1                              ((uint32_t)0x5000004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PC_MSK_b0                              ((uint32_t)0x50000048)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PC_MSK_b1                              ((uint32_t)0x50000049)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PC_MSK_b2                              ((uint32_t)0x5000004A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PC_MSK_b3                              ((uint32_t)0x5000004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_PF  [register's definitions]
 *              Offset[0x50]  EXIC PD input interrupt pending flag register (0x50000050)
 ******************************************************************************
 */
///@{
#define EXIC_PD_PF_w                                ((uint32_t)0x50000050)  /*!< Reg Absolute Address */
#define EXIC_PD_PF_h0                               ((uint32_t)0x50000050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PD_PF_h1                               ((uint32_t)0x50000052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PD_PF_b0                               ((uint32_t)0x50000050)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PD_PF_b1                               ((uint32_t)0x50000051)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PD_PF_b2                               ((uint32_t)0x50000052)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PD_PF_b3                               ((uint32_t)0x50000053)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_TRGS  [register's definitions]
 *              Offset[0x54]  EXIC PD Pad input trigger select register (0x50000054)
 ******************************************************************************
 */
///@{
#define EXIC_PD_TRGS_w                              ((uint32_t)0x50000054)  /*!< Reg Absolute Address */
#define EXIC_PD_TRGS_h0                             ((uint32_t)0x50000054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PD_TRGS_h1                             ((uint32_t)0x50000056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PD_TRGS_b0                             ((uint32_t)0x50000054)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PD_TRGS_b1                             ((uint32_t)0x50000055)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PD_TRGS_b2                             ((uint32_t)0x50000056)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PD_TRGS_b3                             ((uint32_t)0x50000057)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_MSK  [register's definitions]
 *              Offset[0x58]  EXIC  PD AOI Mask register (0x50000058)
 ******************************************************************************
 */
///@{
#define EXIC_PD_MSK_w                               ((uint32_t)0x50000058)  /*!< Reg Absolute Address */
#define EXIC_PD_MSK_h0                              ((uint32_t)0x50000058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_PD_MSK_h1                              ((uint32_t)0x5000005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_PD_MSK_b0                              ((uint32_t)0x50000058)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_PD_MSK_b1                              ((uint32_t)0x50000059)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_PD_MSK_b2                              ((uint32_t)0x5000005A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_PD_MSK_b3                              ((uint32_t)0x5000005B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC0  [register's definitions]
 *              Offset[0x60]  EXIC Interrupt source identity register 0 (0x50000060)
 ******************************************************************************
 */
///@{
#define EXIC_SRC0_w                                 ((uint32_t)0x50000060)  /*!< Reg Absolute Address */
#define EXIC_SRC0_h0                                ((uint32_t)0x50000060)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC0_h1                                ((uint32_t)0x50000062)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC0_b0                                ((uint32_t)0x50000060)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC0_b1                                ((uint32_t)0x50000061)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC0_b2                                ((uint32_t)0x50000062)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC0_b3                                ((uint32_t)0x50000063)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC1  [register's definitions]
 *              Offset[0x64]  EXIC interrupt source identity register 1 (0x50000064)
 ******************************************************************************
 */
///@{
#define EXIC_SRC1_w                                 ((uint32_t)0x50000064)  /*!< Reg Absolute Address */
#define EXIC_SRC1_h0                                ((uint32_t)0x50000064)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC1_h1                                ((uint32_t)0x50000066)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC1_b0                                ((uint32_t)0x50000064)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC1_b1                                ((uint32_t)0x50000065)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC1_b2                                ((uint32_t)0x50000066)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC1_b3                                ((uint32_t)0x50000067)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC2  [register's definitions]
 *              Offset[0x68]  EXIC interrupt source identity register 2 (0x50000068)
 ******************************************************************************
 */
///@{
#define EXIC_SRC2_w                                 ((uint32_t)0x50000068)  /*!< Reg Absolute Address */
#define EXIC_SRC2_h0                                ((uint32_t)0x50000068)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC2_h1                                ((uint32_t)0x5000006A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC2_b0                                ((uint32_t)0x50000068)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC2_b1                                ((uint32_t)0x50000069)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC2_b2                                ((uint32_t)0x5000006A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC2_b3                                ((uint32_t)0x5000006B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC3  [register's definitions]
 *              Offset[0x6C]  EXIC interrupt source identity register 3 (0x5000006C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC3_w                                 ((uint32_t)0x5000006C)  /*!< Reg Absolute Address */
#define EXIC_SRC3_h0                                ((uint32_t)0x5000006C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC3_h1                                ((uint32_t)0x5000006E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC3_b0                                ((uint32_t)0x5000006C)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC3_b1                                ((uint32_t)0x5000006D)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC3_b2                                ((uint32_t)0x5000006E)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC3_b3                                ((uint32_t)0x5000006F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC4  [register's definitions]
 *              Offset[0x70]  EXIC interrupt source identity register 4 (0x50000070)
 ******************************************************************************
 */
///@{
#define EXIC_SRC4_w                                 ((uint32_t)0x50000070)  /*!< Reg Absolute Address */
#define EXIC_SRC4_h0                                ((uint32_t)0x50000070)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC4_h1                                ((uint32_t)0x50000072)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC4_b0                                ((uint32_t)0x50000070)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC4_b1                                ((uint32_t)0x50000071)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC4_b2                                ((uint32_t)0x50000072)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC4_b3                                ((uint32_t)0x50000073)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC5  [register's definitions]
 *              Offset[0x74]  EXIC interrupt source identity register 5 (0x50000074)
 ******************************************************************************
 */
///@{
#define EXIC_SRC5_w                                 ((uint32_t)0x50000074)  /*!< Reg Absolute Address */
#define EXIC_SRC5_h0                                ((uint32_t)0x50000074)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC5_h1                                ((uint32_t)0x50000076)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC5_b0                                ((uint32_t)0x50000074)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC5_b1                                ((uint32_t)0x50000075)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC5_b2                                ((uint32_t)0x50000076)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC5_b3                                ((uint32_t)0x50000077)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC6  [register's definitions]
 *              Offset[0x78]  EXIC interrupt source identity register 6 (0x50000078)
 ******************************************************************************
 */
///@{
#define EXIC_SRC6_w                                 ((uint32_t)0x50000078)  /*!< Reg Absolute Address */
#define EXIC_SRC6_h0                                ((uint32_t)0x50000078)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC6_h1                                ((uint32_t)0x5000007A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC6_b0                                ((uint32_t)0x50000078)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC6_b1                                ((uint32_t)0x50000079)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC6_b2                                ((uint32_t)0x5000007A)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC6_b3                                ((uint32_t)0x5000007B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC7  [register's definitions]
 *              Offset[0x7C]  EXIC interrupt source identity register 7 (0x5000007C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC7_w                                 ((uint32_t)0x5000007C)  /*!< Reg Absolute Address */
#define EXIC_SRC7_h0                                ((uint32_t)0x5000007C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define EXIC_SRC7_h1                                ((uint32_t)0x5000007E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define EXIC_SRC7_b0                                ((uint32_t)0x5000007C)  /*!< Reg Absolute Address of [Byte-0] */
#define EXIC_SRC7_b1                                ((uint32_t)0x5000007D)  /*!< Reg Absolute Address of [Byte-1] */
#define EXIC_SRC7_b2                                ((uint32_t)0x5000007E)  /*!< Reg Absolute Address of [Byte-2] */
#define EXIC_SRC7_b3                                ((uint32_t)0x5000007F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      I2C (I2C Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        I2C_STA  [register's definitions]
 *              Offset[0x00]  I2C status register
 ******************************************************************************
 */
///@{
#define I2C0_STA_w                                  ((uint32_t)0x51000000)  /*!< Reg Absolute Address */
#define I2C0_STA_h0                                 ((uint32_t)0x51000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_STA_h1                                 ((uint32_t)0x51000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_STA_b0                                 ((uint32_t)0x51000000)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_STA_b1                                 ((uint32_t)0x51000001)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_STA_b2                                 ((uint32_t)0x51000002)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_STA_b3                                 ((uint32_t)0x51000003)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_STA_w                                  ((uint32_t)0x51010000)  /*!< Reg Absolute Address */
#define I2C1_STA_h0                                 ((uint32_t)0x51010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_STA_h1                                 ((uint32_t)0x51010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_STA_b0                                 ((uint32_t)0x51010000)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_STA_b1                                 ((uint32_t)0x51010001)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_STA_b2                                 ((uint32_t)0x51010002)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_STA_b3                                 ((uint32_t)0x51010003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_INT  [register's definitions]
 *              Offset[0x04]  I2C interrupt enable register
 ******************************************************************************
 */
///@{
#define I2C0_INT_w                                  ((uint32_t)0x51000004)  /*!< Reg Absolute Address */
#define I2C0_INT_h0                                 ((uint32_t)0x51000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_INT_h1                                 ((uint32_t)0x51000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_INT_b0                                 ((uint32_t)0x51000004)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_INT_b1                                 ((uint32_t)0x51000005)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_INT_b2                                 ((uint32_t)0x51000006)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_INT_b3                                 ((uint32_t)0x51000007)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_INT_w                                  ((uint32_t)0x51010004)  /*!< Reg Absolute Address */
#define I2C1_INT_h0                                 ((uint32_t)0x51010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_INT_h1                                 ((uint32_t)0x51010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_INT_b0                                 ((uint32_t)0x51010004)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_INT_b1                                 ((uint32_t)0x51010005)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_INT_b2                                 ((uint32_t)0x51010006)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_INT_b3                                 ((uint32_t)0x51010007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_CLK  [register's definitions]
 *              Offset[0x08]  I2C clock source register
 ******************************************************************************
 */
///@{
#define I2C0_CLK_w                                  ((uint32_t)0x51000008)  /*!< Reg Absolute Address */
#define I2C0_CLK_h0                                 ((uint32_t)0x51000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_CLK_h1                                 ((uint32_t)0x5100000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_CLK_b0                                 ((uint32_t)0x51000008)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_CLK_b1                                 ((uint32_t)0x51000009)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_CLK_b2                                 ((uint32_t)0x5100000A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_CLK_b3                                 ((uint32_t)0x5100000B)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_CLK_w                                  ((uint32_t)0x51010008)  /*!< Reg Absolute Address */
#define I2C1_CLK_h0                                 ((uint32_t)0x51010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_CLK_h1                                 ((uint32_t)0x5101000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_CLK_b0                                 ((uint32_t)0x51010008)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_CLK_b1                                 ((uint32_t)0x51010009)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_CLK_b2                                 ((uint32_t)0x5101000A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_CLK_b3                                 ((uint32_t)0x5101000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_SAC  [register's definitions]
 *              Offset[0x0C]  I2C slave mode slave address code register
 ******************************************************************************
 */
///@{
#define I2C0_SAC_w                                  ((uint32_t)0x5100000C)  /*!< Reg Absolute Address */
#define I2C0_SAC_h0                                 ((uint32_t)0x5100000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_SAC_h1                                 ((uint32_t)0x5100000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_SAC_b0                                 ((uint32_t)0x5100000C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_SAC_b1                                 ((uint32_t)0x5100000D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_SAC_b2                                 ((uint32_t)0x5100000E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_SAC_b3                                 ((uint32_t)0x5100000F)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_SAC_w                                  ((uint32_t)0x5101000C)  /*!< Reg Absolute Address */
#define I2C1_SAC_h0                                 ((uint32_t)0x5101000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_SAC_h1                                 ((uint32_t)0x5101000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_SAC_b0                                 ((uint32_t)0x5101000C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_SAC_b1                                 ((uint32_t)0x5101000D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_SAC_b2                                 ((uint32_t)0x5101000E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_SAC_b3                                 ((uint32_t)0x5101000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_CR0  [register's definitions]
 *              Offset[0x10]  I2C control register 0
 ******************************************************************************
 */
///@{
#define I2C0_CR0_w                                  ((uint32_t)0x51000010)  /*!< Reg Absolute Address */
#define I2C0_CR0_h0                                 ((uint32_t)0x51000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_CR0_h1                                 ((uint32_t)0x51000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_CR0_b0                                 ((uint32_t)0x51000010)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_CR0_b1                                 ((uint32_t)0x51000011)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_CR0_b2                                 ((uint32_t)0x51000012)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_CR0_b3                                 ((uint32_t)0x51000013)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_CR0_w                                  ((uint32_t)0x51010010)  /*!< Reg Absolute Address */
#define I2C1_CR0_h0                                 ((uint32_t)0x51010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_CR0_h1                                 ((uint32_t)0x51010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_CR0_b0                                 ((uint32_t)0x51010010)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_CR0_b1                                 ((uint32_t)0x51010011)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_CR0_b2                                 ((uint32_t)0x51010012)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_CR0_b3                                 ((uint32_t)0x51010013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_CR1  [register's definitions]
 *              Offset[0x14]  I2C control register 1
 ******************************************************************************
 */
///@{
#define I2C0_CR1_w                                  ((uint32_t)0x51000014)  /*!< Reg Absolute Address */
#define I2C0_CR1_h0                                 ((uint32_t)0x51000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_CR1_h1                                 ((uint32_t)0x51000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_CR1_b0                                 ((uint32_t)0x51000014)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_CR1_b1                                 ((uint32_t)0x51000015)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_CR1_b2                                 ((uint32_t)0x51000016)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_CR1_b3                                 ((uint32_t)0x51000017)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_CR1_w                                  ((uint32_t)0x51010014)  /*!< Reg Absolute Address */
#define I2C1_CR1_h0                                 ((uint32_t)0x51010014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_CR1_h1                                 ((uint32_t)0x51010016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_CR1_b0                                 ((uint32_t)0x51010014)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_CR1_b1                                 ((uint32_t)0x51010015)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_CR1_b2                                 ((uint32_t)0x51010016)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_CR1_b3                                 ((uint32_t)0x51010017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_CR2  [register's definitions]
 *              Offset[0x18]  I2C control register 2
 ******************************************************************************
 */
///@{
#define I2C0_CR2_w                                  ((uint32_t)0x51000018)  /*!< Reg Absolute Address */
#define I2C0_CR2_h0                                 ((uint32_t)0x51000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_CR2_h1                                 ((uint32_t)0x5100001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_CR2_b0                                 ((uint32_t)0x51000018)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_CR2_b1                                 ((uint32_t)0x51000019)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_CR2_b2                                 ((uint32_t)0x5100001A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_CR2_b3                                 ((uint32_t)0x5100001B)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_CR2_w                                  ((uint32_t)0x51010018)  /*!< Reg Absolute Address */
#define I2C1_CR2_h0                                 ((uint32_t)0x51010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_CR2_h1                                 ((uint32_t)0x5101001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_CR2_b0                                 ((uint32_t)0x51010018)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_CR2_b1                                 ((uint32_t)0x51010019)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_CR2_b2                                 ((uint32_t)0x5101001A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_CR2_b3                                 ((uint32_t)0x5101001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_SADR  [register's definitions]
 *              Offset[0x1C]  I2C slave address detect register
 ******************************************************************************
 */
///@{
#define I2C0_SADR_w                                 ((uint32_t)0x5100001C)  /*!< Reg Absolute Address */
#define I2C0_SADR_h0                                ((uint32_t)0x5100001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_SADR_h1                                ((uint32_t)0x5100001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_SADR_b0                                ((uint32_t)0x5100001C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_SADR_b1                                ((uint32_t)0x5100001D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_SADR_b2                                ((uint32_t)0x5100001E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_SADR_b3                                ((uint32_t)0x5100001F)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_SADR_w                                 ((uint32_t)0x5101001C)  /*!< Reg Absolute Address */
#define I2C1_SADR_h0                                ((uint32_t)0x5101001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_SADR_h1                                ((uint32_t)0x5101001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_SADR_b0                                ((uint32_t)0x5101001C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_SADR_b1                                ((uint32_t)0x5101001D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_SADR_b2                                ((uint32_t)0x5101001E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_SADR_b3                                ((uint32_t)0x5101001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_TMOUT  [register's definitions]
 *              Offset[0x20]  I2C timeout control register
 ******************************************************************************
 */
///@{
#define I2C0_TMOUT_w                                ((uint32_t)0x51000020)  /*!< Reg Absolute Address */
#define I2C0_TMOUT_h0                               ((uint32_t)0x51000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_TMOUT_h1                               ((uint32_t)0x51000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_TMOUT_b0                               ((uint32_t)0x51000020)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_TMOUT_b1                               ((uint32_t)0x51000021)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_TMOUT_b2                               ((uint32_t)0x51000022)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_TMOUT_b3                               ((uint32_t)0x51000023)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_TMOUT_w                                ((uint32_t)0x51010020)  /*!< Reg Absolute Address */
#define I2C1_TMOUT_h0                               ((uint32_t)0x51010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_TMOUT_h1                               ((uint32_t)0x51010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_TMOUT_b0                               ((uint32_t)0x51010020)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_TMOUT_b1                               ((uint32_t)0x51010021)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_TMOUT_b2                               ((uint32_t)0x51010022)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_TMOUT_b3                               ((uint32_t)0x51010023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_STA2  [register's definitions]
 *              Offset[0x28]  I2C status register 2
 ******************************************************************************
 */
///@{
#define I2C0_STA2_w                                 ((uint32_t)0x51000028)  /*!< Reg Absolute Address */
#define I2C0_STA2_h0                                ((uint32_t)0x51000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_STA2_h1                                ((uint32_t)0x5100002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_STA2_b0                                ((uint32_t)0x51000028)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_STA2_b1                                ((uint32_t)0x51000029)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_STA2_b2                                ((uint32_t)0x5100002A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_STA2_b3                                ((uint32_t)0x5100002B)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_STA2_w                                 ((uint32_t)0x51010028)  /*!< Reg Absolute Address */
#define I2C1_STA2_h0                                ((uint32_t)0x51010028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_STA2_h1                                ((uint32_t)0x5101002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_STA2_b0                                ((uint32_t)0x51010028)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_STA2_b1                                ((uint32_t)0x51010029)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_STA2_b2                                ((uint32_t)0x5101002A)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_STA2_b3                                ((uint32_t)0x5101002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_SBUF  [register's definitions]
 *              Offset[0x2C]  I2C data shift buffer register
 ******************************************************************************
 */
///@{
#define I2C0_SBUF_w                                 ((uint32_t)0x5100002C)  /*!< Reg Absolute Address */
#define I2C0_SBUF_h0                                ((uint32_t)0x5100002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_SBUF_h1                                ((uint32_t)0x5100002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_SBUF_b0                                ((uint32_t)0x5100002C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_SBUF_b1                                ((uint32_t)0x5100002D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_SBUF_b2                                ((uint32_t)0x5100002E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_SBUF_b3                                ((uint32_t)0x5100002F)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_SBUF_w                                 ((uint32_t)0x5101002C)  /*!< Reg Absolute Address */
#define I2C1_SBUF_h0                                ((uint32_t)0x5101002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_SBUF_h1                                ((uint32_t)0x5101002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_SBUF_b0                                ((uint32_t)0x5101002C)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_SBUF_b1                                ((uint32_t)0x5101002D)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_SBUF_b2                                ((uint32_t)0x5101002E)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_SBUF_b3                                ((uint32_t)0x5101002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        I2C_DAT  [register's definitions]
 *              Offset[0x30]  I2C data register
 ******************************************************************************
 */
///@{
#define I2C0_DAT_w                                  ((uint32_t)0x51000030)  /*!< Reg Absolute Address */
#define I2C0_DAT_h0                                 ((uint32_t)0x51000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C0_DAT_h1                                 ((uint32_t)0x51000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C0_DAT_b0                                 ((uint32_t)0x51000030)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C0_DAT_b1                                 ((uint32_t)0x51000031)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C0_DAT_b2                                 ((uint32_t)0x51000032)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C0_DAT_b3                                 ((uint32_t)0x51000033)  /*!< Reg Absolute Address of [Byte-3] */
#define I2C1_DAT_w                                  ((uint32_t)0x51010030)  /*!< Reg Absolute Address */
#define I2C1_DAT_h0                                 ((uint32_t)0x51010030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define I2C1_DAT_h1                                 ((uint32_t)0x51010032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define I2C1_DAT_b0                                 ((uint32_t)0x51010030)  /*!< Reg Absolute Address of [Byte-0] */
#define I2C1_DAT_b1                                 ((uint32_t)0x51010031)  /*!< Reg Absolute Address of [Byte-1] */
#define I2C1_DAT_b2                                 ((uint32_t)0x51010032)  /*!< Reg Absolute Address of [Byte-2] */
#define I2C1_DAT_b3                                 ((uint32_t)0x51010033)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      URT (URT Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        URT_STA  [register's definitions]
 *              Offset[0x00]  URT status register 1
 ******************************************************************************
 */
///@{
#define URT0_STA_w                                  ((uint32_t)0x52000000)  /*!< Reg Absolute Address */
#define URT0_STA_h0                                 ((uint32_t)0x52000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_STA_h1                                 ((uint32_t)0x52000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_STA_b0                                 ((uint32_t)0x52000000)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_STA_b1                                 ((uint32_t)0x52000001)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_STA_b2                                 ((uint32_t)0x52000002)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_STA_b3                                 ((uint32_t)0x52000003)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_STA_w                                  ((uint32_t)0x52010000)  /*!< Reg Absolute Address */
#define URT1_STA_h0                                 ((uint32_t)0x52010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_STA_h1                                 ((uint32_t)0x52010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_STA_b0                                 ((uint32_t)0x52010000)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_STA_b1                                 ((uint32_t)0x52010001)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_STA_b2                                 ((uint32_t)0x52010002)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_STA_b3                                 ((uint32_t)0x52010003)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_STA_w                                  ((uint32_t)0x52020000)  /*!< Reg Absolute Address */
#define URT2_STA_h0                                 ((uint32_t)0x52020000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_STA_h1                                 ((uint32_t)0x52020002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_STA_b0                                 ((uint32_t)0x52020000)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_STA_b1                                 ((uint32_t)0x52020001)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_STA_b2                                 ((uint32_t)0x52020002)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_STA_b3                                 ((uint32_t)0x52020003)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_STA_w                                  ((uint32_t)0x52030000)  /*!< Reg Absolute Address */
#define URT3_STA_h0                                 ((uint32_t)0x52030000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_STA_h1                                 ((uint32_t)0x52030002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_STA_b0                                 ((uint32_t)0x52030000)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_STA_b1                                 ((uint32_t)0x52030001)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_STA_b2                                 ((uint32_t)0x52030002)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_STA_b3                                 ((uint32_t)0x52030003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_INT  [register's definitions]
 *              Offset[0x04]  URT interrupt enable register
 ******************************************************************************
 */
///@{
#define URT0_INT_w                                  ((uint32_t)0x52000004)  /*!< Reg Absolute Address */
#define URT0_INT_h0                                 ((uint32_t)0x52000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_INT_h1                                 ((uint32_t)0x52000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_INT_b0                                 ((uint32_t)0x52000004)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_INT_b1                                 ((uint32_t)0x52000005)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_INT_b2                                 ((uint32_t)0x52000006)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_INT_b3                                 ((uint32_t)0x52000007)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_INT_w                                  ((uint32_t)0x52010004)  /*!< Reg Absolute Address */
#define URT1_INT_h0                                 ((uint32_t)0x52010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_INT_h1                                 ((uint32_t)0x52010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_INT_b0                                 ((uint32_t)0x52010004)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_INT_b1                                 ((uint32_t)0x52010005)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_INT_b2                                 ((uint32_t)0x52010006)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_INT_b3                                 ((uint32_t)0x52010007)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_INT_w                                  ((uint32_t)0x52020004)  /*!< Reg Absolute Address */
#define URT2_INT_h0                                 ((uint32_t)0x52020004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_INT_h1                                 ((uint32_t)0x52020006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_INT_b0                                 ((uint32_t)0x52020004)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_INT_b1                                 ((uint32_t)0x52020005)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_INT_b2                                 ((uint32_t)0x52020006)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_INT_b3                                 ((uint32_t)0x52020007)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_INT_w                                  ((uint32_t)0x52030004)  /*!< Reg Absolute Address */
#define URT3_INT_h0                                 ((uint32_t)0x52030004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_INT_h1                                 ((uint32_t)0x52030006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_INT_b0                                 ((uint32_t)0x52030004)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_INT_b1                                 ((uint32_t)0x52030005)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_INT_b2                                 ((uint32_t)0x52030006)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_INT_b3                                 ((uint32_t)0x52030007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CLK  [register's definitions]
 *              Offset[0x08]  URT clock source register
 ******************************************************************************
 */
///@{
#define URT0_CLK_w                                  ((uint32_t)0x52000008)  /*!< Reg Absolute Address */
#define URT0_CLK_h0                                 ((uint32_t)0x52000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CLK_h1                                 ((uint32_t)0x5200000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CLK_b0                                 ((uint32_t)0x52000008)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CLK_b1                                 ((uint32_t)0x52000009)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CLK_b2                                 ((uint32_t)0x5200000A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CLK_b3                                 ((uint32_t)0x5200000B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CLK_w                                  ((uint32_t)0x52010008)  /*!< Reg Absolute Address */
#define URT1_CLK_h0                                 ((uint32_t)0x52010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CLK_h1                                 ((uint32_t)0x5201000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CLK_b0                                 ((uint32_t)0x52010008)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CLK_b1                                 ((uint32_t)0x52010009)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CLK_b2                                 ((uint32_t)0x5201000A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CLK_b3                                 ((uint32_t)0x5201000B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CLK_w                                  ((uint32_t)0x52020008)  /*!< Reg Absolute Address */
#define URT2_CLK_h0                                 ((uint32_t)0x52020008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CLK_h1                                 ((uint32_t)0x5202000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CLK_b0                                 ((uint32_t)0x52020008)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CLK_b1                                 ((uint32_t)0x52020009)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CLK_b2                                 ((uint32_t)0x5202000A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CLK_b3                                 ((uint32_t)0x5202000B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CLK_w                                  ((uint32_t)0x52030008)  /*!< Reg Absolute Address */
#define URT3_CLK_h0                                 ((uint32_t)0x52030008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CLK_h1                                 ((uint32_t)0x5203000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CLK_b0                                 ((uint32_t)0x52030008)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CLK_b1                                 ((uint32_t)0x52030009)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CLK_b2                                 ((uint32_t)0x5203000A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CLK_b3                                 ((uint32_t)0x5203000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_STA2  [register's definitions]
 *              Offset[0x0C]  URT status register 2
 ******************************************************************************
 */
///@{
#define URT0_STA2_w                                 ((uint32_t)0x5200000C)  /*!< Reg Absolute Address */
#define URT0_STA2_h0                                ((uint32_t)0x5200000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_STA2_h1                                ((uint32_t)0x5200000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_STA2_b0                                ((uint32_t)0x5200000C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_STA2_b1                                ((uint32_t)0x5200000D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_STA2_b2                                ((uint32_t)0x5200000E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_STA2_b3                                ((uint32_t)0x5200000F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_STA2_w                                 ((uint32_t)0x5201000C)  /*!< Reg Absolute Address */
#define URT1_STA2_h0                                ((uint32_t)0x5201000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_STA2_h1                                ((uint32_t)0x5201000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_STA2_b0                                ((uint32_t)0x5201000C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_STA2_b1                                ((uint32_t)0x5201000D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_STA2_b2                                ((uint32_t)0x5201000E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_STA2_b3                                ((uint32_t)0x5201000F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_STA2_w                                 ((uint32_t)0x5202000C)  /*!< Reg Absolute Address */
#define URT2_STA2_h0                                ((uint32_t)0x5202000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_STA2_h1                                ((uint32_t)0x5202000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_STA2_b0                                ((uint32_t)0x5202000C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_STA2_b1                                ((uint32_t)0x5202000D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_STA2_b2                                ((uint32_t)0x5202000E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_STA2_b3                                ((uint32_t)0x5202000F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_STA2_w                                 ((uint32_t)0x5203000C)  /*!< Reg Absolute Address */
#define URT3_STA2_h0                                ((uint32_t)0x5203000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_STA2_h1                                ((uint32_t)0x5203000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_STA2_b0                                ((uint32_t)0x5203000C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_STA2_b1                                ((uint32_t)0x5203000D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_STA2_b2                                ((uint32_t)0x5203000E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_STA2_b3                                ((uint32_t)0x5203000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CR0  [register's definitions]
 *              Offset[0x10]  URT control register 0
 ******************************************************************************
 */
///@{
#define URT0_CR0_w                                  ((uint32_t)0x52000010)  /*!< Reg Absolute Address */
#define URT0_CR0_h0                                 ((uint32_t)0x52000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CR0_h1                                 ((uint32_t)0x52000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CR0_b0                                 ((uint32_t)0x52000010)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CR0_b1                                 ((uint32_t)0x52000011)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CR0_b2                                 ((uint32_t)0x52000012)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CR0_b3                                 ((uint32_t)0x52000013)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CR0_w                                  ((uint32_t)0x52010010)  /*!< Reg Absolute Address */
#define URT1_CR0_h0                                 ((uint32_t)0x52010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CR0_h1                                 ((uint32_t)0x52010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CR0_b0                                 ((uint32_t)0x52010010)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CR0_b1                                 ((uint32_t)0x52010011)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CR0_b2                                 ((uint32_t)0x52010012)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CR0_b3                                 ((uint32_t)0x52010013)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CR0_w                                  ((uint32_t)0x52020010)  /*!< Reg Absolute Address */
#define URT2_CR0_h0                                 ((uint32_t)0x52020010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CR0_h1                                 ((uint32_t)0x52020012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CR0_b0                                 ((uint32_t)0x52020010)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CR0_b1                                 ((uint32_t)0x52020011)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CR0_b2                                 ((uint32_t)0x52020012)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CR0_b3                                 ((uint32_t)0x52020013)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CR0_w                                  ((uint32_t)0x52030010)  /*!< Reg Absolute Address */
#define URT3_CR0_h0                                 ((uint32_t)0x52030010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CR0_h1                                 ((uint32_t)0x52030012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CR0_b0                                 ((uint32_t)0x52030010)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CR0_b1                                 ((uint32_t)0x52030011)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CR0_b2                                 ((uint32_t)0x52030012)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CR0_b3                                 ((uint32_t)0x52030013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CR1  [register's definitions]
 *              Offset[0x14]  URT control register 1
 ******************************************************************************
 */
///@{
#define URT0_CR1_w                                  ((uint32_t)0x52000014)  /*!< Reg Absolute Address */
#define URT0_CR1_h0                                 ((uint32_t)0x52000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CR1_h1                                 ((uint32_t)0x52000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CR1_b0                                 ((uint32_t)0x52000014)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CR1_b1                                 ((uint32_t)0x52000015)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CR1_b2                                 ((uint32_t)0x52000016)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CR1_b3                                 ((uint32_t)0x52000017)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CR1_w                                  ((uint32_t)0x52010014)  /*!< Reg Absolute Address */
#define URT1_CR1_h0                                 ((uint32_t)0x52010014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CR1_h1                                 ((uint32_t)0x52010016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CR1_b0                                 ((uint32_t)0x52010014)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CR1_b1                                 ((uint32_t)0x52010015)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CR1_b2                                 ((uint32_t)0x52010016)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CR1_b3                                 ((uint32_t)0x52010017)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CR1_w                                  ((uint32_t)0x52020014)  /*!< Reg Absolute Address */
#define URT2_CR1_h0                                 ((uint32_t)0x52020014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CR1_h1                                 ((uint32_t)0x52020016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CR1_b0                                 ((uint32_t)0x52020014)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CR1_b1                                 ((uint32_t)0x52020015)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CR1_b2                                 ((uint32_t)0x52020016)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CR1_b3                                 ((uint32_t)0x52020017)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CR1_w                                  ((uint32_t)0x52030014)  /*!< Reg Absolute Address */
#define URT3_CR1_h0                                 ((uint32_t)0x52030014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CR1_h1                                 ((uint32_t)0x52030016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CR1_b0                                 ((uint32_t)0x52030014)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CR1_b1                                 ((uint32_t)0x52030015)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CR1_b2                                 ((uint32_t)0x52030016)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CR1_b3                                 ((uint32_t)0x52030017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CR2  [register's definitions]
 *              Offset[0x18]  URT control register 2
 ******************************************************************************
 */
///@{
#define URT0_CR2_w                                  ((uint32_t)0x52000018)  /*!< Reg Absolute Address */
#define URT0_CR2_h0                                 ((uint32_t)0x52000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CR2_h1                                 ((uint32_t)0x5200001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CR2_b0                                 ((uint32_t)0x52000018)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CR2_b1                                 ((uint32_t)0x52000019)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CR2_b2                                 ((uint32_t)0x5200001A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CR2_b3                                 ((uint32_t)0x5200001B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CR2_w                                  ((uint32_t)0x52010018)  /*!< Reg Absolute Address */
#define URT1_CR2_h0                                 ((uint32_t)0x52010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CR2_h1                                 ((uint32_t)0x5201001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CR2_b0                                 ((uint32_t)0x52010018)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CR2_b1                                 ((uint32_t)0x52010019)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CR2_b2                                 ((uint32_t)0x5201001A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CR2_b3                                 ((uint32_t)0x5201001B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CR2_w                                  ((uint32_t)0x52020018)  /*!< Reg Absolute Address */
#define URT2_CR2_h0                                 ((uint32_t)0x52020018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CR2_h1                                 ((uint32_t)0x5202001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CR2_b0                                 ((uint32_t)0x52020018)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CR2_b1                                 ((uint32_t)0x52020019)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CR2_b2                                 ((uint32_t)0x5202001A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CR2_b3                                 ((uint32_t)0x5202001B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CR2_w                                  ((uint32_t)0x52030018)  /*!< Reg Absolute Address */
#define URT3_CR2_h0                                 ((uint32_t)0x52030018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CR2_h1                                 ((uint32_t)0x5203001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CR2_b0                                 ((uint32_t)0x52030018)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CR2_b1                                 ((uint32_t)0x52030019)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CR2_b2                                 ((uint32_t)0x5203001A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CR2_b3                                 ((uint32_t)0x5203001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CR3  [register's definitions]
 *              Offset[0x1C]  URT control register 3
 ******************************************************************************
 */
///@{
#define URT0_CR3_w                                  ((uint32_t)0x5200001C)  /*!< Reg Absolute Address */
#define URT0_CR3_h0                                 ((uint32_t)0x5200001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CR3_h1                                 ((uint32_t)0x5200001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CR3_b0                                 ((uint32_t)0x5200001C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CR3_b1                                 ((uint32_t)0x5200001D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CR3_b2                                 ((uint32_t)0x5200001E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CR3_b3                                 ((uint32_t)0x5200001F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CR3_w                                  ((uint32_t)0x5201001C)  /*!< Reg Absolute Address */
#define URT1_CR3_h0                                 ((uint32_t)0x5201001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CR3_h1                                 ((uint32_t)0x5201001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CR3_b0                                 ((uint32_t)0x5201001C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CR3_b1                                 ((uint32_t)0x5201001D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CR3_b2                                 ((uint32_t)0x5201001E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CR3_b3                                 ((uint32_t)0x5201001F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CR3_w                                  ((uint32_t)0x5202001C)  /*!< Reg Absolute Address */
#define URT2_CR3_h0                                 ((uint32_t)0x5202001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CR3_h1                                 ((uint32_t)0x5202001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CR3_b0                                 ((uint32_t)0x5202001C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CR3_b1                                 ((uint32_t)0x5202001D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CR3_b2                                 ((uint32_t)0x5202001E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CR3_b3                                 ((uint32_t)0x5202001F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CR3_w                                  ((uint32_t)0x5203001C)  /*!< Reg Absolute Address */
#define URT3_CR3_h0                                 ((uint32_t)0x5203001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CR3_h1                                 ((uint32_t)0x5203001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CR3_b0                                 ((uint32_t)0x5203001C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CR3_b1                                 ((uint32_t)0x5203001D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CR3_b2                                 ((uint32_t)0x5203001E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CR3_b3                                 ((uint32_t)0x5203001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CR4  [register's definitions]
 *              Offset[0x20]  URT control register 4
 ******************************************************************************
 */
///@{
#define URT0_CR4_w                                  ((uint32_t)0x52000020)  /*!< Reg Absolute Address */
#define URT0_CR4_h0                                 ((uint32_t)0x52000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CR4_h1                                 ((uint32_t)0x52000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CR4_b0                                 ((uint32_t)0x52000020)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CR4_b1                                 ((uint32_t)0x52000021)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CR4_b2                                 ((uint32_t)0x52000022)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CR4_b3                                 ((uint32_t)0x52000023)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CR4_w                                  ((uint32_t)0x52010020)  /*!< Reg Absolute Address */
#define URT1_CR4_h0                                 ((uint32_t)0x52010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CR4_h1                                 ((uint32_t)0x52010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CR4_b0                                 ((uint32_t)0x52010020)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CR4_b1                                 ((uint32_t)0x52010021)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CR4_b2                                 ((uint32_t)0x52010022)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CR4_b3                                 ((uint32_t)0x52010023)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CR4_w                                  ((uint32_t)0x52020020)  /*!< Reg Absolute Address */
#define URT2_CR4_h0                                 ((uint32_t)0x52020020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CR4_h1                                 ((uint32_t)0x52020022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CR4_b0                                 ((uint32_t)0x52020020)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CR4_b1                                 ((uint32_t)0x52020021)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CR4_b2                                 ((uint32_t)0x52020022)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CR4_b3                                 ((uint32_t)0x52020023)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CR4_w                                  ((uint32_t)0x52030020)  /*!< Reg Absolute Address */
#define URT3_CR4_h0                                 ((uint32_t)0x52030020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CR4_h1                                 ((uint32_t)0x52030022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CR4_b0                                 ((uint32_t)0x52030020)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CR4_b1                                 ((uint32_t)0x52030021)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CR4_b2                                 ((uint32_t)0x52030022)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CR4_b3                                 ((uint32_t)0x52030023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_RLR  [register's definitions]
 *              Offset[0x24]  URT baud-rate clock counter reload register
 ******************************************************************************
 */
///@{
#define URT0_RLR_w                                  ((uint32_t)0x52000024)  /*!< Reg Absolute Address */
#define URT0_RLR_h0                                 ((uint32_t)0x52000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_RLR_h1                                 ((uint32_t)0x52000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_RLR_b0                                 ((uint32_t)0x52000024)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_RLR_b1                                 ((uint32_t)0x52000025)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_RLR_b2                                 ((uint32_t)0x52000026)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_RLR_b3                                 ((uint32_t)0x52000027)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_RLR_w                                  ((uint32_t)0x52010024)  /*!< Reg Absolute Address */
#define URT1_RLR_h0                                 ((uint32_t)0x52010024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_RLR_h1                                 ((uint32_t)0x52010026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_RLR_b0                                 ((uint32_t)0x52010024)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_RLR_b1                                 ((uint32_t)0x52010025)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_RLR_b2                                 ((uint32_t)0x52010026)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_RLR_b3                                 ((uint32_t)0x52010027)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_RLR_w                                  ((uint32_t)0x52020024)  /*!< Reg Absolute Address */
#define URT2_RLR_h0                                 ((uint32_t)0x52020024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_RLR_h1                                 ((uint32_t)0x52020026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_RLR_b0                                 ((uint32_t)0x52020024)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_RLR_b1                                 ((uint32_t)0x52020025)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_RLR_b2                                 ((uint32_t)0x52020026)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_RLR_b3                                 ((uint32_t)0x52020027)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_RLR_w                                  ((uint32_t)0x52030024)  /*!< Reg Absolute Address */
#define URT3_RLR_h0                                 ((uint32_t)0x52030024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_RLR_h1                                 ((uint32_t)0x52030026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_RLR_b0                                 ((uint32_t)0x52030024)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_RLR_b1                                 ((uint32_t)0x52030025)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_RLR_b2                                 ((uint32_t)0x52030026)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_RLR_b3                                 ((uint32_t)0x52030027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CNT  [register's definitions]
 *              Offset[0x28]  URT baud-rate clock counter register
 ******************************************************************************
 */
///@{
#define URT0_CNT_w                                  ((uint32_t)0x52000028)  /*!< Reg Absolute Address */
#define URT0_CNT_h0                                 ((uint32_t)0x52000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CNT_h1                                 ((uint32_t)0x5200002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CNT_b0                                 ((uint32_t)0x52000028)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CNT_b1                                 ((uint32_t)0x52000029)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CNT_b2                                 ((uint32_t)0x5200002A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CNT_b3                                 ((uint32_t)0x5200002B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CNT_w                                  ((uint32_t)0x52010028)  /*!< Reg Absolute Address */
#define URT1_CNT_h0                                 ((uint32_t)0x52010028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CNT_h1                                 ((uint32_t)0x5201002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CNT_b0                                 ((uint32_t)0x52010028)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CNT_b1                                 ((uint32_t)0x52010029)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CNT_b2                                 ((uint32_t)0x5201002A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CNT_b3                                 ((uint32_t)0x5201002B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CNT_w                                  ((uint32_t)0x52020028)  /*!< Reg Absolute Address */
#define URT2_CNT_h0                                 ((uint32_t)0x52020028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CNT_h1                                 ((uint32_t)0x5202002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CNT_b0                                 ((uint32_t)0x52020028)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CNT_b1                                 ((uint32_t)0x52020029)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CNT_b2                                 ((uint32_t)0x5202002A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CNT_b3                                 ((uint32_t)0x5202002B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CNT_w                                  ((uint32_t)0x52030028)  /*!< Reg Absolute Address */
#define URT3_CNT_h0                                 ((uint32_t)0x52030028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CNT_h1                                 ((uint32_t)0x5203002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CNT_b0                                 ((uint32_t)0x52030028)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CNT_b1                                 ((uint32_t)0x52030029)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CNT_b2                                 ((uint32_t)0x5203002A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CNT_b3                                 ((uint32_t)0x5203002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_RCAP  [register's definitions]
 *              Offset[0x2C]  URT RX data capture register
 ******************************************************************************
 */
///@{
#define URT0_RCAP_w                                 ((uint32_t)0x5200002C)  /*!< Reg Absolute Address */
#define URT0_RCAP_h0                                ((uint32_t)0x5200002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_RCAP_h1                                ((uint32_t)0x5200002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_RCAP_b0                                ((uint32_t)0x5200002C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_RCAP_b1                                ((uint32_t)0x5200002D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_RCAP_b2                                ((uint32_t)0x5200002E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_RCAP_b3                                ((uint32_t)0x5200002F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_RCAP_w                                 ((uint32_t)0x5201002C)  /*!< Reg Absolute Address */
#define URT1_RCAP_h0                                ((uint32_t)0x5201002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_RCAP_h1                                ((uint32_t)0x5201002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_RCAP_b0                                ((uint32_t)0x5201002C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_RCAP_b1                                ((uint32_t)0x5201002D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_RCAP_b2                                ((uint32_t)0x5201002E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_RCAP_b3                                ((uint32_t)0x5201002F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_RCAP_w                                 ((uint32_t)0x5202002C)  /*!< Reg Absolute Address */
#define URT2_RCAP_h0                                ((uint32_t)0x5202002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_RCAP_h1                                ((uint32_t)0x5202002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_RCAP_b0                                ((uint32_t)0x5202002C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_RCAP_b1                                ((uint32_t)0x5202002D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_RCAP_b2                                ((uint32_t)0x5202002E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_RCAP_b3                                ((uint32_t)0x5202002F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_RCAP_w                                 ((uint32_t)0x5203002C)  /*!< Reg Absolute Address */
#define URT3_RCAP_h0                                ((uint32_t)0x5203002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_RCAP_h1                                ((uint32_t)0x5203002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_RCAP_b0                                ((uint32_t)0x5203002C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_RCAP_b1                                ((uint32_t)0x5203002D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_RCAP_b2                                ((uint32_t)0x5203002E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_RCAP_b3                                ((uint32_t)0x5203002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_RDAT  [register's definitions]
 *              Offset[0x30]  URT RX data register
 ******************************************************************************
 */
///@{
#define URT0_RDAT_w                                 ((uint32_t)0x52000030)  /*!< Reg Absolute Address */
#define URT0_RDAT_h0                                ((uint32_t)0x52000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_RDAT_h1                                ((uint32_t)0x52000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_RDAT_b0                                ((uint32_t)0x52000030)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_RDAT_b1                                ((uint32_t)0x52000031)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_RDAT_b2                                ((uint32_t)0x52000032)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_RDAT_b3                                ((uint32_t)0x52000033)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_RDAT_w                                 ((uint32_t)0x52010030)  /*!< Reg Absolute Address */
#define URT1_RDAT_h0                                ((uint32_t)0x52010030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_RDAT_h1                                ((uint32_t)0x52010032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_RDAT_b0                                ((uint32_t)0x52010030)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_RDAT_b1                                ((uint32_t)0x52010031)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_RDAT_b2                                ((uint32_t)0x52010032)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_RDAT_b3                                ((uint32_t)0x52010033)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_RDAT_w                                 ((uint32_t)0x52020030)  /*!< Reg Absolute Address */
#define URT2_RDAT_h0                                ((uint32_t)0x52020030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_RDAT_h1                                ((uint32_t)0x52020032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_RDAT_b0                                ((uint32_t)0x52020030)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_RDAT_b1                                ((uint32_t)0x52020031)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_RDAT_b2                                ((uint32_t)0x52020032)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_RDAT_b3                                ((uint32_t)0x52020033)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_RDAT_w                                 ((uint32_t)0x52030030)  /*!< Reg Absolute Address */
#define URT3_RDAT_h0                                ((uint32_t)0x52030030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_RDAT_h1                                ((uint32_t)0x52030032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_RDAT_b0                                ((uint32_t)0x52030030)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_RDAT_b1                                ((uint32_t)0x52030031)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_RDAT_b2                                ((uint32_t)0x52030032)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_RDAT_b3                                ((uint32_t)0x52030033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_TDAT  [register's definitions]
 *              Offset[0x34]  URT TX data register
 ******************************************************************************
 */
///@{
#define URT0_TDAT_w                                 ((uint32_t)0x52000034)  /*!< Reg Absolute Address */
#define URT0_TDAT_h0                                ((uint32_t)0x52000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_TDAT_h1                                ((uint32_t)0x52000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_TDAT_b0                                ((uint32_t)0x52000034)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_TDAT_b1                                ((uint32_t)0x52000035)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_TDAT_b2                                ((uint32_t)0x52000036)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_TDAT_b3                                ((uint32_t)0x52000037)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_TDAT_w                                 ((uint32_t)0x52010034)  /*!< Reg Absolute Address */
#define URT1_TDAT_h0                                ((uint32_t)0x52010034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_TDAT_h1                                ((uint32_t)0x52010036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_TDAT_b0                                ((uint32_t)0x52010034)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_TDAT_b1                                ((uint32_t)0x52010035)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_TDAT_b2                                ((uint32_t)0x52010036)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_TDAT_b3                                ((uint32_t)0x52010037)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_TDAT_w                                 ((uint32_t)0x52020034)  /*!< Reg Absolute Address */
#define URT2_TDAT_h0                                ((uint32_t)0x52020034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_TDAT_h1                                ((uint32_t)0x52020036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_TDAT_b0                                ((uint32_t)0x52020034)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_TDAT_b1                                ((uint32_t)0x52020035)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_TDAT_b2                                ((uint32_t)0x52020036)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_TDAT_b3                                ((uint32_t)0x52020037)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_TDAT_w                                 ((uint32_t)0x52030034)  /*!< Reg Absolute Address */
#define URT3_TDAT_h0                                ((uint32_t)0x52030034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_TDAT_h1                                ((uint32_t)0x52030036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_TDAT_b0                                ((uint32_t)0x52030034)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_TDAT_b1                                ((uint32_t)0x52030035)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_TDAT_b2                                ((uint32_t)0x52030036)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_TDAT_b3                                ((uint32_t)0x52030037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_TDAT3  [register's definitions]
 *              Offset[0x38]  URT TX data 3-byte register
 ******************************************************************************
 */
///@{
#define URT0_TDAT3_w                                ((uint32_t)0x52000038)  /*!< Reg Absolute Address */
#define URT0_TDAT3_h0                               ((uint32_t)0x52000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_TDAT3_h1                               ((uint32_t)0x5200003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_TDAT3_b0                               ((uint32_t)0x52000038)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_TDAT3_b1                               ((uint32_t)0x52000039)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_TDAT3_b2                               ((uint32_t)0x5200003A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_TDAT3_b3                               ((uint32_t)0x5200003B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_TDAT3_w                                ((uint32_t)0x52010038)  /*!< Reg Absolute Address */
#define URT1_TDAT3_h0                               ((uint32_t)0x52010038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_TDAT3_h1                               ((uint32_t)0x5201003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_TDAT3_b0                               ((uint32_t)0x52010038)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_TDAT3_b1                               ((uint32_t)0x52010039)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_TDAT3_b2                               ((uint32_t)0x5201003A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_TDAT3_b3                               ((uint32_t)0x5201003B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_TDAT3_w                                ((uint32_t)0x52020038)  /*!< Reg Absolute Address */
#define URT2_TDAT3_h0                               ((uint32_t)0x52020038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_TDAT3_h1                               ((uint32_t)0x5202003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_TDAT3_b0                               ((uint32_t)0x52020038)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_TDAT3_b1                               ((uint32_t)0x52020039)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_TDAT3_b2                               ((uint32_t)0x5202003A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_TDAT3_b3                               ((uint32_t)0x5202003B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_TDAT3_w                                ((uint32_t)0x52030038)  /*!< Reg Absolute Address */
#define URT3_TDAT3_h0                               ((uint32_t)0x52030038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_TDAT3_h1                               ((uint32_t)0x5203003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_TDAT3_b0                               ((uint32_t)0x52030038)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_TDAT3_b1                               ((uint32_t)0x52030039)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_TDAT3_b2                               ((uint32_t)0x5203003A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_TDAT3_b3                               ((uint32_t)0x5203003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_SBUF  [register's definitions]
 *              Offset[0x3C]  URT data shift buffer register
 ******************************************************************************
 */
///@{
#define URT0_SBUF_w                                 ((uint32_t)0x5200003C)  /*!< Reg Absolute Address */
#define URT0_SBUF_h0                                ((uint32_t)0x5200003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_SBUF_h1                                ((uint32_t)0x5200003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_SBUF_b0                                ((uint32_t)0x5200003C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_SBUF_b1                                ((uint32_t)0x5200003D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_SBUF_b2                                ((uint32_t)0x5200003E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_SBUF_b3                                ((uint32_t)0x5200003F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_SBUF_w                                 ((uint32_t)0x5201003C)  /*!< Reg Absolute Address */
#define URT1_SBUF_h0                                ((uint32_t)0x5201003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_SBUF_h1                                ((uint32_t)0x5201003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_SBUF_b0                                ((uint32_t)0x5201003C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_SBUF_b1                                ((uint32_t)0x5201003D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_SBUF_b2                                ((uint32_t)0x5201003E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_SBUF_b3                                ((uint32_t)0x5201003F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_SBUF_w                                 ((uint32_t)0x5202003C)  /*!< Reg Absolute Address */
#define URT2_SBUF_h0                                ((uint32_t)0x5202003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_SBUF_h1                                ((uint32_t)0x5202003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_SBUF_b0                                ((uint32_t)0x5202003C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_SBUF_b1                                ((uint32_t)0x5202003D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_SBUF_b2                                ((uint32_t)0x5202003E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_SBUF_b3                                ((uint32_t)0x5202003F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_SBUF_w                                 ((uint32_t)0x5203003C)  /*!< Reg Absolute Address */
#define URT3_SBUF_h0                                ((uint32_t)0x5203003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_SBUF_h1                                ((uint32_t)0x5203003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_SBUF_b0                                ((uint32_t)0x5203003C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_SBUF_b1                                ((uint32_t)0x5203003D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_SBUF_b2                                ((uint32_t)0x5203003E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_SBUF_b3                                ((uint32_t)0x5203003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT  [register's definitions]
 *              Offset[0x40]  URT timeout control register
 ******************************************************************************
 */
///@{
#define URT0_TMOUT_w                                ((uint32_t)0x52000040)  /*!< Reg Absolute Address */
#define URT0_TMOUT_h0                               ((uint32_t)0x52000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_TMOUT_h1                               ((uint32_t)0x52000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_TMOUT_b0                               ((uint32_t)0x52000040)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_TMOUT_b1                               ((uint32_t)0x52000041)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_TMOUT_b2                               ((uint32_t)0x52000042)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_TMOUT_b3                               ((uint32_t)0x52000043)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_TMOUT_w                                ((uint32_t)0x52010040)  /*!< Reg Absolute Address */
#define URT1_TMOUT_h0                               ((uint32_t)0x52010040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_TMOUT_h1                               ((uint32_t)0x52010042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_TMOUT_b0                               ((uint32_t)0x52010040)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_TMOUT_b1                               ((uint32_t)0x52010041)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_TMOUT_b2                               ((uint32_t)0x52010042)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_TMOUT_b3                               ((uint32_t)0x52010043)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_TMOUT_w                                ((uint32_t)0x52020040)  /*!< Reg Absolute Address */
#define URT2_TMOUT_h0                               ((uint32_t)0x52020040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_TMOUT_h1                               ((uint32_t)0x52020042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_TMOUT_b0                               ((uint32_t)0x52020040)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_TMOUT_b1                               ((uint32_t)0x52020041)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_TMOUT_b2                               ((uint32_t)0x52020042)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_TMOUT_b3                               ((uint32_t)0x52020043)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_TMOUT_w                                ((uint32_t)0x52030040)  /*!< Reg Absolute Address */
#define URT3_TMOUT_h0                               ((uint32_t)0x52030040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_TMOUT_h1                               ((uint32_t)0x52030042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_TMOUT_b0                               ((uint32_t)0x52030040)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_TMOUT_b1                               ((uint32_t)0x52030041)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_TMOUT_b2                               ((uint32_t)0x52030042)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_TMOUT_b3                               ((uint32_t)0x52030043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT2  [register's definitions]
 *              Offset[0x44]  URT timeout control register 2
 ******************************************************************************
 */
///@{
#define URT0_TMOUT2_w                               ((uint32_t)0x52000044)  /*!< Reg Absolute Address */
#define URT0_TMOUT2_h0                              ((uint32_t)0x52000044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_TMOUT2_h1                              ((uint32_t)0x52000046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_TMOUT2_b0                              ((uint32_t)0x52000044)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_TMOUT2_b1                              ((uint32_t)0x52000045)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_TMOUT2_b2                              ((uint32_t)0x52000046)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_TMOUT2_b3                              ((uint32_t)0x52000047)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_TMOUT2_w                               ((uint32_t)0x52010044)  /*!< Reg Absolute Address */
#define URT1_TMOUT2_h0                              ((uint32_t)0x52010044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_TMOUT2_h1                              ((uint32_t)0x52010046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_TMOUT2_b0                              ((uint32_t)0x52010044)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_TMOUT2_b1                              ((uint32_t)0x52010045)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_TMOUT2_b2                              ((uint32_t)0x52010046)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_TMOUT2_b3                              ((uint32_t)0x52010047)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_TMOUT2_w                               ((uint32_t)0x52020044)  /*!< Reg Absolute Address */
#define URT2_TMOUT2_h0                              ((uint32_t)0x52020044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_TMOUT2_h1                              ((uint32_t)0x52020046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_TMOUT2_b0                              ((uint32_t)0x52020044)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_TMOUT2_b1                              ((uint32_t)0x52020045)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_TMOUT2_b2                              ((uint32_t)0x52020046)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_TMOUT2_b3                              ((uint32_t)0x52020047)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_TMOUT2_w                               ((uint32_t)0x52030044)  /*!< Reg Absolute Address */
#define URT3_TMOUT2_h0                              ((uint32_t)0x52030044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_TMOUT2_h1                              ((uint32_t)0x52030046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_TMOUT2_b0                              ((uint32_t)0x52030044)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_TMOUT2_b1                              ((uint32_t)0x52030045)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_TMOUT2_b2                              ((uint32_t)0x52030046)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_TMOUT2_b3                              ((uint32_t)0x52030047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_SC  [register's definitions]
 *              Offset[0x48]  URT SmartCard control register
 ******************************************************************************
 */
///@{
#define URT0_SC_w                                   ((uint32_t)0x52000048)  /*!< Reg Absolute Address */
#define URT0_SC_h0                                  ((uint32_t)0x52000048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_SC_h1                                  ((uint32_t)0x5200004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_SC_b0                                  ((uint32_t)0x52000048)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_SC_b1                                  ((uint32_t)0x52000049)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_SC_b2                                  ((uint32_t)0x5200004A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_SC_b3                                  ((uint32_t)0x5200004B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_SC_w                                   ((uint32_t)0x52010048)  /*!< Reg Absolute Address */
#define URT1_SC_h0                                  ((uint32_t)0x52010048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_SC_h1                                  ((uint32_t)0x5201004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_SC_b0                                  ((uint32_t)0x52010048)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_SC_b1                                  ((uint32_t)0x52010049)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_SC_b2                                  ((uint32_t)0x5201004A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_SC_b3                                  ((uint32_t)0x5201004B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_SC_w                                   ((uint32_t)0x52020048)  /*!< Reg Absolute Address */
#define URT2_SC_h0                                  ((uint32_t)0x52020048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_SC_h1                                  ((uint32_t)0x5202004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_SC_b0                                  ((uint32_t)0x52020048)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_SC_b1                                  ((uint32_t)0x52020049)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_SC_b2                                  ((uint32_t)0x5202004A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_SC_b3                                  ((uint32_t)0x5202004B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_SC_w                                   ((uint32_t)0x52030048)  /*!< Reg Absolute Address */
#define URT3_SC_h0                                  ((uint32_t)0x52030048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_SC_h1                                  ((uint32_t)0x5203004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_SC_b0                                  ((uint32_t)0x52030048)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_SC_b1                                  ((uint32_t)0x52030049)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_SC_b2                                  ((uint32_t)0x5203004A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_SC_b3                                  ((uint32_t)0x5203004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_SADR  [register's definitions]
 *              Offset[0x4C]  URT slave address detect register
 ******************************************************************************
 */
///@{
#define URT0_SADR_w                                 ((uint32_t)0x5200004C)  /*!< Reg Absolute Address */
#define URT0_SADR_h0                                ((uint32_t)0x5200004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_SADR_h1                                ((uint32_t)0x5200004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_SADR_b0                                ((uint32_t)0x5200004C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_SADR_b1                                ((uint32_t)0x5200004D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_SADR_b2                                ((uint32_t)0x5200004E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_SADR_b3                                ((uint32_t)0x5200004F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_SADR_w                                 ((uint32_t)0x5201004C)  /*!< Reg Absolute Address */
#define URT1_SADR_h0                                ((uint32_t)0x5201004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_SADR_h1                                ((uint32_t)0x5201004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_SADR_b0                                ((uint32_t)0x5201004C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_SADR_b1                                ((uint32_t)0x5201004D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_SADR_b2                                ((uint32_t)0x5201004E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_SADR_b3                                ((uint32_t)0x5201004F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_SADR_w                                 ((uint32_t)0x5202004C)  /*!< Reg Absolute Address */
#define URT2_SADR_h0                                ((uint32_t)0x5202004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_SADR_h1                                ((uint32_t)0x5202004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_SADR_b0                                ((uint32_t)0x5202004C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_SADR_b1                                ((uint32_t)0x5202004D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_SADR_b2                                ((uint32_t)0x5202004E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_SADR_b3                                ((uint32_t)0x5202004F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_SADR_w                                 ((uint32_t)0x5203004C)  /*!< Reg Absolute Address */
#define URT3_SADR_h0                                ((uint32_t)0x5203004C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_SADR_h1                                ((uint32_t)0x5203004E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_SADR_b0                                ((uint32_t)0x5203004C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_SADR_b1                                ((uint32_t)0x5203004D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_SADR_b2                                ((uint32_t)0x5203004E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_SADR_b3                                ((uint32_t)0x5203004F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_CAL  [register's definitions]
 *              Offset[0x50]  URT calibration control register
 ******************************************************************************
 */
///@{
#define URT0_CAL_w                                  ((uint32_t)0x52000050)  /*!< Reg Absolute Address */
#define URT0_CAL_h0                                 ((uint32_t)0x52000050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_CAL_h1                                 ((uint32_t)0x52000052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_CAL_b0                                 ((uint32_t)0x52000050)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_CAL_b1                                 ((uint32_t)0x52000051)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_CAL_b2                                 ((uint32_t)0x52000052)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_CAL_b3                                 ((uint32_t)0x52000053)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_CAL_w                                  ((uint32_t)0x52010050)  /*!< Reg Absolute Address */
#define URT1_CAL_h0                                 ((uint32_t)0x52010050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_CAL_h1                                 ((uint32_t)0x52010052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_CAL_b0                                 ((uint32_t)0x52010050)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_CAL_b1                                 ((uint32_t)0x52010051)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_CAL_b2                                 ((uint32_t)0x52010052)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_CAL_b3                                 ((uint32_t)0x52010053)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_CAL_w                                  ((uint32_t)0x52020050)  /*!< Reg Absolute Address */
#define URT2_CAL_h0                                 ((uint32_t)0x52020050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_CAL_h1                                 ((uint32_t)0x52020052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_CAL_b0                                 ((uint32_t)0x52020050)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_CAL_b1                                 ((uint32_t)0x52020051)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_CAL_b2                                 ((uint32_t)0x52020052)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_CAL_b3                                 ((uint32_t)0x52020053)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_CAL_w                                  ((uint32_t)0x52030050)  /*!< Reg Absolute Address */
#define URT3_CAL_h0                                 ((uint32_t)0x52030050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_CAL_h1                                 ((uint32_t)0x52030052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_CAL_b0                                 ((uint32_t)0x52030050)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_CAL_b1                                 ((uint32_t)0x52030051)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_CAL_b2                                 ((uint32_t)0x52030052)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_CAL_b3                                 ((uint32_t)0x52030053)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_IRDA  [register's definitions]
 *              Offset[0x54]  URT IrDA control register
 ******************************************************************************
 */
///@{
#define URT0_IRDA_w                                 ((uint32_t)0x52000054)  /*!< Reg Absolute Address */
#define URT0_IRDA_h0                                ((uint32_t)0x52000054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_IRDA_h1                                ((uint32_t)0x52000056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_IRDA_b0                                ((uint32_t)0x52000054)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_IRDA_b1                                ((uint32_t)0x52000055)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_IRDA_b2                                ((uint32_t)0x52000056)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_IRDA_b3                                ((uint32_t)0x52000057)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_IRDA_w                                 ((uint32_t)0x52010054)  /*!< Reg Absolute Address */
#define URT1_IRDA_h0                                ((uint32_t)0x52010054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_IRDA_h1                                ((uint32_t)0x52010056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_IRDA_b0                                ((uint32_t)0x52010054)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_IRDA_b1                                ((uint32_t)0x52010055)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_IRDA_b2                                ((uint32_t)0x52010056)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_IRDA_b3                                ((uint32_t)0x52010057)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_IRDA_w                                 ((uint32_t)0x52020054)  /*!< Reg Absolute Address */
#define URT2_IRDA_h0                                ((uint32_t)0x52020054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_IRDA_h1                                ((uint32_t)0x52020056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_IRDA_b0                                ((uint32_t)0x52020054)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_IRDA_b1                                ((uint32_t)0x52020055)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_IRDA_b2                                ((uint32_t)0x52020056)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_IRDA_b3                                ((uint32_t)0x52020057)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_IRDA_w                                 ((uint32_t)0x52030054)  /*!< Reg Absolute Address */
#define URT3_IRDA_h0                                ((uint32_t)0x52030054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_IRDA_h1                                ((uint32_t)0x52030056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_IRDA_b0                                ((uint32_t)0x52030054)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_IRDA_b1                                ((uint32_t)0x52030055)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_IRDA_b2                                ((uint32_t)0x52030056)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_IRDA_b3                                ((uint32_t)0x52030057)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_HFC  [register's definitions]
 *              Offset[0x58]  URT hardware flow control register
 ******************************************************************************
 */
///@{
#define URT0_HFC_w                                  ((uint32_t)0x52000058)  /*!< Reg Absolute Address */
#define URT0_HFC_h0                                 ((uint32_t)0x52000058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_HFC_h1                                 ((uint32_t)0x5200005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_HFC_b0                                 ((uint32_t)0x52000058)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_HFC_b1                                 ((uint32_t)0x52000059)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_HFC_b2                                 ((uint32_t)0x5200005A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_HFC_b3                                 ((uint32_t)0x5200005B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_HFC_w                                  ((uint32_t)0x52010058)  /*!< Reg Absolute Address */
#define URT1_HFC_h0                                 ((uint32_t)0x52010058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_HFC_h1                                 ((uint32_t)0x5201005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_HFC_b0                                 ((uint32_t)0x52010058)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_HFC_b1                                 ((uint32_t)0x52010059)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_HFC_b2                                 ((uint32_t)0x5201005A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_HFC_b3                                 ((uint32_t)0x5201005B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_HFC_w                                  ((uint32_t)0x52020058)  /*!< Reg Absolute Address */
#define URT2_HFC_h0                                 ((uint32_t)0x52020058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_HFC_h1                                 ((uint32_t)0x5202005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_HFC_b0                                 ((uint32_t)0x52020058)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_HFC_b1                                 ((uint32_t)0x52020059)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_HFC_b2                                 ((uint32_t)0x5202005A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_HFC_b3                                 ((uint32_t)0x5202005B)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_HFC_w                                  ((uint32_t)0x52030058)  /*!< Reg Absolute Address */
#define URT3_HFC_h0                                 ((uint32_t)0x52030058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_HFC_h1                                 ((uint32_t)0x5203005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_HFC_b0                                 ((uint32_t)0x52030058)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_HFC_b1                                 ((uint32_t)0x52030059)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_HFC_b2                                 ((uint32_t)0x5203005A)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_HFC_b3                                 ((uint32_t)0x5203005B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        URT_MUTE  [register's definitions]
 *              Offset[0x5C]  URT mute control register
 ******************************************************************************
 */
///@{
#define URT0_MUTE_w                                 ((uint32_t)0x5200005C)  /*!< Reg Absolute Address */
#define URT0_MUTE_h0                                ((uint32_t)0x5200005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT0_MUTE_h1                                ((uint32_t)0x5200005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT0_MUTE_b0                                ((uint32_t)0x5200005C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT0_MUTE_b1                                ((uint32_t)0x5200005D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT0_MUTE_b2                                ((uint32_t)0x5200005E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT0_MUTE_b3                                ((uint32_t)0x5200005F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT1_MUTE_w                                 ((uint32_t)0x5201005C)  /*!< Reg Absolute Address */
#define URT1_MUTE_h0                                ((uint32_t)0x5201005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT1_MUTE_h1                                ((uint32_t)0x5201005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT1_MUTE_b0                                ((uint32_t)0x5201005C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT1_MUTE_b1                                ((uint32_t)0x5201005D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT1_MUTE_b2                                ((uint32_t)0x5201005E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT1_MUTE_b3                                ((uint32_t)0x5201005F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT2_MUTE_w                                 ((uint32_t)0x5202005C)  /*!< Reg Absolute Address */
#define URT2_MUTE_h0                                ((uint32_t)0x5202005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT2_MUTE_h1                                ((uint32_t)0x5202005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT2_MUTE_b0                                ((uint32_t)0x5202005C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT2_MUTE_b1                                ((uint32_t)0x5202005D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT2_MUTE_b2                                ((uint32_t)0x5202005E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT2_MUTE_b3                                ((uint32_t)0x5202005F)  /*!< Reg Absolute Address of [Byte-3] */
#define URT3_MUTE_w                                 ((uint32_t)0x5203005C)  /*!< Reg Absolute Address */
#define URT3_MUTE_h0                                ((uint32_t)0x5203005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define URT3_MUTE_h1                                ((uint32_t)0x5203005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define URT3_MUTE_b0                                ((uint32_t)0x5203005C)  /*!< Reg Absolute Address of [Byte-0] */
#define URT3_MUTE_b1                                ((uint32_t)0x5203005D)  /*!< Reg Absolute Address of [Byte-1] */
#define URT3_MUTE_b2                                ((uint32_t)0x5203005E)  /*!< Reg Absolute Address of [Byte-2] */
#define URT3_MUTE_b3                                ((uint32_t)0x5203005F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      SPI (SPI Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        SPI_STA  [register's definitions]
 *              Offset[0x00]  SPI status register
 ******************************************************************************
 */
///@{
#define SPI0_STA_w                                  ((uint32_t)0x53000000)  /*!< Reg Absolute Address */
#define SPI0_STA_h0                                 ((uint32_t)0x53000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_STA_h1                                 ((uint32_t)0x53000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_STA_b0                                 ((uint32_t)0x53000000)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_STA_b1                                 ((uint32_t)0x53000001)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_STA_b2                                 ((uint32_t)0x53000002)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_STA_b3                                 ((uint32_t)0x53000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_INT  [register's definitions]
 *              Offset[0x04]  SPI interrupt enable register
 ******************************************************************************
 */
///@{
#define SPI0_INT_w                                  ((uint32_t)0x53000004)  /*!< Reg Absolute Address */
#define SPI0_INT_h0                                 ((uint32_t)0x53000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_INT_h1                                 ((uint32_t)0x53000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_INT_b0                                 ((uint32_t)0x53000004)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_INT_b1                                 ((uint32_t)0x53000005)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_INT_b2                                 ((uint32_t)0x53000006)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_INT_b3                                 ((uint32_t)0x53000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_CLK  [register's definitions]
 *              Offset[0x08]  SPI clock source register
 ******************************************************************************
 */
///@{
#define SPI0_CLK_w                                  ((uint32_t)0x53000008)  /*!< Reg Absolute Address */
#define SPI0_CLK_h0                                 ((uint32_t)0x53000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_CLK_h1                                 ((uint32_t)0x5300000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_CLK_b0                                 ((uint32_t)0x53000008)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_CLK_b1                                 ((uint32_t)0x53000009)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_CLK_b2                                 ((uint32_t)0x5300000A)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_CLK_b3                                 ((uint32_t)0x5300000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_CR0  [register's definitions]
 *              Offset[0x10]  SPI control register 0
 ******************************************************************************
 */
///@{
#define SPI0_CR0_w                                  ((uint32_t)0x53000010)  /*!< Reg Absolute Address */
#define SPI0_CR0_h0                                 ((uint32_t)0x53000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_CR0_h1                                 ((uint32_t)0x53000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_CR0_b0                                 ((uint32_t)0x53000010)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_CR0_b1                                 ((uint32_t)0x53000011)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_CR0_b2                                 ((uint32_t)0x53000012)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_CR0_b3                                 ((uint32_t)0x53000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_CR1  [register's definitions]
 *              Offset[0x14]  SPI control register 1
 ******************************************************************************
 */
///@{
#define SPI0_CR1_w                                  ((uint32_t)0x53000014)  /*!< Reg Absolute Address */
#define SPI0_CR1_h0                                 ((uint32_t)0x53000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_CR1_h1                                 ((uint32_t)0x53000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_CR1_b0                                 ((uint32_t)0x53000014)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_CR1_b1                                 ((uint32_t)0x53000015)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_CR1_b2                                 ((uint32_t)0x53000016)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_CR1_b3                                 ((uint32_t)0x53000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_CR2  [register's definitions]
 *              Offset[0x18]  SPI control register 2
 ******************************************************************************
 */
///@{
#define SPI0_CR2_w                                  ((uint32_t)0x53000018)  /*!< Reg Absolute Address */
#define SPI0_CR2_h0                                 ((uint32_t)0x53000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_CR2_h1                                 ((uint32_t)0x5300001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_CR2_b0                                 ((uint32_t)0x53000018)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_CR2_b1                                 ((uint32_t)0x53000019)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_CR2_b2                                 ((uint32_t)0x5300001A)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_CR2_b3                                 ((uint32_t)0x5300001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_RDAT  [register's definitions]
 *              Offset[0x30]  SPI data receive register
 ******************************************************************************
 */
///@{
#define SPI0_RDAT_w                                 ((uint32_t)0x53000030)  /*!< Reg Absolute Address */
#define SPI0_RDAT_h0                                ((uint32_t)0x53000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_RDAT_h1                                ((uint32_t)0x53000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_RDAT_b0                                ((uint32_t)0x53000030)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_RDAT_b1                                ((uint32_t)0x53000031)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_RDAT_b2                                ((uint32_t)0x53000032)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_RDAT_b3                                ((uint32_t)0x53000033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT  [register's definitions]
 *              Offset[0x34]  SPI data transmit register
 ******************************************************************************
 */
///@{
#define SPI0_TDAT_w                                 ((uint32_t)0x53000034)  /*!< Reg Absolute Address */
#define SPI0_TDAT_h0                                ((uint32_t)0x53000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_TDAT_h1                                ((uint32_t)0x53000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_TDAT_b0                                ((uint32_t)0x53000034)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_TDAT_b1                                ((uint32_t)0x53000035)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_TDAT_b2                                ((uint32_t)0x53000036)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_TDAT_b3                                ((uint32_t)0x53000037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT3  [register's definitions]
 *              Offset[0x38]  SPI TX data 3-byte register
 ******************************************************************************
 */
///@{
#define SPI0_TDAT3_w                                ((uint32_t)0x53000038)  /*!< Reg Absolute Address */
#define SPI0_TDAT3_h0                               ((uint32_t)0x53000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define SPI0_TDAT3_h1                               ((uint32_t)0x5300003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define SPI0_TDAT3_b0                               ((uint32_t)0x53000038)  /*!< Reg Absolute Address of [Byte-0] */
#define SPI0_TDAT3_b1                               ((uint32_t)0x53000039)  /*!< Reg Absolute Address of [Byte-1] */
#define SPI0_TDAT3_b2                               ((uint32_t)0x5300003A)  /*!< Reg Absolute Address of [Byte-2] */
#define SPI0_TDAT3_b3                               ((uint32_t)0x5300003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      TM (Timer36 Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        TM_STA  [register's definitions]
 *              Offset[0x00]  TM Timer status register
 ******************************************************************************
 */
///@{
#define TM00_STA_w                                  ((uint32_t)0x55000000)  /*!< Reg Absolute Address */
#define TM00_STA_h0                                 ((uint32_t)0x55000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_STA_h1                                 ((uint32_t)0x55000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_STA_b0                                 ((uint32_t)0x55000000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_STA_b1                                 ((uint32_t)0x55000001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_STA_b2                                 ((uint32_t)0x55000002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_STA_b3                                 ((uint32_t)0x55000003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_STA_w                                  ((uint32_t)0x55010000)  /*!< Reg Absolute Address */
#define TM01_STA_h0                                 ((uint32_t)0x55010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_STA_h1                                 ((uint32_t)0x55010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_STA_b0                                 ((uint32_t)0x55010000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_STA_b1                                 ((uint32_t)0x55010001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_STA_b2                                 ((uint32_t)0x55010002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_STA_b3                                 ((uint32_t)0x55010003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_STA_w                                  ((uint32_t)0x55800000)  /*!< Reg Absolute Address */
#define TM10_STA_h0                                 ((uint32_t)0x55800000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_STA_h1                                 ((uint32_t)0x55800002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_STA_b0                                 ((uint32_t)0x55800000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_STA_b1                                 ((uint32_t)0x55800001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_STA_b2                                 ((uint32_t)0x55800002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_STA_b3                                 ((uint32_t)0x55800003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_STA_w                                  ((uint32_t)0x55860000)  /*!< Reg Absolute Address */
#define TM16_STA_h0                                 ((uint32_t)0x55860000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_STA_h1                                 ((uint32_t)0x55860002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_STA_b0                                 ((uint32_t)0x55860000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_STA_b1                                 ((uint32_t)0x55860001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_STA_b2                                 ((uint32_t)0x55860002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_STA_b3                                 ((uint32_t)0x55860003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_STA_w                                  ((uint32_t)0x56000000)  /*!< Reg Absolute Address */
#define TM20_STA_h0                                 ((uint32_t)0x56000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_STA_h1                                 ((uint32_t)0x56000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_STA_b0                                 ((uint32_t)0x56000000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_STA_b1                                 ((uint32_t)0x56000001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_STA_b2                                 ((uint32_t)0x56000002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_STA_b3                                 ((uint32_t)0x56000003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_STA_w                                  ((uint32_t)0x56060000)  /*!< Reg Absolute Address */
#define TM26_STA_h0                                 ((uint32_t)0x56060000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_STA_h1                                 ((uint32_t)0x56060002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_STA_b0                                 ((uint32_t)0x56060000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_STA_b1                                 ((uint32_t)0x56060001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_STA_b2                                 ((uint32_t)0x56060002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_STA_b3                                 ((uint32_t)0x56060003)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_STA_w                                  ((uint32_t)0x56860000)  /*!< Reg Absolute Address */
#define TM36_STA_h0                                 ((uint32_t)0x56860000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_STA_h1                                 ((uint32_t)0x56860002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_STA_b0                                 ((uint32_t)0x56860000)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_STA_b1                                 ((uint32_t)0x56860001)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_STA_b2                                 ((uint32_t)0x56860002)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_STA_b3                                 ((uint32_t)0x56860003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_INT  [register's definitions]
 *              Offset[0x04]  TM Timer interrupt enable register
 ******************************************************************************
 */
///@{
#define TM00_INT_w                                  ((uint32_t)0x55000004)  /*!< Reg Absolute Address */
#define TM00_INT_h0                                 ((uint32_t)0x55000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_INT_h1                                 ((uint32_t)0x55000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_INT_b0                                 ((uint32_t)0x55000004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_INT_b1                                 ((uint32_t)0x55000005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_INT_b2                                 ((uint32_t)0x55000006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_INT_b3                                 ((uint32_t)0x55000007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_INT_w                                  ((uint32_t)0x55010004)  /*!< Reg Absolute Address */
#define TM01_INT_h0                                 ((uint32_t)0x55010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_INT_h1                                 ((uint32_t)0x55010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_INT_b0                                 ((uint32_t)0x55010004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_INT_b1                                 ((uint32_t)0x55010005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_INT_b2                                 ((uint32_t)0x55010006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_INT_b3                                 ((uint32_t)0x55010007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_INT_w                                  ((uint32_t)0x55800004)  /*!< Reg Absolute Address */
#define TM10_INT_h0                                 ((uint32_t)0x55800004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_INT_h1                                 ((uint32_t)0x55800006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_INT_b0                                 ((uint32_t)0x55800004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_INT_b1                                 ((uint32_t)0x55800005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_INT_b2                                 ((uint32_t)0x55800006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_INT_b3                                 ((uint32_t)0x55800007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_INT_w                                  ((uint32_t)0x55860004)  /*!< Reg Absolute Address */
#define TM16_INT_h0                                 ((uint32_t)0x55860004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_INT_h1                                 ((uint32_t)0x55860006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_INT_b0                                 ((uint32_t)0x55860004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_INT_b1                                 ((uint32_t)0x55860005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_INT_b2                                 ((uint32_t)0x55860006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_INT_b3                                 ((uint32_t)0x55860007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_INT_w                                  ((uint32_t)0x56000004)  /*!< Reg Absolute Address */
#define TM20_INT_h0                                 ((uint32_t)0x56000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_INT_h1                                 ((uint32_t)0x56000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_INT_b0                                 ((uint32_t)0x56000004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_INT_b1                                 ((uint32_t)0x56000005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_INT_b2                                 ((uint32_t)0x56000006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_INT_b3                                 ((uint32_t)0x56000007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_INT_w                                  ((uint32_t)0x56060004)  /*!< Reg Absolute Address */
#define TM26_INT_h0                                 ((uint32_t)0x56060004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_INT_h1                                 ((uint32_t)0x56060006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_INT_b0                                 ((uint32_t)0x56060004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_INT_b1                                 ((uint32_t)0x56060005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_INT_b2                                 ((uint32_t)0x56060006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_INT_b3                                 ((uint32_t)0x56060007)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_INT_w                                  ((uint32_t)0x56860004)  /*!< Reg Absolute Address */
#define TM36_INT_h0                                 ((uint32_t)0x56860004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_INT_h1                                 ((uint32_t)0x56860006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_INT_b0                                 ((uint32_t)0x56860004)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_INT_b1                                 ((uint32_t)0x56860005)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_INT_b2                                 ((uint32_t)0x56860006)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_INT_b3                                 ((uint32_t)0x56860007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CLK  [register's definitions]
 *              Offset[0x08]  TM Timer clock source register
 ******************************************************************************
 */
///@{
#define TM00_CLK_w                                  ((uint32_t)0x55000008)  /*!< Reg Absolute Address */
#define TM00_CLK_h0                                 ((uint32_t)0x55000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_CLK_h1                                 ((uint32_t)0x5500000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_CLK_b0                                 ((uint32_t)0x55000008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_CLK_b1                                 ((uint32_t)0x55000009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_CLK_b2                                 ((uint32_t)0x5500000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_CLK_b3                                 ((uint32_t)0x5500000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_CLK_w                                  ((uint32_t)0x55010008)  /*!< Reg Absolute Address */
#define TM01_CLK_h0                                 ((uint32_t)0x55010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_CLK_h1                                 ((uint32_t)0x5501000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_CLK_b0                                 ((uint32_t)0x55010008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_CLK_b1                                 ((uint32_t)0x55010009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_CLK_b2                                 ((uint32_t)0x5501000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_CLK_b3                                 ((uint32_t)0x5501000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_CLK_w                                  ((uint32_t)0x55800008)  /*!< Reg Absolute Address */
#define TM10_CLK_h0                                 ((uint32_t)0x55800008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_CLK_h1                                 ((uint32_t)0x5580000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_CLK_b0                                 ((uint32_t)0x55800008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_CLK_b1                                 ((uint32_t)0x55800009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_CLK_b2                                 ((uint32_t)0x5580000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_CLK_b3                                 ((uint32_t)0x5580000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_CLK_w                                  ((uint32_t)0x55860008)  /*!< Reg Absolute Address */
#define TM16_CLK_h0                                 ((uint32_t)0x55860008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_CLK_h1                                 ((uint32_t)0x5586000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_CLK_b0                                 ((uint32_t)0x55860008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_CLK_b1                                 ((uint32_t)0x55860009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_CLK_b2                                 ((uint32_t)0x5586000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_CLK_b3                                 ((uint32_t)0x5586000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_CLK_w                                  ((uint32_t)0x56000008)  /*!< Reg Absolute Address */
#define TM20_CLK_h0                                 ((uint32_t)0x56000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CLK_h1                                 ((uint32_t)0x5600000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CLK_b0                                 ((uint32_t)0x56000008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CLK_b1                                 ((uint32_t)0x56000009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CLK_b2                                 ((uint32_t)0x5600000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CLK_b3                                 ((uint32_t)0x5600000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CLK_w                                  ((uint32_t)0x56060008)  /*!< Reg Absolute Address */
#define TM26_CLK_h0                                 ((uint32_t)0x56060008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CLK_h1                                 ((uint32_t)0x5606000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CLK_b0                                 ((uint32_t)0x56060008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CLK_b1                                 ((uint32_t)0x56060009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CLK_b2                                 ((uint32_t)0x5606000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CLK_b3                                 ((uint32_t)0x5606000B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CLK_w                                  ((uint32_t)0x56860008)  /*!< Reg Absolute Address */
#define TM36_CLK_h0                                 ((uint32_t)0x56860008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CLK_h1                                 ((uint32_t)0x5686000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CLK_b0                                 ((uint32_t)0x56860008)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CLK_b1                                 ((uint32_t)0x56860009)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CLK_b2                                 ((uint32_t)0x5686000A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CLK_b3                                 ((uint32_t)0x5686000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_TRG  [register's definitions]
 *              Offset[0x0C]  TM Timer trigger control register
 ******************************************************************************
 */
///@{
#define TM00_TRG_w                                  ((uint32_t)0x5500000C)  /*!< Reg Absolute Address */
#define TM00_TRG_h0                                 ((uint32_t)0x5500000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_TRG_h1                                 ((uint32_t)0x5500000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_TRG_b0                                 ((uint32_t)0x5500000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_TRG_b1                                 ((uint32_t)0x5500000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_TRG_b2                                 ((uint32_t)0x5500000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_TRG_b3                                 ((uint32_t)0x5500000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_TRG_w                                  ((uint32_t)0x5501000C)  /*!< Reg Absolute Address */
#define TM01_TRG_h0                                 ((uint32_t)0x5501000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_TRG_h1                                 ((uint32_t)0x5501000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_TRG_b0                                 ((uint32_t)0x5501000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_TRG_b1                                 ((uint32_t)0x5501000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_TRG_b2                                 ((uint32_t)0x5501000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_TRG_b3                                 ((uint32_t)0x5501000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_TRG_w                                  ((uint32_t)0x5580000C)  /*!< Reg Absolute Address */
#define TM10_TRG_h0                                 ((uint32_t)0x5580000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_TRG_h1                                 ((uint32_t)0x5580000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_TRG_b0                                 ((uint32_t)0x5580000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_TRG_b1                                 ((uint32_t)0x5580000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_TRG_b2                                 ((uint32_t)0x5580000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_TRG_b3                                 ((uint32_t)0x5580000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_TRG_w                                  ((uint32_t)0x5586000C)  /*!< Reg Absolute Address */
#define TM16_TRG_h0                                 ((uint32_t)0x5586000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_TRG_h1                                 ((uint32_t)0x5586000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_TRG_b0                                 ((uint32_t)0x5586000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_TRG_b1                                 ((uint32_t)0x5586000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_TRG_b2                                 ((uint32_t)0x5586000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_TRG_b3                                 ((uint32_t)0x5586000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_TRG_w                                  ((uint32_t)0x5600000C)  /*!< Reg Absolute Address */
#define TM20_TRG_h0                                 ((uint32_t)0x5600000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_TRG_h1                                 ((uint32_t)0x5600000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_TRG_b0                                 ((uint32_t)0x5600000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_TRG_b1                                 ((uint32_t)0x5600000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_TRG_b2                                 ((uint32_t)0x5600000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_TRG_b3                                 ((uint32_t)0x5600000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_TRG_w                                  ((uint32_t)0x5606000C)  /*!< Reg Absolute Address */
#define TM26_TRG_h0                                 ((uint32_t)0x5606000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_TRG_h1                                 ((uint32_t)0x5606000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_TRG_b0                                 ((uint32_t)0x5606000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_TRG_b1                                 ((uint32_t)0x5606000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_TRG_b2                                 ((uint32_t)0x5606000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_TRG_b3                                 ((uint32_t)0x5606000F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_TRG_w                                  ((uint32_t)0x5686000C)  /*!< Reg Absolute Address */
#define TM36_TRG_h0                                 ((uint32_t)0x5686000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_TRG_h1                                 ((uint32_t)0x5686000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_TRG_b0                                 ((uint32_t)0x5686000C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_TRG_b1                                 ((uint32_t)0x5686000D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_TRG_b2                                 ((uint32_t)0x5686000E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_TRG_b3                                 ((uint32_t)0x5686000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CR0  [register's definitions]
 *              Offset[0x10]  TM Timer control register 0
 ******************************************************************************
 */
///@{
#define TM00_CR0_w                                  ((uint32_t)0x55000010)  /*!< Reg Absolute Address */
#define TM00_CR0_h0                                 ((uint32_t)0x55000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_CR0_h1                                 ((uint32_t)0x55000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_CR0_b0                                 ((uint32_t)0x55000010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_CR0_b1                                 ((uint32_t)0x55000011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_CR0_b2                                 ((uint32_t)0x55000012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_CR0_b3                                 ((uint32_t)0x55000013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_CR0_w                                  ((uint32_t)0x55010010)  /*!< Reg Absolute Address */
#define TM01_CR0_h0                                 ((uint32_t)0x55010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_CR0_h1                                 ((uint32_t)0x55010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_CR0_b0                                 ((uint32_t)0x55010010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_CR0_b1                                 ((uint32_t)0x55010011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_CR0_b2                                 ((uint32_t)0x55010012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_CR0_b3                                 ((uint32_t)0x55010013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_CR0_w                                  ((uint32_t)0x55800010)  /*!< Reg Absolute Address */
#define TM10_CR0_h0                                 ((uint32_t)0x55800010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_CR0_h1                                 ((uint32_t)0x55800012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_CR0_b0                                 ((uint32_t)0x55800010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_CR0_b1                                 ((uint32_t)0x55800011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_CR0_b2                                 ((uint32_t)0x55800012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_CR0_b3                                 ((uint32_t)0x55800013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_CR0_w                                  ((uint32_t)0x55860010)  /*!< Reg Absolute Address */
#define TM16_CR0_h0                                 ((uint32_t)0x55860010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_CR0_h1                                 ((uint32_t)0x55860012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_CR0_b0                                 ((uint32_t)0x55860010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_CR0_b1                                 ((uint32_t)0x55860011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_CR0_b2                                 ((uint32_t)0x55860012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_CR0_b3                                 ((uint32_t)0x55860013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_CR0_w                                  ((uint32_t)0x56000010)  /*!< Reg Absolute Address */
#define TM20_CR0_h0                                 ((uint32_t)0x56000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CR0_h1                                 ((uint32_t)0x56000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CR0_b0                                 ((uint32_t)0x56000010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CR0_b1                                 ((uint32_t)0x56000011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CR0_b2                                 ((uint32_t)0x56000012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CR0_b3                                 ((uint32_t)0x56000013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CR0_w                                  ((uint32_t)0x56060010)  /*!< Reg Absolute Address */
#define TM26_CR0_h0                                 ((uint32_t)0x56060010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CR0_h1                                 ((uint32_t)0x56060012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CR0_b0                                 ((uint32_t)0x56060010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CR0_b1                                 ((uint32_t)0x56060011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CR0_b2                                 ((uint32_t)0x56060012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CR0_b3                                 ((uint32_t)0x56060013)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CR0_w                                  ((uint32_t)0x56860010)  /*!< Reg Absolute Address */
#define TM36_CR0_h0                                 ((uint32_t)0x56860010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CR0_h1                                 ((uint32_t)0x56860012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CR0_b0                                 ((uint32_t)0x56860010)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CR0_b1                                 ((uint32_t)0x56860011)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CR0_b2                                 ((uint32_t)0x56860012)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CR0_b3                                 ((uint32_t)0x56860013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CR1  [register's definitions]
 *              Offset[0x14]  TM Timer control register 1
 ******************************************************************************
 */
///@{
#define TM20_CR1_w                                  ((uint32_t)0x56000014)  /*!< Reg Absolute Address */
#define TM20_CR1_h0                                 ((uint32_t)0x56000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CR1_h1                                 ((uint32_t)0x56000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CR1_b0                                 ((uint32_t)0x56000014)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CR1_b1                                 ((uint32_t)0x56000015)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CR1_b2                                 ((uint32_t)0x56000016)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CR1_b3                                 ((uint32_t)0x56000017)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CR1_w                                  ((uint32_t)0x56060014)  /*!< Reg Absolute Address */
#define TM26_CR1_h0                                 ((uint32_t)0x56060014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CR1_h1                                 ((uint32_t)0x56060016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CR1_b0                                 ((uint32_t)0x56060014)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CR1_b1                                 ((uint32_t)0x56060015)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CR1_b2                                 ((uint32_t)0x56060016)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CR1_b3                                 ((uint32_t)0x56060017)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CR1_w                                  ((uint32_t)0x56860014)  /*!< Reg Absolute Address */
#define TM36_CR1_h0                                 ((uint32_t)0x56860014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CR1_h1                                 ((uint32_t)0x56860016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CR1_b0                                 ((uint32_t)0x56860014)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CR1_b1                                 ((uint32_t)0x56860015)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CR1_b2                                 ((uint32_t)0x56860016)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CR1_b3                                 ((uint32_t)0x56860017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CKO  [register's definitions]
 *              Offset[0x18]  TM Timer CKO control register
 ******************************************************************************
 */
///@{
#define TM00_CKO_w                                  ((uint32_t)0x55000018)  /*!< Reg Absolute Address */
#define TM00_CKO_h0                                 ((uint32_t)0x55000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_CKO_h1                                 ((uint32_t)0x5500001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_CKO_b0                                 ((uint32_t)0x55000018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_CKO_b1                                 ((uint32_t)0x55000019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_CKO_b2                                 ((uint32_t)0x5500001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_CKO_b3                                 ((uint32_t)0x5500001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_CKO_w                                  ((uint32_t)0x55010018)  /*!< Reg Absolute Address */
#define TM01_CKO_h0                                 ((uint32_t)0x55010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_CKO_h1                                 ((uint32_t)0x5501001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_CKO_b0                                 ((uint32_t)0x55010018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_CKO_b1                                 ((uint32_t)0x55010019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_CKO_b2                                 ((uint32_t)0x5501001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_CKO_b3                                 ((uint32_t)0x5501001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_CKO_w                                  ((uint32_t)0x55800018)  /*!< Reg Absolute Address */
#define TM10_CKO_h0                                 ((uint32_t)0x55800018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_CKO_h1                                 ((uint32_t)0x5580001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_CKO_b0                                 ((uint32_t)0x55800018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_CKO_b1                                 ((uint32_t)0x55800019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_CKO_b2                                 ((uint32_t)0x5580001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_CKO_b3                                 ((uint32_t)0x5580001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_CKO_w                                  ((uint32_t)0x55860018)  /*!< Reg Absolute Address */
#define TM16_CKO_h0                                 ((uint32_t)0x55860018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_CKO_h1                                 ((uint32_t)0x5586001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_CKO_b0                                 ((uint32_t)0x55860018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_CKO_b1                                 ((uint32_t)0x55860019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_CKO_b2                                 ((uint32_t)0x5586001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_CKO_b3                                 ((uint32_t)0x5586001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_CKO_w                                  ((uint32_t)0x56000018)  /*!< Reg Absolute Address */
#define TM20_CKO_h0                                 ((uint32_t)0x56000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CKO_h1                                 ((uint32_t)0x5600001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CKO_b0                                 ((uint32_t)0x56000018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CKO_b1                                 ((uint32_t)0x56000019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CKO_b2                                 ((uint32_t)0x5600001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CKO_b3                                 ((uint32_t)0x5600001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CKO_w                                  ((uint32_t)0x56060018)  /*!< Reg Absolute Address */
#define TM26_CKO_h0                                 ((uint32_t)0x56060018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CKO_h1                                 ((uint32_t)0x5606001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CKO_b0                                 ((uint32_t)0x56060018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CKO_b1                                 ((uint32_t)0x56060019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CKO_b2                                 ((uint32_t)0x5606001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CKO_b3                                 ((uint32_t)0x5606001B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CKO_w                                  ((uint32_t)0x56860018)  /*!< Reg Absolute Address */
#define TM36_CKO_h0                                 ((uint32_t)0x56860018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CKO_h1                                 ((uint32_t)0x5686001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CKO_b0                                 ((uint32_t)0x56860018)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CKO_b1                                 ((uint32_t)0x56860019)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CKO_b2                                 ((uint32_t)0x5686001A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CKO_b3                                 ((uint32_t)0x5686001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CNT  [register's definitions]
 *              Offset[0x20]  TM Timer main counter register
 ******************************************************************************
 */
///@{
#define TM00_CNT_w                                  ((uint32_t)0x55000020)  /*!< Reg Absolute Address */
#define TM00_CNT_h0                                 ((uint32_t)0x55000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_CNT_h1                                 ((uint32_t)0x55000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_CNT_b0                                 ((uint32_t)0x55000020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_CNT_b1                                 ((uint32_t)0x55000021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_CNT_b2                                 ((uint32_t)0x55000022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_CNT_b3                                 ((uint32_t)0x55000023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_CNT_w                                  ((uint32_t)0x55010020)  /*!< Reg Absolute Address */
#define TM01_CNT_h0                                 ((uint32_t)0x55010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_CNT_h1                                 ((uint32_t)0x55010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_CNT_b0                                 ((uint32_t)0x55010020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_CNT_b1                                 ((uint32_t)0x55010021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_CNT_b2                                 ((uint32_t)0x55010022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_CNT_b3                                 ((uint32_t)0x55010023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_CNT_w                                  ((uint32_t)0x55800020)  /*!< Reg Absolute Address */
#define TM10_CNT_h0                                 ((uint32_t)0x55800020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_CNT_h1                                 ((uint32_t)0x55800022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_CNT_b0                                 ((uint32_t)0x55800020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_CNT_b1                                 ((uint32_t)0x55800021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_CNT_b2                                 ((uint32_t)0x55800022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_CNT_b3                                 ((uint32_t)0x55800023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_CNT_w                                  ((uint32_t)0x55860020)  /*!< Reg Absolute Address */
#define TM16_CNT_h0                                 ((uint32_t)0x55860020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_CNT_h1                                 ((uint32_t)0x55860022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_CNT_b0                                 ((uint32_t)0x55860020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_CNT_b1                                 ((uint32_t)0x55860021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_CNT_b2                                 ((uint32_t)0x55860022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_CNT_b3                                 ((uint32_t)0x55860023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_CNT_w                                  ((uint32_t)0x56000020)  /*!< Reg Absolute Address */
#define TM20_CNT_h0                                 ((uint32_t)0x56000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CNT_h1                                 ((uint32_t)0x56000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CNT_b0                                 ((uint32_t)0x56000020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CNT_b1                                 ((uint32_t)0x56000021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CNT_b2                                 ((uint32_t)0x56000022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CNT_b3                                 ((uint32_t)0x56000023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CNT_w                                  ((uint32_t)0x56060020)  /*!< Reg Absolute Address */
#define TM26_CNT_h0                                 ((uint32_t)0x56060020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CNT_h1                                 ((uint32_t)0x56060022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CNT_b0                                 ((uint32_t)0x56060020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CNT_b1                                 ((uint32_t)0x56060021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CNT_b2                                 ((uint32_t)0x56060022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CNT_b3                                 ((uint32_t)0x56060023)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CNT_w                                  ((uint32_t)0x56860020)  /*!< Reg Absolute Address */
#define TM36_CNT_h0                                 ((uint32_t)0x56860020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CNT_h1                                 ((uint32_t)0x56860022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CNT_b0                                 ((uint32_t)0x56860020)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CNT_b1                                 ((uint32_t)0x56860021)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CNT_b2                                 ((uint32_t)0x56860022)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CNT_b3                                 ((uint32_t)0x56860023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_ARR  [register's definitions]
 *              Offset[0x24]  TM Timer main counter auto-reload value register
 ******************************************************************************
 */
///@{
#define TM00_ARR_w                                  ((uint32_t)0x55000024)  /*!< Reg Absolute Address */
#define TM00_ARR_h0                                 ((uint32_t)0x55000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_ARR_h1                                 ((uint32_t)0x55000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_ARR_b0                                 ((uint32_t)0x55000024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_ARR_b1                                 ((uint32_t)0x55000025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_ARR_b2                                 ((uint32_t)0x55000026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_ARR_b3                                 ((uint32_t)0x55000027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_ARR_w                                  ((uint32_t)0x55010024)  /*!< Reg Absolute Address */
#define TM01_ARR_h0                                 ((uint32_t)0x55010024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_ARR_h1                                 ((uint32_t)0x55010026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_ARR_b0                                 ((uint32_t)0x55010024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_ARR_b1                                 ((uint32_t)0x55010025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_ARR_b2                                 ((uint32_t)0x55010026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_ARR_b3                                 ((uint32_t)0x55010027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_ARR_w                                  ((uint32_t)0x55800024)  /*!< Reg Absolute Address */
#define TM10_ARR_h0                                 ((uint32_t)0x55800024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_ARR_h1                                 ((uint32_t)0x55800026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_ARR_b0                                 ((uint32_t)0x55800024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_ARR_b1                                 ((uint32_t)0x55800025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_ARR_b2                                 ((uint32_t)0x55800026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_ARR_b3                                 ((uint32_t)0x55800027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_ARR_w                                  ((uint32_t)0x55860024)  /*!< Reg Absolute Address */
#define TM16_ARR_h0                                 ((uint32_t)0x55860024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_ARR_h1                                 ((uint32_t)0x55860026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_ARR_b0                                 ((uint32_t)0x55860024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_ARR_b1                                 ((uint32_t)0x55860025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_ARR_b2                                 ((uint32_t)0x55860026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_ARR_b3                                 ((uint32_t)0x55860027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_ARR_w                                  ((uint32_t)0x56000024)  /*!< Reg Absolute Address */
#define TM20_ARR_h0                                 ((uint32_t)0x56000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_ARR_h1                                 ((uint32_t)0x56000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_ARR_b0                                 ((uint32_t)0x56000024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_ARR_b1                                 ((uint32_t)0x56000025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_ARR_b2                                 ((uint32_t)0x56000026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_ARR_b3                                 ((uint32_t)0x56000027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_ARR_w                                  ((uint32_t)0x56060024)  /*!< Reg Absolute Address */
#define TM26_ARR_h0                                 ((uint32_t)0x56060024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_ARR_h1                                 ((uint32_t)0x56060026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_ARR_b0                                 ((uint32_t)0x56060024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_ARR_b1                                 ((uint32_t)0x56060025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_ARR_b2                                 ((uint32_t)0x56060026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_ARR_b3                                 ((uint32_t)0x56060027)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_ARR_w                                  ((uint32_t)0x56860024)  /*!< Reg Absolute Address */
#define TM36_ARR_h0                                 ((uint32_t)0x56860024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_ARR_h1                                 ((uint32_t)0x56860026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_ARR_b0                                 ((uint32_t)0x56860024)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_ARR_b1                                 ((uint32_t)0x56860025)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_ARR_b2                                 ((uint32_t)0x56860026)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_ARR_b3                                 ((uint32_t)0x56860027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_PSCNT  [register's definitions]
 *              Offset[0x28]  TM Timer prescaler register
 ******************************************************************************
 */
///@{
#define TM00_PSCNT_w                                ((uint32_t)0x55000028)  /*!< Reg Absolute Address */
#define TM00_PSCNT_h0                               ((uint32_t)0x55000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_PSCNT_h1                               ((uint32_t)0x5500002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_PSCNT_b0                               ((uint32_t)0x55000028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_PSCNT_b1                               ((uint32_t)0x55000029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_PSCNT_b2                               ((uint32_t)0x5500002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_PSCNT_b3                               ((uint32_t)0x5500002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_PSCNT_w                                ((uint32_t)0x55010028)  /*!< Reg Absolute Address */
#define TM01_PSCNT_h0                               ((uint32_t)0x55010028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_PSCNT_h1                               ((uint32_t)0x5501002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_PSCNT_b0                               ((uint32_t)0x55010028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_PSCNT_b1                               ((uint32_t)0x55010029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_PSCNT_b2                               ((uint32_t)0x5501002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_PSCNT_b3                               ((uint32_t)0x5501002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_PSCNT_w                                ((uint32_t)0x55800028)  /*!< Reg Absolute Address */
#define TM10_PSCNT_h0                               ((uint32_t)0x55800028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_PSCNT_h1                               ((uint32_t)0x5580002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_PSCNT_b0                               ((uint32_t)0x55800028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_PSCNT_b1                               ((uint32_t)0x55800029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_PSCNT_b2                               ((uint32_t)0x5580002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_PSCNT_b3                               ((uint32_t)0x5580002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_PSCNT_w                                ((uint32_t)0x55860028)  /*!< Reg Absolute Address */
#define TM16_PSCNT_h0                               ((uint32_t)0x55860028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_PSCNT_h1                               ((uint32_t)0x5586002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_PSCNT_b0                               ((uint32_t)0x55860028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_PSCNT_b1                               ((uint32_t)0x55860029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_PSCNT_b2                               ((uint32_t)0x5586002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_PSCNT_b3                               ((uint32_t)0x5586002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_PSCNT_w                                ((uint32_t)0x56000028)  /*!< Reg Absolute Address */
#define TM20_PSCNT_h0                               ((uint32_t)0x56000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_PSCNT_h1                               ((uint32_t)0x5600002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_PSCNT_b0                               ((uint32_t)0x56000028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_PSCNT_b1                               ((uint32_t)0x56000029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_PSCNT_b2                               ((uint32_t)0x5600002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_PSCNT_b3                               ((uint32_t)0x5600002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_PSCNT_w                                ((uint32_t)0x56060028)  /*!< Reg Absolute Address */
#define TM26_PSCNT_h0                               ((uint32_t)0x56060028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_PSCNT_h1                               ((uint32_t)0x5606002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_PSCNT_b0                               ((uint32_t)0x56060028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_PSCNT_b1                               ((uint32_t)0x56060029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_PSCNT_b2                               ((uint32_t)0x5606002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_PSCNT_b3                               ((uint32_t)0x5606002B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_PSCNT_w                                ((uint32_t)0x56860028)  /*!< Reg Absolute Address */
#define TM36_PSCNT_h0                               ((uint32_t)0x56860028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_PSCNT_h1                               ((uint32_t)0x5686002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_PSCNT_b0                               ((uint32_t)0x56860028)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_PSCNT_b1                               ((uint32_t)0x56860029)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_PSCNT_b2                               ((uint32_t)0x5686002A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_PSCNT_b3                               ((uint32_t)0x5686002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_PSARR  [register's definitions]
 *              Offset[0x2C]  TM Timer prescaler auto-reload register
 ******************************************************************************
 */
///@{
#define TM00_PSARR_w                                ((uint32_t)0x5500002C)  /*!< Reg Absolute Address */
#define TM00_PSARR_h0                               ((uint32_t)0x5500002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM00_PSARR_h1                               ((uint32_t)0x5500002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM00_PSARR_b0                               ((uint32_t)0x5500002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM00_PSARR_b1                               ((uint32_t)0x5500002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM00_PSARR_b2                               ((uint32_t)0x5500002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM00_PSARR_b3                               ((uint32_t)0x5500002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM01_PSARR_w                                ((uint32_t)0x5501002C)  /*!< Reg Absolute Address */
#define TM01_PSARR_h0                               ((uint32_t)0x5501002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM01_PSARR_h1                               ((uint32_t)0x5501002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM01_PSARR_b0                               ((uint32_t)0x5501002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM01_PSARR_b1                               ((uint32_t)0x5501002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM01_PSARR_b2                               ((uint32_t)0x5501002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM01_PSARR_b3                               ((uint32_t)0x5501002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM10_PSARR_w                                ((uint32_t)0x5580002C)  /*!< Reg Absolute Address */
#define TM10_PSARR_h0                               ((uint32_t)0x5580002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM10_PSARR_h1                               ((uint32_t)0x5580002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM10_PSARR_b0                               ((uint32_t)0x5580002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM10_PSARR_b1                               ((uint32_t)0x5580002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM10_PSARR_b2                               ((uint32_t)0x5580002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM10_PSARR_b3                               ((uint32_t)0x5580002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM16_PSARR_w                                ((uint32_t)0x5586002C)  /*!< Reg Absolute Address */
#define TM16_PSARR_h0                               ((uint32_t)0x5586002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM16_PSARR_h1                               ((uint32_t)0x5586002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM16_PSARR_b0                               ((uint32_t)0x5586002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM16_PSARR_b1                               ((uint32_t)0x5586002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM16_PSARR_b2                               ((uint32_t)0x5586002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM16_PSARR_b3                               ((uint32_t)0x5586002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM20_PSARR_w                                ((uint32_t)0x5600002C)  /*!< Reg Absolute Address */
#define TM20_PSARR_h0                               ((uint32_t)0x5600002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_PSARR_h1                               ((uint32_t)0x5600002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_PSARR_b0                               ((uint32_t)0x5600002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_PSARR_b1                               ((uint32_t)0x5600002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_PSARR_b2                               ((uint32_t)0x5600002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_PSARR_b3                               ((uint32_t)0x5600002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_PSARR_w                                ((uint32_t)0x5606002C)  /*!< Reg Absolute Address */
#define TM26_PSARR_h0                               ((uint32_t)0x5606002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_PSARR_h1                               ((uint32_t)0x5606002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_PSARR_b0                               ((uint32_t)0x5606002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_PSARR_b1                               ((uint32_t)0x5606002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_PSARR_b2                               ((uint32_t)0x5606002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_PSARR_b3                               ((uint32_t)0x5606002F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_PSARR_w                                ((uint32_t)0x5686002C)  /*!< Reg Absolute Address */
#define TM36_PSARR_h0                               ((uint32_t)0x5686002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_PSARR_h1                               ((uint32_t)0x5686002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_PSARR_b0                               ((uint32_t)0x5686002C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_PSARR_b1                               ((uint32_t)0x5686002D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_PSARR_b2                               ((uint32_t)0x5686002E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_PSARR_b3                               ((uint32_t)0x5686002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CCMDS  [register's definitions]
 *              Offset[0x30]  TM Timer capture and compare mode select register
 ******************************************************************************
 */
///@{
#define TM20_CCMDS_w                                ((uint32_t)0x56000030)  /*!< Reg Absolute Address */
#define TM20_CCMDS_h0                               ((uint32_t)0x56000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CCMDS_h1                               ((uint32_t)0x56000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CCMDS_b0                               ((uint32_t)0x56000030)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CCMDS_b1                               ((uint32_t)0x56000031)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CCMDS_b2                               ((uint32_t)0x56000032)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CCMDS_b3                               ((uint32_t)0x56000033)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CCMDS_w                                ((uint32_t)0x56060030)  /*!< Reg Absolute Address */
#define TM26_CCMDS_h0                               ((uint32_t)0x56060030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CCMDS_h1                               ((uint32_t)0x56060032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CCMDS_b0                               ((uint32_t)0x56060030)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CCMDS_b1                               ((uint32_t)0x56060031)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CCMDS_b2                               ((uint32_t)0x56060032)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CCMDS_b3                               ((uint32_t)0x56060033)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CCMDS_w                                ((uint32_t)0x56860030)  /*!< Reg Absolute Address */
#define TM36_CCMDS_h0                               ((uint32_t)0x56860030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CCMDS_h1                               ((uint32_t)0x56860032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CCMDS_b0                               ((uint32_t)0x56860030)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CCMDS_b1                               ((uint32_t)0x56860031)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CCMDS_b2                               ((uint32_t)0x56860032)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CCMDS_b3                               ((uint32_t)0x56860033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_ICCR  [register's definitions]
 *              Offset[0x34]  TM Timer input capture control register
 ******************************************************************************
 */
///@{
#define TM20_ICCR_w                                 ((uint32_t)0x56000034)  /*!< Reg Absolute Address */
#define TM20_ICCR_h0                                ((uint32_t)0x56000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_ICCR_h1                                ((uint32_t)0x56000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_ICCR_b0                                ((uint32_t)0x56000034)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_ICCR_b1                                ((uint32_t)0x56000035)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_ICCR_b2                                ((uint32_t)0x56000036)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_ICCR_b3                                ((uint32_t)0x56000037)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_ICCR_w                                 ((uint32_t)0x56060034)  /*!< Reg Absolute Address */
#define TM26_ICCR_h0                                ((uint32_t)0x56060034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_ICCR_h1                                ((uint32_t)0x56060036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_ICCR_b0                                ((uint32_t)0x56060034)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_ICCR_b1                                ((uint32_t)0x56060035)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_ICCR_b2                                ((uint32_t)0x56060036)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_ICCR_b3                                ((uint32_t)0x56060037)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_ICCR_w                                 ((uint32_t)0x56860034)  /*!< Reg Absolute Address */
#define TM36_ICCR_h0                                ((uint32_t)0x56860034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_ICCR_h1                                ((uint32_t)0x56860036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_ICCR_b0                                ((uint32_t)0x56860034)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_ICCR_b1                                ((uint32_t)0x56860035)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_ICCR_b2                                ((uint32_t)0x56860036)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_ICCR_b3                                ((uint32_t)0x56860037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_OSCR  [register's definitions]
 *              Offset[0x38]  TM Timer output compare state register
 ******************************************************************************
 */
///@{
#define TM20_OSCR_w                                 ((uint32_t)0x56000038)  /*!< Reg Absolute Address */
#define TM20_OSCR_h0                                ((uint32_t)0x56000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_OSCR_h1                                ((uint32_t)0x5600003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_OSCR_b0                                ((uint32_t)0x56000038)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_OSCR_b1                                ((uint32_t)0x56000039)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_OSCR_b2                                ((uint32_t)0x5600003A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_OSCR_b3                                ((uint32_t)0x5600003B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_OSCR_w                                 ((uint32_t)0x56060038)  /*!< Reg Absolute Address */
#define TM26_OSCR_h0                                ((uint32_t)0x56060038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_OSCR_h1                                ((uint32_t)0x5606003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_OSCR_b0                                ((uint32_t)0x56060038)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_OSCR_b1                                ((uint32_t)0x56060039)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_OSCR_b2                                ((uint32_t)0x5606003A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_OSCR_b3                                ((uint32_t)0x5606003B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_OSCR_w                                 ((uint32_t)0x56860038)  /*!< Reg Absolute Address */
#define TM36_OSCR_h0                                ((uint32_t)0x56860038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_OSCR_h1                                ((uint32_t)0x5686003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_OSCR_b0                                ((uint32_t)0x56860038)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_OSCR_b1                                ((uint32_t)0x56860039)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_OSCR_b2                                ((uint32_t)0x5686003A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_OSCR_b3                                ((uint32_t)0x5686003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_OCCR0  [register's definitions]
 *              Offset[0x3C]  TM Timer output compare control register 0
 ******************************************************************************
 */
///@{
#define TM20_OCCR0_w                                ((uint32_t)0x5600003C)  /*!< Reg Absolute Address */
#define TM20_OCCR0_h0                               ((uint32_t)0x5600003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_OCCR0_h1                               ((uint32_t)0x5600003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_OCCR0_b0                               ((uint32_t)0x5600003C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_OCCR0_b1                               ((uint32_t)0x5600003D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_OCCR0_b2                               ((uint32_t)0x5600003E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_OCCR0_b3                               ((uint32_t)0x5600003F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_OCCR0_w                                ((uint32_t)0x5606003C)  /*!< Reg Absolute Address */
#define TM26_OCCR0_h0                               ((uint32_t)0x5606003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_OCCR0_h1                               ((uint32_t)0x5606003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_OCCR0_b0                               ((uint32_t)0x5606003C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_OCCR0_b1                               ((uint32_t)0x5606003D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_OCCR0_b2                               ((uint32_t)0x5606003E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_OCCR0_b3                               ((uint32_t)0x5606003F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_OCCR0_w                                ((uint32_t)0x5686003C)  /*!< Reg Absolute Address */
#define TM36_OCCR0_h0                               ((uint32_t)0x5686003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_OCCR0_h1                               ((uint32_t)0x5686003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_OCCR0_b0                               ((uint32_t)0x5686003C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_OCCR0_b1                               ((uint32_t)0x5686003D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_OCCR0_b2                               ((uint32_t)0x5686003E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_OCCR0_b3                               ((uint32_t)0x5686003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_OCCR1  [register's definitions]
 *              Offset[0x40]  TM Timer output compare control register 1
 ******************************************************************************
 */
///@{
#define TM20_OCCR1_w                                ((uint32_t)0x56000040)  /*!< Reg Absolute Address */
#define TM20_OCCR1_h0                               ((uint32_t)0x56000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_OCCR1_h1                               ((uint32_t)0x56000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_OCCR1_b0                               ((uint32_t)0x56000040)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_OCCR1_b1                               ((uint32_t)0x56000041)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_OCCR1_b2                               ((uint32_t)0x56000042)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_OCCR1_b3                               ((uint32_t)0x56000043)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_OCCR1_w                                ((uint32_t)0x56060040)  /*!< Reg Absolute Address */
#define TM26_OCCR1_h0                               ((uint32_t)0x56060040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_OCCR1_h1                               ((uint32_t)0x56060042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_OCCR1_b0                               ((uint32_t)0x56060040)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_OCCR1_b1                               ((uint32_t)0x56060041)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_OCCR1_b2                               ((uint32_t)0x56060042)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_OCCR1_b3                               ((uint32_t)0x56060043)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_OCCR1_w                                ((uint32_t)0x56860040)  /*!< Reg Absolute Address */
#define TM36_OCCR1_h0                               ((uint32_t)0x56860040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_OCCR1_h1                               ((uint32_t)0x56860042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_OCCR1_b0                               ((uint32_t)0x56860040)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_OCCR1_b1                               ((uint32_t)0x56860041)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_OCCR1_b2                               ((uint32_t)0x56860042)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_OCCR1_b3                               ((uint32_t)0x56860043)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_PWM  [register's definitions]
 *              Offset[0x44]  TM Timer PWM and DTG control register
 ******************************************************************************
 */
///@{
#define TM20_PWM_w                                  ((uint32_t)0x56000044)  /*!< Reg Absolute Address */
#define TM20_PWM_h0                                 ((uint32_t)0x56000044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_PWM_h1                                 ((uint32_t)0x56000046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_PWM_b0                                 ((uint32_t)0x56000044)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_PWM_b1                                 ((uint32_t)0x56000045)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_PWM_b2                                 ((uint32_t)0x56000046)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_PWM_b3                                 ((uint32_t)0x56000047)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_PWM_w                                  ((uint32_t)0x56060044)  /*!< Reg Absolute Address */
#define TM26_PWM_h0                                 ((uint32_t)0x56060044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_PWM_h1                                 ((uint32_t)0x56060046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_PWM_b0                                 ((uint32_t)0x56060044)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_PWM_b1                                 ((uint32_t)0x56060045)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_PWM_b2                                 ((uint32_t)0x56060046)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_PWM_b3                                 ((uint32_t)0x56060047)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_PWM_w                                  ((uint32_t)0x56860044)  /*!< Reg Absolute Address */
#define TM36_PWM_h0                                 ((uint32_t)0x56860044)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_PWM_h1                                 ((uint32_t)0x56860046)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_PWM_b0                                 ((uint32_t)0x56860044)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_PWM_b1                                 ((uint32_t)0x56860045)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_PWM_b2                                 ((uint32_t)0x56860046)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_PWM_b3                                 ((uint32_t)0x56860047)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_BS  [register's definitions]
 *              Offset[0x48]  TM Timer break and stop control register
 ******************************************************************************
 */
///@{
#define TM20_BS_w                                   ((uint32_t)0x56000048)  /*!< Reg Absolute Address */
#define TM20_BS_h0                                  ((uint32_t)0x56000048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_BS_h1                                  ((uint32_t)0x5600004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_BS_b0                                  ((uint32_t)0x56000048)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_BS_b1                                  ((uint32_t)0x56000049)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_BS_b2                                  ((uint32_t)0x5600004A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_BS_b3                                  ((uint32_t)0x5600004B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_BS_w                                   ((uint32_t)0x56060048)  /*!< Reg Absolute Address */
#define TM26_BS_h0                                  ((uint32_t)0x56060048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_BS_h1                                  ((uint32_t)0x5606004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_BS_b0                                  ((uint32_t)0x56060048)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_BS_b1                                  ((uint32_t)0x56060049)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_BS_b2                                  ((uint32_t)0x5606004A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_BS_b3                                  ((uint32_t)0x5606004B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_BS_w                                   ((uint32_t)0x56860048)  /*!< Reg Absolute Address */
#define TM36_BS_h0                                  ((uint32_t)0x56860048)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_BS_h1                                  ((uint32_t)0x5686004A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_BS_b0                                  ((uint32_t)0x56860048)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_BS_b1                                  ((uint32_t)0x56860049)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_BS_b2                                  ((uint32_t)0x5686004A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_BS_b3                                  ((uint32_t)0x5686004B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC0A  [register's definitions]
 *              Offset[0x50]  TM Timer capture and compare register 0A
 ******************************************************************************
 */
///@{
#define TM20_CC0A_w                                 ((uint32_t)0x56000050)  /*!< Reg Absolute Address */
#define TM20_CC0A_h0                                ((uint32_t)0x56000050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CC0A_h1                                ((uint32_t)0x56000052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CC0A_b0                                ((uint32_t)0x56000050)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CC0A_b1                                ((uint32_t)0x56000051)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CC0A_b2                                ((uint32_t)0x56000052)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CC0A_b3                                ((uint32_t)0x56000053)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CC0A_w                                 ((uint32_t)0x56060050)  /*!< Reg Absolute Address */
#define TM26_CC0A_h0                                ((uint32_t)0x56060050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CC0A_h1                                ((uint32_t)0x56060052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CC0A_b0                                ((uint32_t)0x56060050)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CC0A_b1                                ((uint32_t)0x56060051)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CC0A_b2                                ((uint32_t)0x56060052)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CC0A_b3                                ((uint32_t)0x56060053)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CC0A_w                                 ((uint32_t)0x56860050)  /*!< Reg Absolute Address */
#define TM36_CC0A_h0                                ((uint32_t)0x56860050)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC0A_h1                                ((uint32_t)0x56860052)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC0A_b0                                ((uint32_t)0x56860050)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC0A_b1                                ((uint32_t)0x56860051)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC0A_b2                                ((uint32_t)0x56860052)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC0A_b3                                ((uint32_t)0x56860053)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC0B  [register's definitions]
 *              Offset[0x54]  TM Timer capture and compare register 0B
 ******************************************************************************
 */
///@{
#define TM20_CC0B_w                                 ((uint32_t)0x56000054)  /*!< Reg Absolute Address */
#define TM20_CC0B_h0                                ((uint32_t)0x56000054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CC0B_h1                                ((uint32_t)0x56000056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CC0B_b0                                ((uint32_t)0x56000054)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CC0B_b1                                ((uint32_t)0x56000055)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CC0B_b2                                ((uint32_t)0x56000056)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CC0B_b3                                ((uint32_t)0x56000057)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CC0B_w                                 ((uint32_t)0x56060054)  /*!< Reg Absolute Address */
#define TM26_CC0B_h0                                ((uint32_t)0x56060054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CC0B_h1                                ((uint32_t)0x56060056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CC0B_b0                                ((uint32_t)0x56060054)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CC0B_b1                                ((uint32_t)0x56060055)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CC0B_b2                                ((uint32_t)0x56060056)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CC0B_b3                                ((uint32_t)0x56060057)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CC0B_w                                 ((uint32_t)0x56860054)  /*!< Reg Absolute Address */
#define TM36_CC0B_h0                                ((uint32_t)0x56860054)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC0B_h1                                ((uint32_t)0x56860056)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC0B_b0                                ((uint32_t)0x56860054)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC0B_b1                                ((uint32_t)0x56860055)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC0B_b2                                ((uint32_t)0x56860056)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC0B_b3                                ((uint32_t)0x56860057)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC1A  [register's definitions]
 *              Offset[0x58]  TM Timer capture and compare register 1A
 ******************************************************************************
 */
///@{
#define TM20_CC1A_w                                 ((uint32_t)0x56000058)  /*!< Reg Absolute Address */
#define TM20_CC1A_h0                                ((uint32_t)0x56000058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CC1A_h1                                ((uint32_t)0x5600005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CC1A_b0                                ((uint32_t)0x56000058)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CC1A_b1                                ((uint32_t)0x56000059)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CC1A_b2                                ((uint32_t)0x5600005A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CC1A_b3                                ((uint32_t)0x5600005B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CC1A_w                                 ((uint32_t)0x56060058)  /*!< Reg Absolute Address */
#define TM26_CC1A_h0                                ((uint32_t)0x56060058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CC1A_h1                                ((uint32_t)0x5606005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CC1A_b0                                ((uint32_t)0x56060058)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CC1A_b1                                ((uint32_t)0x56060059)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CC1A_b2                                ((uint32_t)0x5606005A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CC1A_b3                                ((uint32_t)0x5606005B)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CC1A_w                                 ((uint32_t)0x56860058)  /*!< Reg Absolute Address */
#define TM36_CC1A_h0                                ((uint32_t)0x56860058)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC1A_h1                                ((uint32_t)0x5686005A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC1A_b0                                ((uint32_t)0x56860058)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC1A_b1                                ((uint32_t)0x56860059)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC1A_b2                                ((uint32_t)0x5686005A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC1A_b3                                ((uint32_t)0x5686005B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC1B  [register's definitions]
 *              Offset[0x5c]  TM Timer capture and compare register 1B
 ******************************************************************************
 */
///@{
#define TM20_CC1B_w                                 ((uint32_t)0x5600005C)  /*!< Reg Absolute Address */
#define TM20_CC1B_h0                                ((uint32_t)0x5600005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM20_CC1B_h1                                ((uint32_t)0x5600005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM20_CC1B_b0                                ((uint32_t)0x5600005C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM20_CC1B_b1                                ((uint32_t)0x5600005D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM20_CC1B_b2                                ((uint32_t)0x5600005E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM20_CC1B_b3                                ((uint32_t)0x5600005F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM26_CC1B_w                                 ((uint32_t)0x5606005C)  /*!< Reg Absolute Address */
#define TM26_CC1B_h0                                ((uint32_t)0x5606005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM26_CC1B_h1                                ((uint32_t)0x5606005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM26_CC1B_b0                                ((uint32_t)0x5606005C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM26_CC1B_b1                                ((uint32_t)0x5606005D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM26_CC1B_b2                                ((uint32_t)0x5606005E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM26_CC1B_b3                                ((uint32_t)0x5606005F)  /*!< Reg Absolute Address of [Byte-3] */
#define TM36_CC1B_w                                 ((uint32_t)0x5686005C)  /*!< Reg Absolute Address */
#define TM36_CC1B_h0                                ((uint32_t)0x5686005C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC1B_h1                                ((uint32_t)0x5686005E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC1B_b0                                ((uint32_t)0x5686005C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC1B_b1                                ((uint32_t)0x5686005D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC1B_b2                                ((uint32_t)0x5686005E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC1B_b3                                ((uint32_t)0x5686005F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC2A  [register's definitions]
 *              Offset[0x60]  TM Timer capture and compare register 2A
 ******************************************************************************
 */
///@{
#define TM36_CC2A_w                                 ((uint32_t)0x56860060)  /*!< Reg Absolute Address */
#define TM36_CC2A_h0                                ((uint32_t)0x56860060)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC2A_h1                                ((uint32_t)0x56860062)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC2A_b0                                ((uint32_t)0x56860060)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC2A_b1                                ((uint32_t)0x56860061)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC2A_b2                                ((uint32_t)0x56860062)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC2A_b3                                ((uint32_t)0x56860063)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC2B  [register's definitions]
 *              Offset[0x64]  TM Timer capture and compare register 2B
 ******************************************************************************
 */
///@{
#define TM36_CC2B_w                                 ((uint32_t)0x56860064)  /*!< Reg Absolute Address */
#define TM36_CC2B_h0                                ((uint32_t)0x56860064)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC2B_h1                                ((uint32_t)0x56860066)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC2B_b0                                ((uint32_t)0x56860064)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC2B_b1                                ((uint32_t)0x56860065)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC2B_b2                                ((uint32_t)0x56860066)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC2B_b3                                ((uint32_t)0x56860067)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC3A  [register's definitions]
 *              Offset[0x68]  TM Timer capture and compare register 3A
 ******************************************************************************
 */
///@{
#define TM36_CC3A_w                                 ((uint32_t)0x56860068)  /*!< Reg Absolute Address */
#define TM36_CC3A_h0                                ((uint32_t)0x56860068)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC3A_h1                                ((uint32_t)0x5686006A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC3A_b0                                ((uint32_t)0x56860068)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC3A_b1                                ((uint32_t)0x56860069)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC3A_b2                                ((uint32_t)0x5686006A)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC3A_b3                                ((uint32_t)0x5686006B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        TM_CC3B  [register's definitions]
 *              Offset[0x6c]  TM Timer capture and compare register 3B
 ******************************************************************************
 */
///@{
#define TM36_CC3B_w                                 ((uint32_t)0x5686006C)  /*!< Reg Absolute Address */
#define TM36_CC3B_h0                                ((uint32_t)0x5686006C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define TM36_CC3B_h1                                ((uint32_t)0x5686006E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define TM36_CC3B_b0                                ((uint32_t)0x5686006C)  /*!< Reg Absolute Address of [Byte-0] */
#define TM36_CC3B_b1                                ((uint32_t)0x5686006D)  /*!< Reg Absolute Address of [Byte-1] */
#define TM36_CC3B_b2                                ((uint32_t)0x5686006E)  /*!< Reg Absolute Address of [Byte-2] */
#define TM36_CC3B_b3                                ((uint32_t)0x5686006F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      ADC (ADC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        ADC_STA  [register's definitions]
 *              Offset[0x00]  ADC status register
 ******************************************************************************
 */
///@{
#define ADC0_STA_w                                  ((uint32_t)0x5B000000)  /*!< Reg Absolute Address */
#define ADC0_STA_h0                                 ((uint32_t)0x5B000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_STA_h1                                 ((uint32_t)0x5B000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_STA_b0                                 ((uint32_t)0x5B000000)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_STA_b1                                 ((uint32_t)0x5B000001)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_STA_b2                                 ((uint32_t)0x5B000002)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_STA_b3                                 ((uint32_t)0x5B000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_INT  [register's definitions]
 *              Offset[0x04]  ADC interrupt enable register
 ******************************************************************************
 */
///@{
#define ADC0_INT_w                                  ((uint32_t)0x5B000004)  /*!< Reg Absolute Address */
#define ADC0_INT_h0                                 ((uint32_t)0x5B000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_INT_h1                                 ((uint32_t)0x5B000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_INT_b0                                 ((uint32_t)0x5B000004)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_INT_b1                                 ((uint32_t)0x5B000005)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_INT_b2                                 ((uint32_t)0x5B000006)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_INT_b3                                 ((uint32_t)0x5B000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_CLK  [register's definitions]
 *              Offset[0x08]  ADC clock source register
 ******************************************************************************
 */
///@{
#define ADC0_CLK_w                                  ((uint32_t)0x5B000008)  /*!< Reg Absolute Address */
#define ADC0_CLK_h0                                 ((uint32_t)0x5B000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_CLK_h1                                 ((uint32_t)0x5B00000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_CLK_b0                                 ((uint32_t)0x5B000008)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_CLK_b1                                 ((uint32_t)0x5B000009)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_CLK_b2                                 ((uint32_t)0x5B00000A)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_CLK_b3                                 ((uint32_t)0x5B00000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_WINDTH  [register's definitions]
 *              Offset[0x0C]  ADC window detect threshold register
 ******************************************************************************
 */
///@{
#define ADC0_WINDTH_w                               ((uint32_t)0x5B00000C)  /*!< Reg Absolute Address */
#define ADC0_WINDTH_h0                              ((uint32_t)0x5B00000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_WINDTH_h1                              ((uint32_t)0x5B00000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_WINDTH_b0                              ((uint32_t)0x5B00000C)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_WINDTH_b1                              ((uint32_t)0x5B00000D)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_WINDTH_b2                              ((uint32_t)0x5B00000E)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_WINDTH_b3                              ((uint32_t)0x5B00000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_CR0  [register's definitions]
 *              Offset[0x10]  ADC control register 0
 ******************************************************************************
 */
///@{
#define ADC0_CR0_w                                  ((uint32_t)0x5B000010)  /*!< Reg Absolute Address */
#define ADC0_CR0_h0                                 ((uint32_t)0x5B000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_CR0_h1                                 ((uint32_t)0x5B000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_CR0_b0                                 ((uint32_t)0x5B000010)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_CR0_b1                                 ((uint32_t)0x5B000011)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_CR0_b2                                 ((uint32_t)0x5B000012)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_CR0_b3                                 ((uint32_t)0x5B000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_CR1  [register's definitions]
 *              Offset[0x14]  ADC control register 1
 ******************************************************************************
 */
///@{
#define ADC0_CR1_w                                  ((uint32_t)0x5B000014)  /*!< Reg Absolute Address */
#define ADC0_CR1_h0                                 ((uint32_t)0x5B000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_CR1_h1                                 ((uint32_t)0x5B000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_CR1_b0                                 ((uint32_t)0x5B000014)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_CR1_b1                                 ((uint32_t)0x5B000015)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_CR1_b2                                 ((uint32_t)0x5B000016)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_CR1_b3                                 ((uint32_t)0x5B000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_MSK  [register's definitions]
 *              Offset[0x1C]  ADC channel mask register
 ******************************************************************************
 */
///@{
#define ADC0_MSK_w                                  ((uint32_t)0x5B00001C)  /*!< Reg Absolute Address */
#define ADC0_MSK_h0                                 ((uint32_t)0x5B00001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_MSK_h1                                 ((uint32_t)0x5B00001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_MSK_b0                                 ((uint32_t)0x5B00001C)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_MSK_b1                                 ((uint32_t)0x5B00001D)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_MSK_b2                                 ((uint32_t)0x5B00001E)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_MSK_b3                                 ((uint32_t)0x5B00001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_START  [register's definitions]
 *              Offset[0x20]  ADC start conversion register
 ******************************************************************************
 */
///@{
#define ADC0_START_w                                ((uint32_t)0x5B000020)  /*!< Reg Absolute Address */
#define ADC0_START_h0                               ((uint32_t)0x5B000020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_START_h1                               ((uint32_t)0x5B000022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_START_b0                               ((uint32_t)0x5B000020)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_START_b1                               ((uint32_t)0x5B000021)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_START_b2                               ((uint32_t)0x5B000022)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_START_b3                               ((uint32_t)0x5B000023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_ANA  [register's definitions]
 *              Offset[0x24]  ADC analog control register
 ******************************************************************************
 */
///@{
#define ADC0_ANA_w                                  ((uint32_t)0x5B000024)  /*!< Reg Absolute Address */
#define ADC0_ANA_h0                                 ((uint32_t)0x5B000024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_ANA_h1                                 ((uint32_t)0x5B000026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_ANA_b0                                 ((uint32_t)0x5B000024)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_ANA_b1                                 ((uint32_t)0x5B000025)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_ANA_b2                                 ((uint32_t)0x5B000026)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_ANA_b3                                 ((uint32_t)0x5B000027)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_CAL  [register's definitions]
 *              Offset[0x28]  ADC calibration control register
 ******************************************************************************
 */
///@{
#define ADC0_CAL_w                                  ((uint32_t)0x5B000028)  /*!< Reg Absolute Address */
#define ADC0_CAL_h0                                 ((uint32_t)0x5B000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_CAL_h1                                 ((uint32_t)0x5B00002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_CAL_b0                                 ((uint32_t)0x5B000028)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_CAL_b1                                 ((uint32_t)0x5B000029)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_CAL_b2                                 ((uint32_t)0x5B00002A)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_CAL_b3                                 ((uint32_t)0x5B00002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_GAIN  [register's definitions]
 *              Offset[0x2C]  ADC gain control register
 ******************************************************************************
 */
///@{
#define ADC0_GAIN_w                                 ((uint32_t)0x5B00002C)  /*!< Reg Absolute Address */
#define ADC0_GAIN_h0                                ((uint32_t)0x5B00002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_GAIN_h1                                ((uint32_t)0x5B00002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_GAIN_b0                                ((uint32_t)0x5B00002C)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_GAIN_b1                                ((uint32_t)0x5B00002D)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_GAIN_b2                                ((uint32_t)0x5B00002E)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_GAIN_b3                                ((uint32_t)0x5B00002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_SUM0  [register's definitions]
 *              Offset[0x30]  ADC accumulator sum result register 0
 ******************************************************************************
 */
///@{
#define ADC0_SUM0_w                                 ((uint32_t)0x5B000030)  /*!< Reg Absolute Address */
#define ADC0_SUM0_h0                                ((uint32_t)0x5B000030)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_SUM0_h1                                ((uint32_t)0x5B000032)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_SUM0_b0                                ((uint32_t)0x5B000030)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_SUM0_b1                                ((uint32_t)0x5B000031)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_SUM0_b2                                ((uint32_t)0x5B000032)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_SUM0_b3                                ((uint32_t)0x5B000033)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_SUM1  [register's definitions]
 *              Offset[0x34]  ADC accumulator sum result register 1
 ******************************************************************************
 */
///@{
#define ADC0_SUM1_w                                 ((uint32_t)0x5B000034)  /*!< Reg Absolute Address */
#define ADC0_SUM1_h0                                ((uint32_t)0x5B000034)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_SUM1_h1                                ((uint32_t)0x5B000036)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_SUM1_b0                                ((uint32_t)0x5B000034)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_SUM1_b1                                ((uint32_t)0x5B000035)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_SUM1_b2                                ((uint32_t)0x5B000036)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_SUM1_b3                                ((uint32_t)0x5B000037)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_SUM2  [register's definitions]
 *              Offset[0x38]  ADC accumulator sum result register 2
 ******************************************************************************
 */
///@{
#define ADC0_SUM2_w                                 ((uint32_t)0x5B000038)  /*!< Reg Absolute Address */
#define ADC0_SUM2_h0                                ((uint32_t)0x5B000038)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_SUM2_h1                                ((uint32_t)0x5B00003A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_SUM2_b0                                ((uint32_t)0x5B000038)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_SUM2_b1                                ((uint32_t)0x5B000039)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_SUM2_b2                                ((uint32_t)0x5B00003A)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_SUM2_b3                                ((uint32_t)0x5B00003B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_TCAL  [register's definitions]
 *              Offset[0x3C]  ADC Temperature Sensor calibration register
 ******************************************************************************
 */
///@{
#define ADC0_TCAL_w                                 ((uint32_t)0x5B00003C)  /*!< Reg Absolute Address */
#define ADC0_TCAL_h0                                ((uint32_t)0x5B00003C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_TCAL_h1                                ((uint32_t)0x5B00003E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_TCAL_b0                                ((uint32_t)0x5B00003C)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_TCAL_b1                                ((uint32_t)0x5B00003D)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_TCAL_b2                                ((uint32_t)0x5B00003E)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_TCAL_b3                                ((uint32_t)0x5B00003F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        ADC_DAT0  [register's definitions]
 *              Offset[0x40]  ADC conversion data register 0
 ******************************************************************************
 */
///@{
#define ADC0_DAT0_w                                 ((uint32_t)0x5B000040)  /*!< Reg Absolute Address */
#define ADC0_DAT0_h0                                ((uint32_t)0x5B000040)  /*!< Reg Absolute Address of [HalfWord-0] */
#define ADC0_DAT0_h1                                ((uint32_t)0x5B000042)  /*!< Reg Absolute Address of [HalfWord-1] */
#define ADC0_DAT0_b0                                ((uint32_t)0x5B000040)  /*!< Reg Absolute Address of [Byte-0] */
#define ADC0_DAT0_b1                                ((uint32_t)0x5B000041)  /*!< Reg Absolute Address of [Byte-1] */
#define ADC0_DAT0_b2                                ((uint32_t)0x5B000042)  /*!< Reg Absolute Address of [Byte-2] */
#define ADC0_DAT0_b3                                ((uint32_t)0x5B000043)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      CMP (Analog Comparator)                                       */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CMP_STA  [register's definitions]
 *              Offset[0x00]  CMP Analog comparator status register (0x5C000000)
 ******************************************************************************
 */
///@{
#define CMP_STA_w                                   ((uint32_t)0x5C000000)  /*!< Reg Absolute Address */
#define CMP_STA_h0                                  ((uint32_t)0x5C000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_STA_h1                                  ((uint32_t)0x5C000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_STA_b0                                  ((uint32_t)0x5C000000)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_STA_b1                                  ((uint32_t)0x5C000001)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_STA_b2                                  ((uint32_t)0x5C000002)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_STA_b3                                  ((uint32_t)0x5C000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_INT  [register's definitions]
 *              Offset[0x04]  CMP Analog comparator interrupt enable register (0x5C000004)
 ******************************************************************************
 */
///@{
#define CMP_INT_w                                   ((uint32_t)0x5C000004)  /*!< Reg Absolute Address */
#define CMP_INT_h0                                  ((uint32_t)0x5C000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_INT_h1                                  ((uint32_t)0x5C000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_INT_b0                                  ((uint32_t)0x5C000004)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_INT_b1                                  ((uint32_t)0x5C000005)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_INT_b2                                  ((uint32_t)0x5C000006)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_INT_b3                                  ((uint32_t)0x5C000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_ANA  [register's definitions]
 *              Offset[0x0C]  CMP Analog comparator analog control register (0x5C00000C)
 ******************************************************************************
 */
///@{
#define CMP_ANA_w                                   ((uint32_t)0x5C00000C)  /*!< Reg Absolute Address */
#define CMP_ANA_h0                                  ((uint32_t)0x5C00000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_ANA_h1                                  ((uint32_t)0x5C00000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_ANA_b0                                  ((uint32_t)0x5C00000C)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_ANA_b1                                  ((uint32_t)0x5C00000D)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_ANA_b2                                  ((uint32_t)0x5C00000E)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_ANA_b3                                  ((uint32_t)0x5C00000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_CR0  [register's definitions]
 *              Offset[0x10]  CMP Analog comparator-0 control register (0x5C000010)
 ******************************************************************************
 */
///@{
#define CMP_CR0_w                                   ((uint32_t)0x5C000010)  /*!< Reg Absolute Address */
#define CMP_CR0_h0                                  ((uint32_t)0x5C000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_CR0_h1                                  ((uint32_t)0x5C000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_CR0_b0                                  ((uint32_t)0x5C000010)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_CR0_b1                                  ((uint32_t)0x5C000011)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_CR0_b2                                  ((uint32_t)0x5C000012)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_CR0_b3                                  ((uint32_t)0x5C000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_CR1  [register's definitions]
 *              Offset[0x14]  CMP Analog comparator-1 control register (0x5C000014)
 ******************************************************************************
 */
///@{
#define CMP_CR1_w                                   ((uint32_t)0x5C000014)  /*!< Reg Absolute Address */
#define CMP_CR1_h0                                  ((uint32_t)0x5C000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_CR1_h1                                  ((uint32_t)0x5C000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_CR1_b0                                  ((uint32_t)0x5C000014)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_CR1_b1                                  ((uint32_t)0x5C000015)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_CR1_b2                                  ((uint32_t)0x5C000016)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_CR1_b3                                  ((uint32_t)0x5C000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_CR2  [register's definitions]
 *              Offset[0x18]  CMP Analog comparator-2 control register (0x5C000018)
 ******************************************************************************
 */
///@{
#define CMP_CR2_w                                   ((uint32_t)0x5C000018)  /*!< Reg Absolute Address */
#define CMP_CR2_h0                                  ((uint32_t)0x5C000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_CR2_h1                                  ((uint32_t)0x5C00001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_CR2_b0                                  ((uint32_t)0x5C000018)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_CR2_b1                                  ((uint32_t)0x5C000019)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_CR2_b2                                  ((uint32_t)0x5C00001A)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_CR2_b3                                  ((uint32_t)0x5C00001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CMP_CR3  [register's definitions]
 *              Offset[0x1C]  CMP Analog comparator-3 control register (0x5C00001C)
 ******************************************************************************
 */
///@{
#define CMP_CR3_w                                   ((uint32_t)0x5C00001C)  /*!< Reg Absolute Address */
#define CMP_CR3_h0                                  ((uint32_t)0x5C00001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CMP_CR3_h1                                  ((uint32_t)0x5C00001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CMP_CR3_b0                                  ((uint32_t)0x5C00001C)  /*!< Reg Absolute Address of [Byte-0] */
#define CMP_CR3_b1                                  ((uint32_t)0x5C00001D)  /*!< Reg Absolute Address of [Byte-1] */
#define CMP_CR3_b2                                  ((uint32_t)0x5C00001E)  /*!< Reg Absolute Address of [Byte-2] */
#define CMP_CR3_b3                                  ((uint32_t)0x5C00001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      DAC (DAC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        DAC_STA  [register's definitions]
 *              Offset[0x00]  DAC status register (0x5C080000)
 ******************************************************************************
 */
///@{
#define DAC_STA_w                                   ((uint32_t)0x5C080000)  /*!< Reg Absolute Address */
#define DAC_STA_h0                                  ((uint32_t)0x5C080000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DAC_STA_h1                                  ((uint32_t)0x5C080002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DAC_STA_b0                                  ((uint32_t)0x5C080000)  /*!< Reg Absolute Address of [Byte-0] */
#define DAC_STA_b1                                  ((uint32_t)0x5C080001)  /*!< Reg Absolute Address of [Byte-1] */
#define DAC_STA_b2                                  ((uint32_t)0x5C080002)  /*!< Reg Absolute Address of [Byte-2] */
#define DAC_STA_b3                                  ((uint32_t)0x5C080003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DAC_INT  [register's definitions]
 *              Offset[0x04]  DAC interrupt enable register (0x5C080004)
 ******************************************************************************
 */
///@{
#define DAC_INT_w                                   ((uint32_t)0x5C080004)  /*!< Reg Absolute Address */
#define DAC_INT_h0                                  ((uint32_t)0x5C080004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DAC_INT_h1                                  ((uint32_t)0x5C080006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DAC_INT_b0                                  ((uint32_t)0x5C080004)  /*!< Reg Absolute Address of [Byte-0] */
#define DAC_INT_b1                                  ((uint32_t)0x5C080005)  /*!< Reg Absolute Address of [Byte-1] */
#define DAC_INT_b2                                  ((uint32_t)0x5C080006)  /*!< Reg Absolute Address of [Byte-2] */
#define DAC_INT_b3                                  ((uint32_t)0x5C080007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DAC_CR0  [register's definitions]
 *              Offset[0x10]  DAC control register 0 (0x5C080010)
 ******************************************************************************
 */
///@{
#define DAC_CR0_w                                   ((uint32_t)0x5C080010)  /*!< Reg Absolute Address */
#define DAC_CR0_h0                                  ((uint32_t)0x5C080010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DAC_CR0_h1                                  ((uint32_t)0x5C080012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DAC_CR0_b0                                  ((uint32_t)0x5C080010)  /*!< Reg Absolute Address of [Byte-0] */
#define DAC_CR0_b1                                  ((uint32_t)0x5C080011)  /*!< Reg Absolute Address of [Byte-1] */
#define DAC_CR0_b2                                  ((uint32_t)0x5C080012)  /*!< Reg Absolute Address of [Byte-2] */
#define DAC_CR0_b3                                  ((uint32_t)0x5C080013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DAC_DAT0  [register's definitions]
 *              Offset[0x20]  DAC conversion data register 0 (0x5C080020)
 ******************************************************************************
 */
///@{
#define DAC_DAT0_w                                  ((uint32_t)0x5C080020)  /*!< Reg Absolute Address */
#define DAC_DAT0_h0                                 ((uint32_t)0x5C080020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DAC_DAT0_h1                                 ((uint32_t)0x5C080022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DAC_DAT0_b0                                 ((uint32_t)0x5C080020)  /*!< Reg Absolute Address of [Byte-0] */
#define DAC_DAT0_b1                                 ((uint32_t)0x5C080021)  /*!< Reg Absolute Address of [Byte-1] */
#define DAC_DAT0_b2                                 ((uint32_t)0x5C080022)  /*!< Reg Absolute Address of [Byte-2] */
#define DAC_DAT0_b3                                 ((uint32_t)0x5C080023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        DAC_DOR0  [register's definitions]
 *              Offset[0x28]  DAC conversion output register 0 (0x5C080028)
 ******************************************************************************
 */
///@{
#define DAC_DOR0_w                                  ((uint32_t)0x5C080028)  /*!< Reg Absolute Address */
#define DAC_DOR0_h0                                 ((uint32_t)0x5C080028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define DAC_DOR0_h1                                 ((uint32_t)0x5C08002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define DAC_DOR0_b0                                 ((uint32_t)0x5C080028)  /*!< Reg Absolute Address of [Byte-0] */
#define DAC_DOR0_b1                                 ((uint32_t)0x5C080029)  /*!< Reg Absolute Address of [Byte-1] */
#define DAC_DOR0_b2                                 ((uint32_t)0x5C08002A)  /*!< Reg Absolute Address of [Byte-2] */
#define DAC_DOR0_b3                                 ((uint32_t)0x5C08002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      IWDT (IWDT Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        IWDT_STA  [register's definitions]
 *              Offset[0x00]  IWDT status register (0x5D000000)
 ******************************************************************************
 */
///@{
#define IWDT_STA_w                                  ((uint32_t)0x5D000000)  /*!< Reg Absolute Address */
#define IWDT_STA_h0                                 ((uint32_t)0x5D000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_STA_h1                                 ((uint32_t)0x5D000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_STA_b0                                 ((uint32_t)0x5D000000)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_STA_b1                                 ((uint32_t)0x5D000001)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_STA_b2                                 ((uint32_t)0x5D000002)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_STA_b3                                 ((uint32_t)0x5D000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        IWDT_INT  [register's definitions]
 *              Offset[0x04]  IWDT interrupt enable register (0x5D000004)
 ******************************************************************************
 */
///@{
#define IWDT_INT_w                                  ((uint32_t)0x5D000004)  /*!< Reg Absolute Address */
#define IWDT_INT_h0                                 ((uint32_t)0x5D000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_INT_h1                                 ((uint32_t)0x5D000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_INT_b0                                 ((uint32_t)0x5D000004)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_INT_b1                                 ((uint32_t)0x5D000005)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_INT_b2                                 ((uint32_t)0x5D000006)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_INT_b3                                 ((uint32_t)0x5D000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        IWDT_CLK  [register's definitions]
 *              Offset[0x08]  IWDT clock source register (0x5D000008)
 ******************************************************************************
 */
///@{
#define IWDT_CLK_w                                  ((uint32_t)0x5D000008)  /*!< Reg Absolute Address */
#define IWDT_CLK_h0                                 ((uint32_t)0x5D000008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_CLK_h1                                 ((uint32_t)0x5D00000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_CLK_b0                                 ((uint32_t)0x5D000008)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_CLK_b1                                 ((uint32_t)0x5D000009)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_CLK_b2                                 ((uint32_t)0x5D00000A)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_CLK_b3                                 ((uint32_t)0x5D00000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        IWDT_KEY  [register's definitions]
 *              Offset[0x0C]  IWDT write protected Key register (0x5D00000C)
 ******************************************************************************
 */
///@{
#define IWDT_KEY_w                                  ((uint32_t)0x5D00000C)  /*!< Reg Absolute Address */
#define IWDT_KEY_h0                                 ((uint32_t)0x5D00000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_KEY_h1                                 ((uint32_t)0x5D00000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_KEY_b0                                 ((uint32_t)0x5D00000C)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_KEY_b1                                 ((uint32_t)0x5D00000D)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_KEY_b2                                 ((uint32_t)0x5D00000E)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_KEY_b3                                 ((uint32_t)0x5D00000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        IWDT_CR0  [register's definitions]
 *              Offset[0x10]  IWDT control register 0 (0x5D000010)
 ******************************************************************************
 */
///@{
#define IWDT_CR0_w                                  ((uint32_t)0x5D000010)  /*!< Reg Absolute Address */
#define IWDT_CR0_h0                                 ((uint32_t)0x5D000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_CR0_h1                                 ((uint32_t)0x5D000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_CR0_b0                                 ((uint32_t)0x5D000010)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_CR0_b1                                 ((uint32_t)0x5D000011)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_CR0_b2                                 ((uint32_t)0x5D000012)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_CR0_b3                                 ((uint32_t)0x5D000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        IWDT_CNT  [register's definitions]
 *              Offset[0x18]  IWDT counter register (0x5D000018)
 ******************************************************************************
 */
///@{
#define IWDT_CNT_w                                  ((uint32_t)0x5D000018)  /*!< Reg Absolute Address */
#define IWDT_CNT_h0                                 ((uint32_t)0x5D000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define IWDT_CNT_h1                                 ((uint32_t)0x5D00001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define IWDT_CNT_b0                                 ((uint32_t)0x5D000018)  /*!< Reg Absolute Address of [Byte-0] */
#define IWDT_CNT_b1                                 ((uint32_t)0x5D000019)  /*!< Reg Absolute Address of [Byte-1] */
#define IWDT_CNT_b2                                 ((uint32_t)0x5D00001A)  /*!< Reg Absolute Address of [Byte-2] */
#define IWDT_CNT_b3                                 ((uint32_t)0x5D00001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      WWDT (WWDT Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        WWDT_STA  [register's definitions]
 *              Offset[0x00]  WWDT status register (0x5D010000)
 ******************************************************************************
 */
///@{
#define WWDT_STA_w                                  ((uint32_t)0x5D010000)  /*!< Reg Absolute Address */
#define WWDT_STA_h0                                 ((uint32_t)0x5D010000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_STA_h1                                 ((uint32_t)0x5D010002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_STA_b0                                 ((uint32_t)0x5D010000)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_STA_b1                                 ((uint32_t)0x5D010001)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_STA_b2                                 ((uint32_t)0x5D010002)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_STA_b3                                 ((uint32_t)0x5D010003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_INT  [register's definitions]
 *              Offset[0x04]  WWDT interrupt enable register (0x5D010004)
 ******************************************************************************
 */
///@{
#define WWDT_INT_w                                  ((uint32_t)0x5D010004)  /*!< Reg Absolute Address */
#define WWDT_INT_h0                                 ((uint32_t)0x5D010004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_INT_h1                                 ((uint32_t)0x5D010006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_INT_b0                                 ((uint32_t)0x5D010004)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_INT_b1                                 ((uint32_t)0x5D010005)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_INT_b2                                 ((uint32_t)0x5D010006)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_INT_b3                                 ((uint32_t)0x5D010007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_CLK  [register's definitions]
 *              Offset[0x08]  WWDT clock source register (0x5D010008)
 ******************************************************************************
 */
///@{
#define WWDT_CLK_w                                  ((uint32_t)0x5D010008)  /*!< Reg Absolute Address */
#define WWDT_CLK_h0                                 ((uint32_t)0x5D010008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_CLK_h1                                 ((uint32_t)0x5D01000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_CLK_b0                                 ((uint32_t)0x5D010008)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_CLK_b1                                 ((uint32_t)0x5D010009)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_CLK_b2                                 ((uint32_t)0x5D01000A)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_CLK_b3                                 ((uint32_t)0x5D01000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_KEY  [register's definitions]
 *              Offset[0x0C]  WWDT write protected Key register (0x5D01000C)
 ******************************************************************************
 */
///@{
#define WWDT_KEY_w                                  ((uint32_t)0x5D01000C)  /*!< Reg Absolute Address */
#define WWDT_KEY_h0                                 ((uint32_t)0x5D01000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_KEY_h1                                 ((uint32_t)0x5D01000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_KEY_b0                                 ((uint32_t)0x5D01000C)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_KEY_b1                                 ((uint32_t)0x5D01000D)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_KEY_b2                                 ((uint32_t)0x5D01000E)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_KEY_b3                                 ((uint32_t)0x5D01000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_CR0  [register's definitions]
 *              Offset[0x10]  WWDT control register 0 (0x5D010010)
 ******************************************************************************
 */
///@{
#define WWDT_CR0_w                                  ((uint32_t)0x5D010010)  /*!< Reg Absolute Address */
#define WWDT_CR0_h0                                 ((uint32_t)0x5D010010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_CR0_h1                                 ((uint32_t)0x5D010012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_CR0_b0                                 ((uint32_t)0x5D010010)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_CR0_b1                                 ((uint32_t)0x5D010011)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_CR0_b2                                 ((uint32_t)0x5D010012)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_CR0_b3                                 ((uint32_t)0x5D010013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_CNT  [register's definitions]
 *              Offset[0x18]  WWDT counter register (0x5D010018)
 ******************************************************************************
 */
///@{
#define WWDT_CNT_w                                  ((uint32_t)0x5D010018)  /*!< Reg Absolute Address */
#define WWDT_CNT_h0                                 ((uint32_t)0x5D010018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_CNT_h1                                 ((uint32_t)0x5D01001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_CNT_b0                                 ((uint32_t)0x5D010018)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_CNT_b1                                 ((uint32_t)0x5D010019)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_CNT_b2                                 ((uint32_t)0x5D01001A)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_CNT_b3                                 ((uint32_t)0x5D01001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_RLR  [register's definitions]
 *              Offset[0x1C]  WWDT reload register (0x5D01001C)
 ******************************************************************************
 */
///@{
#define WWDT_RLR_w                                  ((uint32_t)0x5D01001C)  /*!< Reg Absolute Address */
#define WWDT_RLR_h0                                 ((uint32_t)0x5D01001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_RLR_h1                                 ((uint32_t)0x5D01001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_RLR_b0                                 ((uint32_t)0x5D01001C)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_RLR_b1                                 ((uint32_t)0x5D01001D)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_RLR_b2                                 ((uint32_t)0x5D01001E)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_RLR_b3                                 ((uint32_t)0x5D01001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_WIN  [register's definitions]
 *              Offset[0x20]  WWDT window compare register (0x5D010020)
 ******************************************************************************
 */
///@{
#define WWDT_WIN_w                                  ((uint32_t)0x5D010020)  /*!< Reg Absolute Address */
#define WWDT_WIN_h0                                 ((uint32_t)0x5D010020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_WIN_h1                                 ((uint32_t)0x5D010022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_WIN_b0                                 ((uint32_t)0x5D010020)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_WIN_b1                                 ((uint32_t)0x5D010021)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_WIN_b2                                 ((uint32_t)0x5D010022)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_WIN_b3                                 ((uint32_t)0x5D010023)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        WWDT_WRN  [register's definitions]
 *              Offset[0x24]  WWDT warning compare register (0x5D010024)
 ******************************************************************************
 */
///@{
#define WWDT_WRN_w                                  ((uint32_t)0x5D010024)  /*!< Reg Absolute Address */
#define WWDT_WRN_h0                                 ((uint32_t)0x5D010024)  /*!< Reg Absolute Address of [HalfWord-0] */
#define WWDT_WRN_h1                                 ((uint32_t)0x5D010026)  /*!< Reg Absolute Address of [HalfWord-1] */
#define WWDT_WRN_b0                                 ((uint32_t)0x5D010024)  /*!< Reg Absolute Address of [Byte-0] */
#define WWDT_WRN_b1                                 ((uint32_t)0x5D010025)  /*!< Reg Absolute Address of [Byte-1] */
#define WWDT_WRN_b2                                 ((uint32_t)0x5D010026)  /*!< Reg Absolute Address of [Byte-2] */
#define WWDT_WRN_b3                                 ((uint32_t)0x5D010027)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      RTC (RTC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        RTC_STA  [register's definitions]
 *              Offset[0x00]  RTC status register (0x5D040000)
 ******************************************************************************
 */
///@{
#define RTC_STA_w                                   ((uint32_t)0x5D040000)  /*!< Reg Absolute Address */
#define RTC_STA_h0                                  ((uint32_t)0x5D040000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_STA_h1                                  ((uint32_t)0x5D040002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_STA_b0                                  ((uint32_t)0x5D040000)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_STA_b1                                  ((uint32_t)0x5D040001)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_STA_b2                                  ((uint32_t)0x5D040002)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_STA_b3                                  ((uint32_t)0x5D040003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_INT  [register's definitions]
 *              Offset[0x04]  RTC interrupt enable register (0x5D040004)
 ******************************************************************************
 */
///@{
#define RTC_INT_w                                   ((uint32_t)0x5D040004)  /*!< Reg Absolute Address */
#define RTC_INT_h0                                  ((uint32_t)0x5D040004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_INT_h1                                  ((uint32_t)0x5D040006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_INT_b0                                  ((uint32_t)0x5D040004)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_INT_b1                                  ((uint32_t)0x5D040005)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_INT_b2                                  ((uint32_t)0x5D040006)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_INT_b3                                  ((uint32_t)0x5D040007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_CLK  [register's definitions]
 *              Offset[0x08]  RTC clock source register (0x5D040008)
 ******************************************************************************
 */
///@{
#define RTC_CLK_w                                   ((uint32_t)0x5D040008)  /*!< Reg Absolute Address */
#define RTC_CLK_h0                                  ((uint32_t)0x5D040008)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_CLK_h1                                  ((uint32_t)0x5D04000A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_CLK_b0                                  ((uint32_t)0x5D040008)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_CLK_b1                                  ((uint32_t)0x5D040009)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_CLK_b2                                  ((uint32_t)0x5D04000A)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_CLK_b3                                  ((uint32_t)0x5D04000B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_KEY  [register's definitions]
 *              Offset[0x0C]  RTC write protected Key register (0x5D04000C)
 ******************************************************************************
 */
///@{
#define RTC_KEY_w                                   ((uint32_t)0x5D04000C)  /*!< Reg Absolute Address */
#define RTC_KEY_h0                                  ((uint32_t)0x5D04000C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_KEY_h1                                  ((uint32_t)0x5D04000E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_KEY_b0                                  ((uint32_t)0x5D04000C)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_KEY_b1                                  ((uint32_t)0x5D04000D)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_KEY_b2                                  ((uint32_t)0x5D04000E)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_KEY_b3                                  ((uint32_t)0x5D04000F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_CR0  [register's definitions]
 *              Offset[0x10]  RTC control register 0 (0x5D040010)
 ******************************************************************************
 */
///@{
#define RTC_CR0_w                                   ((uint32_t)0x5D040010)  /*!< Reg Absolute Address */
#define RTC_CR0_h0                                  ((uint32_t)0x5D040010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_CR0_h1                                  ((uint32_t)0x5D040012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_CR0_b0                                  ((uint32_t)0x5D040010)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_CR0_b1                                  ((uint32_t)0x5D040011)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_CR0_b2                                  ((uint32_t)0x5D040012)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_CR0_b3                                  ((uint32_t)0x5D040013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_CR1  [register's definitions]
 *              Offset[0x14]  RTC control register 1 (0x5D040014)
 ******************************************************************************
 */
///@{
#define RTC_CR1_w                                   ((uint32_t)0x5D040014)  /*!< Reg Absolute Address */
#define RTC_CR1_h0                                  ((uint32_t)0x5D040014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_CR1_h1                                  ((uint32_t)0x5D040016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_CR1_b0                                  ((uint32_t)0x5D040014)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_CR1_b1                                  ((uint32_t)0x5D040015)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_CR1_b2                                  ((uint32_t)0x5D040016)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_CR1_b3                                  ((uint32_t)0x5D040017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_RLR  [register's definitions]
 *              Offset[0x18]  RTC reload register (0x5D040018)
 ******************************************************************************
 */
///@{
#define RTC_RLR_w                                   ((uint32_t)0x5D040018)  /*!< Reg Absolute Address */
#define RTC_RLR_h0                                  ((uint32_t)0x5D040018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_RLR_h1                                  ((uint32_t)0x5D04001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_RLR_b0                                  ((uint32_t)0x5D040018)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_RLR_b1                                  ((uint32_t)0x5D040019)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_RLR_b2                                  ((uint32_t)0x5D04001A)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_RLR_b3                                  ((uint32_t)0x5D04001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_ALM  [register's definitions]
 *              Offset[0x1C]  RTC alarm compare register (0x5D04001C)
 ******************************************************************************
 */
///@{
#define RTC_ALM_w                                   ((uint32_t)0x5D04001C)  /*!< Reg Absolute Address */
#define RTC_ALM_h0                                  ((uint32_t)0x5D04001C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_ALM_h1                                  ((uint32_t)0x5D04001E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_ALM_b0                                  ((uint32_t)0x5D04001C)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_ALM_b1                                  ((uint32_t)0x5D04001D)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_ALM_b2                                  ((uint32_t)0x5D04001E)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_ALM_b3                                  ((uint32_t)0x5D04001F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        RTC_CAP  [register's definitions]
 *              Offset[0x20]  RTC capture register (0x5D040020)
 ******************************************************************************
 */
///@{
#define RTC_CAP_w                                   ((uint32_t)0x5D040020)  /*!< Reg Absolute Address */
#define RTC_CAP_h0                                  ((uint32_t)0x5D040020)  /*!< Reg Absolute Address of [HalfWord-0] */
#define RTC_CAP_h1                                  ((uint32_t)0x5D040022)  /*!< Reg Absolute Address of [HalfWord-1] */
#define RTC_CAP_b0                                  ((uint32_t)0x5D040020)  /*!< Reg Absolute Address of [Byte-0] */
#define RTC_CAP_b1                                  ((uint32_t)0x5D040021)  /*!< Reg Absolute Address of [Byte-1] */
#define RTC_CAP_b2                                  ((uint32_t)0x5D040022)  /*!< Reg Absolute Address of [Byte-2] */
#define RTC_CAP_b3                                  ((uint32_t)0x5D040023)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      APB (APB Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        APB_STA  [register's definitions]
 *              Offset[0x00]  APB status register (0x5F000000)
 ******************************************************************************
 */
///@{
#define APB_STA_w                                   ((uint32_t)0x5F000000)  /*!< Reg Absolute Address */
#define APB_STA_h0                                  ((uint32_t)0x5F000000)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_STA_h1                                  ((uint32_t)0x5F000002)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_STA_b0                                  ((uint32_t)0x5F000000)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_STA_b1                                  ((uint32_t)0x5F000001)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_STA_b2                                  ((uint32_t)0x5F000002)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_STA_b3                                  ((uint32_t)0x5F000003)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_INT  [register's definitions]
 *              Offset[0x04]  APB interrupt enable register (0x5F000004)
 ******************************************************************************
 */
///@{
#define APB_INT_w                                   ((uint32_t)0x5F000004)  /*!< Reg Absolute Address */
#define APB_INT_h0                                  ((uint32_t)0x5F000004)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_INT_h1                                  ((uint32_t)0x5F000006)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_INT_b0                                  ((uint32_t)0x5F000004)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_INT_b1                                  ((uint32_t)0x5F000005)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_INT_b2                                  ((uint32_t)0x5F000006)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_INT_b3                                  ((uint32_t)0x5F000007)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_CR0  [register's definitions]
 *              Offset[0x10]  APB global control register 0 (0x5F000010)
 ******************************************************************************
 */
///@{
#define APB_CR0_w                                   ((uint32_t)0x5F000010)  /*!< Reg Absolute Address */
#define APB_CR0_h0                                  ((uint32_t)0x5F000010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_CR0_h1                                  ((uint32_t)0x5F000012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_CR0_b0                                  ((uint32_t)0x5F000010)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_CR0_b1                                  ((uint32_t)0x5F000011)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_CR0_b2                                  ((uint32_t)0x5F000012)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_CR0_b3                                  ((uint32_t)0x5F000013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_CR1  [register's definitions]
 *              Offset[0x14]  APB global control register 1 (0x5F000014)
 ******************************************************************************
 */
///@{
#define APB_CR1_w                                   ((uint32_t)0x5F000014)  /*!< Reg Absolute Address */
#define APB_CR1_h0                                  ((uint32_t)0x5F000014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_CR1_h1                                  ((uint32_t)0x5F000016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_CR1_b0                                  ((uint32_t)0x5F000014)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_CR1_b1                                  ((uint32_t)0x5F000015)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_CR1_b2                                  ((uint32_t)0x5F000016)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_CR1_b3                                  ((uint32_t)0x5F000017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_CR2  [register's definitions]
 *              Offset[0x18]  APB global control register 2 (0x5F000018)
 ******************************************************************************
 */
///@{
#define APB_CR2_w                                   ((uint32_t)0x5F000018)  /*!< Reg Absolute Address */
#define APB_CR2_h0                                  ((uint32_t)0x5F000018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_CR2_h1                                  ((uint32_t)0x5F00001A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_CR2_b0                                  ((uint32_t)0x5F000018)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_CR2_b1                                  ((uint32_t)0x5F000019)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_CR2_b2                                  ((uint32_t)0x5F00001A)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_CR2_b3                                  ((uint32_t)0x5F00001B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_OBM10  [register's definitions]
 *              Offset[0x28]  APB OBM1 control register-0 (0x5F000028)
 ******************************************************************************
 */
///@{
#define APB_OBM10_w                                 ((uint32_t)0x5F000028)  /*!< Reg Absolute Address */
#define APB_OBM10_h0                                ((uint32_t)0x5F000028)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_OBM10_h1                                ((uint32_t)0x5F00002A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_OBM10_b0                                ((uint32_t)0x5F000028)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_OBM10_b1                                ((uint32_t)0x5F000029)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_OBM10_b2                                ((uint32_t)0x5F00002A)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_OBM10_b3                                ((uint32_t)0x5F00002B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        APB_OBM11  [register's definitions]
 *              Offset[0x2C]  APB OBM1 control register-1 (0x5F00002C)
 ******************************************************************************
 */
///@{
#define APB_OBM11_w                                 ((uint32_t)0x5F00002C)  /*!< Reg Absolute Address */
#define APB_OBM11_h0                                ((uint32_t)0x5F00002C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define APB_OBM11_h1                                ((uint32_t)0x5F00002E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define APB_OBM11_b0                                ((uint32_t)0x5F00002C)  /*!< Reg Absolute Address of [Byte-0] */
#define APB_OBM11_b1                                ((uint32_t)0x5F00002D)  /*!< Reg Absolute Address of [Byte-1] */
#define APB_OBM11_b2                                ((uint32_t)0x5F00002E)  /*!< Reg Absolute Address of [Byte-2] */
#define APB_OBM11_b3                                ((uint32_t)0x5F00002F)  /*!< Reg Absolute Address of [Byte-3] */
///@}

/*----------------------------------------------------------------------------*/
/* @module      CPU (CPU PPB SCS)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CPU_SYST_CSR  [register's definitions]
 *              Offset[0x10]  CPU SysTick Control and Status Register (0xE000E010)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CSR_w                              ((uint32_t)0xE000E010)  /*!< Reg Absolute Address */
#define CPU_SYST_CSR_h0                             ((uint32_t)0xE000E010)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SYST_CSR_h1                             ((uint32_t)0xE000E012)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SYST_CSR_b0                             ((uint32_t)0xE000E010)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SYST_CSR_b1                             ((uint32_t)0xE000E011)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SYST_CSR_b2                             ((uint32_t)0xE000E012)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SYST_CSR_b3                             ((uint32_t)0xE000E013)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_RVR  [register's definitions]
 *              Offset[0x14]  CPU SysTick Reload Value Register (0xE000E014)
 ******************************************************************************
 */
///@{
#define CPU_SYST_RVR_w                              ((uint32_t)0xE000E014)  /*!< Reg Absolute Address */
#define CPU_SYST_RVR_h0                             ((uint32_t)0xE000E014)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SYST_RVR_h1                             ((uint32_t)0xE000E016)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SYST_RVR_b0                             ((uint32_t)0xE000E014)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SYST_RVR_b1                             ((uint32_t)0xE000E015)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SYST_RVR_b2                             ((uint32_t)0xE000E016)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SYST_RVR_b3                             ((uint32_t)0xE000E017)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CVR  [register's definitions]
 *              Offset[0x18]  CPU SysTick Current Value Register (0xE000E018)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CVR_w                              ((uint32_t)0xE000E018)  /*!< Reg Absolute Address */
#define CPU_SYST_CVR_h0                             ((uint32_t)0xE000E018)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SYST_CVR_h1                             ((uint32_t)0xE000E01A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SYST_CVR_b0                             ((uint32_t)0xE000E018)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SYST_CVR_b1                             ((uint32_t)0xE000E019)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SYST_CVR_b2                             ((uint32_t)0xE000E01A)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SYST_CVR_b3                             ((uint32_t)0xE000E01B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CALIB  [register's definitions]
 *              Offset[0x1C]  CPU SysTick Calibration Value Register (0xE000E01C)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CALIB_w                            ((uint32_t)0xE000E01C)  /*!< Reg Absolute Address */
#define CPU_SYST_CALIB_h0                           ((uint32_t)0xE000E01C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SYST_CALIB_h1                           ((uint32_t)0xE000E01E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SYST_CALIB_b0                           ((uint32_t)0xE000E01C)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SYST_CALIB_b1                           ((uint32_t)0xE000E01D)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SYST_CALIB_b2                           ((uint32_t)0xE000E01E)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SYST_CALIB_b3                           ((uint32_t)0xE000E01F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_ISER  [register's definitions]
 *              Offset[0x100]  CPU Interrupt Set-enable Register (0xE000E100)
 ******************************************************************************
 */
///@{
#define CPU_ISER_w                                  ((uint32_t)0xE000E100)  /*!< Reg Absolute Address */
#define CPU_ISER_h0                                 ((uint32_t)0xE000E100)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_ISER_h1                                 ((uint32_t)0xE000E102)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_ISER_b0                                 ((uint32_t)0xE000E100)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_ISER_b1                                 ((uint32_t)0xE000E101)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_ISER_b2                                 ((uint32_t)0xE000E102)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_ISER_b3                                 ((uint32_t)0xE000E103)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_ICER  [register's definitions]
 *              Offset[0x180]  CPU Interrupt Clear-enable Register (0xE000E180)
 ******************************************************************************
 */
///@{
#define CPU_ICER_w                                  ((uint32_t)0xE000E180)  /*!< Reg Absolute Address */
#define CPU_ICER_h0                                 ((uint32_t)0xE000E180)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_ICER_h1                                 ((uint32_t)0xE000E182)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_ICER_b0                                 ((uint32_t)0xE000E180)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_ICER_b1                                 ((uint32_t)0xE000E181)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_ICER_b2                                 ((uint32_t)0xE000E182)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_ICER_b3                                 ((uint32_t)0xE000E183)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_ISPR  [register's definitions]
 *              Offset[0x200]  CPU Interrupt Set-pending Register (0xE000E200)
 ******************************************************************************
 */
///@{
#define CPU_ISPR_w                                  ((uint32_t)0xE000E200)  /*!< Reg Absolute Address */
#define CPU_ISPR_h0                                 ((uint32_t)0xE000E200)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_ISPR_h1                                 ((uint32_t)0xE000E202)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_ISPR_b0                                 ((uint32_t)0xE000E200)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_ISPR_b1                                 ((uint32_t)0xE000E201)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_ISPR_b2                                 ((uint32_t)0xE000E202)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_ISPR_b3                                 ((uint32_t)0xE000E203)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_ICPR  [register's definitions]
 *              Offset[0x280]  CPU Interrupt Clear-pending Register (0xE000E280)
 ******************************************************************************
 */
///@{
#define CPU_ICPR_w                                  ((uint32_t)0xE000E280)  /*!< Reg Absolute Address */
#define CPU_ICPR_h0                                 ((uint32_t)0xE000E280)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_ICPR_h1                                 ((uint32_t)0xE000E282)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_ICPR_b0                                 ((uint32_t)0xE000E280)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_ICPR_b1                                 ((uint32_t)0xE000E281)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_ICPR_b2                                 ((uint32_t)0xE000E282)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_ICPR_b3                                 ((uint32_t)0xE000E283)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR0  [register's definitions]
 *              Offset[0x400]  CPU Interrupt Priority Registers 0 (0xE000E400)
 ******************************************************************************
 */
///@{
#define CPU_IPR0_w                                  ((uint32_t)0xE000E400)  /*!< Reg Absolute Address */
#define CPU_IPR0_h0                                 ((uint32_t)0xE000E400)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR0_h1                                 ((uint32_t)0xE000E402)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR0_b0                                 ((uint32_t)0xE000E400)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR0_b1                                 ((uint32_t)0xE000E401)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR0_b2                                 ((uint32_t)0xE000E402)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR0_b3                                 ((uint32_t)0xE000E403)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR1  [register's definitions]
 *              Offset[0x404]  CPU Interrupt Priority Registers 1 (0xE000E404)
 ******************************************************************************
 */
///@{
#define CPU_IPR1_w                                  ((uint32_t)0xE000E404)  /*!< Reg Absolute Address */
#define CPU_IPR1_h0                                 ((uint32_t)0xE000E404)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR1_h1                                 ((uint32_t)0xE000E406)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR1_b0                                 ((uint32_t)0xE000E404)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR1_b1                                 ((uint32_t)0xE000E405)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR1_b2                                 ((uint32_t)0xE000E406)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR1_b3                                 ((uint32_t)0xE000E407)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR2  [register's definitions]
 *              Offset[0x408]  CPU Interrupt Priority Registers 2 (0xE000E408)
 ******************************************************************************
 */
///@{
#define CPU_IPR2_w                                  ((uint32_t)0xE000E408)  /*!< Reg Absolute Address */
#define CPU_IPR2_h0                                 ((uint32_t)0xE000E408)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR2_h1                                 ((uint32_t)0xE000E40A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR2_b0                                 ((uint32_t)0xE000E408)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR2_b1                                 ((uint32_t)0xE000E409)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR2_b2                                 ((uint32_t)0xE000E40A)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR2_b3                                 ((uint32_t)0xE000E40B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR3  [register's definitions]
 *              Offset[0x40C]  CPU Interrupt Priority Registers 3 (0xE000E40C)
 ******************************************************************************
 */
///@{
#define CPU_IPR3_w                                  ((uint32_t)0xE000E40C)  /*!< Reg Absolute Address */
#define CPU_IPR3_h0                                 ((uint32_t)0xE000E40C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR3_h1                                 ((uint32_t)0xE000E40E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR3_b0                                 ((uint32_t)0xE000E40C)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR3_b1                                 ((uint32_t)0xE000E40D)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR3_b2                                 ((uint32_t)0xE000E40E)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR3_b3                                 ((uint32_t)0xE000E40F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR4  [register's definitions]
 *              Offset[0x410]  CPU Interrupt Priority Registers 4 (0xE000E410)
 ******************************************************************************
 */
///@{
#define CPU_IPR4_w                                  ((uint32_t)0xE000E410)  /*!< Reg Absolute Address */
#define CPU_IPR4_h0                                 ((uint32_t)0xE000E410)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR4_h1                                 ((uint32_t)0xE000E412)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR4_b0                                 ((uint32_t)0xE000E410)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR4_b1                                 ((uint32_t)0xE000E411)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR4_b2                                 ((uint32_t)0xE000E412)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR4_b3                                 ((uint32_t)0xE000E413)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR5  [register's definitions]
 *              Offset[0x414]  CPU Interrupt Priority Registers 5 (0xE000E414)
 ******************************************************************************
 */
///@{
#define CPU_IPR5_w                                  ((uint32_t)0xE000E414)  /*!< Reg Absolute Address */
#define CPU_IPR5_h0                                 ((uint32_t)0xE000E414)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR5_h1                                 ((uint32_t)0xE000E416)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR5_b0                                 ((uint32_t)0xE000E414)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR5_b1                                 ((uint32_t)0xE000E415)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR5_b2                                 ((uint32_t)0xE000E416)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR5_b3                                 ((uint32_t)0xE000E417)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR6  [register's definitions]
 *              Offset[0x418]  CPU Interrupt Priority Registers 6 (0xE000E418)
 ******************************************************************************
 */
///@{
#define CPU_IPR6_w                                  ((uint32_t)0xE000E418)  /*!< Reg Absolute Address */
#define CPU_IPR6_h0                                 ((uint32_t)0xE000E418)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR6_h1                                 ((uint32_t)0xE000E41A)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR6_b0                                 ((uint32_t)0xE000E418)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR6_b1                                 ((uint32_t)0xE000E419)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR6_b2                                 ((uint32_t)0xE000E41A)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR6_b3                                 ((uint32_t)0xE000E41B)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR7  [register's definitions]
 *              Offset[0x41C]  CPU Interrupt Priority Registers 7 (0xE000E41C)
 ******************************************************************************
 */
///@{
#define CPU_IPR7_w                                  ((uint32_t)0xE000E41C)  /*!< Reg Absolute Address */
#define CPU_IPR7_h0                                 ((uint32_t)0xE000E41C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_IPR7_h1                                 ((uint32_t)0xE000E41E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_IPR7_b0                                 ((uint32_t)0xE000E41C)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_IPR7_b1                                 ((uint32_t)0xE000E41D)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_IPR7_b2                                 ((uint32_t)0xE000E41E)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_IPR7_b3                                 ((uint32_t)0xE000E41F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_CPUID  [register's definitions]
 *              Offset[0xD00]  CPU ID Register (0xE000ED00)
 ******************************************************************************
 */
///@{
#define CPU_CPUID_w                                 ((uint32_t)0xE000ED00)  /*!< Reg Absolute Address */
#define CPU_CPUID_h0                                ((uint32_t)0xE000ED00)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_CPUID_h1                                ((uint32_t)0xE000ED02)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_CPUID_b0                                ((uint32_t)0xE000ED00)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_CPUID_b1                                ((uint32_t)0xE000ED01)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_CPUID_b2                                ((uint32_t)0xE000ED02)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_CPUID_b3                                ((uint32_t)0xE000ED03)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_ICSR  [register's definitions]
 *              Offset[0xD04]  CPU Interrupt Control and State Register (0xE000ED04)
 ******************************************************************************
 */
///@{
#define CPU_ICSR_w                                  ((uint32_t)0xE000ED04)  /*!< Reg Absolute Address */
#define CPU_ICSR_h0                                 ((uint32_t)0xE000ED04)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_ICSR_h1                                 ((uint32_t)0xE000ED06)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_ICSR_b0                                 ((uint32_t)0xE000ED04)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_ICSR_b1                                 ((uint32_t)0xE000ED05)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_ICSR_b2                                 ((uint32_t)0xE000ED06)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_ICSR_b3                                 ((uint32_t)0xE000ED07)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_AIRCR  [register's definitions]
 *              Offset[0xD0C]  CPU Application Interrupt and Reset Control Register (0xE000ED0C)
 ******************************************************************************
 */
///@{
#define CPU_AIRCR_w                                 ((uint32_t)0xE000ED0C)  /*!< Reg Absolute Address */
#define CPU_AIRCR_h0                                ((uint32_t)0xE000ED0C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_AIRCR_h1                                ((uint32_t)0xE000ED0E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_AIRCR_b0                                ((uint32_t)0xE000ED0C)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_AIRCR_b1                                ((uint32_t)0xE000ED0D)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_AIRCR_b2                                ((uint32_t)0xE000ED0E)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_AIRCR_b3                                ((uint32_t)0xE000ED0F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SCR  [register's definitions]
 *              Offset[0xD10]  CPU System Control Register (0xE000ED10)
 ******************************************************************************
 */
///@{
#define CPU_SCR_w                                   ((uint32_t)0xE000ED10)  /*!< Reg Absolute Address */
#define CPU_SCR_h0                                  ((uint32_t)0xE000ED10)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SCR_h1                                  ((uint32_t)0xE000ED12)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SCR_b0                                  ((uint32_t)0xE000ED10)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SCR_b1                                  ((uint32_t)0xE000ED11)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SCR_b2                                  ((uint32_t)0xE000ED12)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SCR_b3                                  ((uint32_t)0xE000ED13)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_CCR  [register's definitions]
 *              Offset[0xD14]  CPU Configuration and Control Register (0xE000ED14)
 ******************************************************************************
 */
///@{
#define CPU_CCR_w                                   ((uint32_t)0xE000ED14)  /*!< Reg Absolute Address */
#define CPU_CCR_h0                                  ((uint32_t)0xE000ED14)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_CCR_h1                                  ((uint32_t)0xE000ED16)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_CCR_b0                                  ((uint32_t)0xE000ED14)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_CCR_b1                                  ((uint32_t)0xE000ED15)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_CCR_b2                                  ((uint32_t)0xE000ED16)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_CCR_b3                                  ((uint32_t)0xE000ED17)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR2  [register's definitions]
 *              Offset[0xD1C]  CPU System Handler Priority Register 2 (0xE000ED1C)
 ******************************************************************************
 */
///@{
#define CPU_SHPR2_w                                 ((uint32_t)0xE000ED1C)  /*!< Reg Absolute Address */
#define CPU_SHPR2_h0                                ((uint32_t)0xE000ED1C)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SHPR2_h1                                ((uint32_t)0xE000ED1E)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SHPR2_b0                                ((uint32_t)0xE000ED1C)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SHPR2_b1                                ((uint32_t)0xE000ED1D)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SHPR2_b2                                ((uint32_t)0xE000ED1E)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SHPR2_b3                                ((uint32_t)0xE000ED1F)  /*!< Reg Absolute Address of [Byte-3] */
///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR3  [register's definitions]
 *              Offset[0xD20]  CPU System Handler Priority Register 3 (0xE000ED20)
 ******************************************************************************
 */
///@{
#define CPU_SHPR3_w                                 ((uint32_t)0xE000ED20)  /*!< Reg Absolute Address */
#define CPU_SHPR3_h0                                ((uint32_t)0xE000ED20)  /*!< Reg Absolute Address of [HalfWord-0] */
#define CPU_SHPR3_h1                                ((uint32_t)0xE000ED22)  /*!< Reg Absolute Address of [HalfWord-1] */
#define CPU_SHPR3_b0                                ((uint32_t)0xE000ED20)  /*!< Reg Absolute Address of [Byte-0] */
#define CPU_SHPR3_b1                                ((uint32_t)0xE000ED21)  /*!< Reg Absolute Address of [Byte-1] */
#define CPU_SHPR3_b2                                ((uint32_t)0xE000ED22)  /*!< Reg Absolute Address of [Byte-2] */
#define CPU_SHPR3_b3                                ((uint32_t)0xE000ED23)  /*!< Reg Absolute Address of [Byte-3] */
///@}

#endif  // ___RegAddress_H

/*----------------------------------------------------------------------------*/
/*                     End of file MG32x02z__RegAddress.h                     */
/*----------------------------------------------------------------------------*/
