/**
 ******************************************************************************
 *
 * @file        MG32x02z_MEM.h
 *
 * @brief       MG32x02z MEM Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V3.0 (Register File Date : 2018_0509)
 * @date        2018/05/09 17:57 (H File Generated Date)
 * @author      HeadCodeGen V0.70
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_MEM_H
#define _MG32x02z_MEM_H
#define _MG32x02z_MEM_H_VER                         3.0     /*!< File Version */

#if !(MG32x02z_H_VER == MG32x02z_MEM_H_VER)
    #error "MG32x02z_MEM_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      MEM_Struct
 *              MEM  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  FBUSYF        :1;     //[0] Flash memory access busy flag.
                                        //0 = Normal (Not busy)
                                        //1 = Busy
            __IO uint8_t  EOPF          :1;     //[1] Flash memory end of processing flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  IAEF          :1;     //[4] Memory code execution illegal address error detection flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  WPEF          :1;     //[5] Flash memory write protect error detection flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  RPEF          :1;     //[6] Flash memory read protect error detection flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :6;     //[15..10] 
            __I  uint8_t  IAPSEF        :1;     //[16] IAP Flash memory size setting error flag.
                                        //0 = Normal (Not busy)
                                        //1 = ERR (Size over maximum value error)
            __I  uint8_t                :1;     //[17] 
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  MEM status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] Memory controller interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  EOP_IE        :1;     //[1] Flash memory end of processing interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  IAE_IE        :1;     //[4] Memory code execution illegal address error detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WPE_IE        :1;     //[5] Flash memory write protect error detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RPE_IE        :1;     //[6] Flash memory read protect error detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :6;     //[15..10] 
            __I  uint8_t                :3;     //[18..16] 
            __I  uint8_t                :1;     //[19] 
            __IO uint8_t  IAE_RE        :1;     //[20] Memory code execution illegal address detection reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WPE_RE        :1;     //[21] Flash memory write protect error detection reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  RPE_RE        :1;     //[22] Flash memory read protect error detection reset enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[23] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :1;     //[25] 
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  MEM interrupt enable register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] Reset key register
                                        //0 = Unprotected
                                        //1 = Protected
            __IO uint16_t KEY2          :16;    //[31..16] Reset key register-2
                                        //0 = Unprotected
                                        //1 = Protected
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  MEM write protected key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] Memory controller enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  HF_EN         :1;     //[1] Flash memory data access error HardFault enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  HOLD          :1;     //[2] CPU hold control under flash memory access
                                        //0 = Hold
                                        //1 = Normal
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  MDS           :4;     //[7..4] AP/IAP flash memory access mode select.
                                        //0x0 = No (No Operation)
                                        //0x1 = Write (Write AP/IAP/ISPD Flash)
                                        //0x2 = Erase (Erase a page of AP/IAP/ISPD Flash)
                                        //0x3 = Reserved
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  FWAIT         :2;     //[13..12] Flash memory read access wait state selection
                                        //0x0 = Zero : Zero wait state if  25 MHz > CK_AHB
                                        //0x1 = One : One wait state if 50MHz >CK_AHB> 25 MHz
                                        //0x3 = Two : Two wait state if 75MHz >CK_AHB> 50 MHz
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  BOOT_MS       :2;     //[17..16] System reset memory select and memory is mapped at 0x0000 0000
                                        //0x0 = Application Flash
                                        //0x1 = Boot Flash
                                        //0x2 = Embedded SRAM
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  HSP_EN        :1;     //[20] Flash memory read high speed mode enable during reset
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IAP_AEN       :1;     //[21] IAP memory size MEM_IAP_SIZE register access enable
                                        //0 = Disable : Register access lock
                                        //1 = Enable
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  MEM control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  AP_WEN        :1;     //[0] Flash AP memory write enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IAP_WEN       :1;     //[1] Flash IAP memory write enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ISPD_WEN      :1;     //[2] Flash ISP data memory write enable for ISP program
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ISPD_REN      :1;     //[3] Flash ISP data memory read enable for ISP program
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IAP_EXEC      :1;     //[4] Flash IAP data memory code execution function enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  ISP_WEN       :1;     //[8] Flash ISP Boot memory write enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ISP_REN       :1;     //[9] Flash ISP Boot memory read enable for AP program
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[10] 
            __IO uint8_t  OB_WEN        :1;     //[11] Flash OB0 Option-Byte memory write enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  MEM control register 1 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x18]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  SKEY          :8;     //[7..0] MEM sequential key register for AP/IAP/ISPD flash
            __I  uint8_t                :8;     //[15..8] 
            __IO uint16_t SKEY2         :16;    //[31..16] Reserved for internal using
        }MBIT;
    }SKEY;                              /*!< SKEY       ~ Offset[0x1C]  MEM Flash memory protected key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t FADR          :32;    //[31..0] Flash memory access address register
        }MBIT;
    }FADR;                              /*!< FADR       ~ Offset[0x20]  MEM Flash memory address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t FDAT          :32;    //[31..0] Flash memory access data register.
        }MBIT;
    }FDAT;                              /*!< FDAT       ~ Offset[0x24]  MEM Flash memory data register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :8;     //[7..0] 
            __IO uint8_t  IAP_SIZE      :8;     //[15..8] IAP memory size select
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }IAPSZ;                             /*!< IAPSZ      ~ Offset[0x28]  MEM Flash memory IAP size register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  OB1_WEN       :1;     //[0] Flash OB1 Option-Byte memory write enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }MCR;                               /*!< MCR        ~ Offset[0x2C]  MEM manufacturer control register */

} MEM_Struct;

/**
 ******************************************************************************
 *
 * @name        MEM  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define MEM_Base                        ((uint32_t)0x4D000000)              /*!< Internal Memory Controller */
#define MEM                             ((MEM_Struct*) MEM_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        MEM  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        MEM_STA  [register's definitions]
 *              Offset[0x00]  MEM status register (0x4D000000)
 ******************************************************************************
 */
///@{
#define MEM_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_STA */
#define MEM_STA_IAPSEF_mask_w                       ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define MEM_STA_IAPSEF_mask_h1                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_STA_IAPSEF_mask_b2                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_STA_IAPSEF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_IAPSEF_normal_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_IAPSEF_normal_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_IAPSEF_err_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(1):ERR of 32bit */
#define MEM_STA_IAPSEF_err_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(1):ERR of 16bit */
#define MEM_STA_IAPSEF_err_b2                       ((uint8_t )0x01)        /*!< Bit Value =(1):ERR of 8bit */

#define MEM_STA_RPEF_mask_w                         ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define MEM_STA_RPEF_mask_h0                        ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define MEM_STA_RPEF_mask_b0                        ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define MEM_STA_RPEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_RPEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_RPEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_RPEF_happened_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Happened of 32bit */
#define MEM_STA_RPEF_happened_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Happened of 16bit */
#define MEM_STA_RPEF_happened_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Happened of 8bit */

#define MEM_STA_WPEF_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define MEM_STA_WPEF_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define MEM_STA_WPEF_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define MEM_STA_WPEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_WPEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_WPEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_WPEF_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define MEM_STA_WPEF_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define MEM_STA_WPEF_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define MEM_STA_IAEF_mask_w                         ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define MEM_STA_IAEF_mask_h0                        ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define MEM_STA_IAEF_mask_b0                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define MEM_STA_IAEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_IAEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_IAEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_IAEF_happened_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define MEM_STA_IAEF_happened_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define MEM_STA_IAEF_happened_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define MEM_STA_EOPF_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define MEM_STA_EOPF_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define MEM_STA_EOPF_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define MEM_STA_EOPF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_EOPF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_EOPF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_EOPF_happened_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define MEM_STA_EOPF_happened_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define MEM_STA_EOPF_happened_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define MEM_STA_FBUSYF_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define MEM_STA_FBUSYF_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_STA_FBUSYF_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_STA_FBUSYF_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define MEM_STA_FBUSYF_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define MEM_STA_FBUSYF_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define MEM_STA_FBUSYF_busy_w                       ((uint32_t)0x00000001)  /*!< Bit Value =(1):Busy of 32bit */
#define MEM_STA_FBUSYF_busy_h0                      ((uint16_t)0x0001)      /*!< Bit Value =(1):Busy of 16bit */
#define MEM_STA_FBUSYF_busy_b0                      ((uint8_t )0x01)        /*!< Bit Value =(1):Busy of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_INT  [register's definitions]
 *              Offset[0x04]  MEM interrupt enable register (0x4D000004)
 ******************************************************************************
 */
///@{
#define MEM_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_INT */
#define MEM_INT_RPE_RE_mask_w                       ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define MEM_INT_RPE_RE_mask_h1                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define MEM_INT_RPE_RE_mask_b2                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define MEM_INT_RPE_RE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_RPE_RE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_RPE_RE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_RPE_RE_enable_w                     ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_RPE_RE_enable_h1                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_RPE_RE_enable_b2                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_WPE_RE_mask_w                       ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define MEM_INT_WPE_RE_mask_h1                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define MEM_INT_WPE_RE_mask_b2                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define MEM_INT_WPE_RE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_WPE_RE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_WPE_RE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_WPE_RE_enable_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_WPE_RE_enable_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_WPE_RE_enable_b2                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_IAE_RE_mask_w                       ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define MEM_INT_IAE_RE_mask_h1                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define MEM_INT_IAE_RE_mask_b2                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define MEM_INT_IAE_RE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_IAE_RE_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_IAE_RE_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_IAE_RE_enable_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_IAE_RE_enable_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_IAE_RE_enable_b2                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_RPE_IE_mask_w                       ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define MEM_INT_RPE_IE_mask_h0                      ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define MEM_INT_RPE_IE_mask_b0                      ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define MEM_INT_RPE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_RPE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_RPE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_RPE_IE_enable_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_RPE_IE_enable_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_RPE_IE_enable_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_WPE_IE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define MEM_INT_WPE_IE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define MEM_INT_WPE_IE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define MEM_INT_WPE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_WPE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_WPE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_WPE_IE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_WPE_IE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_WPE_IE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_IAE_IE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define MEM_INT_IAE_IE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define MEM_INT_IAE_IE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define MEM_INT_IAE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_IAE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_IAE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_IAE_IE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_IAE_IE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_IAE_IE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_EOP_IE_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define MEM_INT_EOP_IE_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define MEM_INT_EOP_IE_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define MEM_INT_EOP_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_EOP_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_EOP_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_EOP_IE_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_EOP_IE_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_EOP_IE_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define MEM_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_KEY  [register's definitions]
 *              Offset[0x0C]  MEM write protected key register (0x4D00000C)
 ******************************************************************************
 */
///@{
#define MEM_KEY_default                             ((uint32_t)0x00010001)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_KEY */
#define MEM_KEY_KEY2_mask_w                         ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define MEM_KEY_KEY2_mask_h1                        ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define MEM_KEY_KEY2_unprotected_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define MEM_KEY_KEY2_unprotected_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define MEM_KEY_KEY2_unprotected_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define MEM_KEY_KEY2_protected_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Protected of 32bit */
#define MEM_KEY_KEY2_protected_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define MEM_KEY_KEY2_protected_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

#define MEM_KEY_KEY_mask_w                          ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define MEM_KEY_KEY_mask_h0                         ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define MEM_KEY_KEY_unprotected_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define MEM_KEY_KEY_unprotected_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define MEM_KEY_KEY_unprotected_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define MEM_KEY_KEY_protected_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define MEM_KEY_KEY_protected_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define MEM_KEY_KEY_protected_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_CR0  [register's definitions]
 *              Offset[0x10]  MEM control register 0 (0x4D000010)
 ******************************************************************************
 */
///@{
#define MEM_CR0_default                             ((uint32_t)0x00200002)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_CR0 */
#define MEM_CR0_IAP_AEN_mask_w                      ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define MEM_CR0_IAP_AEN_mask_h1                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define MEM_CR0_IAP_AEN_mask_b2                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define MEM_CR0_IAP_AEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR0_IAP_AEN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR0_IAP_AEN_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR0_IAP_AEN_enable_w                    ((uint32_t)0x00200000)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR0_IAP_AEN_enable_h1                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR0_IAP_AEN_enable_b2                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR0_HSP_EN_mask_w                       ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define MEM_CR0_HSP_EN_mask_h1                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define MEM_CR0_HSP_EN_mask_b2                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define MEM_CR0_HSP_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR0_HSP_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR0_HSP_EN_disable_b2                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR0_HSP_EN_enable_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR0_HSP_EN_enable_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR0_HSP_EN_enable_b2                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR0_BOOT_MS_mask_w                      ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define MEM_CR0_BOOT_MS_mask_h1                     ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define MEM_CR0_BOOT_MS_mask_b2                     ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define MEM_CR0_BOOT_MS_application_flash_w         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Application Flash of 32bit */
#define MEM_CR0_BOOT_MS_application_flash_h1        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Application Flash of 16bit */
#define MEM_CR0_BOOT_MS_application_flash_b2        ((uint8_t )0x00)        /*!< Bit Value =(0x0):Application Flash of 8bit */
#define MEM_CR0_BOOT_MS_boot_flash_w                ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):Boot Flash of 32bit */
#define MEM_CR0_BOOT_MS_boot_flash_h1               ((uint16_t)0x0001)      /*!< Bit Value =(0x1):Boot Flash of 16bit */
#define MEM_CR0_BOOT_MS_boot_flash_b2               ((uint8_t )0x01)        /*!< Bit Value =(0x1):Boot Flash of 8bit */
#define MEM_CR0_BOOT_MS_embedded_sram_w             ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):Embedded SRAM of 32bit */
#define MEM_CR0_BOOT_MS_embedded_sram_h1            ((uint16_t)0x0002)      /*!< Bit Value =(0x2):Embedded SRAM of 16bit */
#define MEM_CR0_BOOT_MS_embedded_sram_b2            ((uint8_t )0x02)        /*!< Bit Value =(0x2):Embedded SRAM of 8bit */

#define MEM_CR0_FWAIT_mask_w                        ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define MEM_CR0_FWAIT_mask_h0                       ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define MEM_CR0_FWAIT_mask_b1                       ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define MEM_CR0_FWAIT_zero_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Zero of 32bit */
#define MEM_CR0_FWAIT_zero_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Zero of 16bit */
#define MEM_CR0_FWAIT_zero_b1                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):Zero of 8bit */
#define MEM_CR0_FWAIT_one_w                         ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):One of 32bit */
#define MEM_CR0_FWAIT_one_h0                        ((uint16_t)0x1000)      /*!< Bit Value =(0x1):One of 16bit */
#define MEM_CR0_FWAIT_one_b1                        ((uint8_t )0x10)        /*!< Bit Value =(0x1):One of 8bit */
#define MEM_CR0_FWAIT_two_w                         ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Two of 32bit */
#define MEM_CR0_FWAIT_two_h0                        ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Two of 16bit */
#define MEM_CR0_FWAIT_two_b1                        ((uint8_t )0x30)        /*!< Bit Value =(0x3):Two of 8bit */

#define MEM_CR0_MDS_mask_w                          ((uint32_t)0x000000F0)  /*!< Bit Mask of 32bit */
#define MEM_CR0_MDS_mask_h0                         ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define MEM_CR0_MDS_mask_b0                         ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define MEM_CR0_MDS_no_w                            ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define MEM_CR0_MDS_no_h0                           ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define MEM_CR0_MDS_no_b0                           ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define MEM_CR0_MDS_write_w                         ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):Write of 32bit */
#define MEM_CR0_MDS_write_h0                        ((uint16_t)0x0010)      /*!< Bit Value =(0x1):Write of 16bit */
#define MEM_CR0_MDS_write_b0                        ((uint8_t )0x10)        /*!< Bit Value =(0x1):Write of 8bit */
#define MEM_CR0_MDS_erase_w                         ((uint32_t)0x00000020)  /*!< Bit Value =(0x2):Erase of 32bit */
#define MEM_CR0_MDS_erase_h0                        ((uint16_t)0x0020)      /*!< Bit Value =(0x2):Erase of 16bit */
#define MEM_CR0_MDS_erase_b0                        ((uint8_t )0x20)        /*!< Bit Value =(0x2):Erase of 8bit */

#define MEM_CR0_HOLD_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define MEM_CR0_HOLD_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define MEM_CR0_HOLD_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define MEM_CR0_HOLD_hold_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Hold of 32bit */
#define MEM_CR0_HOLD_hold_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Hold of 16bit */
#define MEM_CR0_HOLD_hold_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Hold of 8bit */
#define MEM_CR0_HOLD_normal_w                       ((uint32_t)0x00000004)  /*!< Bit Value =(1):Normal of 32bit */
#define MEM_CR0_HOLD_normal_h0                      ((uint16_t)0x0004)      /*!< Bit Value =(1):Normal of 16bit */
#define MEM_CR0_HOLD_normal_b0                      ((uint8_t )0x04)        /*!< Bit Value =(1):Normal of 8bit */

#define MEM_CR0_HF_EN_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define MEM_CR0_HF_EN_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define MEM_CR0_HF_EN_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define MEM_CR0_HF_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR0_HF_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR0_HF_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR0_HF_EN_enable_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR0_HF_EN_enable_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR0_HF_EN_enable_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define MEM_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_CR1  [register's definitions]
 *              Offset[0x14]  MEM control register 1 (0x4D000014)
 ******************************************************************************
 */
///@{
#define MEM_CR1_default                             ((uint32_t)0x00000010)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_CR1 */
#define MEM_CR1_OB_WEN_mask_w                       ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define MEM_CR1_OB_WEN_mask_h0                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define MEM_CR1_OB_WEN_mask_b1                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define MEM_CR1_OB_WEN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_OB_WEN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_OB_WEN_disable_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_OB_WEN_enable_w                     ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_OB_WEN_enable_h0                    ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_OB_WEN_enable_b1                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_ISP_REN_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define MEM_CR1_ISP_REN_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define MEM_CR1_ISP_REN_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define MEM_CR1_ISP_REN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_ISP_REN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_ISP_REN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_ISP_REN_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_ISP_REN_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_ISP_REN_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_ISP_WEN_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define MEM_CR1_ISP_WEN_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define MEM_CR1_ISP_WEN_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_CR1_ISP_WEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_ISP_WEN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_ISP_WEN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_ISP_WEN_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_ISP_WEN_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_ISP_WEN_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_IAP_EXEC_mask_w                     ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define MEM_CR1_IAP_EXEC_mask_h0                    ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define MEM_CR1_IAP_EXEC_mask_b0                    ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define MEM_CR1_IAP_EXEC_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_IAP_EXEC_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_IAP_EXEC_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_IAP_EXEC_enable_w                   ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_IAP_EXEC_enable_h0                  ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_IAP_EXEC_enable_b0                  ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_ISPD_REN_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define MEM_CR1_ISPD_REN_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define MEM_CR1_ISPD_REN_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define MEM_CR1_ISPD_REN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_ISPD_REN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_ISPD_REN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_ISPD_REN_enable_w                   ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_ISPD_REN_enable_h0                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_ISPD_REN_enable_b0                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_ISPD_WEN_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define MEM_CR1_ISPD_WEN_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define MEM_CR1_ISPD_WEN_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define MEM_CR1_ISPD_WEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_ISPD_WEN_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_ISPD_WEN_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_ISPD_WEN_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_ISPD_WEN_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_ISPD_WEN_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_IAP_WEN_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define MEM_CR1_IAP_WEN_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define MEM_CR1_IAP_WEN_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define MEM_CR1_IAP_WEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_IAP_WEN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_IAP_WEN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_IAP_WEN_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_IAP_WEN_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_IAP_WEN_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define MEM_CR1_AP_WEN_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define MEM_CR1_AP_WEN_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_CR1_AP_WEN_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_CR1_AP_WEN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_CR1_AP_WEN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_CR1_AP_WEN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_CR1_AP_WEN_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_CR1_AP_WEN_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_CR1_AP_WEN_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_SKEY  [register's definitions]
 *              Offset[0x1C]  MEM Flash memory protected key register (0x4D00001C)
 ******************************************************************************
 */
///@{
#define MEM_SKEY_default                            ((uint32_t)0x00000007)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_SKEY */
#define MEM_SKEY_SKEY2_mask_w                       ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define MEM_SKEY_SKEY2_mask_h1                      ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define MEM_SKEY_SKEY2_shift_w                      (16)                    /*!< Bit Shift of 32bit */
#define MEM_SKEY_SKEY2_shift_h1                     (0)                     /*!< Bit Shift of 16bit */
#define MEM_SKEY_SKEY2_shift_b2                     (0)                     /*!< Bit Shift of 8bit */

#define MEM_SKEY_SKEY_mask_w                        ((uint32_t)0x000000FF)  /*!< Bit Mask of 32bit */
#define MEM_SKEY_SKEY_mask_h0                       ((uint16_t)0x00FF)      /*!< Bit Mask of 16bit */
#define MEM_SKEY_SKEY_mask_b0                       ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define MEM_SKEY_SKEY_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define MEM_SKEY_SKEY_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define MEM_SKEY_SKEY_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_FADR  [register's definitions]
 *              Offset[0x20]  MEM Flash memory address register (0x4D000020)
 ******************************************************************************
 */
///@{
#define MEM_FADR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_FADR */
#define MEM_FADR_FADR_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define MEM_FADR_FADR_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define MEM_FADR_FADR_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define MEM_FADR_FADR_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_FDAT  [register's definitions]
 *              Offset[0x24]  MEM Flash memory data register (0x4D000024)
 ******************************************************************************
 */
///@{
#define MEM_FDAT_default                            ((uint32_t)0xFFFFFFFF)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_FDAT */
#define MEM_FDAT_FDAT_mask_w                        ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define MEM_FDAT_FDAT_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define MEM_FDAT_FDAT_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define MEM_FDAT_FDAT_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_IAPSZ  [register's definitions]
 *              Offset[0x28]  MEM Flash memory IAP size register (0x4D000028)
 ******************************************************************************
 */
///@{
#define MEM_IAPSZ_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_IAPSZ */
#define MEM_IAPSZ_IAP_SIZE_mask_w                   ((uint32_t)0x0000FF00)  /*!< Bit Mask of 32bit */
#define MEM_IAPSZ_IAP_SIZE_mask_h0                  ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define MEM_IAPSZ_IAP_SIZE_mask_b1                  ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */

///@}
/**
 ******************************************************************************
 * @name        MEM_MCR  [register's definitions]
 *              Offset[0x2C]  MEM manufacturer control register (0x4D00002C)
 ******************************************************************************
 */
///@{
#define MEM_MCR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of MEM_MCR */
#define MEM_MCR_OB1_WEN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define MEM_MCR_OB1_WEN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define MEM_MCR_OB1_WEN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define MEM_MCR_OB1_WEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define MEM_MCR_OB1_WEN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define MEM_MCR_OB1_WEN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define MEM_MCR_OB1_WEN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define MEM_MCR_OB1_WEN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define MEM_MCR_OB1_WEN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32x02z_MEM_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_MEM.h                         */
/*----------------------------------------------------------------------------*/
