/**
 ******************************************************************************
 *
 * @file        MG32x02z_ADC_MID.H
 *
 * @brief       This file provides firmware functions to manage the following 
 *              functionalities of the ADC peripheral:
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2018/02/12
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 @if HIDE 
 *Modify History: 
 *>>
 *--
 *--
 *>>
 *>>
 *
 @endif 
 ******************************************************************************
 */ 




#ifndef _MG32x02z_ADC_MID_H

/*!< _MG32x02z_TM_DRV_H */ 
#define _MG32x02z_ADC_MID_H

#include "MG32x02z.H"
#include "MG32x02z_Common_MID.H"
#include "MG32x02z__Common_DRV.H"
#include "MG32x02z_ADC_DRV.H"



/** 
 * @enum		MID_ADC_StateTypeDef
 * @brief		MID State structures definition 
 */        
typedef enum 
{ 
    MID_ADC_STATE_BUSY,     /*!< An internal process is running */ 
    MID_ADC_STATE_READY,    /*!< Peripheral Initialized and ready for use */
    MID_ADC_STATE_RESET,
    MID_ADC_PRESS_KEY,      /*!< A event thar press a key  */ 
} MID_ADC_StateTypeDef;


/** 
 * @enum		MID_ADC_CalibrationStateTypeDef
 * @brief		MID State structures definition 
 */        
typedef enum 
{ 
    MID_ADC_Calibrated,     /*!< An internal process is running */ 
    MID_ADC_UnCalibrate,    /*!< Peripheral Initialized and ready for use */
} MID_ADC_CalibrationStateTypeDef;


/*! @struct ADC_HandleTypeDef 
    @brief  ADC clock/resolution/Justified structure definition
*/ 
typedef struct 
{ 
    ADC_Struct          *Instance;      /*!< Register base address */

    ADC_InitTypeDef     Init;           /*!< ADC clock/resolution/Justified parameters */

    MID_LockTypeDef     Lock;           /*!< ADC locking object */
    
    uint16_t            State;          /*!< ADC communication state (bitmap of ADC states) */

    uint8_t             PressChannel;   /*!< Record press Key column */
    
    uint16_t            ADCData;        /*!< Record ADC conversion data */               

} ADC_HandleTypeDef;

/*! @struct ADC_WindowDetectTypeDef  
    @brief  ADC Window Detect Boundary and mode
*/ 
typedef struct 
{ 
    uint16_t                    WindowHighThreshold;    /*!< ADC Window High Threshold boundary 
                                                             This parameter can be a number between 
                                                             Min_Data = 0~4095 (Right-Justified). */
    
    uint16_t                    WindowLowThreshold;     /*!< ADC Window Low Threshold boundary
                                                             This parameter can be a number between 
                                                             Min_Data = 0~4095 (Right-Justified). */
    
    ADC_WindowDetectApplyDef    ApplyMode;              /*!< Window Detect apply range. 
                                                             This parameter can be: ADC_WINDSingle or ADC_WINDAll */
    
    ADC_ExtChannelDef           SingleChannel;          /*!< Window Detect apply single channels for single mode.
                                                             This parameter can be: ADC_ExtAIN0~ADC_ExtAIN15 */

} ADC_WindowDetectTypeDef;


/*! @struct ADC_ConversionDef  
    @brief  ADC conversion parameter
*/ 
typedef struct 
{ 
    ADC_ConversionTypeDef   ADCTypeMDS;         /*!< ADC conversion type (ADC_SingleMode/ADC_DifferentMode) */    
    
    ADC_ConversionModeDef   ADCConversioMDS;    /*!< ADC conversion mode. This parameter can be:
                                                     ADCMode/ADCContinueMode/Scan/ScanContinue/LoopMode */
    
    uint8_t                 ExtendSampling;     /*!< Extend ADC Sample and Hold time.
                                                     This parameter can be a number between 0~255 ADC clocks. */
    
    uint16_t                ScanChannelMSK;     /*!< Scan/Loop enable channels. */
    
    ADC_TriggerSourceDef    TriggerSrcSel;      /*!< Select ADC trigger event to start conversion. */
    
    uint8_t                 CalibrationState;   /*!< ADC calibrate state. ref @MID_ADC_CalibrationStateTypeDef */
    
    FunctionalState         ActivePGA;          /*!< Only extend Sample and Hold time with 6 ADC clocks. 
                                                     This parameter can be: ENABLE or Disable. */
    
    uint8_t                 PGAGain;            /*!< ADC PGA gain control. 
                                                     This parameter can be a number between 0~3 (x1~x4). */

    uint8_t                 PGAoffset;           /*!< ADC PGA offset control. 
                                                     This parameter can be a number between 0~63. */

} ADC_ConversionDef;





/**
 * @name    Function announce
 * @brief   Config ADC base parameter.e.g. Clock/Resolution/Justified	
 */ 
///@{
MID_StatusTypeDef MID_ADC_Init(ADC_HandleTypeDef *hadc);
MID_StatusTypeDef MID_ADC_DeInit(ADC_HandleTypeDef *hadc);
///@}

/**
 * @name    Function announce
 * @brief   Config Window Detect	
 */ 
///@{
MID_StatusTypeDef MID_ADC_WindowDetect_Init(ADC_HandleTypeDef *hadc, ADC_WindowDetectTypeDef *ADCWinDet);
MID_StatusTypeDef MID_ADC_WindowDetect_Start(ADC_HandleTypeDef *hadc);
MID_StatusTypeDef MID_ADC_WindowDetect_Stop(ADC_HandleTypeDef *hadc);
MID_StatusTypeDef MID_ADC_WindowDetectIT_Start(ADC_HandleTypeDef *hadc, uint32_t ADC_ITSrc);
MID_StatusTypeDef MID_ADC_WindowDetectIT_Stop(ADC_HandleTypeDef *hadc, uint32_t ADC_ITSrc);
///@}


/**
 * @name    Function announce
 * @brief   Config ADC conversion 	
 */ 
///@{
MID_StatusTypeDef MID_ADC_Conversion_Init(ADC_HandleTypeDef *hadc, ADC_ConversionDef *ADCConMOD);
///@}


#endif
