/**
 ******************************************************************************
 *
 * @file        LCDDEMO_KEY_API.H
 *
 * @brief       This file provides firmware functions to manage the following 
 *              functionalities of the ADC peripheral:
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2018/02/12
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2016 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 @if HIDE 
 *Modify History: 
 *>>
 *--
 *--
 *>>
 *>>
 *
 @endif 
 ******************************************************************************
 */ 




#ifndef _LCDDEMO_KEY_API_H

/*!< _LCDDEMO_KEY_API_H */ 
#define _LCDDEMO_KEY_API_H

#include "MG32x02z_ADC_MID.H"



/** 
 * @enum		ADC_AnalyzKey
 * @brief		Analysis ADC Key matrix 
 */        
typedef enum
{
    SKey1,      /*!< Serial Key1 */
    SKey2,      /*!< Serial Key2 */
    SKey3,      /*!< Serial Key3 */
    SKey4,      /*!< Serial Key4 */
    SKey5,      /*!< Serial Key5 */
    SKey6,      /*!< Serial Key6 */
    
    SKey7,      /*!< Serial Key7 */
    SKey8,      /*!< Serial Key8 */
    SKey9,      /*!< Serial Key9 */
    SKey10,     /*!< Serial Key10 */
    SKey11,     /*!< Serial Key11 */
    SKey12,     /*!< Serial Key12 */
    
    PKey1,      /*!< Parelle Key1 */
    PKey2,      /*!< Parelle Key2 */
    PKey3,      /*!< Parelle Key3 */
    PKey4,      /*!< Parelle Key4 */
    PKey5,      /*!< Parelle Key5 */
    PKey6,      /*!< Parelle Key6 */
    
    NoPressKey, /*!< Did not press any button */
} MatrixKeyDef;




/**
 * @name    Function announce
 * @brief   Config ADC base parameter.e.g. Clock/Resolution/Justified	
 */ 
///@{
void API_Key_Init(void);
MatrixKeyDef API_ReadKey(void);
///@}



#endif
