/*********************************************************************
*    Project: MGEQ1C064-DEMO
*			MGEQ1C064AD48 LQFP48 EV_V10 (TH249A)
*			CpuCLK=12MHz, SysCLK=12MHz
*    Description:
*    		Set IO mode. P5-Page 0 only,P6-Page 1 only,P7-Page 2 only
*    Note:
*
*    Creat time:
*    Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MGEQ1C064.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MGEQ1C064.H"
#include ".\include\API_Uart_BRGRL_MGEQ1C064.H"


/*************************************************
*Set SysClk (MAX.50MHz)
*Selection: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	33170000,36000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57


/*************************************************
*Function:     	void DelayXus(u16 xUs)
*Description:   	delay,unit:us
*Input:     		u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     	void DelayXms(u16 xMs)
*Description:    delay,unit:ms
*Input:     		u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   	void InitPort()
*Description:	Initialize IO Port
*Input:   
*Output:   		
*************************************************************************************/
void InitPort(void)
{

//	PORT_SetP5AInputOnly(BIT0|BIT1);				// Set P50,P51 as Analog-Input-Only 
//	PORT_SetP5OpenDrainPu(BIT0|BIT1);				// Set P50,P51 as OpenDrain with pull up resistance
//	PORT_SetP5OpenDrain(BIT0|BIT1);					// Set P50,P51 as OpenDrain
//	PORT_SetP5PushPull(BIT0|BIT1);					// Set P50,P51 as Push pull
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);				// Set P55,P56,P57 as Push Pull(LED)

//	PORT_SetP6AInputOnly(BIT0|BIT1);				// Set P60,P61 as Analog-Input-Only 
//	PORT_SetP6OpenDrainPu(BIT0|BIT1);				// Set P60,P61 as OpenDrain with pull up resistance
//	PORT_SetP6OpenDrain(BIT0|BIT1);					// Set P60,P61 as OpenDrain
	PORT_SetP6PushPull(BIT0|BIT1);					// Set P60,P61 as Push pull

//	PORT_SetP7AInputOnly(BIT0|BIT1);				// Set P70,P71 as Analog-Input-Only 
//	PORT_SetP7OpenDrainPu(BIT0|BIT1); 				// Set P70,P71 as OpenDrain with pull up resistance
//	PORT_SetP7OpenDrain(BIT0|BIT1);					// Set P70,P71 as OpenDrain
	PORT_SetP7PushPull(BIT0|BIT1);					// Set P70,P71 as Push pull
	
}


/***********************************************************************************
*Function:       void InitSystem(void)
*Description:    Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();

}



void main()
{
    InitSystem();
					
	LED_G_0=0;LED_R=0;LED_G_1=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;
	
    while(1)
    {
		// P5, Page 0 only
		SFR_SetPage(P5_Page);
		LED_G_0=0;
		DelayXms(500);
		LED_G_0=1;
		LED_R=0;
		DelayXms(500);
		LED_R=1;
		LED_G_1=0;
		DelayXms(500);
		LED_G_1=1;

		// P6, Page 1 only
		SFR_SetPage(P6_Page);
		P60=0;
		P61=0;
		DelayXus(100);
		P60=1;
		P61=1;
		DelayXus(100);
		SFR_SetPage(0);

		// P7, Page 2 only
		SFR_SetPage(P7_Page);
		P70=0;
		P71=0;
		DelayXus(100);
		P70=1;
		P71=1;
		DelayXus(100);
		SFR_SetPage(0);

    }
 }


