#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_WDT_DRV.h"
#include "MGEQ1C064_PW_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
WDT overflow Interrupt(WDTF) => WDTF_Flag
****************************************************************/
uint8_t WDTF_Flag;

/****************************************************************
 *  Delay function
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P57 used for LED_D6
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P57_PushPull);

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable WDT interrupt (WDTFIE) = Enable;
     *  2. Enable System interrupt (ESF) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_WDT_IT_Cmd(MW_ENABLE);
    __DRV_INT_SystemFlag_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  WDT Initialized
     *  1. Setting prescaler to div 256
     *  2. WDT can run under the power down mode(ILRCO)
     *  3. Enable WDT
     ****************************************************************/
    __DRV_WDT_SetPrescaler(WDT_PRESCALER_DIV_256);
    __DRV_WDT_NonStopped_Cmd(MW_ENABLE);
    __DRV_WDT_Cmd(MW_ENABLE);

    while (1)
    {
        if (WDTF_Flag)
        {
            __DRV_GPIO_WriteP5(P57, 1);
            __DRV_PW_PowerDown_Enable();
            WDTF_Flag = 0;
        }
        __DRV_GPIO_InversePinP5(P57);
        delay_ms(50);
    }
}

void SYSFlag_WDT_ISR() interrupt SYSFLAG_ISR_VECTOR
{
    // WDT Interrupt
    if ((PCON1 & WDTF) == WDTF)
    {
        WDTF_Flag = 1;
        __DRV_WDT_ClearFlag();
    }
}

